/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerInternal;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.PackageUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.accounts.AccountManagerService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AccountManagerBackupHelper {
    private static final String TAG = "AccountManagerBackupHelper";
    private static final long PENDING_RESTORE_TIMEOUT_MILLIS = 3600000L;
    private static final String TAG_PERMISSIONS = "permissions";
    private static final String TAG_PERMISSION = "permission";
    private static final String ATTR_ACCOUNT_SHA_256 = "account-sha-256";
    private static final String ATTR_PACKAGE = "package";
    private static final String ATTR_DIGEST = "digest";
    private final Object mLock = new Object();
    private final AccountManagerService mAccountManagerService;
    private final AccountManagerInternal mAccountManagerInternal;
    @GuardedBy(value={"mLock"})
    private List<PendingAppPermission> mRestorePendingAppPermissions;
    @GuardedBy(value={"mLock"})
    private RestorePackageMonitor mRestorePackageMonitor;
    @GuardedBy(value={"mLock"})
    private Runnable mRestoreCancelCommand;

    public AccountManagerBackupHelper(AccountManagerService accountManagerService, AccountManagerInternal accountManagerInternal) {
        this.mAccountManagerService = accountManagerService;
        this.mAccountManagerInternal = accountManagerInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] backupAccountAccessPermissions(int userId) {
        AccountManagerService.UserAccounts accounts = this.mAccountManagerService.getUserAccounts(userId);
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                List<Pair<String, Integer>> allAccountGrants = accounts.accountsDb.findAllAccountGrants();
                if (allAccountGrants.isEmpty()) {
                    return null;
                }
                try {
                    ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                    FastXmlSerializer serializer = new FastXmlSerializer();
                    serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.startTag(null, TAG_PERMISSIONS);
                    PackageManager packageManager = this.mAccountManagerService.mContext.getPackageManager();
                    for (Pair<String, Integer> grant : allAccountGrants) {
                        String accountName = (String)grant.first;
                        int uid = (Integer)grant.second;
                        String[] packageNames = packageManager.getPackagesForUid(uid);
                        if (packageNames == null) continue;
                        for (String packageName : packageNames) {
                            PackageInfo packageInfo;
                            try {
                                packageInfo = packageManager.getPackageInfoAsUser(packageName, 64, userId);
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                Slog.i(TAG, "Skipping backup of account access grant for non-existing package: " + packageName);
                                continue;
                            }
                            String digest = PackageUtils.computeSignaturesSha256Digest(packageInfo.signatures);
                            if (digest == null) continue;
                            serializer.startTag(null, TAG_PERMISSION);
                            serializer.attribute(null, ATTR_ACCOUNT_SHA_256, PackageUtils.computeSha256Digest(accountName.getBytes()));
                            serializer.attribute(null, ATTR_PACKAGE, packageName);
                            serializer.attribute(null, ATTR_DIGEST, digest);
                            serializer.endTag(null, TAG_PERMISSION);
                        }
                    }
                    serializer.endTag(null, TAG_PERMISSIONS);
                    serializer.endDocument();
                    serializer.flush();
                    return dataStream.toByteArray();
                }
                catch (IOException e) {
                    Log.e(TAG, "Error backing up account access grants", e);
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreAccountAccessPermissions(byte[] data, int userId) {
        try {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(dataStream, StandardCharsets.UTF_8.name());
            PackageManager packageManager = this.mAccountManagerService.mContext.getPackageManager();
            int permissionsOuterDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, permissionsOuterDepth)) {
                if (!TAG_PERMISSIONS.equals(parser.getName())) continue;
                int permissionOuterDepth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, permissionOuterDepth)) {
                    PendingAppPermission pendingAppPermission;
                    String digest;
                    String packageName;
                    if (!TAG_PERMISSION.equals(parser.getName())) continue;
                    String accountDigest = parser.getAttributeValue(null, ATTR_ACCOUNT_SHA_256);
                    if (TextUtils.isEmpty(accountDigest)) {
                        XmlUtils.skipCurrentTag(parser);
                    }
                    if (TextUtils.isEmpty(packageName = parser.getAttributeValue(null, ATTR_PACKAGE))) {
                        XmlUtils.skipCurrentTag(parser);
                    }
                    if (TextUtils.isEmpty(digest = parser.getAttributeValue(null, ATTR_DIGEST))) {
                        XmlUtils.skipCurrentTag(parser);
                    }
                    if ((pendingAppPermission = new PendingAppPermission(accountDigest, packageName, digest, userId)).apply(packageManager)) continue;
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mRestorePackageMonitor == null) {
                            this.mRestorePackageMonitor = new RestorePackageMonitor();
                            this.mRestorePackageMonitor.register(this.mAccountManagerService.mContext, this.mAccountManagerService.mHandler.getLooper(), true);
                        }
                        if (this.mRestorePendingAppPermissions == null) {
                            this.mRestorePendingAppPermissions = new ArrayList<PendingAppPermission>();
                        }
                        this.mRestorePendingAppPermissions.add(pendingAppPermission);
                    }
                }
            }
            this.mRestoreCancelCommand = new CancelRestoreCommand();
            this.mAccountManagerService.mHandler.postDelayed(this.mRestoreCancelCommand, 3600000L);
        }
        catch (IOException | XmlPullParserException e) {
            Log.e(TAG, "Error restoring app permissions", e);
        }
    }

    private final class CancelRestoreCommand
    implements Runnable {
        private CancelRestoreCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AccountManagerBackupHelper.this.mLock;
            synchronized (object) {
                AccountManagerBackupHelper.this.mRestorePendingAppPermissions = null;
                if (AccountManagerBackupHelper.this.mRestorePackageMonitor != null) {
                    AccountManagerBackupHelper.this.mRestorePackageMonitor.unregister();
                    AccountManagerBackupHelper.this.mRestorePackageMonitor = null;
                }
            }
        }
    }

    private final class RestorePackageMonitor
    extends PackageMonitor {
        private RestorePackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageAdded(String packageName, int uid) {
            Object object = AccountManagerBackupHelper.this.mLock;
            synchronized (object) {
                if (AccountManagerBackupHelper.this.mRestorePendingAppPermissions == null) {
                    return;
                }
                if (UserHandle.getUserId(uid) != 0) {
                    return;
                }
                int count = AccountManagerBackupHelper.this.mRestorePendingAppPermissions.size();
                for (int i = count - 1; i >= 0; --i) {
                    PendingAppPermission pendingAppPermission = (PendingAppPermission)AccountManagerBackupHelper.this.mRestorePendingAppPermissions.get(i);
                    if (!pendingAppPermission.packageName.equals(packageName) || !pendingAppPermission.apply(((AccountManagerBackupHelper)AccountManagerBackupHelper.this).mAccountManagerService.mContext.getPackageManager())) continue;
                    AccountManagerBackupHelper.this.mRestorePendingAppPermissions.remove(i);
                }
                if (AccountManagerBackupHelper.this.mRestorePendingAppPermissions.isEmpty() && AccountManagerBackupHelper.this.mRestoreCancelCommand != null) {
                    ((AccountManagerBackupHelper)AccountManagerBackupHelper.this).mAccountManagerService.mHandler.removeCallbacks(AccountManagerBackupHelper.this.mRestoreCancelCommand);
                    AccountManagerBackupHelper.this.mRestoreCancelCommand.run();
                    AccountManagerBackupHelper.this.mRestoreCancelCommand = null;
                }
            }
        }
    }

    private final class PendingAppPermission {
        private final String accountDigest;
        private final String packageName;
        private final String certDigest;
        private final int userId;

        public PendingAppPermission(String accountDigest, String packageName, String certDigest, int userId) {
            this.accountDigest = accountDigest;
            this.packageName = packageName;
            this.certDigest = certDigest;
            this.userId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(PackageManager packageManager) {
            PackageInfo packageInfo;
            Account account = null;
            AccountManagerService.UserAccounts accounts = AccountManagerBackupHelper.this.mAccountManagerService.getUserAccounts(this.userId);
            Object object = accounts.dbLock;
            synchronized (object) {
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    for (Account[] accountsPerType : accounts.accountCache.values()) {
                        for (Account accountPerType : accountsPerType) {
                            if (!this.accountDigest.equals(PackageUtils.computeSha256Digest(accountPerType.name.getBytes()))) continue;
                            account = accountPerType;
                            break;
                        }
                        if (account == null) continue;
                        break;
                    }
                }
            }
            if (account == null) {
                return false;
            }
            try {
                packageInfo = packageManager.getPackageInfoAsUser(this.packageName, 64, this.userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            String[] signaturesSha256Digests = PackageUtils.computeSignaturesSha256Digests(packageInfo.signatures);
            String signaturesSha256Digest = PackageUtils.computeSignaturesSha256Digest(signaturesSha256Digests);
            if (!(this.certDigest.equals(signaturesSha256Digest) || packageInfo.signatures.length > 1 && this.certDigest.equals(signaturesSha256Digests[0]))) {
                return false;
            }
            int uid = packageInfo.applicationInfo.uid;
            if (!AccountManagerBackupHelper.this.mAccountManagerInternal.hasAccountAccess(account, uid)) {
                AccountManagerBackupHelper.this.mAccountManagerService.grantAppPermission(account, "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", uid);
            }
            return true;
        }
    }
}

