/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.adb;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.AtomicFile;
import android.util.Base64;
import android.util.Slog;
import android.util.StatsLog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.dump.DumpUtils;
import com.android.server.FgThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AdbDebuggingManager {
    private static final String TAG = "AdbDebuggingManager";
    private static final boolean DEBUG = false;
    private static final String ADBD_SOCKET = "adbd";
    private static final String ADB_DIRECTORY = "misc/adb";
    private static final String ADB_KEYS_FILE = "adb_keys";
    private static final String ADB_TEMP_KEYS_FILE = "adb_temp_keys.xml";
    private static final int BUFFER_SIZE = 65536;
    private final Context mContext;
    private final Handler mHandler = new AdbDebuggingHandler(FgThread.get().getLooper());
    private AdbDebuggingThread mThread;
    private boolean mAdbEnabled = false;
    private String mFingerprints;
    private final List<String> mConnectedKeys;
    private String mConfirmComponent;
    private final File mTestUserKeyFile;

    public AdbDebuggingManager(Context context) {
        this.mContext = context;
        this.mTestUserKeyFile = null;
        this.mConnectedKeys = new ArrayList<String>(1);
    }

    protected AdbDebuggingManager(Context context, String confirmComponent, File testUserKeyFile) {
        this.mContext = context;
        this.mConfirmComponent = confirmComponent;
        this.mTestUserKeyFile = testUserKeyFile;
        this.mConnectedKeys = new ArrayList<String>();
    }

    private String getFingerprints(String key) {
        byte[] digest;
        MessageDigest digester;
        String hex = "0123456789ABCDEF";
        StringBuilder sb = new StringBuilder();
        if (key == null) {
            return "";
        }
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            Slog.e(TAG, "Error getting digester", ex);
            return "";
        }
        byte[] base64_data = key.split("\\s+")[0].getBytes();
        try {
            digest = digester.digest(Base64.decode(base64_data, 0));
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "error doing base64 decoding", e);
            return "";
        }
        for (int i = 0; i < digest.length; ++i) {
            sb.append(hex.charAt(digest[i] >> 4 & 0xF));
            sb.append(hex.charAt(digest[i] & 0xF));
            if (i >= digest.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void startConfirmation(String key, String fingerprints) {
        int currentUserId = ActivityManager.getCurrentUser();
        UserInfo userInfo = UserManager.get(this.mContext).getUserInfo(currentUserId);
        String componentString = userInfo.isAdmin() ? (this.mConfirmComponent != null ? this.mConfirmComponent : Resources.getSystem().getString(17039688)) : Resources.getSystem().getString(17039689);
        ComponentName componentName = ComponentName.unflattenFromString(componentString);
        if (this.startConfirmationActivity(componentName, userInfo.getUserHandle(), key, fingerprints) || this.startConfirmationService(componentName, userInfo.getUserHandle(), key, fingerprints)) {
            return;
        }
        Slog.e(TAG, "unable to start customAdbPublicKeyConfirmation[SecondaryUser]Component " + componentString + " as an Activity or a Service");
    }

    private boolean startConfirmationActivity(ComponentName componentName, UserHandle userHandle, String key, String fingerprints) {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        intent.addFlags(0x10000000);
        if (packageManager.resolveActivity(intent, 65536) != null) {
            try {
                this.mContext.startActivityAsUser(intent, userHandle);
                return true;
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start adb whitelist activity: " + componentName, e);
            }
        }
        return false;
    }

    private boolean startConfirmationService(ComponentName componentName, UserHandle userHandle, String key, String fingerprints) {
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        try {
            if (this.mContext.startServiceAsUser(intent, userHandle) != null) {
                return true;
            }
        }
        catch (SecurityException e) {
            Slog.e(TAG, "unable to start adb whitelist service: " + componentName, e);
        }
        return false;
    }

    private Intent createConfirmationIntent(ComponentName componentName, String key, String fingerprints) {
        Intent intent = new Intent();
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        intent.putExtra("key", key);
        intent.putExtra("fingerprints", fingerprints);
        return intent;
    }

    private File getAdbFile(String fileName) {
        File dataDir = Environment.getDataDirectory();
        File adbDir = new File(dataDir, ADB_DIRECTORY);
        if (!adbDir.exists()) {
            Slog.e(TAG, "ADB data directory does not exist");
            return null;
        }
        return new File(adbDir, fileName);
    }

    File getAdbTempKeysFile() {
        return this.getAdbFile(ADB_TEMP_KEYS_FILE);
    }

    File getUserKeyFile() {
        return this.mTestUserKeyFile == null ? this.getAdbFile(ADB_KEYS_FILE) : this.mTestUserKeyFile;
    }

    private void writeKey(String key) {
        try {
            File keyFile = this.getUserKeyFile();
            if (keyFile == null) {
                return;
            }
            FileOutputStream fo = new FileOutputStream(keyFile, true);
            fo.write(key.getBytes());
            fo.write(10);
            fo.close();
            FileUtils.setPermissions(keyFile.toString(), 416, -1, -1);
        }
        catch (IOException ex) {
            Slog.e(TAG, "Error writing key:" + ex);
        }
    }

    private void writeKeys(Iterable<String> keys) {
        block4: {
            AtomicFile atomicKeyFile = null;
            FileOutputStream fo = null;
            try {
                File keyFile = this.getUserKeyFile();
                if (keyFile == null) {
                    return;
                }
                atomicKeyFile = new AtomicFile(keyFile);
                fo = atomicKeyFile.startWrite();
                for (String key : keys) {
                    fo.write(key.getBytes());
                    fo.write(10);
                }
                atomicKeyFile.finishWrite(fo);
                FileUtils.setPermissions(keyFile.toString(), 416, -1, -1);
            }
            catch (IOException ex) {
                Slog.e(TAG, "Error writing keys: " + ex);
                if (atomicKeyFile == null) break block4;
                atomicKeyFile.failWrite(fo);
            }
        }
    }

    private void deleteKeyFile() {
        File keyFile = this.getUserKeyFile();
        if (keyFile != null) {
            keyFile.delete();
        }
    }

    public void setAdbEnabled(boolean enabled) {
        this.mHandler.sendEmptyMessage(enabled ? 1 : 2);
    }

    public void allowDebugging(boolean alwaysAllow, String publicKey) {
        Message msg = this.mHandler.obtainMessage(3);
        msg.arg1 = alwaysAllow ? 1 : 0;
        msg.obj = publicKey;
        this.mHandler.sendMessage(msg);
    }

    public void denyDebugging() {
        this.mHandler.sendEmptyMessage(4);
    }

    public void clearDebuggingKeys() {
        this.mHandler.sendEmptyMessage(6);
    }

    private void sendPersistKeyStoreMessage() {
        Message msg = this.mHandler.obtainMessage(8);
        this.mHandler.sendMessage(msg);
    }

    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("connected_to_adb", 0x10800000001L, this.mThread != null);
        DumpUtils.writeStringIfNotNull(dump, "last_key_received", 1138166333442L, this.mFingerprints);
        try {
            dump.write("user_keys", 1138166333443L, FileUtils.readTextFile(new File("/data/misc/adb/adb_keys"), 0, null));
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot read user keys", e);
        }
        try {
            dump.write("system_keys", 1138166333444L, FileUtils.readTextFile(new File("/adb_keys"), 0, null));
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot read system keys", e);
        }
        try {
            dump.write("keystore", 1138166333445L, FileUtils.readTextFile(this.getAdbTempKeysFile(), 0, null));
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot read keystore: ", e);
        }
        dump.end(token);
    }

    class AdbKeyStore {
        private Map<String, Long> mKeyMap;
        private Set<String> mSystemKeys;
        private File mKeyFile;
        private AtomicFile mAtomicKeyFile;
        private static final String XML_TAG_ADB_KEY = "adbKey";
        private static final String XML_ATTRIBUTE_KEY = "key";
        private static final String XML_ATTRIBUTE_LAST_CONNECTION = "lastConnection";
        private static final String SYSTEM_KEY_FILE = "/adb_keys";
        public static final long NO_PREVIOUS_CONNECTION = 0L;

        AdbKeyStore() {
            this.init();
        }

        AdbKeyStore(File keyFile) {
            this.mKeyFile = keyFile;
            this.init();
        }

        private void init() {
            this.initKeyFile();
            this.mKeyMap = this.getKeyMap();
            this.mSystemKeys = this.getSystemKeysFromFile(SYSTEM_KEY_FILE);
            this.addUserKeysToKeyStore();
        }

        private void initKeyFile() {
            if (this.mKeyFile == null) {
                this.mKeyFile = AdbDebuggingManager.this.getAdbTempKeysFile();
            }
            if (this.mKeyFile != null) {
                this.mAtomicKeyFile = new AtomicFile(this.mKeyFile);
            }
        }

        private Set<String> getSystemKeysFromFile(String fileName) {
            HashSet<String> systemKeys = new HashSet<String>();
            File systemKeyFile = new File(fileName);
            if (systemKeyFile.exists()) {
                try (BufferedReader in = new BufferedReader(new FileReader(systemKeyFile));){
                    String key;
                    while ((key = in.readLine()) != null) {
                        if ((key = key.trim()).length() <= 0) continue;
                        systemKeys.add(key);
                    }
                }
                catch (IOException e) {
                    Slog.e(AdbDebuggingManager.TAG, "Caught an exception reading " + fileName + ": " + e);
                }
            }
            return systemKeys;
        }

        public boolean isEmpty() {
            return this.mKeyMap.isEmpty();
        }

        public void updateKeyStore() {
            if (this.filterOutOldKeys()) {
                AdbDebuggingManager.this.sendPersistKeyStoreMessage();
            }
        }

        private Map<String, Long> getKeyMap() {
            HashMap<String, Long> keyMap = new HashMap<String, Long>();
            if (this.mAtomicKeyFile == null) {
                this.initKeyFile();
                if (this.mAtomicKeyFile == null) {
                    Slog.e(AdbDebuggingManager.TAG, "Unable to obtain the key file, " + this.mKeyFile + ", for reading");
                    return keyMap;
                }
            }
            if (!this.mAtomicKeyFile.exists()) {
                return keyMap;
            }
            try (FileInputStream keyStream = this.mAtomicKeyFile.openRead();){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(keyStream, StandardCharsets.UTF_8.name());
                XmlUtils.beginDocument(parser, XML_TAG_ADB_KEY);
                while (parser.next() != 1) {
                    long connectionTime;
                    String tagName = parser.getName();
                    if (tagName == null) {
                        break;
                    }
                    if (!tagName.equals(XML_TAG_ADB_KEY)) {
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String key = parser.getAttributeValue(null, XML_ATTRIBUTE_KEY);
                    try {
                        connectionTime = Long.valueOf(parser.getAttributeValue(null, XML_ATTRIBUTE_LAST_CONNECTION));
                    }
                    catch (NumberFormatException e) {
                        Slog.e(AdbDebuggingManager.TAG, "Caught a NumberFormatException parsing the last connection time: " + e);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    keyMap.put(key, connectionTime);
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.e(AdbDebuggingManager.TAG, "Caught an exception parsing the XML key file: ", e);
            }
            return keyMap;
        }

        private void addUserKeysToKeyStore() {
            File userKeyFile = AdbDebuggingManager.this.getUserKeyFile();
            boolean mapUpdated = false;
            if (userKeyFile != null && userKeyFile.exists()) {
                try (BufferedReader in = new BufferedReader(new FileReader(userKeyFile));){
                    String key;
                    long time = System.currentTimeMillis();
                    while ((key = in.readLine()) != null) {
                        if (this.mKeyMap.containsKey(key)) continue;
                        this.mKeyMap.put(key, time);
                        mapUpdated = true;
                    }
                }
                catch (IOException e) {
                    Slog.e(AdbDebuggingManager.TAG, "Caught an exception reading " + userKeyFile + ": " + e);
                }
            }
            if (mapUpdated) {
                AdbDebuggingManager.this.sendPersistKeyStoreMessage();
            }
        }

        public void persistKeyStore() {
            this.filterOutOldKeys();
            if (this.mKeyMap.isEmpty()) {
                this.deleteKeyStore();
                return;
            }
            if (this.mAtomicKeyFile == null) {
                this.initKeyFile();
                if (this.mAtomicKeyFile == null) {
                    Slog.e(AdbDebuggingManager.TAG, "Unable to obtain the key file, " + this.mKeyFile + ", for writing");
                    return;
                }
            }
            FileOutputStream keyStream = null;
            try {
                FastXmlSerializer serializer = new FastXmlSerializer();
                keyStream = this.mAtomicKeyFile.startWrite();
                serializer.setOutput(keyStream, StandardCharsets.UTF_8.name());
                serializer.startDocument(null, true);
                for (Map.Entry<String, Long> keyEntry : this.mKeyMap.entrySet()) {
                    serializer.startTag(null, XML_TAG_ADB_KEY);
                    serializer.attribute(null, XML_ATTRIBUTE_KEY, keyEntry.getKey());
                    serializer.attribute(null, XML_ATTRIBUTE_LAST_CONNECTION, String.valueOf(keyEntry.getValue()));
                    serializer.endTag(null, XML_TAG_ADB_KEY);
                }
                serializer.endDocument();
                this.mAtomicKeyFile.finishWrite(keyStream);
            }
            catch (IOException e) {
                Slog.e(AdbDebuggingManager.TAG, "Caught an exception writing the key map: ", e);
                this.mAtomicKeyFile.failWrite(keyStream);
            }
        }

        private boolean filterOutOldKeys() {
            boolean keysDeleted = false;
            long allowedTime = this.getAllowedConnectionTime();
            long systemTime = System.currentTimeMillis();
            Iterator<Map.Entry<String, Long>> keyMapIterator = this.mKeyMap.entrySet().iterator();
            while (keyMapIterator.hasNext()) {
                Map.Entry<String, Long> keyEntry = keyMapIterator.next();
                long connectionTime = keyEntry.getValue();
                if (allowedTime == 0L || systemTime <= connectionTime + allowedTime) continue;
                keyMapIterator.remove();
                keysDeleted = true;
            }
            if (keysDeleted) {
                AdbDebuggingManager.this.writeKeys(this.mKeyMap.keySet());
            }
            return keysDeleted;
        }

        public long getNextExpirationTime() {
            long minExpiration = -1L;
            long allowedTime = this.getAllowedConnectionTime();
            if (allowedTime == 0L) {
                return minExpiration;
            }
            long systemTime = System.currentTimeMillis();
            for (Map.Entry<String, Long> keyEntry : this.mKeyMap.entrySet()) {
                long connectionTime = keyEntry.getValue();
                long keyExpiration = Math.max(0L, connectionTime + allowedTime - systemTime);
                if (minExpiration != -1L && keyExpiration >= minExpiration) continue;
                minExpiration = keyExpiration;
            }
            return minExpiration;
        }

        public void deleteKeyStore() {
            this.mKeyMap.clear();
            AdbDebuggingManager.this.deleteKeyFile();
            if (this.mAtomicKeyFile == null) {
                return;
            }
            this.mAtomicKeyFile.delete();
        }

        public long getLastConnectionTime(String key) {
            return this.mKeyMap.getOrDefault(key, 0L);
        }

        public void setLastConnectionTime(String key, long connectionTime) {
            this.setLastConnectionTime(key, connectionTime, false);
        }

        public void setLastConnectionTime(String key, long connectionTime, boolean force) {
            if (this.mKeyMap.containsKey(key) && this.mKeyMap.get(key) >= connectionTime && !force) {
                return;
            }
            if (this.mSystemKeys.contains(key)) {
                return;
            }
            if (!this.mKeyMap.containsKey(key)) {
                AdbDebuggingManager.this.writeKey(key);
            }
            this.mKeyMap.put(key, connectionTime);
        }

        public long getAllowedConnectionTime() {
            return Settings.Global.getLong(AdbDebuggingManager.this.mContext.getContentResolver(), "adb_allowed_connection_time", 604800000L);
        }

        public boolean isKeyAuthorized(String key) {
            if (this.mSystemKeys.contains(key)) {
                return true;
            }
            long lastConnectionTime = this.getLastConnectionTime(key);
            if (lastConnectionTime == 0L) {
                return false;
            }
            long allowedConnectionTime = this.getAllowedConnectionTime();
            return allowedConnectionTime == 0L || System.currentTimeMillis() < lastConnectionTime + allowedConnectionTime;
        }
    }

    class AdbDebuggingHandler
    extends Handler {
        static final long UPDATE_KEYSTORE_JOB_INTERVAL = 86400000L;
        static final long UPDATE_KEYSTORE_MIN_JOB_INTERVAL = 60000L;
        static final int MESSAGE_ADB_ENABLED = 1;
        static final int MESSAGE_ADB_DISABLED = 2;
        static final int MESSAGE_ADB_ALLOW = 3;
        static final int MESSAGE_ADB_DENY = 4;
        static final int MESSAGE_ADB_CONFIRM = 5;
        static final int MESSAGE_ADB_CLEAR = 6;
        static final int MESSAGE_ADB_DISCONNECT = 7;
        static final int MESSAGE_ADB_PERSIST_KEYSTORE = 8;
        static final int MESSAGE_ADB_UPDATE_KEYSTORE = 9;
        static final int MESSAGE_ADB_CONNECTED_KEY = 10;
        private AdbKeyStore mAdbKeyStore;
        private ContentObserver mAuthTimeObserver;

        AdbDebuggingHandler(Looper looper) {
            super(looper);
            this.mAuthTimeObserver = new ContentObserver(this){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    Slog.d(AdbDebuggingManager.TAG, "Received notification that uri " + uri + " was modified; rescheduling keystore job");
                    AdbDebuggingHandler.this.scheduleJobToUpdateAdbKeyStore();
                }
            };
        }

        AdbDebuggingHandler(Looper looper, AdbDebuggingThread thread, AdbKeyStore adbKeyStore) {
            super(looper);
            this.mAuthTimeObserver = new /* invalid duplicate definition of identical inner class */;
            AdbDebuggingManager.this.mThread = thread;
            this.mAdbKeyStore = adbKeyStore;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AdbDebuggingManager.this.mAdbEnabled) break;
                    this.registerForAuthTimeChanges();
                    AdbDebuggingManager.this.mAdbEnabled = true;
                    AdbDebuggingManager.this.mThread = new AdbDebuggingThread();
                    AdbDebuggingManager.this.mThread.start();
                    this.mAdbKeyStore = new AdbKeyStore();
                    this.mAdbKeyStore.updateKeyStore();
                    this.scheduleJobToUpdateAdbKeyStore();
                    break;
                }
                case 2: {
                    if (!AdbDebuggingManager.this.mAdbEnabled) break;
                    AdbDebuggingManager.this.mAdbEnabled = false;
                    if (AdbDebuggingManager.this.mThread != null) {
                        AdbDebuggingManager.this.mThread.stopListening();
                        AdbDebuggingManager.this.mThread = null;
                    }
                    if (!AdbDebuggingManager.this.mConnectedKeys.isEmpty()) {
                        for (String connectedKey : AdbDebuggingManager.this.mConnectedKeys) {
                            this.mAdbKeyStore.setLastConnectionTime(connectedKey, System.currentTimeMillis());
                        }
                        AdbDebuggingManager.this.sendPersistKeyStoreMessage();
                        AdbDebuggingManager.this.mConnectedKeys.clear();
                    }
                    this.scheduleJobToUpdateAdbKeyStore();
                    break;
                }
                case 3: {
                    boolean alwaysAllow;
                    String key = (String)msg.obj;
                    String fingerprints = AdbDebuggingManager.this.getFingerprints(key);
                    if (!fingerprints.equals(AdbDebuggingManager.this.mFingerprints)) {
                        Slog.e(AdbDebuggingManager.TAG, "Fingerprints do not match. Got " + fingerprints + ", expected " + AdbDebuggingManager.this.mFingerprints);
                        break;
                    }
                    boolean bl = alwaysAllow = msg.arg1 == 1;
                    if (AdbDebuggingManager.this.mThread == null) break;
                    AdbDebuggingManager.this.mThread.sendResponse("OK");
                    if (alwaysAllow) {
                        if (!AdbDebuggingManager.this.mConnectedKeys.contains(key)) {
                            AdbDebuggingManager.this.mConnectedKeys.add(key);
                        }
                        this.mAdbKeyStore.setLastConnectionTime(key, System.currentTimeMillis());
                        AdbDebuggingManager.this.sendPersistKeyStoreMessage();
                        this.scheduleJobToUpdateAdbKeyStore();
                    }
                    this.logAdbConnectionChanged(key, 2, alwaysAllow);
                    break;
                }
                case 4: {
                    if (AdbDebuggingManager.this.mThread == null) break;
                    AdbDebuggingManager.this.mThread.sendResponse("NO");
                    this.logAdbConnectionChanged(null, 3, false);
                    break;
                }
                case 5: {
                    String key = (String)msg.obj;
                    if ("trigger_restart_min_framework".equals(SystemProperties.get("vold.decrypt"))) {
                        Slog.d(AdbDebuggingManager.TAG, "Deferring adb confirmation until after vold decrypt");
                        if (AdbDebuggingManager.this.mThread == null) break;
                        AdbDebuggingManager.this.mThread.sendResponse("NO");
                        this.logAdbConnectionChanged(key, 6, false);
                        break;
                    }
                    String fingerprints = AdbDebuggingManager.this.getFingerprints(key);
                    if ("".equals(fingerprints)) {
                        if (AdbDebuggingManager.this.mThread == null) break;
                        AdbDebuggingManager.this.mThread.sendResponse("NO");
                        this.logAdbConnectionChanged(key, 5, false);
                        break;
                    }
                    this.logAdbConnectionChanged(key, 1, false);
                    AdbDebuggingManager.this.mFingerprints = fingerprints;
                    AdbDebuggingManager.this.startConfirmation(key, AdbDebuggingManager.this.mFingerprints);
                    break;
                }
                case 6: {
                    Slog.d(AdbDebuggingManager.TAG, "Received a request to clear the adb authorizations");
                    AdbDebuggingManager.this.mConnectedKeys.clear();
                    this.mAdbKeyStore.deleteKeyStore();
                    this.cancelJobToUpdateAdbKeyStore();
                    break;
                }
                case 7: {
                    String key = (String)msg.obj;
                    boolean alwaysAllow = false;
                    if (key != null && key.length() > 0) {
                        if (AdbDebuggingManager.this.mConnectedKeys.contains(key)) {
                            alwaysAllow = true;
                            this.mAdbKeyStore.setLastConnectionTime(key, System.currentTimeMillis());
                            AdbDebuggingManager.this.sendPersistKeyStoreMessage();
                            this.scheduleJobToUpdateAdbKeyStore();
                            AdbDebuggingManager.this.mConnectedKeys.remove(key);
                        }
                    } else {
                        Slog.w(AdbDebuggingManager.TAG, "Received a disconnected key message with an empty key");
                    }
                    this.logAdbConnectionChanged(key, 7, alwaysAllow);
                    break;
                }
                case 8: {
                    if (this.mAdbKeyStore == null) break;
                    this.mAdbKeyStore.persistKeyStore();
                    break;
                }
                case 9: {
                    if (!AdbDebuggingManager.this.mConnectedKeys.isEmpty()) {
                        for (String connectedKey : AdbDebuggingManager.this.mConnectedKeys) {
                            this.mAdbKeyStore.setLastConnectionTime(connectedKey, System.currentTimeMillis());
                        }
                        AdbDebuggingManager.this.sendPersistKeyStoreMessage();
                        this.scheduleJobToUpdateAdbKeyStore();
                        break;
                    }
                    if (this.mAdbKeyStore.isEmpty()) break;
                    this.mAdbKeyStore.updateKeyStore();
                    this.scheduleJobToUpdateAdbKeyStore();
                    break;
                }
                case 10: {
                    String key = (String)msg.obj;
                    if (key == null || key.length() == 0) {
                        Slog.w(AdbDebuggingManager.TAG, "Received a connected key message with an empty key");
                        break;
                    }
                    if (!AdbDebuggingManager.this.mConnectedKeys.contains(key)) {
                        AdbDebuggingManager.this.mConnectedKeys.add(key);
                    }
                    this.mAdbKeyStore.setLastConnectionTime(key, System.currentTimeMillis());
                    AdbDebuggingManager.this.sendPersistKeyStoreMessage();
                    this.scheduleJobToUpdateAdbKeyStore();
                    this.logAdbConnectionChanged(key, 4, true);
                    break;
                }
            }
        }

        void registerForAuthTimeChanges() {
            Uri uri = Settings.Global.getUriFor("adb_allowed_connection_time");
            AdbDebuggingManager.this.mContext.getContentResolver().registerContentObserver(uri, false, this.mAuthTimeObserver);
        }

        private void logAdbConnectionChanged(String key, int state, boolean alwaysAllow) {
            long lastConnectionTime = this.mAdbKeyStore.getLastConnectionTime(key);
            long authWindow = this.mAdbKeyStore.getAllowedConnectionTime();
            Slog.d(AdbDebuggingManager.TAG, "Logging key " + key + ", state = " + state + ", alwaysAllow = " + alwaysAllow + ", lastConnectionTime = " + lastConnectionTime + ", authWindow = " + authWindow);
            StatsLog.write(144, lastConnectionTime, authWindow, state, alwaysAllow);
        }

        @VisibleForTesting
        long scheduleJobToUpdateAdbKeyStore() {
            this.cancelJobToUpdateAdbKeyStore();
            long keyExpiration = this.mAdbKeyStore.getNextExpirationTime();
            if (keyExpiration == -1L) {
                return -1L;
            }
            long delay = keyExpiration == 0L ? 0L : Math.max(Math.min(86400000L, keyExpiration), 60000L);
            Message message = this.obtainMessage(9);
            this.sendMessageDelayed(message, delay);
            return delay;
        }

        private void cancelJobToUpdateAdbKeyStore() {
            this.removeMessages(9);
        }
    }

    class AdbDebuggingThread
    extends Thread {
        private boolean mStopped;
        private LocalSocket mSocket;
        private OutputStream mOutputStream;
        private InputStream mInputStream;

        AdbDebuggingThread() {
            super(AdbDebuggingManager.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AdbDebuggingThread adbDebuggingThread = this;
                synchronized (adbDebuggingThread) {
                    if (this.mStopped) {
                        return;
                    }
                    try {
                        this.openSocketLocked();
                    }
                    catch (Exception e) {
                        SystemClock.sleep(1000L);
                    }
                }
                try {
                    this.listenToSocket();
                    continue;
                }
                catch (Exception e) {
                    SystemClock.sleep(1000L);
                    continue;
                }
                break;
            }
        }

        private void openSocketLocked() throws IOException {
            try {
                LocalSocketAddress address = new LocalSocketAddress(AdbDebuggingManager.ADBD_SOCKET, LocalSocketAddress.Namespace.RESERVED);
                this.mInputStream = null;
                this.mSocket = new LocalSocket(3);
                this.mSocket.connect(address);
                this.mOutputStream = this.mSocket.getOutputStream();
                this.mInputStream = this.mSocket.getInputStream();
            }
            catch (IOException ioe) {
                Slog.e(AdbDebuggingManager.TAG, "Caught an exception opening the socket: " + ioe);
                this.closeSocketLocked();
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenToSocket() throws IOException {
            block13: {
                try {
                    byte[] buffer = new byte[65536];
                    while (true) {
                        Message msg;
                        String key;
                        int count;
                        if ((count = this.mInputStream.read(buffer)) < 2) {
                            Slog.w(AdbDebuggingManager.TAG, "Read failed with count " + count);
                            break block13;
                        }
                        if (buffer[0] == 80 && buffer[1] == 75) {
                            key = new String(Arrays.copyOfRange(buffer, 2, count));
                            Slog.d(AdbDebuggingManager.TAG, "Received public key: " + key);
                            msg = AdbDebuggingManager.this.mHandler.obtainMessage(5);
                            msg.obj = key;
                            AdbDebuggingManager.this.mHandler.sendMessage(msg);
                            continue;
                        }
                        if (buffer[0] == 68 && buffer[1] == 67) {
                            key = new String(Arrays.copyOfRange(buffer, 2, count));
                            Slog.d(AdbDebuggingManager.TAG, "Received disconnected message: " + key);
                            msg = AdbDebuggingManager.this.mHandler.obtainMessage(7);
                            msg.obj = key;
                            AdbDebuggingManager.this.mHandler.sendMessage(msg);
                            continue;
                        }
                        if (buffer[0] != 67 || buffer[1] != 75) break;
                        key = new String(Arrays.copyOfRange(buffer, 2, count));
                        Slog.d(AdbDebuggingManager.TAG, "Received connected key message: " + key);
                        msg = AdbDebuggingManager.this.mHandler.obtainMessage(10);
                        msg.obj = key;
                        AdbDebuggingManager.this.mHandler.sendMessage(msg);
                    }
                    Slog.e(AdbDebuggingManager.TAG, "Wrong message: " + new String(Arrays.copyOfRange(buffer, 0, 2)));
                }
                finally {
                    AdbDebuggingThread adbDebuggingThread = this;
                    synchronized (adbDebuggingThread) {
                        this.closeSocketLocked();
                    }
                }
            }
        }

        private void closeSocketLocked() {
            try {
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                    this.mOutputStream = null;
                }
            }
            catch (IOException e) {
                Slog.e(AdbDebuggingManager.TAG, "Failed closing output stream: " + e);
            }
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                    this.mSocket = null;
                }
            }
            catch (IOException ex) {
                Slog.e(AdbDebuggingManager.TAG, "Failed closing socket: " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopListening() {
            AdbDebuggingThread adbDebuggingThread = this;
            synchronized (adbDebuggingThread) {
                this.mStopped = true;
                this.closeSocketLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendResponse(String msg) {
            AdbDebuggingThread adbDebuggingThread = this;
            synchronized (adbDebuggingThread) {
                if (!this.mStopped && this.mOutputStream != null) {
                    try {
                        this.mOutputStream.write(msg.getBytes());
                    }
                    catch (IOException ex) {
                        Slog.e(AdbDebuggingManager.TAG, "Failed to write response:", ex);
                    }
                }
            }
        }
    }
}

