/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.adb;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.debug.AdbManagerInternal;
import android.debug.IAdbManager;
import android.debug.IAdbTransport;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.Settings;
import android.sysprop.AdbProperties;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.adb.AdbDebuggingManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;

public class AdbService
extends IAdbManager.Stub {
    private static final String TAG = "AdbService";
    private static final boolean DEBUG = false;
    private static final int MSG_ENABLE_ADB = 1;
    private static final int MSG_BOOT_COMPLETED = 2;
    private static final String USB_PERSISTENT_CONFIG_PROPERTY = "persist.sys.usb.config";
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AdbHandler mHandler;
    private final ArrayMap<IBinder, IAdbTransport> mTransports = new ArrayMap();
    private boolean mAdbEnabled;
    private AdbDebuggingManager mDebuggingManager;

    private AdbService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        boolean secureAdbEnabled = AdbProperties.secure().orElse(false);
        boolean dataEncrypted = "1".equals(SystemProperties.get("vold.decrypt"));
        if (secureAdbEnabled && !dataEncrypted) {
            this.mDebuggingManager = new AdbDebuggingManager(context);
        }
        this.mHandler = new AdbHandler(FgThread.get().getLooper());
        LocalServices.addService(AdbManagerInternal.class, new AdbManagerInternalImpl());
    }

    public void systemReady() {
        try {
            Settings.Global.putInt(this.mContentResolver, "adb_enabled", this.mAdbEnabled ? 1 : 0);
        }
        catch (SecurityException e) {
            Slog.d(TAG, "ADB_ENABLED is restricted.");
        }
    }

    public void bootCompleted() {
        this.mHandler.sendEmptyMessage(2);
    }

    @Override
    public void allowDebugging(boolean alwaysAllow, String publicKey) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEBUGGING", null);
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.allowDebugging(alwaysAllow, publicKey);
        }
    }

    @Override
    public void denyDebugging() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEBUGGING", null);
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.denyDebugging();
        }
    }

    @Override
    public void clearDebuggingKeys() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEBUGGING", null);
        if (this.mDebuggingManager == null) {
            throw new RuntimeException("Cannot clear ADB debugging keys, AdbDebuggingManager not enabled");
        }
        this.mDebuggingManager.clearDebuggingKeys();
    }

    private void setAdbEnabled(boolean enable) {
        if (enable == this.mAdbEnabled) {
            return;
        }
        this.mAdbEnabled = enable;
        for (IAdbTransport transport : this.mTransports.values()) {
            try {
                transport.onAdbEnabled(enable);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Unable to send onAdbEnabled to transport " + transport.toString());
            }
        }
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.setAdbEnabled(enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        long ident = Binder.clearCallingIdentity();
        try {
            ArraySet argsSet = new ArraySet();
            Collections.addAll(argsSet, args);
            boolean dumpAsProto = false;
            if (argsSet.contains("--proto")) {
                dumpAsProto = true;
            }
            if (argsSet.size() == 0 || argsSet.contains("-a") || dumpAsProto) {
                DualDumpOutputStream dump;
                if (dumpAsProto) {
                    dump = new DualDumpOutputStream(new ProtoOutputStream(fd));
                } else {
                    pw.println("ADB MANAGER STATE (dumpsys adb):");
                    dump = new DualDumpOutputStream(new IndentingPrintWriter((Writer)pw, "  "));
                }
                if (this.mDebuggingManager != null) {
                    this.mDebuggingManager.dump(dump, "debugging_manager", 0x10B00000001L);
                }
                dump.flush();
            } else {
                pw.println("Dump current ADB state");
                pw.println("  No commands available");
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private class AdbSettingsObserver
    extends ContentObserver {
        AdbSettingsObserver() {
            super(null);
        }

        @Override
        public void onChange(boolean selfChange) {
            boolean enable = Settings.Global.getInt(AdbService.this.mContentResolver, "adb_enabled", 0) > 0;
            AdbService.this.mHandler.sendMessage(1, enable);
        }
    }

    private final class AdbHandler
    extends Handler {
        AdbHandler(Looper looper) {
            super(looper);
            try {
                AdbService.this.mAdbEnabled = this.containsFunction(SystemProperties.get(AdbService.USB_PERSISTENT_CONFIG_PROPERTY, ""), "adb");
                AdbService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("adb_enabled"), false, new AdbSettingsObserver());
            }
            catch (Exception e) {
                Slog.e(AdbService.TAG, "Error initializing AdbHandler", e);
            }
        }

        private boolean containsFunction(String functions, String function) {
            int index = functions.indexOf(function);
            if (index < 0) {
                return false;
            }
            if (index > 0 && functions.charAt(index - 1) != ',') {
                return false;
            }
            int charAfter = index + function.length();
            return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
        }

        public void sendMessage(int what, boolean arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessage(m);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AdbService.this.setAdbEnabled(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    if (AdbService.this.mDebuggingManager == null) break;
                    AdbService.this.mDebuggingManager.setAdbEnabled(AdbService.this.mAdbEnabled);
                }
            }
        }
    }

    private class AdbManagerInternalImpl
    extends AdbManagerInternal {
        private AdbManagerInternalImpl() {
        }

        @Override
        public void registerTransport(IAdbTransport transport) {
            AdbService.this.mTransports.put(transport.asBinder(), transport);
        }

        @Override
        public void unregisterTransport(IAdbTransport transport) {
            AdbService.this.mTransports.remove(transport.asBinder());
        }

        @Override
        public boolean isAdbEnabled() {
            return AdbService.this.mAdbEnabled;
        }

        @Override
        public File getAdbKeysFile() {
            return AdbService.this.mDebuggingManager.getUserKeyFile();
        }

        @Override
        public File getAdbTempKeysFile() {
            return AdbService.this.mDebuggingManager.getAdbTempKeysFile();
        }
    }

    public static class Lifecycle
    extends SystemService {
        private AdbService mAdbService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mAdbService = new AdbService(this.getContext());
            this.publishBinderService("adb", this.mAdbService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mAdbService.systemReady();
            } else if (phase == 1000) {
                this.mAdbService.bootCompleted();
            }
        }
    }
}

