/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.util.SparseArray;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.UidRecord;

final class ActiveUids {
    private ActivityManagerService mService;
    private boolean mPostChangesToAtm;
    private final SparseArray<UidRecord> mActiveUids = new SparseArray();

    ActiveUids(ActivityManagerService service, boolean postChangesToAtm) {
        this.mService = service;
        this.mPostChangesToAtm = postChangesToAtm;
    }

    void put(int uid, UidRecord value) {
        this.mActiveUids.put(uid, value);
        if (this.mPostChangesToAtm) {
            this.mService.mAtmInternal.onUidActive(uid, value.getCurProcState());
        }
    }

    void remove(int uid) {
        this.mActiveUids.remove(uid);
        if (this.mPostChangesToAtm) {
            this.mService.mAtmInternal.onUidInactive(uid);
        }
    }

    void clear() {
        this.mActiveUids.clear();
        if (this.mPostChangesToAtm) {
            this.mService.mAtmInternal.onActiveUidsCleared();
        }
    }

    UidRecord get(int uid) {
        return this.mActiveUids.get(uid);
    }

    int size() {
        return this.mActiveUids.size();
    }

    UidRecord valueAt(int index) {
        return this.mActiveUids.valueAt(index);
    }

    int keyAt(int index) {
        return this.mActiveUids.keyAt(index);
    }

    int indexOfKey(int uid) {
        return this.mActiveUids.indexOfKey(uid);
    }
}

