/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.AppOpsManagerInternal;
import android.app.ApplicationErrorReport;
import android.app.BroadcastOptions;
import android.app.ContentProviderHolder;
import android.app.Dialog;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IAssistDataReceiver;
import android.app.IInstrumentationWatcher;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.ITaskStackListener;
import android.app.IUiAutomationConnection;
import android.app.IUidObserver;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProcessMemoryState;
import android.app.ProfilerInfo;
import android.app.WaitResult;
import android.app.WindowConfiguration;
import android.app.backup.IBackupManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.AutofillOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ActivityPresentationInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.ParceledListSlice;
import android.content.pm.PathPermission;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerInternal;
import android.net.NetworkPolicyManager;
import android.net.Uri;
import android.os.AppZygote;
import android.os.Binder;
import android.os.BinderProxy;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.FactoryTest;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdentifiersPolicyService;
import android.os.IPermissionController;
import android.os.IProcessInfoService;
import android.os.IProgressListener;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.RemoteCallback;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.sysprop.VoldProperties;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import android.util.TimingsTraceLog;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import android.view.IRecentsAnimationRunner;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.autofill.AutofillManagerInternal;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.DumpHeapActivity;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.ProcessMap;
import com.android.internal.app.SystemUserHomeActivity;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.content.PackageHelper;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.ByteTransferPipe;
import com.android.internal.os.IResultReceiver;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.MemInfoReader;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.QuadFunction;
import com.android.internal.util.function.TriFunction;
import com.android.server.AlarmManagerInternal;
import com.android.server.AttributeCache;
import com.android.server.DeviceIdleController;
import com.android.server.DisplayThread;
import com.android.server.IntentResolver;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.NetworkManagementInternal;
import com.android.server.PackageWatchdog;
import com.android.server.RescueParty;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import com.android.server.ThreadPriorityBooster;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.ActiveInstrumentation;
import com.android.server.am.ActiveServices;
import com.android.server.am.ActiveUids;
import com.android.server.am.ActivityManagerConstants;
import com.android.server.am.ActivityManagerShellCommand;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppErrors;
import com.android.server.am.AppWaitingForDebuggerDialog;
import com.android.server.am.BackupRecord;
import com.android.server.am.BatteryStatsService;
import com.android.server.am.BroadcastConstants;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.BroadcastStats;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.CoreSettingsObserver;
import com.android.server.am.DumpHeapProvider;
import com.android.server.am.EventLogTags;
import com.android.server.am.HostingRecord;
import com.android.server.am.InstrumentationReporter;
import com.android.server.am.LowMemDetector;
import com.android.server.am.MemoryStatUtil;
import com.android.server.am.NativeCrashListener;
import com.android.server.am.OomAdjProfiler;
import com.android.server.am.OomAdjuster;
import com.android.server.am.PendingIntentController;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.PendingTempWhitelists;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessMemInfo;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ProviderMap;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import com.android.server.am.SettingsToPropertiesMapper;
import com.android.server.am.StrictModeViolationDialog;
import com.android.server.am.UidRecord;
import com.android.server.am.UserController;
import com.android.server.am.UserState;
import com.android.server.appop.AppOpsService;
import com.android.server.contentcapture.ContentCaptureManagerInternal;
import com.android.server.firewall.IntentFirewall;
import com.android.server.job.JobSchedulerInternal;
import com.android.server.pm.Installer;
import com.android.server.uri.GrantUri;
import com.android.server.uri.UriGrantsManagerInternal;
import com.android.server.utils.PriorityDump;
import com.android.server.vr.VrManagerInternal;
import com.android.server.wm.ActivityMetricsLaunchObserver;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import libcore.util.EmptyArray;

public class ActivityManagerService
extends IActivityManager.Stub
implements Watchdog.Monitor,
BatteryStatsImpl.BatteryCallback {
    public static final int TOP_APP_PRIORITY_BOOST = -10;
    private static final String SYSTEM_PROPERTY_DEVICE_PROVISIONED = "persist.sys.device_provisioned";
    static final String TAG = "ActivityManager";
    static final String TAG_BACKUP = "ActivityManager";
    private static final String TAG_BROADCAST = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    static final String TAG_LRU = "ActivityManager";
    private static final String TAG_MU = "ActivityManager_MU";
    private static final String TAG_NETWORK = "ActivityManager_Network";
    static final String TAG_OOM_ADJ = "ActivityManager";
    private static final String TAG_POWER = "ActivityManager";
    static final String TAG_PROCESS_OBSERVERS = "ActivityManager";
    static final String TAG_PROCESSES = "ActivityManager";
    private static final String TAG_PROVIDER = "ActivityManager";
    static final String TAG_PSS = "ActivityManager";
    private static final String TAG_SERVICE = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    static final String TAG_UID_OBSERVERS = "ActivityManager";
    public static final String ACTION_TRIGGER_IDLE = "com.android.server.ACTION_TRIGGER_IDLE";
    static final long BATTERY_STATS_TIME = 1800000L;
    static final boolean MONITOR_CPU_USAGE = true;
    static final long MONITOR_CPU_MIN_TIME = 5000L;
    static final long MONITOR_CPU_MAX_TIME = 0xFFFFFFFL;
    static final boolean MONITOR_THREAD_CPU_USAGE = false;
    public static final int STOCK_PM_FLAGS = 1024;
    static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    public static final String ANR_TRACE_DIR = "/data/anr";
    private static final int MAX_RECEIVERS_ALLOWED_PER_APP = 1000;
    static final int PROC_START_TIMEOUT = 10000;
    static final int CONTENT_PROVIDER_PUBLISH_TIMEOUT = 10000;
    static final int KILL_APP_ZYGOTE_DELAY_MS = 5000;
    static final int CONTENT_PROVIDER_WAIT_TIMEOUT = 20000;
    static final int PROC_START_TIMEOUT_WITH_WRAPPER = 1200000;
    static final int BROADCAST_FG_TIMEOUT = 10000;
    static final int BROADCAST_BG_TIMEOUT = 60000;
    public static final int MY_PID = android.os.Process.myPid();
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final int DROPBOX_MAX_SIZE = 196608;
    static final int RESERVED_BYTES_PER_LOGCAT_LINE = 100;
    private static final int SLOW_UID_OBSERVER_THRESHOLD_MS = 20;
    static final int PERSISTENT_MASK = 9;
    private static final String INTENT_REMOTE_BUGREPORT_FINISHED = "com.android.internal.intent.action.REMOTE_BUGREPORT_FINISHED";
    static final boolean TRACK_PROCSTATS_ASSOCIATIONS = true;
    private static final long NETWORK_ACCESS_TIMEOUT_DEFAULT_MS = 200L;
    private static final int MINIMUM_MEMORY_GROWTH_THRESHOLD = 10000;
    private static final int BINDER_PROXY_HIGH_WATERMARK = 6000;
    private static final int BINDER_PROXY_LOW_WATERMARK = 5500;
    @VisibleForTesting
    static final int NETWORK_STATE_NO_CHANGE = 0;
    @VisibleForTesting
    static final int NETWORK_STATE_BLOCK = 1;
    @VisibleForTesting
    static final int NETWORK_STATE_UNBLOCK = 2;
    private static final int MAX_BUGREPORT_TITLE_SIZE = 50;
    private static final int NATIVE_DUMP_TIMEOUT_MS = 2000;
    private static final int JAVA_DUMP_MINIMUM_SIZE = 100;
    OomAdjuster mOomAdjuster;
    final LowMemDetector mLowMemDetector;
    SystemServiceManager mSystemServiceManager;
    private Installer mInstaller;
    final InstrumentationReporter mInstrumentationReporter = new InstrumentationReporter();
    final ArrayList<ActiveInstrumentation> mActiveInstrumentation = new ArrayList();
    public final IntentFirewall mIntentFirewall;
    public OomAdjProfiler mOomAdjProfiler = new OomAdjProfiler();
    boolean mUseFifoUiScheduling = false;
    boolean mEnableOffloadQueue;
    BroadcastQueue mFgBroadcastQueue;
    BroadcastQueue mBgBroadcastQueue;
    BroadcastQueue mOffloadBroadcastQueue;
    final BroadcastQueue[] mBroadcastQueues = new BroadcastQueue[3];
    BroadcastStats mLastBroadcastStats;
    BroadcastStats mCurBroadcastStats;
    String mDeviceOwnerName;
    final UserController mUserController;
    @VisibleForTesting
    public final PendingIntentController mPendingIntentController;
    final AppErrors mAppErrors;
    final PackageWatchdog mPackageWatchdog;
    @VisibleForTesting
    long mWaitForNetworkTimeoutMs;
    int mUidChangeDispatchCount;
    private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

        @Override
        public void dumpCritical(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            if (asProto) {
                return;
            }
            ActivityManagerService.this.doDump(fd, pw, new String[]{"activities"}, asProto);
            ActivityManagerService.this.doDump(fd, pw, new String[]{"service", "all-platform-critical"}, asProto);
        }

        @Override
        public void dumpNormal(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ActivityManagerService.this.doDump(fd, pw, new String[]{"-a", "--normal-priority"}, asProto);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ActivityManagerService.this.doDump(fd, pw, args, asProto);
        }
    };
    private static ThreadPriorityBooster sThreadPriorityBooster = new ThreadPriorityBooster(-2, 6);
    final ProcessList mProcessList = new ProcessList();
    final ProcessStatsService mProcessStats;
    int[] mBackgroundAppIdWhitelist = new int[]{1002};
    ArraySet<String> mBackgroundLaunchBroadcasts;
    ArrayMap<String, PackageAssociationInfo> mAllowedAssociations;
    final PidMap mPidsSelfLocked = new PidMap();
    final SparseArray<ImportanceToken> mImportantProcesses = new SparseArray();
    final ArrayList<ProcessRecord> mProcessesOnHold = new ArrayList();
    final ArrayList<ProcessRecord> mPersistentStartingProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mProcessesToGc = new ArrayList();
    final ArrayList<ProcessRecord> mPendingPssProcesses = new ArrayList();
    private final AtomicInteger mActivityStartingNesting = new AtomicInteger(0);
    private final ActivityMetricsLaunchObserver mActivityLaunchObserver = new ActivityMetricsLaunchObserver(){

        @Override
        public void onActivityLaunched(byte[] activity, int temperature) {
            if (ActivityManagerService.this.mPssDeferralTime > 0L) {
                Message msg = ActivityManagerService.this.mBgHandler.obtainMessage(2);
                ActivityManagerService.this.mBgHandler.sendMessageAtFrontOfQueue(msg);
            }
        }

        @Override
        public void onIntentStarted(Intent intent) {
        }

        @Override
        public void onIntentFailed() {
        }

        @Override
        public void onActivityLaunchCancelled(byte[] abortingActivity) {
        }

        @Override
        public void onActivityLaunchFinished(byte[] finalActivity) {
        }
    };
    private volatile long mPssDeferralTime = 0L;
    private static final String ACTIVITY_START_PSS_DEFER_CONFIG = "activity_start_pss_defer";
    private boolean mBinderTransactionTrackingEnabled = false;
    long mLastFullPssTime = SystemClock.uptimeMillis();
    boolean mFullPssPending = false;
    private final DeviceConfig.OnPropertiesChangedListener mPssDelayConfigListener = new DeviceConfig.OnPropertiesChangedListener(){

        @Override
        public void onPropertiesChanged(DeviceConfig.Properties properties) {
            ActivityManagerService.this.mPssDeferralTime = properties.getLong(ActivityManagerService.ACTIVITY_START_PSS_DEFER_CONFIG, 0L);
        }
    };
    static final boolean VALIDATE_UID_STATES = true;
    final ActiveUids mValidateUids = new ActiveUids(this, false);
    private final HashSet<Integer> mAlreadyLoggedViolatedStacks = new HashSet();
    private static final int MAX_DUP_SUPPRESSED_STACKS = 5000;
    final HashMap<IBinder, ReceiverList> mRegisteredReceivers = new HashMap();
    final IntentResolver<BroadcastFilter, BroadcastFilter> mReceiverResolver = new IntentResolver<BroadcastFilter, BroadcastFilter>(){

        @Override
        protected boolean allowFilterResult(BroadcastFilter filter, List<BroadcastFilter> dest) {
            IBinder target = filter.receiverList.receiver.asBinder();
            for (int i = dest.size() - 1; i >= 0; --i) {
                if (dest.get((int)i).receiverList.receiver.asBinder() != target) continue;
                return false;
            }
            return true;
        }

        @Override
        protected BroadcastFilter newResult(BroadcastFilter filter, int match, int userId) {
            if (userId == -1 || filter.owningUserId == -1 || userId == filter.owningUserId) {
                return (BroadcastFilter)super.newResult(filter, match, userId);
            }
            return null;
        }

        protected BroadcastFilter[] newArray(int size) {
            return new BroadcastFilter[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, BroadcastFilter filter) {
            return packageName.equals(filter.packageName);
        }
    };
    final SparseArray<ArrayMap<String, ArrayList<Intent>>> mStickyBroadcasts = new SparseArray();
    final ActiveServices mServices;
    final SparseArray<ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>>> mAssociations = new SparseArray();
    boolean mTrackingAssociations;
    @GuardedBy(value={"this"})
    final SparseArray<BackupRecord> mBackupTargets = new SparseArray();
    final ProviderMap mProviderMap;
    final ArrayList<ContentProviderRecord> mLaunchingProviders = new ArrayList();
    boolean mSystemProvidersInstalled;
    CoreSettingsObserver mCoreSettingsObserver;
    DevelopmentSettingsObserver mDevelopmentSettingsObserver;
    private static final ThreadLocal<Identity> sCallerIdentity = new ThreadLocal();
    final BatteryStatsService mBatteryStatsService;
    UsageStatsManagerInternal mUsageStatsService;
    DeviceIdleController.LocalService mLocalDeviceIdleController;
    int[] mDeviceIdleWhitelist = new int[0];
    int[] mDeviceIdleExceptIdleWhitelist = new int[0];
    int[] mDeviceIdleTempWhitelist = new int[0];
    final PendingTempWhitelists mPendingTempWhitelist = new PendingTempWhitelists(this);
    final AppOpsService mAppOpsService;
    ArrayMap<String, IBinder> mAppBindArgs;
    ArrayMap<String, IBinder> mIsolatedAppBindArgs;
    final StringBuilder mStringBuilder = new StringBuilder(256);
    volatile boolean mProcessesReady = false;
    volatile boolean mSystemReady = false;
    volatile boolean mOnBattery = false;
    final int mFactoryTest;
    volatile boolean mBooting = false;
    @GuardedBy(value={"this"})
    boolean mCallFinishBooting = false;
    @GuardedBy(value={"this"})
    boolean mBootAnimationComplete = false;
    final Context mContext;
    final Context mUiContext;
    long mLastPowerCheckUptime;
    PowerManagerInternal mLocalPowerManager;
    int mWakefulness = 1;
    boolean mAllowLowerMemLevel = false;
    int mLastMemoryLevel = 0;
    int mLastNumProcesses;
    long mLastIdleTime = SystemClock.uptimeMillis();
    long mLowRamTimeSinceLastIdle = 0L;
    long mLowRamStartTime = 0L;
    private String mCurResumedPackage = null;
    private int mCurResumedUid = -1;
    final ProcessMap<ArrayList<ProcessRecord>> mForegroundPackages = new ProcessMap();
    boolean mSafeMode;
    boolean mTestPssMode = false;
    String mDebugApp = null;
    boolean mWaitForDebugger = false;
    boolean mDebugTransient = false;
    String mOrigDebugApp = null;
    boolean mOrigWaitForDebugger = false;
    boolean mAlwaysFinishActivities = false;
    final ProfileData mProfileData = new ProfileData();
    private Map<String, String> mAppAgentMap = null;
    int mProfileType = 0;
    final ProcessMap<Pair<Long, String>> mMemWatchProcesses = new ProcessMap();
    String mMemWatchDumpProcName;
    String mMemWatchDumpFile;
    int mMemWatchDumpPid;
    int mMemWatchDumpUid;
    private boolean mMemWatchIsUserInitiated;
    String mTrackAllocationApp = null;
    String mNativeDebuggingApp = null;
    private final Injector mInjector;
    final RemoteCallbackList<IProcessObserver> mProcessObservers = new RemoteCallbackList();
    ProcessChangeItem[] mActiveProcessChanges = new ProcessChangeItem[5];
    final ArrayList<ProcessChangeItem> mPendingProcessChanges = new ArrayList();
    final ArrayList<ProcessChangeItem> mAvailProcessChanges = new ArrayList();
    final RemoteCallbackList<IUidObserver> mUidObservers = new RemoteCallbackList();
    UidRecord.ChangeItem[] mActiveUidChanges = new UidRecord.ChangeItem[5];
    final ArrayList<UidRecord.ChangeItem> mPendingUidChanges = new ArrayList();
    final ArrayList<UidRecord.ChangeItem> mAvailUidChanges = new ArrayList();
    OomAdjObserver mCurOomAdjObserver;
    int mCurOomAdjUid;
    final Thread mProcessCpuThread;
    final ProcessCpuTracker mProcessCpuTracker = new ProcessCpuTracker(false);
    final AtomicLong mLastCpuTime = new AtomicLong(0L);
    final AtomicBoolean mProcessCpuMutexFree = new AtomicBoolean(true);
    final CountDownLatch mProcessCpuInitLatch = new CountDownLatch(1);
    long mLastWriteTime = 0L;
    volatile boolean mBooted = false;
    int mBootPhase;
    @VisibleForTesting
    public WindowManagerService mWindowManager;
    @VisibleForTesting
    public ActivityTaskManagerService mActivityTaskManager;
    @VisibleForTesting
    public ActivityTaskManagerInternal mAtmInternal;
    @VisibleForTesting
    public UriGrantsManagerInternal mUgmInternal;
    final ActivityThread mSystemThread;
    static final int SHOW_ERROR_UI_MSG = 1;
    static final int SHOW_NOT_RESPONDING_UI_MSG = 2;
    static final int GC_BACKGROUND_PROCESSES_MSG = 5;
    static final int WAIT_FOR_DEBUGGER_UI_MSG = 6;
    static final int SERVICE_TIMEOUT_MSG = 12;
    static final int UPDATE_TIME_ZONE = 13;
    static final int PROC_START_TIMEOUT_MSG = 20;
    static final int KILL_APPLICATION_MSG = 22;
    static final int SHOW_STRICT_MODE_VIOLATION_UI_MSG = 26;
    static final int CHECK_EXCESSIVE_POWER_USE_MSG = 27;
    static final int CLEAR_DNS_CACHE_MSG = 28;
    static final int UPDATE_HTTP_PROXY_MSG = 29;
    static final int DISPATCH_PROCESSES_CHANGED_UI_MSG = 31;
    static final int DISPATCH_PROCESS_DIED_UI_MSG = 32;
    static final int REPORT_MEM_USAGE_MSG = 33;
    static final int UPDATE_TIME_PREFERENCE_MSG = 41;
    static final int NOTIFY_CLEARTEXT_NETWORK_MSG = 49;
    static final int POST_DUMP_HEAP_NOTIFICATION_MSG = 50;
    static final int DELETE_DUMPHEAP_MSG = 51;
    static final int DISPATCH_UIDS_CHANGED_UI_MSG = 53;
    static final int SHUTDOWN_UI_AUTOMATION_CONNECTION_MSG = 56;
    static final int CONTENT_PROVIDER_PUBLISH_TIMEOUT_MSG = 57;
    static final int IDLE_UIDS_MSG = 58;
    static final int HANDLE_TRUST_STORAGE_UPDATE_MSG = 63;
    static final int SERVICE_FOREGROUND_TIMEOUT_MSG = 66;
    static final int PUSH_TEMP_WHITELIST_UI_MSG = 68;
    static final int SERVICE_FOREGROUND_CRASH_MSG = 69;
    static final int DISPATCH_OOM_ADJ_OBSERVER_MSG = 70;
    static final int KILL_APP_ZYGOTE_MSG = 71;
    static final int FIRST_BROADCAST_QUEUE_MSG = 200;
    static final String SERVICE_RECORD_KEY = "servicerecord";
    long mLastMemUsageReportTime = 0L;
    private boolean mUserIsMonkey;
    @VisibleForTesting
    public final ServiceThread mHandlerThread;
    final MainHandler mHandler;
    final Handler mUiHandler;
    final ServiceThread mProcStartHandlerThread;
    final Handler mProcStartHandler;
    ActivityManagerConstants mConstants;
    final HiddenApiSettings mHiddenApiBlacklist;
    PackageManagerInternal mPackageManagerInt;
    boolean mForceBackgroundCheck;
    private static String sTheRealBuildSerial = "unknown";
    private ParcelFileDescriptor[] mLifeMonitorFds;
    static final HostingRecord sNullHostingRecord = new HostingRecord(null);
    ContentCaptureManagerInternal mContentCaptureService;
    static final int COLLECT_PSS_BG_MSG = 1;
    static final int DEFER_PSS_MSG = 2;
    static final int STOP_DEFERRING_PSS_MSG = 3;
    final Handler mBgHandler = new Handler(BackgroundThread.getHandler().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    start = SystemClock.uptimeMillis();
                    memInfo = null;
                    var5_5 = ActivityManagerService.this;
                    synchronized (var5_5) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (ActivityManagerService.this.mFullPssPending) {
                                ActivityManagerService.this.mFullPssPending = false;
                                memInfo = new MemInfoReader();
                            }
                        }
                        catch (Throwable var6_8) {
                            // MONITOREXIT @DISABLED, blocks:[19, 8, 14, 15] lbl15 : MonitorExitStatement: MONITOREXIT : var5_5
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw var6_8;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    if (memInfo != null) {
                        ActivityManagerService.this.updateCpuStatsNow();
                        nativeTotalPss = 0L;
                        var8_10 = ActivityManagerService.this.mProcessCpuTracker;
                        synchronized (var8_10) {
                            stats = ActivityManagerService.this.mProcessCpuTracker.getStats((ProcessCpuTracker.FilterStats)LambdaMetafactory.metafactory(null, null, null, (Lcom/android/internal/os/ProcessCpuTracker$Stats;)Z, lambda$handleMessage$0(com.android.internal.os.ProcessCpuTracker$Stats ), (Lcom/android/internal/os/ProcessCpuTracker$Stats;)Z)());
                        }
                        N = stats.size();
                        for (j = 0; j < N; ++j) {
                            var10_17 = ActivityManagerService.this.mPidsSelfLocked;
                            synchronized (var10_17) {
                                if (ActivityManagerService.this.mPidsSelfLocked.indexOfKey(stats.get((int)j).pid) >= 0) {
                                    continue;
                                }
                            }
                            nativeTotalPss += Debug.getPss(stats.get((int)j).pid, null, null);
                        }
                        memInfo.readMemInfo();
                        j = ActivityManagerService.this;
                        synchronized (j) {
                            ActivityManagerService.boostPriorityForLockedSection();
                            cachedKb = memInfo.getCachedSizeKb();
                            freeKb = memInfo.getFreeSizeKb();
                            zramKb = memInfo.getZramTotalSizeKb();
                            kernelKb = memInfo.getKernelUsedSizeKb();
                            EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeTotalPss * 1024L);
                            ActivityManagerService.this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeTotalPss);
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        ** GOTO lbl58
                        {
                            catch (Throwable var18_25) {
                                // MONITOREXIT @DISABLED, blocks:[34, 22, 12, 14, 15] lbl62 : MonitorExitStatement: MONITOREXIT : j
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw var18_25;
                            }
                        }
                    }
lbl58:
                    // 3 sources

                    num = 0;
                    tmp = new long[3];
                    while (true) {
                        pid = -1;
                        var13_26 = ActivityManagerService.this;
                        synchronized (var13_26) {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (ActivityManagerService.this.mPendingPssProcesses.size() > 0) ** GOTO lbl-1000
                            if (ActivityManagerService.this.mTestPssMode) {
                                Slog.d("ActivityManager", "Collected pss of " + num + " processes in " + (SystemClock.uptimeMillis() - start) + "ms");
                            }
                            ActivityManagerService.this.mPendingPssProcesses.clear();
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                proc = ActivityManagerService.this.mPendingPssProcesses.remove(0);
                                procState = proc.pssProcState;
                                statType = proc.pssStatType;
                                lastPssTime = proc.lastPssTime;
                                now = SystemClock.uptimeMillis();
                                if (proc.thread != null && procState == proc.setProcState && lastPssTime + 1000L < now) {
                                    pid = proc.pid;
                                } else {
                                    ProcessList.abortNextPssTime(proc.procStateMemTracker);
                                    proc = null;
                                    pid = 0;
                                }
                            }
                            catch (Throwable var19_31) {
                                // MONITOREXIT @DISABLED, blocks:[23, 10, 26, 14, 15] lbl96 : MonitorExitStatement: MONITOREXIT : var13_26
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw var19_31;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        if (proc == null) continue;
                        startTime = SystemClock.currentThreadTimeMillis();
                        pss = Debug.getPss(pid, tmp, null);
                        endTime = SystemClock.currentThreadTimeMillis();
                        var19_30 = ActivityManagerService.this;
                        synchronized (var19_30) {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (pss != 0L && proc.thread != null && proc.setProcState == procState && proc.pid == pid && proc.lastPssTime == lastPssTime) {
                                ++num;
                                ProcessList.commitNextPssTime(proc.procStateMemTracker);
                                ActivityManagerService.this.recordPssSampleLocked(proc, procState, pss, tmp[0], tmp[1], tmp[2], statType, endTime - startTime, SystemClock.uptimeMillis());
                            } else {
                                ProcessList.abortNextPssTime(proc.procStateMemTracker);
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                    {
                        catch (Throwable var20_32) {
                            // MONITOREXIT @DISABLED, blocks:[24, 13, 14, 15] lbl118 : MonitorExitStatement: MONITOREXIT : var19_30
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw var20_32;
                        }
                    }
                }
                case 2: {
                    ActivityManagerService.access$800(ActivityManagerService.this);
                    break;
                }
                case 3: {
                    nesting = ActivityManagerService.access$900(ActivityManagerService.this).decrementAndGet();
                    if (nesting > 0 || nesting >= 0) break;
                    Slog.wtf("ActivityManager", "Activity start nesting undercount!");
                    ActivityManagerService.access$900(ActivityManagerService.this).incrementAndGet();
                }
            }
        }

        private static /* synthetic */ boolean lambda$handleMessage$0(ProcessCpuTracker.Stats st) {
            return st.vsize > 0L && st.uid < 10000;
        }
    };
    @GuardedBy(value={"ActivityManagerService.class"})
    private static SimpleDateFormat sAnrFileDateFormat;
    private static final int[] PROCESS_STATE_STATS_FORMAT;
    private final long[] mProcessStateStatsLongs = new long[1];
    private volatile long mWtfClusterStart;
    private volatile int mWtfClusterCount;
    static final long[] DUMP_MEM_BUCKETS;
    static final int[] DUMP_MEM_OOM_ADJ;
    static final String[] DUMP_MEM_OOM_LABEL;
    static final String[] DUMP_MEM_OOM_COMPACT_LABEL;
    private static final int KSM_SHARED = 0;
    private static final int KSM_SHARING = 1;
    private static final int KSM_UNSHARED = 2;
    private static final int KSM_VOLATILE = 3;
    private static final int MEMINFO_COMPACT_VERSION = 1;

    BroadcastQueue broadcastQueueForIntent(Intent intent) {
        if (this.isOnOffloadQueue(intent.getFlags())) {
            return this.mOffloadBroadcastQueue;
        }
        boolean isFg = (intent.getFlags() & 0x10000000) != 0;
        return isFg ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
    }

    static void boostPriorityForLockedSection() {
        sThreadPriorityBooster.boost();
    }

    static void resetPriorityAfterLockedSection() {
        sThreadPriorityBooster.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setSystemProcess() {
        try {
            ServiceManager.addService("activity", this, true, 21);
            ServiceManager.addService("procstats", this.mProcessStats);
            ServiceManager.addService("meminfo", new MemBinder(this), false, 2);
            ServiceManager.addService("gfxinfo", new GraphicsBinder(this));
            ServiceManager.addService("dbinfo", new DbBinder(this));
            ServiceManager.addService("cpuinfo", new CpuBinder(this), false, 1);
            ServiceManager.addService("permission", new PermissionController(this));
            ServiceManager.addService("processinfo", new ProcessInfoService(this));
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo("android", 0x100400);
            this.mSystemThread.installSystemApplicationInfo(info, this.getClass().getClassLoader());
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord app = this.mProcessList.newProcessRecordLocked(info, info.processName, false, 0, new HostingRecord("system"));
                app.setPersistent(true);
                app.pid = MY_PID;
                app.getWindowProcessController().setPid(MY_PID);
                app.maxAdj = -900;
                app.makeActive(this.mSystemThread.getApplicationThread(), this.mProcessStats);
                this.mPidsSelfLocked.put(app);
                this.mProcessList.updateLruProcessLocked(app, false, null);
                this.updateOomAdjLocked("updateOomAdj_meh");
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find android system package", e);
        }
        this.mAppOpsService.startWatchingMode(63, null, new IAppOpsCallback.Stub(){

            @Override
            public void opChanged(int op, int uid, String packageName) {
                if (op == 63 && packageName != null && ActivityManagerService.this.mAppOpsService.checkOperation(op, uid, packageName) != 0) {
                    ActivityManagerService.this.runInBackgroundDisabled(uid);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowManager(WindowManagerService wm) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mWindowManager = wm;
                this.mActivityTaskManager.setWindowManager(wm);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    public void setUsageStatsManager(UsageStatsManagerInternal usageStatsManager) {
        this.mUsageStatsService = usageStatsManager;
        this.mActivityTaskManager.setUsageStatsManager(usageStatsManager);
    }

    public void setContentCaptureManager(ContentCaptureManagerInternal contentCaptureManager) {
        this.mContentCaptureService = contentCaptureManager;
    }

    public void startObservingNativeCrashes() {
        NativeCrashListener ncl = new NativeCrashListener(this);
        ncl.start();
    }

    public IAppOpsService getAppOpsService() {
        return this.mAppOpsService;
    }

    @VisibleForTesting
    public ActivityManagerService(Injector injector) {
        this(injector, null);
    }

    @VisibleForTesting
    public ActivityManagerService(Injector injector, ServiceThread handlerThread) {
        boolean hasHandlerThread = handlerThread != null;
        this.mInjector = injector;
        this.mContext = this.mInjector.getContext();
        this.mUiContext = null;
        this.mAppErrors = null;
        this.mPackageWatchdog = null;
        this.mAppOpsService = this.mInjector.getAppOpsService(null, null);
        this.mBatteryStatsService = null;
        this.mHandler = hasHandlerThread ? new MainHandler(handlerThread.getLooper()) : null;
        this.mHandlerThread = handlerThread;
        this.mConstants = hasHandlerThread ? new ActivityManagerConstants(this.mContext, this, this.mHandler) : null;
        ActiveUids activeUids = new ActiveUids(this, false);
        this.mProcessList.init(this, activeUids);
        this.mLowMemDetector = null;
        this.mOomAdjuster = new OomAdjuster(this, this.mProcessList, activeUids);
        this.mIntentFirewall = hasHandlerThread ? new IntentFirewall(new IntentFirewallInterface(), this.mHandler) : null;
        this.mProcessCpuThread = null;
        this.mProcessStats = null;
        this.mProviderMap = null;
        this.mServices = hasHandlerThread ? new ActiveServices(this) : null;
        this.mSystemThread = null;
        this.mUiHandler = injector.getUiHandler(null);
        this.mUserController = hasHandlerThread ? new UserController(this) : null;
        this.mPendingIntentController = hasHandlerThread ? new PendingIntentController(handlerThread.getLooper(), this.mUserController) : null;
        this.mProcStartHandlerThread = null;
        this.mProcStartHandler = null;
        this.mHiddenApiBlacklist = null;
        this.mFactoryTest = 0;
    }

    public ActivityManagerService(Context systemContext, ActivityTaskManagerService atm) {
        LockGuard.installLock((Object)this, 6);
        this.mInjector = new Injector();
        this.mContext = systemContext;
        this.mFactoryTest = FactoryTest.getMode();
        this.mSystemThread = ActivityThread.currentActivityThread();
        this.mUiContext = this.mSystemThread.getSystemUiContext();
        Slog.i("ActivityManager", "Memory class: " + ActivityManager.staticGetMemoryClass());
        this.mHandlerThread = new ServiceThread("ActivityManager", -2, false);
        this.mHandlerThread.start();
        this.mHandler = new MainHandler(this.mHandlerThread.getLooper());
        this.mUiHandler = this.mInjector.getUiHandler(this);
        this.mProcStartHandlerThread = new ServiceThread("ActivityManager:procStart", -2, false);
        this.mProcStartHandlerThread.start();
        this.mProcStartHandler = new Handler(this.mProcStartHandlerThread.getLooper());
        this.mConstants = new ActivityManagerConstants(this.mContext, this, this.mHandler);
        ActiveUids activeUids = new ActiveUids(this, true);
        this.mProcessList.init(this, activeUids);
        this.mLowMemDetector = new LowMemDetector(this);
        this.mOomAdjuster = new OomAdjuster(this, this.mProcessList, activeUids);
        BroadcastConstants foreConstants = new BroadcastConstants("bcast_fg_constants");
        foreConstants.TIMEOUT = 10000L;
        BroadcastConstants backConstants = new BroadcastConstants("bcast_bg_constants");
        backConstants.TIMEOUT = 60000L;
        BroadcastConstants offloadConstants = new BroadcastConstants("bcast_offload_constants");
        offloadConstants.TIMEOUT = 60000L;
        offloadConstants.SLOW_TIME = Integer.MAX_VALUE;
        this.mEnableOffloadQueue = SystemProperties.getBoolean("persist.device_config.activity_manager_native_boot.offload_queue_enabled", false);
        this.mFgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "foreground", foreConstants, false);
        this.mBgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "background", backConstants, true);
        this.mOffloadBroadcastQueue = new BroadcastQueue(this, this.mHandler, "offload", offloadConstants, true);
        this.mBroadcastQueues[0] = this.mFgBroadcastQueue;
        this.mBroadcastQueues[1] = this.mBgBroadcastQueue;
        this.mBroadcastQueues[2] = this.mOffloadBroadcastQueue;
        this.mServices = new ActiveServices(this);
        this.mProviderMap = new ProviderMap(this);
        this.mPackageWatchdog = PackageWatchdog.getInstance(this.mUiContext);
        this.mAppErrors = new AppErrors(this.mUiContext, this, this.mPackageWatchdog);
        File systemDir = SystemServiceManager.ensureSystemDir();
        BackgroundThread.get();
        this.mBatteryStatsService = new BatteryStatsService(systemContext, systemDir, BackgroundThread.getHandler());
        this.mBatteryStatsService.getActiveStatistics().readLocked();
        this.mBatteryStatsService.scheduleWriteToDisk();
        this.mOnBattery = this.mBatteryStatsService.getActiveStatistics().getIsOnBattery();
        this.mBatteryStatsService.getActiveStatistics().setCallback(this);
        this.mOomAdjProfiler.batteryPowerChanged(this.mOnBattery);
        this.mProcessStats = new ProcessStatsService(this, new File(systemDir, "procstats"));
        this.mAppOpsService = this.mInjector.getAppOpsService(new File(systemDir, "appops.xml"), this.mHandler);
        this.mUgmInternal = LocalServices.getService(UriGrantsManagerInternal.class);
        this.mUserController = new UserController(this);
        this.mPendingIntentController = new PendingIntentController(this.mHandlerThread.getLooper(), this.mUserController);
        if (SystemProperties.getInt("sys.use_fifo_ui", 0) != 0) {
            this.mUseFifoUiScheduling = true;
        }
        this.mTrackingAssociations = "1".equals(SystemProperties.get("debug.track-associations"));
        this.mIntentFirewall = new IntentFirewall(new IntentFirewallInterface(), this.mHandler);
        this.mActivityTaskManager = atm;
        this.mActivityTaskManager.initialize(this.mIntentFirewall, this.mPendingIntentController, DisplayThread.get().getLooper());
        this.mAtmInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        this.mProcessCpuThread = new Thread("CpuTracker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ActivityManagerService.this.mProcessCpuTracker;
                synchronized (object) {
                    ActivityManagerService.this.mProcessCpuInitLatch.countDown();
                    ActivityManagerService.this.mProcessCpuTracker.init();
                }
                while (true) {
                    try {
                        while (true) {
                            try {
                                object = this;
                                synchronized (object) {
                                    long now = SystemClock.uptimeMillis();
                                    long nextCpuDelay = ActivityManagerService.this.mLastCpuTime.get() + 0xFFFFFFFL - now;
                                    long nextWriteDelay = ActivityManagerService.this.mLastWriteTime + 1800000L - now;
                                    if (nextWriteDelay < nextCpuDelay) {
                                        nextCpuDelay = nextWriteDelay;
                                    }
                                    if (nextCpuDelay > 0L) {
                                        ActivityManagerService.this.mProcessCpuMutexFree.set(true);
                                        this.wait(nextCpuDelay);
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                        }
                    }
                    catch (Exception e) {
                        Slog.e("ActivityManager", "Unexpected exception collecting process stats", e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.mHiddenApiBlacklist = new HiddenApiSettings(this.mHandler, this.mContext);
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler);
        this.updateOomAdjLocked("updateOomAdj_meh");
        try {
            android.os.Process.setThreadGroupAndCpuset(BackgroundThread.get().getThreadId(), 2);
            android.os.Process.setThreadGroupAndCpuset(this.mOomAdjuster.mAppCompact.mCompactionThread.getThreadId(), 2);
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Setting background thread cpuset failed");
        }
    }

    public void setSystemServiceManager(SystemServiceManager mgr) {
        this.mSystemServiceManager = mgr;
    }

    public void setInstaller(Installer installer) {
        this.mInstaller = installer;
    }

    private void start() {
        android.os.Process.removeAllProcessGroups();
        this.mProcessCpuThread.start();
        this.mBatteryStatsService.publish();
        this.mAppOpsService.publish(this.mContext);
        Slog.d("AppOps", "AppOpsService published");
        LocalServices.addService(ActivityManagerInternal.class, new LocalService());
        this.mActivityTaskManager.onActivityManagerInternalAdded();
        this.mUgmInternal.onActivityManagerInternalAdded();
        this.mPendingIntentController.onActivityManagerInternalAdded();
        try {
            this.mProcessCpuInitLatch.await();
        }
        catch (InterruptedException e) {
            Slog.wtf("ActivityManager", "Interrupted wait during start", e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted wait during start");
        }
    }

    public void initPowerManagement() {
        this.mActivityTaskManager.onInitPowerManagement();
        this.mBatteryStatsService.initPowerManagement();
        this.mLocalPowerManager = LocalServices.getService(PowerManagerInternal.class);
    }

    private ArraySet<String> getBackgroundLaunchBroadcasts() {
        if (this.mBackgroundLaunchBroadcasts == null) {
            this.mBackgroundLaunchBroadcasts = SystemConfig.getInstance().getAllowImplicitBroadcasts();
        }
        return this.mBackgroundLaunchBroadcasts;
    }

    void requireAllowedAssociationsLocked(String packageName) {
        this.ensureAllowedAssociations();
        if (this.mAllowedAssociations.get(packageName) == null) {
            this.mAllowedAssociations.put(packageName, new PackageAssociationInfo(packageName, new ArraySet<String>(), false));
        }
    }

    boolean validateAssociationAllowedLocked(String pkg1, int uid1, String pkg2, int uid2) {
        this.ensureAllowedAssociations();
        if (uid1 == uid2 || UserHandle.getAppId(uid1) == 1000 || UserHandle.getAppId(uid2) == 1000) {
            return true;
        }
        PackageAssociationInfo pai = this.mAllowedAssociations.get(pkg1);
        if (pai != null && !pai.isPackageAssociationAllowed(pkg2)) {
            return false;
        }
        pai = this.mAllowedAssociations.get(pkg2);
        return pai == null || pai.isPackageAssociationAllowed(pkg1);
    }

    private void ensureAllowedAssociations() {
        if (this.mAllowedAssociations == null) {
            ArrayMap<String, ArraySet<String>> allowedAssociations = SystemConfig.getInstance().getAllowedAssociations();
            this.mAllowedAssociations = new ArrayMap(allowedAssociations.size());
            PackageManagerInternal pm = this.getPackageManagerInternalLocked();
            for (int i = 0; i < allowedAssociations.size(); ++i) {
                String pkg = allowedAssociations.keyAt(i);
                ArraySet<String> asc = allowedAssociations.valueAt(i);
                boolean isDebuggable = false;
                try {
                    ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(pkg, 131072, 0);
                    if (ai != null) {
                        isDebuggable = (ai.flags & 2) != 0;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mAllowedAssociations.put(pkg, new PackageAssociationInfo(pkg, asc, isDebuggable));
            }
        }
    }

    private void updateAssociationForApp(ApplicationInfo appInfo) {
        this.ensureAllowedAssociations();
        PackageAssociationInfo pai = this.mAllowedAssociations.get(appInfo.packageName);
        if (pai != null) {
            pai.setDebuggable((appInfo.flags & 2) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        block11: {
            if (code != 1599295570) break block11;
            ArrayList<IBinder> procs = new ArrayList<IBinder>();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    int NP = this.mProcessList.mProcessNames.getMap().size();
                    for (int ip = 0; ip < NP; ++ip) {
                        SparseArray apps = this.mProcessList.mProcessNames.getMap().valueAt(ip);
                        int NA = apps.size();
                        for (int ia = 0; ia < NA; ++ia) {
                            ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                            if (app.thread == null) continue;
                            procs.add(app.thread.asBinder());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var6_7
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                Parcel data2 = Parcel.obtain();
                try {
                    ((IBinder)procs.get(i)).transact(1599295570, data2, null, 1);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                data2.recycle();
            }
        }
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException || e instanceof IllegalArgumentException || e instanceof IllegalStateException)) {
                Slog.wtf("ActivityManager", "Activity Manager Crash. UID:" + Binder.getCallingUid() + " PID:" + Binder.getCallingPid() + " TRANS:" + code, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStats() {
        long now = SystemClock.uptimeMillis();
        if (this.mLastCpuTime.get() >= now - 5000L) {
            return;
        }
        if (this.mProcessCpuMutexFree.compareAndSet(true, false)) {
            Thread thread = this.mProcessCpuThread;
            synchronized (thread) {
                this.mProcessCpuThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStatsNow() {
        ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
        synchronized (processCpuTracker) {
            BatteryStatsImpl bstats;
            this.mProcessCpuMutexFree.set(false);
            long now = SystemClock.uptimeMillis();
            boolean haveNewCpuStats = false;
            if (this.mLastCpuTime.get() < now - 5000L) {
                this.mLastCpuTime.set(now);
                this.mProcessCpuTracker.update();
                if (this.mProcessCpuTracker.hasGoodLastStats()) {
                    haveNewCpuStats = true;
                    if ("true".equals(SystemProperties.get("events.cpu"))) {
                        int idle;
                        int softIrq;
                        int irq;
                        int iowait;
                        int system;
                        int user = this.mProcessCpuTracker.getLastUserTime();
                        int total = user + (system = this.mProcessCpuTracker.getLastSystemTime()) + (iowait = this.mProcessCpuTracker.getLastIoWaitTime()) + (irq = this.mProcessCpuTracker.getLastIrqTime()) + (softIrq = this.mProcessCpuTracker.getLastSoftIrqTime()) + (idle = this.mProcessCpuTracker.getLastIdleTime());
                        if (total == 0) {
                            total = 1;
                        }
                        EventLog.writeEvent(2721, (user + system + iowait + irq + softIrq) * 100 / total, user * 100 / total, system * 100 / total, iowait * 100 / total, irq * 100 / total, softIrq * 100 / total);
                    }
                }
            }
            BatteryStatsImpl batteryStatsImpl = bstats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    if (haveNewCpuStats && bstats.startAddingCpuLocked()) {
                        int totalUTime = 0;
                        int totalSTime = 0;
                        int N = this.mProcessCpuTracker.countStats();
                        for (int i = 0; i < N; ++i) {
                            BatteryStatsImpl.Uid.Proc ps;
                            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                            if (!st.working) continue;
                            ProcessRecord pr = this.mPidsSelfLocked.get(st.pid);
                            totalUTime += st.rel_utime;
                            totalSTime += st.rel_stime;
                            if (pr != null) {
                                ps = pr.curProcBatteryStats;
                                if (ps == null || !ps.isActive()) {
                                    pr.curProcBatteryStats = ps = bstats.getProcessStatsLocked(pr.info.uid, pr.processName);
                                }
                                ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                                pr.curCpuTime += (long)(st.rel_utime + st.rel_stime);
                                if (pr.lastCpuTime != 0L) continue;
                                pr.lastCpuTime = pr.curCpuTime;
                                continue;
                            }
                            ps = st.batteryStats;
                            if (ps == null || !ps.isActive()) {
                                st.batteryStats = ps = bstats.getProcessStatsLocked(bstats.mapUid(st.uid), st.name);
                            }
                            ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                        }
                        int userTime = this.mProcessCpuTracker.getLastUserTime();
                        int systemTime = this.mProcessCpuTracker.getLastSystemTime();
                        int iowaitTime = this.mProcessCpuTracker.getLastIoWaitTime();
                        int irqTime = this.mProcessCpuTracker.getLastIrqTime();
                        int softIrqTime = this.mProcessCpuTracker.getLastSoftIrqTime();
                        int idleTime = this.mProcessCpuTracker.getLastIdleTime();
                        bstats.finishAddingCpuLocked(totalUTime, totalSTime, userTime, systemTime, iowaitTime, irqTime, softIrqTime, idleTime);
                    }
                }
                if (this.mLastWriteTime < now - 1800000L) {
                    this.mLastWriteTime = now;
                    this.mBatteryStatsService.scheduleWriteToDisk();
                }
            }
        }
    }

    @Override
    public void batteryNeedsCpuUpdate() {
        this.updateCpuStatsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batteryPowerChanged(boolean onBattery) {
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    this.mOnBattery = onBattery;
                }
                this.mOomAdjProfiler.batteryPowerChanged(onBattery);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl19 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void batteryStatsReset() {
        this.mOomAdjProfiler.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batterySendBroadcast(Intent intent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, Binder.getCallingUid(), Binder.getCallingPid(), -1);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private ArrayMap<String, IBinder> getCommonServicesLocked(boolean isolated) {
        if (isolated) {
            if (this.mIsolatedAppBindArgs == null) {
                this.mIsolatedAppBindArgs = new ArrayMap(1);
                ActivityManagerService.addServiceToMap(this.mIsolatedAppBindArgs, "package");
            }
            return this.mIsolatedAppBindArgs;
        }
        if (this.mAppBindArgs == null) {
            this.mAppBindArgs = new ArrayMap();
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "package");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "window");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "alarm");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "display");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "network_management");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "connectivity");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "accessibility");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "input_method");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "input");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "graphicsstats");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "appops");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "content");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "jobscheduler");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "notification");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "vibrator");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "account");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "power");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "user");
            ActivityManagerService.addServiceToMap(this.mAppBindArgs, "mount");
        }
        return this.mAppBindArgs;
    }

    private static void addServiceToMap(ArrayMap<String, IBinder> map, String name) {
        IBinder service = ServiceManager.getService(name);
        if (service != null) {
            map.put(name, service);
        }
    }

    @Override
    public void setFocusedStack(int stackId) {
        this.mActivityTaskManager.setFocusedStack(stackId);
    }

    @Override
    public void registerTaskStackListener(ITaskStackListener listener) {
        this.mActivityTaskManager.registerTaskStackListener(listener);
    }

    @Override
    public void unregisterTaskStackListener(ITaskStackListener listener) {
        this.mActivityTaskManager.unregisterTaskStackListener(listener);
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean activityChange, ProcessRecord client) {
        this.mProcessList.updateLruProcessLocked(app, activityChange, client);
    }

    final void removeLruProcessLocked(ProcessRecord app) {
        this.mProcessList.removeLruProcessLocked(app);
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid, boolean keepIfLarge) {
        return this.mProcessList.getProcessRecordLocked(processName, uid, keepIfLarge);
    }

    final ProcessMap<ProcessRecord> getProcessNames() {
        return this.mProcessList.mProcessNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPackageUse(String packageName, int reason) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.getPackageManagerInternalLocked().notifyPackageUse(packageName, reason);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ApplicationInfo info = new ApplicationInfo();
                info.uid = 1000;
                info.processName = processName;
                info.className = entryPoint;
                info.packageName = "android";
                info.seInfoUser = ":complete";
                info.targetSdkVersion = Build.VERSION.SDK_INT;
                ProcessRecord proc = this.mProcessList.startProcessLocked(processName, info, false, 0, sNullHostingRecord, true, true, uid, true, abiOverride, entryPoint, entryPointArgs, crashHandler);
                bl = proc != null;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    @GuardedBy(value={"this"})
    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, HostingRecord hostingRecord, boolean allowWhileBooting, boolean isolated, boolean keepIfLarge) {
        return this.mProcessList.startProcessLocked(processName, info, knownToBeDead, intentFlags, hostingRecord, allowWhileBooting, isolated, 0, keepIfLarge, null, null, null, null);
    }

    boolean isAllowedWhileBooting(ApplicationInfo ai) {
        return (ai.flags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBatteryStats(ComponentName activity, int uid, int userId, boolean resumed) {
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        StatsLog.write(42, uid, activity.getPackageName(), activity.getShortClassName(), resumed ? 1 : 0);
        BatteryStatsImpl batteryStatsImpl = stats;
        synchronized (batteryStatsImpl) {
            if (resumed) {
                stats.noteActivityResumedLocked(uid);
            } else {
                stats.noteActivityPausedLocked(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivityUsageStats(ComponentName activity, int userId, int event, IBinder appToken, ComponentName taskRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mUsageStatsService != null) {
                    this.mUsageStatsService.reportEvent(activity, userId, event, appToken.hashCode(), taskRoot);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var6_6
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (this.mContentCaptureService != null && (event == 2 || event == 1 || event == 23 || event == 24)) {
            this.mContentCaptureService.notifyActivityEvent(userId, activity, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivityUsageStats(String packageName, int userId, int event) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mUsageStatsService != null) {
                    this.mUsageStatsService.reportEvent(packageName, userId, event);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateForegroundServiceUsageStats(ComponentName service, int userId, boolean started) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mUsageStatsService != null) {
                    this.mUsageStatsService.reportEvent(service, userId, started ? 19 : 20, 0, null);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    CompatibilityInfo compatibilityInfoForPackage(ApplicationInfo ai) {
        return this.mAtmInternal.compatibilityInfoForPackage(ai);
    }

    private void enforceNotIsolatedCaller(String caller) {
        if (UserHandle.isIsolated(Binder.getCallingUid())) {
            throw new SecurityException("Isolated process not allowed to call " + caller);
        }
    }

    @Override
    public void setPackageScreenCompatMode(String packageName, int mode) {
        this.mActivityTaskManager.setPackageScreenCompatMode(packageName, mode);
    }

    private boolean hasUsageStatsPermission(String callingPackage) {
        int mode = this.mAppOpsService.noteOperation(43, Binder.getCallingUid(), callingPackage);
        if (mode == 3) {
            return this.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
        }
        return mode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageProcessState(String packageName, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "getPackageProcessState");
        }
        int procState = 21;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mProcessList.mLruProcesses.get(i);
                    if (procState <= proc.setProcState || !proc.pkgList.containsKey(packageName) && (proc.pkgDeps == null || !proc.pkgDeps.contains(packageName))) continue;
                    procState = proc.setProcState;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return procState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setProcessMemoryTrimLevel(String process, int userId, int level) throws RemoteException {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord app = this.findProcessLocked(process, userId, "setProcessMemoryTrimLevel");
                if (app == null) {
                    throw new IllegalArgumentException("Unknown process: " + process);
                }
                if (app.thread == null) {
                    throw new IllegalArgumentException("Process has no app thread");
                }
                if (app.trimMemoryLevel >= level) {
                    throw new IllegalArgumentException("Unable to set a higher trim level than current level");
                }
                if (level >= 20 && app.getCurProcState() <= 7) {
                    throw new IllegalArgumentException("Unable to set a background trim level on a foreground process");
                }
                app.thread.scheduleTrimMemory(level);
                app.trimMemoryLevel = level;
                bl = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProcessesChanged() {
        int j;
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                N = this.mPendingProcessChanges.size();
                if (this.mActiveProcessChanges.length < N) {
                    this.mActiveProcessChanges = new ProcessChangeItem[N];
                }
                this.mPendingProcessChanges.toArray(this.mActiveProcessChanges);
                this.mPendingProcessChanges.clear();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                for (j = 0; j < N; ++j) {
                    ProcessChangeItem item = this.mActiveProcessChanges[j];
                    if ((item.changes & 1) != 0) {
                        observer.onForegroundActivitiesChanged(item.pid, item.uid, item.foregroundActivities);
                    }
                    if ((item.changes & 2) == 0) continue;
                    observer.onForegroundServicesChanged(item.pid, item.uid, item.foregroundServiceTypes);
                }
            }
            catch (RemoteException j2) {
            }
        }
        this.mProcessObservers.finishBroadcast();
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (j = 0; j < N; ++j) {
                    this.mAvailProcessChanges.add(this.mActiveProcessChanges[j]);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[4, 7] lbl44 : MonitorExitStatement: MONITOREXIT : var3_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    ProcessChangeItem enqueueProcessChangeItemLocked(int pid, int uid) {
        int i;
        ProcessChangeItem item = null;
        for (i = this.mPendingProcessChanges.size() - 1; i >= 0; --i) {
            item = this.mPendingProcessChanges.get(i);
            if (item.pid == pid) break;
        }
        if (i < 0) {
            int NA = this.mAvailProcessChanges.size();
            item = NA > 0 ? this.mAvailProcessChanges.remove(NA - 1) : new ProcessChangeItem();
            item.changes = 0;
            item.pid = pid;
            item.uid = uid;
            if (this.mPendingProcessChanges.size() == 0) {
                this.mUiHandler.obtainMessage(31).sendToTarget();
            }
            this.mPendingProcessChanges.add(item);
        }
        return item;
    }

    private void dispatchProcessDied(int pid, int uid) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onProcessDied(pid, uid);
            }
            catch (RemoteException remoteException) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void dispatchUidsChanged() {
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                N = this.mPendingUidChanges.size();
                if (this.mActiveUidChanges.length < N) {
                    this.mActiveUidChanges = new UidRecord.ChangeItem[N];
                }
                for (int i = 0; i < N; ++i) {
                    UidRecord.ChangeItem change;
                    this.mActiveUidChanges[i] = change = this.mPendingUidChanges.get(i);
                    if (change.uidRecord == null) continue;
                    change.uidRecord.pendingChange = null;
                    change.uidRecord = null;
                }
                this.mPendingUidChanges.clear();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        this.mUidChangeDispatchCount += N;
        int i = this.mUidObservers.beginBroadcast();
        while (i > 0) {
            this.dispatchUidsChangedForObserver(this.mUidObservers.getBroadcastItem(--i), (UidObserverRegistration)this.mUidObservers.getBroadcastCookie(i), N);
        }
        this.mUidObservers.finishBroadcast();
        if (this.mUidObservers.getRegisteredCallbackCount() > 0) {
            for (int j = 0; j < N; ++j) {
                UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                if ((item.change & 1) != 0) {
                    this.mValidateUids.remove(item.uid);
                    continue;
                }
                UidRecord validateUid = this.mValidateUids.get(item.uid);
                if (validateUid == null) {
                    validateUid = new UidRecord(item.uid);
                    this.mValidateUids.put(item.uid, validateUid);
                }
                if ((item.change & 2) != 0) {
                    validateUid.idle = true;
                } else if ((item.change & 4) != 0) {
                    validateUid.idle = false;
                }
                validateUid.setProcState = item.processState;
                validateUid.setCurProcState(validateUid.setProcState);
                validateUid.lastDispatchedProcStateSeq = item.procStateSeq;
            }
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int j = 0; j < N; ++j) {
                    this.mAvailUidChanges.add(this.mActiveUidChanges[j]);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl58 : MonitorExitStatement: MONITOREXIT : var3_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void dispatchUidsChangedForObserver(IUidObserver observer, UidObserverRegistration reg, int changesSize) {
        if (observer == null) {
            return;
        }
        try {
            for (int j = 0; j < changesSize; ++j) {
                int duration;
                UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                int change = item.change;
                if (change == 0 && (reg.which & 1) == 0) continue;
                long start = SystemClock.uptimeMillis();
                if ((change & 2) != 0) {
                    if ((reg.which & 4) != 0) {
                        observer.onUidIdle(item.uid, item.ephemeral);
                    }
                } else if ((change & 4) != 0 && (reg.which & 8) != 0) {
                    observer.onUidActive(item.uid);
                }
                if ((reg.which & 0x10) != 0) {
                    if ((change & 8) != 0) {
                        observer.onUidCachedChanged(item.uid, true);
                    } else if ((change & 0x10) != 0) {
                        observer.onUidCachedChanged(item.uid, false);
                    }
                }
                if ((change & 1) != 0) {
                    if ((reg.which & 2) != 0) {
                        observer.onUidGone(item.uid, item.ephemeral);
                    }
                    if (reg.lastProcStates != null) {
                        reg.lastProcStates.delete(item.uid);
                    }
                } else if ((reg.which & 1) != 0) {
                    boolean doReport = true;
                    if (reg.cutpoint >= 0) {
                        int lastState = reg.lastProcStates.get(item.uid, -1);
                        if (lastState != -1) {
                            boolean lastAboveCut = lastState <= reg.cutpoint;
                            boolean newAboveCut = item.processState <= reg.cutpoint;
                            doReport = lastAboveCut != newAboveCut;
                        } else {
                            boolean bl = doReport = item.processState != 21;
                        }
                    }
                    if (doReport) {
                        if (reg.lastProcStates != null) {
                            reg.lastProcStates.put(item.uid, item.processState);
                        }
                        observer.onUidStateChanged(item.uid, item.processState, item.procStateSeq);
                    }
                }
                if (reg.mMaxDispatchTime < (duration = (int)(SystemClock.uptimeMillis() - start))) {
                    reg.mMaxDispatchTime = duration;
                }
                if (duration < 20) continue;
                ++reg.mSlowDispatchCount;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOomAdjObserver(String msg) {
        OomAdjObserver observer;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                observer = this.mCurOomAdjObserver;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (observer != null) {
            observer.onOomAdjMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOomAdjObserver(int uid, OomAdjObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mCurOomAdjUid = uid;
                this.mCurOomAdjObserver = observer;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearOomAdjObserver() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mCurOomAdjUid = -1;
                this.mCurOomAdjObserver = null;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void reportOomAdjMessageLocked(String tag, String msg) {
        Slog.d(tag, msg);
        if (this.mCurOomAdjObserver != null) {
            this.mUiHandler.obtainMessage(70, msg).sendToTarget();
        }
    }

    void reportUidInfoMessageLocked(String tag, String msg, int uid) {
        Slog.i("ActivityManager", msg);
        if (this.mCurOomAdjObserver != null && uid == this.mCurOomAdjUid) {
            this.mUiHandler.obtainMessage(70, msg).sendToTarget();
        }
    }

    @Override
    public int startActivity(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions) {
        return this.mActivityTaskManager.startActivity(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, bOptions);
    }

    @Override
    public final int startActivityAsUser(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, int userId) {
        return this.mActivityTaskManager.startActivityAsUser(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, bOptions, userId);
    }

    WaitResult startActivityAndWait(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, int userId) {
        return this.mActivityTaskManager.startActivityAndWait(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, bOptions, userId);
    }

    @Override
    public final int startActivityFromRecents(int taskId, Bundle bOptions) {
        return this.mActivityTaskManager.startActivityFromRecents(taskId, bOptions);
    }

    @Override
    public void startRecentsActivity(Intent intent, IAssistDataReceiver assistDataReceiver, IRecentsAnimationRunner recentsAnimationRunner) {
        this.mActivityTaskManager.startRecentsActivity(intent, assistDataReceiver, recentsAnimationRunner);
    }

    @Override
    public void cancelRecentsAnimation(boolean restoreHomeStackPosition) {
        this.mActivityTaskManager.cancelRecentsAnimation(restoreHomeStackPosition);
    }

    @Override
    public final boolean finishActivity(IBinder token, int resultCode, Intent resultData, int finishTask) {
        return this.mActivityTaskManager.finishActivity(token, resultCode, resultData, finishTask);
    }

    @Override
    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        this.mActivityTaskManager.setRequestedOrientation(token, requestedOrientation);
    }

    @Override
    public final void finishHeavyWeightApp() {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: finishHeavyWeightApp() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        this.mAtmInternal.finishHeavyWeightApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crashApplication(int uid, int initialPid, String packageName, int userId, String message) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: crashApplication() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mAppErrors.scheduleAppCrashLocked(uid, initialPid, packageName, userId, message);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var6_7
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    final void handleAppDiedLocked(ProcessRecord app, boolean restarting, boolean allowRestart) {
        int pid = app.pid;
        boolean kept = this.cleanUpApplicationRecordLocked(app, restarting, allowRestart, -1, false);
        if (!kept && !restarting) {
            this.removeLruProcessLocked(app);
            if (pid > 0) {
                ProcessList.remove(pid);
            }
        }
        if (this.mProfileData.getProfileProc() == app) {
            this.clearProfilerLocked();
        }
        this.mAtmInternal.handleAppDied(app.getWindowProcessController(), restarting, () -> {
            Slog.w("ActivityManager", "Crash of app " + app.processName + " running instrumentation " + app.getActiveInstrumentation().mClass);
            Bundle info = new Bundle();
            info.putString("shortMsg", "Process crashed.");
            this.finishInstrumentationLocked(app, 0, info);
        });
    }

    ProcessRecord getRecordForAppLocked(IApplicationThread thread) {
        if (thread == null) {
            return null;
        }
        ProcessRecord record = this.mProcessList.getLRURecordForAppLocked(thread);
        if (record != null) {
            return record;
        }
        IBinder threadBinder = thread.asBinder();
        ArrayMap pmap = this.mProcessList.mProcessNames.getMap();
        for (int i = pmap.size() - 1; i >= 0; --i) {
            SparseArray procs = pmap.valueAt(i);
            for (int j = procs.size() - 1; j >= 0; --j) {
                ProcessRecord proc = (ProcessRecord)procs.valueAt(j);
                if (proc.thread == null || proc.thread.asBinder() != threadBinder) continue;
                Slog.wtf("ActivityManager", "getRecordForApp: exists in name list but not in LRU list: " + proc);
                return proc;
            }
        }
        return null;
    }

    final void doLowMemReportIfNeededLocked(ProcessRecord dyingProc) {
        if (!this.mProcessList.haveBackgroundProcessLocked()) {
            boolean doReport = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (doReport) {
                long now = SystemClock.uptimeMillis();
                if (now < this.mLastMemUsageReportTime + 300000L) {
                    doReport = false;
                } else {
                    this.mLastMemUsageReportTime = now;
                }
            }
            ArrayList<ProcessMemInfo> memInfos = doReport ? new ArrayList<ProcessMemInfo>(this.mProcessList.getLruSizeLocked()) : null;
            EventLog.writeEvent(30017, this.mProcessList.getLruSizeLocked());
            long now = SystemClock.uptimeMillis();
            for (int i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord rec = this.mProcessList.mLruProcesses.get(i);
                if (rec == dyingProc || rec.thread == null) continue;
                if (doReport) {
                    memInfos.add(new ProcessMemInfo(rec.processName, rec.pid, rec.setAdj, rec.setProcState, rec.adjType, rec.makeAdjReason()));
                }
                if (rec.lastLowMemory + this.mConstants.GC_MIN_INTERVAL > now) continue;
                rec.lastRequestedGc = rec.setAdj <= 400 ? 0L : rec.lastLowMemory;
                rec.reportLowMemory = true;
                rec.lastLowMemory = now;
                this.mProcessesToGc.remove(rec);
                this.addProcessToGcListLocked(rec);
            }
            if (doReport) {
                Message msg = this.mHandler.obtainMessage(33, memInfos);
                this.mHandler.sendMessage(msg);
            }
            this.scheduleAppGcsLocked();
        }
    }

    @GuardedBy(value={"this"})
    final void appDiedLocked(ProcessRecord app) {
        this.appDiedLocked(app, app.pid, app.thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    final void appDiedLocked(ProcessRecord app, int pid, IApplicationThread thread, boolean fromBinderDied) {
        BatteryStatsImpl stats;
        Object curProc;
        PidMap pidMap = this.mPidsSelfLocked;
        synchronized (pidMap) {
            curProc = this.mPidsSelfLocked.get(pid);
            if (curProc != app) {
                Slog.w("ActivityManager", "Spurious death for " + app + ", curProc for " + pid + ": " + curProc);
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
            stats = this.mBatteryStatsService.getActiveStatistics();
            curProc = stats;
        }
        synchronized (curProc) {
            stats.noteProcessDiedLocked(app.info.uid, pid);
        }
        if (!app.killed) {
            if (!fromBinderDied) {
                android.os.Process.killProcessQuiet(pid);
            }
            ProcessList.killProcessGroup(app.uid, pid);
            app.killed = true;
        }
        if (app.pid == pid && app.thread != null && app.thread.asBinder() == thread.asBinder()) {
            boolean doLowMem;
            boolean doOomAdj = doLowMem = app.getActiveInstrumentation() == null;
            if (!app.killedByAm) {
                this.reportUidInfoMessageLocked("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died: " + ProcessList.makeOomAdjString(app.setAdj, true) + " " + ProcessList.makeProcStateString(app.setProcState), app.info.uid);
                this.mAllowLowerMemLevel = true;
            } else {
                this.mAllowLowerMemLevel = false;
                doLowMem = false;
            }
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName, app.setAdj, app.setProcState);
            this.handleAppDiedLocked(app, false, true);
            if (doOomAdj) {
                this.updateOomAdjLocked("updateOomAdj_processEnd");
            }
            if (doLowMem) {
                this.doLowMemReportIfNeededLocked(app);
            }
        } else if (app.pid != pid) {
            this.reportUidInfoMessageLocked("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died and restarted (pid " + app.pid + ").", app.info.uid);
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
        }
        if (!MemoryStatUtil.hasMemcg()) {
            StatsLog.write(65, SystemClock.elapsedRealtime());
        }
    }

    public static File dumpStackTraces(ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, ArrayList<Integer> nativePids) {
        ArrayList<Integer> extraPids = null;
        Slog.i("ActivityManager", "dumpStackTraces pids=" + lastPids + " nativepids=" + nativePids);
        if (processCpuTracker != null) {
            processCpuTracker.init();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            processCpuTracker.update();
            int N = processCpuTracker.countWorkingStats();
            extraPids = new ArrayList<Integer>();
            for (int i = 0; i < N && extraPids.size() < 5; ++i) {
                ProcessCpuTracker.Stats stats = processCpuTracker.getWorkingStats(i);
                if (lastPids.indexOfKey(stats.pid) >= 0) {
                    extraPids.add(stats.pid);
                    continue;
                }
                Slog.i("ActivityManager", "Skipping next CPU consuming process, not a java proc: " + stats.pid);
            }
        }
        File tracesDir = new File(ANR_TRACE_DIR);
        ActivityManagerService.maybePruneOldTraces(tracesDir);
        File tracesFile = ActivityManagerService.createAnrDumpFile(tracesDir);
        if (tracesFile == null) {
            return null;
        }
        ActivityManagerService.dumpStackTraces(tracesFile.getAbsolutePath(), firstPids, nativePids, extraPids);
        return tracesFile;
    }

    private static synchronized File createAnrDumpFile(File file) {
        block4: {
            File tracesDir;
            ActivityManagerService.boostPriorityForLockedSection();
            if (sAnrFileDateFormat == null) {
                sAnrFileDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            }
            String formattedDate = sAnrFileDateFormat.format(new Date());
            File anrFile = new File(tracesDir, "anr_" + formattedDate);
            if (!anrFile.createNewFile()) break block4;
            FileUtils.setPermissions(anrFile.getAbsolutePath(), 384, -1, -1);
            File file2 = anrFile;
            ActivityManagerService.resetPriorityAfterLockedSection();
            return file2;
        }
        try {
            Slog.w("ActivityManager", "Unable to create ANR dump file: createNewFile failed");
        }
        catch (IOException ioe) {
            Slog.w("ActivityManager", "Exception creating ANR dump file:", ioe);
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return null;
    }

    private static void maybePruneOldTraces(File tracesDir) {
        File[] files = tracesDir.listFiles();
        if (files == null) {
            return;
        }
        int max = SystemProperties.getInt("tombstoned.max_anr_count", 64);
        long now = System.currentTimeMillis();
        Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
        for (int i = 0; i < files.length; ++i) {
            if (i <= max && now - files[i].lastModified() <= 86400000L || files[i].delete()) continue;
            Slog.w("ActivityManager", "Unable to prune stale trace file: " + files[i]);
        }
    }

    private static long dumpJavaTracesTombstoned(int pid, String fileName, long timeoutMs) {
        long timeStart = SystemClock.elapsedRealtime();
        boolean javaSuccess = Debug.dumpJavaBacktraceToFileTimeout(pid, fileName, (int)(timeoutMs / 1000L));
        if (javaSuccess) {
            try {
                long size = new File(fileName).length();
                if (size < 100L) {
                    Slog.w("ActivityManager", "Successfully created Java ANR file is empty!");
                    javaSuccess = false;
                }
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Unable to get ANR file size", e);
                javaSuccess = false;
            }
        }
        if (!javaSuccess) {
            Slog.w("ActivityManager", "Dumping Java threads failed, initiating native stack dump.");
            if (!Debug.dumpNativeBacktraceToFileTimeout(pid, fileName, 2)) {
                Slog.w("ActivityManager", "Native stack dump failed!");
            }
        }
        return SystemClock.elapsedRealtime() - timeStart;
    }

    public static void dumpStackTraces(String tracesFile, ArrayList<Integer> firstPids, ArrayList<Integer> nativePids, ArrayList<Integer> extraPids) {
        long timeTaken;
        Slog.i("ActivityManager", "Dumping to " + tracesFile);
        long remainingTime = 20000L;
        if (firstPids != null) {
            int num = firstPids.size();
            for (int i = 0; i < num; ++i) {
                Slog.i("ActivityManager", "Collecting stacks for pid " + firstPids.get(i));
                timeTaken = ActivityManagerService.dumpJavaTracesTombstoned(firstPids.get(i), tracesFile, remainingTime);
                if ((remainingTime -= timeTaken) > 0L) continue;
                Slog.e("ActivityManager", "Aborting stack trace dump (current firstPid=" + firstPids.get(i) + "); deadline exceeded.");
                return;
            }
        }
        if (nativePids != null) {
            for (int pid : nativePids) {
                Slog.i("ActivityManager", "Collecting stacks for native pid " + pid);
                long nativeDumpTimeoutMs = Math.min(2000L, remainingTime);
                long start = SystemClock.elapsedRealtime();
                Debug.dumpNativeBacktraceToFileTimeout(pid, tracesFile, (int)(nativeDumpTimeoutMs / 1000L));
                long timeTaken2 = SystemClock.elapsedRealtime() - start;
                if ((remainingTime -= timeTaken2) > 0L) continue;
                Slog.e("ActivityManager", "Aborting stack trace dump (current native pid=" + pid + "); deadline exceeded.");
                return;
            }
        }
        if (extraPids != null) {
            for (int pid : extraPids) {
                Slog.i("ActivityManager", "Collecting stacks for extra pid " + pid);
                if ((remainingTime -= (timeTaken = ActivityManagerService.dumpJavaTracesTombstoned(pid, tracesFile, remainingTime))) > 0L) continue;
                Slog.e("ActivityManager", "Aborting stack trace dump (current extra pid=" + pid + "); deadline exceeded.");
                return;
            }
        }
        Slog.i("ActivityManager", "Done dumping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean clearApplicationUserData(String packageName, boolean keepState, final IPackageDataObserver observer, int userId) {
        boolean isInstantApp;
        ApplicationInfo appInfo;
        IPackageManager pm;
        int resolvedUserId;
        int pid;
        int uid;
        block19: {
            boolean bl;
            this.enforceNotIsolatedCaller("clearApplicationUserData");
            uid = Binder.getCallingUid();
            pid = Binder.getCallingPid();
            resolvedUserId = this.mUserController.handleIncomingUser(pid, uid, userId, false, 2, "clearApplicationUserData", null);
            long callingId = Binder.clearCallingIdentity();
            pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                boolean canAccessInstantApps;
                boolean clearingOwnUidData;
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.getPackageManagerInternalLocked().isPackageDataProtected(resolvedUserId, packageName)) {
                    throw new SecurityException("Cannot clear data for a protected package: " + packageName);
                }
                ApplicationInfo applicationInfo = null;
                try {
                    applicationInfo = pm.getApplicationInfo(packageName, 8192, resolvedUserId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                appInfo = applicationInfo;
                boolean bl2 = clearingOwnUidData = appInfo != null && appInfo.uid == uid;
                if (!clearingOwnUidData && ActivityManagerService.checkComponentPermission("android.permission.CLEAR_APP_USER_DATA", pid, uid, -1, true) != 0) {
                    throw new SecurityException("PID " + pid + " does not have permission " + "android.permission.CLEAR_APP_USER_DATA" + " to clear data of package " + packageName);
                }
                boolean hasInstantMetadata = this.getPackageManagerInternalLocked().hasInstantApplicationMetadata(packageName, resolvedUserId);
                boolean isUninstalledAppWithoutInstantMetadata = appInfo == null && !hasInstantMetadata;
                isInstantApp = appInfo != null && appInfo.isInstantApp() || hasInstantMetadata;
                boolean bl3 = canAccessInstantApps = ActivityManagerService.checkComponentPermission("android.permission.ACCESS_INSTANT_APPS", pid, uid, -1, true) == 0;
                if (!isUninstalledAppWithoutInstantMetadata && (!isInstantApp || canAccessInstantApps)) break block19;
                Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, false);
                    }
                    catch (RemoteException e) {
                        Slog.i("ActivityManager", "Observer no longer exists.");
                    }
                }
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (appInfo != null) {
            this.forceStopPackageLocked(packageName, appInfo.uid, "clear data");
            this.mAtmInternal.removeRecentTasksByPackageName(packageName, resolvedUserId);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        IPackageDataObserver.Stub localObserver = new IPackageDataObserver.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onRemoveCompleted(String packageName, boolean succeeded) throws RemoteException {
                if (appInfo != null) {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.finishForceStopPackageLocked(packageName, appInfo.uid);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
                Intent intent = new Intent("android.intent.action.PACKAGE_DATA_CLEARED", Uri.fromParts("package", packageName, null));
                intent.addFlags(0x1000000);
                intent.putExtra("android.intent.extra.UID", appInfo != null ? appInfo.uid : -1);
                intent.putExtra("android.intent.extra.user_handle", resolvedUserId);
                if (isInstantApp) {
                    intent.putExtra("android.intent.extra.PACKAGE_NAME", packageName);
                    ActivityManagerService.this.broadcastIntentInPackage("android", 1000, uid, pid, intent, null, null, 0, null, null, "android.permission.ACCESS_INSTANT_APPS", null, false, false, resolvedUserId, false);
                } else {
                    ActivityManagerService.this.broadcastIntentInPackage("android", 1000, uid, pid, intent, null, null, 0, null, null, null, null, false, false, resolvedUserId, false);
                }
                if (observer != null) {
                    observer.onRemoveCompleted(packageName, succeeded);
                }
            }
        };
        try {}
        catch (RemoteException remoteException) {
            // empty catch block
            return true;
        }
        {
            pm.clearApplicationUserData(packageName, localObserver, resolvedUserId);
            if (appInfo == null) return true;
            if (!keepState) {
                this.mUgmInternal.removeUriPermissionsForPackage(packageName, resolvedUserId, true, false);
                INotificationManager inm = NotificationManager.getService();
                inm.clearData(packageName, appInfo.uid, uid == appInfo.uid);
            }
            JobSchedulerInternal js = LocalServices.getService(JobSchedulerInternal.class);
            js.cancelJobsForUid(appInfo.uid, "clear data");
            AlarmManagerInternal ami = LocalServices.getService(AlarmManagerInternal.class);
            ami.removeAlarmsForUid(appInfo.uid);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killBackgroundProcesses(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0 && this.checkCallingPermission("android.permission.RESTART_PACKAGES") != 0) {
            String msg = "Permission Denial: killBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, "killBackgroundProcesses", null);
        int[] userIds = this.mUserController.expandUserId(userId);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            for (int targetUserId : userIds) {
                int appId = -1;
                try {
                    appId = UserHandle.getAppId(pm.getPackageUid(packageName, 0x10000000, targetUserId));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (appId == -1) {
                    Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                    return;
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        this.mProcessList.killPackageProcessesLocked(packageName, appId, targetUserId, 500, "kill background");
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 9] lbl34 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void killAllBackgroundProcesses() {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mAllowLowerMemLevel = true;
                    this.mProcessList.killPackageProcessesLocked(null, -1, -1, 900, "kill all background");
                    this.doLowMemReportIfNeededLocked(null);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl19 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void killAllBackgroundProcessesExcept(int minTargetSdk, int maxProcState) {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcessesExcept() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mProcessList.killAllBackgroundProcessesExceptLocked(minTargetSdk, maxProcState);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void forceStopPackage(String packageName, int userId) {
        long callingId;
        block18: {
            block19: {
                if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
                    String msg = "Permission Denial: forceStopPackage() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                int callingPid = Binder.getCallingPid();
                userId = this.mUserController.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, 2, "forceStopPackage", null);
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        int[] users;
                        int[] nArray;
                        ActivityManagerService.boostPriorityForLockedSection();
                        if (userId == -1) {
                            nArray = this.mUserController.getUsers();
                        } else {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = userId;
                        }
                        for (int user : users = nArray) {
                            if (this.getPackageManagerInternalLocked().isPackageStateProtected(packageName, user)) {
                                Slog.w("ActivityManager", "Ignoring request to force stop protected package " + packageName + " u" + user);
                                break block18;
                            }
                            int pkgUid = -1;
                            try {
                                pkgUid = pm.getPackageUid(packageName, 0x10000000, user);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            if (pkgUid == -1) {
                                Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                                continue;
                            }
                            try {
                                pm.setPackageStoppedState(packageName, true, user);
                            }
                            catch (RemoteException remoteException) {
                            }
                            catch (IllegalArgumentException e) {
                                Slog.w("ActivityManager", "Failed trying to unstop package " + packageName + ": " + e);
                            }
                            if (!this.mUserController.isUserRunning(user, 0)) continue;
                            this.forceStopPackageLocked(packageName, pkgUid, "from pid " + callingPid);
                            this.finishForceStopPackageLocked(packageName, pkgUid);
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    break block19;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 10] lbl56 : MonitorExitStatement: MONITOREXIT : var7_7
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(callingId);
            return;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        Binder.restoreCallingIdentity(callingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addPackageDependency(String packageName) {
        block8: {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int callingPid = Binder.getCallingPid();
                if (callingPid != android.os.Process.myPid()) break block8;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        PidMap pidMap = this.mPidsSelfLocked;
        // MONITORENTER : pidMap
        ProcessRecord proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
        // MONITOREXIT : pidMap
        if (proc != null) {
            if (proc.pkgDeps == null) {
                proc.pkgDeps = new ArraySet(1);
            }
            proc.pkgDeps.add(packageName);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void killApplication(String pkg, int appId, int userId, String reason) {
        if (pkg == null) {
            return;
        }
        if (appId < 0) {
            Slog.w("ActivityManager", "Invalid appid specified for pkg : " + pkg);
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callerUid) != 1000) {
            throw new SecurityException(callerUid + " cannot kill pkg: " + pkg);
        }
        Message msg = this.mHandler.obtainMessage(22);
        msg.arg1 = appId;
        msg.arg2 = userId;
        Bundle bundle = new Bundle();
        bundle.putString("pkg", pkg);
        bundle.putString("reason", reason);
        msg.obj = bundle;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void closeSystemDialogs(String reason) {
        this.mAtmInternal.closeSystemDialogs(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessMemoryInfo");
        long now = SystemClock.uptimeMillis();
        long lastNow = now - this.mConstants.MEMORY_INFO_THROTTLE_TIME;
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        boolean allUids = this.mAtmInternal.isGetTasksAllowed("getProcessMemoryInfo", callingPid, callingUid);
        Debug.MemoryInfo[] infos = new Debug.MemoryInfo[pids.length];
        int i = pids.length - 1;
        while (i >= 0) {
            int targetUserId;
            int oomAdj;
            ProcessRecord proc;
            infos[i] = new Debug.MemoryInfo();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    PidMap pidMap = this.mPidsSelfLocked;
                    synchronized (pidMap) {
                        proc = this.mPidsSelfLocked.get(pids[i]);
                        oomAdj = proc != null ? proc.setAdj : 0;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 8] lbl27 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            int targetUid = proc != null ? proc.uid : -1;
            int n = targetUserId = proc != null ? UserHandle.getUserId(targetUid) : -1;
            if (callingUid == targetUid || allUids && (allUsers || targetUserId == callingUserId)) {
                if (proc != null && proc.lastMemInfoTime >= lastNow && proc.lastMemInfo != null) {
                    infos[i].set(proc.lastMemInfo);
                } else {
                    long startTime = SystemClock.currentThreadTimeMillis();
                    Debug.MemoryInfo memInfo = new Debug.MemoryInfo();
                    Debug.getMemoryInfo(pids[i], memInfo);
                    long endTime = SystemClock.currentThreadTimeMillis();
                    infos[i].set(memInfo);
                    if (proc != null) {
                        ActivityManagerService activityManagerService2 = this;
                        synchronized (activityManagerService2) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                proc.lastMemInfo = memInfo;
                                proc.lastMemInfoTime = SystemClock.uptimeMillis();
                                if (proc.thread != null && proc.setAdj == oomAdj) {
                                    proc.baseProcessTracker.addPss(infos[i].getTotalPss(), infos[i].getTotalUss(), infos[i].getTotalRss(), false, 4, endTime - startTime, proc.pkgList.mPkgList);
                                    for (int ipkg = proc.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                                        ProcessStats.ProcessStateHolder holder = proc.pkgList.valueAt(ipkg);
                                        StatsLog.write(18, proc.info.uid, holder.state.getName(), holder.state.getPackage(), (long)infos[i].getTotalPss(), (long)infos[i].getTotalUss(), (long)infos[i].getTotalRss(), 4, endTime - startTime, holder.appVersion);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[5, 7, 8, 12, 13, 15] lbl59 : MonitorExitStatement: MONITOREXIT : var22_20
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                }
            }
            --i;
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] getProcessPss(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessPss");
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(callingUid);
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        boolean allUids = this.mAtmInternal.isGetTasksAllowed("getProcessPss", callingPid, callingUid);
        long[] pss = new long[pids.length];
        int i = pids.length - 1;
        while (i >= 0) {
            int oomAdj;
            ProcessRecord proc;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    PidMap pidMap = this.mPidsSelfLocked;
                    synchronized (pidMap) {
                        proc = this.mPidsSelfLocked.get(pids[i]);
                        oomAdj = proc != null ? proc.setAdj : 0;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 8] lbl24 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            if (allUids && (allUsers || UserHandle.getUserId(proc.uid) == userId)) {
                long[] tmpUss = new long[3];
                long startTime = SystemClock.currentThreadTimeMillis();
                pss[i] = Debug.getPss(pids[i], tmpUss, null);
                long endTime = SystemClock.currentThreadTimeMillis();
                if (proc != null) {
                    ActivityManagerService activityManagerService2 = this;
                    synchronized (activityManagerService2) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (proc.thread != null && proc.setAdj == oomAdj) {
                                proc.baseProcessTracker.addPss(pss[i], tmpUss[0], tmpUss[2], false, 3, endTime - startTime, proc.pkgList.mPkgList);
                                for (int ipkg = proc.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                                    ProcessStats.ProcessStateHolder holder = proc.pkgList.valueAt(ipkg);
                                    StatsLog.write(18, proc.info.uid, holder.state.getName(), holder.state.getPackage(), pss[i], tmpUss[0], tmpUss[2], 3, endTime - startTime, holder.appVersion);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[5, 7, 8, 12, 13] lbl48 : MonitorExitStatement: MONITOREXIT : activityManagerService2
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
            }
            --i;
        }
        return pss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killApplicationProcess(String processName, int uid) {
        block9: {
            int callerUid;
            block8: {
                if (processName == null) {
                    return;
                }
                callerUid = Binder.getCallingUid();
                if (callerUid != 1000) break block8;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        ProcessRecord app = this.getProcessRecordLocked(processName, uid, true);
                        if (app != null && app.thread != null) {
                            try {
                                app.thread.scheduleSuicide();
                            }
                            catch (RemoteException remoteException) {}
                        } else {
                            Slog.w("ActivityManager", "Process/uid not found attempting kill of " + processName + " / " + uid);
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var4_4
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    break block9;
                }
            }
            throw new SecurityException(callerUid + " cannot kill app process: " + processName);
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    private void forceStopPackageLocked(String packageName, int uid, String reason) {
        this.forceStopPackageLocked(packageName, UserHandle.getAppId(uid), false, false, true, false, false, UserHandle.getUserId(uid), reason);
    }

    @GuardedBy(value={"this"})
    private void finishForceStopPackageLocked(String packageName, int uid) {
        Intent intent = new Intent("android.intent.action.PACKAGE_RESTARTED", Uri.fromParts("package", packageName, null));
        if (!this.mProcessesReady) {
            intent.addFlags(0x50000000);
        }
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.intent.extra.user_handle", UserHandle.getUserId(uid));
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getUserId(uid));
    }

    private void cleanupDisabledPackageComponentsLocked(String packageName, int userId, String[] changedClasses) {
        int i;
        ArraySet<String> disabledClasses = null;
        boolean packageDisabled = false;
        IPackageManager pm = AppGlobals.getPackageManager();
        if (changedClasses == null) {
            return;
        }
        int enabled = 0;
        for (int i2 = changedClasses.length - 1; i2 >= 0; --i2) {
            String changedClass = changedClasses[i2];
            if (changedClass.equals(packageName)) {
                try {
                    enabled = pm.getApplicationEnabledSetting(packageName, userId != -1 ? userId : 0);
                }
                catch (Exception e) {
                    return;
                }
                boolean bl = packageDisabled = enabled != 1 && enabled != 0;
                if (!packageDisabled) continue;
                disabledClasses = null;
                break;
            }
            try {
                enabled = pm.getComponentEnabledSetting(new ComponentName(packageName, changedClass), userId != -1 ? userId : 0);
            }
            catch (Exception e) {
                return;
            }
            if (enabled == 1 || enabled == 0) continue;
            if (disabledClasses == null) {
                disabledClasses = new ArraySet<String>(changedClasses.length);
            }
            disabledClasses.add(changedClass);
        }
        if (!packageDisabled && disabledClasses == null) {
            return;
        }
        this.mAtmInternal.cleanupDisabledPackageComponents(packageName, disabledClasses, userId, this.mBooted);
        this.mServices.bringDownDisabledPackageServicesLocked(packageName, disabledClasses, userId, false, true);
        ArrayList<ContentProviderRecord> providers = new ArrayList<ContentProviderRecord>();
        this.mProviderMap.collectPackageProvidersLocked(packageName, (Set<String>)disabledClasses, true, false, userId, providers);
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
            this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, disabledClasses, userId, true);
        }
    }

    final boolean clearBroadcastQueueForUserLocked(int userId) {
        boolean didSomething = false;
        for (int i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
            didSomething |= this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(null, null, userId, true);
        }
        return didSomething;
    }

    @GuardedBy(value={"this"})
    final boolean forceStopPackageLocked(String packageName, int appId, boolean callerWillRestart, boolean purgeCache, boolean doit, boolean evenPersistent, boolean uninstalling, int userId, String reason) {
        int i;
        ArrayList<ContentProviderRecord> providers;
        if (userId == -1 && packageName == null) {
            Slog.w("ActivityManager", "Can't force stop all processes of all users, that is insane!");
        }
        if (appId < 0 && packageName != null) {
            try {
                appId = UserHandle.getAppId(AppGlobals.getPackageManager().getPackageUid(packageName, 0x10000000, 0));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (doit) {
            if (packageName != null) {
                Slog.i("ActivityManager", "Force stopping " + packageName + " appid=" + appId + " user=" + userId + ": " + reason);
            } else {
                Slog.i("ActivityManager", "Force stopping u" + userId + ": " + reason);
            }
            this.mAppErrors.resetProcessCrashTimeLocked(packageName == null, appId, userId);
        }
        boolean didSomething = this.mProcessList.killPackageProcessesLocked(packageName, appId, userId, -10000, callerWillRestart, true, doit, evenPersistent, true, packageName == null ? "stop user " + userId : "stop " + packageName);
        didSomething |= this.mAtmInternal.onForceStopPackage(packageName, doit, evenPersistent, userId);
        if (this.mServices.bringDownDisabledPackageServicesLocked(packageName, null, userId, evenPersistent, doit)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (packageName == null) {
            this.mStickyBroadcasts.remove(userId);
        }
        if (this.mProviderMap.collectPackageProvidersLocked(packageName, null, doit, evenPersistent, userId, providers = new ArrayList<ContentProviderRecord>())) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        this.mUgmInternal.removeUriPermissionsForPackage(packageName, userId, false, false);
        if (doit) {
            for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
                didSomething |= this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, null, userId, doit);
            }
        }
        if (packageName == null || uninstalling) {
            didSomething |= this.mPendingIntentController.removePendingIntentsForPackage(packageName, userId, appId, doit);
        }
        if (doit) {
            AttributeCache ac;
            if (purgeCache && packageName != null && (ac = AttributeCache.instance()) != null) {
                ac.removePackage(packageName);
            }
            if (this.mBooted) {
                this.mAtmInternal.resumeTopActivities(true);
            }
        }
        return didSomething;
    }

    @GuardedBy(value={"this"})
    private final void processContentProviderPublishTimedOutLocked(ProcessRecord app) {
        this.cleanupAppInLaunchingProvidersLocked(app, true);
        this.mProcessList.removeProcessLocked(app, false, true, "timeout publishing content providers");
    }

    @GuardedBy(value={"this"})
    private final void processStartTimedOutLocked(final ProcessRecord app) {
        int pid = app.pid;
        boolean gone = this.mPidsSelfLocked.removeIfNoThread(app);
        if (gone) {
            Slog.w("ActivityManager", "Process " + app + " failed to attach");
            EventLog.writeEvent(30037, app.userId, pid, app.uid, app.processName);
            this.mProcessList.removeProcessNameLocked(app.processName, app.uid);
            this.mAtmInternal.clearHeavyWeightProcessIfEquals(app.getWindowProcessController());
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            this.cleanupAppInLaunchingProvidersLocked(app, true);
            this.mServices.processStartTimedOutLocked(app);
            app.kill("start timeout", true);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            this.removeLruProcessLocked(app);
            BackupRecord backupTarget = this.mBackupTargets.get(app.userId);
            if (backupTarget != null && backupTarget.app.pid == pid) {
                Slog.w("ActivityManager", "Unattached app died before backup, skipping");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                            bm.agentDisconnectedForUser(app.userId, app.info.packageName);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            if (this.isPendingBroadcastProcessLocked(pid)) {
                Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
                this.skipPendingBroadcastLocked(pid);
            }
        } else {
            Slog.w("ActivityManager", "Spurious process start timeout - pid not known for " + app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    private final boolean attachApplicationLocked(IApplicationThread thread, int pid, int callingUid, long startSeq) {
        long bindApplicationTimeMillis;
        List<ProviderInfo> providers;
        ProcessRecord pending3;
        String processName;
        ProcessRecord app;
        long startTime = SystemClock.uptimeMillis();
        if (pid != MY_PID && pid >= 0) {
            PidMap pidMap = this.mPidsSelfLocked;
            synchronized (pidMap) {
                app = this.mPidsSelfLocked.get(pid);
            }
            if (app != null && (app.startUid != callingUid || app.startSeq != startSeq)) {
                processName = null;
                ProcessRecord pending2 = this.mProcessList.mPendingStarts.get(startSeq);
                if (pending2 != null) {
                    processName = pending2.processName;
                }
                String msg = "attachApplicationLocked process:" + processName + " startSeq:" + startSeq + " pid:" + pid + " belongs to another existing app:" + app.processName + " startSeq:" + app.startSeq;
                Slog.wtf("ActivityManager", msg);
                EventLog.writeEvent(1397638484, "131105245", app.startUid, msg);
                this.cleanUpApplicationRecordLocked(app, false, false, -1, true);
                this.mPidsSelfLocked.remove(app);
                app = null;
            }
        } else {
            app = null;
        }
        if (app == null && startSeq > 0L && (pending3 = this.mProcessList.mPendingStarts.get(startSeq)) != null && pending3.startUid == callingUid && pending3.startSeq == startSeq && this.mProcessList.handleProcessStartedLocked(pending3, pid, pending3.isUsingWrapper(), startSeq, true)) {
            app = pending3;
        }
        if (app == null) {
            Slog.w("ActivityManager", "No pending application record for pid " + pid + " (IApplicationThread " + thread + "); dropping process");
            EventLog.writeEvent(30033, pid);
            if (pid > 0 && pid != MY_PID) {
                android.os.Process.killProcessQuiet(pid);
            } else {
                try {
                    thread.scheduleExit();
                }
                catch (Exception pending3) {
                    // empty catch block
                }
            }
            return false;
        }
        if (app.thread != null) {
            this.handleAppDiedLocked(app, true, true);
        }
        processName = app.processName;
        try {
            AppDeathRecipient adr = new AppDeathRecipient(app, pid, thread);
            thread.asBinder().linkToDeath(adr, 0);
            app.deathRecipient = adr;
        }
        catch (RemoteException e) {
            app.resetPackageList(this.mProcessStats);
            this.mProcessList.startProcessLocked(app, new HostingRecord("link fail", processName));
            return false;
        }
        EventLog.writeEvent(30010, app.userId, app.pid, app.processName);
        app.verifiedAdj = -10000;
        app.setAdj = -10000;
        app.curAdj = -10000;
        app.setSchedGroup = 2;
        app.setCurrentSchedulingGroup(2);
        app.forcingToImportant = null;
        this.updateProcessForegroundLocked(app, false, 0, false);
        app.hasShownUi = false;
        app.setDebugging(false);
        app.cached = false;
        app.killedByAm = false;
        app.killed = false;
        app.unlocked = StorageManager.isUserKeyUnlocked(app.userId);
        this.mHandler.removeMessages(20, app);
        boolean normalMode = this.mProcessesReady || this.isAllowedWhileBooting(app.info);
        List<ProviderInfo> list = providers = normalMode ? this.generateApplicationProvidersLocked(app) : null;
        if (providers != null && this.checkAppInLaunchingProvidersLocked(app)) {
            Message msg = this.mHandler.obtainMessage(57);
            msg.obj = app;
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
        this.checkTime(startTime, "attachApplicationLocked: before bindApplication");
        if (!normalMode) {
            Slog.i("ActivityManager", "Launching preboot mode app: " + app);
        }
        BackupRecord backupTarget = this.mBackupTargets.get(app.userId);
        try {
            ContentCaptureManagerInternal ccm;
            AutofillManagerInternal afm;
            String buildSerial;
            ActiveInstrumentation instr;
            int testMode = 0;
            if (this.mDebugApp != null && this.mDebugApp.equals(processName)) {
                testMode = this.mWaitForDebugger ? 2 : 1;
                app.setDebugging(true);
                if (this.mDebugTransient) {
                    this.mDebugApp = this.mOrigDebugApp;
                    this.mWaitForDebugger = this.mOrigWaitForDebugger;
                }
            }
            boolean enableTrackAllocation = false;
            if (this.mTrackAllocationApp != null && this.mTrackAllocationApp.equals(processName)) {
                enableTrackAllocation = true;
                this.mTrackAllocationApp = null;
            }
            boolean isRestrictedBackupMode = false;
            if (backupTarget != null && backupTarget.appInfo.packageName.equals(processName)) {
                boolean bl = isRestrictedBackupMode = backupTarget.appInfo.uid >= 10000 && (backupTarget.backupMode == 2 || backupTarget.backupMode == 3 || backupTarget.backupMode == 1);
            }
            if ((instr = app.getActiveInstrumentation()) != null) {
                this.notifyPackageUse(instr.mClass.getPackageName(), 7);
            }
            ApplicationInfo appInfo = instr != null ? instr.mTargetInfo : app.info;
            app.compat = this.compatibilityInfoForPackage(appInfo);
            ProfilerInfo profilerInfo = null;
            String preBindAgent = null;
            if (this.mProfileData.getProfileApp() != null && this.mProfileData.getProfileApp().equals(processName)) {
                this.mProfileData.setProfileProc(app);
                if (this.mProfileData.getProfilerInfo() != null) {
                    boolean needsInfo = this.mProfileData.getProfilerInfo().profileFile != null || this.mProfileData.getProfilerInfo().attachAgentDuringBind;
                    ProfilerInfo profilerInfo2 = profilerInfo = needsInfo ? new ProfilerInfo(this.mProfileData.getProfilerInfo()) : null;
                    if (this.mProfileData.getProfilerInfo().agent != null) {
                        preBindAgent = this.mProfileData.getProfilerInfo().agent;
                    }
                }
            } else if (instr != null && instr.mProfileFile != null) {
                profilerInfo = new ProfilerInfo(instr.mProfileFile, null, 0, false, false, null, false);
            }
            if (this.mAppAgentMap != null && this.mAppAgentMap.containsKey(processName) && (app.info.flags & 2) != 0) {
                String agent = this.mAppAgentMap.get(processName);
                if (profilerInfo == null) {
                    profilerInfo = new ProfilerInfo(null, null, 0, false, false, this.mAppAgentMap.get(processName), true);
                } else if (profilerInfo.agent == null) {
                    profilerInfo = profilerInfo.setAgent(this.mAppAgentMap.get(processName), true);
                }
            }
            if (profilerInfo != null && profilerInfo.profileFd != null) {
                profilerInfo.profileFd = profilerInfo.profileFd.dup();
                if (TextUtils.equals(this.mProfileData.getProfileApp(), processName) && this.mProfileData.getProfilerInfo() != null) {
                    this.clearProfilerLocked();
                }
            }
            String string2 = buildSerial = !appInfo.isInstantApp() && appInfo.targetSdkVersion < 28 ? sTheRealBuildSerial : "unknown";
            if (this.mActiveInstrumentation.size() > 0 && instr == null) {
                block17: for (int i = this.mActiveInstrumentation.size() - 1; i >= 0 && app.getActiveInstrumentation() == null; --i) {
                    ActiveInstrumentation aInstr = this.mActiveInstrumentation.get(i);
                    if (aInstr.mFinished || aInstr.mTargetInfo.uid != app.uid) continue;
                    if (aInstr.mTargetProcesses.length == 0) {
                        if (!aInstr.mTargetInfo.packageName.equals(app.info.packageName)) continue;
                        app.setActiveInstrumentation(aInstr);
                        aInstr.mRunningProcesses.add(app);
                        continue;
                    }
                    for (String proc : aInstr.mTargetProcesses) {
                        if (!proc.equals(app.processName)) continue;
                        app.setActiveInstrumentation(aInstr);
                        aInstr.mRunningProcesses.add(app);
                        continue block17;
                    }
                }
            }
            if (preBindAgent != null) {
                thread.attachAgent(preBindAgent);
            }
            AutofillOptions autofillOptions = null;
            if (UserHandle.getAppId(app.info.uid) >= 10000 && (afm = LocalServices.getService(AutofillManagerInternal.class)) != null) {
                autofillOptions = afm.getAutofillOptions(app.info.packageName, app.info.longVersionCode, app.userId);
            }
            ContentCaptureOptions contentCaptureOptions = null;
            if (UserHandle.getAppId(app.info.uid) >= 10000 && (ccm = LocalServices.getService(ContentCaptureManagerInternal.class)) != null) {
                contentCaptureOptions = ccm.getOptionsForPackage(app.userId, app.info.packageName);
            }
            this.checkTime(startTime, "attachApplicationLocked: immediately before bindApplication");
            bindApplicationTimeMillis = SystemClock.elapsedRealtime();
            this.mAtmInternal.preBindApplication(app.getWindowProcessController());
            ActiveInstrumentation instr2 = app.getActiveInstrumentation();
            if (app.isolatedEntryPoint != null) {
                thread.runIsolatedEntryPoint(app.isolatedEntryPoint, app.isolatedEntryPointArgs);
            } else if (instr2 != null) {
                thread.bindApplication(processName, appInfo, providers, instr2.mClass, profilerInfo, instr2.mArguments, instr2.mWatcher, instr2.mUiAutomationConnection, testMode, this.mBinderTransactionTrackingEnabled, enableTrackAllocation, isRestrictedBackupMode || !normalMode, app.isPersistent(), new Configuration(app.getWindowProcessController().getConfiguration()), app.compat, this.getCommonServicesLocked(app.isolated), this.mCoreSettingsObserver.getCoreSettingsLocked(), buildSerial, autofillOptions, contentCaptureOptions);
            } else {
                thread.bindApplication(processName, appInfo, providers, null, profilerInfo, null, null, null, testMode, this.mBinderTransactionTrackingEnabled, enableTrackAllocation, isRestrictedBackupMode || !normalMode, app.isPersistent(), new Configuration(app.getWindowProcessController().getConfiguration()), app.compat, this.getCommonServicesLocked(app.isolated), this.mCoreSettingsObserver.getCoreSettingsLocked(), buildSerial, autofillOptions, contentCaptureOptions);
            }
            if (profilerInfo != null) {
                profilerInfo.closeFd();
                profilerInfo = null;
            }
            app.makeActive(thread, this.mProcessStats);
            this.checkTime(startTime, "attachApplicationLocked: immediately after bindApplication");
            this.mProcessList.updateLruProcessLocked(app, false, null);
            this.checkTime(startTime, "attachApplicationLocked: after updateLruProcessLocked");
            app.lastRequestedGc = app.lastLowMemory = SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            Slog.wtf("ActivityManager", "Exception thrown during bind of " + app, e);
            app.resetPackageList(this.mProcessStats);
            app.unlinkDeathRecipient();
            this.mProcessList.startProcessLocked(app, new HostingRecord("bind-fail", processName));
            return false;
        }
        this.mPersistentStartingProcesses.remove(app);
        this.mProcessesOnHold.remove(app);
        boolean badApp = false;
        boolean didSomething = false;
        if (normalMode) {
            try {
                didSomething = this.mAtmInternal.attachApplication(app.getWindowProcessController());
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown launching activities in " + app, e);
                badApp = true;
            }
        }
        if (!badApp) {
            try {
                didSomething |= this.mServices.attachApplicationLocked(app, processName);
                this.checkTime(startTime, "attachApplicationLocked: after mServices.attachApplicationLocked");
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown starting services in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && this.isPendingBroadcastProcessLocked(pid)) {
            try {
                didSomething |= this.sendPendingBroadcastsLocked(app);
                this.checkTime(startTime, "attachApplicationLocked: after sendPendingBroadcastsLocked");
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown dispatching broadcasts in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && backupTarget != null && backupTarget.app == app) {
            this.notifyPackageUse(backupTarget.appInfo.packageName, 5);
            try {
                thread.scheduleCreateBackupAgent(backupTarget.appInfo, this.compatibilityInfoForPackage(backupTarget.appInfo), backupTarget.backupMode, backupTarget.userId);
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown creating backup agent in " + app, e);
                badApp = true;
            }
        }
        if (badApp) {
            app.kill("error during init", true);
            this.handleAppDiedLocked(app, false, true);
            return false;
        }
        if (!didSomething) {
            this.updateOomAdjLocked("updateOomAdj_processBegin");
            this.checkTime(startTime, "attachApplicationLocked: after updateOomAdjLocked");
        }
        StatsLog.write(169, app.info.uid, app.pid, app.info.packageName, 3, app.startTime, (int)(bindApplicationTimeMillis - app.startTime), (int)(SystemClock.elapsedRealtime() - app.startTime), app.hostingRecord.getType(), app.hostingRecord.getName() != null ? app.hostingRecord.getName() : "");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachApplication(IApplicationThread thread, long startSeq) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long origId = Binder.clearCallingIdentity();
                this.attachApplicationLocked(thread, callingPid, callingUid, startSeq);
                Binder.restoreCallingIdentity(origId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var4_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void showBootMessage(CharSequence msg, boolean always) {
        if (Binder.getCallingUid() != android.os.Process.myUid()) {
            throw new SecurityException();
        }
        this.mWindowManager.showBootMessage(msg, always);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void finishBooting() {
        block18: {
            block16: {
                Trace.traceBegin(64L, "FinishBooting");
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (this.mBootAnimationComplete) break block16;
                    this.mCallFinishBooting = true;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            this.mCallFinishBooting = false;
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            ArraySet<String> completedIsas = new ArraySet<String>();
            String[] stringArray = Build.SUPPORTED_ABIS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String instructionSet;
                block17: {
                    String abi = stringArray[i];
                    android.os.Process.ZYGOTE_PROCESS.establishZygoteConnectionForAbi(abi);
                    instructionSet = VMRuntime.getInstructionSet(abi);
                    if (completedIsas.contains(instructionSet)) continue;
                    try {
                        this.mInstaller.markBootComplete(VMRuntime.getInstructionSet(abi));
                    }
                    catch (Installer.InstallerException e) {
                        if (VMRuntime.didPruneDalvikCache()) break block17;
                        Slog.w("ActivityManager", "Unable to mark boot complete for abi: " + abi + " (" + e.getMessage() + ")");
                    }
                }
                completedIsas.add(instructionSet);
            }
            IntentFilter pkgFilter = new IntentFilter();
            pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            pkgFilter.addDataScheme("package");
            this.mContext.registerReceiver(new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onReceive(Context context, Intent intent) {
                    block6: {
                        String[] pkgs = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                        if (pkgs == null) break block6;
                        for (String pkg : pkgs) {
                            block7: {
                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                synchronized (activityManagerService) {
                                    try {
                                        ActivityManagerService.boostPriorityForLockedSection();
                                        if (ActivityManagerService.this.forceStopPackageLocked(pkg, -1, false, false, false, false, false, 0, "query restart")) {
                                            this.setResultCode(-1);
                                        }
                                        break block7;
                                    }
                                    catch (Throwable throwable) {
                                        // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var8_8
                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                        throw throwable;
                                    }
                                }
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                return;
                            }
                            ActivityManagerService.resetPriorityAfterLockedSection();
                        }
                    }
                }
            }, pkgFilter);
            IntentFilter dumpheapFilter = new IntentFilter();
            dumpheapFilter.addAction("com.android.server.am.DELETE_DUMPHEAP");
            this.mContext.registerReceiver(new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    long delay = intent.getBooleanExtra("delay_delete", false) ? 300000L : 0L;
                    ActivityManagerService.this.mHandler.sendEmptyMessageDelayed(51, delay);
                }
            }, dumpheapFilter);
            try {
                IStorageManager storageManager = PackageHelper.getStorageManager();
                storageManager.commitChanges();
            }
            catch (Exception e) {
                PowerManager pm = (PowerManager)this.mInjector.getContext().getSystemService("power");
                pm.reboot("Checkpoint commit failed");
            }
            this.mSystemServiceManager.startBootPhase(1000);
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int NP = this.mProcessesOnHold.size();
                if (NP > 0) {
                    ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>(this.mProcessesOnHold);
                    for (int ip = 0; ip < NP; ++ip) {
                        this.mProcessList.startProcessLocked(procs.get(ip), new HostingRecord("on-hold"));
                    }
                }
                if (this.mFactoryTest != 1) break block18;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Message nmsg = this.mHandler.obtainMessage(27);
        this.mHandler.sendMessageDelayed(nmsg, this.mConstants.POWER_CHECK_INTERVAL);
        SystemProperties.set("sys.boot_completed", "1");
        if (!"trigger_restart_min_framework".equals(VoldProperties.decrypt().orElse("")) || "".equals(VoldProperties.encrypt_progress().orElse(""))) {
            SystemProperties.set("dev.bootcomplete", "1");
        }
        this.mUserController.sendBootCompleted(new IIntentReceiver.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                ActivityManagerService activityManagerService = ActivityManagerService.this;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        ActivityManagerService.this.mOomAdjuster.mAppCompact.compactAllSystem();
                        ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var8_8
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
        });
        this.mUserController.scheduleStartProfiles();
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        Trace.traceEnd(64L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootAnimationComplete() {
        boolean callFinishBooting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                callFinishBooting = this.mCallFinishBooting;
                this.mBootAnimationComplete = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (callFinishBooting) {
            this.finishBooting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureBootCompleted() {
        boolean enableScreen;
        boolean booting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                booting = this.mBooting;
                this.mBooting = false;
                enableScreen = !this.mBooted;
                this.mBooted = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (booting) {
            this.finishBooting();
        }
        if (enableScreen) {
            this.mAtmInternal.enableScreenAfterBoot(this.mBooted);
        }
    }

    @Override
    public IIntentSender getIntentSender(int type, String packageName, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle bOptions, int userId) {
        this.enforceNotIsolatedCaller("getIntentSender");
        if (intents != null) {
            if (intents.length < 1) {
                throw new IllegalArgumentException("Intents array length must be >= 1");
            }
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null) continue;
                if (intent.hasFileDescriptors()) {
                    throw new IllegalArgumentException("File descriptors passed in Intent");
                }
                if (type == 1 && (intent.getFlags() & 0x2000000) != 0) {
                    throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
                }
                intents[i] = new Intent(intent);
            }
            if (resolvedTypes != null && resolvedTypes.length != intents.length) {
                throw new IllegalArgumentException("Intent array length does not match resolvedTypes length");
            }
        }
        if (bOptions != null && bOptions.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in options");
        }
        int callingUid = Binder.getCallingUid();
        int origUserId = userId;
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, type == 1, 0, "getIntentSender", null);
        if (origUserId == -2) {
            userId = -2;
        }
        try {
            int uid;
            if (callingUid != 0 && callingUid != 1000 && !UserHandle.isSameApp(callingUid, uid = AppGlobals.getPackageManager().getPackageUid(packageName, 0x10000000, UserHandle.getUserId(callingUid)))) {
                String msg = "Permission Denial: getIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + ", (need uid=" + uid + ") is not allowed to send as package " + packageName;
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            if (type == 3) {
                return this.mAtmInternal.getIntentSender(type, packageName, callingUid, userId, token, resultWho, requestCode, intents, resolvedTypes, flags, bOptions);
            }
            return this.mPendingIntentController.getIntentSender(type, packageName, callingUid, userId, token, resultWho, requestCode, intents, resolvedTypes, flags, bOptions);
        }
        catch (RemoteException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public int sendIntentSender(IIntentSender target, IBinder whitelistToken, int code, Intent intent, String resolvedType, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
        if (target instanceof PendingIntentRecord) {
            return ((PendingIntentRecord)target).sendWithResult(code, intent, resolvedType, whitelistToken, finishedReceiver, requiredPermission, options);
        }
        if (intent == null) {
            Slog.wtf("ActivityManager", "Can't use null intent with direct IIntentSender call");
            intent = new Intent("android.intent.action.MAIN");
        }
        try {
            target.send(code, intent, resolvedType, whitelistToken, null, requiredPermission, options);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (finishedReceiver != null) {
            try {
                finishedReceiver.performReceive(intent, 0, null, null, false, false, UserHandle.getCallingUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public void cancelIntentSender(IIntentSender sender) {
        this.mPendingIntentController.cancelIntentSender(sender);
    }

    @Override
    public String getPackageForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.packageName;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public void registerIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        this.mPendingIntentController.registerIntentSenderCancelListener(sender, receiver);
    }

    @Override
    public void unregisterIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        this.mPendingIntentController.unregisterIntentSenderCancelListener(sender, receiver);
    }

    @Override
    public int getUidForIntentSender(IIntentSender sender) {
        if (sender instanceof PendingIntentRecord) {
            try {
                PendingIntentRecord res = (PendingIntentRecord)sender;
                return res.uid;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public boolean isIntentSenderTargetedToPackage(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            if (res.key.allIntents == null) {
                return false;
            }
            for (int i = 0; i < res.key.allIntents.length; ++i) {
                Intent intent = res.key.allIntents[i];
                if (intent.getPackage() == null || intent.getComponent() == null) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isIntentSenderAnActivity(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 2;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isIntentSenderAForegroundService(IIntentSender pendingResult) {
        if (pendingResult instanceof PendingIntentRecord) {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 5;
        }
        return false;
    }

    @Override
    public boolean isIntentSenderABroadcast(IIntentSender pendingResult) {
        if (pendingResult instanceof PendingIntentRecord) {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 1;
        }
        return false;
    }

    @Override
    public Intent getIntentForIntentSender(IIntentSender pendingResult) {
        this.enforceCallingPermission("android.permission.GET_INTENT_SENDER_INTENT", "getIntentForIntentSender()");
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.requestIntent != null ? new Intent(res.key.requestIntent) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getTagForIntentSender(IIntentSender pendingResult, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String getTagForIntentSenderLocked(PendingIntentRecord res, String prefix) {
        Intent intent = res.key.requestIntent;
        if (intent != null) {
            if (res.lastTag != null && res.lastTagPrefix == prefix && (res.lastTagPrefix == null || res.lastTagPrefix.equals(prefix))) {
                return res.lastTag;
            }
            res.lastTagPrefix = prefix;
            StringBuilder sb = new StringBuilder(128);
            if (prefix != null) {
                sb.append(prefix);
            }
            if (intent.getAction() != null) {
                sb.append(intent.getAction());
            } else if (intent.getComponent() != null) {
                intent.getComponent().appendShortString(sb);
            } else {
                sb.append("?");
            }
            res.lastTag = sb.toString();
            return res.lastTag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessLimit(int max) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessLimit()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mConstants.setOverrideMaxCachedProcesses(max);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        this.trimApplications("updateOomAdj_processEnd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getProcessLimit() {
        int n;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mConstants.getOverrideMaxCachedProcesses();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void importanceTokenDied(ImportanceToken token) {
        block9: {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                PidMap pidMap = this.mPidsSelfLocked;
                // MONITORENTER : pidMap
                ImportanceToken cur = this.mImportantProcesses.get(token.pid);
                if (cur == token) break block9;
                // MONITOREXIT : pidMap
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mImportantProcesses.remove(token.pid);
        ProcessRecord pr = this.mPidsSelfLocked.get(token.pid);
        if (pr == null) {
            // MONITOREXIT : pidMap
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        pr.forcingToImportant = null;
        this.updateProcessForegroundLocked(pr, false, 0, false);
        // MONITOREXIT : pidMap
        this.updateOomAdjLocked("updateOomAdj_uiVisibility");
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setProcessImportant(IBinder token, int pid, boolean isForeground, String reason) {
        ProcessRecord pr;
        boolean changed;
        block13: {
            this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessImportant()");
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                changed = false;
                PidMap pidMap = this.mPidsSelfLocked;
                // MONITORENTER : pidMap
                pr = this.mPidsSelfLocked.get(pid);
                if (pr != null || !isForeground) break block13;
                Slog.w("ActivityManager", "setProcessForeground called on unknown pid: " + pid);
                // MONITOREXIT : pidMap
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ImportanceToken oldToken = this.mImportantProcesses.get(pid);
        if (oldToken != null) {
            oldToken.token.unlinkToDeath(oldToken, 0);
            this.mImportantProcesses.remove(pid);
            if (pr != null) {
                pr.forcingToImportant = null;
            }
            changed = true;
        }
        if (isForeground && token != null) {
            ImportanceToken newToken = new ImportanceToken(pid, token, reason){

                @Override
                public void binderDied() {
                    ActivityManagerService.this.importanceTokenDied(this);
                }
            };
            try {
                token.linkToDeath(newToken, 0);
                this.mImportantProcesses.put(pid, newToken);
                pr.forcingToImportant = newToken;
                changed = true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        // MONITOREXIT : pidMap
        if (changed) {
            this.updateOomAdjLocked("updateOomAdj_uiVisibility");
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean isAppForeground(int uid) {
        UidRecord uidRec;
        block4: {
            boolean bl;
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                uidRec = this.mProcessList.mActiveUids.get(uid);
                if (uidRec != null && !uidRec.idle) break block4;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        boolean bl = uidRec.getCurProcState() <= 7;
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAppBad(ApplicationInfo info) {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.mAppErrors.isBadProcessLocked(info);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getUidState(int uid) {
        int n;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mProcessList.getUidProcStateLocked(uid);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProcessStatesAndOomScoresForPIDs(int[] pids, int[] states, int[] scores) {
        if (scores != null) {
            this.enforceCallingPermission("android.permission.GET_PROCESS_STATE_AND_OOM_SCORE", "getProcessStatesAndOomScoresForPIDs()");
        }
        if (pids == null) {
            throw new NullPointerException("pids");
        }
        if (states == null) {
            throw new NullPointerException("states");
        }
        if (pids.length != states.length) {
            throw new IllegalArgumentException("pids and states arrays have different lengths!");
        }
        if (scores != null && pids.length != scores.length) {
            throw new IllegalArgumentException("pids and scores arrays have different lengths!");
        }
        PidMap pidMap = this.mPidsSelfLocked;
        synchronized (pidMap) {
            for (int i = 0; i < pids.length; ++i) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pids[i]);
                int n = states[i] = pr == null ? 21 : pr.getCurProcState();
                if (scores == null) continue;
                scores[i] = pr == null ? -10000 : pr.curAdj;
            }
        }
    }

    public static int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
        if (pid == MY_PID) {
            return 0;
        }
        return ActivityManager.checkComponentPermission(permission2, uid, owningUid, exported);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            return -1;
        }
        return ActivityManagerService.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    @Override
    public int checkPermissionWithToken(String permission2, int pid, int uid, IBinder callerToken) {
        if (permission2 == null) {
            return -1;
        }
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            Slog.d("ActivityManager", "checkComponentPermission() adjusting {pid,uid} to {" + tlsIdentity.pid + "," + tlsIdentity.uid + "}");
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        return ActivityManagerService.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    void enforceCallingPermission(String permission2, String func) {
        if (this.checkCallingPermission(permission2) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    void enforcePermission(String permission2, int pid, int uid, String func) {
        if (this.checkPermission(permission2, pid, uid) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + pid + ", uid=" + uid + " requires " + permission2;
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAppStartModeDisabled(int uid, String packageName) {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.getAppStartModeLocked(uid, packageName, 0, -1, false, true, false) == 3;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    int appRestrictedInBackgroundLocked(int uid, String packageName, int packageTargetSdk) {
        if (packageTargetSdk >= 26) {
            return 2;
        }
        int appop = this.mAppOpsService.noteOperation(63, uid, packageName);
        switch (appop) {
            case 0: {
                if (this.mForceBackgroundCheck && !UserHandle.isCore(uid) && !this.isOnDeviceIdleWhitelistLocked(uid, true)) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    int appServicesRestrictedInBackgroundLocked(int uid, String packageName, int packageTargetSdk) {
        if (this.mPackageManagerInt.isPackagePersistent(packageName)) {
            return 0;
        }
        if (this.uidOnBackgroundWhitelist(uid)) {
            return 0;
        }
        if (this.isOnDeviceIdleWhitelistLocked(uid, false)) {
            return 0;
        }
        return this.appRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAppStartModeLocked(int uid, String packageName, int packageTargetSdk, int callingPid, boolean alwaysRestrict, boolean disabledOnly, boolean forcedStandby) {
        UidRecord uidRec = this.mProcessList.getUidRecordLocked(uid);
        if (uidRec == null || alwaysRestrict || forcedStandby || uidRec.idle) {
            int startMode;
            boolean ephemeral = uidRec == null ? this.getPackageManagerInternalLocked().isPackageEphemeral(UserHandle.getUserId(uid), packageName) : uidRec.ephemeral;
            if (ephemeral) {
                return 3;
            }
            if (disabledOnly) {
                return 0;
            }
            int n = startMode = alwaysRestrict ? this.appRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk) : this.appServicesRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk);
            if (startMode == 1 && callingPid >= 0) {
                ProcessRecord proc;
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    proc = this.mPidsSelfLocked.get(callingPid);
                }
                if (proc != null && !ActivityManager.isProcStateBackground(proc.getCurProcState())) {
                    return 0;
                }
            }
            return startMode;
        }
        return 0;
    }

    boolean isOnDeviceIdleWhitelistLocked(int uid, boolean allowExceptIdleToo) {
        int appId = UserHandle.getAppId(uid);
        int[] whitelist = allowExceptIdleToo ? this.mDeviceIdleExceptIdleWhitelist : this.mDeviceIdleWhitelist;
        return Arrays.binarySearch(whitelist, appId) >= 0 || Arrays.binarySearch(this.mDeviceIdleTempWhitelist, appId) >= 0 || this.mPendingTempWhitelist.indexOfKey(uid) >= 0;
    }

    String getPendingTempWhitelistTagForUidLocked(int uid) {
        PendingTempWhitelist ptw = this.mPendingTempWhitelist.get(uid);
        return ptw != null ? ptw.tag : null;
    }

    private ProviderInfo getProviderInfoLocked(String authority, int userHandle, int pmFlags) {
        ProviderInfo pi = null;
        ContentProviderRecord cpr = this.mProviderMap.getProviderByName(authority, userHandle);
        if (cpr != null) {
            pi = cpr.info;
        } else {
            try {
                pi = AppGlobals.getPackageManager().resolveContentProvider(authority, 0x800 | pmFlags, userHandle);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return pi;
    }

    @VisibleForTesting
    public void grantEphemeralAccessLocked(int userId, Intent intent, int targetAppId, int ephemeralAppId) {
        this.getPackageManagerInternalLocked().grantEphemeralAccess(userId, intent, targetAppId, ephemeralAppId);
    }

    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags, int userId, IBinder callerToken) {
        this.enforceNotIsolatedCaller("checkUriPermission");
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        return this.mUgmInternal.checkUriPermission(new GrantUri(userId, uri, false), uid, modeFlags) ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermission(IApplicationThread caller, String targetPkg, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("grantUriPermission");
        GrantUri grantUri = new GrantUri(userId, uri, false);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord r = this.getRecordForAppLocked(caller);
                if (r == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " when granting permission to uri " + grantUri);
                }
                if (targetPkg == null) {
                    throw new IllegalArgumentException("null target");
                }
                if (grantUri == null) {
                    throw new IllegalArgumentException("null uri");
                }
                Preconditions.checkFlagsArgument(modeFlags, 195);
                this.mUgmInternal.grantUriPermission(r.uid, targetPkg, grantUri, modeFlags, null, UserHandle.getUserId(r.uid));
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var7_7
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void revokeUriPermission(IApplicationThread caller, String targetPackage, Uri uri, int modeFlags, int userId) {
        ProcessRecord r;
        block9: {
            block8: {
                block7: {
                    this.enforceNotIsolatedCaller("revokeUriPermission");
                    ActivityManagerService activityManagerService = this;
                    // MONITORENTER : activityManagerService
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        r = this.getRecordForAppLocked(caller);
                        if (r == null) {
                            throw new SecurityException("Unable to find app for caller " + caller + " when revoking permission to uri " + uri);
                        }
                        if (uri != null) break block7;
                        Slog.w("ActivityManager", "revokeUriPermission: null uri");
                        // MONITOREXIT : activityManagerService
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (Intent.isAccessUriMode(modeFlags)) break block8;
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            String authority = uri.getAuthority();
            ProviderInfo pi = this.getProviderInfoLocked(authority, userId, 786432);
            if (pi != null) break block9;
            Slog.w("ActivityManager", "No content provider found for permission revoke: " + uri.toSafeString());
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mUgmInternal.revokeUriPermission(targetPackage, r.uid, new GrantUri(userId, uri, false), modeFlags);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void showWaitingForDebugger(IApplicationThread who, boolean waiting) {
        ProcessRecord app;
        block4: {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord processRecord = app = who != null ? this.getRecordForAppLocked(who) : null;
                if (app != null) break block4;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Message msg = Message.obtain();
        msg.what = 6;
        msg.obj = app;
        msg.arg1 = waiting ? 1 : 0;
        this.mUiHandler.sendMessage(msg);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        this.mProcessList.getMemoryInfo(outInfo);
    }

    @Override
    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum) {
        return this.mActivityTaskManager.getTasks(maxNum);
    }

    @Override
    public List<ActivityManager.RunningTaskInfo> getFilteredTasks(int maxNum, @WindowConfiguration.ActivityType int ignoreActivityType, @WindowConfiguration.WindowingMode int ignoreWindowingMode) {
        return this.mActivityTaskManager.getFilteredTasks(maxNum, ignoreActivityType, ignoreWindowingMode);
    }

    @Override
    public void cancelTaskWindowTransition(int taskId) {
        this.mActivityTaskManager.cancelTaskWindowTransition(taskId);
    }

    @Override
    public void setTaskResizeable(int taskId, int resizeableMode) {
        this.mActivityTaskManager.setTaskResizeable(taskId, resizeableMode);
    }

    @Override
    public ActivityManager.TaskSnapshot getTaskSnapshot(int taskId, boolean reducedResolution) {
        return this.mActivityTaskManager.getTaskSnapshot(taskId, reducedResolution);
    }

    @Override
    public void resizeTask(int taskId, Rect bounds, int resizeMode) {
        this.mActivityTaskManager.resizeTask(taskId, bounds, resizeMode);
    }

    @Override
    public Rect getTaskBounds(int taskId) {
        return this.mActivityTaskManager.getTaskBounds(taskId);
    }

    @Override
    public void removeStack(int stackId) {
        this.mActivityTaskManager.removeStack(stackId);
    }

    @Override
    public boolean removeTask(int taskId) {
        return this.mActivityTaskManager.removeTask(taskId);
    }

    @Override
    public void moveTaskToFront(IApplicationThread appThread, String callingPackage, int taskId, int flags, Bundle bOptions) {
        this.mActivityTaskManager.moveTaskToFront(appThread, callingPackage, taskId, flags, bOptions);
    }

    @Override
    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        return this.mActivityTaskManager.moveActivityTaskToBack(token, nonRoot);
    }

    @Override
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        this.mActivityTaskManager.moveTaskToStack(taskId, stackId, toTop);
    }

    @Override
    public void resizeStack(int stackId, Rect destBounds, boolean allowResizeInDockedMode, boolean preserveWindows, boolean animate, int animationDuration) {
        this.mActivityTaskManager.resizeStack(stackId, destBounds, allowResizeInDockedMode, preserveWindows, animate, animationDuration);
    }

    @Override
    public ParceledListSlice<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        return this.mActivityTaskManager.getRecentTasks(maxNum, flags, userId);
    }

    @Override
    public boolean moveTopActivityToPinnedStack(int stackId, Rect bounds) {
        return this.mActivityTaskManager.moveTopActivityToPinnedStack(stackId, bounds);
    }

    @Override
    public void resizeDockedStack(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds) {
        this.mActivityTaskManager.resizeDockedStack(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds, tempOtherTaskBounds, tempOtherTaskInsetBounds);
    }

    @Override
    public void positionTaskInStack(int taskId, int stackId, int position) {
        this.mActivityTaskManager.positionTaskInStack(taskId, stackId, position);
    }

    @Override
    public List<ActivityManager.StackInfo> getAllStackInfos() {
        return this.mActivityTaskManager.getAllStackInfos();
    }

    @Override
    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        return this.mActivityTaskManager.getTaskForActivity(token, onlyRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceOwner(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("updateDeviceOwner called from non-system process");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mDeviceOwnerName = packageName;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void updateLockTaskPackages(int userId, String[] packages) {
        this.mActivityTaskManager.updateLockTaskPackages(userId, packages);
    }

    @Override
    public boolean isInLockTaskMode() {
        return this.mActivityTaskManager.isInLockTaskMode();
    }

    @Override
    public int getLockTaskModeState() {
        return this.mActivityTaskManager.getLockTaskModeState();
    }

    @Override
    public void startSystemLockTaskMode(int taskId) throws RemoteException {
        this.mActivityTaskManager.startSystemLockTaskMode(taskId);
    }

    private final List<ProviderInfo> generateApplicationProvidersLocked(ProcessRecord app) {
        List providers = null;
        try {
            providers = AppGlobals.getPackageManager().queryContentProviders(app.processName, app.uid, 0x10000C00, null).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int userId = app.userId;
        if (providers != null) {
            int N = providers.size();
            app.pubProviders.ensureCapacity(N + app.pubProviders.size());
            for (int i = 0; i < N; ++i) {
                ProviderInfo cpi = (ProviderInfo)providers.get(i);
                boolean singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags);
                if (singleton && UserHandle.getUserId(app.uid) != 0) {
                    providers.remove(i);
                    --N;
                    --i;
                    continue;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                ContentProviderRecord cpr = this.mProviderMap.getProviderByClass(comp, userId);
                if (cpr == null) {
                    cpr = new ContentProviderRecord(this, cpi, app.info, comp, singleton);
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                app.pubProviders.put(cpi.name, cpr);
                if (!cpi.multiprocess || !"android".equals(cpi.packageName)) {
                    app.addPackage(cpi.applicationInfo.packageName, cpi.applicationInfo.longVersionCode, this.mProcessStats);
                }
                this.notifyPackageUse(cpi.applicationInfo.packageName, 4);
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String checkContentProviderAccess(String authority, int userId) {
        String string2;
        if (userId == -1) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "ActivityManager");
            userId = UserHandle.getCallingUserId();
        }
        ProviderInfo cpi = null;
        try {
            cpi = AppGlobals.getPackageManager().resolveContentProvider(authority, 790016, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (cpi == null) {
            return "Failed to find provider " + authority + " for user " + userId + "; expected to find a valid ContentProvider for this authority";
        }
        ProcessRecord r = null;
        Object object = this.mPidsSelfLocked;
        // MONITORENTER : object
        r = this.mPidsSelfLocked.get(Binder.getCallingPid());
        // MONITOREXIT : object
        if (r == null) {
            return "Failed to find PID " + Binder.getCallingPid();
        }
        object = this;
        // MONITORENTER : object
        try {
            ActivityManagerService.boostPriorityForLockedSection();
            string2 = this.checkContentProviderPermissionLocked(cpi, r, userId, true);
            // MONITOREXIT : object
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object
            ActivityManagerService.resetPriorityAfterLockedSection();
            throw throwable;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return string2;
    }

    private final String checkContentProviderPermissionLocked(ProviderInfo cpi, ProcessRecord r, int userId, boolean checkUser) {
        int callingPid = r != null ? r.pid : Binder.getCallingPid();
        int callingUid = r != null ? r.uid : Binder.getCallingUid();
        boolean checkedGrants = false;
        if (checkUser) {
            int tmpTargetUserId = this.mUserController.unsafeConvertIncomingUser(userId);
            if (tmpTargetUserId != UserHandle.getUserId(callingUid)) {
                if (this.mUgmInternal.checkAuthorityGrants(callingUid, cpi, tmpTargetUserId, checkUser)) {
                    return null;
                }
                checkedGrants = true;
            }
            if ((userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 0, "checkContentProviderPermissionLocked " + cpi.authority, null)) != tmpTargetUserId) {
                checkedGrants = false;
            }
        }
        if (ActivityManagerService.checkComponentPermission(cpi.readPermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        if (ActivityManagerService.checkComponentPermission(cpi.writePermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        PathPermission[] pps = cpi.pathPermissions;
        if (pps != null) {
            int i = pps.length;
            while (i > 0) {
                PathPermission pp;
                String pprperm;
                if ((pprperm = (pp = pps[--i]).getReadPermission()) != null && ActivityManagerService.checkComponentPermission(pprperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
                    return null;
                }
                String ppwperm = pp.getWritePermission();
                if (ppwperm == null || ActivityManagerService.checkComponentPermission(ppwperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) != 0) continue;
                return null;
            }
        }
        if (!checkedGrants && this.mUgmInternal.checkAuthorityGrants(callingUid, cpi, userId, checkUser)) {
            return null;
        }
        String suffix = !cpi.exported ? " that is not exported from UID " + cpi.applicationInfo.uid : ("android.permission.MANAGE_DOCUMENTS".equals(cpi.readPermission) ? " requires that you obtain access using ACTION_OPEN_DOCUMENT or related APIs" : " requires " + cpi.readPermission + " or " + cpi.writePermission);
        String msg = "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ")" + suffix;
        Slog.w("ActivityManager", msg);
        return msg;
    }

    ContentProviderConnection incProviderCountLocked(ProcessRecord r, ContentProviderRecord cpr, IBinder externalProcessToken, int callingUid, String callingPackage, String callingTag, boolean stable) {
        if (r != null) {
            for (int i = 0; i < r.conProviders.size(); ++i) {
                ContentProviderConnection conn = r.conProviders.get(i);
                if (conn.provider != cpr) continue;
                if (stable) {
                    ++conn.stableCount;
                    ++conn.numStableIncs;
                } else {
                    ++conn.unstableCount;
                    ++conn.numUnstableIncs;
                }
                return conn;
            }
            ContentProviderConnection conn = new ContentProviderConnection(cpr, r, callingPackage);
            conn.startAssociationIfNeeded();
            if (stable) {
                conn.stableCount = 1;
                conn.numStableIncs = 1;
            } else {
                conn.unstableCount = 1;
                conn.numUnstableIncs = 1;
            }
            cpr.connections.add(conn);
            r.conProviders.add(conn);
            this.startAssociationLocked(r.uid, r.processName, r.getCurProcState(), cpr.uid, cpr.appInfo.longVersionCode, cpr.name, cpr.info.processName);
            return conn;
        }
        cpr.addExternalProcessHandleLocked(externalProcessToken, callingUid, callingTag);
        return null;
    }

    boolean decProviderCountLocked(ContentProviderConnection conn, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (conn != null) {
            cpr = conn.provider;
            if (stable) {
                --conn.stableCount;
            } else {
                --conn.unstableCount;
            }
            if (conn.stableCount == 0 && conn.unstableCount == 0) {
                conn.stopAssociation();
                cpr.connections.remove(conn);
                conn.client.conProviders.remove(conn);
                if (conn.client.setProcState < 16 && cpr.proc != null) {
                    cpr.proc.lastProviderTime = SystemClock.uptimeMillis();
                }
                this.stopAssociationLocked(conn.client.uid, conn.client.processName, cpr.uid, cpr.appInfo.longVersionCode, cpr.name, cpr.info.processName);
                return true;
            }
            return false;
        }
        cpr.removeExternalProcessHandleLocked(externalProcessToken);
        return false;
    }

    void checkTime(long startTime, String where) {
        long now = SystemClock.uptimeMillis();
        if (now - startTime > 50L) {
            Slog.w("ActivityManager", "Slow operation: " + (now - startTime) + "ms so far, now at " + where);
        }
    }

    private boolean isProcessAliveLocked(ProcessRecord proc) {
        if (proc.pid <= 0) {
            return false;
        }
        if (proc.procStatFile == null) {
            proc.procStatFile = "/proc/" + proc.pid + "/stat";
        }
        this.mProcessStateStatsLongs[0] = 0L;
        if (!android.os.Process.readProcFile(proc.procStatFile, PROCESS_STATE_STATS_FORMAT, null, this.mProcessStateStatsLongs, null)) {
            return false;
        }
        long state = this.mProcessStateStatsLongs[0];
        return state != 90L && state != 88L && state != 120L && state != 75L;
    }

    private String checkContentProviderAssociation(ProcessRecord callingApp, int callingUid, ProviderInfo cpi) {
        if (callingApp == null) {
            return this.validateAssociationAllowedLocked(cpi.packageName, cpi.applicationInfo.uid, null, callingUid) ? null : "<null>";
        }
        for (int i = callingApp.pkgList.size() - 1; i >= 0; --i) {
            if (this.validateAssociationAllowedLocked(callingApp.pkgList.keyAt(i), callingApp.uid, cpi.packageName, cpi.applicationInfo.uid)) continue;
            return cpi.packageName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ContentProviderHolder getContentProviderImpl(IApplicationThread caller, String name, IBinder token, int callingUid, String callingPackage, String callingTag, boolean stable, int userId) {
        block85: {
            conn = null;
            cpi = null;
            providerRunning = false;
            var13_12 = this;
            synchronized (var13_12) {
                ActivityManagerService.boostPriorityForLockedSection();
                startTime = SystemClock.uptimeMillis();
                r = null;
                if (caller != null && (r = this.getRecordForAppLocked(caller)) == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when getting content provider " + name);
                }
                checkCrossUser = true;
                this.checkTime(startTime, "getContentProviderImpl: getProviderByName");
                cpr = this.mProviderMap.getProviderByName(name, userId);
                if (cpr == null && userId != 0 && (cpr = this.mProviderMap.getProviderByName(name, 0)) != null) {
                    cpi = cpr.info;
                    if (this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid)) {
                        userId = 0;
                        checkCrossUser = false;
                    } else {
                        cpr = null;
                        cpi = null;
                    }
                }
                if (cpr != null && cpr.proc != null) {
                    v0 = providerRunning = cpr.proc.killed == false;
                    if (cpr.proc.killed && cpr.proc.killedByAm) {
                        this.checkTime(startTime, "getContentProviderImpl: before appDied (killedByAm)");
                        iden = Binder.clearCallingIdentity();
                        try {
                            this.appDiedLocked(cpr.proc);
                        }
                        finally {
                            Binder.restoreCallingIdentity(iden);
                        }
                        this.checkTime(startTime, "getContentProviderImpl: after appDied (killedByAm)");
                    }
                }
                if (!providerRunning) ** GOTO lbl105
                cpi = cpr.info;
                if (r == null || !cpr.canRunHere((ProcessRecord)r)) ** break block71
                msg = this.checkContentProviderAssociation((ProcessRecord)r, callingUid, cpi);
                if (msg != null) {
                    throw new SecurityException("Content provider lookup " + cpr.name.flattenToShortString() + " failed: association not allowed with package " + msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                msg = this.checkContentProviderPermissionLocked(cpi, (ProcessRecord)r, userId, checkCrossUser);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                holder = cpr.newHolder(null);
                holder.provider = null;
                v1 = holder;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v1;
            {
                if (AppGlobals.getPackageManager().resolveContentProvider(name, 0, userId) != null) ** break block72
                v2 = null;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v2;
            {
                block82: {
                    break block82;
                    catch (RemoteException holder) {
                        // empty catch block
                    }
                }
                msg = this.checkContentProviderAssociation((ProcessRecord)r, callingUid, cpi);
                if (msg != null) {
                    throw new SecurityException("Content provider lookup " + cpr.name.flattenToShortString() + " failed: association not allowed with package " + msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                msg = this.checkContentProviderPermissionLocked(cpi, (ProcessRecord)r, userId, checkCrossUser);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                origId = Binder.clearCallingIdentity();
                this.checkTime(startTime, "getContentProviderImpl: incProviderCountLocked");
                conn = this.incProviderCountLocked((ProcessRecord)r, cpr, token, callingUid, callingPackage, callingTag, stable);
                if (conn != null && conn.stableCount + conn.unstableCount == 1 && cpr.proc != null && r.setAdj <= 250) {
                    this.checkTime(startTime, "getContentProviderImpl: before updateLruProcess");
                    this.mProcessList.updateLruProcessLocked(cpr.proc, false, null);
                    this.checkTime(startTime, "getContentProviderImpl: after updateLruProcess");
                }
                this.checkTime(startTime, "getContentProviderImpl: before updateOomAdj");
                verifiedAdj = cpr.proc.verifiedAdj;
                success = this.updateOomAdjLocked(cpr.proc, true, "updateOomAdj_getProvider");
                if (success && verifiedAdj != cpr.proc.setAdj && !this.isProcessAliveLocked(cpr.proc)) {
                    success = false;
                }
                this.maybeUpdateProviderUsageStatsLocked((ProcessRecord)r, cpr.info.packageName, name);
                this.checkTime(startTime, "getContentProviderImpl: after updateOomAdj");
                if (success) ** GOTO lbl102
                Slog.i("ActivityManager", "Existing provider " + cpr.name.flattenToShortString() + " is crashing; detaching " + r);
                lastRef = this.decProviderCountLocked(conn, cpr, token, stable);
                this.checkTime(startTime, "getContentProviderImpl: before appDied");
                this.appDiedLocked(cpr.proc);
                this.checkTime(startTime, "getContentProviderImpl: after appDied");
                if (lastRef) ** break block73
                v3 = null;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v3;
            {
                block83: {
                    providerRunning = false;
                    conn = null;
                    break block83;
lbl102:
                    // 1 sources

                    cpr.proc.verifiedAdj = cpr.proc.setAdj;
                }
                Binder.restoreCallingIdentity(origId);
lbl105:
                // 2 sources

                if (providerRunning) ** GOTO lbl247
                try {
                    this.checkTime(startTime, "getContentProviderImpl: before resolveContentProvider");
                    cpi = AppGlobals.getPackageManager().resolveContentProvider(name, 3072, userId);
                    this.checkTime(startTime, "getContentProviderImpl: after resolveContentProvider");
                }
                catch (RemoteException msg) {
                    // empty catch block
                }
                if (cpi != null) ** break block74
                v4 = null;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v4;
            {
                v5 = singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) != false && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid) != false;
                if (singleton) {
                    userId = 0;
                }
                cpi.applicationInfo = this.getAppInfoForUser(cpi.applicationInfo, userId);
                this.checkTime(startTime, "getContentProviderImpl: got app info for user");
                msg = this.checkContentProviderAssociation((ProcessRecord)r, callingUid, cpi);
                if (msg != null) {
                    throw new SecurityException("Content provider lookup " + name + " failed: association not allowed with package " + msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                msg = this.checkContentProviderPermissionLocked(cpi, (ProcessRecord)r, userId, singleton == false);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                if (!this.mProcessesReady && !cpi.processName.equals("system")) {
                    throw new IllegalArgumentException("Attempt to launch content provider before system ready");
                }
                if (!this.mSystemProvidersInstalled && cpi.applicationInfo.isSystemApp() && "system".equals(cpi.processName)) {
                    throw new IllegalStateException("Cannot access system provider: '" + cpi.authority + "' before system providers are installed!");
                }
                if (this.mUserController.isUserRunning(userId, 0)) ** break block75
                Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": user " + userId + " is stopped");
                v6 = null;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v6;
            {
                comp = new ComponentName(cpi.packageName, cpi.name);
                this.checkTime(startTime, "getContentProviderImpl: before getProviderByClass");
                cpr = this.mProviderMap.getProviderByClass(comp, userId);
                this.checkTime(startTime, "getContentProviderImpl: after getProviderByClass");
                v7 = firstClass = cpr == null;
                if (!firstClass) ** GOTO lbl181
                ident = Binder.clearCallingIdentity();
                if (this.requestTargetProviderPermissionsReviewIfNeededLocked(cpi, (ProcessRecord)r, userId)) ** break block76
                v8 = null;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v8;
            {
                this.checkTime(startTime, "getContentProviderImpl: before getApplicationInfo");
                ai = AppGlobals.getPackageManager().getApplicationInfo(cpi.applicationInfo.packageName, 1024, userId);
                this.checkTime(startTime, "getContentProviderImpl: after getApplicationInfo");
                if (ai != null) ** break block77
                Slog.w("ActivityManager", "No package info for content provider " + cpi.name);
                var25_40 = null;
                Binder.restoreCallingIdentity(ident);
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return var25_40;
            {
                block78: {
                    ai = this.getAppInfoForUser(ai, userId);
                    cpr = new ContentProviderRecord(this, cpi, ai, comp, singleton);
                    break block78;
                    {
                        catch (RemoteException ai) {
                            break block78;
                            catch (Throwable var26_41) {
                                throw var26_41;
                            }
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                this.checkTime(startTime, "getContentProviderImpl: now have ContentProviderRecord");
                if (r == null || !cpr.canRunHere((ProcessRecord)r)) ** break block79
                v9 = cpr.newHolder(null);
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return v9;
            {
                N = this.mLaunchingProviders.size();
                for (i = 0; i < N && this.mLaunchingProviders.get(i) != cpr; ++i) {
                }
                if (i < N) ** GOTO lbl239
                origId = Binder.clearCallingIdentity();
                try {
                    this.checkTime(startTime, "getContentProviderImpl: before set stopped state");
                    AppGlobals.getPackageManager().setPackageStoppedState(cpr.appInfo.packageName, false, userId);
                    this.checkTime(startTime, "getContentProviderImpl: after set stopped state");
                }
                catch (RemoteException var26_42) {
                }
                catch (IllegalArgumentException e) {
                    Slog.w("ActivityManager", "Failed trying to unstop package " + cpr.appInfo.packageName + ": " + e);
                }
                this.checkTime(startTime, "getContentProviderImpl: looking for process record");
                proc = this.getProcessRecordLocked(cpi.processName, cpr.appInfo.uid, false);
                if (proc != null && proc.thread != null && !proc.killed) {
                    if (!proc.pubProviders.containsKey(cpi.name)) {
                        this.checkTime(startTime, "getContentProviderImpl: scheduling install");
                        proc.pubProviders.put(cpi.name, cpr);
                        try {
                            proc.thread.scheduleInstallProvider(cpi);
                        }
                        catch (RemoteException var27_45) {}
                    }
                    ** break block80
                }
                this.checkTime(startTime, "getContentProviderImpl: before start process");
                proc = this.startProcessLocked(cpi.processName, cpr.appInfo, false, 0, new HostingRecord("content provider", new ComponentName(cpi.applicationInfo.packageName, cpi.name)), false, false, false);
                this.checkTime(startTime, "getContentProviderImpl: after start process");
                if (proc != null) ** break block80
                Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": process is bad");
                var27_46 = null;
                Binder.restoreCallingIdentity(origId);
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return var27_46;
lbl-1000:
            // 3 sources

            {
                try {
                    block81: {
                        cpr.launchingApp = proc;
                        this.mLaunchingProviders.add(cpr);
                        break block81;
                        {
                            catch (Throwable var28_47) {
                                throw var28_47;
                            }
                        }
                        finally {
                            Binder.restoreCallingIdentity(origId);
                        }
                    }
                    this.checkTime(startTime, "getContentProviderImpl: updating data structures");
                    if (firstClass) {
                        this.mProviderMap.putProviderByClass(comp, cpr);
                    }
                    this.mProviderMap.putProviderByName(name, cpr);
                    conn = this.incProviderCountLocked((ProcessRecord)r, cpr, token, callingUid, callingPackage, callingTag, stable);
                    if (conn != null) {
                        conn.waiting = true;
                    }
lbl247:
                    // 4 sources

                    this.checkTime(startTime, "getContentProviderImpl: done!");
                    this.grantEphemeralAccessLocked(userId, null, UserHandle.getAppId(cpi.applicationInfo.uid), UserHandle.getAppId(Binder.getCallingUid()));
                }
                catch (Throwable var29_48) {
                    // MONITOREXIT @DISABLED, blocks:[35, 23] lbl248 : MonitorExitStatement: MONITOREXIT : var13_12
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw var29_48;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            timeout = SystemClock.uptimeMillis() + 20000L;
            timedOut = false;
            r = cpr;
            synchronized (r) lbl-1000:
            // 2 sources

            {
                while (cpr.provider == null) {
                    if (cpr.launchingApp == null) {
                        Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": launching app became null");
                        EventLog.writeEvent(30036, new Object[]{UserHandle.getUserId(cpi.applicationInfo.uid), cpi.applicationInfo.packageName, cpi.applicationInfo.uid, name});
                        return null;
                    }
                    try {
                        wait = Math.max(0L, timeout - SystemClock.uptimeMillis());
                        if (conn != null) {
                            conn.waiting = true;
                        }
                        cpr.wait(wait);
                        if (cpr.provider != null) continue;
                        timedOut = true;
                        break;
                    }
                    catch (InterruptedException var17_18) {}
                    continue;
                    finally {
                        if (conn == null) ** GOTO lbl-1000
                        conn.waiting = false;
                    }
                }
            }
            if (!timedOut) break block85;
            callerName = "unknown";
            var17_19 = this;
            synchronized (var17_19) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    record = this.mProcessList.getLRURecordForAppLocked(caller);
                    if (record != null) {
                        callerName = record.processName;
                    }
                }
                catch (Throwable var32_52) {
                    // MONITOREXIT @DISABLED, blocks:[39, 25] lbl296 : MonitorExitStatement: MONITOREXIT : var17_19
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw var32_52;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            Slog.wtf("ActivityManager", "Timeout waiting for provider " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + " providerRunning=" + providerRunning + " caller=" + callerName + "/" + Binder.getCallingUid());
            return null;
        }
        return cpr.newHolder(conn);
    }

    private boolean requestTargetProviderPermissionsReviewIfNeededLocked(ProviderInfo cpi, ProcessRecord r, int userId) {
        if (this.getPackageManagerInternalLocked().isPermissionsReviewRequired(cpi.packageName, userId)) {
            boolean callerForeground;
            boolean bl = callerForeground = r == null || r.setSchedGroup != 0;
            if (!callerForeground) {
                Slog.w("ActivityManager", "u" + userId + " Instantiating a provider in package" + cpi.packageName + " requires a permissions review");
                return false;
            }
            Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", cpi.packageName);
            UserHandle userHandle = new UserHandle(userId);
            this.mHandler.post(new StartActivityRunnable(this.mContext, intent, userHandle));
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public IPackageManager getPackageManager() {
        return AppGlobals.getPackageManager();
    }

    @VisibleForTesting
    public PackageManagerInternal getPackageManagerInternalLocked() {
        if (this.mPackageManagerInt == null) {
            this.mPackageManagerInt = LocalServices.getService(PackageManagerInternal.class);
        }
        return this.mPackageManagerInt;
    }

    @Override
    public final ContentProviderHolder getContentProvider(IApplicationThread caller, String callingPackage, String name, int userId, boolean stable) {
        this.enforceNotIsolatedCaller("getContentProvider");
        if (caller == null) {
            String msg = "null IApplicationThread when getting content provider " + name;
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingUid = Binder.getCallingUid();
        if (callingPackage != null && this.mAppOpsService.checkPackage(callingUid, callingPackage) != 0) {
            throw new SecurityException("Given calling package " + callingPackage + " does not match caller's uid " + callingUid);
        }
        return this.getContentProviderImpl(caller, name, null, callingUid, callingPackage, null, stable, userId);
    }

    @Override
    public ContentProviderHolder getContentProviderExternal(String name, int userId, IBinder token, String tag) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call getContentProviderExternal()");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "getContentProvider", null);
        return this.getContentProviderExternalUnchecked(name, token, Binder.getCallingUid(), tag != null ? tag : "*external*", userId);
    }

    private ContentProviderHolder getContentProviderExternalUnchecked(String name, IBinder token, int callingUid, String callingTag, int userId) {
        return this.getContentProviderImpl(null, name, token, callingUid, null, callingTag, true, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeContentProvider(IBinder connection, boolean stable) {
        this.enforceNotIsolatedCaller("removeContentProvider");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ContentProviderConnection conn;
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        conn = (ContentProviderConnection)connection;
                    }
                    catch (ClassCastException e) {
                        String msg = "removeContentProvider: " + connection + " not a ContentProviderConnection";
                        Slog.w("ActivityManager", msg);
                        throw new IllegalArgumentException(msg);
                    }
                    if (conn == null) {
                        throw new NullPointerException("connection is null");
                    }
                    if (this.decProviderCountLocked(conn, null, null, stable)) {
                        this.updateOomAdjLocked("updateOomAdj_removeProvider");
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl23 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    @Deprecated
    public void removeContentProviderExternal(String name, IBinder token) {
        this.removeContentProviderExternalAsUser(name, token, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProviderExternalAsUser(String name, IBinder token, int userId) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call removeContentProviderExternal()");
        long ident = Binder.clearCallingIdentity();
        try {
            this.removeContentProviderExternalUnchecked(name, token, userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void removeContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        ContentProviderRecord cpr;
        block8: {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                cpr = this.mProviderMap.getProviderByName(name, userId);
                if (cpr != null) break block8;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
        ContentProviderRecord localCpr = this.mProviderMap.getProviderByClass(comp, userId);
        if (localCpr.hasExternalProcessHandles()) {
            if (localCpr.removeExternalProcessHandleLocked(token)) {
                this.updateOomAdjLocked("updateOomAdj_removeProvider");
            } else {
                Slog.e("ActivityManager", "Attmpt to remove content provider " + localCpr + " with no external reference for token: " + token + ".");
            }
        } else {
            Slog.e("ActivityManager", "Attmpt to remove content provider: " + localCpr + " with no external references.");
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void publishContentProviders(IApplicationThread caller, List<ContentProviderHolder> providers) {
        if (providers == null) {
            return;
        }
        this.enforceNotIsolatedCaller("publishContentProviders");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord r = this.getRecordForAppLocked(caller);
                if (r == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when publishing content providers");
                }
                long origId = Binder.clearCallingIdentity();
                int N = providers.size();
                for (int i = 0; i < N; ++i) {
                    ContentProviderRecord dst;
                    ContentProviderHolder src = providers.get(i);
                    if (src == null || src.info == null || src.provider == null || (dst = r.pubProviders.get(src.info.name)) == null) continue;
                    ComponentName comp = new ComponentName(dst.info.packageName, dst.info.name);
                    this.mProviderMap.putProviderByClass(comp, dst);
                    String[] names = dst.info.authority.split(";");
                    for (int j = 0; j < names.length; ++j) {
                        this.mProviderMap.putProviderByName(names[j], dst);
                    }
                    int launchingCount = this.mLaunchingProviders.size();
                    boolean wasInLaunchingProviders = false;
                    for (int j = 0; j < launchingCount; ++j) {
                        if (this.mLaunchingProviders.get(j) != dst) continue;
                        this.mLaunchingProviders.remove(j);
                        wasInLaunchingProviders = true;
                        --j;
                        --launchingCount;
                    }
                    if (wasInLaunchingProviders) {
                        this.mHandler.removeMessages(57, r);
                    }
                    r.addPackage(dst.info.applicationInfo.packageName, dst.info.applicationInfo.longVersionCode, this.mProcessStats);
                    ContentProviderRecord contentProviderRecord = dst;
                    synchronized (contentProviderRecord) {
                        dst.provider = src.provider;
                        dst.setProcess(r);
                        dst.notifyAll();
                    }
                    this.updateOomAdjLocked(r, true, "updateOomAdj_getProvider");
                    this.maybeUpdateProviderUsageStatsLocked(r, src.info.packageName, src.info.authority);
                }
                Binder.restoreCallingIdentity(origId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl55 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean refContentProvider(IBinder connection, int stable, int unstable) {
        boolean bl;
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w("ActivityManager", msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (stable > 0) {
                    conn.numStableIncs += stable;
                }
                if ((stable = conn.stableCount + stable) < 0) {
                    throw new IllegalStateException("stableCount < 0: " + stable);
                }
                if (unstable > 0) {
                    conn.numUnstableIncs += unstable;
                }
                if ((unstable = conn.unstableCount + unstable) < 0) {
                    throw new IllegalStateException("unstableCount < 0: " + unstable);
                }
                if (stable + unstable <= 0) {
                    throw new IllegalStateException("ref counts can't go to zero here: stable=" + stable + " unstable=" + unstable);
                }
                conn.stableCount = stable;
                conn.unstableCount = unstable;
                bl = !conn.dead;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl31 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void unstableProviderDied(IBinder connection) {
        ProcessRecord proc;
        block20: {
            ContentProviderConnection conn;
            block19: {
                IContentProvider provider;
                try {
                    conn = (ContentProviderConnection)connection;
                }
                catch (ClassCastException e) {
                    String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
                    Slog.w("ActivityManager", msg);
                    throw new IllegalArgumentException(msg);
                }
                if (conn == null) {
                    throw new NullPointerException("connection is null");
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    provider = conn.provider.provider;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                if (provider == null) {
                    return;
                }
                if (provider.asBinder().pingBinder()) {
                    activityManagerService = this;
                    // MONITORENTER : activityManagerService
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        Slog.w("ActivityManager", "unstableProviderDied: caller " + Binder.getCallingUid() + " says " + conn + " died, but we don't agree");
                        // MONITOREXIT : activityManagerService
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (conn.provider.provider == provider) break block19;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            proc = conn.provider.proc;
            if (proc != null && proc.thread != null) break block20;
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.reportUidInfoMessageLocked("ActivityManager", "Process " + proc.processName + " (pid " + proc.pid + ") early provider death", proc.info.uid);
        long ident = Binder.clearCallingIdentity();
        try {
            this.appDiedLocked(proc);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void appNotRespondingViaProvider(IBinder connection) {
        this.enforceCallingPermission("android.permission.REMOVE_TASKS", "appNotRespondingViaProvider()");
        ContentProviderConnection conn = (ContentProviderConnection)connection;
        if (conn == null) {
            Slog.w("ActivityManager", "ContentProviderConnection is null");
            return;
        }
        final ProcessRecord host = conn.provider.proc;
        if (host == null) {
            Slog.w("ActivityManager", "Failed to find hosting ProcessRecord");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                host.appNotResponding(null, null, null, null, false, "ContentProvider not responding");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void installSystemProviders() {
        List<ProviderInfo> providers;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord app = (ProcessRecord)this.mProcessList.mProcessNames.get("system", 1000);
                providers = this.generateApplicationProvidersLocked(app);
                if (providers != null) {
                    for (int i = providers.size() - 1; i >= 0; --i) {
                        ProviderInfo pi = providers.get(i);
                        if ((pi.applicationInfo.flags & 1) != 0) continue;
                        Slog.w("ActivityManager", "Not installing system proc provider " + pi.name + ": not system .apk");
                        providers.remove(i);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (providers != null) {
            this.mSystemThread.installSystemProviders(providers);
        }
        activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mSystemProvidersInstalled = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl33 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        this.mConstants.start(this.mContext.getContentResolver());
        this.mCoreSettingsObserver = new CoreSettingsObserver(this);
        this.mActivityTaskManager.installSystemProviders();
        this.mDevelopmentSettingsObserver = new DevelopmentSettingsObserver();
        SettingsToPropertiesMapper.start(this.mContext.getContentResolver());
        this.mOomAdjuster.initSettings();
        RescueParty.onSettingsProviderPublished(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPersistentApps(int matchFlags) {
        if (this.mFactoryTest == 1) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    List apps = AppGlobals.getPackageManager().getPersistentApplications(0x400 | matchFlags).getList();
                    for (ApplicationInfo app : apps) {
                        if ("android".equals(app.packageName)) continue;
                        this.addAppLocked(app, null, false, null);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installEncryptionUnawareProviders(int userId) {
        int matchFlags = 262152;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int NP = this.mProcessList.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray apps = this.mProcessList.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                        if (app.userId != userId || app.thread == null || app.unlocked) continue;
                        int NG = app.pkgList.size();
                        for (int ig = 0; ig < NG; ++ig) {
                            try {
                                String pkgName = app.pkgList.keyAt(ig);
                                PackageInfo pkgInfo = AppGlobals.getPackageManager().getPackageInfo(pkgName, 262152, userId);
                                if (pkgInfo == null || ArrayUtils.isEmpty(pkgInfo.providers)) continue;
                                for (ProviderInfo pi : pkgInfo.providers) {
                                    boolean userMatch;
                                    boolean processMatch;
                                    boolean bl = processMatch = Objects.equals(pi.processName, app.processName) || pi.multiprocess;
                                    boolean bl2 = this.isSingleton(pi.processName, pi.applicationInfo, pi.name, pi.flags) ? app.userId == 0 : (userMatch = true);
                                    if (processMatch && userMatch) {
                                        Log.v("ActivityManager", "Installing " + pi);
                                        app.thread.scheduleInstallProvider(pi);
                                        continue;
                                    }
                                    Log.v("ActivityManager", "Skipping " + pi);
                                }
                                continue;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl42 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProviderMimeType(Uri uri, int userId) {
        this.enforceNotIsolatedCaller("getProviderMimeType");
        String name = uri.getAuthority();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long ident = 0L;
        boolean clearedIdentity = false;
        userId = this.mUserController.unsafeConvertIncomingUser(userId);
        if (this.canClearIdentity(callingPid, callingUid, userId)) {
            clearedIdentity = true;
            ident = Binder.clearCallingIdentity();
        }
        ContentProviderHolder holder = null;
        try {
            holder = this.getContentProviderExternalUnchecked(name, null, callingUid, "*getmimetype*", userId);
            if (holder != null) {
                String string2 = holder.provider.getType(uri);
                return string2;
            }
        }
        catch (RemoteException e) {
            Log.w("ActivityManager", "Content provider dead retrieving " + uri, e);
            String string3 = null;
            return string3;
        }
        catch (Exception e) {
            Log.w("ActivityManager", "Exception while determining type of " + uri, e);
            String string4 = null;
            return string4;
        }
        finally {
            if (!clearedIdentity) {
                ident = Binder.clearCallingIdentity();
            }
            try {
                if (holder != null) {
                    this.removeContentProviderExternalUnchecked(name, null, userId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return null;
    }

    private boolean canClearIdentity(int callingPid, int callingUid, int userId) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return true;
        }
        return ActivityManagerService.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) == 0 || ActivityManagerService.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0;
    }

    private boolean uidOnBackgroundWhitelist(int uid) {
        int appId = UserHandle.getAppId(uid);
        int[] whitelist = this.mBackgroundAppIdWhitelist;
        int N = whitelist.length;
        for (int i = 0; i < N; ++i) {
            if (appId != whitelist[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBackgroundRestricted(String packageName) {
        int callingUid = Binder.getCallingUid();
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            int packageUid = pm.getPackageUid(packageName, 0x10000000, UserHandle.getUserId(callingUid));
            if (packageUid != callingUid) {
                throw new IllegalArgumentException("Uid " + callingUid + " cannot query restriction state for package " + packageName);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.isBackgroundRestrictedNoCheck(callingUid, packageName);
    }

    boolean isBackgroundRestrictedNoCheck(int uid, String packageName) {
        int mode = this.mAppOpsService.checkOperation(70, uid, packageName);
        return mode != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundWhitelistUid(int uid) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the OS may call backgroundWhitelistUid()");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int N = this.mBackgroundAppIdWhitelist.length;
                int[] newList = new int[N + 1];
                System.arraycopy(this.mBackgroundAppIdWhitelist, 0, newList, 0, N);
                newList[N] = UserHandle.getAppId(uid);
                this.mBackgroundAppIdWhitelist = newList;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    final ProcessRecord addAppLocked(ApplicationInfo info, String customProcess, boolean isolated, String abiOverride) {
        return this.addAppLocked(info, customProcess, isolated, false, false, abiOverride);
    }

    @GuardedBy(value={"this"})
    final ProcessRecord addAppLocked(ApplicationInfo info, String customProcess, boolean isolated, boolean disableHiddenApiChecks, boolean mountExtStorageFull, String abiOverride) {
        ProcessRecord app = !isolated ? this.getProcessRecordLocked(customProcess != null ? customProcess : info.processName, info.uid, true) : null;
        if (app == null) {
            app = this.mProcessList.newProcessRecordLocked(info, customProcess, isolated, 0, new HostingRecord("added application", customProcess != null ? customProcess : info.processName));
            this.mProcessList.updateLruProcessLocked(app, false, null);
            this.updateOomAdjLocked("updateOomAdj_processBegin");
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(info.packageName, false, UserHandle.getUserId(app.uid));
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + info.packageName + ": " + e);
        }
        if ((info.flags & 9) == 9) {
            app.setPersistent(true);
            app.maxAdj = -800;
        }
        if (app.thread == null && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            this.mProcessList.startProcessLocked(app, new HostingRecord("added application", customProcess != null ? customProcess : app.processName), disableHiddenApiChecks, mountExtStorageFull, abiOverride);
        }
        return app;
    }

    @Override
    public void unhandledBack() {
        this.mActivityTaskManager.unhandledBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openContentUri(String uriString) throws RemoteException {
        this.enforceNotIsolatedCaller("openContentUri");
        int userId = UserHandle.getCallingUserId();
        Uri uri = Uri.parse(uriString);
        String name = uri.getAuthority();
        ContentProviderHolder cph = this.getContentProviderExternalUnchecked(name, null, Binder.getCallingUid(), "*opencontent*", userId);
        ParcelFileDescriptor pfd = null;
        if (cph != null) {
            Binder token = new Binder();
            sCallerIdentity.set(new Identity(token, Binder.getCallingPid(), Binder.getCallingUid()));
            try {
                pfd = cph.provider.openFile(null, uri, "r", null, token);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                sCallerIdentity.remove();
                this.removeContentProviderExternalUnchecked(name, null, userId);
            }
        } else {
            Slog.d("ActivityManager", "Failed to get provider for authority '" + name + "'");
        }
        return pfd;
    }

    void reportGlobalUsageEventLocked(int event) {
        this.mUsageStatsService.reportEvent("android", this.mUserController.getCurrentUserId(), event);
        int[] profiles = this.mUserController.getCurrentProfileIds();
        if (profiles != null) {
            for (int i = profiles.length - 1; i >= 0; --i) {
                this.mUsageStatsService.reportEvent(null, profiles[i], event);
            }
        }
    }

    void reportCurWakefulnessUsageEventLocked() {
        this.reportGlobalUsageEventLocked(this.mWakefulness == 1 ? 15 : 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWakefulnessChanged(int wakefulness) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                boolean wasAwake = this.mWakefulness == 1;
                boolean isAwake = wakefulness == 1;
                this.mWakefulness = wakefulness;
                if (wasAwake != isAwake) {
                    this.mServices.updateScreenStateLocked(isAwake);
                    this.reportCurWakefulnessUsageEventLocked();
                    this.mActivityTaskManager.onScreenAwakeChanged(isAwake);
                    this.mOomAdjProfiler.onWakefulnessChanged(wakefulness);
                }
                this.updateOomAdjLocked("updateOomAdj_uiVisibility");
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void notifyCleartextNetwork(int uid, byte[] firstPacket) {
        this.mHandler.obtainMessage(49, uid, 0, firstPacket).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(int timeout) {
        if (this.checkCallingPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires permission android.permission.SHUTDOWN");
        }
        boolean timedout = this.mAtmInternal.shuttingDown(this.mBooted, timeout);
        this.mAppOpsService.shutdown();
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.prepareShutdown();
        }
        this.mBatteryStatsService.shutdown();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mProcessStats.shutdownLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return timedout;
    }

    @Override
    public void notifyLockedProfile(int userId) {
        this.mAtmInternal.notifyLockedProfile(userId, this.mUserController.getCurrentUserId());
    }

    @Override
    public void startConfirmDeviceCredentialIntent(Intent intent, Bundle options) {
        this.mAtmInternal.startConfirmDeviceCredentialIntent(intent, options);
    }

    @Override
    public void stopAppSwitches() {
        this.mActivityTaskManager.stopAppSwitches();
    }

    @Override
    public void resumeAppSwitches() {
        this.mActivityTaskManager.resumeAppSwitches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setDebugApp(String packageName, boolean waitForDebugger, boolean persistent) {
        this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDebugApp()");
        long ident = Binder.clearCallingIdentity();
        try {
            if (persistent) {
                ContentResolver resolver = this.mContext.getContentResolver();
                Settings.Global.putString(resolver, "debug_app", packageName);
                Settings.Global.putInt(resolver, "wait_for_debugger", waitForDebugger ? 1 : 0);
            }
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (!persistent) {
                        this.mOrigDebugApp = this.mDebugApp;
                        this.mOrigWaitForDebugger = this.mWaitForDebugger;
                    }
                    this.mDebugApp = packageName;
                    this.mWaitForDebugger = waitForDebugger;
                    boolean bl = this.mDebugTransient = !persistent;
                    if (packageName != null) {
                        this.forceStopPackageLocked(packageName, -1, false, false, true, true, false, -1, "set debug app");
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl26 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setAgentApp(String packageName, String agent) {
        block8: {
            block9: {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (agent == null) {
                        if (this.mAppAgentMap == null) break block8;
                        this.mAppAgentMap.remove(packageName);
                        if (this.mAppAgentMap.isEmpty()) {
                            this.mAppAgentMap = null;
                        }
                        break block8;
                    }
                    if (this.mAppAgentMap == null) {
                        this.mAppAgentMap = new HashMap<String, String>();
                    }
                    if (this.mAppAgentMap.size() < 100) break block9;
                    Slog.e("ActivityManager", "App agent map has too many entries, cannot add " + packageName + "/" + agent);
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            this.mAppAgentMap.put(packageName, agent);
            // MONITOREXIT : activityManagerService
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTrackAllocationApp(ApplicationInfo app, String processName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                if (!isDebuggable && (app.flags & 2) == 0) {
                    throw new SecurityException("Process not debuggable: " + app.packageName);
                }
                this.mTrackAllocationApp = processName;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileApp(ApplicationInfo app, String processName, ProfilerInfo profilerInfo) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                if (!isDebuggable && !app.isProfileableByShell()) {
                    throw new SecurityException("Process not debuggable, and not profileable by shell: " + app.packageName);
                }
                this.mProfileData.setProfileApp(processName);
                if (this.mProfileData.getProfilerInfo() != null && this.mProfileData.getProfilerInfo().profileFd != null) {
                    try {
                        this.mProfileData.getProfilerInfo().profileFd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.mProfileData.setProfilerInfo(new ProfilerInfo(profilerInfo));
                this.mProfileType = 0;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void setNativeDebuggingAppLocked(ApplicationInfo app, String processName) {
        boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
        if (!isDebuggable && (app.flags & 2) == 0) {
            throw new SecurityException("Process not debuggable: " + app.packageName);
        }
        this.mNativeDebuggingApp = processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setAlwaysFinish(boolean enabled) {
        this.enforceCallingPermission("android.permission.SET_ALWAYS_FINISH", "setAlwaysFinish()");
        long ident = Binder.clearCallingIdentity();
        try {
            Settings.Global.putInt(this.mContext.getContentResolver(), "always_finish_activities", enabled ? 1 : 0);
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mAlwaysFinishActivities = enabled;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public void setActivityController(IActivityController controller, boolean imAMonkey) {
        this.mActivityTaskManager.setActivityController(controller, imAMonkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIsMonkey(boolean userIsMonkey) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    int callingPid = Binder.getCallingPid();
                    ProcessRecord proc = this.mPidsSelfLocked.get(callingPid);
                    if (proc == null) {
                        throw new SecurityException("Unknown process: " + callingPid);
                    }
                    if (proc.getActiveInstrumentation() == null || proc.getActiveInstrumentation().mUiAutomationConnection == null) {
                        throw new SecurityException("Only an instrumentation process with a UiAutomation can call setUserIsMonkey");
                    }
                }
                this.mUserIsMonkey = userIsMonkey;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUserAMonkey() {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.mUserIsMonkey || this.mActivityTaskManager.isControllerAMonkey();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSystemServerHeapDump() {
        ProcessRecord pr;
        if (!Build.IS_DEBUGGABLE) {
            Slog.wtf("ActivityManager", "requestSystemServerHeapDump called on a user build");
            return;
        }
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system process is allowed to request a system heap dump");
        }
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            pr = this.mPidsSelfLocked.get(android.os.Process.myPid());
        }
        if (pr == null) {
            Slog.w("ActivityManager", "system process not in mPidsSelfLocked: " + android.os.Process.myPid());
            return;
        }
        object = this;
        synchronized (object) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.startHeapDumpLocked(pr, true);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl28 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    @Deprecated
    public void requestBugReport(int bugreportType) {
        String extraOptions = null;
        switch (bugreportType) {
            case 0: {
                extraOptions = "bugreportfull";
                break;
            }
            case 1: {
                extraOptions = "bugreportplus";
                break;
            }
            case 2: {
                extraOptions = "bugreportremote";
                break;
            }
            case 3: {
                extraOptions = "bugreportwear";
                break;
            }
            case 4: {
                extraOptions = "bugreporttelephony";
                break;
            }
            case 5: {
                extraOptions = "bugreportwifi";
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided bugreport type is not correct, value: " + bugreportType);
            }
        }
        String type = extraOptions == null ? "bugreport" : extraOptions;
        Slog.i("ActivityManager", type + " requested by UID " + Binder.getCallingUid());
        this.enforceCallingPermission("android.permission.DUMP", "requestBugReport");
        if (extraOptions != null) {
            SystemProperties.set("dumpstate.options", extraOptions);
        }
        SystemProperties.set("ctl.start", "bugreport");
    }

    @Deprecated
    private void requestBugReportWithDescription(String shareTitle, String shareDescription, int bugreportType) {
        if (!TextUtils.isEmpty(shareTitle)) {
            if (shareTitle.length() > 50) {
                String errorStr = "shareTitle should be less than 50 characters";
                throw new IllegalArgumentException(errorStr);
            }
            if (!TextUtils.isEmpty(shareDescription)) {
                int length;
                try {
                    length = shareDescription.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException e) {
                    String errorStr = "shareDescription: UnsupportedEncodingException";
                    throw new IllegalArgumentException(errorStr);
                }
                if (length > 91) {
                    String errorStr = "shareTitle should be less than 91 bytes";
                    throw new IllegalArgumentException(errorStr);
                }
                SystemProperties.set("dumpstate.options.description", shareDescription);
            }
            SystemProperties.set("dumpstate.options.title", shareTitle);
        }
        Slog.d("ActivityManager", "Bugreport notification title " + shareTitle + " description " + shareDescription);
        this.requestBugReport(bugreportType);
    }

    @Override
    @Deprecated
    public void requestTelephonyBugReport(String shareTitle, String shareDescription) {
        this.requestBugReportWithDescription(shareTitle, shareDescription, 4);
    }

    @Override
    @Deprecated
    public void requestWifiBugReport(String shareTitle, String shareDescription) {
        this.requestBugReportWithDescription(shareTitle, shareDescription, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProcessObserver(IProcessObserver observer) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerProcessObserver()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mProcessObservers.register(observer);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProcessObserver(IProcessObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mProcessObservers.unregister(observer);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getUidProcessState(int uid, String callingPackage) {
        int n;
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "getUidProcessState");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mProcessList.getUidProcStateLocked(uid);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUidObserver(IUidObserver observer, int which, int cutpoint, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "registerUidObserver");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mUidObservers.register(observer, new UidObserverRegistration(Binder.getCallingUid(), callingPackage, which, cutpoint));
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUidObserver(IUidObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mUidObservers.unregister(observer);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUidActive(int uid, String callingPackage) {
        boolean bl;
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "isUidActive");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.isUidActiveLocked(uid);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    boolean isUidActiveLocked(int uid) {
        UidRecord uidRecord = this.mProcessList.getUidRecordLocked(uid);
        return uidRecord != null && !uidRecord.setIdle;
    }

    @Override
    public void setPersistentVrThread(int tid) {
        this.mActivityTaskManager.setPersistentVrThread(tid);
    }

    public static boolean scheduleAsRegularPriority(int tid, boolean suppressLogs) {
        block4: {
            try {
                android.os.Process.setThreadScheduler(tid, 0, 0);
                return true;
            }
            catch (IllegalArgumentException e) {
                if (!suppressLogs) {
                    Slog.w("ActivityManager", "Failed to set scheduling policy, thread does not exist:\n" + e);
                }
            }
            catch (SecurityException e) {
                if (suppressLogs) break block4;
                Slog.w("ActivityManager", "Failed to set scheduling policy, not allowed:\n" + e);
            }
        }
        return false;
    }

    public static boolean scheduleAsFifoPriority(int tid, boolean suppressLogs) {
        block4: {
            try {
                android.os.Process.setThreadScheduler(tid, 0x40000001, 1);
                return true;
            }
            catch (IllegalArgumentException e) {
                if (!suppressLogs) {
                    Slog.w("ActivityManager", "Failed to set scheduling policy, thread does not exist:\n" + e);
                }
            }
            catch (SecurityException e) {
                if (suppressLogs) break block4;
                Slog.w("ActivityManager", "Failed to set scheduling policy, not allowed:\n" + e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setRenderThread(int tid) {
        int pid;
        block11: {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                pid = Binder.getCallingPid();
                if (pid != android.os.Process.myPid()) break block11;
                this.demoteSystemServerRenderThread(tid);
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        PidMap pidMap = this.mPidsSelfLocked;
        // MONITORENTER : pidMap
        ProcessRecord proc = this.mPidsSelfLocked.get(pid);
        if (proc != null && proc.renderThreadTid == 0 && tid > 0) {
            if (!android.os.Process.isThreadInProcess(pid, tid)) {
                throw new IllegalArgumentException("Render thread does not belong to process");
            }
            proc.renderThreadTid = tid;
            if (proc.getCurrentSchedulingGroup() == 3) {
                if (this.mUseFifoUiScheduling) {
                    android.os.Process.setThreadScheduler(proc.renderThreadTid, 0x40000001, 1);
                } else {
                    android.os.Process.setThreadPriority(proc.renderThreadTid, -10);
                }
            }
        }
        // MONITOREXIT : pidMap
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void demoteSystemServerRenderThread(int tid) {
        android.os.Process.setThreadPriority(tid, 10);
    }

    @Override
    public boolean isVrModePackageEnabled(ComponentName packageName) {
        this.mActivityTaskManager.enforceSystemHasVrFeature();
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        return vrService.hasVrPackage(packageName, UserHandle.getCallingUserId()) == 0;
    }

    @Override
    public boolean isTopActivityImmersive() {
        return this.mActivityTaskManager.isTopActivityImmersive();
    }

    @Override
    public boolean isTopOfTask(IBinder token) {
        return this.mActivityTaskManager.isTopOfTask(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setHasTopUi(boolean hasTopUi) throws RemoteException {
        ProcessRecord pr;
        boolean changed;
        block14: {
            if (this.checkCallingPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0) {
                String msg = "Permission Denial: setHasTopUi() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERNAL_SYSTEM_WINDOW";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            int pid = Binder.getCallingPid();
            long origId = Binder.clearCallingIdentity();
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                changed = false;
                PidMap pidMap = this.mPidsSelfLocked;
                // MONITORENTER : pidMap
                pr = this.mPidsSelfLocked.get(pid);
                if (pr != null) break block14;
                Slog.w("ActivityManager", "setHasTopUi called on unknown pid: " + pid);
                // MONITOREXIT : pidMap
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            Binder.restoreCallingIdentity(origId);
            return;
        }
        if (pr.hasTopUi() != hasTopUi) {
            pr.setHasTopUi(hasTopUi);
            changed = true;
        }
        // MONITOREXIT : pidMap
        if (changed) {
            this.updateOomAdjLocked(pr, true, "updateOomAdj_uiVisibility");
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void setRunningRemoteAnimation(int pid, boolean runningRemoteAnimation) {
        ProcessRecord pr;
        block10: {
            block9: {
                if (pid == android.os.Process.myPid()) {
                    Slog.wtf("ActivityManager", "system can't run remote animation");
                    return;
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    PidMap pidMap = this.mPidsSelfLocked;
                    // MONITORENTER : pidMap
                    pr = this.mPidsSelfLocked.get(pid);
                    if (pr != null) break block9;
                    Slog.w("ActivityManager", "setRunningRemoteAnimation called on unknown pid: " + pid);
                    // MONITOREXIT : pidMap
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            // MONITOREXIT : pidMap
            if (pr.runningRemoteAnimation != runningRemoteAnimation) break block10;
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        pr.runningRemoteAnimation = runningRemoteAnimation;
        this.updateOomAdjLocked(pr, true, "updateOomAdj_uiVisibility");
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enterSafeMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (!this.mSystemReady) {
                    try {
                        AppGlobals.getPackageManager().enterSafeMode();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mSafeMode = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    public final void showSafeModeOverlay() {
        View v = LayoutInflater.from(this.mContext).inflate(17367265, null);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = 2015;
        lp.width = -2;
        lp.height = -2;
        lp.gravity = 8388691;
        lp.format = v.getBackground().getOpacity();
        lp.flags = 24;
        lp.privateFlags |= 0x10;
        ((WindowManager)this.mContext.getSystemService("window")).addView(v, lp);
    }

    @Override
    public void noteWakeupAlarm(IIntentSender sender, WorkSource workSource, int sourceUid, String sourcePkg, String tag) {
        if (workSource != null && workSource.isEmpty()) {
            workSource = null;
        }
        if (sourceUid <= 0 && workSource == null) {
            if (sender != null) {
                if (!(sender instanceof PendingIntentRecord)) {
                    return;
                }
                PendingIntentRecord rec = (PendingIntentRecord)sender;
                int callerUid = Binder.getCallingUid();
                sourceUid = rec.uid == callerUid ? 1000 : rec.uid;
            } else {
                return;
            }
        }
        int standbyBucket = 0;
        this.mBatteryStatsService.noteWakupAlarm(sourcePkg, sourceUid, workSource, tag);
        if (workSource != null) {
            String workSourcePackage = workSource.getName(0);
            int workSourceUid = workSource.getAttributionUid();
            if (workSourcePackage == null) {
                workSourcePackage = sourcePkg;
                workSourceUid = sourceUid;
            }
            if (this.mUsageStatsService != null) {
                standbyBucket = this.mUsageStatsService.getAppStandbyBucket(workSourcePackage, UserHandle.getUserId(workSourceUid), SystemClock.elapsedRealtime());
            }
            StatsLog.write(35, workSource, tag, sourcePkg, standbyBucket);
        } else {
            if (this.mUsageStatsService != null) {
                standbyBucket = this.mUsageStatsService.getAppStandbyBucket(sourcePkg, UserHandle.getUserId(sourceUid), SystemClock.elapsedRealtime());
            }
            StatsLog.write_non_chained(35, sourceUid, null, tag, sourcePkg, standbyBucket);
        }
    }

    @Override
    public void noteAlarmStart(IIntentSender sender, WorkSource workSource, int sourceUid, String tag) {
        if (workSource != null && workSource.isEmpty()) {
            workSource = null;
        }
        if (sourceUid <= 0 && workSource == null) {
            if (sender != null) {
                if (!(sender instanceof PendingIntentRecord)) {
                    return;
                }
                PendingIntentRecord rec = (PendingIntentRecord)sender;
                int callerUid = Binder.getCallingUid();
                sourceUid = rec.uid == callerUid ? 1000 : rec.uid;
            } else {
                return;
            }
        }
        this.mBatteryStatsService.noteAlarmStart(tag, workSource, sourceUid);
    }

    @Override
    public void noteAlarmFinish(IIntentSender sender, WorkSource workSource, int sourceUid, String tag) {
        if (workSource != null && workSource.isEmpty()) {
            workSource = null;
        }
        if (sourceUid <= 0 && workSource == null) {
            if (sender != null) {
                if (!(sender instanceof PendingIntentRecord)) {
                    return;
                }
                PendingIntentRecord rec = (PendingIntentRecord)sender;
                int callerUid = Binder.getCallingUid();
                sourceUid = rec.uid == callerUid ? 1000 : rec.uid;
            } else {
                return;
            }
        }
        this.mBatteryStatsService.noteAlarmFinish(tag, workSource, sourceUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean killPids(int[] pids, String pReason, boolean secure) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killPids only available to the system");
        }
        String reason = pReason == null ? "Unknown" : pReason;
        boolean killed = false;
        PidMap pidMap = this.mPidsSelfLocked;
        synchronized (pidMap) {
            ProcessRecord proc;
            int i;
            int worstType = 0;
            for (i = 0; i < pids.length; ++i) {
                int type;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (type = proc.setAdj) <= worstType) continue;
                worstType = type;
            }
            if (worstType < 999 && worstType > 900) {
                worstType = 900;
            }
            if (!secure && worstType < 500) {
                worstType = 500;
            }
            Slog.w("ActivityManager", "Killing processes " + reason + " at adjustment " + worstType);
            for (i = 0; i < pids.length; ++i) {
                int adj;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (adj = proc.setAdj) < worstType || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killUid(int appId, int userId, String reason) {
        this.enforceCallingPermission("android.permission.KILL_UID", "killUid");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mProcessList.killPackageProcessesLocked(null, appId, userId, -800, false, true, true, true, false, reason != null ? reason : "kill uid");
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public boolean killProcessesBelowForeground(String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowForeground() only available to system");
        }
        return this.killProcessesBelowAdj(0, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killProcessesBelowAdj(int belowAdj, String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowAdj() only available to system");
        }
        boolean killed = false;
        PidMap pidMap = this.mPidsSelfLocked;
        synchronized (pidMap) {
            int size = this.mPidsSelfLocked.size();
            for (int i = 0; i < size; ++i) {
                int adj;
                int pid = this.mPidsSelfLocked.keyAt(i);
                ProcessRecord proc = this.mPidsSelfLocked.valueAt(i);
                if (proc == null || (adj = proc.setAdj) <= belowAdj || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hang(IBinder who, boolean allowRestart) {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        IBinder.DeathRecipient death = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                15 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        };
        try {
            who.linkToDeath(death, 0);
        }
        catch (RemoteException e) {
            Slog.w("ActivityManager", "hang: given caller IBinder is already dead.");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                Watchdog.getInstance().setAllowRestart(allowRestart);
                Slog.i("ActivityManager", "Hanging system process at request of pid " + Binder.getCallingPid());
                IBinder.DeathRecipient deathRecipient = death;
                synchronized (deathRecipient) {
                    while (who.isBinderAlive()) {
                        try {
                            death.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Watchdog.getInstance().setAllowRestart(true);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[4, 9] lbl36 : MonitorExitStatement: MONITOREXIT : var4_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void restart() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        Log.i("ActivityManager", "Sending shutdown broadcast...");
        BroadcastReceiver br = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.i("ActivityManager", "Shutting down activity manager...");
                ActivityManagerService.this.shutdown(10000);
                Log.i("ActivityManager", "Shutdown complete, restarting!");
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
            }
        };
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
        br.onReceive(this.mContext, intent);
    }

    private long getLowRamTimeSinceIdle(long now) {
        return this.mLowRamTimeSinceLastIdle + (this.mLowRamStartTime > 0L ? now - this.mLowRamStartTime : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performIdleMaintenance() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long now = SystemClock.uptimeMillis();
                long timeSinceLastIdle = now - this.mLastIdleTime;
                this.mOomAdjuster.mAppCompact.compactAllSystem();
                long lowRamSinceLastIdle = this.getLowRamTimeSinceIdle(now);
                this.mLastIdleTime = now;
                this.mLowRamTimeSinceLastIdle = 0L;
                if (this.mLowRamStartTime != 0L) {
                    this.mLowRamStartTime = now;
                }
                StringBuilder sb = new StringBuilder(128);
                sb.append("Idle maintenance over ");
                TimeUtils.formatDuration(timeSinceLastIdle, sb);
                sb.append(" low RAM for ");
                TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
                Slog.i("ActivityManager", sb.toString());
                boolean doKilling = lowRamSinceLastIdle > timeSinceLastIdle / 3L;
                long totalMemoryInKb = android.os.Process.getTotalMemory() / 1000L;
                long memoryGrowthThreshold = Math.max(totalMemoryInKb / 100L, 10000L);
                for (int i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mProcessList.mLruProcesses.get(i);
                    if (proc.notCachedSinceIdle) {
                        if (proc.setProcState < 6 || proc.setProcState > 11 || !doKilling || proc.initialIdlePss == 0L || proc.lastPss <= proc.initialIdlePss * 3L / 2L || proc.lastPss <= proc.initialIdlePss + memoryGrowthThreshold) continue;
                        sb = new StringBuilder(128);
                        sb.append("Kill");
                        sb.append(proc.processName);
                        sb.append(" in idle maint: pss=");
                        sb.append(proc.lastPss);
                        sb.append(", swapPss=");
                        sb.append(proc.lastSwapPss);
                        sb.append(", initialPss=");
                        sb.append(proc.initialIdlePss);
                        sb.append(", period=");
                        TimeUtils.formatDuration(timeSinceLastIdle, sb);
                        sb.append(", lowRamPeriod=");
                        TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
                        Slog.wtfQuiet("ActivityManager", sb.toString());
                        proc.kill("idle maint (pss " + proc.lastPss + " from " + proc.initialIdlePss + ")", true);
                        continue;
                    }
                    if (proc.setProcState >= 15 || proc.setProcState < 0) continue;
                    proc.notCachedSinceIdle = true;
                    proc.initialIdlePss = 0L;
                    proc.nextPssTime = ProcessList.computeNextPssTime(proc.setProcState, null, this.mTestPssMode, this.mAtmInternal.isSleeping(), now);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl65 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendIdleJobTrigger() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent(ACTION_TRIGGER_IDLE).setPackage("android").addFlags(0x40000000);
            this.broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, false, false, -1);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        this.mActivityTaskManager.retrieveSettings(resolver);
        String debugApp = Settings.Global.getString(resolver, "debug_app");
        boolean waitForDebugger = Settings.Global.getInt(resolver, "wait_for_debugger", 0) != 0;
        boolean alwaysFinishActivities = Settings.Global.getInt(resolver, "always_finish_activities", 0) != 0;
        long waitForNetworkTimeoutMs = Settings.Global.getLong(resolver, "network_access_timeout_ms", 200L);
        this.mHiddenApiBlacklist.registerObserver();
        long pssDeferralMs = DeviceConfig.getLong("activity_manager", ACTIVITY_START_PSS_DEFER_CONFIG, 0L);
        DeviceConfig.addOnPropertiesChangedListener("activity_manager", ActivityThread.currentApplication().getMainExecutor(), this.mPssDelayConfigListener);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mDebugApp = this.mOrigDebugApp = debugApp;
                this.mWaitForDebugger = this.mOrigWaitForDebugger = waitForDebugger;
                this.mAlwaysFinishActivities = alwaysFinishActivities;
                Resources res = this.mContext.getResources();
                this.mAppErrors.loadAppsNotReportingCrashesFromConfigLocked(res.getString(17039672));
                this.mUserController.mUserSwitchUiEnabled = !res.getBoolean(17891395);
                this.mUserController.mMaxRunningUsers = res.getInteger(17694845);
                this.mUserController.mDelayUserDataLocking = res.getBoolean(17891480);
                this.mWaitForNetworkTimeoutMs = waitForNetworkTimeoutMs;
                this.mPssDeferralTime = pssDeferralMs;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl27 : MonitorExitStatement: MONITOREXIT : var9_7
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void systemReady(Runnable goingCallback, TimingsTraceLog traceLog) {
        traceLog.traceBegin("PhaseActivityManagerReady");
        var3_3 = this;
        synchronized (var3_3) {
            ActivityManagerService.boostPriorityForLockedSection();
            if (!this.mSystemReady) ** break block32
            if (goingCallback != null) {
                goingCallback.run();
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {
                this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
                this.mActivityTaskManager.onSystemReady();
                this.mUserController.onSystemReady();
                this.mAppOpsService.systemReady();
                this.mSystemReady = true;
            }
            catch (Throwable var4_5) {
                // MONITOREXIT @DISABLED, blocks:[9, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var4_5;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        try {
            ActivityManagerService.sTheRealBuildSerial = IDeviceIdentifiersPolicyService.Stub.asInterface(ServiceManager.getService("device_identifiers")).getSerial();
        }
        catch (RemoteException var3_4) {
            // empty catch block
        }
        procsToKill = null;
        var4_6 = this.mPidsSelfLocked;
        synchronized (var4_6) {
            for (i = this.mPidsSelfLocked.size() - 1; i >= 0; --i) {
                proc = this.mPidsSelfLocked.valueAt(i);
                if (this.isAllowedWhileBooting(proc.info)) continue;
                if (procsToKill == null) {
                    procsToKill = new ArrayList<ProcessRecord>();
                }
                procsToKill.add(proc);
            }
        }
        var4_6 = this;
        synchronized (var4_6) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (procsToKill != null) {
                    for (i = procsToKill.size() - 1; i >= 0; --i) {
                        proc = (ProcessRecord)procsToKill.get(i);
                        Slog.i("ActivityManager", "Removing system update proc: " + proc);
                        this.mProcessList.removeProcessLocked(proc, true, false, "system update done");
                    }
                }
                this.mProcessesReady = true;
            }
            catch (Throwable var8_12) {
                // MONITOREXIT @DISABLED, blocks:[16, 11] lbl63 : MonitorExitStatement: MONITOREXIT : var4_6
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var8_12;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        Slog.i("ActivityManager", "System now ready");
        EventLog.writeEvent(3040, SystemClock.uptimeMillis());
        this.mAtmInternal.updateTopComponentForFactoryTest();
        this.mAtmInternal.getLaunchObserverRegistry().registerLaunchObserver(this.mActivityLaunchObserver);
        this.watchDeviceProvisioning(this.mContext);
        this.retrieveSettings();
        this.mUgmInternal.onSystemReady();
        pmi = LocalServices.getService(PowerManagerInternal.class);
        if (pmi != null) {
            pmi.registerLowPowerModeObserver(12, (Consumer<PowerSaveState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$systemReady$1(android.os.PowerSaveState ), (Landroid/os/PowerSaveState;)V)((ActivityManagerService)this));
            this.updateForceBackgroundCheck(pmi.getLowPowerState((int)12).batterySaverEnabled);
        } else {
            Slog.wtf("ActivityManager", "PowerManagerInternal not found.");
        }
        if (goingCallback != null) {
            goingCallback.run();
        }
        currentUserId = this.mUserController.getCurrentUserId();
        Slog.i("ActivityManager", "Current user:" + currentUserId);
        if (currentUserId != 0 && !this.mUserController.isSystemUserStarted()) {
            throw new RuntimeException("System user not started while current user is:" + currentUserId);
        }
        traceLog.traceBegin("ActivityManagerStartApps");
        this.mBatteryStatsService.noteEvent(32775, Integer.toString(currentUserId), currentUserId);
        this.mBatteryStatsService.noteEvent(32776, Integer.toString(currentUserId), currentUserId);
        this.mSystemServiceManager.startUser(currentUserId);
        var6_8 = this;
        synchronized (var6_8) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.startPersistentApps(524288);
                this.mBooting = true;
                if (UserManager.isSplitSystemUser() && Settings.Secure.getInt(this.mContext.getContentResolver(), "user_setup_complete", 0) != 0) {
                    cName = new ComponentName(this.mContext, SystemUserHomeActivity.class);
                    try {
                        AppGlobals.getPackageManager().setComponentEnabledSetting(cName, 1, 0, 0);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowAsRuntimeException();
                    }
                }
                this.mAtmInternal.startHomeOnAllDisplays(currentUserId, "systemReady");
                this.mAtmInternal.showSystemReadyErrorDialogsIfNeeded();
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                ident = Binder.clearCallingIdentity();
                try {
                    intent = new Intent("android.intent.action.USER_STARTED");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", currentUserId);
                    this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, callingUid, callingPid, currentUserId);
                    intent = new Intent("android.intent.action.USER_STARTING");
                    intent.addFlags(0x40000000);
                    intent.putExtra("android.intent.extra.user_handle", currentUserId);
                    this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                        @Override
                        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                        }
                    }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, callingUid, callingPid, -1);
                }
                catch (Throwable t) {
                    Slog.wtf("ActivityManager", "Failed sending first user broadcasts", t);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                this.mAtmInternal.resumeTopActivities(false);
                this.mUserController.sendUserSwitchBroadcasts(-1, currentUserId);
                BinderInternal.nSetBinderProxyCountWatermarks(6000, 5500);
                BinderInternal.nSetBinderProxyCountEnabled(true);
                BinderInternal.setBinderProxyCountCallback(new BinderInternal.BinderProxyLimitListener(){

                    @Override
                    public void onLimitReached(int uid) {
                        Slog.wtf("ActivityManager", "Uid " + uid + " sent too many Binders to uid " + android.os.Process.myUid());
                        BinderProxy.dumpProxyDebugInfo();
                        if (uid == 1000) {
                            Slog.i("ActivityManager", "Skipping kill (uid is SYSTEM)");
                        } else {
                            ActivityManagerService.this.killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), "Too many Binders sent to SYSTEM");
                        }
                    }
                }, this.mHandler);
                traceLog.traceEnd();
                traceLog.traceEnd();
            }
            catch (Throwable var13_19) {
                // MONITOREXIT @DISABLED, blocks:[20, 12] lbl146 : MonitorExitStatement: MONITOREXIT : var6_8
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var13_19;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void watchDeviceProvisioning(final Context context) {
        if (this.isDeviceProvisioned(context)) {
            SystemProperties.set(SYSTEM_PROPERTY_DEVICE_PROVISIONED, "1");
        } else {
            context.getContentResolver().registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, new ContentObserver(new Handler(Looper.getMainLooper())){

                @Override
                public void onChange(boolean selfChange) {
                    if (ActivityManagerService.this.isDeviceProvisioned(context)) {
                        SystemProperties.set(ActivityManagerService.SYSTEM_PROPERTY_DEVICE_PROVISIONED, "1");
                        context.getContentResolver().unregisterContentObserver(this);
                    }
                }
            });
        }
    }

    private boolean isDeviceProvisioned(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "device_provisioned", 0) != 0;
    }

    private void startBroadcastObservers() {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.start(this.mContext.getContentResolver());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForceBackgroundCheck(boolean enabled) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mForceBackgroundCheck != enabled) {
                    this.mForceBackgroundCheck = enabled;
                    if (this.mForceBackgroundCheck) {
                        this.mProcessList.doStopUidForIdleUidsLocked();
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAppAtUsersRequest(ProcessRecord app, Dialog fromDialog) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mAppErrors.killAppAtUserRequestLocked(app, fromDialog);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void skipCurrentReceiverLocked(ProcessRecord app) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipCurrentReceiverLocked(app);
        }
    }

    @Override
    public void handleApplicationCrash(IBinder app, ApplicationErrorReport.ParcelableCrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "Crash");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        this.handleApplicationCrashInner("crash", r, processName, crashInfo);
    }

    void handleApplicationCrashInner(String eventType, ProcessRecord r, String processName, ApplicationErrorReport.CrashInfo crashInfo) {
        EventLog.writeEvent(30039, Binder.getCallingPid(), UserHandle.getUserId(Binder.getCallingUid()), processName, r == null ? -1 : r.info.flags, crashInfo.exceptionClassName, crashInfo.exceptionMessage, crashInfo.throwFileName, crashInfo.throwLineNumber);
        StatsLog.write(78, Binder.getCallingUid(), eventType, processName, Binder.getCallingPid(), r != null && r.info != null ? r.info.packageName : "", r != null && r.info != null ? (r.info.isInstantApp() ? 2 : 1) : 0, r != null ? (r.isInterestingToUserLocked() ? 2 : 1) : 0, processName.equals("system_server") ? 3 : (r != null ? r.getProcessClassEnum() : 0));
        int relaunchReason = r == null ? 0 : r.getWindowProcessController().computeRelaunchReason();
        String relaunchReasonString = ActivityTaskManagerService.relaunchReasonToString(relaunchReason);
        crashInfo.crashTag = crashInfo.crashTag == null ? relaunchReasonString : crashInfo.crashTag + " " + relaunchReasonString;
        this.addErrorToDropBox(eventType, r, processName, null, null, null, null, null, null, crashInfo);
        this.mAppErrors.crashApplication(r, crashInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleApplicationStrictModeViolation(IBinder app, int penaltyMask, StrictMode.ViolationInfo info) {
        block11: {
            ProcessRecord r = this.findAppProcess(app, "StrictMode");
            if ((penaltyMask & 0x4000000) != 0) {
                Integer stackFingerprint = info.hashCode();
                boolean logIt = true;
                HashSet<Integer> hashSet = this.mAlreadyLoggedViolatedStacks;
                synchronized (hashSet) {
                    if (this.mAlreadyLoggedViolatedStacks.contains(stackFingerprint)) {
                        logIt = false;
                    } else {
                        if (this.mAlreadyLoggedViolatedStacks.size() >= 5000) {
                            this.mAlreadyLoggedViolatedStacks.clear();
                        }
                        this.mAlreadyLoggedViolatedStacks.add(stackFingerprint);
                    }
                }
                if (logIt) {
                    this.logStrictModeViolationToDropBox(r, info);
                }
            }
            if ((penaltyMask & 0x20000000) == 0) break block11;
            AppErrorResult result = new AppErrorResult();
            ActivityManagerService logIt = this;
            synchronized (logIt) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    long origId = Binder.clearCallingIdentity();
                    Message msg = Message.obtain();
                    msg.what = 26;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("result", result);
                    data.put("app", r);
                    data.put("info", info);
                    msg.obj = data;
                    this.mUiHandler.sendMessage(msg);
                    Binder.restoreCallingIdentity(origId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 5] lbl45 : MonitorExitStatement: MONITOREXIT : logIt
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            int res = result.get();
            Slog.w("ActivityManager", "handleApplicationStrictModeViolation; res=" + res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStrictModeViolationToDropBox(ProcessRecord process, StrictMode.ViolationInfo info) {
        StringBuilder sb;
        if (info == null) {
            return;
        }
        boolean isSystemApp = process == null || (process.info.flags & 0x81) != 0;
        String processName = process == null ? "unknown" : process.processName;
        DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        String dropboxTag = ActivityManagerService.processClass(process) + "_strictmode";
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        StringBuilder stringBuilder = sb = new StringBuilder(1024);
        synchronized (stringBuilder) {
            this.appendDropBoxProcessHeaders(process, processName, sb);
            sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
            sb.append("System-App: ").append(isSystemApp).append("\n");
            sb.append("Uptime-Millis: ").append(info.violationUptimeMillis).append("\n");
            if (info.violationNumThisLoop != 0) {
                sb.append("Loop-Violation-Number: ").append(info.violationNumThisLoop).append("\n");
            }
            if (info.numAnimationsRunning != 0) {
                sb.append("Animations-Running: ").append(info.numAnimationsRunning).append("\n");
            }
            if (info.broadcastIntentAction != null) {
                sb.append("Broadcast-Intent-Action: ").append(info.broadcastIntentAction).append("\n");
            }
            if (info.durationMillis != -1) {
                sb.append("Duration-Millis: ").append(info.durationMillis).append("\n");
            }
            if (info.numInstances != -1L) {
                sb.append("Instance-Count: ").append(info.numInstances).append("\n");
            }
            if (info.tags != null) {
                for (String tag : info.tags) {
                    sb.append("Span-Tag: ").append(tag).append("\n");
                }
            }
            sb.append("\n");
            sb.append(info.getStackTrace());
            sb.append("\n");
            if (info.getViolationDetails() != null) {
                sb.append(info.getViolationDetails());
                sb.append("\n");
            }
        }
        String res = sb.toString();
        IoThread.getHandler().post(() -> dbox.addText(dropboxTag, res));
    }

    @Override
    public boolean handleApplicationWtf(final IBinder app, final String tag, boolean system, final ApplicationErrorReport.ParcelableCrashInfo crashInfo) {
        boolean isSystem;
        final int callingUid = Binder.getCallingUid();
        final int callingPid = Binder.getCallingPid();
        if (system) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
                }
            });
            return false;
        }
        ProcessRecord r = this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
        boolean isFatal = Build.IS_ENG || Settings.Global.getInt(this.mContext.getContentResolver(), "wtf_is_fatal", 0) != 0;
        boolean bl = isSystem = r == null || r.isPersistent();
        if (isFatal && !isSystem) {
            this.mAppErrors.crashApplication(r, crashInfo);
            return true;
        }
        return false;
    }

    ProcessRecord handleApplicationWtfInner(int callingUid, int callingPid, IBinder app, String tag, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "WTF");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent(30040, UserHandle.getUserId(callingUid), callingPid, processName, r == null ? -1 : r.info.flags, tag, crashInfo.exceptionMessage);
        StatsLog.write(80, callingUid, tag, processName, callingPid, r != null ? r.getProcessClassEnum() : 0);
        this.addErrorToDropBox("wtf", r, processName, null, null, null, tag, null, null, crashInfo);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProcessRecord findAppProcess(IBinder app, String reason) {
        ProcessRecord processRecord;
        if (app == null) {
            return null;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                processRecord = this.mProcessList.findAppProcessLocked(app, reason);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return processRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDropBoxProcessHeaders(ProcessRecord process, String processName, StringBuilder sb) {
        if (process == null) {
            sb.append("Process: ").append(processName).append("\n");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                sb.append("Process: ").append(processName).append("\n");
                sb.append("PID: ").append(process.pid).append("\n");
                sb.append("UID: ").append(process.uid).append("\n");
                int flags = process.info.flags;
                IPackageManager pm = AppGlobals.getPackageManager();
                sb.append("Flags: 0x").append(Integer.toHexString(flags)).append("\n");
                for (int ip = 0; ip < process.pkgList.size(); ++ip) {
                    String pkg = process.pkgList.keyAt(ip);
                    sb.append("Package: ").append(pkg);
                    try {
                        PackageInfo pi = pm.getPackageInfo(pkg, 0, UserHandle.getCallingUserId());
                        if (pi != null) {
                            sb.append(" v").append(pi.getLongVersionCode());
                            if (pi.versionName != null) {
                                sb.append(" (").append(pi.versionName).append(")");
                            }
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e("ActivityManager", "Error getting package info: " + pkg, e);
                    }
                    sb.append("\n");
                }
                if (process.info.isInstantApp()) {
                    sb.append("Instant-App: true\n");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl46 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private static String processClass(ProcessRecord process) {
        if (process == null || process.pid == MY_PID) {
            return "system_server";
        }
        if ((process.info.flags & 1) != 0) {
            return "system_app";
        }
        return "data_app";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorToDropBox(String eventType, ProcessRecord process, String processName, String activityShortComponentName, String parentShortComponentName, ProcessRecord parentProcess, String subject, final String report, final File dataFile, final ApplicationErrorReport.CrashInfo crashInfo) {
        if (ServiceManager.getService("dropbox") == null) {
            return;
        }
        final DropBoxManager dbox = this.mContext.getSystemService(DropBoxManager.class);
        final String dropboxTag = ActivityManagerService.processClass(process) + "_" + eventType;
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        if (now - this.mWtfClusterStart > 10000L) {
            this.mWtfClusterStart = now;
            this.mWtfClusterCount = 1;
        } else if (this.mWtfClusterCount++ >= 5) {
            return;
        }
        final StringBuilder sb = new StringBuilder(1024);
        this.appendDropBoxProcessHeaders(process, processName, sb);
        if (process != null) {
            sb.append("Foreground: ").append(process.isInterestingToUserLocked() ? "Yes" : "No").append("\n");
        }
        if (activityShortComponentName != null) {
            sb.append("Activity: ").append(activityShortComponentName).append("\n");
        }
        if (parentShortComponentName != null) {
            if (parentProcess != null && parentProcess.pid != process.pid) {
                sb.append("Parent-Process: ").append(parentProcess.processName).append("\n");
            }
            if (!parentShortComponentName.equals(activityShortComponentName)) {
                sb.append("Parent-Activity: ").append(parentShortComponentName).append("\n");
            }
        }
        if (subject != null) {
            sb.append("Subject: ").append(subject).append("\n");
        }
        sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            sb.append("Debugger: Connected\n");
        }
        if (crashInfo != null && crashInfo.crashTag != null && !crashInfo.crashTag.isEmpty()) {
            sb.append("Crash-Tag: ").append(crashInfo.crashTag).append("\n");
        }
        sb.append("\n");
        Thread worker = new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (report != null) {
                    sb.append(report);
                }
                String setting = "logcat_for_" + dropboxTag;
                int lines = Settings.Global.getInt(ActivityManagerService.this.mContext.getContentResolver(), setting, 0);
                int maxDataFileSize = 196608 - sb.length() - lines * 100;
                if (dataFile != null && maxDataFileSize > 0) {
                    try {
                        sb.append(FileUtils.readTextFile(dataFile, maxDataFileSize, "\n\n[[TRUNCATED]]"));
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error reading " + dataFile, e);
                    }
                }
                if (crashInfo != null && crashInfo.stackTrace != null) {
                    sb.append(crashInfo.stackTrace);
                }
                if (lines > 0) {
                    sb.append("\n");
                    InputStreamReader input = null;
                    try {
                        int num;
                        Process logcat = new ProcessBuilder("/system/bin/timeout", "-k", "15s", "10s", "/system/bin/logcat", "-v", "threadtime", "-b", "events", "-b", "system", "-b", "main", "-b", "crash", "-t", String.valueOf(lines)).redirectErrorStream(true).start();
                        try {
                            logcat.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            logcat.getErrorStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        input = new InputStreamReader(logcat.getInputStream());
                        char[] buf = new char[8192];
                        while ((num = input.read(buf)) > 0) {
                            sb.append(buf, 0, num);
                        }
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error running logcat", e);
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                dbox.addText(dropboxTag, sb.toString());
            }
        };
        if (process == null) {
            int oldMask = StrictMode.allowThreadDiskWritesMask();
            try {
                worker.run();
            }
            finally {
                StrictMode.setThreadPolicyMask(oldMask);
            }
        } else {
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() {
        this.enforceNotIsolatedCaller("getProcessesInErrorState");
        ArrayList<ActivityManager.ProcessErrorStateInfo> errList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", Binder.getCallingUid()) == 0;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord app = this.mProcessList.mLruProcesses.get(i);
                    if (!allUsers && app.userId != userId) continue;
                    boolean crashing = app.isCrashing();
                    boolean notResponding = app.isNotResponding();
                    if (app.thread == null || !crashing && !notResponding) continue;
                    ActivityManager.ProcessErrorStateInfo report = null;
                    if (crashing) {
                        report = app.crashingReport;
                    } else if (notResponding) {
                        report = app.notRespondingReport;
                    }
                    if (report != null) {
                        if (errList == null) {
                            errList = new ArrayList<ActivityManager.ProcessErrorStateInfo>(1);
                        }
                        errList.add(report);
                        continue;
                    }
                    Slog.w("ActivityManager", "Missing app error report, app = " + app.processName + " crashing = " + crashing + " notResponding = " + notResponding);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl33 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return errList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        List<ActivityManager.RunningAppProcessInfo> list;
        this.enforceNotIsolatedCaller("getRunningAppProcesses");
        int callingUid = Binder.getCallingUid();
        int clientTargetSdk = this.mPackageManagerInt.getUidTargetSdkVersion(callingUid);
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        int userId = UserHandle.getUserId(callingUid);
        boolean allUids = this.mAtmInternal.isGetTasksAllowed("getRunningAppProcesses", Binder.getCallingPid(), callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                list = this.mProcessList.getRunningAppProcessesLocked(allUsers, userId, allUids, callingUid, clientTargetSdk);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return list;
    }

    @Override
    public List<ApplicationInfo> getRunningExternalApplications() {
        this.enforceNotIsolatedCaller("getRunningExternalApplications");
        List<ActivityManager.RunningAppProcessInfo> runningApps = this.getRunningAppProcesses();
        ArrayList<ApplicationInfo> retList = new ArrayList<ApplicationInfo>();
        if (runningApps != null && runningApps.size() > 0) {
            HashSet<String> extList = new HashSet<String>();
            for (ActivityManager.RunningAppProcessInfo app : runningApps) {
                if (app.pkgList == null) continue;
                for (String pkg : app.pkgList) {
                    extList.add(pkg);
                }
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String pkg : extList) {
                try {
                    ApplicationInfo info = pm.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
                    if ((info.flags & 0x40000) == 0) continue;
                    retList.add(info);
                }
                catch (RemoteException remoteException) {}
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMyMemoryState(ActivityManager.RunningAppProcessInfo outState) {
        if (outState == null) {
            throw new IllegalArgumentException("outState is null");
        }
        this.enforceNotIsolatedCaller("getMyMemoryState");
        int callingUid = Binder.getCallingUid();
        int clientTargetSdk = this.mPackageManagerInt.getUidTargetSdkVersion(callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ProcessRecord proc;
                ActivityManagerService.boostPriorityForLockedSection();
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
                }
                if (proc != null) {
                    this.mProcessList.fillInProcMemInfoLocked(proc, outState, clientTargetSdk);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl24 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getMemoryTrimLevel() {
        int n;
        this.enforceNotIsolatedCaller("getMyMemoryState");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mLastMemoryLevel;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new ActivityManagerShellCommand(this, false).exec(this, in, out, err, args, callback, resultReceiver);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        PriorityDump.dump(this.mPriorityDumper, fd, pw, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpEverything(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage, boolean dumpClient, boolean dumpNormalPriority, int dumpAppId) {
        ActiveServices.ServiceDumper sdumper;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mConstants.dump(pw);
                this.mOomAdjuster.dumpAppCompactorSettings(pw);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpAllowedAssociationsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mPendingIntentController.dumpPendingIntents(pw, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                if (dumpAll || dumpPackage != null) {
                    this.dumpBroadcastStatsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                    pw.println();
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                }
                this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpPermissionsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                sdumper = this.mServices.newServiceDumperLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                if (!dumpClient) {
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                    sdumper.dumpLocked();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl41 : MonitorExitStatement: MONITOREXIT : var11_10
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (dumpClient) {
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            sdumper.dumpWithClient();
        }
        if (dumpPackage == null) {
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpBinderProxies(pw, 6000);
        }
        activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mAtmInternal.dump("recents", fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mAtmInternal.dump("lastanr", fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mAtmInternal.dump("starter", fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.mAtmInternal.dump("containers", fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                if (!dumpNormalPriority) {
                    pw.println();
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                    this.mAtmInternal.dump("activities", fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                }
                if (this.mAssociations.size() > 0) {
                    pw.println();
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                    this.dumpAssociationsLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
                }
                if (dumpPackage == null) {
                    pw.println();
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                    this.mOomAdjProfiler.dump(pw);
                    pw.println();
                    if (dumpAll) {
                        pw.println("-------------------------------------------------------------------------------");
                    }
                    this.dumpLmkLocked(pw);
                }
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpLruLocked(pw, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage, dumpAppId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl105 : MonitorExitStatement: MONITOREXIT : var11_10
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDump(FileDescriptor fd, PrintWriter pw, String[] args, boolean useProto) {
        int dumpAppId;
        long origId;
        int opti;
        String dumpPackage;
        boolean dumpNormalPriority;
        boolean dumpCheckinFormat;
        boolean dumpCheckin;
        boolean dumpClient;
        boolean dumpAll;
        block113: {
            boolean more;
            block112: {
                ActivityManagerShellCommand shell;
                int res;
                String cmd;
                boolean dumpFocusedStackOnly;
                boolean dumpVisibleStacksOnly;
                block131: {
                    block130: {
                        block129: {
                            block128: {
                                block127: {
                                    String[] newArgs;
                                    String name;
                                    block126: {
                                        block125: {
                                            String[] newArgs5;
                                            String name2;
                                            block124: {
                                                block123: {
                                                    block122: {
                                                        block121: {
                                                            block120: {
                                                                block119: {
                                                                    block118: {
                                                                        block117: {
                                                                            block116: {
                                                                                block115: {
                                                                                    block114: {
                                                                                        String opt;
                                                                                        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, "ActivityManager", pw)) {
                                                                                            return;
                                                                                        }
                                                                                        dumpAll = false;
                                                                                        dumpClient = false;
                                                                                        dumpCheckin = false;
                                                                                        dumpCheckinFormat = false;
                                                                                        dumpNormalPriority = false;
                                                                                        dumpVisibleStacksOnly = false;
                                                                                        dumpFocusedStackOnly = false;
                                                                                        dumpPackage = null;
                                                                                        opti = 0;
                                                                                        while (opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-') {
                                                                                            ++opti;
                                                                                            if ("-a".equals(opt)) {
                                                                                                dumpAll = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-c".equals(opt)) {
                                                                                                dumpClient = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-v".equals(opt)) {
                                                                                                dumpVisibleStacksOnly = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-f".equals(opt)) {
                                                                                                dumpFocusedStackOnly = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-p".equals(opt)) {
                                                                                                if (opti >= args.length) {
                                                                                                    pw.println("Error: -p option requires package argument");
                                                                                                    return;
                                                                                                }
                                                                                                dumpPackage = args[opti];
                                                                                                ++opti;
                                                                                                dumpClient = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("--checkin".equals(opt)) {
                                                                                                dumpCheckinFormat = true;
                                                                                                dumpCheckin = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-C".equals(opt)) {
                                                                                                dumpCheckinFormat = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("--normal-priority".equals(opt)) {
                                                                                                dumpNormalPriority = true;
                                                                                                continue;
                                                                                            }
                                                                                            if ("-h".equals(opt)) {
                                                                                                ActivityManagerShellCommand.dumpHelp(pw, true);
                                                                                                return;
                                                                                            }
                                                                                            pw.println("Unknown argument: " + opt + "; use -h for help");
                                                                                        }
                                                                                        origId = Binder.clearCallingIdentity();
                                                                                        if (useProto) {
                                                                                            ProtoOutputStream proto = new ProtoOutputStream(fd);
                                                                                            String cmd2 = opti < args.length ? args[opti] : "";
                                                                                            ++opti;
                                                                                            if ("activities".equals(cmd2) || "a".equals(cmd2)) {
                                                                                                this.mAtmInternal.writeActivitiesToProto(proto);
                                                                                            } else if ("broadcasts".equals(cmd2) || "b".equals(cmd2)) {
                                                                                                ActivityManagerService activityManagerService = this;
                                                                                                synchronized (activityManagerService) {
                                                                                                    try {
                                                                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                                                                        this.writeBroadcastsToProtoLocked(proto);
                                                                                                    }
                                                                                                    catch (Throwable throwable) {
                                                                                                        // MONITOREXIT @DISABLED, blocks:[19, 36, 108, 109, 111] lbl66 : MonitorExitStatement: MONITOREXIT : activityManagerService
                                                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                                        throw throwable;
                                                                                                    }
                                                                                                }
                                                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                            } else if ("provider".equals(cmd2)) {
                                                                                                String[] newArgs4;
                                                                                                String name3;
                                                                                                if (opti >= args.length) {
                                                                                                    Object name32 = null;
                                                                                                    String[] newArgs3 = EMPTY_STRING_ARRAY;
                                                                                                } else {
                                                                                                    name3 = args[opti];
                                                                                                    newArgs4 = new String[args.length - ++opti];
                                                                                                    if (args.length > 2) {
                                                                                                        System.arraycopy(args, opti, newArgs4, 0, args.length - opti);
                                                                                                    }
                                                                                                }
                                                                                                if (!this.dumpProviderProto(fd, pw, name3, newArgs4)) {
                                                                                                    pw.println("No providers match: " + name3);
                                                                                                    pw.println("Use -h for help.");
                                                                                                }
                                                                                            } else if ("service".equals(cmd2)) {
                                                                                                this.mServices.writeToProto(proto, 0x10B00000001L);
                                                                                            } else if ("processes".equals(cmd2) || "p".equals(cmd2)) {
                                                                                                if (opti < args.length) {
                                                                                                    dumpPackage = args[opti];
                                                                                                    ++opti;
                                                                                                }
                                                                                                ActivityManagerService newArgs4 = this;
                                                                                                synchronized (newArgs4) {
                                                                                                    try {
                                                                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                                                                        this.writeProcessesToProtoLocked(proto, dumpPackage);
                                                                                                    }
                                                                                                    catch (Throwable throwable) {
                                                                                                        // MONITOREXIT @DISABLED, blocks:[37, 21, 102, 103, 105, 107, 109, 111] lbl100 : MonitorExitStatement: MONITOREXIT : newArgs4
                                                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                                        throw throwable;
                                                                                                    }
                                                                                                }
                                                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                            } else {
                                                                                                ActivityManagerService newArgs4 = this;
                                                                                                synchronized (newArgs4) {
                                                                                                    try {
                                                                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                                                                        long activityToken = proto.start(0x10B00000001L);
                                                                                                        this.mAtmInternal.writeActivitiesToProto(proto);
                                                                                                        proto.end(activityToken);
                                                                                                        long broadcastToken = proto.start(1146756268034L);
                                                                                                        this.writeBroadcastsToProtoLocked(proto);
                                                                                                        proto.end(broadcastToken);
                                                                                                        long serviceToken = proto.start(1146756268035L);
                                                                                                        this.mServices.writeToProto(proto, 0x10B00000001L);
                                                                                                        proto.end(serviceToken);
                                                                                                        long processToken = proto.start(1146756268036L);
                                                                                                        this.writeProcessesToProtoLocked(proto, dumpPackage);
                                                                                                        proto.end(processToken);
                                                                                                    }
                                                                                                    catch (Throwable throwable) {
                                                                                                        // MONITOREXIT @DISABLED, blocks:[20, 101, 38, 103, 105, 107, 109, 111] lbl124 : MonitorExitStatement: MONITOREXIT : newArgs4
                                                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                                        throw throwable;
                                                                                                    }
                                                                                                }
                                                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                            }
                                                                                            proto.flush();
                                                                                            Binder.restoreCallingIdentity(origId);
                                                                                            return;
                                                                                        }
                                                                                        dumpAppId = this.getAppId(dumpPackage);
                                                                                        more = false;
                                                                                        if (opti >= args.length) break block113;
                                                                                        cmd = args[opti];
                                                                                        ++opti;
                                                                                        if (!"activities".equals(cmd) && !"a".equals(cmd) && !"lastanr".equals(cmd) && !"lastanr-traces".equals(cmd) && !"starter".equals(cmd) && !"containers".equals(cmd) && !"recents".equals(cmd) && !"r".equals(cmd)) break block114;
                                                                                        this.mAtmInternal.dump(cmd, fd, pw, args, opti, true, dumpClient, dumpPackage);
                                                                                        break block112;
                                                                                    }
                                                                                    if (!"binder-proxies".equals(cmd)) break block115;
                                                                                    if (opti >= args.length) {
                                                                                        this.dumpBinderProxies(pw, 0);
                                                                                        break block112;
                                                                                    } else {
                                                                                        String uid = args[opti];
                                                                                        ++opti;
                                                                                        System.gc();
                                                                                        System.runFinalization();
                                                                                        System.gc();
                                                                                        pw.println(BinderInternal.nGetBinderProxyCount(Integer.parseInt(uid)));
                                                                                    }
                                                                                    break block112;
                                                                                }
                                                                                if (!"allowed-associations".equals(cmd)) break block116;
                                                                                if (opti < args.length) {
                                                                                    dumpPackage = args[opti];
                                                                                    ++opti;
                                                                                }
                                                                                ActivityManagerService uid = this;
                                                                                synchronized (uid) {
                                                                                    try {
                                                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                                                        this.dumpAllowedAssociationsLocked(fd, pw, args, opti, true, dumpPackage);
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        // MONITOREXIT @DISABLED, blocks:[22, 39] lbl162 : MonitorExitStatement: MONITOREXIT : uid
                                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                        throw throwable;
                                                                                    }
                                                                                }
                                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                break block112;
                                                                            }
                                                                            if (!"broadcasts".equals(cmd) && !"b".equals(cmd)) break block117;
                                                                            if (opti < args.length) {
                                                                                dumpPackage = args[opti];
                                                                                ++opti;
                                                                            }
                                                                            ActivityManagerService uid = this;
                                                                            synchronized (uid) {
                                                                                try {
                                                                                    ActivityManagerService.boostPriorityForLockedSection();
                                                                                    this.dumpBroadcastsLocked(fd, pw, args, opti, true, dumpPackage);
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    // MONITOREXIT @DISABLED, blocks:[23, 40] lbl179 : MonitorExitStatement: MONITOREXIT : uid
                                                                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                    throw throwable;
                                                                                }
                                                                            }
                                                                            ActivityManagerService.resetPriorityAfterLockedSection();
                                                                            break block112;
                                                                        }
                                                                        if (!"broadcast-stats".equals(cmd)) break block118;
                                                                        if (opti < args.length) {
                                                                            dumpPackage = args[opti];
                                                                            ++opti;
                                                                        }
                                                                        ActivityManagerService uid = this;
                                                                        synchronized (uid) {
                                                                            try {
                                                                                ActivityManagerService.boostPriorityForLockedSection();
                                                                                if (dumpCheckinFormat) {
                                                                                    this.dumpBroadcastStatsCheckinLocked(fd, pw, args, opti, dumpCheckin, dumpPackage);
                                                                                } else {
                                                                                    this.dumpBroadcastStatsLocked(fd, pw, args, opti, true, dumpPackage);
                                                                                }
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                // MONITOREXIT @DISABLED, blocks:[24, 41] lbl199 : MonitorExitStatement: MONITOREXIT : uid
                                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                        break block112;
                                                                    }
                                                                    if (!"intents".equals(cmd) && !"i".equals(cmd)) break block119;
                                                                    if (opti < args.length) {
                                                                        dumpPackage = args[opti];
                                                                        ++opti;
                                                                    }
                                                                    ActivityManagerService uid = this;
                                                                    synchronized (uid) {
                                                                        try {
                                                                            ActivityManagerService.boostPriorityForLockedSection();
                                                                            this.mPendingIntentController.dumpPendingIntents(pw, true, dumpPackage);
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            // MONITOREXIT @DISABLED, blocks:[25, 42] lbl216 : MonitorExitStatement: MONITOREXIT : uid
                                                                            ActivityManagerService.resetPriorityAfterLockedSection();
                                                                            throw throwable;
                                                                        }
                                                                    }
                                                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                                                    break block112;
                                                                }
                                                                if (!"processes".equals(cmd) && !"p".equals(cmd)) break block120;
                                                                if (opti < args.length) {
                                                                    dumpPackage = args[opti];
                                                                    ++opti;
                                                                }
                                                                ActivityManagerService uid = this;
                                                                synchronized (uid) {
                                                                    try {
                                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                                        this.dumpProcessesLocked(fd, pw, args, opti, true, dumpPackage, dumpAppId);
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        // MONITOREXIT @DISABLED, blocks:[26, 43] lbl233 : MonitorExitStatement: MONITOREXIT : uid
                                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                break block112;
                                                            }
                                                            if (!"oom".equals(cmd) && !"o".equals(cmd)) break block121;
                                                            ActivityManagerService uid = this;
                                                            synchronized (uid) {
                                                                try {
                                                                    ActivityManagerService.boostPriorityForLockedSection();
                                                                    this.dumpOomLocked(fd, pw, args, opti, true);
                                                                }
                                                                catch (Throwable throwable) {
                                                                    // MONITOREXIT @DISABLED, blocks:[27, 44] lbl248 : MonitorExitStatement: MONITOREXIT : uid
                                                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                                                    throw throwable;
                                                                }
                                                            }
                                                            ActivityManagerService.resetPriorityAfterLockedSection();
                                                            break block112;
                                                        }
                                                        if (!"lmk".equals(cmd)) break block122;
                                                        ActivityManagerService uid = this;
                                                        synchronized (uid) {
                                                            try {
                                                                ActivityManagerService.boostPriorityForLockedSection();
                                                                this.dumpLmkLocked(pw);
                                                            }
                                                            catch (Throwable throwable) {
                                                                // MONITOREXIT @DISABLED, blocks:[28, 45] lbl263 : MonitorExitStatement: MONITOREXIT : uid
                                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                                throw throwable;
                                                            }
                                                        }
                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                        break block112;
                                                    }
                                                    if (!"lru".equals(cmd)) break block123;
                                                    ActivityManagerService uid = this;
                                                    synchronized (uid) {
                                                        try {
                                                            ActivityManagerService.boostPriorityForLockedSection();
                                                            this.dumpLruLocked(pw, null);
                                                        }
                                                        catch (Throwable throwable) {
                                                            // MONITOREXIT @DISABLED, blocks:[29, 46] lbl277 : MonitorExitStatement: MONITOREXIT : uid
                                                            ActivityManagerService.resetPriorityAfterLockedSection();
                                                            throw throwable;
                                                        }
                                                    }
                                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                                    break block112;
                                                }
                                                if (!"permissions".equals(cmd) && !"perm".equals(cmd)) break block124;
                                                ActivityManagerService uid = this;
                                                synchronized (uid) {
                                                    try {
                                                        ActivityManagerService.boostPriorityForLockedSection();
                                                        this.dumpPermissionsLocked(fd, pw, args, opti, true, null);
                                                    }
                                                    catch (Throwable throwable) {
                                                        // MONITOREXIT @DISABLED, blocks:[30, 47] lbl291 : MonitorExitStatement: MONITOREXIT : uid
                                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                                        throw throwable;
                                                    }
                                                }
                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                break block112;
                                            }
                                            if (!"provider".equals(cmd)) break block125;
                                            if (opti >= args.length) {
                                                Object name22 = null;
                                                String[] newArgs2 = EMPTY_STRING_ARRAY;
                                            } else {
                                                name2 = args[opti];
                                                newArgs5 = new String[args.length - ++opti];
                                                if (args.length > 2) {
                                                    System.arraycopy(args, opti, newArgs5, 0, args.length - opti);
                                                }
                                            }
                                            if (!this.dumpProvider(fd, pw, name2, newArgs5, 0, dumpAll)) {
                                                pw.println("No providers match: " + name2);
                                                pw.println("Use -h for help.");
                                            }
                                            break block112;
                                        }
                                        if (!"providers".equals(cmd) && !"prov".equals(cmd)) break block126;
                                        ActivityManagerService newArgs5 = this;
                                        synchronized (newArgs5) {
                                            try {
                                                ActivityManagerService.boostPriorityForLockedSection();
                                                this.dumpProvidersLocked(fd, pw, args, opti, true, null);
                                            }
                                            catch (Throwable throwable) {
                                                // MONITOREXIT @DISABLED, blocks:[48, 31] lbl319 : MonitorExitStatement: MONITOREXIT : newArgs5
                                                ActivityManagerService.resetPriorityAfterLockedSection();
                                                throw throwable;
                                            }
                                        }
                                        ActivityManagerService.resetPriorityAfterLockedSection();
                                        break block112;
                                    }
                                    if (!"service".equals(cmd)) break block127;
                                    if (opti >= args.length) {
                                        name = null;
                                        newArgs = EMPTY_STRING_ARRAY;
                                    } else {
                                        name = args[opti];
                                        newArgs = new String[args.length - ++opti];
                                        if (args.length > 2) {
                                            System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                                        }
                                    }
                                    if (!this.mServices.dumpService(fd, pw, name, newArgs, 0, dumpAll)) {
                                        pw.println("No services match: " + name);
                                        pw.println("Use -h for help.");
                                    }
                                    break block112;
                                }
                                if (!"package".equals(cmd)) break block128;
                                if (opti >= args.length) {
                                    pw.println("package: no package name specified");
                                    pw.println("Use -h for help.");
                                    break block112;
                                } else {
                                    dumpPackage = args[opti];
                                    String[] newArgs = new String[args.length - ++opti];
                                    if (args.length > 2) {
                                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                                    }
                                    args = newArgs;
                                    opti = 0;
                                    more = true;
                                }
                                break block112;
                            }
                            if (!"associations".equals(cmd) && !"as".equals(cmd)) break block129;
                            ActivityManagerService newArgs = this;
                            synchronized (newArgs) {
                                try {
                                    ActivityManagerService.boostPriorityForLockedSection();
                                    this.dumpAssociationsLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                                }
                                catch (Throwable throwable) {
                                    // MONITOREXIT @DISABLED, blocks:[32, 49] lbl360 : MonitorExitStatement: MONITOREXIT : newArgs
                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                    throw throwable;
                                }
                            }
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break block112;
                        }
                        if (!"settings".equals(cmd)) break block130;
                        ActivityManagerService newArgs = this;
                        synchronized (newArgs) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                this.mConstants.dump(pw);
                                this.mOomAdjuster.dumpAppCompactorSettings(pw);
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[33, 50] lbl375 : MonitorExitStatement: MONITOREXIT : newArgs
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        break block112;
                    }
                    if (!"services".equals(cmd) && !"s".equals(cmd)) break block131;
                    if (dumpClient) {
                        ActiveServices.ServiceDumper dumper;
                        ActivityManagerService name = this;
                        synchronized (name) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                dumper = this.mServices.newServiceDumperLocked(fd, pw, args, opti, true, dumpPackage);
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[34, 51, 100] lbl390 : MonitorExitStatement: MONITOREXIT : name
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        dumper.dumpWithClient();
                        break block112;
                    } else {
                        ActivityManagerService dumper = this;
                        synchronized (dumper) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                this.mServices.newServiceDumperLocked(fd, pw, args, opti, true, dumpPackage).dumpLocked();
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[35, 99, 52] lbl404 : MonitorExitStatement: MONITOREXIT : dumper
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                    break block112;
                }
                if ("locks".equals(cmd)) {
                    LockGuard.dump(fd, pw, args);
                } else if (!this.mAtmInternal.dumpActivity(fd, pw, cmd, args, opti, dumpAll, dumpVisibleStacksOnly, dumpFocusedStackOnly) && (res = (shell = new ActivityManagerShellCommand(this, true)).exec(this, null, fd, null, args, null, new ResultReceiver(null))) < 0) {
                    pw.println("Bad activity command, or no activities match: " + cmd);
                    pw.println("Use -h for help.");
                }
            }
            if (!more) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        if (dumpCheckinFormat) {
            this.dumpBroadcastStatsCheckinLocked(fd, pw, args, opti, dumpCheckin, dumpPackage);
        } else if (dumpClient) {
            this.dumpEverything(fd, pw, args, opti, dumpAll, dumpPackage, dumpClient, dumpNormalPriority, dumpAppId);
        } else {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.dumpEverything(fd, pw, args, opti, dumpAll, dumpPackage, dumpClient, dumpNormalPriority, dumpAppId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[97, 18, 53, 95] lbl432 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
        Binder.restoreCallingIdentity(origId);
    }

    void dumpAssociationsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        pw.println("ACTIVITY MANAGER ASSOCIATIONS (dumpsys activity associations)");
        int dumpUid = 0;
        if (dumpPackage != null) {
            IPackageManager pm = AppGlobals.getPackageManager();
            try {
                dumpUid = pm.getPackageUid(dumpPackage, 0x400000, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        boolean printedAnything = false;
        long now = SystemClock.uptimeMillis();
        int N1 = this.mAssociations.size();
        for (int i1 = 0; i1 < N1; ++i1) {
            ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> targetComponents = this.mAssociations.valueAt(i1);
            int N2 = targetComponents.size();
            for (int i2 = 0; i2 < N2; ++i2) {
                SparseArray<ArrayMap<String, Association>> sourceUids = targetComponents.valueAt(i2);
                int N3 = sourceUids.size();
                for (int i3 = 0; i3 < N3; ++i3) {
                    ArrayMap<String, Association> sourceProcesses = sourceUids.valueAt(i3);
                    int N4 = sourceProcesses.size();
                    for (int i4 = 0; i4 < N4; ++i4) {
                        Association ass = sourceProcesses.valueAt(i4);
                        if (dumpPackage != null && !ass.mTargetComponent.getPackageName().equals(dumpPackage) && UserHandle.getAppId(ass.mSourceUid) != dumpUid) continue;
                        printedAnything = true;
                        pw.print("  ");
                        pw.print(ass.mTargetProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mTargetUid);
                        pw.print(" <- ");
                        pw.print(ass.mSourceProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mSourceUid);
                        pw.println();
                        pw.print("    via ");
                        pw.print(ass.mTargetComponent.flattenToShortString());
                        pw.println();
                        pw.print("    ");
                        long dur = ass.mTime;
                        if (ass.mNesting > 0) {
                            dur += now - ass.mStartTime;
                        }
                        TimeUtils.formatDuration(dur, pw);
                        pw.print(" (");
                        pw.print(ass.mCount);
                        pw.print(" times)");
                        pw.print("  ");
                        for (int i = 0; i < ass.mStateTimes.length; ++i) {
                            long amt = ass.mStateTimes[i];
                            if (ass.mLastState - 0 == i) {
                                amt += now - ass.mLastStateUptime;
                            }
                            if (amt == 0L) continue;
                            pw.print(" ");
                            pw.print(ProcessList.makeProcStateString(i + 0));
                            pw.print("=");
                            TimeUtils.formatDuration(amt, pw);
                            if (ass.mLastState - 0 != i) continue;
                            pw.print("*");
                        }
                        pw.println();
                        if (ass.mNesting <= 0) continue;
                        pw.print("    Currently active: ");
                        TimeUtils.formatDuration(now - ass.mStartTime, pw);
                        pw.println();
                    }
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    private int getAppId(String dumpPackage) {
        if (dumpPackage != null) {
            try {
                ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo(dumpPackage, 0);
                return UserHandle.getAppId(info.uid);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    boolean dumpUids(PrintWriter pw, String dumpPackage, int dumpAppId, ActiveUids uids, String header, boolean needSep) {
        boolean printed = false;
        for (int i = 0; i < uids.size(); ++i) {
            UidRecord uidRec = uids.valueAt(i);
            if (dumpPackage != null && UserHandle.getAppId(uidRec.uid) != dumpAppId) continue;
            if (!printed) {
                printed = true;
                if (needSep) {
                    pw.println();
                }
                pw.print("  ");
                pw.println(header);
                needSep = true;
            }
            pw.print("    UID ");
            UserHandle.formatUid(pw, uidRec.uid);
            pw.print(": ");
            pw.println(uidRec);
        }
        return printed;
    }

    void dumpBinderProxyInterfaceCounts(PrintWriter pw, String header) {
        BinderProxy.InterfaceCount[] proxyCounts = BinderProxy.getSortedInterfaceCounts(50);
        pw.println(header);
        for (int i = 0; i < proxyCounts.length; ++i) {
            pw.println("    #" + (i + 1) + ": " + proxyCounts[i]);
        }
    }

    boolean dumpBinderProxiesCounts(PrintWriter pw, String header) {
        SparseIntArray counts = BinderInternal.nGetBinderProxyPerUidCounts();
        if (counts != null) {
            pw.println(header);
            for (int i = 0; i < counts.size(); ++i) {
                int uid = counts.keyAt(i);
                int binderCount = counts.valueAt(i);
                pw.print("    UID ");
                pw.print(uid);
                pw.print(", binder count = ");
                pw.print(binderCount);
                pw.print(", package(s)= ");
                String[] pkgNames = this.mContext.getPackageManager().getPackagesForUid(uid);
                if (pkgNames != null) {
                    for (int j = 0; j < pkgNames.length; ++j) {
                        pw.print(pkgNames[j]);
                        pw.print("; ");
                    }
                } else {
                    pw.print("NO PACKAGE NAME FOUND");
                }
                pw.println();
            }
            return true;
        }
        return false;
    }

    void dumpBinderProxies(PrintWriter pw, int minCountToDumpInterfaces) {
        pw.println("ACTIVITY MANAGER BINDER PROXY STATE (dumpsys activity binder-proxies)");
        int proxyCount = BinderProxy.getProxyCount();
        if (proxyCount >= minCountToDumpInterfaces) {
            this.dumpBinderProxyInterfaceCounts(pw, "Top proxy interface names held by SYSTEM");
        } else {
            pw.print("Not dumping proxy interface counts because size (" + Integer.toString(proxyCount) + ") looks reasonable");
            pw.println();
        }
        this.dumpBinderProxiesCounts(pw, "  Counts of Binder Proxies held by SYSTEM");
    }

    void dumpLruEntryLocked(PrintWriter pw, int index, ProcessRecord proc) {
        pw.print("    #");
        pw.print(index);
        pw.print(": ");
        pw.print(ProcessList.makeOomAdjString(proc.setAdj, false));
        pw.print(" ");
        pw.print(ProcessList.makeProcStateString(proc.getCurProcState()));
        pw.print(" ");
        pw.print(proc.toShortString());
        pw.print(" ");
        if (proc.hasActivitiesOrRecentTasks() || proc.hasClientActivities() || proc.treatLikeActivity) {
            pw.print(" activity=");
            boolean printed = false;
            if (proc.hasActivities()) {
                pw.print("activities");
                printed = true;
            }
            if (proc.hasRecentTasks()) {
                if (printed) {
                    pw.print("|");
                }
                pw.print("recents");
                printed = true;
            }
            if (proc.hasClientActivities()) {
                if (printed) {
                    pw.print("|");
                }
                pw.print("client");
                printed = true;
            }
            if (proc.treatLikeActivity) {
                if (printed) {
                    pw.print("|");
                }
                pw.print("treated");
            }
        }
        pw.println();
    }

    void dumpLruLocked(PrintWriter pw, String dumpPackage) {
        ProcessRecord r;
        int i;
        pw.println("ACTIVITY MANAGER LRU PROCESSES (dumpsys activity lru)");
        int N = this.mProcessList.mLruProcesses.size();
        boolean first = true;
        for (i = N - 1; i >= this.mProcessList.mLruProcessActivityStart; --i) {
            r = this.mProcessList.mLruProcesses.get(i);
            if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
            if (first) {
                pw.println("  Activities:");
                first = false;
            }
            this.dumpLruEntryLocked(pw, i, r);
        }
        first = true;
        while (i >= this.mProcessList.mLruProcessServiceStart) {
            r = this.mProcessList.mLruProcesses.get(i);
            if (dumpPackage == null || r.pkgList.containsKey(dumpPackage)) {
                if (first) {
                    pw.println("  Services:");
                    first = false;
                }
                this.dumpLruEntryLocked(pw, i, r);
            }
            --i;
        }
        first = true;
        while (i >= 0) {
            r = this.mProcessList.mLruProcesses.get(i);
            if (dumpPackage == null || r.pkgList.containsKey(dumpPackage)) {
                if (first) {
                    pw.println("  Other:");
                    first = false;
                }
                this.dumpLruEntryLocked(pw, i, r);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    void dumpProcessesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage, int dumpAppId) {
        boolean printed;
        int i;
        boolean printed2;
        boolean needSep = false;
        int numPers = 0;
        pw.println("ACTIVITY MANAGER RUNNING PROCESSES (dumpsys activity processes)");
        if (dumpAll) {
            int NP = this.mProcessList.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray procs = this.mProcessList.mProcessNames.getMap().valueAt(ip);
                int NA = procs.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord r = (ProcessRecord)procs.valueAt(ia);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!needSep) {
                        pw.println("  All known processes:");
                        needSep = true;
                    }
                    pw.print(r.isPersistent() ? "  *PERS*" : "  *APP*");
                    pw.print(" UID ");
                    pw.print(procs.keyAt(ia));
                    pw.print(" ");
                    pw.println(r);
                    r.dump(pw, "    ");
                    if (!r.isPersistent()) continue;
                    ++numPers;
                }
            }
        }
        if (this.mProcessList.mIsolatedProcesses.size() > 0) {
            printed2 = false;
            for (i = 0; i < this.mProcessList.mIsolatedProcesses.size(); ++i) {
                ProcessRecord r = this.mProcessList.mIsolatedProcesses.valueAt(i);
                if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                if (!printed2) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Isolated process list (sorted by uid):");
                    printed2 = true;
                    needSep = true;
                }
                pw.print("    Isolated #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (this.mActiveInstrumentation.size() > 0) {
            printed2 = false;
            for (i = 0; i < this.mActiveInstrumentation.size(); ++i) {
                ActiveInstrumentation ai = this.mActiveInstrumentation.get(i);
                if (dumpPackage != null && !ai.mClass.getPackageName().equals(dumpPackage) && !ai.mTargetInfo.packageName.equals(dumpPackage)) continue;
                if (!printed2) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Active instrumentation:");
                    printed2 = true;
                    needSep = true;
                }
                pw.print("    Instrumentation #");
                pw.print(i);
                pw.print(": ");
                pw.println(ai);
                ai.dump(pw, "      ");
            }
        }
        if (this.mProcessList.mActiveUids.size() > 0 && this.dumpUids(pw, dumpPackage, dumpAppId, this.mProcessList.mActiveUids, "UID states:", needSep)) {
            needSep = true;
        }
        if (dumpAll && this.mValidateUids.size() > 0 && this.dumpUids(pw, dumpPackage, dumpAppId, this.mValidateUids, "UID validation:", needSep)) {
            needSep = true;
        }
        if (this.mProcessList.getLruSizeLocked() > 0) {
            if (needSep) {
                pw.println();
            }
            this.mProcessList.dumpLruListHeaderLocked(pw);
            ActivityManagerService.dumpProcessOomList(pw, this, this.mProcessList.mLruProcesses, "    ", "Proc", "PERS", false, dumpPackage);
            needSep = true;
        }
        if (dumpAll || dumpPackage != null) {
            PidMap printed3 = this.mPidsSelfLocked;
            synchronized (printed3) {
                printed = false;
                for (int i2 = 0; i2 < this.mPidsSelfLocked.size(); ++i2) {
                    ProcessRecord r = this.mPidsSelfLocked.valueAt(i2);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  PID mappings:");
                        printed = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mPidsSelfLocked.keyAt(i2));
                    pw.print(": ");
                    pw.println(this.mPidsSelfLocked.valueAt(i2));
                }
            }
        }
        if (this.mImportantProcesses.size() > 0) {
            PidMap printed3 = this.mPidsSelfLocked;
            synchronized (printed3) {
                printed = false;
                for (int i3 = 0; i3 < this.mImportantProcesses.size(); ++i3) {
                    ProcessRecord r = this.mPidsSelfLocked.get(this.mImportantProcesses.valueAt((int)i3).pid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Foreground Processes:");
                        printed = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mImportantProcesses.keyAt(i3));
                    pw.print(": ");
                    pw.println(this.mImportantProcesses.valueAt(i3));
                }
            }
        }
        if (this.mPersistentStartingProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  Persisent processes that are starting:");
            ActivityManagerService.dumpProcessList(pw, this, this.mPersistentStartingProcesses, "    ", "Starting Norm", "Restarting PERS", dumpPackage);
        }
        if (this.mProcessList.mRemovedProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  Processes that are being removed:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessList.mRemovedProcesses, "    ", "Removed Norm", "Removed PERS", dumpPackage);
        }
        if (this.mProcessesOnHold.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  Processes that are on old until the system is ready:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessesOnHold, "    ", "OnHold Norm", "OnHold PERS", dumpPackage);
        }
        needSep = this.dumpProcessesToGc(pw, needSep, dumpPackage);
        needSep = this.mAppErrors.dumpLocked(fd, pw, needSep, dumpPackage);
        if (dumpPackage == null) {
            pw.println();
            needSep = false;
            this.mUserController.dump(pw, dumpAll);
        }
        needSep = this.mAtmInternal.dumpForProcesses(fd, pw, dumpAll, dumpPackage, dumpAppId, needSep, this.mTestPssMode, this.mWakefulness);
        if (dumpAll && this.mProcessList.mPendingStarts.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  mPendingStarts: ");
            int len = this.mProcessList.mPendingStarts.size();
            for (int i4 = 0; i4 < len; ++i4) {
                pw.println("    " + this.mProcessList.mPendingStarts.keyAt(i4) + ": " + this.mProcessList.mPendingStarts.valueAt(i4));
            }
        }
        if (dumpAll) {
            int i5;
            int NI = this.mUidObservers.getRegisteredCallbackCount();
            printed = false;
            for (i5 = 0; i5 < NI; ++i5) {
                UidObserverRegistration reg = (UidObserverRegistration)this.mUidObservers.getRegisteredCallbackCookie(i5);
                if (dumpPackage != null && !dumpPackage.equals(reg.pkg)) continue;
                if (!printed) {
                    pw.println("  mUidObservers:");
                    printed = true;
                }
                pw.print("    ");
                UserHandle.formatUid(pw, reg.uid);
                pw.print(" ");
                pw.print(reg.pkg);
                IUidObserver observer = this.mUidObservers.getRegisteredCallbackItem(i5);
                pw.print(" ");
                pw.print(observer.getClass().getTypeName());
                pw.print(":");
                if ((reg.which & 4) != 0) {
                    pw.print(" IDLE");
                }
                if ((reg.which & 8) != 0) {
                    pw.print(" ACT");
                }
                if ((reg.which & 2) != 0) {
                    pw.print(" GONE");
                }
                if ((reg.which & 1) != 0) {
                    pw.print(" STATE");
                    pw.print(" (cut=");
                    pw.print(reg.cutpoint);
                    pw.print(")");
                }
                pw.println();
                if (reg.lastProcStates == null) continue;
                int NJ = reg.lastProcStates.size();
                for (int j = 0; j < NJ; ++j) {
                    pw.print("      Last ");
                    UserHandle.formatUid(pw, reg.lastProcStates.keyAt(j));
                    pw.print(": ");
                    pw.println(reg.lastProcStates.valueAt(j));
                }
            }
            pw.println("  mDeviceIdleWhitelist=" + Arrays.toString(this.mDeviceIdleWhitelist));
            pw.println("  mDeviceIdleExceptIdleWhitelist=" + Arrays.toString(this.mDeviceIdleExceptIdleWhitelist));
            pw.println("  mDeviceIdleTempWhitelist=" + Arrays.toString(this.mDeviceIdleTempWhitelist));
            if (this.mPendingTempWhitelist.size() > 0) {
                pw.println("  mPendingTempWhitelist:");
                for (i5 = 0; i5 < this.mPendingTempWhitelist.size(); ++i5) {
                    PendingTempWhitelist ptw = this.mPendingTempWhitelist.valueAt(i5);
                    pw.print("    ");
                    UserHandle.formatUid(pw, ptw.targetUid);
                    pw.print(": ");
                    TimeUtils.formatDuration(ptw.duration, pw);
                    pw.print(" ");
                    pw.println(ptw.tag);
                }
            }
        }
        if ((this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) && (dumpPackage == null || dumpPackage.equals(this.mDebugApp) || dumpPackage.equals(this.mOrigDebugApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mDebugApp=" + this.mDebugApp + "/orig=" + this.mOrigDebugApp + " mDebugTransient=" + this.mDebugTransient + " mOrigWaitForDebugger=" + this.mOrigWaitForDebugger);
        }
        if (this.mMemWatchProcesses.getMap().size() > 0) {
            pw.println("  Mem watch processes:");
            ArrayMap<String, SparseArray<Pair<Long, String>>> procs = this.mMemWatchProcesses.getMap();
            for (i = 0; i < procs.size(); ++i) {
                String proc = procs.keyAt(i);
                SparseArray<Pair<Long, String>> uids = procs.valueAt(i);
                for (int j = 0; j < uids.size(); ++j) {
                    if (needSep) {
                        pw.println();
                        needSep = false;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("    ").append(proc).append('/');
                    UserHandle.formatUid(sb, uids.keyAt(j));
                    Pair<Long, String> val = uids.valueAt(j);
                    sb.append(": ");
                    DebugUtils.sizeValueToString((Long)val.first, sb);
                    if (val.second != null) {
                        sb.append(", report to ").append((String)val.second);
                    }
                    pw.println(sb.toString());
                }
            }
            pw.print("  mMemWatchDumpProcName=");
            pw.println(this.mMemWatchDumpProcName);
            pw.print("  mMemWatchDumpFile=");
            pw.println(this.mMemWatchDumpFile);
            pw.print("  mMemWatchDumpPid=");
            pw.println(this.mMemWatchDumpPid);
            pw.print("  mMemWatchDumpUid=");
            pw.println(this.mMemWatchDumpUid);
            pw.print("  mMemWatchIsUserInitiated=");
            pw.println(this.mMemWatchIsUserInitiated);
        }
        if (this.mTrackAllocationApp != null && (dumpPackage == null || dumpPackage.equals(this.mTrackAllocationApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mTrackAllocationApp=" + this.mTrackAllocationApp);
        }
        if (!(this.mProfileData.getProfileApp() == null && this.mProfileData.getProfileProc() == null && (this.mProfileData.getProfilerInfo() == null || this.mProfileData.getProfilerInfo().profileFile == null && this.mProfileData.getProfilerInfo().profileFd == null) || dumpPackage != null && !dumpPackage.equals(this.mProfileData.getProfileApp()))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mProfileApp=" + this.mProfileData.getProfileApp() + " mProfileProc=" + this.mProfileData.getProfileProc());
            if (this.mProfileData.getProfilerInfo() != null) {
                pw.println("  mProfileFile=" + this.mProfileData.getProfilerInfo().profileFile + " mProfileFd=" + this.mProfileData.getProfilerInfo().profileFd);
                pw.println("  mSamplingInterval=" + this.mProfileData.getProfilerInfo().samplingInterval + " mAutoStopProfiler=" + this.mProfileData.getProfilerInfo().autoStopProfiler + " mStreamingOutput=" + this.mProfileData.getProfilerInfo().streamingOutput);
                pw.println("  mProfileType=" + this.mProfileType);
            }
        }
        if (this.mNativeDebuggingApp != null && (dumpPackage == null || dumpPackage.equals(this.mNativeDebuggingApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mNativeDebuggingApp=" + this.mNativeDebuggingApp);
        }
        if (dumpPackage == null) {
            if (this.mAlwaysFinishActivities) {
                pw.println("  mAlwaysFinishActivities=" + this.mAlwaysFinishActivities);
            }
            if (dumpAll) {
                pw.println("  Total persistent processes: " + numPers);
                pw.println("  mProcessesReady=" + this.mProcessesReady + " mSystemReady=" + this.mSystemReady + " mBooted=" + this.mBooted + " mFactoryTest=" + this.mFactoryTest);
                pw.println("  mBooting=" + this.mBooting + " mCallFinishBooting=" + this.mCallFinishBooting + " mBootAnimationComplete=" + this.mBootAnimationComplete);
                pw.print("  mLastPowerCheckUptime=");
                TimeUtils.formatDuration(this.mLastPowerCheckUptime, pw);
                pw.println("");
                this.mOomAdjuster.dumpSequenceNumbersLocked(pw);
                this.mOomAdjuster.dumpProcCountsLocked(pw);
                pw.println("  mAllowLowerMemLevel=" + this.mAllowLowerMemLevel + " mLastMemoryLevel=" + this.mLastMemoryLevel + " mLastNumProcesses=" + this.mLastNumProcesses);
                long now = SystemClock.uptimeMillis();
                pw.print("  mLastIdleTime=");
                TimeUtils.formatDuration(now, this.mLastIdleTime, pw);
                pw.print(" mLowRamSinceLastIdle=");
                TimeUtils.formatDuration(this.getLowRamTimeSinceIdle(now), pw);
                pw.println();
                pw.println();
                pw.print("  mUidChangeDispatchCount=");
                pw.print(this.mUidChangeDispatchCount);
                pw.println();
                pw.println("  Slow UID dispatches:");
                int N = this.mUidObservers.beginBroadcast();
                for (int i6 = 0; i6 < N; ++i6) {
                    UidObserverRegistration r = (UidObserverRegistration)this.mUidObservers.getBroadcastCookie(i6);
                    pw.print("    ");
                    pw.print(this.mUidObservers.getBroadcastItem(i6).getClass().getTypeName());
                    pw.print(": ");
                    pw.print(r.mSlowDispatchCount);
                    pw.print(" / Max ");
                    pw.print(r.mMaxDispatchTime);
                    pw.println("ms");
                }
                this.mUidObservers.finishBroadcast();
                pw.println();
                pw.println("  ServiceManager statistics:");
                ServiceManager.sStatLogger.dump(pw, "    ");
                pw.println();
            }
        }
        pw.println("  mForceBackgroundCheck=" + this.mForceBackgroundCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    void writeProcessesToProtoLocked(ProtoOutputStream proto, String dumpPackage) {
        int i;
        int i2;
        int i3;
        ProcessRecord r;
        int numPers = 0;
        int NP = this.mProcessList.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray procs = this.mProcessList.mProcessNames.getMap().valueAt(ip);
            int NA = procs.size();
            for (int ia = 0; ia < NA; ++ia) {
                r = (ProcessRecord)procs.valueAt(ia);
                if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                r.writeToProto(proto, 2246267895809L, this.mProcessList.mLruProcesses.indexOf(r));
                if (!r.isPersistent()) continue;
                ++numPers;
            }
        }
        for (i3 = 0; i3 < this.mProcessList.mIsolatedProcesses.size(); ++i3) {
            ProcessRecord r2 = this.mProcessList.mIsolatedProcesses.valueAt(i3);
            if (dumpPackage != null && !r2.pkgList.containsKey(dumpPackage)) continue;
            r2.writeToProto(proto, 0x20B00000002L, this.mProcessList.mLruProcesses.indexOf(r2));
        }
        for (i3 = 0; i3 < this.mActiveInstrumentation.size(); ++i3) {
            ActiveInstrumentation ai = this.mActiveInstrumentation.get(i3);
            if (dumpPackage != null && !ai.mClass.getPackageName().equals(dumpPackage) && !ai.mTargetInfo.packageName.equals(dumpPackage)) continue;
            ai.writeToProto(proto, 2246267895811L);
        }
        int whichAppId = this.getAppId(dumpPackage);
        for (i2 = 0; i2 < this.mProcessList.mActiveUids.size(); ++i2) {
            UidRecord uidRec = this.mProcessList.mActiveUids.valueAt(i2);
            if (dumpPackage != null && UserHandle.getAppId(uidRec.uid) != whichAppId) continue;
            uidRec.writeToProto(proto, 2246267895812L);
        }
        for (i2 = 0; i2 < this.mValidateUids.size(); ++i2) {
            UidRecord uidRec = this.mValidateUids.valueAt(i2);
            if (dumpPackage != null && UserHandle.getAppId(uidRec.uid) != whichAppId) continue;
            uidRec.writeToProto(proto, 2246267895813L);
        }
        if (this.mProcessList.getLruSizeLocked() > 0) {
            long lruToken = proto.start(1146756268038L);
            int total = this.mProcessList.getLruSizeLocked();
            proto.write(0x10500000001L, total);
            proto.write(1120986464258L, total - this.mProcessList.mLruProcessActivityStart);
            proto.write(1120986464259L, total - this.mProcessList.mLruProcessServiceStart);
            ActivityManagerService.writeProcessOomListToProto(proto, 2246267895812L, this, this.mProcessList.mLruProcesses, false, dumpPackage);
            proto.end(lruToken);
        }
        if (dumpPackage != null) {
            PidMap lruToken = this.mPidsSelfLocked;
            synchronized (lruToken) {
                for (int i4 = 0; i4 < this.mPidsSelfLocked.size(); ++i4) {
                    ProcessRecord r3 = this.mPidsSelfLocked.valueAt(i4);
                    if (!r3.pkgList.containsKey(dumpPackage)) continue;
                    r3.writeToProto(proto, 2246267895815L);
                }
            }
        }
        if (this.mImportantProcesses.size() > 0) {
            PidMap lruToken = this.mPidsSelfLocked;
            synchronized (lruToken) {
                for (int i5 = 0; i5 < this.mImportantProcesses.size(); ++i5) {
                    ImportanceToken it = this.mImportantProcesses.valueAt(i5);
                    r = this.mPidsSelfLocked.get(it.pid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    it.writeToProto(proto, 2246267895816L);
                }
            }
        }
        for (i = 0; i < this.mPersistentStartingProcesses.size(); ++i) {
            ProcessRecord r4 = this.mPersistentStartingProcesses.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r4.info.packageName)) continue;
            r4.writeToProto(proto, 2246267895817L);
        }
        for (i = 0; i < this.mProcessList.mRemovedProcesses.size(); ++i) {
            ProcessRecord r5 = this.mProcessList.mRemovedProcesses.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r5.info.packageName)) continue;
            r5.writeToProto(proto, 2246267895818L);
        }
        for (i = 0; i < this.mProcessesOnHold.size(); ++i) {
            ProcessRecord r6 = this.mProcessesOnHold.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r6.info.packageName)) continue;
            r6.writeToProto(proto, 0x20B0000000BL);
        }
        this.writeProcessesToGcToProto(proto, 2246267895820L, dumpPackage);
        this.mAppErrors.writeToProto(proto, 1146756268045L, dumpPackage);
        this.mAtmInternal.writeProcessesToProto(proto, dumpPackage, this.mWakefulness, this.mTestPssMode);
        if (dumpPackage == null) {
            this.mUserController.writeToProto(proto, 1146756268046L);
        }
        int NI = this.mUidObservers.getRegisteredCallbackCount();
        for (int i6 = 0; i6 < NI; ++i6) {
            UidObserverRegistration reg = (UidObserverRegistration)this.mUidObservers.getRegisteredCallbackCookie(i6);
            if (dumpPackage != null && !dumpPackage.equals(reg.pkg)) continue;
            reg.writeToProto(proto, 2246267895831L);
        }
        for (int v : this.mDeviceIdleWhitelist) {
            proto.write(2220498092056L, v);
        }
        for (int v : this.mDeviceIdleTempWhitelist) {
            proto.write(2220498092057L, v);
        }
        if (this.mPendingTempWhitelist.size() > 0) {
            for (int i7 = 0; i7 < this.mPendingTempWhitelist.size(); ++i7) {
                this.mPendingTempWhitelist.valueAt(i7).writeToProto(proto, 2246267895834L);
            }
        }
        if ((this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) && (dumpPackage == null || dumpPackage.equals(this.mDebugApp) || dumpPackage.equals(this.mOrigDebugApp))) {
            long debugAppToken = proto.start(1146756268062L);
            proto.write(0x10900000001L, this.mDebugApp);
            proto.write(1138166333442L, this.mOrigDebugApp);
            proto.write(1133871366147L, this.mDebugTransient);
            proto.write(1133871366148L, this.mOrigWaitForDebugger);
            proto.end(debugAppToken);
        }
        if (this.mMemWatchProcesses.getMap().size() > 0) {
            long token = proto.start(1146756268064L);
            ArrayMap<String, SparseArray<Pair<Long, String>>> procs = this.mMemWatchProcesses.getMap();
            for (int i8 = 0; i8 < procs.size(); ++i8) {
                String proc = procs.keyAt(i8);
                SparseArray<Pair<Long, String>> uids = procs.valueAt(i8);
                long ptoken = proto.start(2246267895809L);
                proto.write(0x10900000001L, proc);
                for (int j = 0; j < uids.size(); ++j) {
                    long utoken = proto.start(0x20B00000002L);
                    Pair<Long, String> val = uids.valueAt(j);
                    proto.write(0x10500000001L, uids.keyAt(j));
                    proto.write(1138166333442L, DebugUtils.sizeValueToString((Long)val.first, new StringBuilder()));
                    proto.write(1138166333443L, (String)val.second);
                    proto.end(utoken);
                }
                proto.end(ptoken);
            }
            long dtoken = proto.start(1146756268034L);
            proto.write(0x10900000001L, this.mMemWatchDumpProcName);
            proto.write(1138166333442L, this.mMemWatchDumpFile);
            proto.write(1120986464259L, this.mMemWatchDumpPid);
            proto.write(1120986464260L, this.mMemWatchDumpUid);
            proto.write(1133871366149L, this.mMemWatchIsUserInitiated);
            proto.end(dtoken);
            proto.end(token);
        }
        if (this.mTrackAllocationApp != null && (dumpPackage == null || dumpPackage.equals(this.mTrackAllocationApp))) {
            proto.write(1138166333473L, this.mTrackAllocationApp);
        }
        if (!(this.mProfileData.getProfileApp() == null && this.mProfileData.getProfileProc() == null && (this.mProfileData.getProfilerInfo() == null || this.mProfileData.getProfilerInfo().profileFile == null && this.mProfileData.getProfilerInfo().profileFd == null) || dumpPackage != null && !dumpPackage.equals(this.mProfileData.getProfileApp()))) {
            long token = proto.start(1146756268066L);
            proto.write(0x10900000001L, this.mProfileData.getProfileApp());
            this.mProfileData.getProfileProc().writeToProto(proto, 1146756268034L);
            if (this.mProfileData.getProfilerInfo() != null) {
                this.mProfileData.getProfilerInfo().writeToProto(proto, 1146756268035L);
                proto.write(1120986464260L, this.mProfileType);
            }
            proto.end(token);
        }
        if (dumpPackage == null || dumpPackage.equals(this.mNativeDebuggingApp)) {
            proto.write(1138166333475L, this.mNativeDebuggingApp);
        }
        if (dumpPackage == null) {
            proto.write(1133871366180L, this.mAlwaysFinishActivities);
            proto.write(1120986464294L, numPers);
            proto.write(1133871366183L, this.mProcessesReady);
            proto.write(1133871366184L, this.mSystemReady);
            proto.write(1133871366185L, this.mBooted);
            proto.write(1120986464298L, this.mFactoryTest);
            proto.write(1133871366187L, this.mBooting);
            proto.write(1133871366188L, this.mCallFinishBooting);
            proto.write(1133871366189L, this.mBootAnimationComplete);
            proto.write(1112396529710L, this.mLastPowerCheckUptime);
            this.mOomAdjuster.dumpProcessListVariablesLocked(proto);
            proto.write(1133871366199L, this.mAllowLowerMemLevel);
            proto.write(1120986464312L, this.mLastMemoryLevel);
            proto.write(1120986464313L, this.mLastNumProcesses);
            long now = SystemClock.uptimeMillis();
            ProtoUtils.toDuration(proto, 1146756268090L, this.mLastIdleTime, now);
            proto.write(1112396529723L, this.getLowRamTimeSinceIdle(now));
        }
    }

    void writeProcessesToGcToProto(ProtoOutputStream proto, long fieldId, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord r = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
                long token = proto.start(fieldId);
                r.writeToProto(proto, 0x10B00000001L);
                proto.write(1133871366146L, r.reportLowMemory);
                proto.write(0x10300000003L, now);
                proto.write(1112396529668L, r.lastRequestedGc);
                proto.write(1112396529669L, r.lastLowMemory);
                proto.end(token);
            }
        }
    }

    boolean dumpProcessesToGc(PrintWriter pw, boolean needSep, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord proc = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(proc.info.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Processes that are waiting to GC:");
                    printed = true;
                }
                pw.print("    Process ");
                pw.println(proc);
                pw.print("      lowMem=");
                pw.print(proc.reportLowMemory);
                pw.print(", last gced=");
                pw.print(now - proc.lastRequestedGc);
                pw.print(" ms ago, last lowMem=");
                pw.print(now - proc.lastLowMemory);
                pw.println(" ms ago");
            }
        }
        return needSep;
    }

    void printOomLevel(PrintWriter pw, String name, int adj) {
        pw.print("    ");
        if (adj >= 0) {
            pw.print(' ');
            if (adj < 10) {
                pw.print(' ');
            }
        } else if (adj > -10) {
            pw.print(' ');
        }
        pw.print(adj);
        pw.print(": ");
        pw.print(name);
        pw.print(" (");
        pw.print(ActivityManagerService.stringifySize(this.mProcessList.getMemLevel(adj), 1024));
        pw.println(")");
    }

    boolean dumpOomLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll) {
        boolean needSep = false;
        if (this.mProcessList.getLruSizeLocked() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  OOM levels:");
            this.printOomLevel(pw, "SYSTEM_ADJ", -900);
            this.printOomLevel(pw, "PERSISTENT_PROC_ADJ", -800);
            this.printOomLevel(pw, "PERSISTENT_SERVICE_ADJ", -700);
            this.printOomLevel(pw, "FOREGROUND_APP_ADJ", 0);
            this.printOomLevel(pw, "VISIBLE_APP_ADJ", 100);
            this.printOomLevel(pw, "PERCEPTIBLE_APP_ADJ", 200);
            this.printOomLevel(pw, "PERCEPTIBLE_LOW_APP_ADJ", 250);
            this.printOomLevel(pw, "BACKUP_APP_ADJ", 300);
            this.printOomLevel(pw, "HEAVY_WEIGHT_APP_ADJ", 400);
            this.printOomLevel(pw, "SERVICE_ADJ", 500);
            this.printOomLevel(pw, "HOME_APP_ADJ", 600);
            this.printOomLevel(pw, "PREVIOUS_APP_ADJ", 700);
            this.printOomLevel(pw, "SERVICE_B_ADJ", 800);
            this.printOomLevel(pw, "CACHED_APP_MIN_ADJ", 900);
            this.printOomLevel(pw, "CACHED_APP_MAX_ADJ", 999);
            if (needSep) {
                pw.println();
            }
            pw.print("  Process OOM control (");
            pw.print(this.mProcessList.getLruSizeLocked());
            pw.print(" total, non-act at ");
            pw.print(this.mProcessList.getLruSizeLocked() - this.mProcessList.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mProcessList.getLruSizeLocked() - this.mProcessList.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mProcessList.mLruProcesses, "    ", "Proc", "PERS", true, null);
            needSep = true;
        }
        this.dumpProcessesToGc(pw, needSep, null);
        pw.println();
        this.mAtmInternal.dumpForOom(pw);
        return true;
    }

    private boolean reportLmkKillAtOrBelow(PrintWriter pw, int oom_adj) {
        Integer cnt = ProcessList.getLmkdKillCount(0, oom_adj);
        if (cnt != null) {
            pw.println("    kills at or below oom_adj " + oom_adj + ": " + cnt);
            return true;
        }
        return false;
    }

    boolean dumpLmkLocked(PrintWriter pw) {
        pw.println("ACTIVITY MANAGER LMK KILLS (dumpsys activity lmk)");
        Integer cnt = ProcessList.getLmkdKillCount(1001, 1001);
        if (cnt == null) {
            return false;
        }
        pw.println("  Total number of kills: " + cnt);
        return this.reportLmkKillAtOrBelow(pw, 999) && this.reportLmkKillAtOrBelow(pw, 900) && this.reportLmkKillAtOrBelow(pw, 800) && this.reportLmkKillAtOrBelow(pw, 700) && this.reportLmkKillAtOrBelow(pw, 600) && this.reportLmkKillAtOrBelow(pw, 500) && this.reportLmkKillAtOrBelow(pw, 400) && this.reportLmkKillAtOrBelow(pw, 300) && this.reportLmkKillAtOrBelow(pw, 250) && this.reportLmkKillAtOrBelow(pw, 200) && this.reportLmkKillAtOrBelow(pw, 100) && this.reportLmkKillAtOrBelow(pw, 0);
    }

    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        return this.mProviderMap.dumpProvider(fd, pw, name, args, opti, dumpAll);
    }

    protected boolean dumpProviderProto(FileDescriptor fd, PrintWriter pw, String name, String[] args) {
        return this.mProviderMap.dumpProviderProto(fd, pw, name, args);
    }

    void writeBroadcastsToProtoLocked(ProtoOutputStream proto) {
        if (this.mRegisteredReceivers.size() > 0) {
            for (ReceiverList r : this.mRegisteredReceivers.values()) {
                r.writeToProto(proto, 2246267895809L);
            }
        }
        this.mReceiverResolver.writeToProto(proto, 1146756268034L);
        for (BroadcastQueue q : this.mBroadcastQueues) {
            q.writeToProto(proto, 2246267895811L);
        }
        for (int user = 0; user < this.mStickyBroadcasts.size(); ++user) {
            long token = proto.start(2246267895812L);
            proto.write(0x10500000001L, this.mStickyBroadcasts.keyAt(user));
            for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.valueAt(user).entrySet()) {
                long actionToken = proto.start(0x20B00000002L);
                proto.write(0x10900000001L, ent.getKey());
                for (Intent intent : ent.getValue()) {
                    intent.writeToProto(proto, 0x20B00000002L, false, true, true, false);
                }
                proto.end(actionToken);
            }
            proto.end(token);
        }
        long handlerToken = proto.start(1146756268037L);
        proto.write(0x10900000001L, this.mHandler.toString());
        this.mHandler.getLooper().writeToProto(proto, 1146756268034L);
        proto.end(handlerToken);
    }

    void dumpAllowedAssociationsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        pw.println("ACTIVITY MANAGER ALLOWED ASSOCIATION STATE (dumpsys activity allowed-associations)");
        boolean printed = false;
        if (this.mAllowedAssociations != null) {
            for (int i = 0; i < this.mAllowedAssociations.size(); ++i) {
                String pkg = this.mAllowedAssociations.keyAt(i);
                ArraySet<String> asc = this.mAllowedAssociations.valueAt(i).getAllowedPackageAssociations();
                boolean printedHeader = false;
                for (int j = 0; j < asc.size(); ++j) {
                    if (dumpPackage != null && !pkg.equals(dumpPackage) && !asc.valueAt(j).equals(dumpPackage)) continue;
                    if (!printed) {
                        pw.println("  Allowed associations (by restricted package):");
                        printed = true;
                        needSep = true;
                    }
                    if (!printedHeader) {
                        pw.print("  * ");
                        pw.print(pkg);
                        pw.println(":");
                        printedHeader = true;
                    }
                    pw.print("      Allow: ");
                    pw.println(asc.valueAt(j));
                }
                if (!this.mAllowedAssociations.valueAt(i).isDebuggable()) continue;
                pw.println("      (debuggable)");
            }
        }
        if (!printed) {
            pw.println("  (No association restrictions)");
        }
    }

    void dumpBroadcastsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean onlyHistory = false;
        boolean printedAnything = false;
        if ("history".equals(dumpPackage)) {
            if (opti < args.length && "-s".equals(args[opti])) {
                dumpAll = false;
            }
            onlyHistory = true;
            dumpPackage = null;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATE (dumpsys activity broadcasts)");
        if (!onlyHistory && dumpAll) {
            if (this.mRegisteredReceivers.size() > 0) {
                boolean printed = false;
                for (ReceiverList r : this.mRegisteredReceivers.values()) {
                    if (dumpPackage != null && (r.app == null || !dumpPackage.equals(r.app.info.packageName))) continue;
                    if (!printed) {
                        pw.println("  Registered Receivers:");
                        needSep = true;
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("  * ");
                    pw.println(r);
                    r.dump(pw, "    ");
                }
            }
            if (this.mReceiverResolver.dump(pw, needSep ? "\n  Receiver Resolver Table:" : "  Receiver Resolver Table:", "    ", dumpPackage, false, false)) {
                needSep = true;
                printedAnything = true;
            }
        }
        for (BroadcastQueue q : this.mBroadcastQueues) {
            needSep = q.dumpLocked(fd, pw, args, opti, dumpAll, dumpPackage, needSep);
            printedAnything |= needSep;
        }
        needSep = true;
        if (!onlyHistory && this.mStickyBroadcasts != null && dumpPackage == null) {
            for (int user = 0; user < this.mStickyBroadcasts.size(); ++user) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                printedAnything = true;
                pw.print("  Sticky broadcasts for user ");
                pw.print(this.mStickyBroadcasts.keyAt(user));
                pw.println(":");
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.valueAt(user).entrySet()) {
                    pw.print("  * Sticky action ");
                    pw.print(ent.getKey());
                    if (dumpAll) {
                        pw.println(":");
                        ArrayList<Intent> intents = ent.getValue();
                        int N = intents.size();
                        for (int i = 0; i < N; ++i) {
                            sb.setLength(0);
                            sb.append("    Intent: ");
                            intents.get(i).toShortString(sb, false, true, false, false);
                            pw.println(sb.toString());
                            Bundle bundle = intents.get(i).getExtras();
                            if (bundle == null) continue;
                            pw.print("      ");
                            pw.println(bundle.toString());
                        }
                        continue;
                    }
                    pw.println("");
                }
            }
        }
        if (!onlyHistory && dumpAll) {
            pw.println();
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                pw.println("  mBroadcastsScheduled [" + queue.mQueueName + "]=" + queue.mBroadcastsScheduled);
            }
            pw.println("  mHandler:");
            this.mHandler.dump(new PrintWriterPrinter(pw), "    ");
            needSep = true;
            printedAnything = true;
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpBroadcastStatsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        if (this.mCurBroadcastStats == null) {
            return;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATS STATE (dumpsys activity broadcast-stats)");
        long now = SystemClock.elapsedRealtime();
        if (this.mLastBroadcastStats != null) {
            pw.print("  Last stats (from ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mStartRealtime, now, pw);
            pw.print(" to ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mEndRealtime, now, pw);
            pw.print(", ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mEndUptime - this.mLastBroadcastStats.mStartUptime, pw);
            pw.println(" uptime):");
            if (!this.mLastBroadcastStats.dumpStats(pw, "    ", dumpPackage)) {
                pw.println("    (nothing)");
            }
            pw.println();
        }
        pw.print("  Current stats (from ");
        TimeUtils.formatDuration(this.mCurBroadcastStats.mStartRealtime, now, pw);
        pw.print(" to now, ");
        TimeUtils.formatDuration(SystemClock.uptimeMillis() - this.mCurBroadcastStats.mStartUptime, pw);
        pw.println(" uptime):");
        if (!this.mCurBroadcastStats.dumpStats(pw, "    ", dumpPackage)) {
            pw.println("    (nothing)");
        }
    }

    void dumpBroadcastStatsCheckinLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean fullCheckin, String dumpPackage) {
        if (this.mCurBroadcastStats == null) {
            return;
        }
        if (this.mLastBroadcastStats != null) {
            this.mLastBroadcastStats.dumpCheckinStats(pw, dumpPackage);
            if (fullCheckin) {
                this.mLastBroadcastStats = null;
                return;
            }
        }
        this.mCurBroadcastStats.dumpCheckinStats(pw, dumpPackage);
        if (fullCheckin) {
            this.mCurBroadcastStats = null;
        }
    }

    void dumpProvidersLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printedAnything = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER CONTENT PROVIDERS (dumpsys activity providers)");
        boolean needSep = this.mProviderMap.dumpProvidersLocked(pw, dumpAll, dumpPackage);
        printedAnything |= needSep;
        if (this.mLaunchingProviders.size() > 0) {
            boolean printed = false;
            for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
                ContentProviderRecord r = this.mLaunchingProviders.get(i);
                if (dumpPackage != null && !dumpPackage.equals(r.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Launching content providers:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  Launching #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    @GuardedBy(value={"this"})
    void dumpPermissionsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        pw.println("ACTIVITY MANAGER URI PERMISSIONS (dumpsys activity permissions)");
        this.mUgmInternal.dump(pw, dumpAll, dumpPackage);
    }

    private static final int dumpProcessList(PrintWriter pw, ActivityManagerService service, List list, String prefix, String normalLabel, String persistentLabel, String dumpPackage) {
        int N;
        int numPers = 0;
        for (int i = N = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            pw.println(String.format("%s%s #%2d: %s", prefix, r.isPersistent() ? persistentLabel : normalLabel, i, r.toString()));
            if (!r.isPersistent()) continue;
            ++numPers;
        }
        return numPers;
    }

    private static final ArrayList<Pair<ProcessRecord, Integer>> sortProcessOomList(List<ProcessRecord> origList, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = new ArrayList<Pair<ProcessRecord, Integer>>(origList.size());
        for (int i = 0; i < origList.size(); ++i) {
            ProcessRecord r = origList.get(i);
            if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
            list.add(new Pair<ProcessRecord, Integer>(origList.get(i), i));
        }
        Comparator<Pair<ProcessRecord, Integer>> comparator = new Comparator<Pair<ProcessRecord, Integer>>(){

            @Override
            public int compare(Pair<ProcessRecord, Integer> object1, Pair<ProcessRecord, Integer> object2) {
                if (((ProcessRecord)object1.first).setAdj != ((ProcessRecord)object2.first).setAdj) {
                    return ((ProcessRecord)object1.first).setAdj > ((ProcessRecord)object2.first).setAdj ? -1 : 1;
                }
                if (((ProcessRecord)object1.first).setProcState != ((ProcessRecord)object2.first).setProcState) {
                    return ((ProcessRecord)object1.first).setProcState > ((ProcessRecord)object2.first).setProcState ? -1 : 1;
                }
                if (((Integer)object1.second).intValue() != ((Integer)object2.second).intValue()) {
                    return (Integer)object1.second > (Integer)object2.second ? -1 : 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        return list;
    }

    private static final boolean writeProcessOomListToProto(ProtoOutputStream proto, long fieldId, ActivityManagerService service, List<ProcessRecord> origList, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = ActivityManagerService.sortProcessOomList(origList, dumpPackage);
        if (list.isEmpty()) {
            return false;
        }
        long curUptime = SystemClock.uptimeMillis();
        for (int i = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get((int)i).first;
            long token = proto.start(fieldId);
            String oomAdj = ProcessList.makeOomAdjString(r.setAdj, true);
            proto.write(0x10800000001L, r.isPersistent());
            proto.write(1120986464258L, origList.size() - 1 - (Integer)list.get((int)i).second);
            proto.write(1138166333443L, oomAdj);
            int schedGroup = -1;
            switch (r.setSchedGroup) {
                case 0: {
                    schedGroup = 0;
                    break;
                }
                case 2: {
                    schedGroup = 1;
                    break;
                }
                case 3: {
                    schedGroup = 2;
                    break;
                }
                case 4: {
                    schedGroup = 3;
                }
            }
            if (schedGroup != -1) {
                proto.write(1159641169924L, schedGroup);
            }
            if (r.hasForegroundActivities()) {
                proto.write(1133871366149L, true);
            } else if (r.hasForegroundServices()) {
                proto.write(1133871366150L, true);
            }
            proto.write(1159641169927L, ProcessList.makeProcStateProtoEnum(r.getCurProcState()));
            proto.write(1120986464264L, r.trimMemoryLevel);
            r.writeToProto(proto, 1146756268041L);
            proto.write(1138166333450L, r.adjType);
            if (r.adjSource != null || r.adjTarget != null) {
                if (r.adjTarget instanceof ComponentName) {
                    ComponentName cn = (ComponentName)r.adjTarget;
                    cn.writeToProto(proto, 0x10B0000000BL);
                } else if (r.adjTarget != null) {
                    proto.write(1138166333452L, r.adjTarget.toString());
                }
                if (r.adjSource instanceof ProcessRecord) {
                    ProcessRecord p = (ProcessRecord)r.adjSource;
                    p.writeToProto(proto, 1146756268045L);
                } else if (r.adjSource != null) {
                    proto.write(1138166333454L, r.adjSource.toString());
                }
            }
            if (inclDetails) {
                long detailToken = proto.start(1146756268047L);
                proto.write(0x10500000001L, r.maxAdj);
                proto.write(1120986464258L, r.getCurRawAdj());
                proto.write(1120986464259L, r.setRawAdj);
                proto.write(1120986464260L, r.curAdj);
                proto.write(0x10500000005L, r.setAdj);
                proto.write(1159641169927L, ProcessList.makeProcStateProtoEnum(r.getCurProcState()));
                proto.write(1159641169928L, ProcessList.makeProcStateProtoEnum(r.setProcState));
                proto.write(0x10900000009L, DebugUtils.sizeValueToString(r.lastPss * 1024L, new StringBuilder()));
                proto.write(1138166333450L, DebugUtils.sizeValueToString(r.lastSwapPss * 1024L, new StringBuilder()));
                proto.write(1138166333451L, DebugUtils.sizeValueToString(r.lastCachedPss * 1024L, new StringBuilder()));
                proto.write(1133871366156L, r.cached);
                proto.write(1133871366157L, r.empty);
                proto.write(1133871366158L, r.hasAboveClient);
                if (r.setProcState >= 11 && r.lastCpuTime != 0L) {
                    long uptimeSince = curUptime - service.mLastPowerCheckUptime;
                    long timeUsed = r.curCpuTime - r.lastCpuTime;
                    long cpuTimeToken = proto.start(1146756268047L);
                    proto.write(0x10300000001L, uptimeSince);
                    proto.write(1112396529666L, timeUsed);
                    proto.write(1108101562371L, 100.0 * (double)timeUsed / (double)uptimeSince);
                    proto.end(cpuTimeToken);
                }
                proto.end(detailToken);
            }
            proto.end(token);
        }
        return true;
    }

    private static final boolean dumpProcessOomList(PrintWriter pw, ActivityManagerService service, List<ProcessRecord> origList, String prefix, String normalLabel, String persistentLabel, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = ActivityManagerService.sortProcessOomList(origList, dumpPackage);
        if (list.isEmpty()) {
            return false;
        }
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - service.mLastPowerCheckUptime;
        for (int i = list.size() - 1; i >= 0; --i) {
            char schedGroup;
            ProcessRecord r = (ProcessRecord)list.get((int)i).first;
            String oomAdj = ProcessList.makeOomAdjString(r.setAdj, false);
            switch (r.setSchedGroup) {
                case 0: {
                    schedGroup = 'B';
                    break;
                }
                case 2: {
                    schedGroup = 'F';
                    break;
                }
                case 3: {
                    schedGroup = 'T';
                    break;
                }
                case 1: {
                    schedGroup = 'R';
                    break;
                }
                default: {
                    schedGroup = '?';
                }
            }
            char foreground = r.hasForegroundActivities() ? (char)'A' : (r.hasForegroundServices() ? (char)'S' : ' ');
            String procState = ProcessList.makeProcStateString(r.getCurProcState());
            pw.print(prefix);
            pw.print(r.isPersistent() ? persistentLabel : normalLabel);
            pw.print(" #");
            int num = origList.size() - 1 - (Integer)list.get((int)i).second;
            if (num < 10) {
                pw.print(' ');
            }
            pw.print(num);
            pw.print(": ");
            pw.print(oomAdj);
            pw.print(' ');
            pw.print(schedGroup);
            pw.print('/');
            pw.print(foreground);
            pw.print('/');
            pw.print(procState);
            pw.print(" trm:");
            if (r.trimMemoryLevel < 10) {
                pw.print(' ');
            }
            pw.print(r.trimMemoryLevel);
            pw.print(' ');
            pw.print(r.toShortString());
            pw.print(" (");
            pw.print(r.adjType);
            pw.println(')');
            if (r.adjSource != null || r.adjTarget != null) {
                pw.print(prefix);
                pw.print("    ");
                if (r.adjTarget instanceof ComponentName) {
                    pw.print(((ComponentName)r.adjTarget).flattenToShortString());
                } else if (r.adjTarget != null) {
                    pw.print(r.adjTarget.toString());
                } else {
                    pw.print("{null}");
                }
                pw.print("<=");
                if (r.adjSource instanceof ProcessRecord) {
                    pw.print("Proc{");
                    pw.print(((ProcessRecord)r.adjSource).toShortString());
                    pw.println("}");
                } else if (r.adjSource != null) {
                    pw.println(r.adjSource.toString());
                } else {
                    pw.println("{null}");
                }
            }
            if (!inclDetails) continue;
            pw.print(prefix);
            pw.print("    ");
            pw.print("oom: max=");
            pw.print(r.maxAdj);
            pw.print(" curRaw=");
            pw.print(r.getCurRawAdj());
            pw.print(" setRaw=");
            pw.print(r.setRawAdj);
            pw.print(" cur=");
            pw.print(r.curAdj);
            pw.print(" set=");
            pw.println(r.setAdj);
            pw.print(prefix);
            pw.print("    ");
            pw.print("state: cur=");
            pw.print(ProcessList.makeProcStateString(r.getCurProcState()));
            pw.print(" set=");
            pw.print(ProcessList.makeProcStateString(r.setProcState));
            pw.print(" lastPss=");
            DebugUtils.printSizeValue(pw, r.lastPss * 1024L);
            pw.print(" lastSwapPss=");
            DebugUtils.printSizeValue(pw, r.lastSwapPss * 1024L);
            pw.print(" lastCachedPss=");
            DebugUtils.printSizeValue(pw, r.lastCachedPss * 1024L);
            pw.println();
            pw.print(prefix);
            pw.print("    ");
            pw.print("cached=");
            pw.print(r.cached);
            pw.print(" empty=");
            pw.print(r.empty);
            pw.print(" hasAboveClient=");
            pw.println(r.hasAboveClient);
            if (r.setProcState < 11 || r.lastCpuTime == 0L) continue;
            long timeUsed = r.curCpuTime - r.lastCpuTime;
            pw.print(prefix);
            pw.print("    ");
            pw.print("run cpu over ");
            TimeUtils.formatDuration(uptimeSince, pw);
            pw.print(" used ");
            TimeUtils.formatDuration(timeUsed, pw);
            pw.print(" (");
            pw.print(timeUsed * 100L / uptimeSince);
            pw.println("%)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArrayList<ProcessRecord> collectProcesses(PrintWriter pw, int start, boolean allPkgs, String[] args) {
        ArrayList<ProcessRecord> arrayList;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                arrayList = this.mProcessList.collectProcessesLocked(start, allPkgs, args);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpGraphicsHardwareUsage(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        pw.println("Applications Graphics Acceleration Info:");
        pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Graphics info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpGfxInfo(tp.getWriteFd(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpDbInfo(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        pw.println("Applications Database Info:");
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Database info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpDbInfo(tp.getWriteFd(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    private static void sortMemItems(List<MemItem> items) {
        Collections.sort(items, new Comparator<MemItem>(){

            @Override
            public int compare(MemItem lhs, MemItem rhs) {
                if (lhs.pss < rhs.pss) {
                    return 1;
                }
                if (lhs.pss > rhs.pss) {
                    return -1;
                }
                return 0;
            }
        });
    }

    static final void dumpMemItems(PrintWriter pw, String prefix, String tag, ArrayList<MemItem> items, boolean sort, boolean isCompact, boolean dumpSwapPss) {
        if (sort && !isCompact) {
            ActivityManagerService.sortMemItems(items);
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            if (!isCompact) {
                if (dumpSwapPss) {
                    pw.printf("%s%s: %-60s (%s in swap)\n", prefix, ActivityManagerService.stringifyKBSize(mi.pss), mi.label, ActivityManagerService.stringifyKBSize(mi.swapPss));
                } else {
                    pw.printf("%s%s: %s\n", prefix, ActivityManagerService.stringifyKBSize(mi.pss), mi.label);
                }
            } else if (mi.isProc) {
                pw.print("proc,");
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.id);
                pw.print(",");
                pw.print(mi.pss);
                pw.print(",");
                pw.print(dumpSwapPss ? Long.valueOf(mi.swapPss) : "N/A");
                pw.println(mi.hasActivities ? ",a" : ",e");
            } else {
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.pss);
                pw.print(",");
                pw.println(dumpSwapPss ? Long.valueOf(mi.swapPss) : "N/A");
            }
            if (mi.subitems == null) continue;
            ActivityManagerService.dumpMemItems(pw, prefix + "    ", mi.shortLabel, mi.subitems, true, isCompact, dumpSwapPss);
        }
    }

    static final void dumpMemItems(ProtoOutputStream proto, long fieldId, String tag, ArrayList<MemItem> items, boolean sort, boolean dumpSwapPss) {
        if (sort) {
            ActivityManagerService.sortMemItems(items);
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, tag);
            proto.write(1138166333442L, mi.shortLabel);
            proto.write(1133871366148L, mi.isProc);
            proto.write(1120986464259L, mi.id);
            proto.write(1133871366149L, mi.hasActivities);
            proto.write(1112396529670L, mi.pss);
            if (dumpSwapPss) {
                proto.write(1112396529671L, mi.swapPss);
            }
            if (mi.subitems != null) {
                ActivityManagerService.dumpMemItems(proto, 2246267895816L, mi.shortLabel, mi.subitems, true, dumpSwapPss);
            }
            proto.end(token);
        }
    }

    static final void appendMemBucket(StringBuilder out, long memKB, String label, boolean stackLike) {
        int start = label.lastIndexOf(46);
        start = start >= 0 ? ++start : 0;
        int end = label.length();
        for (int i = 0; i < DUMP_MEM_BUCKETS.length; ++i) {
            if (DUMP_MEM_BUCKETS[i] < memKB) continue;
            long bucket = DUMP_MEM_BUCKETS[i] / 1024L;
            out.append(bucket);
            out.append(stackLike ? "MB." : "MB ");
            out.append(label, start, end);
            return;
        }
        out.append(memKB / 1024L);
        out.append(stackLike ? "MB." : "MB ");
        out.append(label, start, end);
    }

    private final void dumpApplicationMemoryUsageHeader(PrintWriter pw, long uptime, long realtime, boolean isCheckinRequest, boolean isCompact) {
        if (isCompact) {
            pw.print("version,");
            pw.println(1);
        }
        if (isCheckinRequest || isCompact) {
            pw.print("time,");
            pw.print(uptime);
            pw.print(",");
            pw.println(realtime);
        } else {
            pw.println("Applications Memory Usage (in Kilobytes):");
            pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        }
    }

    private final long[] getKsmInfo() {
        long[] longOut = new long[4];
        int[] SINGLE_LONG_FORMAT = new int[]{8224};
        long[] longTmp = new long[1];
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_shared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[0] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_sharing", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[1] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_unshared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[2] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_volatile", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[3] = longTmp[0] * 4096L / 1024L;
        return longOut;
    }

    private static String stringifySize(long size, int order) {
        Locale locale = Locale.US;
        switch (order) {
            case 1: {
                return String.format(locale, "%,13d", size);
            }
            case 1024: {
                return String.format(locale, "%,9dK", size / 1024L);
            }
            case 0x100000: {
                return String.format(locale, "%,5dM", size / 1024L / 1024L);
            }
            case 0x40000000: {
                return String.format(locale, "%,1dG", size / 1024L / 1024L / 1024L);
            }
        }
        throw new IllegalArgumentException("Invalid size order");
    }

    private static String stringifyKBSize(long size) {
        return ActivityManagerService.stringifySize(size * 1024L, 1024);
    }

    final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, String[] args, boolean brief, PrintWriter categoryPw, boolean asProto) {
        String opt;
        int opti;
        MemoryUsageDumpOptions opts = new MemoryUsageDumpOptions();
        opts.dumpDetails = false;
        opts.dumpFullDetails = false;
        opts.dumpDalvik = false;
        opts.dumpSummaryOnly = false;
        opts.dumpUnreachable = false;
        opts.oomOnly = false;
        opts.isCompact = false;
        opts.localOnly = false;
        opts.packages = false;
        opts.isCheckinRequest = false;
        opts.dumpSwapPss = false;
        opts.dumpProto = asProto;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                opts.dumpDetails = true;
                opts.dumpFullDetails = true;
                opts.dumpDalvik = true;
                opts.dumpSwapPss = true;
                continue;
            }
            if ("-d".equals(opt)) {
                opts.dumpDalvik = true;
                continue;
            }
            if ("-c".equals(opt)) {
                opts.isCompact = true;
                continue;
            }
            if ("-s".equals(opt)) {
                opts.dumpDetails = true;
                opts.dumpSummaryOnly = true;
                continue;
            }
            if ("-S".equals(opt)) {
                opts.dumpSwapPss = true;
                continue;
            }
            if ("--unreachable".equals(opt)) {
                opts.dumpUnreachable = true;
                continue;
            }
            if ("--oom".equals(opt)) {
                opts.oomOnly = true;
                continue;
            }
            if ("--local".equals(opt)) {
                opts.localOnly = true;
                continue;
            }
            if ("--package".equals(opt)) {
                opts.packages = true;
                continue;
            }
            if ("--checkin".equals(opt)) {
                opts.isCheckinRequest = true;
                continue;
            }
            if ("--proto".equals(opt)) {
                opts.dumpProto = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("meminfo dump options: [-a] [-d] [-c] [-s] [--oom] [process]");
                pw.println("  -a: include all available information for each process.");
                pw.println("  -d: include dalvik details.");
                pw.println("  -c: dump in a compact machine-parseable representation.");
                pw.println("  -s: dump only summary of application memory usage.");
                pw.println("  -S: dump also SwapPss.");
                pw.println("  --oom: only show processes organized by oom adj.");
                pw.println("  --local: only collect details locally, don't call process.");
                pw.println("  --package: interpret process arg as package, dumping all");
                pw.println("             processes that have loaded that package.");
                pw.println("  --checkin: dump data for a checkin");
                pw.println("  --proto: dump data to proto");
                pw.println("If [process] is specified it can be the name or ");
                pw.println("pid of a specific process to dump.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        String[] innerArgs = new String[args.length - opti];
        System.arraycopy(args, opti, innerArgs, 0, args.length - opti);
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, opti, opts.packages, args);
        if (opts.dumpProto) {
            this.dumpApplicationMemoryUsage(fd, opts, innerArgs, brief, procs);
        } else {
            this.dumpApplicationMemoryUsage(fd, pw, prefix, opts, innerArgs, brief, procs, categoryPw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, MemoryUsageDumpOptions opts, String[] innerArgs, boolean brief, ArrayList<ProcessRecord> procs, PrintWriter categoryPw) {
        int N;
        long nativeProcTotalPss;
        long[] tmpLong;
        long realtime;
        long uptime;
        block96: {
            ArrayList<ProcessCpuTracker.Stats> nativeProcs;
            block98: {
                String proc;
                block97: {
                    block95: {
                        uptime = SystemClock.uptimeMillis();
                        realtime = SystemClock.elapsedRealtime();
                        tmpLong = new long[1];
                        if (procs == null) break block95;
                        if (!brief && !opts.oomOnly && (procs.size() == 1 || opts.isCheckinRequest || opts.packages)) {
                            opts.dumpDetails = true;
                        }
                        break block96;
                    }
                    proc = "N/A";
                    if (innerArgs.length <= 0 || (proc = innerArgs[0]).charAt(0) == '-') break block97;
                    nativeProcs = new ArrayList<ProcessCpuTracker.Stats>();
                    this.updateCpuStatsNow();
                    int findPid = -1;
                    try {
                        findPid = Integer.parseInt(innerArgs[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
                    // MONITORENTER : processCpuTracker
                    int N2 = this.mProcessCpuTracker.countStats();
                    for (int i = 0; i < N2; ++i) {
                        ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                        if (st.pid != findPid && (st.baseName == null || !st.baseName.equals(innerArgs[0]))) continue;
                        nativeProcs.add(st);
                    }
                    // MONITOREXIT : processCpuTracker
                    if (nativeProcs.size() > 0) break block98;
                }
                pw.println("No process found for: " + proc);
                return;
            }
            this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, opts.isCheckinRequest, opts.isCompact);
            Debug.MemoryInfo mi = null;
            int i = nativeProcs.size() - 1;
            while (i >= 0) {
                ProcessCpuTracker.Stats r = (ProcessCpuTracker.Stats)nativeProcs.get(i);
                int pid = r.pid;
                if (!opts.isCheckinRequest && opts.dumpDetails) {
                    pw.println("\n** MEMINFO in pid " + pid + " [" + r.baseName + "] **");
                }
                if (mi == null) {
                    mi = new Debug.MemoryInfo();
                }
                if (opts.dumpDetails || !brief && !opts.oomOnly) {
                    Debug.getMemoryInfo(pid, mi);
                } else {
                    mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                    mi.dalvikPrivateDirty = (int)tmpLong[0];
                }
                ActivityThread.dumpMemInfoTable(pw, mi, opts.isCheckinRequest, opts.dumpFullDetails, opts.dumpDalvik, opts.dumpSummaryOnly, pid, r.baseName, 0L, 0L, 0L, 0L, 0L, 0L);
                if (opts.isCheckinRequest) {
                    pw.println();
                }
                --i;
            }
            return;
        }
        this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, opts.isCheckinRequest, opts.isCompact);
        ArrayList<MemItem> procMems = new ArrayList<MemItem>();
        SparseArray<MemItem> procMemsMap = new SparseArray<MemItem>();
        long nativePss = 0L;
        long nativeSwapPss = 0L;
        long dalvikPss = 0L;
        long dalvikSwapPss = 0L;
        long[] dalvikSubitemPss = opts.dumpDalvik ? new long[14] : EmptyArray.LONG;
        long[] dalvikSubitemSwapPss = opts.dumpDalvik ? new long[14] : EmptyArray.LONG;
        long otherPss = 0L;
        long otherSwapPss = 0L;
        long[] miscPss = new long[17];
        long[] miscSwapPss = new long[17];
        long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
        long[] oomSwapPss = new long[DUMP_MEM_OOM_LABEL.length];
        ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
        long totalPss = 0L;
        long totalSwapPss = 0L;
        long cachedPss = 0L;
        long cachedSwapPss = 0L;
        boolean hasSwapPss = false;
        Debug.MemoryInfo mi = null;
        int i = procs.size() - 1;
        while (true) {
            block100: {
                MemItem pssItem;
                long myTotalSwapPss;
                long myTotalPss;
                int oomAdj;
                block101: {
                    Object thread;
                    block99: {
                        int j;
                        long endTime;
                        long startTime;
                        int reportType;
                        boolean hasActivities;
                        int pid;
                        ProcessRecord r;
                        block93: {
                            if (i < 0) break block99;
                            r = procs.get(i);
                            ActivityManagerService activityManagerService = this;
                            // MONITORENTER : activityManagerService
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                thread = r.thread;
                                pid = r.pid;
                                oomAdj = r.getSetAdjWithServices();
                                hasActivities = r.hasActivities();
                                // MONITOREXIT : activityManagerService
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT : activityManagerService
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            if (thread == null) break block100;
                            if (!opts.isCheckinRequest && opts.dumpDetails) {
                                pw.println("\n** MEMINFO in pid " + pid + " [" + r.processName + "] **");
                            }
                            if (mi == null) {
                                mi = new Debug.MemoryInfo();
                            }
                            if (opts.dumpDetails || !brief && !opts.oomOnly) {
                                reportType = 4;
                                startTime = SystemClock.currentThreadTimeMillis();
                                Debug.getMemoryInfo(pid, mi);
                                endTime = SystemClock.currentThreadTimeMillis();
                                hasSwapPss = mi.hasSwappedOutPss;
                            } else {
                                reportType = 3;
                                startTime = SystemClock.currentThreadTimeMillis();
                                mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                                endTime = SystemClock.currentThreadTimeMillis();
                                mi.dalvikPrivateDirty = (int)tmpLong[0];
                            }
                            if (opts.dumpDetails) {
                                if (opts.localOnly) {
                                    ActivityThread.dumpMemInfoTable(pw, mi, opts.isCheckinRequest, opts.dumpFullDetails, opts.dumpDalvik, opts.dumpSummaryOnly, pid, r.processName, 0L, 0L, 0L, 0L, 0L, 0L);
                                    if (opts.isCheckinRequest) {
                                        pw.println();
                                    }
                                } else {
                                    pw.flush();
                                    try {
                                        TransferPipe tp = new TransferPipe();
                                        try {
                                            thread.dumpMemInfo(tp.getWriteFd(), mi, opts.isCheckinRequest, opts.dumpFullDetails, opts.dumpDalvik, opts.dumpSummaryOnly, opts.dumpUnreachable, innerArgs);
                                            tp.go(fd, opts.dumpUnreachable ? 30000L : 5000L);
                                        }
                                        finally {
                                            tp.kill();
                                        }
                                    }
                                    catch (IOException e) {
                                        if (!opts.isCheckinRequest) {
                                            pw.println("Got IoException! " + e);
                                            pw.flush();
                                        }
                                    }
                                    catch (RemoteException e) {
                                        if (opts.isCheckinRequest) break block93;
                                        pw.println("Got RemoteException! " + e);
                                        pw.flush();
                                    }
                                }
                            }
                        }
                        myTotalPss = mi.getTotalPss();
                        long myTotalUss = mi.getTotalUss();
                        long myTotalRss = mi.getTotalRss();
                        myTotalSwapPss = mi.getTotalSwappedOutPss();
                        ActivityManagerService activityManagerService = this;
                        // MONITORENTER : activityManagerService
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.thread != null && oomAdj == r.getSetAdjWithServices()) {
                                r.baseProcessTracker.addPss(myTotalPss, myTotalUss, myTotalRss, true, reportType, endTime - startTime, r.pkgList.mPkgList);
                                for (int ipkg = r.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                                    ProcessStats.ProcessStateHolder holder = r.pkgList.valueAt(ipkg);
                                    StatsLog.write(18, r.info.uid, holder.state.getName(), holder.state.getPackage(), myTotalPss, myTotalUss, myTotalRss, reportType, endTime - startTime, holder.appVersion);
                                }
                            }
                            // MONITOREXIT : activityManagerService
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        if (opts.isCheckinRequest) break block100;
                        if (mi == null) break block100;
                        totalPss += myTotalPss;
                        totalSwapPss += myTotalSwapPss;
                        pssItem = new MemItem(r.processName + " (pid " + pid + (hasActivities ? " / activities)" : ")"), r.processName, myTotalPss, myTotalSwapPss, pid, hasActivities);
                        procMems.add(pssItem);
                        procMemsMap.put(pid, pssItem);
                        nativePss += (long)mi.nativePss;
                        nativeSwapPss += (long)mi.nativeSwappedOutPss;
                        dalvikPss += (long)mi.dalvikPss;
                        dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
                        for (j = 0; j < dalvikSubitemPss.length; ++j) {
                            int n = j;
                            dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
                            int n2 = j;
                            dalvikSubitemSwapPss[n2] = dalvikSubitemSwapPss[n2] + (long)mi.getOtherSwappedOutPss(17 + j);
                        }
                        otherPss += (long)mi.otherPss;
                        otherSwapPss += (long)mi.otherSwappedOutPss;
                        j = 0;
                        while (j < 17) {
                            long mem = mi.getOtherPss(j);
                            int n = j;
                            miscPss[n] = miscPss[n] + mem;
                            otherPss -= mem;
                            mem = mi.getOtherSwappedOutPss(j);
                            int n3 = j++;
                            miscSwapPss[n3] = miscSwapPss[n3] + mem;
                            otherSwapPss -= mem;
                        }
                        if (oomAdj < 900) break block101;
                        cachedPss += myTotalPss;
                        cachedSwapPss += myTotalSwapPss;
                        break block101;
                    }
                    nativeProcTotalPss = 0L;
                    if (opts.isCheckinRequest) return;
                    if (procs.size() <= 1) return;
                    if (opts.packages) return;
                    this.updateCpuStatsNow();
                    mi = null;
                    thread = this.mProcessCpuTracker;
                    // MONITORENTER : thread
                    N = this.mProcessCpuTracker.countStats();
                    break;
                }
                for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                    if (oomIndex != oomPss.length - 1 && (oomAdj < DUMP_MEM_OOM_ADJ[oomIndex] || oomAdj >= DUMP_MEM_OOM_ADJ[oomIndex + 1])) continue;
                    int n = oomIndex;
                    oomPss[n] = oomPss[n] + myTotalPss;
                    int n4 = oomIndex;
                    oomSwapPss[n4] = oomSwapPss[n4] + myTotalSwapPss;
                    if (oomProcs[oomIndex] == null) {
                        oomProcs[oomIndex] = new ArrayList();
                    }
                    oomProcs[oomIndex].add(pssItem);
                    break;
                }
            }
            --i;
        }
        for (int i2 = 0; i2 < N; ++i2) {
            int j;
            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i2);
            if (st.vsize <= 0L || procMemsMap.indexOfKey(st.pid) >= 0) continue;
            if (mi == null) {
                mi = new Debug.MemoryInfo();
            }
            if (!brief && !opts.oomOnly) {
                Debug.getMemoryInfo(st.pid, mi);
            } else {
                mi.nativePss = (int)Debug.getPss(st.pid, tmpLong, null);
                mi.nativePrivateDirty = (int)tmpLong[0];
            }
            long myTotalPss = mi.getTotalPss();
            long myTotalSwapPss = mi.getTotalSwappedOutPss();
            totalPss += myTotalPss;
            totalSwapPss += myTotalSwapPss;
            nativeProcTotalPss += myTotalPss;
            MemItem pssItem = new MemItem(st.name + " (pid " + st.pid + ")", st.name, myTotalPss, mi.getSummaryTotalSwapPss(), st.pid, false);
            procMems.add(pssItem);
            nativePss += (long)mi.nativePss;
            nativeSwapPss += (long)mi.nativeSwappedOutPss;
            dalvikPss += (long)mi.dalvikPss;
            dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
            for (j = 0; j < dalvikSubitemPss.length; ++j) {
                int n = j;
                dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
                int n5 = j;
                dalvikSubitemSwapPss[n5] = dalvikSubitemSwapPss[n5] + (long)mi.getOtherSwappedOutPss(17 + j);
            }
            otherPss += (long)mi.otherPss;
            otherSwapPss += (long)mi.otherSwappedOutPss;
            j = 0;
            while (j < 17) {
                long mem = mi.getOtherPss(j);
                int n = j;
                miscPss[n] = miscPss[n] + mem;
                otherPss -= mem;
                mem = mi.getOtherSwappedOutPss(j);
                int n6 = j++;
                miscSwapPss[n6] = miscSwapPss[n6] + mem;
                otherSwapPss -= mem;
            }
            oomPss[0] = oomPss[0] + myTotalPss;
            oomSwapPss[0] = oomSwapPss[0] + myTotalSwapPss;
            if (oomProcs[0] == null) {
                oomProcs[0] = new ArrayList();
            }
            oomProcs[0].add(pssItem);
        }
        // MONITOREXIT : thread
        ArrayList<MemItem> catMems = new ArrayList<MemItem>();
        catMems.add(new MemItem("Native", "Native", nativePss, nativeSwapPss, -1));
        int dalvikId = -2;
        catMems.add(new MemItem("Dalvik", "Dalvik", dalvikPss, dalvikSwapPss, -2));
        catMems.add(new MemItem("Unknown", "Unknown", otherPss, otherSwapPss, -3));
        for (int j = 0; j < 17; ++j) {
            String label = Debug.MemoryInfo.getOtherLabel(j);
            catMems.add(new MemItem(label, label, miscPss[j], miscSwapPss[j], j));
        }
        if (dalvikSubitemPss.length > 0) {
            for (MemItem memItem : catMems) {
                int memItemStart = 0;
                int memItemEnd = 0;
                if (memItem.id == -2) {
                    memItemStart = 0;
                    memItemEnd = 3;
                } else if (memItem.id == 0) {
                    memItemStart = 4;
                    memItemEnd = 8;
                } else if (memItem.id == 10) {
                    memItemStart = 9;
                    memItemEnd = 11;
                } else {
                    if (memItem.id != 12) continue;
                    memItemStart = 12;
                    memItemEnd = 13;
                }
                memItem.subitems = new ArrayList();
                for (int j = memItemStart; j <= memItemEnd; ++j) {
                    String name = Debug.MemoryInfo.getOtherLabel(17 + j);
                    memItem.subitems.add(new MemItem(name, name, dalvikSubitemPss[j], dalvikSubitemSwapPss[j], j));
                }
            }
        }
        ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
        for (int j = 0; j < oomPss.length; ++j) {
            if (oomPss[j] == 0L) continue;
            String label = opts.isCompact ? DUMP_MEM_OOM_COMPACT_LABEL[j] : DUMP_MEM_OOM_LABEL[j];
            MemItem item = new MemItem(label, label, oomPss[j], oomSwapPss[j], DUMP_MEM_OOM_ADJ[j]);
            item.subitems = oomProcs[j];
            oomMems.add(item);
        }
        boolean bl = opts.dumpSwapPss = opts.dumpSwapPss && hasSwapPss && totalSwapPss != 0L;
        if (!(brief || opts.oomOnly || opts.isCompact)) {
            pw.println();
            pw.println("Total PSS by process:");
            ActivityManagerService.dumpMemItems(pw, "  ", "proc", procMems, true, opts.isCompact, opts.dumpSwapPss);
            pw.println();
        }
        if (!opts.isCompact) {
            pw.println("Total PSS by OOM adjustment:");
        }
        ActivityManagerService.dumpMemItems(pw, "  ", "oom", oomMems, false, opts.isCompact, opts.dumpSwapPss);
        if (!brief && !opts.oomOnly) {
            PrintWriter out;
            PrintWriter printWriter = out = categoryPw != null ? categoryPw : pw;
            if (!opts.isCompact) {
                out.println();
                out.println("Total PSS by category:");
            }
            ActivityManagerService.dumpMemItems(out, "  ", "cat", catMems, true, opts.isCompact, opts.dumpSwapPss);
        }
        if (!opts.isCompact) {
            pw.println();
        }
        MemInfoReader memInfo = new MemInfoReader();
        memInfo.readMemInfo();
        if (nativeProcTotalPss > 0L) {
            ActivityManagerService label = this;
            // MONITORENTER : label
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long cachedKb = memInfo.getCachedSizeKb();
                long freeKb = memInfo.getFreeSizeKb();
                long zramKb = memInfo.getZramTotalSizeKb();
                long kernelKb = memInfo.getKernelUsedSizeKb();
                EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeProcTotalPss * 1024L);
                this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeProcTotalPss);
                // MONITOREXIT : label
            }
            catch (Throwable throwable) {
                // MONITOREXIT : label
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
        if (!brief) {
            if (!opts.isCompact) {
                pw.print("Total RAM: ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getTotalSizeKb()));
                pw.print(" (status ");
                switch (this.mLastMemoryLevel) {
                    case 0: {
                        pw.println("normal)");
                        break;
                    }
                    case 1: {
                        pw.println("moderate)");
                        break;
                    }
                    case 2: {
                        pw.println("low)");
                        break;
                    }
                    case 3: {
                        pw.println("critical)");
                        break;
                    }
                    default: {
                        pw.print(this.mLastMemoryLevel);
                        pw.println(")");
                    }
                }
                pw.print(" Free RAM: ");
                pw.print(ActivityManagerService.stringifyKBSize(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb()));
                pw.print(" (");
                pw.print(ActivityManagerService.stringifyKBSize(cachedPss));
                pw.print(" cached pss + ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getCachedSizeKb()));
                pw.print(" cached kernel + ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getFreeSizeKb()));
                pw.println(" free)");
            } else {
                pw.print("ram,");
                pw.print(memInfo.getTotalSizeKb());
                pw.print(",");
                pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                pw.print(",");
                pw.println(totalPss - cachedPss);
            }
        }
        long lostRAM = memInfo.getTotalSizeKb() - (totalPss - totalSwapPss) - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb() - memInfo.getZramTotalSizeKb();
        if (!opts.isCompact) {
            pw.print(" Used RAM: ");
            pw.print(ActivityManagerService.stringifyKBSize(totalPss - cachedPss + memInfo.getKernelUsedSizeKb()));
            pw.print(" (");
            pw.print(ActivityManagerService.stringifyKBSize(totalPss - cachedPss));
            pw.print(" used pss + ");
            pw.print(ActivityManagerService.stringifyKBSize(memInfo.getKernelUsedSizeKb()));
            pw.print(" kernel)\n");
            pw.print(" Lost RAM: ");
            pw.println(ActivityManagerService.stringifyKBSize(lostRAM));
        } else {
            pw.print("lostram,");
            pw.println(lostRAM);
        }
        if (brief) return;
        if (memInfo.getZramTotalSizeKb() != 0L) {
            if (!opts.isCompact) {
                pw.print("     ZRAM: ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getZramTotalSizeKb()));
                pw.print(" physical used for ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getSwapTotalSizeKb() - memInfo.getSwapFreeSizeKb()));
                pw.print(" in swap (");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getSwapTotalSizeKb()));
                pw.println(" total swap)");
            } else {
                pw.print("zram,");
                pw.print(memInfo.getZramTotalSizeKb());
                pw.print(",");
                pw.print(memInfo.getSwapTotalSizeKb());
                pw.print(",");
                pw.println(memInfo.getSwapFreeSizeKb());
            }
        }
        long[] ksm = this.getKsmInfo();
        if (!opts.isCompact) {
            if (ksm[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
                pw.print("      KSM: ");
                pw.print(ActivityManagerService.stringifyKBSize(ksm[1]));
                pw.print(" saved from shared ");
                pw.print(ActivityManagerService.stringifyKBSize(ksm[0]));
                pw.print("           ");
                pw.print(ActivityManagerService.stringifyKBSize(ksm[2]));
                pw.print(" unshared; ");
                pw.print(ActivityManagerService.stringifyKBSize(ksm[3]));
                pw.println(" volatile");
            }
            pw.print("   Tuning: ");
            pw.print(ActivityManager.staticGetMemoryClass());
            pw.print(" (large ");
            pw.print(ActivityManager.staticGetLargeMemoryClass());
            pw.print("), oom ");
            pw.print(ActivityManagerService.stringifySize(this.mProcessList.getMemLevel(999), 1024));
            pw.print(", restore limit ");
            pw.print(ActivityManagerService.stringifyKBSize(this.mProcessList.getCachedRestoreThresholdKb()));
            if (ActivityManager.isLowRamDeviceStatic()) {
                pw.print(" (low-ram)");
            }
            if (ActivityManager.isHighEndGfx()) {
                pw.print(" (high-end-gfx)");
            }
            pw.println();
            return;
        }
        pw.print("ksm,");
        pw.print(ksm[1]);
        pw.print(",");
        pw.print(ksm[0]);
        pw.print(",");
        pw.print(ksm[2]);
        pw.print(",");
        pw.println(ksm[3]);
        pw.print("tuning,");
        pw.print(ActivityManager.staticGetMemoryClass());
        pw.print(',');
        pw.print(ActivityManager.staticGetLargeMemoryClass());
        pw.print(',');
        pw.print(this.mProcessList.getMemLevel(999) / 1024L);
        if (ActivityManager.isLowRamDeviceStatic()) {
            pw.print(",low-ram");
        }
        if (ActivityManager.isHighEndGfx()) {
            pw.print(",high-end-gfx");
        }
        pw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void dumpApplicationMemoryUsage(FileDescriptor fd, MemoryUsageDumpOptions opts, String[] innerArgs, boolean brief, ArrayList<ProcessRecord> procs) {
        ProtoOutputStream proto;
        block71: {
            int N;
            long nativeProcTotalPss;
            long[] tmpLong;
            long realtimeMs;
            long uptimeMs;
            block74: {
                int i;
                ArrayList<ProcessCpuTracker.Stats> nativeProcs;
                block76: {
                    block75: {
                        block73: {
                            uptimeMs = SystemClock.uptimeMillis();
                            realtimeMs = SystemClock.elapsedRealtime();
                            tmpLong = new long[1];
                            if (procs == null) break block73;
                            if (!brief && !opts.oomOnly && (procs.size() == 1 || opts.isCheckinRequest || opts.packages)) {
                                opts.dumpDetails = true;
                            }
                            break block74;
                        }
                        String proc = "N/A";
                        if (innerArgs.length <= 0 || (proc = innerArgs[0]).charAt(0) == '-') break block75;
                        nativeProcs = new ArrayList<ProcessCpuTracker.Stats>();
                        this.updateCpuStatsNow();
                        int findPid = -1;
                        try {
                            findPid = Integer.parseInt(innerArgs[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
                        // MONITORENTER : processCpuTracker
                        int N2 = this.mProcessCpuTracker.countStats();
                        for (i = 0; i < N2; ++i) {
                            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                            if (st.pid != findPid && (st.baseName == null || !st.baseName.equals(innerArgs[0]))) continue;
                            nativeProcs.add(st);
                        }
                        // MONITOREXIT : processCpuTracker
                        if (nativeProcs.size() > 0) break block76;
                    }
                    Log.d("ActivityManager", "No process found for: " + innerArgs[0]);
                    return;
                }
                ProtoOutputStream proto2 = new ProtoOutputStream(fd);
                proto2.write(0x10300000001L, uptimeMs);
                proto2.write(1112396529666L, realtimeMs);
                Debug.MemoryInfo mi = null;
                i = nativeProcs.size() - 1;
                while (true) {
                    if (i < 0) {
                        proto2.flush();
                        return;
                    }
                    ProcessCpuTracker.Stats r = (ProcessCpuTracker.Stats)nativeProcs.get(i);
                    int pid = r.pid;
                    long nToken = proto2.start(2246267895811L);
                    proto2.write(0x10500000001L, pid);
                    proto2.write(1138166333442L, r.baseName);
                    if (mi == null) {
                        mi = new Debug.MemoryInfo();
                    }
                    if (opts.dumpDetails || !brief && !opts.oomOnly) {
                        Debug.getMemoryInfo(pid, mi);
                    } else {
                        mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                        mi.dalvikPrivateDirty = (int)tmpLong[0];
                    }
                    ActivityThread.dumpMemInfoTable(proto2, mi, opts.dumpDalvik, opts.dumpSummaryOnly, 0L, 0L, 0L, 0L, 0L, 0L);
                    proto2.end(nToken);
                    --i;
                }
            }
            proto = new ProtoOutputStream(fd);
            proto.write(0x10300000001L, uptimeMs);
            proto.write(1112396529666L, realtimeMs);
            ArrayList<MemItem> procMems = new ArrayList<MemItem>();
            SparseArray<MemItem> procMemsMap = new SparseArray<MemItem>();
            long nativePss = 0L;
            long nativeSwapPss = 0L;
            long dalvikPss = 0L;
            long dalvikSwapPss = 0L;
            long[] dalvikSubitemPss = opts.dumpDalvik ? new long[14] : EmptyArray.LONG;
            long[] dalvikSubitemSwapPss = opts.dumpDalvik ? new long[14] : EmptyArray.LONG;
            long otherPss = 0L;
            long otherSwapPss = 0L;
            long[] miscPss = new long[17];
            long[] miscSwapPss = new long[17];
            long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
            long[] oomSwapPss = new long[DUMP_MEM_OOM_LABEL.length];
            ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
            long totalPss = 0L;
            long totalSwapPss = 0L;
            long cachedPss = 0L;
            long cachedSwapPss = 0L;
            boolean hasSwapPss = false;
            Debug.MemoryInfo mi = null;
            int i = procs.size() - 1;
            while (true) {
                block79: {
                    MemItem pssItem;
                    long myTotalSwapPss;
                    long myTotalPss;
                    int oomAdj;
                    block80: {
                        Object thread;
                        block77: {
                            int j;
                            long endTime;
                            long startTime;
                            int reportType;
                            boolean hasActivities;
                            int pid;
                            ProcessRecord r;
                            block78: {
                                if (i < 0) break block77;
                                r = procs.get(i);
                                ActivityManagerService activityManagerService = this;
                                // MONITORENTER : activityManagerService
                                try {
                                    ActivityManagerService.boostPriorityForLockedSection();
                                    thread = r.thread;
                                    pid = r.pid;
                                    oomAdj = r.getSetAdjWithServices();
                                    hasActivities = r.hasActivities();
                                    // MONITOREXIT : activityManagerService
                                }
                                catch (Throwable throwable) {
                                    // MONITOREXIT : activityManagerService
                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                    throw throwable;
                                }
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                if (thread != null) break block78;
                                break block79;
                            }
                            if (mi == null) {
                                mi = new Debug.MemoryInfo();
                            }
                            if (opts.dumpDetails || !brief && !opts.oomOnly) {
                                reportType = 4;
                                startTime = SystemClock.currentThreadTimeMillis();
                                Debug.getMemoryInfo(pid, mi);
                                endTime = SystemClock.currentThreadTimeMillis();
                                hasSwapPss = mi.hasSwappedOutPss;
                            } else {
                                reportType = 3;
                                startTime = SystemClock.currentThreadTimeMillis();
                                mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                                endTime = SystemClock.currentThreadTimeMillis();
                                mi.dalvikPrivateDirty = (int)tmpLong[0];
                            }
                            if (opts.dumpDetails) {
                                if (opts.localOnly) {
                                    long aToken = proto.start(2246267895812L);
                                    long mToken = proto.start(0x10B00000001L);
                                    proto.write(0x10500000001L, pid);
                                    proto.write(1138166333442L, r.processName);
                                    ActivityThread.dumpMemInfoTable(proto, mi, opts.dumpDalvik, opts.dumpSummaryOnly, 0L, 0L, 0L, 0L, 0L, 0L);
                                    proto.end(mToken);
                                    proto.end(aToken);
                                } else {
                                    try {
                                        ByteTransferPipe tp = new ByteTransferPipe();
                                        try {
                                            thread.dumpMemInfoProto(tp.getWriteFd(), mi, opts.dumpFullDetails, opts.dumpDalvik, opts.dumpSummaryOnly, opts.dumpUnreachable, innerArgs);
                                            proto.write(2246267895812L, tp.get());
                                        }
                                        finally {
                                            tp.kill();
                                        }
                                    }
                                    catch (IOException e) {
                                        Log.e("ActivityManager", "Got IOException!", e);
                                    }
                                    catch (RemoteException e) {
                                        Log.e("ActivityManager", "Got RemoteException!", e);
                                    }
                                }
                            }
                            myTotalPss = mi.getTotalPss();
                            long myTotalUss = mi.getTotalUss();
                            long myTotalRss = mi.getTotalRss();
                            myTotalSwapPss = mi.getTotalSwappedOutPss();
                            ActivityManagerService activityManagerService = this;
                            // MONITORENTER : activityManagerService
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                if (r.thread != null && oomAdj == r.getSetAdjWithServices()) {
                                    r.baseProcessTracker.addPss(myTotalPss, myTotalUss, myTotalRss, true, reportType, endTime - startTime, r.pkgList.mPkgList);
                                    for (int ipkg = r.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                                        ProcessStats.ProcessStateHolder holder = r.pkgList.valueAt(ipkg);
                                        StatsLog.write(18, r.info.uid, holder.state.getName(), holder.state.getPackage(), myTotalPss, myTotalUss, myTotalRss, reportType, endTime - startTime, holder.appVersion);
                                    }
                                }
                                // MONITOREXIT : activityManagerService
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT : activityManagerService
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            if (opts.isCheckinRequest) break block79;
                            if (mi == null) break block79;
                            totalPss += myTotalPss;
                            totalSwapPss += myTotalSwapPss;
                            pssItem = new MemItem(r.processName + " (pid " + pid + (hasActivities ? " / activities)" : ")"), r.processName, myTotalPss, myTotalSwapPss, pid, hasActivities);
                            procMems.add(pssItem);
                            procMemsMap.put(pid, pssItem);
                            nativePss += (long)mi.nativePss;
                            nativeSwapPss += (long)mi.nativeSwappedOutPss;
                            dalvikPss += (long)mi.dalvikPss;
                            dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
                            for (j = 0; j < dalvikSubitemPss.length; ++j) {
                                int n = j;
                                dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
                                int n2 = j;
                                dalvikSubitemSwapPss[n2] = dalvikSubitemSwapPss[n2] + (long)mi.getOtherSwappedOutPss(17 + j);
                            }
                            otherPss += (long)mi.otherPss;
                            otherSwapPss += (long)mi.otherSwappedOutPss;
                            j = 0;
                            while (j < 17) {
                                long mem = mi.getOtherPss(j);
                                int n = j;
                                miscPss[n] = miscPss[n] + mem;
                                otherPss -= mem;
                                mem = mi.getOtherSwappedOutPss(j);
                                int n3 = j++;
                                miscSwapPss[n3] = miscSwapPss[n3] + mem;
                                otherSwapPss -= mem;
                            }
                            if (oomAdj < 900) break block80;
                            cachedPss += myTotalPss;
                            cachedSwapPss += myTotalSwapPss;
                            break block80;
                        }
                        nativeProcTotalPss = 0L;
                        if (procs.size() > 1 && !opts.packages) {
                            this.updateCpuStatsNow();
                            mi = null;
                            thread = this.mProcessCpuTracker;
                            // MONITORENTER : thread
                            N = this.mProcessCpuTracker.countStats();
                            break;
                        }
                        break block71;
                    }
                    for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                        if (oomIndex != oomPss.length - 1 && (oomAdj < DUMP_MEM_OOM_ADJ[oomIndex] || oomAdj >= DUMP_MEM_OOM_ADJ[oomIndex + 1])) continue;
                        int n = oomIndex;
                        oomPss[n] = oomPss[n] + myTotalPss;
                        int n4 = oomIndex;
                        oomSwapPss[n4] = oomSwapPss[n4] + myTotalSwapPss;
                        if (oomProcs[oomIndex] == null) {
                            oomProcs[oomIndex] = new ArrayList();
                        }
                        oomProcs[oomIndex].add(pssItem);
                        break;
                    }
                }
                --i;
            }
            for (int i2 = 0; i2 < N; ++i2) {
                int j;
                ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i2);
                if (st.vsize <= 0L || procMemsMap.indexOfKey(st.pid) >= 0) continue;
                if (mi == null) {
                    mi = new Debug.MemoryInfo();
                }
                if (!brief && !opts.oomOnly) {
                    Debug.getMemoryInfo(st.pid, mi);
                } else {
                    mi.nativePss = (int)Debug.getPss(st.pid, tmpLong, null);
                    mi.nativePrivateDirty = (int)tmpLong[0];
                }
                long myTotalPss = mi.getTotalPss();
                long myTotalSwapPss = mi.getTotalSwappedOutPss();
                totalPss += myTotalPss;
                nativeProcTotalPss += myTotalPss;
                MemItem pssItem = new MemItem(st.name + " (pid " + st.pid + ")", st.name, myTotalPss, mi.getSummaryTotalSwapPss(), st.pid, false);
                procMems.add(pssItem);
                nativePss += (long)mi.nativePss;
                nativeSwapPss += (long)mi.nativeSwappedOutPss;
                dalvikPss += (long)mi.dalvikPss;
                dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
                for (j = 0; j < dalvikSubitemPss.length; ++j) {
                    int n = j;
                    dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
                    int n5 = j;
                    dalvikSubitemSwapPss[n5] = dalvikSubitemSwapPss[n5] + (long)mi.getOtherSwappedOutPss(17 + j);
                }
                otherPss += (long)mi.otherPss;
                otherSwapPss += (long)mi.otherSwappedOutPss;
                j = 0;
                while (j < 17) {
                    long mem = mi.getOtherPss(j);
                    int n = j;
                    miscPss[n] = miscPss[n] + mem;
                    otherPss -= mem;
                    mem = mi.getOtherSwappedOutPss(j);
                    int n6 = j++;
                    miscSwapPss[n6] = miscSwapPss[n6] + mem;
                    otherSwapPss -= mem;
                }
                oomPss[0] = oomPss[0] + myTotalPss;
                oomSwapPss[0] = oomSwapPss[0] + myTotalSwapPss;
                if (oomProcs[0] == null) {
                    oomProcs[0] = new ArrayList();
                }
                oomProcs[0].add(pssItem);
            }
            // MONITOREXIT : thread
            ArrayList<MemItem> catMems = new ArrayList<MemItem>();
            catMems.add(new MemItem("Native", "Native", nativePss, nativeSwapPss, -1));
            int dalvikId = -2;
            catMems.add(new MemItem("Dalvik", "Dalvik", dalvikPss, dalvikSwapPss, -2));
            catMems.add(new MemItem("Unknown", "Unknown", otherPss, otherSwapPss, -3));
            for (int j = 0; j < 17; ++j) {
                String label = Debug.MemoryInfo.getOtherLabel(j);
                catMems.add(new MemItem(label, label, miscPss[j], miscSwapPss[j], j));
            }
            if (dalvikSubitemPss.length > 0) {
                for (MemItem memItem : catMems) {
                    int memItemStart = 0;
                    int memItemEnd = 0;
                    if (memItem.id == -2) {
                        memItemStart = 0;
                        memItemEnd = 3;
                    } else if (memItem.id == 0) {
                        memItemStart = 4;
                        memItemEnd = 8;
                    } else if (memItem.id == 10) {
                        memItemStart = 9;
                        memItemEnd = 11;
                    } else {
                        if (memItem.id != 12) continue;
                        memItemStart = 12;
                        memItemEnd = 13;
                    }
                    memItem.subitems = new ArrayList();
                    for (int j = memItemStart; j <= memItemEnd; ++j) {
                        String name = Debug.MemoryInfo.getOtherLabel(17 + j);
                        memItem.subitems.add(new MemItem(name, name, dalvikSubitemPss[j], dalvikSubitemSwapPss[j], j));
                    }
                }
            }
            ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
            for (int j = 0; j < oomPss.length; ++j) {
                if (oomPss[j] == 0L) continue;
                String label = opts.isCompact ? DUMP_MEM_OOM_COMPACT_LABEL[j] : DUMP_MEM_OOM_LABEL[j];
                MemItem item = new MemItem(label, label, oomPss[j], oomSwapPss[j], DUMP_MEM_OOM_ADJ[j]);
                item.subitems = oomProcs[j];
                oomMems.add(item);
            }
            boolean bl = opts.dumpSwapPss = opts.dumpSwapPss && hasSwapPss && totalSwapPss != 0L;
            if (!opts.oomOnly) {
                ActivityManagerService.dumpMemItems(proto, 2246267895813L, "proc", procMems, true, opts.dumpSwapPss);
            }
            ActivityManagerService.dumpMemItems(proto, 2246267895814L, "oom", oomMems, false, opts.dumpSwapPss);
            if (!brief && !opts.oomOnly) {
                ActivityManagerService.dumpMemItems(proto, 2246267895815L, "cat", catMems, true, opts.dumpSwapPss);
            }
            MemInfoReader memInfo = new MemInfoReader();
            memInfo.readMemInfo();
            if (nativeProcTotalPss > 0L) {
                ActivityManagerService label = this;
                // MONITORENTER : label
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    long cachedKb = memInfo.getCachedSizeKb();
                    long freeKb = memInfo.getFreeSizeKb();
                    long zramKb = memInfo.getZramTotalSizeKb();
                    long kernelKb = memInfo.getKernelUsedSizeKb();
                    EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeProcTotalPss * 1024L);
                    this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeProcTotalPss);
                    // MONITOREXIT : label
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : label
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            if (!brief) {
                proto.write(1112396529672L, memInfo.getTotalSizeKb());
                proto.write(1159641169929L, this.mLastMemoryLevel);
                proto.write(1112396529674L, cachedPss);
                proto.write(1112396529675L, memInfo.getCachedSizeKb());
                proto.write(1112396529676L, memInfo.getFreeSizeKb());
            }
            long lostRAM = memInfo.getTotalSizeKb() - (totalPss - totalSwapPss) - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb() - memInfo.getZramTotalSizeKb();
            proto.write(1112396529677L, totalPss - cachedPss);
            proto.write(1112396529678L, memInfo.getKernelUsedSizeKb());
            proto.write(1112396529679L, lostRAM);
            if (!brief) {
                if (memInfo.getZramTotalSizeKb() != 0L) {
                    proto.write(0x10300000010L, memInfo.getZramTotalSizeKb());
                    proto.write(0x10300000011L, memInfo.getSwapTotalSizeKb() - memInfo.getSwapFreeSizeKb());
                    proto.write(1112396529682L, memInfo.getSwapTotalSizeKb());
                }
                long[] ksm = this.getKsmInfo();
                proto.write(0x10300000013L, ksm[1]);
                proto.write(1112396529684L, ksm[0]);
                proto.write(1112396529685L, ksm[2]);
                proto.write(1112396529686L, ksm[3]);
                proto.write(1120986464279L, ActivityManager.staticGetMemoryClass());
                proto.write(1120986464280L, ActivityManager.staticGetLargeMemoryClass());
                proto.write(1112396529689L, this.mProcessList.getMemLevel(999) / 1024L);
                proto.write(1112396529690L, this.mProcessList.getCachedRestoreThresholdKb());
                proto.write(1133871366171L, ActivityManager.isLowRamDeviceStatic());
                proto.write(1133871366172L, ActivityManager.isHighEndGfx());
            }
        }
        proto.flush();
    }

    private void appendBasicMemEntry(StringBuilder sb, int oomAdj, int procState, long pss, long memtrack, String name) {
        sb.append("  ");
        sb.append(ProcessList.makeOomAdjString(oomAdj, false));
        sb.append(' ');
        sb.append(ProcessList.makeProcStateString(procState));
        sb.append(' ');
        ProcessList.appendRamKb(sb, pss);
        sb.append(": ");
        sb.append(name);
        if (memtrack > 0L) {
            sb.append(" (");
            sb.append(ActivityManagerService.stringifyKBSize(memtrack));
            sb.append(" memtrack)");
        }
    }

    private void appendMemInfo(StringBuilder sb, ProcessMemInfo mi) {
        this.appendBasicMemEntry(sb, mi.oomAdj, mi.procState, mi.pss, mi.memtrack, mi.name);
        sb.append(" (pid ");
        sb.append(mi.pid);
        sb.append(") ");
        sb.append(mi.adjType);
        sb.append('\n');
        if (mi.adjReason != null) {
            sb.append("                      ");
            sb.append(mi.adjReason);
            sb.append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportMemUsage(ArrayList<ProcessMemInfo> memInfos) {
        long[] ksm;
        List<ProcessCpuTracker.Stats> stats;
        SparseArray<ProcessMemInfo> infoMap = new SparseArray<ProcessMemInfo>(memInfos.size());
        int N = memInfos.size();
        for (int i = 0; i < N; ++i) {
            ProcessMemInfo mi = memInfos.get(i);
            infoMap.put(mi.pid, mi);
        }
        this.updateCpuStatsNow();
        long[] memtrackTmp = new long[1];
        long[] swaptrackTmp = new long[2];
        ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
        synchronized (processCpuTracker) {
            stats = this.mProcessCpuTracker.getStats(st -> st.vsize > 0L);
        }
        int statsCount = stats.size();
        for (int i = 0; i < statsCount; ++i) {
            ProcessCpuTracker.Stats st2 = stats.get(i);
            long pss = Debug.getPss(st2.pid, swaptrackTmp, memtrackTmp);
            if (pss <= 0L || infoMap.indexOfKey(st2.pid) >= 0) continue;
            ProcessMemInfo mi = new ProcessMemInfo(st2.name, st2.pid, -1000, -1, "native", null);
            mi.pss = pss;
            mi.swapPss = swaptrackTmp[1];
            mi.memtrack = memtrackTmp[0];
            memInfos.add(mi);
        }
        long totalPss = 0L;
        long totalSwapPss = 0L;
        long totalMemtrack = 0L;
        int N2 = memInfos.size();
        for (int i = 0; i < N2; ++i) {
            ProcessMemInfo mi = memInfos.get(i);
            if (mi.pss == 0L) {
                mi.pss = Debug.getPss(mi.pid, swaptrackTmp, memtrackTmp);
                mi.swapPss = swaptrackTmp[1];
                mi.memtrack = memtrackTmp[0];
            }
            totalPss += mi.pss;
            totalSwapPss += mi.swapPss;
            totalMemtrack += mi.memtrack;
        }
        Collections.sort(memInfos, new Comparator<ProcessMemInfo>(){

            @Override
            public int compare(ProcessMemInfo lhs, ProcessMemInfo rhs) {
                if (lhs.oomAdj != rhs.oomAdj) {
                    return lhs.oomAdj < rhs.oomAdj ? -1 : 1;
                }
                if (lhs.pss != rhs.pss) {
                    return lhs.pss < rhs.pss ? 1 : -1;
                }
                return 0;
            }
        });
        StringBuilder tag = new StringBuilder(128);
        StringBuilder stack = new StringBuilder(128);
        tag.append("Low on memory -- ");
        ActivityManagerService.appendMemBucket(tag, totalPss, "total", false);
        ActivityManagerService.appendMemBucket(stack, totalPss, "total", true);
        StringBuilder fullNativeBuilder = new StringBuilder(1024);
        StringBuilder shortNativeBuilder = new StringBuilder(1024);
        StringBuilder fullJavaBuilder = new StringBuilder(1024);
        boolean firstLine = true;
        int lastOomAdj = Integer.MIN_VALUE;
        long extraNativeRam = 0L;
        long extraNativeMemtrack = 0L;
        long cachedPss = 0L;
        int N3 = memInfos.size();
        for (int i = 0; i < N3; ++i) {
            ProcessMemInfo mi = memInfos.get(i);
            if (mi.oomAdj >= 900) {
                cachedPss += mi.pss;
            }
            if (mi.oomAdj != -1000 && (mi.oomAdj < 500 || mi.oomAdj == 600 || mi.oomAdj == 700)) {
                if (lastOomAdj != mi.oomAdj) {
                    lastOomAdj = mi.oomAdj;
                    if (mi.oomAdj <= 0) {
                        tag.append(" / ");
                    }
                    if (mi.oomAdj >= 0) {
                        if (firstLine) {
                            stack.append(":");
                            firstLine = false;
                        }
                        stack.append("\n\t at ");
                    } else {
                        stack.append("$");
                    }
                } else {
                    tag.append(" ");
                    stack.append("$");
                }
                if (mi.oomAdj <= 0) {
                    ActivityManagerService.appendMemBucket(tag, mi.pss, mi.name, false);
                }
                ActivityManagerService.appendMemBucket(stack, mi.pss, mi.name, true);
                if (mi.oomAdj >= 0 && (i + 1 >= N3 || memInfos.get((int)(i + 1)).oomAdj != lastOomAdj)) {
                    stack.append("(");
                    for (int k = 0; k < DUMP_MEM_OOM_ADJ.length; ++k) {
                        if (DUMP_MEM_OOM_ADJ[k] != mi.oomAdj) continue;
                        stack.append(DUMP_MEM_OOM_LABEL[k]);
                        stack.append(":");
                        stack.append(DUMP_MEM_OOM_ADJ[k]);
                    }
                    stack.append(")");
                }
            }
            this.appendMemInfo(fullNativeBuilder, mi);
            if (mi.oomAdj == -1000) {
                if (mi.pss >= 512L) {
                    this.appendMemInfo(shortNativeBuilder, mi);
                    continue;
                }
                extraNativeRam += mi.pss;
                extraNativeMemtrack += mi.memtrack;
                continue;
            }
            if (extraNativeRam > 0L) {
                this.appendBasicMemEntry(shortNativeBuilder, -1000, -1, extraNativeRam, extraNativeMemtrack, "(Other native)");
                shortNativeBuilder.append('\n');
                extraNativeRam = 0L;
            }
            this.appendMemInfo(fullJavaBuilder, mi);
        }
        fullJavaBuilder.append("           ");
        ProcessList.appendRamKb(fullJavaBuilder, totalPss);
        fullJavaBuilder.append(": TOTAL");
        if (totalMemtrack > 0L) {
            fullJavaBuilder.append(" (");
            fullJavaBuilder.append(ActivityManagerService.stringifyKBSize(totalMemtrack));
            fullJavaBuilder.append(" memtrack)");
        }
        fullJavaBuilder.append("\n");
        MemInfoReader memInfo = new MemInfoReader();
        memInfo.readMemInfo();
        long[] infos = memInfo.getRawInfo();
        StringBuilder memInfoBuilder = new StringBuilder(1024);
        Debug.getMemInfo(infos);
        memInfoBuilder.append("  MemInfo: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[5])).append(" slab, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[4])).append(" shmem, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[12])).append(" vm alloc, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[13])).append(" page tables ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[14])).append(" kernel stack\n");
        memInfoBuilder.append("           ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[2])).append(" buffers, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[3])).append(" cached, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[11])).append(" mapped, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[1])).append(" free\n");
        if (infos[10] != 0L) {
            memInfoBuilder.append("  ZRAM: ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[10]));
            memInfoBuilder.append(" RAM, ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[8]));
            memInfoBuilder.append(" swap total, ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[9]));
            memInfoBuilder.append(" swap free\n");
        }
        if ((ksm = this.getKsmInfo())[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
            memInfoBuilder.append("  KSM: ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[1]));
            memInfoBuilder.append(" saved from shared ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[0]));
            memInfoBuilder.append("\n       ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[2]));
            memInfoBuilder.append(" unshared; ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[3]));
            memInfoBuilder.append(" volatile\n");
        }
        memInfoBuilder.append("  Free RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb()));
        memInfoBuilder.append("\n");
        memInfoBuilder.append("  Used RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(totalPss - cachedPss + memInfo.getKernelUsedSizeKb()));
        memInfoBuilder.append("\n");
        memInfoBuilder.append("  Lost RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(memInfo.getTotalSizeKb() - (totalPss - totalSwapPss) - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb() - memInfo.getZramTotalSizeKb()));
        memInfoBuilder.append("\n");
        Slog.i("ActivityManager", "Low on memory:");
        Slog.i("ActivityManager", shortNativeBuilder.toString());
        Slog.i("ActivityManager", fullJavaBuilder.toString());
        Slog.i("ActivityManager", memInfoBuilder.toString());
        StringBuilder dropBuilder = new StringBuilder(1024);
        dropBuilder.append("Low on memory:");
        dropBuilder.append((CharSequence)stack);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)fullNativeBuilder);
        dropBuilder.append((CharSequence)fullJavaBuilder);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)memInfoBuilder);
        dropBuilder.append('\n');
        StringWriter catSw = new StringWriter();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                FastPrintWriter catPw = new FastPrintWriter(catSw, false, 256);
                String[] emptyArgs = new String[]{};
                ((PrintWriter)catPw).println();
                this.dumpProcessesLocked(null, catPw, emptyArgs, 0, false, null, -1);
                ((PrintWriter)catPw).println();
                this.mServices.newServiceDumperLocked(null, catPw, emptyArgs, 0, false, null).dumpLocked();
                ((PrintWriter)catPw).println();
                this.mAtmInternal.dump("activities", null, catPw, emptyArgs, 0, false, false, null);
                ((PrintWriter)catPw).flush();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[4, 7] lbl253 : MonitorExitStatement: MONITOREXIT : var32_38
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        dropBuilder.append(catSw.toString());
        StatsLog.write(81);
        this.addErrorToDropBox("lowmem", null, "system_server", null, null, null, tag.toString(), dropBuilder.toString(), null, null);
        activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long now = SystemClock.uptimeMillis();
                if (this.mLastMemUsageReportTime < now) {
                    this.mLastMemUsageReportTime = now;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl272 : MonitorExitStatement: MONITOREXIT : var32_38
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeDyingProviderLocked(ProcessRecord proc, ContentProviderRecord cpr, boolean always) {
        boolean inLaunching = this.mLaunchingProviders.contains(cpr);
        if (!inLaunching || always) {
            ContentProviderRecord contentProviderRecord = cpr;
            synchronized (contentProviderRecord) {
                cpr.launchingApp = null;
                cpr.notifyAll();
            }
            this.mProviderMap.removeProviderByClass(cpr.name, UserHandle.getUserId(cpr.uid));
            String[] names = cpr.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                this.mProviderMap.removeProviderByName(names[j], UserHandle.getUserId(cpr.uid));
            }
        }
        for (int i = cpr.connections.size() - 1; i >= 0; --i) {
            ContentProviderConnection conn = cpr.connections.get(i);
            if (conn.waiting && inLaunching && !always) continue;
            ProcessRecord capp = conn.client;
            conn.dead = true;
            if (conn.stableCount > 0) {
                if (capp.isPersistent() || capp.thread == null || capp.pid == 0 || capp.pid == MY_PID) continue;
                capp.kill("depends on provider " + cpr.name.flattenToShortString() + " in dying proc " + (proc != null ? proc.processName : "??") + " (adj " + (proc != null ? Integer.valueOf(proc.setAdj) : "??") + ")", true);
                continue;
            }
            if (capp.thread == null || conn.provider.provider == null) continue;
            try {
                capp.thread.unstableProviderDied(conn.provider.provider.asBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            cpr.connections.remove(i);
            if (!conn.client.conProviders.remove(conn)) continue;
            this.stopAssociationLocked(capp.uid, capp.processName, cpr.uid, cpr.appInfo.longVersionCode, cpr.name, cpr.info.processName);
        }
        if (inLaunching && always) {
            this.mLaunchingProviders.remove(cpr);
        }
        return inLaunching;
    }

    @GuardedBy(value={"this"})
    final boolean cleanUpApplicationRecordLocked(final ProcessRecord app, boolean restarting, boolean allowRestart, int index, boolean replacingPid) {
        int i;
        if (index >= 0) {
            this.removeLruProcessLocked(app);
            ProcessList.remove(app.pid);
        }
        this.mProcessesToGc.remove(app);
        this.mPendingPssProcesses.remove(app);
        ProcessList.abortNextPssTime(app.procStateMemTracker);
        if (app.crashDialog != null && !app.forceCrashReport) {
            app.crashDialog.dismiss();
            app.crashDialog = null;
        }
        if (app.anrDialog != null) {
            app.anrDialog.dismiss();
            app.anrDialog = null;
        }
        if (app.waitDialog != null) {
            app.waitDialog.dismiss();
            app.waitDialog = null;
        }
        app.setCrashing(false);
        app.setNotResponding(false);
        app.resetPackageList(this.mProcessStats);
        app.unlinkDeathRecipient();
        app.makeInactive(this.mProcessStats);
        app.waitingToKill = null;
        app.forcingToImportant = null;
        this.updateProcessForegroundLocked(app, false, 0, false);
        app.setHasForegroundActivities(false);
        app.hasShownUi = false;
        app.treatLikeActivity = false;
        app.hasAboveClient = false;
        app.setHasClientActivities(false);
        this.mServices.killServicesLocked(app, allowRestart);
        boolean restart = false;
        for (i = app.pubProviders.size() - 1; i >= 0; --i) {
            boolean always;
            ContentProviderRecord cpr = app.pubProviders.valueAt(i);
            boolean inLaunching = this.removeDyingProviderLocked(app, cpr, always = app.bad || !allowRestart);
            if ((inLaunching || always) && cpr.hasConnectionOrHandle()) {
                restart = true;
            }
            cpr.provider = null;
            cpr.setProcess(null);
        }
        app.pubProviders.clear();
        if (this.cleanupAppInLaunchingProvidersLocked(app, false)) {
            restart = true;
        }
        if (!app.conProviders.isEmpty()) {
            for (i = app.conProviders.size() - 1; i >= 0; --i) {
                ContentProviderConnection conn = app.conProviders.get(i);
                conn.provider.connections.remove(conn);
                this.stopAssociationLocked(app.uid, app.processName, conn.provider.uid, conn.provider.appInfo.longVersionCode, conn.provider.name, conn.provider.info.processName);
            }
            app.conProviders.clear();
        }
        this.skipCurrentReceiverLocked(app);
        for (i = app.receivers.size() - 1; i >= 0; --i) {
            this.removeReceiverLocked(app.receivers.valueAt(i));
        }
        app.receivers.clear();
        BackupRecord backupTarget = this.mBackupTargets.get(app.userId);
        if (backupTarget != null && app.pid == backupTarget.app.pid) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                        bm.agentDisconnectedForUser(app.userId, app.info.packageName);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
        for (int i2 = this.mPendingProcessChanges.size() - 1; i2 >= 0; --i2) {
            ProcessChangeItem item = this.mPendingProcessChanges.get(i2);
            if (app.pid <= 0 || item.pid != app.pid) continue;
            this.mPendingProcessChanges.remove(i2);
            this.mAvailProcessChanges.add(item);
        }
        this.mUiHandler.obtainMessage(32, app.pid, app.info.uid, null).sendToTarget();
        if (restarting) {
            return false;
        }
        if (!app.isPersistent() || app.isolated) {
            if (!replacingPid) {
                this.mProcessList.removeProcessNameLocked(app.processName, app.uid, app);
            }
            this.mAtmInternal.clearHeavyWeightProcessIfEquals(app.getWindowProcessController());
        } else if (!app.removed && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            restart = true;
        }
        this.mProcessesOnHold.remove(app);
        this.mAtmInternal.onCleanUpApplicationRecord(app.getWindowProcessController());
        if (restart && !app.isolated) {
            if (index < 0) {
                ProcessList.remove(app.pid);
            }
            this.mProcessList.addProcessNameLocked(app);
            app.pendingStart = false;
            this.mProcessList.startProcessLocked(app, new HostingRecord("restart", app.processName));
            return true;
        }
        if (app.pid > 0 && app.pid != MY_PID) {
            this.mPidsSelfLocked.remove(app);
            this.mHandler.removeMessages(20, app);
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            app.setPid(0);
        }
        return false;
    }

    boolean checkAppInLaunchingProvidersLocked(ProcessRecord app) {
        for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            return true;
        }
        return false;
    }

    boolean cleanupAppInLaunchingProvidersLocked(ProcessRecord app, boolean alwaysBad) {
        boolean restart = false;
        for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            if (!alwaysBad && !app.bad && cpr.hasConnectionOrHandle()) {
                restart = true;
                continue;
            }
            this.removeDyingProviderLocked(app, cpr, true);
        }
        return restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ActivityManager.RunningServiceInfo> getServices(int maxNum, int flags) {
        List<ActivityManager.RunningServiceInfo> list;
        this.enforceNotIsolatedCaller("getServices");
        int callingUid = Binder.getCallingUid();
        boolean canInteractAcrossUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        boolean allowed = this.mAtmInternal.isGetTasksAllowed("getServices", Binder.getCallingPid(), callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                list = this.mServices.getRunningServiceInfoLocked(maxNum, flags, callingUid, allowed, canInteractAcrossUsers);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PendingIntent getRunningServiceControlPanel(ComponentName name) {
        PendingIntent pendingIntent;
        this.enforceNotIsolatedCaller("getRunningServiceControlPanel");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                pendingIntent = this.mServices.getRunningServiceControlPanelLocked(name);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return pendingIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ComponentName startService(IApplicationThread caller, Intent service, String resolvedType, boolean requireForeground, String callingPackage, int userId) throws TransactionTooLargeException {
        ComponentName componentName;
        this.enforceNotIsolatedCaller("startService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ComponentName res;
                ActivityManagerService.boostPriorityForLockedSection();
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long origId = Binder.clearCallingIdentity();
                try {
                    res = this.mServices.startServiceLocked(caller, service, resolvedType, callingPid, callingUid, requireForeground, callingPackage, userId);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
                componentName = res;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl23 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return componentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int stopService(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        int n;
        this.enforceNotIsolatedCaller("stopService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mServices.stopServiceLocked(caller, service, resolvedType, userId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinder peekService(Intent service, String resolvedType, String callingPackage) {
        IBinder iBinder;
        this.enforceNotIsolatedCaller("peekService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                iBinder = this.mServices.peekServiceLocked(service, resolvedType, callingPackage);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return iBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopServiceToken(ComponentName className, IBinder token, int startId) {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.mServices.stopServiceTokenLocked(className, token, startId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceForeground(ComponentName className, IBinder token, int id2, Notification notification, int flags, int foregroundServiceType) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mServices.setServiceForegroundLocked(className, token, id2, notification, flags, foregroundServiceType);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var7_7
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getForegroundServiceType(ComponentName className, IBinder token) {
        int n;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mServices.getForegroundServiceTypeLocked(className, token);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    @Override
    public int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        return this.mUserController.handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull ? 2 : 0, name, callerPackage);
    }

    boolean isSingleton(String componentProcessName, ApplicationInfo aInfo, String className, int flags) {
        boolean result = false;
        if (UserHandle.getAppId(aInfo.uid) >= 10000) {
            if ((flags & 0x40000000) != 0) {
                if (ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", aInfo.uid) != 0) {
                    ComponentName comp = new ComponentName(aInfo.packageName, className);
                    String msg = "Permission Denial: Component " + comp.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                result = true;
            }
        } else if ("system".equals(componentProcessName)) {
            result = true;
        } else if ((flags & 0x40000000) != 0) {
            result = UserHandle.isSameApp(aInfo.uid, 1001) || (aInfo.flags & 8) != 0;
        }
        return result;
    }

    boolean isValidSingletonCall(int callingUid, int componentUid) {
        int componentAppId = UserHandle.getAppId(componentUid);
        return UserHandle.isSameApp(callingUid, componentUid) || componentAppId == 1000 || componentAppId == 1001 || ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", componentUid) == 0;
    }

    @Override
    public int bindService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags, String callingPackage, int userId) throws TransactionTooLargeException {
        return this.bindIsolatedService(caller, token, service, resolvedType, connection, flags, null, callingPackage, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int bindIsolatedService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags, String instanceName, String callingPackage, int userId) throws TransactionTooLargeException {
        int n;
        this.enforceNotIsolatedCaller("bindService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        if (instanceName != null) {
            for (int i = 0; i < instanceName.length(); ++i) {
                char c = instanceName.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.') continue;
                throw new IllegalArgumentException("Illegal instanceName");
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                n = this.mServices.bindServiceLocked(caller, token, service, resolvedType, connection, flags, instanceName, callingPackage, userId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl19 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServiceGroup(IServiceConnection connection, int group, int importance) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mServices.updateServiceGroupLocked(connection, group, importance);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean unbindService(IServiceConnection connection) {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                bl = this.mServices.unbindServiceLocked(connection);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishService(IBinder token, Intent intent, IBinder service) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (!(token instanceof ServiceRecord)) {
                    throw new IllegalArgumentException("Invalid service token");
                }
                this.mServices.publishServiceLocked((ServiceRecord)token, intent, service);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFinished(IBinder token, Intent intent, boolean doRebind) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mServices.unbindFinishedLocked((ServiceRecord)token, intent, doRebind);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceDoneExecuting(IBinder token, int type, int startId, int res) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (!(token instanceof ServiceRecord)) {
                    Slog.e("ActivityManager", "serviceDoneExecuting: Invalid service token=" + token);
                    throw new IllegalArgumentException("Invalid service token");
                }
                this.mServices.serviceDoneExecutingLocked((ServiceRecord)token, type, startId, res);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean bindBackupAgent(String packageName, int backupMode, int targetUserId) {
        JobSchedulerInternal js;
        int newBackupUid;
        block15: {
            ProcessRecord proc;
            BackupRecord r;
            ApplicationInfo app;
            block14: {
                boolean bl;
                this.enforceCallingPermission("android.permission.CONFIRM_FULL_BACKUP", "bindBackupAgent");
                int instantiatedUserId = "android".equals(packageName) ? 0 : targetUserId;
                IPackageManager pm = AppGlobals.getPackageManager();
                app = null;
                try {
                    app = pm.getApplicationInfo(packageName, 1024, instantiatedUserId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (app == null) {
                    Slog.w("ActivityManager", "Unable to bind backup agent for " + packageName);
                    return false;
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        AppGlobals.getPackageManager().setPackageStoppedState(app.packageName, false, UserHandle.getUserId(app.uid));
                    }
                    catch (RemoteException remoteException) {
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w("ActivityManager", "Failed trying to unstop package " + app.packageName + ": " + e);
                    }
                    r = new BackupRecord(app, backupMode, targetUserId);
                    ComponentName hostingName = backupMode == 0 ? new ComponentName(app.packageName, app.backupAgentName) : new ComponentName("android", "FullBackupAgent");
                    proc = this.startProcessLocked(app.processName, app, false, 0, new HostingRecord("backup", hostingName), false, false, false);
                    if (proc != null) break block14;
                    Slog.e("ActivityManager", "Unable to start backup agent process " + r);
                    bl = false;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (UserHandle.isApp(app.uid) && backupMode == 1) {
                proc.inFullBackup = true;
            }
            r.app = proc;
            BackupRecord backupTarget = this.mBackupTargets.get(targetUserId);
            int oldBackupUid = backupTarget != null ? backupTarget.appInfo.uid : -1;
            newBackupUid = proc.inFullBackup ? r.appInfo.uid : -1;
            this.mBackupTargets.put(targetUserId, r);
            this.updateOomAdjLocked(proc, true, "updateOomAdj_meh");
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleCreateBackupAgent(app, this.compatibilityInfoForPackage(app), backupMode, targetUserId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            js = LocalServices.getService(JobSchedulerInternal.class);
            if (oldBackupUid == -1) break block15;
            js.removeBackingUpUid(oldBackupUid);
        }
        if (newBackupUid == -1) return true;
        js.addBackingUpUid(newBackupUid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPendingBackup(int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mBackupTargets.delete(userId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        JobSchedulerInternal js = LocalServices.getService(JobSchedulerInternal.class);
        js.clearAllBackingUpUids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void backupAgentCreated(String agentPackageName, IBinder agent, int userId) {
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "backupAgentCreated", null);
        var4_4 = this;
        synchronized (var4_4) {
            ActivityManagerService.boostPriorityForLockedSection();
            backupTarget = this.mBackupTargets.get(userId);
            v0 = backupAppName = backupTarget == null ? null : backupTarget.appInfo.packageName;
            if (agentPackageName.equals(backupAppName)) ** break block11
            Slog.e("ActivityManager", "Backup agent created for " + agentPackageName + " but not requested!");
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {}
            catch (Throwable var7_10) {
                // MONITOREXIT @DISABLED, blocks:[5, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var7_10;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        oldIdent = Binder.clearCallingIdentity();
        try {
            bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
            bm.agentConnectedForUser(userId, agentPackageName, agent);
        }
        catch (RemoteException bm) {
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception trying to deliver BackupAgent binding: ");
            e.printStackTrace();
        }
        finally {
            Binder.restoreCallingIdentity(oldIdent);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void unbindBackupAgent(ApplicationInfo appInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isInstantApp(ProcessRecord record, String callerPackage, int uid) {
        if (UserHandle.getAppId(uid) < 10000) {
            return false;
        }
        if (record != null) {
            return record.info.isInstantApp();
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            if (callerPackage == null) {
                String[] packageNames = pm.getPackagesForUid(uid);
                if (packageNames == null || packageNames.length == 0) {
                    throw new IllegalArgumentException("Unable to determine caller package name");
                }
                callerPackage = packageNames[0];
            }
            this.mAppOpsService.checkPackage(uid, callerPackage);
            return pm.isInstantApp(callerPackage, UserHandle.getUserId(uid));
        }
        catch (RemoteException e) {
            Slog.e("ActivityManager", "Error looking up if " + callerPackage + " is an instant app.", e);
            return true;
        }
    }

    boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mFgBroadcastQueue.isPendingBroadcastProcessLocked(pid) || this.mBgBroadcastQueue.isPendingBroadcastProcessLocked(pid) || this.mOffloadBroadcastQueue.isPendingBroadcastProcessLocked(pid);
    }

    void skipPendingBroadcastLocked(int pid) {
        Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipPendingBroadcastLocked(pid);
        }
    }

    boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            didSomething |= queue.sendPendingBroadcastsLocked(app);
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Intent registerReceiver(IApplicationThread caller, String callerPackage, IIntentReceiver receiver, IntentFilter filter, String permission, int userId, int flags) {
        this.enforceNotIsolatedCaller("registerReceiver");
        stickyIntents = null;
        callerApp = null;
        visibleToInstantApps = (flags & 1) != 0;
        var14_11 = this;
        synchronized (var14_11) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (caller != null) {
                    callerApp = this.getRecordForAppLocked(caller);
                    if (callerApp == null) {
                        throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when registering receiver " + receiver);
                    }
                    if (callerApp.info.uid != 1000 && !callerApp.pkgList.containsKey(callerPackage) && !"android".equals(callerPackage)) {
                        throw new SecurityException("Given caller package " + callerPackage + " is not running in process " + callerApp);
                    }
                    callingUid = callerApp.info.uid;
                    callingPid = callerApp.pid;
                } else {
                    callerPackage = null;
                    callingUid = Binder.getCallingUid();
                    callingPid = Binder.getCallingPid();
                }
                instantApp = this.isInstantApp(callerApp, callerPackage, callingUid);
                userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, true, 2, "registerReceiver", callerPackage);
                actions = filter.actionsIterator();
                if (actions == null) {
                    noAction = new ArrayList<E>(1);
                    noAction.add(null);
                    actions = noAction.iterator();
                }
                userIds = new int[]{-1, UserHandle.getUserId(callingUid)};
                while (actions.hasNext()) {
                    action = actions.next();
                    for (int id : userIds) {
                        stickies = this.mStickyBroadcasts.get(id);
                        if (stickies == null || (intents = stickies.get(action)) == null) continue;
                        if (stickyIntents == null) {
                            stickyIntents = new ArrayList<Intent>();
                        }
                        stickyIntents.addAll(intents);
                    }
                }
            }
            catch (Throwable var24_32) {
                // MONITOREXIT @DISABLED, blocks:[5, 7] lbl47 : MonitorExitStatement: MONITOREXIT : var14_11
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var24_32;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        allSticky = null;
        if (stickyIntents != null) {
            resolver = this.mContext.getContentResolver();
            N = stickyIntents.size();
            for (i = 0; i < N; ++i) {
                intent = (Intent)stickyIntents.get(i);
                if (instantApp && (intent.getFlags() & 0x200000) == 0 || filter.match(resolver, intent, true, "ActivityManager") < 0) continue;
                if (allSticky == null) {
                    allSticky = new ArrayList<Intent>();
                }
                allSticky.add(intent);
            }
        }
        v0 = sticky = allSticky != null ? (Intent)allSticky.get(0) : null;
        if (receiver == null) {
            return sticky;
        }
        var16_18 = this;
        synchronized (var16_18) {
            ActivityManagerService.boostPriorityForLockedSection();
            if (callerApp == null || callerApp.thread != null && callerApp.thread.asBinder() == caller.asBinder()) ** break block31
            v1 = null;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return v1;
        {
            block33: {
                block32: {
                    rl = this.mRegisteredReceivers.get(receiver.asBinder());
                    if (rl != null) ** GOTO lbl95
                    rl = new ReceiverList(this, callerApp, callingPid, callingUid, userId, receiver);
                    if (rl.app == null) break block32;
                    totalReceiversForApp = rl.app.receivers.size();
                    if (totalReceiversForApp >= 1000) {
                        throw new IllegalStateException("Too many receivers, total of " + totalReceiversForApp + ", registered for pid: " + rl.pid + ", callerPackage: " + callerPackage);
                    }
                    rl.app.receivers.add(rl);
                    ** GOTO lbl92
                }
                try {
                    receiver.asBinder().linkToDeath(rl, 0);
                }
                catch (RemoteException e) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6, 8] lbl90 : MonitorExitStatement: MONITOREXIT : var16_18
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return sticky;
                }
                rl.linkedToDeath = true;
lbl92:
                // 2 sources

                this.mRegisteredReceivers.put(receiver.asBinder(), rl);
                break block33;
lbl95:
                // 1 sources

                if (rl.uid != callingUid) {
                    throw new IllegalArgumentException("Receiver requested to register for uid " + callingUid + " was previously registered for uid " + rl.uid + " callerPackage is " + callerPackage);
                }
                if (rl.pid != callingPid) {
                    throw new IllegalArgumentException("Receiver requested to register for pid " + callingPid + " was previously registered for pid " + rl.pid + " callerPackage is " + callerPackage);
                }
                if (rl.userId != userId) {
                    throw new IllegalArgumentException("Receiver requested to register for user " + userId + " was previously registered for user " + rl.userId + " callerPackage is " + callerPackage);
                }
            }
            bf = new BroadcastFilter(filter, rl, callerPackage, permission, callingUid, userId, instantApp, visibleToInstantApps);
            if (rl.containsFilter(filter)) {
                Slog.w("ActivityManager", "Receiver with filter " + filter + " already registered for pid " + rl.pid + ", callerPackage is " + callerPackage);
            } else {
                rl.add(bf);
                if (!bf.debugCheck()) {
                    Slog.w("ActivityManager", "==> For Dynamic broadcast");
                }
                this.mReceiverResolver.addFilter(bf);
            }
            if (allSticky != null) {
                receivers = new ArrayList<BroadcastFilter>();
                receivers.add(bf);
                stickyCount = allSticky.size();
                for (i = 0; i < stickyCount; ++i) {
                    intent = (Intent)allSticky.get(i);
                    queue = this.broadcastQueueForIntent(intent);
                    r = new BroadcastRecord(queue, intent, null, null, -1, -1, false, null, null, -1, null, receivers, null, 0, null, null, false, true, true, -1, false, false);
                    queue.enqueueParallelBroadcastLocked(r);
                    queue.scheduleBroadcastsLocked();
                }
            }
            v2 = sticky;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return v2;
        {
            catch (Throwable var25_34) {
                // MONITOREXIT @DISABLED, blocks:[6, 9] lbl132 : MonitorExitStatement: MONITOREXIT : var16_18
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var25_34;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterReceiver(IIntentReceiver receiver) {
        long origId = Binder.clearCallingIdentity();
        try {
            boolean doTrim = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
                    if (rl != null) {
                        boolean doNext;
                        BroadcastRecord r = rl.curBroadcast;
                        if (r != null && r == r.queue.getMatchingOrderedReceiver(r) && (doNext = r.queue.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false))) {
                            doTrim = true;
                            r.queue.processNextBroadcast(false);
                        }
                        if (rl.app != null) {
                            rl.app.receivers.remove(rl);
                        }
                        this.removeReceiverLocked(rl);
                        if (rl.linkedToDeath) {
                            rl.linkedToDeath = false;
                            rl.receiver.asBinder().unlinkToDeath(rl, 0);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl25 : MonitorExitStatement: MONITOREXIT : var5_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            if (doTrim) {
                this.trimApplications("updateOomAdj_finishReceiver");
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void removeReceiverLocked(ReceiverList rl) {
        this.mRegisteredReceivers.remove(rl.receiver.asBinder());
        for (int i = rl.size() - 1; i >= 0; --i) {
            this.mReceiverResolver.removeFilter((BroadcastFilter)rl.get(i));
        }
    }

    private final void sendPackageBroadcastLocked(int cmd, String[] packages, int userId) {
        this.mProcessList.sendPackageBroadcastLocked(cmd, packages, userId);
    }

    private List<ResolveInfo> collectReceiverComponents(Intent intent, String resolvedType, int callingUid, int[] users) {
        int pmFlags = 0x10000400;
        List receivers = null;
        try {
            HashSet<ComponentName> singleUserReceivers = null;
            boolean scannedFirstReceivers = false;
            for (int user : users) {
                ComponentName cn;
                ResolveInfo ri;
                int i;
                if (callingUid == 2000 && this.mUserController.hasUserRestriction("no_debugging_features", user) && !this.isPermittedShellBroadcast(intent)) continue;
                List newReceivers = AppGlobals.getPackageManager().queryIntentReceivers(intent, resolvedType, pmFlags, user).getList();
                if (user != 0 && newReceivers != null) {
                    for (i = 0; i < newReceivers.size(); ++i) {
                        ri = (ResolveInfo)newReceivers.get(i);
                        if ((ri.activityInfo.flags & 0x20000000) == 0) continue;
                        newReceivers.remove(i);
                        --i;
                    }
                }
                if (newReceivers != null && newReceivers.size() == 0) {
                    newReceivers = null;
                }
                if (receivers == null) {
                    receivers = newReceivers;
                    continue;
                }
                if (newReceivers == null) continue;
                if (!scannedFirstReceivers) {
                    scannedFirstReceivers = true;
                    for (i = 0; i < receivers.size(); ++i) {
                        ri = (ResolveInfo)receivers.get(i);
                        if ((ri.activityInfo.flags & 0x40000000) == 0) continue;
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet();
                        }
                        singleUserReceivers.add(cn);
                    }
                }
                for (i = 0; i < newReceivers.size(); ++i) {
                    ri = (ResolveInfo)newReceivers.get(i);
                    if ((ri.activityInfo.flags & 0x40000000) != 0) {
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet<ComponentName>();
                        }
                        if (singleUserReceivers.contains(cn)) continue;
                        singleUserReceivers.add(cn);
                        receivers.add(ri);
                        continue;
                    }
                    receivers.add(ri);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return receivers;
    }

    private boolean isPermittedShellBroadcast(Intent intent) {
        return INTENT_REMOTE_BUGREPORT_FINISHED.equals(intent.getAction());
    }

    private void checkBroadcastFromSystem(Intent intent, ProcessRecord callerApp, String callerPackage, int callingUid, boolean isProtectedBroadcast, List receivers) {
        if ((intent.getFlags() & 0x400000) != 0) {
            return;
        }
        String action = intent.getAction();
        if (isProtectedBroadcast || "android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "com.android.intent.action.DISMISS_KEYBOARD_SHORTCUTS".equals(action) || "android.intent.action.MEDIA_BUTTON".equals(action) || "android.intent.action.MEDIA_SCANNER_SCAN_FILE".equals(action) || "com.android.intent.action.SHOW_KEYBOARD_SHORTCUTS".equals(action) || "android.intent.action.MASTER_CLEAR".equals(action) || "android.intent.action.FACTORY_RESET".equals(action) || "android.appwidget.action.APPWIDGET_CONFIGURE".equals(action) || "android.appwidget.action.APPWIDGET_UPDATE".equals(action) || "android.location.HIGH_POWER_REQUEST_CHANGE".equals(action) || "com.android.omadm.service.CONFIGURATION_UPDATE".equals(action) || "android.text.style.SUGGESTION_PICKED".equals(action) || "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION".equals(action) || "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION".equals(action)) {
            return;
        }
        if (intent.getPackage() != null || intent.getComponent() != null) {
            if (receivers == null || receivers.size() == 0) {
                return;
            }
            boolean allProtected = true;
            for (int i = receivers.size() - 1; i >= 0; --i) {
                Object target = receivers.get(i);
                if (target instanceof ResolveInfo) {
                    ResolveInfo ri = (ResolveInfo)target;
                    if (!ri.activityInfo.exported || ri.activityInfo.permission != null) continue;
                    allProtected = false;
                    break;
                }
                BroadcastFilter bf = (BroadcastFilter)target;
                if (bf.requiredPermission != null) continue;
                allProtected = false;
                break;
            }
            if (allProtected) {
                return;
            }
        }
        if (callerApp != null) {
            Log.wtf("ActivityManager", "Sending non-protected broadcast " + action + " from system " + callerApp.toShortString() + " pkg " + callerPackage, new Throwable());
        } else {
            Log.wtf("ActivityManager", "Sending non-protected broadcast " + action + " from system uid " + UserHandle.formatUid(callingUid) + " pkg " + callerPackage, new Throwable());
        }
    }

    @GuardedBy(value={"this"})
    final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean ordered, boolean sticky, int callingPid, int callingUid, int realCallingUid, int realCallingPid, int userId) {
        return this.broadcastIntentLocked(callerApp, callerPackage, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, appOp, bOptions, ordered, sticky, callingPid, callingUid, realCallingUid, realCallingPid, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @GuardedBy(value={"this"})
    final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean ordered, boolean sticky, int callingPid, int callingUid, int realCallingUid, int realCallingPid, int userId, boolean allowBackgroundActivityStarts) {
        int NR;
        boolean timeoutExempt;
        boolean isCallerSystem;
        boolean isProtectedBroadcast;
        BroadcastOptions brOptions;
        boolean callerInstantApp;
        block133: {
            UidRecord uidRec;
            int uid;
            String action;
            block134: {
                intent = new Intent(intent);
                callerInstantApp = this.isInstantApp(callerApp, callerPackage, callingUid);
                if (callerInstantApp) {
                    intent.setFlags(intent.getFlags() & 0xFFDFFFFF);
                }
                intent.addFlags(16);
                if (!this.mProcessesReady && (intent.getFlags() & 0x2000000) == 0) {
                    intent.addFlags(0x40000000);
                }
                if (resultTo != null && !ordered) {
                    Slog.w("ActivityManager", "Broadcast " + intent + " not ordered but result callback requested!");
                }
                if (!((userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, true, 0, "broadcast", callerPackage)) == -1 || this.mUserController.isUserOrItsParentRunning(userId) || callingUid == 1000 && (intent.getFlags() & 0x2000000) != 0 || "android.intent.action.ACTION_SHUTDOWN".equals(intent.getAction()))) {
                    Slog.w("ActivityManager", "Skipping broadcast of " + intent + ": user " + userId + " and its parent (if any) are stopped");
                    return -2;
                }
                action = intent.getAction();
                brOptions = null;
                if (bOptions != null) {
                    brOptions = new BroadcastOptions(bOptions);
                    if (brOptions.getTemporaryAppWhitelistDuration() > 0L && ActivityManagerService.checkComponentPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", realCallingPid, realCallingUid, -1, true) != 0) {
                        String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + "android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST";
                        Slog.w("ActivityManager", msg);
                        throw new SecurityException(msg);
                    }
                    if (brOptions.isDontSendToRestrictedApps() && !this.isUidActiveLocked(callingUid) && this.isBackgroundRestrictedNoCheck(callingUid, callerPackage)) {
                        Slog.i("ActivityManager", "Not sending broadcast " + action + " - app " + callerPackage + " has background restrictions");
                        return -96;
                    }
                    if (brOptions.allowsBackgroundActivityStarts()) {
                        if (ActivityManagerService.checkComponentPermission("android.permission.START_ACTIVITIES_FROM_BACKGROUND", realCallingPid, realCallingUid, -1, true) != 0) {
                            String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + "android.permission.START_ACTIVITIES_FROM_BACKGROUND";
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                        allowBackgroundActivityStarts = true;
                    }
                }
                try {
                    isProtectedBroadcast = AppGlobals.getPackageManager().isProtectedBroadcast(action);
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", "Remote exception", e);
                    return 0;
                }
                switch (UserHandle.getAppId(callingUid)) {
                    case 0: 
                    case 1000: 
                    case 1001: 
                    case 1002: 
                    case 1027: 
                    case 1068: 
                    case 1073: {
                        isCallerSystem = true;
                        break;
                    }
                    default: {
                        boolean bl = isCallerSystem = callerApp != null && callerApp.isPersistent();
                    }
                }
                if (!isCallerSystem) {
                    if (isProtectedBroadcast) {
                        String msg = "Permission Denial: not allowed to send broadcast " + action + " from pid=" + callingPid + ", uid=" + callingUid;
                        Slog.w("ActivityManager", msg);
                        throw new SecurityException(msg);
                    }
                    if ("android.appwidget.action.APPWIDGET_CONFIGURE".equals(action) || "android.appwidget.action.APPWIDGET_UPDATE".equals(action)) {
                        if (callerPackage == null) {
                            String msg = "Permission Denial: not allowed to send broadcast " + action + " from unknown caller.";
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                        if (intent.getComponent() != null) {
                            if (!intent.getComponent().getPackageName().equals(callerPackage)) {
                                String msg = "Permission Denial: not allowed to send broadcast " + action + " to " + intent.getComponent().getPackageName() + " from " + callerPackage;
                                Slog.w("ActivityManager", msg);
                                throw new SecurityException(msg);
                            }
                        } else {
                            intent.setPackage(callerPackage);
                        }
                    }
                }
                timeoutExempt = false;
                if (action == null) break block133;
                if (this.getBackgroundLaunchBroadcasts().contains(action)) {
                    intent.addFlags(0x1000000);
                }
                block30 : switch (action) {
                    case "android.intent.action.UID_REMOVED": 
                    case "android.intent.action.PACKAGE_REMOVED": 
                    case "android.intent.action.PACKAGE_CHANGED": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": 
                    case "android.intent.action.PACKAGES_SUSPENDED": 
                    case "android.intent.action.PACKAGES_UNSUSPENDED": {
                        if (ActivityManagerService.checkComponentPermission("android.permission.BROADCAST_PACKAGE_REMOVED", callingPid, callingUid, -1, true) != 0) {
                            String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + "android.permission.BROADCAST_PACKAGE_REMOVED";
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                        switch (action) {
                            case "android.intent.action.UID_REMOVED": {
                                int uid2 = this.getUidFromIntent(intent);
                                if (uid2 >= 0) {
                                    this.mBatteryStatsService.removeUid(uid2);
                                    this.mAppOpsService.uidRemoved(uid2);
                                    break;
                                }
                                break block134;
                            }
                            case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": {
                                String[] list = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                                if (list != null && list.length > 0) {
                                    for (int i = 0; i < list.length; ++i) {
                                        this.forceStopPackageLocked(list[i], -1, false, true, true, false, false, userId, "storage unmount");
                                    }
                                    this.mAtmInternal.cleanupRecentTasksForUser(-1);
                                    this.sendPackageBroadcastLocked(1, list, userId);
                                    break;
                                }
                                break block134;
                            }
                            case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": {
                                this.mAtmInternal.cleanupRecentTasksForUser(-1);
                                break;
                            }
                            case "android.intent.action.PACKAGE_REMOVED": 
                            case "android.intent.action.PACKAGE_CHANGED": {
                                String ssp;
                                Uri data = intent.getData();
                                if (data != null && (ssp = data.getSchemeSpecificPart()) != null) {
                                    boolean fullUninstall;
                                    boolean removed = "android.intent.action.PACKAGE_REMOVED".equals(action);
                                    boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                                    boolean bl = !intent.getBooleanExtra("android.intent.extra.DONT_KILL_APP", false);
                                    boolean bl2 = fullUninstall = removed && !replacing;
                                    if (removed) {
                                        if (bl) {
                                            this.forceStopPackageLocked(ssp, UserHandle.getAppId(intent.getIntExtra("android.intent.extra.UID", -1)), false, true, true, false, fullUninstall, userId, removed ? "pkg removed" : "pkg changed");
                                        }
                                        int cmd = bl ? 0 : 2;
                                        this.sendPackageBroadcastLocked(cmd, new String[]{ssp}, userId);
                                        if (!fullUninstall) break block30;
                                        this.mAppOpsService.packageRemoved(intent.getIntExtra("android.intent.extra.UID", -1), ssp);
                                        this.mUgmInternal.removeUriPermissionsForPackage(ssp, userId, true, false);
                                        this.mAtmInternal.removeRecentTasksByPackageName(ssp, userId);
                                        this.mServices.forceStopPackageLocked(ssp, userId);
                                        this.mAtmInternal.onPackageUninstalled(ssp);
                                        this.mBatteryStatsService.notePackageUninstalled(ssp);
                                        break;
                                    }
                                    if (bl) {
                                        int extraUid = intent.getIntExtra("android.intent.extra.UID", -1);
                                        this.mProcessList.killPackageProcessesLocked(ssp, UserHandle.getAppId(extraUid), userId, -10000, "change " + ssp);
                                    }
                                    this.cleanupDisabledPackageComponentsLocked(ssp, userId, intent.getStringArrayExtra("android.intent.extra.changed_component_name_list"));
                                    break;
                                }
                                break block134;
                            }
                            case "android.intent.action.PACKAGES_SUSPENDED": 
                            case "android.intent.action.PACKAGES_UNSUSPENDED": {
                                boolean suspended = "android.intent.action.PACKAGES_SUSPENDED".equals(intent.getAction());
                                String[] packageNames = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                                int n = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                                this.mAtmInternal.onPackagesSuspendedChanged(packageNames, suspended, n);
                            }
                        }
                        break;
                    }
                    case "android.intent.action.PACKAGE_REPLACED": {
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        ApplicationInfo aInfo = null;
                        try {
                            aInfo = AppGlobals.getPackageManager().getApplicationInfo(ssp, 1024, userId);
                        }
                        catch (RemoteException list) {
                            // empty catch block
                        }
                        if (aInfo == null) {
                            Slog.w("ActivityManager", "Dropping ACTION_PACKAGE_REPLACED for non-existent pkg: ssp=" + ssp + " data=" + data);
                            return 0;
                        }
                        this.updateAssociationForApp(aInfo);
                        this.mAtmInternal.onPackageReplaced(aInfo);
                        this.mServices.updateServiceApplicationInfoLocked(aInfo);
                        this.sendPackageBroadcastLocked(3, new String[]{ssp}, userId);
                        break;
                    }
                    case "android.intent.action.PACKAGE_ADDED": {
                        Parcelable ai22;
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                        this.mAtmInternal.onPackageAdded(ssp, replacing);
                        try {
                            ai22 = AppGlobals.getPackageManager().getApplicationInfo(ssp, 1024, 0);
                            this.mBatteryStatsService.notePackageInstalled(ssp, ai22 != null ? ((ApplicationInfo)ai22).longVersionCode : 0L);
                        }
                        catch (RemoteException ai22) {}
                        break;
                    }
                    case "android.intent.action.PACKAGE_DATA_CLEARED": {
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        this.mAtmInternal.onPackageDataCleared(ssp);
                        break;
                    }
                    case "android.intent.action.TIMEZONE_CHANGED": {
                        this.mHandler.sendEmptyMessage(13);
                        break;
                    }
                    case "android.intent.action.TIME_SET": {
                        BatteryStatsImpl stats;
                        int NO_EXTRA_VALUE_FOUND = -1;
                        int timeFormatPreferenceMsgValue = intent.getIntExtra("android.intent.extra.TIME_PREF_24_HOUR_FORMAT", -1);
                        if (timeFormatPreferenceMsgValue != -1) {
                            Message updateTimePreferenceMsg = this.mHandler.obtainMessage(41, timeFormatPreferenceMsgValue, 0);
                            this.mHandler.sendMessage(updateTimePreferenceMsg);
                        }
                        Parcelable ai22 = stats = this.mBatteryStatsService.getActiveStatistics();
                        synchronized (ai22) {
                            stats.noteCurrentTimeChangedLocked();
                            break;
                        }
                    }
                    case "android.intent.action.CLEAR_DNS_CACHE": {
                        this.mHandler.sendEmptyMessage(28);
                        break;
                    }
                    case "android.intent.action.PROXY_CHANGE": {
                        this.mHandler.sendMessage(this.mHandler.obtainMessage(29));
                        break;
                    }
                    case "android.hardware.action.NEW_PICTURE": 
                    case "android.hardware.action.NEW_VIDEO": {
                        intent.addFlags(0x40000000);
                        break;
                    }
                    case "android.security.action.TRUST_STORE_CHANGED": {
                        this.mHandler.sendEmptyMessage(63);
                        break;
                    }
                    case "com.android.launcher.action.INSTALL_SHORTCUT": {
                        Log.w("ActivityManager", "Broadcast " + action + " no longer supported. It will not be delivered.");
                        return 0;
                    }
                    case "android.intent.action.PRE_BOOT_COMPLETED": {
                        timeoutExempt = true;
                    }
                }
            }
            if (("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_REPLACED".equals(action)) && (uid = this.getUidFromIntent(intent)) != -1 && (uidRec = this.mProcessList.getUidRecordLocked(uid)) != null) {
                uidRec.updateHasInternetPermission();
            }
        }
        if (sticky) {
            int i;
            ArrayList<Intent> list;
            ArrayMap<String, ArrayList<Intent>> stickies;
            if (this.checkPermission("android.permission.BROADCAST_STICKY", callingPid, callingUid) != 0) {
                String msg = "Permission Denial: broadcastIntent() requesting a sticky broadcast from pid=" + callingPid + ", uid=" + callingUid + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            if (requiredPermissions != null && requiredPermissions.length > 0) {
                Slog.w("ActivityManager", "Can't broadcast sticky intent " + intent + " and enforce permissions " + Arrays.toString(requiredPermissions));
                return -1;
            }
            if (intent.getComponent() != null) {
                throw new SecurityException("Sticky broadcasts can't target a specific component");
            }
            if (userId != -1 && (stickies = this.mStickyBroadcasts.get(-1)) != null && (list = stickies.get(intent.getAction())) != null) {
                int N = list.size();
                for (int i2 = 0; i2 < N; ++i2) {
                    if (!intent.filterEquals(list.get(i2))) continue;
                    throw new IllegalArgumentException("Sticky broadcast " + intent + " for user " + userId + " conflicts with existing global broadcast");
                }
            }
            if ((stickies = this.mStickyBroadcasts.get(userId)) == null) {
                stickies = new ArrayMap();
                this.mStickyBroadcasts.put(userId, stickies);
            }
            if ((list = stickies.get(intent.getAction())) == null) {
                list = new ArrayList();
                stickies.put(intent.getAction(), list);
            }
            int stickiesCount = list.size();
            for (i = 0; i < stickiesCount; ++i) {
                if (!intent.filterEquals(list.get(i))) continue;
                list.set(i, new Intent(intent));
                break;
            }
            if (i >= stickiesCount) {
                list.add(new Intent(intent));
            }
        }
        int[] users = userId == -1 ? this.mUserController.getStartedUserArray() : new int[]{userId};
        List<ResolveInfo> receivers = null;
        List<BroadcastFilter> registeredReceivers = null;
        if ((intent.getFlags() & 0x40000000) == 0) {
            receivers = this.collectReceiverComponents(intent, resolvedType, callingUid, users);
        }
        if (intent.getComponent() == null) {
            if (userId == -1 && callingUid == 2000) {
                for (int i = 0; i < users.length; ++i) {
                    if (this.mUserController.hasUserRestriction("no_debugging_features", users[i])) continue;
                    List<BroadcastFilter> registeredReceiversForUser = this.mReceiverResolver.queryIntent(intent, resolvedType, false, users[i]);
                    if (registeredReceivers == null) {
                        registeredReceivers = registeredReceiversForUser;
                        continue;
                    }
                    if (registeredReceiversForUser == null) continue;
                    registeredReceivers.addAll(registeredReceiversForUser);
                }
            } else {
                registeredReceivers = this.mReceiverResolver.queryIntent(intent, resolvedType, false, userId);
            }
        }
        boolean replacePending = (intent.getFlags() & 0x20000000) != 0;
        int n = NR = registeredReceivers != null ? registeredReceivers.size() : 0;
        if (!ordered && NR > 0) {
            boolean replaced;
            if (isCallerSystem) {
                this.checkBroadcastFromSystem(intent, callerApp, callerPackage, callingUid, isProtectedBroadcast, registeredReceivers);
            }
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, callerInstantApp, resolvedType, requiredPermissions, appOp, brOptions, registeredReceivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId, allowBackgroundActivityStarts, timeoutExempt);
            boolean bl = replaced = replacePending && queue.replaceParallelBroadcastLocked(r) != null;
            if (!replaced) {
                queue.enqueueParallelBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
            registeredReceivers = null;
            NR = 0;
        }
        int ir = 0;
        if (receivers != null) {
            String[] skipPackages = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) || "android.intent.action.PACKAGE_RESTARTED".equals(intent.getAction()) || "android.intent.action.PACKAGE_DATA_CLEARED".equals(intent.getAction())) {
                String pkgName;
                Uri data = intent.getData();
                if (data != null && (pkgName = data.getSchemeSpecificPart()) != null) {
                    skipPackages = new String[]{pkgName};
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(intent.getAction())) {
                skipPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (skipPackages != null && skipPackages.length > 0) {
                for (Uri uri : skipPackages) {
                    if (uri == null) continue;
                    int NT = receivers.size();
                    for (int it = 0; it < NT; ++it) {
                        ResolveInfo curt = receivers.get(it);
                        if (!curt.activityInfo.packageName.equals(uri)) continue;
                        receivers.remove(it);
                        --it;
                        --NT;
                    }
                }
            }
            int NT = receivers != null ? receivers.size() : 0;
            int it = 0;
            ResolveInfo curt = null;
            Object var36_86 = null;
            while (it < NT && ir < NR) {
                void var36_87;
                if (curt == null) {
                    curt = receivers.get(it);
                }
                if (var36_87 == null) {
                    BroadcastFilter broadcastFilter = registeredReceivers.get(ir);
                }
                if (var36_87.getPriority() >= curt.priority) {
                    receivers.add(it, (ResolveInfo)var36_87);
                    ++ir;
                    Object var36_89 = null;
                    ++it;
                    ++NT;
                    continue;
                }
                ++it;
                curt = null;
            }
        }
        while (ir < NR) {
            if (receivers == null) {
                receivers = new ArrayList<ResolveInfo>();
            }
            receivers.add((ResolveInfo)((Object)registeredReceivers.get(ir)));
            ++ir;
        }
        if (isCallerSystem) {
            this.checkBroadcastFromSystem(intent, callerApp, callerPackage, callingUid, isProtectedBroadcast, receivers);
        }
        if (receivers != null && receivers.size() > 0 || resultTo != null) {
            BroadcastRecord oldRecord;
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, callerInstantApp, resolvedType, requiredPermissions, appOp, brOptions, receivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId, allowBackgroundActivityStarts, timeoutExempt);
            BroadcastRecord broadcastRecord = oldRecord = replacePending ? queue.replaceOrderedBroadcastLocked(r) : null;
            if (oldRecord != null) {
                if (oldRecord.resultTo != null) {
                    BroadcastQueue oldQueue = this.broadcastQueueForIntent(oldRecord.intent);
                    try {
                        oldQueue.performReceiveLocked(oldRecord.callerApp, oldRecord.resultTo, oldRecord.intent, 0, null, null, false, false, oldRecord.userId);
                    }
                    catch (RemoteException remoteException) {
                        Slog.w("ActivityManager", "Failure [" + queue.mQueueName + "] sending broadcast result of " + intent, remoteException);
                    }
                }
            } else {
                queue.enqueueOrderedBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
        } else if (intent.getComponent() == null && intent.getPackage() == null && (intent.getFlags() & 0x40000000) == 0) {
            this.addBroadcastStatLocked(intent.getAction(), callerPackage, 0, 0, 0L);
        }
        return 0;
    }

    private int getUidFromIntent(Intent intent) {
        if (intent == null) {
            return -1;
        }
        Bundle intentExtras = intent.getExtras();
        return intent.hasExtra("android.intent.extra.UID") ? intentExtras.getInt("android.intent.extra.UID") : -1;
    }

    final void rotateBroadcastStatsIfNeededLocked() {
        long now = SystemClock.elapsedRealtime();
        if (this.mCurBroadcastStats == null || this.mCurBroadcastStats.mStartRealtime + 86400000L < now) {
            this.mLastBroadcastStats = this.mCurBroadcastStats;
            if (this.mLastBroadcastStats != null) {
                this.mLastBroadcastStats.mEndRealtime = SystemClock.elapsedRealtime();
                this.mLastBroadcastStats.mEndUptime = SystemClock.uptimeMillis();
            }
            this.mCurBroadcastStats = new BroadcastStats();
        }
    }

    final void addBroadcastStatLocked(String action, String srcPackage, int receiveCount, int skipCount, long dispatchTime) {
        this.rotateBroadcastStatsIfNeededLocked();
        this.mCurBroadcastStats.addBroadcast(action, srcPackage, receiveCount, skipCount, dispatchTime);
    }

    final void addBackgroundCheckViolationLocked(String action, String targetPackage) {
        this.rotateBroadcastStatsIfNeededLocked();
        this.mCurBroadcastStats.addBackgroundCheckViolation(action, targetPackage);
    }

    final Intent verifyBroadcastLocked(Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        int flags = intent.getFlags();
        if (!this.mProcessesReady && (flags & 0x4000000) == 0 && (flags & 0x40000000) == 0) {
            Slog.e("ActivityManager", "Attempt to launch receivers of broadcast intent " + intent + " before boot completion");
            throw new IllegalStateException("Cannot broadcast before boot completed");
        }
        if ((flags & 0x2000000) != 0) {
            throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
        }
        if ((flags & 0x400000) != 0) {
            switch (Binder.getCallingUid()) {
                case 0: 
                case 2000: {
                    break;
                }
                default: {
                    Slog.w("ActivityManager", "Removing FLAG_RECEIVER_FROM_SHELL because caller is UID " + Binder.getCallingUid());
                    intent.removeFlags(0x400000);
                }
            }
        }
        return intent;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final int broadcastIntent(IApplicationThread caller, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean serialized, boolean sticky, int userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    int broadcastIntentInPackage(String packageName, int uid, int realCallingUid, int realCallingPid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String requiredPermission, Bundle bOptions, boolean serialized, boolean sticky, int userId, boolean allowBackgroundActivityStarts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbroadcastIntent(IApplicationThread caller, Intent intent, int userId) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 0, "removeStickyBroadcast", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.checkCallingPermission("android.permission.BROADCAST_STICKY") != 0) {
                    String msg = "Permission Denial: unbroadcastIntent() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BROADCAST_STICKY";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(userId);
                if (stickies != null) {
                    ArrayList<Intent> list = stickies.get(intent.getAction());
                    if (list != null) {
                        int N = list.size();
                        for (int i = 0; i < N; ++i) {
                            if (!intent.filterEquals(list.get(i))) continue;
                            list.remove(i);
                            break;
                        }
                        if (list.size() <= 0) {
                            stickies.remove(intent.getAction());
                        }
                    }
                    if (stickies.size() <= 0) {
                        this.mStickyBroadcasts.remove(userId);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl31 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void backgroundServicesFinishedLocked(int userId) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.backgroundServicesFinishedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void finishReceiver(IBinder who, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, int flags) {
        if (resultExtras != null && resultExtras.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            boolean doNext = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    BroadcastQueue queue = this.isOnOffloadQueue(flags) ? this.mOffloadBroadcastQueue : ((flags & 0x10000000) != 0 ? this.mFgBroadcastQueue : this.mBgBroadcastQueue);
                    BroadcastRecord r = queue.getMatchingOrderedReceiver(who);
                    if (r != null) {
                        doNext = r.queue.finishReceiverLocked(r, resultCode, resultData, resultExtras, resultAbort, true);
                    }
                    if (doNext) {
                        r.queue.processNextBroadcastLocked(false, true);
                    }
                    this.trimApplicationsLocked("updateOomAdj_finishReceiver");
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean startInstrumentation(ComponentName className, String profileFile, int flags, Bundle arguments, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection, int userId, String abiOverride) {
        boolean disableHiddenApiChecks;
        ApplicationInfo ai;
        InstrumentationInfo ii;
        int callingPid;
        int callingUid;
        block20: {
            block19: {
                block18: {
                    boolean bl;
                    this.enforceNotIsolatedCaller("startInstrumentation");
                    callingUid = Binder.getCallingUid();
                    callingPid = Binder.getCallingPid();
                    userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 2, "startInstrumentation", null);
                    if (arguments != null && arguments.hasFileDescriptors()) {
                        throw new IllegalArgumentException("File descriptors passed in Bundle");
                    }
                    ActivityManagerService activityManagerService = this;
                    // MONITORENTER : activityManagerService
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        ii = null;
                        ai = null;
                        try {
                            ii = this.mContext.getPackageManager().getInstrumentationInfo(className, 1024);
                            ai = AppGlobals.getPackageManager().getApplicationInfo(ii.targetPackage, 1024, userId);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        if (ii != null) break block18;
                        this.reportStartInstrumentationFailureLocked(watcher, className, "Unable to find instrumentation info for: " + className);
                        bl = false;
                        // MONITOREXIT : activityManagerService
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                if (ai != null) break block19;
                this.reportStartInstrumentationFailureLocked(watcher, className, "Unable to find instrumentation target package: " + ii.targetPackage);
                boolean bl = false;
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (ai.hasCode()) break block20;
            this.reportStartInstrumentationFailureLocked(watcher, className, "Instrumentation target has no code: " + ii.targetPackage);
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        int match = this.mContext.getPackageManager().checkSignatures(ii.targetPackage, ii.packageName);
        if (match < 0 && match != -1) {
            String msg = "Permission Denial: starting instrumentation " + className + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingPid() + " not allowed because package " + ii.packageName + " does not have a signature matching the target " + ii.targetPackage;
            this.reportStartInstrumentationFailureLocked(watcher, className, msg);
            throw new SecurityException(msg);
        }
        ActiveInstrumentation activeInstr = new ActiveInstrumentation(this);
        activeInstr.mClass = className;
        String defProcess = ai.processName;
        if (ii.targetProcesses == null) {
            activeInstr.mTargetProcesses = new String[]{ai.processName};
        } else if (ii.targetProcesses.equals("*")) {
            activeInstr.mTargetProcesses = new String[0];
        } else {
            activeInstr.mTargetProcesses = ii.targetProcesses.split(",");
            defProcess = activeInstr.mTargetProcesses[0];
        }
        activeInstr.mTargetInfo = ai;
        activeInstr.mProfileFile = profileFile;
        activeInstr.mArguments = arguments;
        activeInstr.mWatcher = watcher;
        activeInstr.mUiAutomationConnection = uiAutomationConnection;
        activeInstr.mResultClass = className;
        activeInstr.mHasBackgroundActivityStartsPermission = this.checkPermission("android.permission.START_ACTIVITIES_FROM_BACKGROUND", callingPid, callingUid) == 0;
        boolean bl = disableHiddenApiChecks = ai.usesNonSdkApi() || (flags & 1) != 0;
        if (disableHiddenApiChecks) {
            this.enforceCallingPermission("android.permission.DISABLE_HIDDEN_API_CHECKS", "disable hidden API checks");
        }
        boolean mountExtStorageFull = this.isCallerShell() && (flags & 2) != 0;
        long origId = Binder.clearCallingIdentity();
        this.forceStopPackageLocked(ii.targetPackage, -1, true, false, true, true, false, userId, "start instr");
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.reportEvent(ii.targetPackage, userId, 6);
        }
        ProcessRecord app = this.addAppLocked(ai, defProcess, false, disableHiddenApiChecks, mountExtStorageFull, abiOverride);
        app.setActiveInstrumentation(activeInstr);
        activeInstr.mFinished = false;
        activeInstr.mRunningProcesses.add(app);
        if (!this.mActiveInstrumentation.contains(activeInstr)) {
            this.mActiveInstrumentation.add(activeInstr);
        }
        Binder.restoreCallingIdentity(origId);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        return true;
    }

    private boolean isCallerShell() {
        int callingUid = Binder.getCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    private void reportStartInstrumentationFailureLocked(IInstrumentationWatcher watcher, ComponentName cn, String report) {
        Slog.w("ActivityManager", report);
        if (watcher != null) {
            Bundle results = new Bundle();
            results.putString("id", "ActivityManagerService");
            results.putString("Error", report);
            this.mInstrumentationReporter.reportStatus(watcher, cn, -1, results);
        }
    }

    void addInstrumentationResultsLocked(ProcessRecord app, Bundle results) {
        ActiveInstrumentation instr = app.getActiveInstrumentation();
        if (instr == null) {
            Slog.w("ActivityManager", "finishInstrumentation called on non-instrumented: " + app);
            return;
        }
        if (!instr.mFinished && results != null) {
            if (instr.mCurResults == null) {
                instr.mCurResults = new Bundle(results);
            } else {
                instr.mCurResults.putAll(results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addInstrumentationResults(IApplicationThread target, Bundle results) {
        ProcessRecord app;
        block5: {
            int userId = UserHandle.getCallingUserId();
            if (results != null && results.hasFileDescriptors()) {
                throw new IllegalArgumentException("File descriptors passed in Intent");
            }
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                app = this.getRecordForAppLocked(target);
                if (app != null) break block5;
                Slog.w("ActivityManager", "addInstrumentationResults: no app for " + target);
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        long origId = Binder.clearCallingIdentity();
        this.addInstrumentationResultsLocked(app, results);
        Binder.restoreCallingIdentity(origId);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    void finishInstrumentationLocked(ProcessRecord app, int resultCode, Bundle results) {
        ActiveInstrumentation instr = app.getActiveInstrumentation();
        if (instr == null) {
            Slog.w("ActivityManager", "finishInstrumentation called on non-instrumented: " + app);
            return;
        }
        if (!instr.mFinished) {
            if (instr.mWatcher != null) {
                Bundle finalResults = instr.mCurResults;
                if (finalResults != null) {
                    if (instr.mCurResults != null && results != null) {
                        finalResults.putAll(results);
                    }
                } else {
                    finalResults = results;
                }
                this.mInstrumentationReporter.reportFinished(instr.mWatcher, instr.mClass, resultCode, finalResults);
            }
            if (instr.mUiAutomationConnection != null) {
                this.mAppOpsService.setAppOpsServiceDelegate(null);
                this.getPackageManagerInternalLocked().setCheckPermissionDelegate(null);
                this.mHandler.obtainMessage(56, instr.mUiAutomationConnection).sendToTarget();
            }
            instr.mFinished = true;
        }
        instr.removeProcess(app);
        app.setActiveInstrumentation(null);
        this.forceStopPackageLocked(app.info.packageName, -1, false, false, true, true, false, app.userId, "finished inst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void finishInstrumentation(IApplicationThread target, int resultCode, Bundle results) {
        ProcessRecord app;
        block5: {
            int userId = UserHandle.getCallingUserId();
            if (results != null && results.hasFileDescriptors()) {
                throw new IllegalArgumentException("File descriptors passed in Intent");
            }
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                app = this.getRecordForAppLocked(target);
                if (app != null) break block5;
                Slog.w("ActivityManager", "finishInstrumentation: no app for " + target);
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        long origId = Binder.clearCallingIdentity();
        this.finishInstrumentationLocked(app, resultCode, results);
        Binder.restoreCallingIdentity(origId);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public ActivityManager.StackInfo getFocusedStackInfo() throws RemoteException {
        return this.mActivityTaskManager.getFocusedStackInfo();
    }

    @Override
    public Configuration getConfiguration() {
        return this.mActivityTaskManager.getConfiguration();
    }

    @Override
    public void suppressResizeConfigChanges(boolean suppress) throws RemoteException {
        this.mActivityTaskManager.suppressResizeConfigChanges(suppress);
    }

    @Override
    public void updatePersistentConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updatePersistentConfiguration()");
        this.enforceWriteSettingsPermission("updatePersistentConfiguration()");
        if (values == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        int userId = UserHandle.getCallingUserId();
        this.mActivityTaskManager.updatePersistentConfiguration(values, userId);
    }

    private void enforceWriteSettingsPermission(String func) {
        int uid = Binder.getCallingUid();
        if (uid == 0) {
            return;
        }
        if (Settings.checkAndNoteWriteSettingsOperation(this.mContext, uid, Settings.getPackageNameForUid(this.mContext, uid), false)) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + uid + " requires " + "android.permission.WRITE_SETTINGS";
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    @Override
    public boolean updateConfiguration(Configuration values) {
        return this.mActivityTaskManager.updateConfiguration(values);
    }

    @Override
    public int getLaunchedFromUid(IBinder activityToken) {
        return this.mActivityTaskManager.getLaunchedFromUid(activityToken);
    }

    @Override
    public String getLaunchedFromPackage(IBinder activityToken) {
        return this.mActivityTaskManager.getLaunchedFromPackage(activityToken);
    }

    boolean isReceivingBroadcastLocked(ProcessRecord app, ArraySet<BroadcastQueue> receivingQueues) {
        int N = app.curReceivers.size();
        if (N > 0) {
            for (int i = 0; i < N; ++i) {
                receivingQueues.add(app.curReceivers.valueAt((int)i).queue);
            }
            return true;
        }
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            BroadcastRecord r = queue.mPendingBroadcast;
            if (r == null || r.curApp != app) continue;
            receivingQueues.add(queue);
        }
        return !receivingQueues.isEmpty();
    }

    Association startAssociationLocked(int sourceUid, String sourceProcess, int sourceState, int targetUid, long targetVersionCode, ComponentName targetComponent, String targetProcess) {
        Association ass;
        ArrayMap<String, Association> sourceProcesses;
        SparseArray<ArrayMap<String, Association>> sourceUids;
        if (!this.mTrackingAssociations) {
            return null;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            components = new ArrayMap();
            this.mAssociations.put(targetUid, components);
        }
        if ((sourceUids = components.get(targetComponent)) == null) {
            sourceUids = new SparseArray();
            components.put(targetComponent, sourceUids);
        }
        if ((sourceProcesses = sourceUids.get(sourceUid)) == null) {
            sourceProcesses = new ArrayMap();
            sourceUids.put(sourceUid, sourceProcesses);
        }
        if ((ass = sourceProcesses.get(sourceProcess)) == null) {
            ass = new Association(sourceUid, sourceProcess, targetUid, targetComponent, targetProcess);
            sourceProcesses.put(sourceProcess, ass);
        }
        ++ass.mCount;
        ++ass.mNesting;
        if (ass.mNesting == 1) {
            ass.mStartTime = ass.mLastStateUptime = SystemClock.uptimeMillis();
            ass.mLastState = sourceState;
        }
        return ass;
    }

    void stopAssociationLocked(int sourceUid, String sourceProcess, int targetUid, long targetVersionCode, ComponentName targetComponent, String targetProcess) {
        if (!this.mTrackingAssociations) {
            return;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            return;
        }
        SparseArray<ArrayMap<String, Association>> sourceUids = components.get(targetComponent);
        if (sourceUids == null) {
            return;
        }
        ArrayMap<String, Association> sourceProcesses = sourceUids.get(sourceUid);
        if (sourceProcesses == null) {
            return;
        }
        Association ass = sourceProcesses.get(sourceProcess);
        if (ass == null || ass.mNesting <= 0) {
            return;
        }
        --ass.mNesting;
        if (ass.mNesting == 0) {
            long uptime = SystemClock.uptimeMillis();
            ass.mTime += uptime - ass.mStartTime;
            int n = ass.mLastState - 0;
            ass.mStateTimes[n] = ass.mStateTimes[n] + (uptime - ass.mLastStateUptime);
            ass.mLastState = 23;
        }
    }

    void noteUidProcessState(int uid, int state) {
        this.mBatteryStatsService.noteUidProcessState(uid, state);
        this.mAppOpsService.updateUidProcState(uid, state);
        if (this.mTrackingAssociations) {
            int N1 = this.mAssociations.size();
            for (int i1 = 0; i1 < N1; ++i1) {
                ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> targetComponents = this.mAssociations.valueAt(i1);
                int N2 = targetComponents.size();
                for (int i2 = 0; i2 < N2; ++i2) {
                    SparseArray<ArrayMap<String, Association>> sourceUids = targetComponents.valueAt(i2);
                    ArrayMap<String, Association> sourceProcesses = sourceUids.get(uid);
                    if (sourceProcesses == null) continue;
                    int N4 = sourceProcesses.size();
                    for (int i4 = 0; i4 < N4; ++i4) {
                        Association ass = sourceProcesses.valueAt(i4);
                        if (ass.mNesting < 1) continue;
                        long uptime = SystemClock.uptimeMillis();
                        int n = ass.mLastState - 0;
                        ass.mStateTimes[n] = ass.mStateTimes[n] + (uptime - ass.mLastStateUptime);
                        ass.mLastState = state;
                        ass.mLastStateUptime = uptime;
                    }
                }
            }
        }
    }

    void recordPssSampleLocked(ProcessRecord proc, int procState, long pss, long uss, long swapPss, long rss, int statType, long pssDuration, long now) {
        EventLogTags.writeAmPss(proc.pid, proc.uid, proc.processName, pss * 1024L, uss * 1024L, swapPss * 1024L, rss * 1024L, statType, procState, pssDuration);
        proc.lastPssTime = now;
        proc.baseProcessTracker.addPss(pss, uss, rss, true, statType, pssDuration, proc.pkgList.mPkgList);
        for (int ipkg = proc.pkgList.mPkgList.size() - 1; ipkg >= 0; --ipkg) {
            ProcessStats.ProcessStateHolder holder = proc.pkgList.valueAt(ipkg);
            StatsLog.write(18, proc.info.uid, holder.state.getName(), holder.state.getPackage(), pss, uss, rss, statType, pssDuration, holder.appVersion);
        }
        if (proc.initialIdlePss == 0L) {
            proc.initialIdlePss = pss;
        }
        proc.lastPss = pss;
        proc.lastSwapPss = swapPss;
        if (procState >= 15) {
            proc.lastCachedPss = pss;
            proc.lastCachedSwapPss = swapPss;
        }
        SparseArray<Pair<Long, String>> watchUids = this.mMemWatchProcesses.getMap().get(proc.processName);
        Long check = null;
        if (watchUids != null) {
            Pair<Long, String> val = watchUids.get(proc.uid);
            if (val == null) {
                val = watchUids.get(0);
            }
            if (val != null) {
                check = (Long)val.first;
            }
        }
        if (check != null && pss * 1024L >= check && proc.thread != null && this.mMemWatchDumpProcName == null) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (proc.info.flags & 2) != 0) {
                isDebuggable = true;
            }
            if (isDebuggable) {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + "; reporting");
                this.startHeapDumpLocked(proc, false);
            } else {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + ", but debugging not enabled");
            }
        }
    }

    private void startHeapDumpLocked(ProcessRecord proc, boolean isUserInitiated) {
        File heapdumpFile = DumpHeapProvider.getJavaFile();
        this.mMemWatchDumpProcName = proc.processName;
        this.mMemWatchDumpFile = heapdumpFile.toString();
        this.mMemWatchDumpPid = proc.pid;
        this.mMemWatchDumpUid = proc.uid;
        this.mMemWatchIsUserInitiated = isUserInitiated;
        BackgroundThread.getHandler().post(new RecordPssRunnable(this, proc, heapdumpFile));
    }

    boolean requestPssLocked(ProcessRecord proc, int procState) {
        if (this.mPendingPssProcesses.contains(proc)) {
            return false;
        }
        if (this.mPendingPssProcesses.size() == 0) {
            long deferral = this.mPssDeferralTime > 0L && this.mActivityStartingNesting.get() > 0 ? this.mPssDeferralTime : 0L;
            this.mBgHandler.sendEmptyMessageDelayed(1, deferral);
        }
        proc.pssProcState = procState;
        proc.pssStatType = 0;
        this.mPendingPssProcesses.add(proc);
        return true;
    }

    private void deferPssIfNeededLocked() {
        if (this.mPendingPssProcesses.size() > 0) {
            this.mBgHandler.removeMessages(1);
            this.mBgHandler.sendEmptyMessageDelayed(1, this.mPssDeferralTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferPssForActivityStart() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mPssDeferralTime > 0L) {
                    this.deferPssIfNeededLocked();
                    this.mActivityStartingNesting.getAndIncrement();
                    this.mBgHandler.sendEmptyMessageDelayed(3, this.mPssDeferralTime);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void requestPssAllProcsLocked(long now, boolean always, boolean memLowered) {
        int i;
        if (!always && now < this.mLastFullPssTime + (memLowered ? this.mConstants.FULL_PSS_LOWERED_INTERVAL : this.mConstants.FULL_PSS_MIN_INTERVAL)) {
            return;
        }
        this.mLastFullPssTime = now;
        this.mFullPssPending = true;
        for (i = this.mPendingPssProcesses.size() - 1; i >= 0; --i) {
            ProcessList.abortNextPssTime(this.mPendingPssProcesses.get((int)i).procStateMemTracker);
        }
        this.mPendingPssProcesses.ensureCapacity(this.mProcessList.getLruSizeLocked());
        this.mPendingPssProcesses.clear();
        for (i = this.mProcessList.getLruSizeLocked() - 1; i >= 0; --i) {
            ProcessRecord app = this.mProcessList.mLruProcesses.get(i);
            if (app.thread == null || app.getCurProcState() == 21 || !memLowered && (!always || now <= app.lastStateTime + 1000L) && now <= app.lastStateTime + 1200000L) continue;
            app.pssProcState = app.setProcState;
            app.pssStatType = always ? 2 : 1;
            app.nextPssTime = ProcessList.computeNextPssTime(app.getCurProcState(), app.procStateMemTracker, this.mTestPssMode, this.mAtmInternal.isSleeping(), now);
            this.mPendingPssProcesses.add(app);
        }
        if (!this.mBgHandler.hasMessages(1)) {
            this.mBgHandler.sendEmptyMessage(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestPssMode(boolean enabled) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mTestPssMode = enabled;
                if (enabled) {
                    this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, true);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    final void performAppGcLocked(ProcessRecord app) {
        try {
            app.lastRequestedGc = SystemClock.uptimeMillis();
            if (app.thread != null) {
                if (app.reportLowMemory) {
                    app.reportLowMemory = false;
                    app.thread.scheduleLowMemory();
                } else {
                    app.thread.processInBackground();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean canGcNowLocked() {
        for (BroadcastQueue q : this.mBroadcastQueues) {
            if (q.mParallelBroadcasts.isEmpty() && q.mDispatcher.isEmpty()) continue;
            return false;
        }
        return this.mAtmInternal.canGcNow();
    }

    final void performAppGcsLocked() {
        int N = this.mProcessesToGc.size();
        if (N <= 0) {
            return;
        }
        if (this.canGcNowLocked()) {
            while (this.mProcessesToGc.size() > 0) {
                ProcessRecord proc = this.mProcessesToGc.remove(0);
                if (proc.getCurRawAdj() <= 200 && !proc.reportLowMemory) continue;
                if (proc.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL <= SystemClock.uptimeMillis()) {
                    this.performAppGcLocked(proc);
                    this.scheduleAppGcsLocked();
                    return;
                }
                this.addProcessToGcListLocked(proc);
                break;
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void performAppGcsIfAppropriateLocked() {
        if (this.canGcNowLocked()) {
            this.performAppGcsLocked();
            return;
        }
        this.scheduleAppGcsLocked();
    }

    final void scheduleAppGcsLocked() {
        this.mHandler.removeMessages(5);
        if (this.mProcessesToGc.size() > 0) {
            ProcessRecord proc = this.mProcessesToGc.get(0);
            Message msg = this.mHandler.obtainMessage(5);
            long when = proc.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL;
            long now = SystemClock.uptimeMillis();
            if (when < now + this.mConstants.GC_TIMEOUT) {
                when = now + this.mConstants.GC_TIMEOUT;
            }
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    final void addProcessToGcListLocked(ProcessRecord proc) {
        boolean added = false;
        for (int i = this.mProcessesToGc.size() - 1; i >= 0; --i) {
            if (this.mProcessesToGc.get((int)i).lastRequestedGc >= proc.lastRequestedGc) continue;
            added = true;
            this.mProcessesToGc.add(i + 1, proc);
            break;
        }
        if (!added) {
            this.mProcessesToGc.add(0, proc);
        }
    }

    final void scheduleAppGcLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        if (app.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL > now) {
            return;
        }
        if (!this.mProcessesToGc.contains(app)) {
            this.addProcessToGcListLocked(app);
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkExcessivePowerUsageLocked() {
        this.updateCpuStatsNow();
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        boolean doCpuKills = true;
        if (this.mLastPowerCheckUptime == 0L) {
            doCpuKills = false;
        }
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - this.mLastPowerCheckUptime;
        this.mLastPowerCheckUptime = curUptime;
        int i = this.mProcessList.mLruProcesses.size();
        while (i > 0) {
            long checkDur;
            int cpuLimit;
            ProcessRecord app = this.mProcessList.mLruProcesses.get(--i);
            if (app.setProcState < 15 || app.lastCpuTime <= 0L) continue;
            long cputimeUsed = app.curCpuTime - app.lastCpuTime;
            if (doCpuKills && uptimeSince > 0L && cputimeUsed * 100L / uptimeSince >= (long)(cpuLimit = (checkDur = curUptime - app.getWhenUnimportant()) <= this.mConstants.POWER_CHECK_INTERVAL ? this.mConstants.POWER_CHECK_MAX_CPU_1 : (checkDur <= this.mConstants.POWER_CHECK_INTERVAL * 2L || app.setProcState <= 15 ? this.mConstants.POWER_CHECK_MAX_CPU_2 : (checkDur <= this.mConstants.POWER_CHECK_INTERVAL * 3L ? this.mConstants.POWER_CHECK_MAX_CPU_3 : this.mConstants.POWER_CHECK_MAX_CPU_4)))) {
                BatteryStatsImpl batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveCpuLocked(app.info.uid, app.processName, uptimeSince, cputimeUsed);
                }
                app.kill("excessive cpu " + cputimeUsed + " during " + uptimeSince + " dur=" + checkDur + " limit=" + cpuLimit, true);
                app.baseProcessTracker.reportExcessiveCpu(app.pkgList.mPkgList);
                for (int ipkg = app.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                    ProcessStats.ProcessStateHolder holder = app.pkgList.valueAt(ipkg);
                    StatsLog.write(16, app.info.uid, holder.state.getName(), holder.state.getPackage(), holder.appVersion);
                }
            }
            app.lastCpuTime = app.curCpuTime;
        }
    }

    private boolean isEphemeralLocked(int uid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        if (packages == null || packages.length != 1) {
            return false;
        }
        return this.getPackageManagerInternalLocked().isPackageEphemeral(UserHandle.getUserId(uid), packages[0]);
    }

    @VisibleForTesting
    final void enqueueUidChangeLocked(UidRecord uidRec, int uid, int change) {
        UidRecord.ChangeItem pendingChange;
        if (uidRec == null || uidRec.pendingChange == null) {
            int NA;
            if (this.mPendingUidChanges.size() == 0) {
                this.mUiHandler.obtainMessage(53).sendToTarget();
            }
            pendingChange = (NA = this.mAvailUidChanges.size()) > 0 ? this.mAvailUidChanges.remove(NA - 1) : new UidRecord.ChangeItem();
            if (uidRec != null) {
                uidRec.pendingChange = pendingChange;
                if ((change & 1) != 0 && !uidRec.idle) {
                    change |= 2;
                }
            } else if (uid < 0) {
                throw new IllegalArgumentException("No UidRecord or uid");
            }
            pendingChange.uidRecord = uidRec;
            pendingChange.uid = uidRec != null ? uidRec.uid : uid;
            this.mPendingUidChanges.add(pendingChange);
        } else {
            pendingChange = uidRec.pendingChange;
            if ((change & 6) == 0) {
                change |= pendingChange.change & 6;
            }
            if ((change & 0x18) == 0) {
                change |= pendingChange.change & 0x18;
            }
            if ((change & 1) != 0) {
                change &= 0xFFFFFFF3;
                if (!uidRec.idle) {
                    change |= 2;
                }
            }
        }
        pendingChange.change = change;
        pendingChange.processState = uidRec != null ? uidRec.setProcState : 21;
        pendingChange.ephemeral = uidRec != null ? uidRec.ephemeral : this.isEphemeralLocked(uid);
        long l = pendingChange.procStateSeq = uidRec != null ? uidRec.curProcStateSeq : 0L;
        if (uidRec != null) {
            uidRec.lastReportedChange = change;
            uidRec.updateLastDispatchedProcStateSeq(change);
        }
        if (this.mLocalPowerManager != null) {
            if ((change & 4) != 0) {
                this.mLocalPowerManager.uidActive(pendingChange.uid);
            }
            if ((change & 2) != 0) {
                this.mLocalPowerManager.uidIdle(pendingChange.uid);
            }
            if ((change & 1) != 0) {
                this.mLocalPowerManager.uidGone(pendingChange.uid);
            } else {
                this.mLocalPowerManager.updateUidProcState(pendingChange.uid, pendingChange.processState);
            }
        }
    }

    private void maybeUpdateProviderUsageStatsLocked(ProcessRecord app, String providerPkgName, String authority) {
        if (app == null) {
            return;
        }
        if (app.getCurProcState() <= 7) {
            UserState userState = this.mUserController.getStartedUserState(app.userId);
            if (userState == null) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            Long lastReported = userState.mProviderLastReportedFg.get(authority);
            if (lastReported == null || lastReported < now - 60000L) {
                if (this.mSystemReady) {
                    this.mUsageStatsService.reportContentProviderUsage(authority, providerPkgName, app.userId);
                }
                userState.mProviderLastReportedFg.put(authority, now);
            }
        }
    }

    final void setProcessTrackerStateLocked(ProcessRecord proc, int memFactor, long now) {
        if (proc.thread != null && proc.baseProcessTracker != null) {
            proc.baseProcessTracker.setState(proc.getReportedProcState(), memFactor, now, proc.pkgList.mPkgList);
        }
    }

    @GuardedBy(value={"this"})
    final void updateProcessForegroundLocked(ProcessRecord proc, boolean isForeground, int fgServiceTypes, boolean oomAdj) {
        if (isForeground != proc.hasForegroundServices() || proc.getForegroundServiceTypes() != fgServiceTypes) {
            proc.setHasForegroundServices(isForeground, fgServiceTypes);
            ArrayList<ProcessRecord> curProcs = this.mForegroundPackages.get(proc.info.packageName, proc.info.uid);
            if (isForeground) {
                if (curProcs == null) {
                    curProcs = new ArrayList();
                    this.mForegroundPackages.put(proc.info.packageName, proc.info.uid, curProcs);
                }
                if (!curProcs.contains(proc)) {
                    curProcs.add(proc);
                    this.mBatteryStatsService.noteEvent(32770, proc.info.packageName, proc.info.uid);
                }
            } else if (curProcs != null && curProcs.remove(proc)) {
                this.mBatteryStatsService.noteEvent(16386, proc.info.packageName, proc.info.uid);
                if (curProcs.size() <= 0) {
                    this.mForegroundPackages.remove(proc.info.packageName, proc.info.uid);
                }
            }
            proc.setReportedForegroundServiceTypes(fgServiceTypes);
            ProcessChangeItem item = this.enqueueProcessChangeItemLocked(proc.pid, proc.info.uid);
            item.changes = 2;
            item.foregroundServiceTypes = fgServiceTypes;
            if (oomAdj) {
                this.updateOomAdjLocked("updateOomAdj_uiVisibility");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessRecord getTopAppLocked() {
        int uid;
        String pkg;
        ProcessRecord r;
        WindowProcessController wpc = this.mAtmInternal != null ? this.mAtmInternal.getTopApp() : null;
        ProcessRecord processRecord = r = wpc != null ? (ProcessRecord)wpc.mOwner : null;
        if (r != null) {
            pkg = r.processName;
            uid = r.info.uid;
        } else {
            pkg = null;
            uid = -1;
        }
        if (uid != this.mCurResumedUid || pkg != this.mCurResumedPackage && (pkg == null || !pkg.equals(this.mCurResumedPackage))) {
            long identity = Binder.clearCallingIdentity();
            try {
                if (this.mCurResumedPackage != null) {
                    this.mBatteryStatsService.noteEvent(16387, this.mCurResumedPackage, this.mCurResumedUid);
                }
                this.mCurResumedPackage = pkg;
                this.mCurResumedUid = uid;
                if (this.mCurResumedPackage != null) {
                    this.mBatteryStatsService.noteEvent(32771, this.mCurResumedPackage, this.mCurResumedUid);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return r;
    }

    @GuardedBy(value={"this"})
    final boolean updateOomAdjLocked(ProcessRecord app, boolean oomAdjAll, String oomAdjReason) {
        return this.mOomAdjuster.updateOomAdjLocked(app, oomAdjAll, oomAdjReason);
    }

    @GuardedBy(value={"this"})
    final boolean updateLowMemStateLocked(int numCached, int numEmpty, int numTrimming) {
        int numCachedAndEmpty;
        int N = this.mProcessList.getLruSizeLocked();
        long now = SystemClock.uptimeMillis();
        int memFactor = this.mLowMemDetector != null && this.mLowMemDetector.isAvailable() ? this.mLowMemDetector.getMemFactor() : (numCached <= this.mConstants.CUR_TRIM_CACHED_PROCESSES && numEmpty <= this.mConstants.CUR_TRIM_EMPTY_PROCESSES ? ((numCachedAndEmpty = numCached + numEmpty) <= 3 ? 3 : (numCachedAndEmpty <= 5 ? 2 : 1)) : 0);
        if (!(memFactor <= this.mLastMemoryLevel || this.mAllowLowerMemLevel && this.mProcessList.getLruSizeLocked() < this.mLastNumProcesses)) {
            memFactor = this.mLastMemoryLevel;
        }
        if (memFactor != this.mLastMemoryLevel) {
            EventLogTags.writeAmMemFactor(memFactor, this.mLastMemoryLevel);
            StatsLog.write(15, memFactor);
        }
        this.mLastMemoryLevel = memFactor;
        this.mLastNumProcesses = this.mProcessList.getLruSizeLocked();
        boolean allChanged = this.mProcessStats.setMemFactorLocked(memFactor, this.mAtmInternal != null ? !this.mAtmInternal.isSleeping() : true, now);
        int trackerMemFactor = this.mProcessStats.getMemFactorLocked();
        if (memFactor != 0) {
            int fgTrimLevel;
            if (this.mLowRamStartTime == 0L) {
                this.mLowRamStartTime = now;
            }
            int step = 0;
            switch (memFactor) {
                case 3: {
                    fgTrimLevel = 15;
                    break;
                }
                case 2: {
                    fgTrimLevel = 10;
                    break;
                }
                default: {
                    fgTrimLevel = 5;
                }
            }
            int factor = numTrimming / 3;
            int minFactor = 2;
            if (this.mAtmInternal.getHomeProcess() != null) {
                ++minFactor;
            }
            if (this.mAtmInternal.getPreviousProcess() != null) {
                ++minFactor;
            }
            if (factor < minFactor) {
                factor = minFactor;
            }
            int curLevel = 80;
            for (int i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mProcessList.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if (app.getCurProcState() >= 15 && !app.killedByAm) {
                    if (app.trimMemoryLevel < curLevel && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(curLevel);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = curLevel;
                    if (++step < factor) continue;
                    step = 0;
                    switch (curLevel) {
                        case 80: {
                            curLevel = 60;
                            break;
                        }
                        case 60: {
                            curLevel = 40;
                        }
                    }
                    continue;
                }
                if (app.getCurProcState() == 14 && !app.killedByAm) {
                    if (app.trimMemoryLevel < 40 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(40);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 40;
                    continue;
                }
                if ((app.getCurProcState() >= 8 || app.systemNoUi) && app.hasPendingUiClean()) {
                    int level = 20;
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.setPendingUiClean(false);
                }
                if (app.trimMemoryLevel < fgTrimLevel && app.thread != null) {
                    try {
                        app.thread.scheduleTrimMemory(fgTrimLevel);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                app.trimMemoryLevel = fgTrimLevel;
            }
        } else {
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamTimeSinceLastIdle += now - this.mLowRamStartTime;
                this.mLowRamStartTime = 0L;
            }
            for (int i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mProcessList.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if ((app.getCurProcState() >= 8 || app.systemNoUi) && app.hasPendingUiClean()) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.setPendingUiClean(false);
                }
                app.trimMemoryLevel = 0;
            }
        }
        return allChanged;
    }

    @GuardedBy(value={"this"})
    final void updateOomAdjLocked(String oomAdjReason) {
        this.mOomAdjuster.updateOomAdjLocked(oomAdjReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void makePackageIdle(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: makePackageIdle() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingPid = Binder.getCallingPid();
        userId = this.mUserController.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, 2, "makePackageIdle", null);
        long callingId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityManagerService.boostPriorityForLockedSection();
            IPackageManager pm = AppGlobals.getPackageManager();
            int pkgUid = -1;
            try {
                pkgUid = pm.getPackageUid(packageName, 0x10002000, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (pkgUid == -1) {
                throw new IllegalArgumentException("Unknown package name " + packageName);
            }
            if (this.mLocalPowerManager != null) {
                this.mLocalPowerManager.startUidChanges();
            }
            int appId = UserHandle.getAppId(pkgUid);
            int N = this.mProcessList.mActiveUids.size();
            for (int i = N - 1; i >= 0; --i) {
                UidRecord uidRec = this.mProcessList.mActiveUids.valueAt(i);
                long bgTime = uidRec.lastBackgroundTime;
                if (bgTime <= 0L || uidRec.idle || UserHandle.getAppId(uidRec.uid) != appId || userId != -1 && userId != UserHandle.getUserId(uidRec.uid)) continue;
                EventLogTags.writeAmUidIdle(uidRec.uid);
                uidRec.idle = true;
                uidRec.setIdle = true;
                Slog.w("ActivityManager", "Idling uid " + UserHandle.formatUid(uidRec.uid) + " from package " + packageName + " user " + userId);
                this.doStopUidLocked(uidRec.uid, uidRec);
            }
            try {
                block14: {
                    if (this.mLocalPowerManager != null) {
                        this.mLocalPowerManager.finishUidChanges();
                    }
                    break block14;
                    catch (Throwable throwable) {
                        if (this.mLocalPowerManager != null) {
                            this.mLocalPowerManager.finishUidChanges();
                        }
                        Binder.restoreCallingIdentity(callingId);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(callingId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[4, 7] lbl52 : MonitorExitStatement: MONITOREXIT : var6_6
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void idleUids() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mOomAdjuster.idleUidsLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @GuardedBy(value={"this"})
    void incrementProcStateSeqAndNotifyAppsLocked() {
        int i;
        if (this.mWaitForNetworkTimeoutMs <= 0L) {
            return;
        }
        ArrayList<Integer> blockingUids = null;
        for (i = this.mProcessList.mActiveUids.size() - 1; i >= 0; --i) {
            int blockState;
            UidRecord uidRec = this.mProcessList.mActiveUids.valueAt(i);
            if (!this.mInjector.isNetworkRestrictedForUid(uidRec.uid) || !UserHandle.isApp(uidRec.uid) || !uidRec.hasInternetPermission || uidRec.setProcState == uidRec.getCurProcState() || (blockState = this.getBlockStateForUid(uidRec)) == 0) continue;
            Object object = uidRec.networkStateLock;
            synchronized (object) {
                uidRec.curProcStateSeq = ++this.mProcessList.mProcStateSeqCounter;
                if (blockState == 1) {
                    if (blockingUids == null) {
                        blockingUids = new ArrayList<Integer>();
                    }
                    blockingUids.add(uidRec.uid);
                } else if (uidRec.waitingForNetwork) {
                    uidRec.networkStateLock.notifyAll();
                }
                continue;
            }
        }
        if (blockingUids == null) {
            return;
        }
        for (i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mProcessList.mLruProcesses.get(i);
            if (!blockingUids.contains(app.uid) || app.killedByAm || app.thread == null) continue;
            UidRecord uidRec = this.mProcessList.getUidRecordLocked(app.uid);
            try {
                if (uidRec == null) continue;
                app.thread.setNetworkBlockSeq(uidRec.curProcStateSeq);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    int getBlockStateForUid(UidRecord uidRec) {
        boolean wasAllowed;
        boolean isAllowed = NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidRec.getCurProcState()) || NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(uidRec.getCurProcState());
        boolean bl = wasAllowed = NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidRec.setProcState) || NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(uidRec.setProcState);
        if (!wasAllowed && isAllowed) {
            return 1;
        }
        if (wasAllowed && !isAllowed) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runInBackgroundDisabled(int uid) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                UidRecord uidRec = this.mProcessList.getUidRecordLocked(uid);
                if (uidRec != null) {
                    if (uidRec.idle) {
                        this.doStopUidLocked(uidRec.uid, uidRec);
                    }
                } else {
                    this.doStopUidLocked(uid, null);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    final void doStopUidLocked(int uid, UidRecord uidRec) {
        this.mServices.stopInBackgroundLocked(uid);
        this.enqueueUidChangeLocked(uidRec, uid, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    void tempWhitelistForPendingIntentLocked(int callerPid, int callerUid, int targetUid, long duration, String tag) {
        PidMap pidMap = this.mPidsSelfLocked;
        synchronized (pidMap) {
            ProcessRecord pr = this.mPidsSelfLocked.get(callerPid);
            if (pr == null) {
                Slog.w("ActivityManager", "tempWhitelistForPendingIntentLocked() no ProcessRecord for pid " + callerPid);
                return;
            }
            if (!pr.whitelistManager && this.checkPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", callerPid, callerUid) != 0) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var7_6
            this.tempWhitelistUidLocked(targetUid, duration, tag);
            return;
        }
    }

    @GuardedBy(value={"this"})
    void tempWhitelistUidLocked(int targetUid, long duration, String tag) {
        this.mPendingTempWhitelist.put(targetUid, new PendingTempWhitelist(targetUid, duration, tag));
        this.setUidTempWhitelistStateLocked(targetUid, true);
        this.mUiHandler.obtainMessage(68).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushTempWhitelist() {
        int i;
        PendingTempWhitelist[] list;
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                N = this.mPendingTempWhitelist.size();
                list = new PendingTempWhitelist[N];
                for (i = 0; i < N; ++i) {
                    list[i] = this.mPendingTempWhitelist.valueAt(i);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var3_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        for (int i2 = 0; i2 < N; ++i2) {
            PendingTempWhitelist ptw = list[i2];
            this.mLocalDeviceIdleController.addPowerSaveTempWhitelistAppDirect(ptw.targetUid, ptw.duration, true, ptw.tag);
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (i = 0; i < N; ++i) {
                    PendingTempWhitelist ptw = list[i];
                    int index = this.mPendingTempWhitelist.indexOfKey(ptw.targetUid);
                    if (index < 0 || this.mPendingTempWhitelist.valueAt(index) != ptw) continue;
                    this.mPendingTempWhitelist.removeAt(index);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl34 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    final void setAppIdTempWhitelistStateLocked(int appId, boolean onWhitelist) {
        this.mOomAdjuster.setAppIdTempWhitelistStateLocked(appId, onWhitelist);
    }

    @GuardedBy(value={"this"})
    final void setUidTempWhitelistStateLocked(int uid, boolean onWhitelist) {
        this.mOomAdjuster.setUidTempWhitelistStateLocked(uid, onWhitelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimApplications(String oomAdjReason) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.trimApplicationsLocked(oomAdjReason);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"this"})
    final void trimApplicationsLocked(String oomAdjReason) {
        for (int i = this.mProcessList.mRemovedProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mProcessList.mRemovedProcesses.get(i);
            if (app.hasActivitiesOrRecentTasks() || !app.curReceivers.isEmpty() || app.services.size() != 0) continue;
            Slog.i("ActivityManager", "Exiting empty application process " + app.toShortString() + " (" + (app.thread != null ? app.thread.asBinder() : null) + ")\n");
            if (app.pid > 0 && app.pid != MY_PID) {
                app.kill("empty", false);
            } else if (app.thread != null) {
                try {
                    app.thread.scheduleExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cleanUpApplicationRecordLocked(app, false, true, -1, false);
            this.mProcessList.mRemovedProcesses.remove(i);
            if (!app.isPersistent()) continue;
            this.addAppLocked(app.info, null, false, null);
        }
        this.updateOomAdjLocked(oomAdjReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalPersistentProcesses(int sig) throws RemoteException {
        if (sig != 10) {
            throw new SecurityException("Only SIGNAL_USR1 is allowed");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.checkCallingPermission("android.permission.SIGNAL_PERSISTENT_PROCESSES") != 0) {
                    throw new SecurityException("Requires permission android.permission.SIGNAL_PERSISTENT_PROCESSES");
                }
                for (int i = this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord r = this.mProcessList.mLruProcesses.get(i);
                    if (r.thread == null || !r.isPersistent()) continue;
                    android.os.Process.sendSignal(r.pid, sig);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void stopProfilerLocked(ProcessRecord proc, int profileType) {
        if (proc == null || proc == this.mProfileData.getProfileProc()) {
            proc = this.mProfileData.getProfileProc();
            profileType = this.mProfileType;
            this.clearProfilerLocked();
        }
        if (proc == null) {
            return;
        }
        try {
            proc.thread.profilerControl(false, null, profileType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    void clearProfilerLocked() {
        if (this.mProfileData.getProfilerInfo() != null && this.mProfileData.getProfilerInfo().profileFd != null) {
            try {
                this.mProfileData.getProfilerInfo().profileFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mProfileData.setProfileApp(null);
        this.mProfileData.setProfileProc(null);
        this.mProfileData.setProfilerInfo(null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean profileControl(String process, int userId, boolean start, ProfilerInfo profilerInfo, int profileType) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findProcessLocked(String process, int userId, String callName) {
        ArrayMap all;
        SparseArray procs;
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, callName, null);
        ProcessRecord proc = null;
        try {
            int pid = Integer.parseInt(process);
            PidMap pidMap = this.mPidsSelfLocked;
            synchronized (pidMap) {
                proc = this.mPidsSelfLocked.get(pid);
            }
        }
        catch (NumberFormatException pid) {
            // empty catch block
        }
        if (proc == null && (procs = (all = this.mProcessList.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
            proc = (ProcessRecord)procs.valueAt(0);
            if (userId != -1 && proc.userId != userId) {
                for (int i = 1; i < procs.size(); ++i) {
                    ProcessRecord thisProc = (ProcessRecord)procs.valueAt(i);
                    if (thisProc.userId != userId) continue;
                    proc = thisProc;
                    break;
                }
            }
        }
        return proc;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean dumpHeap(String process, int userId, boolean managed, boolean mallocInfo, boolean runGc, String path, ParcelFileDescriptor fd, RemoteCallback finishCallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDumpHeapDebugLimit(String processName, int uid, long maxMemSize, String reportPackage) {
        Object object;
        if (processName != null) {
            this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDumpHeapDebugLimit()");
        } else {
            object = this.mPidsSelfLocked;
            synchronized (object) {
                ProcessRecord proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
                if (proc == null) {
                    throw new SecurityException("No process found for calling pid " + Binder.getCallingPid());
                }
                if (!Build.IS_DEBUGGABLE && (proc.info.flags & 2) == 0) {
                    throw new SecurityException("Not running a debuggable build");
                }
                processName = proc.processName;
                uid = proc.uid;
                if (reportPackage != null && !proc.pkgList.containsKey(reportPackage)) {
                    throw new SecurityException("Package " + reportPackage + " is not running in " + proc);
                }
            }
        }
        object = this;
        synchronized (object) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (maxMemSize > 0L) {
                    this.mMemWatchProcesses.put(processName, uid, new Pair<Long, String>(maxMemSize, reportPackage));
                } else if (uid != 0) {
                    this.mMemWatchProcesses.remove(processName, uid);
                } else {
                    this.mMemWatchProcesses.getMap().remove(processName);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl38 : MonitorExitStatement: MONITOREXIT : var6_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dumpHeapFinished(String path) {
        block6: {
            block5: {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (Binder.getCallingPid() == this.mMemWatchDumpPid) break block5;
                    Slog.w("ActivityManager", "dumpHeapFinished: Calling pid " + Binder.getCallingPid() + " does not match last pid " + this.mMemWatchDumpPid);
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (this.mMemWatchDumpFile != null && this.mMemWatchDumpFile.equals(path)) break block6;
            Slog.w("ActivityManager", "dumpHeapFinished: Calling path " + path + " does not match last path " + this.mMemWatchDumpFile);
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mHandler.sendEmptyMessage(50);
        Runtime.getRuntime().gc();
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCoreSettingsChange(Bundle settings) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mProcessList.updateCoreSettingsLocked(settings);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public boolean startUserInBackground(int userId) {
        return this.startUserInBackgroundWithListener(userId, null);
    }

    @Override
    public boolean startUserInBackgroundWithListener(int userId, IProgressListener unlockListener) {
        return this.mUserController.startUser(userId, false, unlockListener);
    }

    @Override
    public boolean startUserInForegroundWithListener(int userId, IProgressListener unlockListener) {
        return this.mUserController.startUser(userId, true, unlockListener);
    }

    @Override
    public boolean unlockUser(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        return this.mUserController.unlockUser(userId, token, secret, listener);
    }

    @Override
    public boolean switchUser(int targetUserId) {
        return this.mUserController.switchUser(targetUserId);
    }

    @Override
    public int stopUser(int userId, boolean force, IStopUserCallback callback) {
        return this.mUserController.stopUser(userId, force, callback, null);
    }

    @Override
    public UserInfo getCurrentUser() {
        return this.mUserController.getCurrentUser();
    }

    String getStartedUserState(int userId) {
        UserState userState = this.mUserController.getStartedUserState(userId);
        return UserState.stateToString(userState.state);
    }

    @Override
    public boolean isUserRunning(int userId, int flags) {
        if (!this.mUserController.isSameProfileGroup(userId, UserHandle.getCallingUserId()) && this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        return this.mUserController.isUserRunning(userId, flags);
    }

    @Override
    public int[] getRunningUserIds() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        return this.mUserController.getStartedUserArray();
    }

    @Override
    public void registerUserSwitchObserver(IUserSwitchObserver observer, String name) {
        this.mUserController.registerUserSwitchObserver(observer, name);
    }

    @Override
    public void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserController.unregisterUserSwitchObserver(observer);
    }

    ApplicationInfo getAppInfoForUser(ApplicationInfo info, int userId) {
        if (info == null) {
            return null;
        }
        ApplicationInfo newInfo = new ApplicationInfo(info);
        newInfo.initForUser(userId);
        return newInfo;
    }

    public boolean isUserStopped(int userId) {
        return this.mUserController.getStartedUserState(userId) == null;
    }

    ActivityInfo getActivityInfoForUser(ActivityInfo aInfo, int userId) {
        if (aInfo == null || userId < 1 && aInfo.applicationInfo.uid < 100000) {
            return aInfo;
        }
        ActivityInfo info = new ActivityInfo(aInfo);
        info.applicationInfo = this.getAppInfoForUser(info.applicationInfo, userId);
        return info;
    }

    private boolean processSanityChecksLocked(ProcessRecord process) {
        if (process == null || process.thread == null) {
            return false;
        }
        boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
        return isDebuggable || (process.info.flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startBinderTracking() throws RemoteException {
        boolean bl;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mBinderTransactionTrackingEnabled = true;
                if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                    throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                }
                for (int i = 0; i < this.mProcessList.mLruProcesses.size(); ++i) {
                    ProcessRecord process = this.mProcessList.mLruProcesses.get(i);
                    if (!this.processSanityChecksLocked(process)) continue;
                    try {
                        process.thread.startBinderTracking();
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.v("ActivityManager", "Process disappared");
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl22 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean stopBinderTrackingAndDump(ParcelFileDescriptor fd) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long inputDispatchingTimedOut(int pid, boolean aboveSystem, String reason) {
        long timeout;
        ProcessRecord proc;
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                PidMap pidMap = this.mPidsSelfLocked;
                synchronized (pidMap) {
                    proc = this.mPidsSelfLocked.get(pid);
                }
                timeout = proc != null ? proc.getInputDispatchingTimeout() : 5000L;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl20 : MonitorExitStatement: MONITOREXIT : var7_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (this.inputDispatchingTimedOut(proc, null, null, null, null, aboveSystem, reason)) {
            return -1L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean inputDispatchingTimedOut(ProcessRecord proc, String activityShortComponentName, ApplicationInfo aInfo, String parentShortComponentName, WindowProcessController parentProcess, boolean aboveSystem, String reason) {
        String annotation;
        block7: {
            block6: {
                boolean bl;
                if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
                    throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
                }
                annotation = reason == null ? "Input dispatching timed out" : "Input dispatching timed out (" + reason + ")";
                if (proc == null) return true;
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (!proc.isDebugging()) break block6;
                    bl = false;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (proc.getActiveInstrumentation() == null) break block7;
            Bundle info = new Bundle();
            info.putString("shortMsg", "keyDispatchingTimedOut");
            info.putString("longMsg", annotation);
            this.finishInstrumentationLocked(proc, 0, info);
            boolean bl = true;
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        proc.appNotResponding(activityShortComponentName, aInfo, parentShortComponentName, parentProcess, aboveSystem, annotation);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForNetworkStateUpdate(long procStateSeq) {
        UidRecord record;
        Object object;
        int callingUid;
        block13: {
            callingUid = Binder.getCallingUid();
            object = this;
            synchronized (object) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    record = this.mProcessList.getUidRecordLocked(callingUid);
                    if (record == null) {
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[4, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var5_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        object = record.networkStateLock;
        synchronized (object) {
            if (record.lastDispatchedProcStateSeq < procStateSeq) {
                return;
            }
            if (record.curProcStateSeq > procStateSeq) {
                return;
            }
            if (record.lastNetworkUpdatedProcStateSeq >= procStateSeq) {
                return;
            }
            try {
                long startTime = SystemClock.uptimeMillis();
                record.waitingForNetwork = true;
                record.networkStateLock.wait(this.mWaitForNetworkTimeoutMs);
                record.waitingForNetwork = false;
                long totalTime = SystemClock.uptimeMillis() - startTime;
                if (totalTime >= this.mWaitForNetworkTimeoutMs) {
                    Slog.w(TAG_NETWORK, "Total time waited for network rules to get updated: " + totalTime + ". Uid: " + callingUid + " procStateSeq: " + procStateSeq + " UidRec: " + record + " validateUidRec: " + this.mValidateUids.get(callingUid));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBroadcastIdle(PrintWriter pw) {
        this.enforceCallingPermission("android.permission.DUMP", "waitForBroadcastIdle()");
        while (true) {
            boolean idle = true;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    for (BroadcastQueue queue : this.mBroadcastQueues) {
                        if (queue.isIdle()) continue;
                        String msg = "Waiting for queue " + queue + " to become idle...";
                        pw.println(msg);
                        pw.println(queue.describeState());
                        pw.flush();
                        Slog.v("ActivityManager", msg);
                        queue.cancelDeferrals();
                        idle = false;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            if (idle) {
                String msg = "All broadcast queues are idle!";
                pw.println("All broadcast queues are idle!");
                pw.flush();
                Slog.v("ActivityManager", "All broadcast queues are idle!");
                return;
            }
            SystemClock.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void killPackageDependents(String packageName, int userId) {
        this.enforceCallingPermission("android.permission.KILL_UID", "killPackageDependents()");
        if (packageName == null) {
            throw new NullPointerException("Cannot kill the dependents of a package without its name.");
        }
        long callingId = Binder.clearCallingIdentity();
        IPackageManager pm = AppGlobals.getPackageManager();
        int pkgUid = -1;
        try {
            pkgUid = pm.getPackageUid(packageName, 0x10000000, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (userId != -1 && pkgUid == -1) {
            throw new IllegalArgumentException("Cannot kill dependents of non-existing package " + packageName);
        }
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mProcessList.killPackageProcessesLocked(packageName, UserHandle.getAppId(pkgUid), userId, 0, "dep: " + packageName);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 5] lbl24 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    @Override
    public int restartUserInBackground(int userId) {
        return this.mUserController.restartUser(userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleApplicationInfoChanged(List<String> packageNames, int userId) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "scheduleApplicationInfoChanged()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long origId = Binder.clearCallingIdentity();
                try {
                    this.updateApplicationInfoLocked(packageNames, userId);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSystemUiContext() {
        PackageManagerInternal packageManagerInternal;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                packageManagerInternal = this.getPackageManagerInternalLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        ApplicationInfo ai = packageManagerInternal.getApplicationInfo("android", 1024, Binder.getCallingUid(), 0);
        ActivityThread.currentActivityThread().handleSystemApplicationInfoChanged(ai);
    }

    void updateApplicationInfoLocked(List<String> packagesToUpdate, int userId) {
        boolean updateFrameworkRes = packagesToUpdate.contains("android");
        if (updateFrameworkRes) {
            PackageParser.readConfigUseRoundIcon(null);
        }
        this.mProcessList.updateApplicationInfoLocked(packagesToUpdate, userId, updateFrameworkRes);
        if (updateFrameworkRes) {
            Executor executor = ActivityThread.currentActivityThread().getExecutor();
            DisplayManagerInternal display = LocalServices.getService(DisplayManagerInternal.class);
            if (display != null) {
                executor.execute(display::onOverlayChanged);
            }
            if (this.mWindowManager != null) {
                executor.execute(this.mWindowManager::onOverlayChanged);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attachAgent(String process, String path) {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ProcessRecord proc = this.findProcessLocked(process, 0, "attachAgent");
                    if (proc == null) throw new IllegalArgumentException("Unknown process: " + process);
                    if (proc.thread == null) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                    if (!isDebuggable && (proc.info.flags & 2) == 0) {
                        throw new SecurityException("Process not debuggable: " + proc);
                    }
                    proc.thread.attachAgent(path);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForPossibleShutdown() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mUsageStatsService != null) {
                    this.mUsageStatsService.prepareForPossibleShutdown();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void startDelegateShellPermissionIdentity(int delegateUid, String[] permissions) {
        block11: {
            if (UserHandle.getCallingAppId() != 2000 && UserHandle.getCallingAppId() != 0) {
                throw new SecurityException("Only the shell can delegate its permissions");
            }
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            ActivityManagerService.boostPriorityForLockedSection();
            if (this.mAppOpsService.getAppOpsServiceDelegate() != this.getPackageManagerInternalLocked().getCheckPermissionDelegate()) {
                throw new IllegalStateException("Bad shell delegate state");
            }
            if (this.mAppOpsService.getAppOpsServiceDelegate() == null) break block11;
            if (!(this.mAppOpsService.getAppOpsServiceDelegate() instanceof ShellDelegate)) {
                throw new IllegalStateException("Bad shell delegate state");
            }
            ShellDelegate delegate = (ShellDelegate)this.mAppOpsService.getAppOpsServiceDelegate();
            if (delegate.getDelegateUid() != delegateUid) {
                throw new SecurityException("Shell can delegate permissions only to one instrumentation at a time");
            }
            delegate.setPermissions(permissions);
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            int instrCount = this.mActiveInstrumentation.size();
            for (int i = 0; i < instrCount; ++i) {
                ActiveInstrumentation instr = this.mActiveInstrumentation.get(i);
                if (instr.mTargetInfo.uid != delegateUid) break block12;
                if (instr.mUiAutomationConnection == null) {
                    throw new SecurityException("Shell can delegate its permissions only to an instrumentation started from the shell");
                }
                ShellDelegate shellDelegate = new ShellDelegate(instr.mTargetInfo.packageName, delegateUid, permissions);
                this.mAppOpsService.setAppOpsServiceDelegate(shellDelegate);
                this.getPackageManagerInternalLocked().setCheckPermissionDelegate(shellDelegate);
                // MONITOREXIT : activityManagerService
            }
        }
        catch (Throwable throwable) {
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            throw throwable;
        }
        {
            block12: {
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            continue;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDelegateShellPermissionIdentity() {
        if (UserHandle.getCallingAppId() != 2000 && UserHandle.getCallingAppId() != 0) {
            throw new SecurityException("Only the shell can delegate its permissions");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mAppOpsService.setAppOpsServiceDelegate(null);
                this.getPackageManagerInternalLocked().setCheckPermissionDelegate(null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    void maybeTriggerWatchdog() {
        String key = "debug.trigger.watchdog";
    }

    private boolean isOnOffloadQueue(int flags) {
        return this.mEnableOffloadQueue && (flags & Integer.MIN_VALUE) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ParcelFileDescriptor getLifeMonitor() {
        ParcelFileDescriptor parcelFileDescriptor;
        if (!this.isCallerShell()) {
            throw new SecurityException("Only shell can call it");
        }
        ActivityManagerService activityManagerService = this;
        // MONITORENTER : activityManagerService
        try {
            ActivityManagerService.boostPriorityForLockedSection();
            if (this.mLifeMonitorFds == null) {
                this.mLifeMonitorFds = ParcelFileDescriptor.createPipe();
            }
            parcelFileDescriptor = this.mLifeMonitorFds[0].dup();
            // MONITOREXIT : activityManagerService
        }
        catch (IOException e) {
            ParcelFileDescriptor parcelFileDescriptor2;
            try {
                Slog.w("ActivityManager", "Unable to create pipe", e);
                parcelFileDescriptor2 = null;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return parcelFileDescriptor2;
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return parcelFileDescriptor;
    }

    private /* synthetic */ void lambda$systemReady$1(PowerSaveState state) {
        this.updateForceBackgroundCheck(state.batterySaverEnabled);
    }

    static /* synthetic */ void access$200(ActivityManagerService x0) {
        x0.dispatchProcessesChanged();
    }

    static /* synthetic */ void access$300(ActivityManagerService x0, int x1, int x2) {
        x0.dispatchProcessDied(x1, x2);
    }

    static /* synthetic */ void access$800(ActivityManagerService x0) {
        x0.deferPssForActivityStart();
    }

    static /* synthetic */ AtomicInteger access$900(ActivityManagerService x0) {
        return x0.mActivityStartingNesting;
    }

    static {
        PROCESS_STATE_STATS_FORMAT = new int[]{32, 544, 10272};
        DUMP_MEM_BUCKETS = new long[]{5120L, 7168L, 10240L, 15360L, 20480L, 30720L, 40960L, 81920L, 122880L, 163840L, 204800L, 256000L, 307200L, 358400L, 409600L, 512000L, 614400L, 819200L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L};
        DUMP_MEM_OOM_ADJ = new int[]{-1000, -900, -800, -700, 0, 100, 200, 250, 300, 400, 500, 600, 700, 800, 900};
        DUMP_MEM_OOM_LABEL = new String[]{"Native", "System", "Persistent", "Persistent Service", "Foreground", "Visible", "Perceptible", "Perceptible Low", "Heavy Weight", "Backup", "A Services", "Home", "Previous", "B Services", "Cached"};
        DUMP_MEM_OOM_COMPACT_LABEL = new String[]{"native", "sys", "pers", "persvc", "fore", "vis", "percept", "perceptl", "heavy", "backup", "servicea", "home", "prev", "serviceb", "cached"};
    }

    private class ShellDelegate
    implements AppOpsManagerInternal.CheckOpsDelegate,
    PackageManagerInternal.CheckPermissionDelegate {
        private final String mTargetPackageName;
        private final int mTargetUid;
        private String[] mPermissions;

        ShellDelegate(String targetPacakgeName, int targetUid, String[] permissions) {
            this.mTargetPackageName = targetPacakgeName;
            this.mTargetUid = targetUid;
            this.mPermissions = permissions;
        }

        int getDelegateUid() {
            return this.mTargetUid;
        }

        void setPermissions(String[] permissions) {
            this.mPermissions = permissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkOperation(int code, int uid, String packageName, boolean raw2, QuadFunction<Integer, Integer, String, Boolean, Integer> superImpl) {
            if (uid == this.mTargetUid && this.isTargetOp(code)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = superImpl.apply(code, 2000, "com.android.shell", raw2);
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return superImpl.apply(code, uid, packageName, raw2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkAudioOperation(int code, int usage, int uid, String packageName, QuadFunction<Integer, Integer, Integer, String, Integer> superImpl) {
            if (uid == this.mTargetUid && this.isTargetOp(code)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = superImpl.apply(code, usage, 2000, "com.android.shell");
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return superImpl.apply(code, usage, uid, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int noteOperation(int code, int uid, String packageName, TriFunction<Integer, Integer, String, Integer> superImpl) {
            if (uid == this.mTargetUid && this.isTargetOp(code)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = ActivityManagerService.this.mAppOpsService.noteProxyOperation(code, 2000, "com.android.shell", uid, packageName);
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return superImpl.apply(code, uid, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkPermission(String permName, String pkgName, int userId, TriFunction<String, String, Integer, Integer> superImpl) {
            if (this.mTargetPackageName.equals(pkgName) && this.isTargetPermission(permName)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = superImpl.apply(permName, "com.android.shell", userId);
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return superImpl.apply(permName, pkgName, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkUidPermission(String permName, int uid, BiFunction<String, Integer, Integer> superImpl) {
            if (uid == this.mTargetUid && this.isTargetPermission(permName)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = superImpl.apply(permName, 2000);
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return superImpl.apply(permName, uid);
        }

        private boolean isTargetOp(int code) {
            if (this.mPermissions == null) {
                return true;
            }
            String permission2 = AppOpsManager.opToPermission(code);
            if (permission2 == null) {
                return true;
            }
            return this.isTargetPermission(permission2);
        }

        private boolean isTargetPermission(String permission2) {
            return this.mPermissions == null || ArrayUtils.contains(this.mPermissions, permission2);
        }
    }

    @VisibleForTesting
    public static class Injector {
        private NetworkManagementInternal mNmi;

        public Context getContext() {
            return null;
        }

        public AppOpsService getAppOpsService(File file, Handler handler) {
            return new AppOpsService(file, handler);
        }

        public Handler getUiHandler(ActivityManagerService service) {
            return service.new UiHandler();
        }

        public boolean isNetworkRestrictedForUid(int uid) {
            if (this.ensureHasNetworkManagementInternal()) {
                return this.mNmi.isNetworkRestrictedForUid(uid);
            }
            return false;
        }

        private boolean ensureHasNetworkManagementInternal() {
            if (this.mNmi == null) {
                this.mNmi = LocalServices.getService(NetworkManagementInternal.class);
            }
            return this.mNmi != null;
        }
    }

    @VisibleForTesting
    public final class LocalService
    extends ActivityManagerInternal {
        @Override
        public String checkContentProviderAccess(String authority, int userId) {
            return ActivityManagerService.this.checkContentProviderAccess(authority, userId);
        }

        @Override
        public void onWakefulnessChanged(int wakefulness) {
            ActivityManagerService.this.onWakefulnessChanged(wakefulness);
        }

        @Override
        public boolean startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
            return ActivityManagerService.this.startIsolatedProcess(entryPoint, entryPointArgs, processName, abiOverride, uid, crashHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killForegroundAppsForUser(int userHandle) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                    int NP = ActivityManagerService.this.mProcessList.mProcessNames.getMap().size();
                    for (int ip = 0; ip < NP; ++ip) {
                        SparseArray apps = ActivityManagerService.this.mProcessList.mProcessNames.getMap().valueAt(ip);
                        int NA = apps.size();
                        for (int ia = 0; ia < NA; ++ia) {
                            ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                            if (app.isPersistent() || !app.removed && (app.userId != userHandle || !app.hasForegroundActivities())) continue;
                            procs.add(app);
                        }
                    }
                    int N = procs.size();
                    for (int i = 0; i < N; ++i) {
                        ActivityManagerService.this.mProcessList.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all fg");
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public void setPendingIntentWhitelistDuration(IIntentSender target, IBinder whitelistToken, long duration) {
            ActivityManagerService.this.mPendingIntentController.setPendingIntentWhitelistDuration(target, whitelistToken, duration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPendingIntentAllowBgActivityStarts(IIntentSender target, IBinder whitelistToken, int flags) {
            if (!(target instanceof PendingIntentRecord)) {
                Slog.w("ActivityManager", "setPendingIntentAllowBgActivityStarts(): not a PendingIntentRecord: " + target);
                return;
            }
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ((PendingIntentRecord)target).setAllowBgActivityStarts(whitelistToken, flags);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearPendingIntentAllowBgActivityStarts(IIntentSender target, IBinder whitelistToken) {
            if (!(target instanceof PendingIntentRecord)) {
                Slog.w("ActivityManager", "clearPendingIntentAllowBgActivityStarts(): not a PendingIntentRecord: " + target);
                return;
            }
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ((PendingIntentRecord)target).clearAllowBgActivityStarts(whitelistToken);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceIdleWhitelist(int[] allAppids, int[] exceptIdleAppids) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.mDeviceIdleWhitelist = allAppids;
                    ActivityManagerService.this.mDeviceIdleExceptIdleWhitelist = exceptIdleAppids;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateDeviceIdleTempWhitelist(int[] appids, int changingAppId, boolean adding) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.mDeviceIdleTempWhitelist = appids;
                    ActivityManagerService.this.setAppIdTempWhitelistStateLocked(changingAppId, adding);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public int getUidProcessState(int uid) {
            return ActivityManagerService.this.getUidState(uid);
        }

        @Override
        public boolean isSystemReady() {
            return ActivityManagerService.this.mSystemReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setHasOverlayUi(int pid, boolean hasOverlayUi) {
            ProcessRecord pr;
            block9: {
                block8: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    // MONITORENTER : activityManagerService
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        PidMap pidMap = ActivityManagerService.this.mPidsSelfLocked;
                        // MONITORENTER : pidMap
                        pr = ActivityManagerService.this.mPidsSelfLocked.get(pid);
                        if (pr != null) break block8;
                        Slog.w("ActivityManager", "setHasOverlayUi called on unknown pid: " + pid);
                        // MONITOREXIT : pidMap
                        // MONITOREXIT : activityManagerService
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                // MONITOREXIT : pidMap
                if (pr.hasOverlayUi() != hasOverlayUi) break block9;
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            pr.setHasOverlayUi(hasOverlayUi);
            ActivityManagerService.this.updateOomAdjLocked(pr, true, "updateOomAdj_uiVisibility");
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void notifyNetworkPolicyRulesUpdated(int uid, long procStateSeq) {
            UidRecord record;
            Object object;
            block9: {
                object = ActivityManagerService.this;
                synchronized (object) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        record = ActivityManagerService.this.mProcessList.getUidRecordLocked(uid);
                        if (record == null) {
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[3, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var5_3
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            object = record.networkStateLock;
            synchronized (object) {
                if (record.lastNetworkUpdatedProcStateSeq >= procStateSeq) {
                    return;
                }
                record.lastNetworkUpdatedProcStateSeq = procStateSeq;
                if (record.curProcStateSeq > procStateSeq) {
                    return;
                }
                if (!record.waitingForNetwork) return;
                record.networkStateLock.notifyAll();
                return;
            }
        }

        @Override
        public boolean isRuntimeRestarted() {
            return ActivityManagerService.this.mSystemServiceManager.isRuntimeRestarted();
        }

        @Override
        public boolean canStartMoreUsers() {
            return ActivityManagerService.this.mUserController.canStartMoreUsers();
        }

        @Override
        public void setSwitchingFromSystemUserMessage(String switchingFromSystemUserMessage) {
            ActivityManagerService.this.mUserController.setSwitchingFromSystemUserMessage(switchingFromSystemUserMessage);
        }

        @Override
        public void setSwitchingToSystemUserMessage(String switchingToSystemUserMessage) {
            ActivityManagerService.this.mUserController.setSwitchingToSystemUserMessage(switchingToSystemUserMessage);
        }

        @Override
        public int getMaxRunningUsers() {
            return ActivityManagerService.this.mUserController.mMaxRunningUsers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isUidActive(int uid) {
            boolean bl;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    bl = ActivityManagerService.this.isUidActiveLocked(uid);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return bl;
        }

        @Override
        public void setRunningRemoteAnimation(int pid, boolean runningRemoteAnimation) {
            ActivityManagerService.this.setRunningRemoteAnimation(pid, runningRemoteAnimation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ProcessMemoryState> getMemoryStateForProcesses() {
            ArrayList<ProcessMemoryState> processMemoryStates = new ArrayList<ProcessMemoryState>();
            PidMap pidMap = ActivityManagerService.this.mPidsSelfLocked;
            synchronized (pidMap) {
                int size = ActivityManagerService.this.mPidsSelfLocked.size();
                for (int i = 0; i < size; ++i) {
                    ProcessRecord r = ActivityManagerService.this.mPidsSelfLocked.valueAt(i);
                    processMemoryStates.add(new ProcessMemoryState(r.uid, r.pid, r.processName, r.curAdj));
                }
            }
            return processMemoryStates;
        }

        @Override
        public int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, int allowMode, String name, String callerPackage) {
            return ActivityManagerService.this.mUserController.handleIncomingUser(callingPid, callingUid, userId, allowAll, allowMode, name, callerPackage);
        }

        @Override
        public void enforceCallingPermission(String permission2, String func) {
            ActivityManagerService.this.enforceCallingPermission(permission2, func);
        }

        @Override
        public int getCurrentUserId() {
            return ActivityManagerService.this.mUserController.getCurrentUserIdLU();
        }

        @Override
        public boolean isUserRunning(int userId, int flags) {
            return ActivityManagerService.this.mUserController.isUserRunning(userId, flags);
        }

        @Override
        public void trimApplications() {
            ActivityManagerService.this.trimApplications("updateOomAdj_activityChange");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killProcessesForRemovedTask(ArrayList<Object> procsToKill) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    for (int i = 0; i < procsToKill.size(); ++i) {
                        WindowProcessController wpc = (WindowProcessController)procsToKill.get(i);
                        ProcessRecord pr = (ProcessRecord)wpc.mOwner;
                        if (pr.setSchedGroup == 0 && pr.curReceivers.isEmpty()) {
                            pr.kill("remove task", true);
                            continue;
                        }
                        pr.waitingToKill = "remove task";
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killProcess(String processName, int uid, String reason) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ProcessRecord proc = ActivityManagerService.this.getProcessRecordLocked(processName, uid, true);
                    if (proc != null) {
                        ActivityManagerService.this.mProcessList.removeProcessLocked(proc, false, true, reason);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasRunningActivity(int uid, String packageName) {
            if (packageName == null) {
                return false;
            }
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                boolean bl;
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    for (int i = 0; i < ActivityManagerService.this.mProcessList.mLruProcesses.size(); ++i) {
                        ProcessRecord pr = ActivityManagerService.this.mProcessList.mLruProcesses.get(i);
                        if (pr.uid != uid || !pr.getWindowProcessController().hasRunningActivity(packageName)) break block6;
                        bl = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                {
                    block6: {
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return bl;
                    }
                    continue;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateOomAdj() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.updateOomAdjLocked("updateOomAdj_meh");
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCpuStats() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.updateCpuStats();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateBatteryStats(ComponentName activity, int uid, int userId, boolean resumed) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.updateBatteryStats(activity, uid, userId, resumed);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateActivityUsageStats(ComponentName activity, int userId, int event, IBinder appToken, ComponentName taskRoot) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.updateActivityUsageStats(activity, userId, event, appToken, taskRoot);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var6_6
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void updateForegroundTimeIfOnBattery(String packageName, int uid, long cpuTimeDiff) {
            BatteryStatsImpl bsi;
            block7: {
                ActivityManagerService activityManagerService = ActivityManagerService.this;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (ActivityManagerService.this.mBatteryStatsService.isOnBattery()) break block7;
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            BatteryStatsImpl batteryStatsImpl = bsi = ActivityManagerService.this.mBatteryStatsService.getActiveStatistics();
            // MONITORENTER : batteryStatsImpl
            BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(uid, packageName);
            if (ps != null) {
                ps.addForegroundTimeLocked(cpuTimeDiff);
            }
            // MONITOREXIT : batteryStatsImpl
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public void sendForegroundProfileChanged(int userId) {
            ActivityManagerService.this.mUserController.sendForegroundProfileChanged(userId);
        }

        @Override
        public boolean shouldConfirmCredentials(int userId) {
            return ActivityManagerService.this.mUserController.shouldConfirmCredentials(userId);
        }

        @Override
        public int[] getCurrentProfileIds() {
            return ActivityManagerService.this.mUserController.getCurrentProfileIds();
        }

        @Override
        public UserInfo getCurrentUser() {
            return ActivityManagerService.this.mUserController.getCurrentUser();
        }

        @Override
        public void ensureNotSpecialUser(int userId) {
            ActivityManagerService.this.mUserController.ensureNotSpecialUser(userId);
        }

        @Override
        public boolean isCurrentProfile(int userId) {
            return ActivityManagerService.this.mUserController.isCurrentProfile(userId);
        }

        @Override
        public boolean hasStartedUserState(int userId) {
            return ActivityManagerService.this.mUserController.hasStartedUserState(userId);
        }

        @Override
        public void finishUserSwitch(Object uss) {
            ActivityManagerService.this.mUserController.finishUserSwitch((UserState)uss);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleAppGcs() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.scheduleAppGcsLocked();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getTaskIdForActivity(IBinder token, boolean onlyRoot) {
            int n;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    n = ActivityManagerService.this.getTaskForActivity(token, onlyRoot);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return n;
        }

        @Override
        public ActivityPresentationInfo getActivityPresentationInfo(IBinder token) {
            int displayId = -1;
            try {
                displayId = ActivityManagerService.this.mActivityTaskManager.getActivityDisplayId(token);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return new ActivityPresentationInfo(ActivityManagerService.this.mActivityTaskManager.getTaskForActivity(token, false), displayId, ActivityManagerService.this.mActivityTaskManager.getActivityClassForToken(token));
        }

        @Override
        public void setBooting(boolean booting) {
            ActivityManagerService.this.mBooting = booting;
        }

        @Override
        public boolean isBooting() {
            return ActivityManagerService.this.mBooting;
        }

        @Override
        public void setBooted(boolean booted) {
            ActivityManagerService.this.mBooted = booted;
        }

        @Override
        public boolean isBooted() {
            return ActivityManagerService.this.mBooted;
        }

        @Override
        public void finishBooting() {
            ActivityManagerService.this.finishBooting();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tempWhitelistForPendingIntent(int callerPid, int callerUid, int targetUid, long duration, String tag) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.tempWhitelistForPendingIntentLocked(callerPid, callerUid, targetUid, duration, tag);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var7_6
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int broadcastIntentInPackage(String packageName, int uid, int realCallingUid, int realCallingPid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String requiredPermission, Bundle bOptions, boolean serialized, boolean sticky, int userId, boolean allowBackgroundActivityStarts) {
            int n;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    n = ActivityManagerService.this.broadcastIntentInPackage(packageName, uid, realCallingUid, realCallingPid, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermission, bOptions, serialized, sticky, userId, allowBackgroundActivityStarts);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ComponentName startServiceInPackage(int uid, Intent service, String resolvedType, boolean fgRequired, String callingPackage, int userId, boolean allowBackgroundActivityStarts) throws TransactionTooLargeException {
            ComponentName componentName;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ComponentName res;
                    ActivityManagerService.boostPriorityForLockedSection();
                    long origId = Binder.clearCallingIdentity();
                    try {
                        res = ActivityManagerService.this.mServices.startServiceLocked(null, service, resolvedType, -1, uid, fgRequired, callingPackage, userId, allowBackgroundActivityStarts);
                    }
                    finally {
                        Binder.restoreCallingIdentity(origId);
                    }
                    componentName = res;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 4] lbl16 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return componentName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnectActivityFromServices(Object connectionHolder, Object conns) {
            ActivityServiceConnectionsHolder holder = (ActivityServiceConnectionsHolder)connectionHolder;
            HashSet toDisconnect = (HashSet)conns;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    for (ConnectionRecord cr : toDisconnect) {
                        ActivityManagerService.this.mServices.removeConnectionLocked(cr, null, holder);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var5_5
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanUpServices(int userId, ComponentName component, Intent baseIntent) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.mServices.cleanUpServices(userId, component, baseIntent);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public ActivityInfo getActivityInfoForUser(ActivityInfo aInfo, int userId) {
            return ActivityManagerService.this.getActivityInfoForUser(aInfo, userId);
        }

        @Override
        public void ensureBootCompleted() {
            ActivityManagerService.this.ensureBootCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateOomLevelsForDisplay(int displayId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (ActivityManagerService.this.mWindowManager != null) {
                        ActivityManagerService.this.mProcessList.applyDisplaySize(ActivityManagerService.this.mWindowManager);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        @Override
        public boolean isActivityStartsLoggingEnabled() {
            return ActivityManagerService.this.mConstants.mFlagActivityStartsLoggingEnabled;
        }

        @Override
        public boolean isBackgroundActivityStartsEnabled() {
            return ActivityManagerService.this.mConstants.mFlagBackgroundActivityStartsEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportCurKeyguardUsageEvent(boolean keyguardShowing) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.reportGlobalUsageEventLocked(keyguardShowing ? 17 : 18);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long inputDispatchingTimedOut(int pid, boolean aboveSystem, String reason) {
            long l;
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    l = ActivityManagerService.this.inputDispatchingTimedOut(pid, aboveSystem, reason);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return l;
        }

        @Override
        public boolean inputDispatchingTimedOut(Object proc, String activityShortComponentName, ApplicationInfo aInfo, String parentShortComponentName, Object parentProc, boolean aboveSystem, String reason) {
            return ActivityManagerService.this.inputDispatchingTimedOut((ProcessRecord)proc, activityShortComponentName, aInfo, parentShortComponentName, (WindowProcessController)parentProc, aboveSystem, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcastGlobalConfigurationChanged(int changes, boolean initLocale) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    Intent intent = new Intent("android.intent.action.CONFIGURATION_CHANGED");
                    intent.addFlags(0x70200000);
                    ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, Binder.getCallingUid(), Binder.getCallingPid(), -1);
                    if ((changes & 4) != 0) {
                        intent = new Intent("android.intent.action.LOCALE_CHANGED");
                        intent.addFlags(0x11200000);
                        if (initLocale || !ActivityManagerService.this.mProcessesReady) {
                            intent.addFlags(0x40000000);
                        }
                        ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, Binder.getCallingUid(), Binder.getCallingPid(), -1);
                    }
                    if (!initLocale && this.isSplitConfigurationChange(changes)) {
                        intent = new Intent("android.intent.action.SPLIT_CONFIGURATION_CHANGED");
                        intent.addFlags(0x21000000);
                        String[] permissions = new String[]{"android.permission.INSTALL_PACKAGES"};
                        ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, permissions, -1, null, false, false, MY_PID, 1000, Binder.getCallingUid(), Binder.getCallingPid(), -1);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl29 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        private boolean isSplitConfigurationChange(int configDiff) {
            return (configDiff & 0x1004) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcastCloseSystemDialogs(String reason) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    Intent intent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
                    intent.addFlags(0x50000000);
                    if (reason != null) {
                        intent.putExtra("reason", reason);
                    }
                    ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, Binder.getCallingUid(), Binder.getCallingPid(), -1);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killAllBackgroundProcessesExcept(int minTargetSdk, int maxProcState) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.killAllBackgroundProcessesExcept(minTargetSdk, maxProcState);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void startProcess(String processName, ApplicationInfo info, boolean knownToBeDead, String hostingType, ComponentName hostingName) {
            try {
                if (Trace.isTagEnabled(64L)) {
                    Trace.traceBegin(64L, "startProcess:" + processName);
                }
                ActivityManagerService activityManagerService = ActivityManagerService.this;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        ActivityManagerService.this.startProcessLocked(processName, info, knownToBeDead, 0, new HostingRecord(hostingType, hostingName), false, false, true);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            finally {
                Trace.traceEnd(64L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDebugFlagsForStartingActivity(ActivityInfo aInfo, int startFlags, ProfilerInfo profilerInfo, Object wmLock) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    Object object = wmLock;
                    synchronized (object) {
                        if ((startFlags & 2) != 0) {
                            ActivityManagerService.this.setDebugApp(aInfo.processName, true, false);
                        }
                        if ((startFlags & 8) != 0) {
                            ActivityManagerService.this.setNativeDebuggingAppLocked(aInfo.applicationInfo, aInfo.processName);
                        }
                        if ((startFlags & 4) != 0) {
                            ActivityManagerService.this.setTrackAllocationApp(aInfo.applicationInfo, aInfo.processName);
                        }
                        if (profilerInfo != null) {
                            ActivityManagerService.this.setProfileApp(aInfo.applicationInfo, aInfo.processName, profilerInfo);
                        }
                        wmLock.notify();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl25 : MonitorExitStatement: MONITOREXIT : var5_5
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStorageMountMode(int pid, int uid) {
            if (uid == 2000 || uid == 0) {
                return 6;
            }
            PidMap pidMap = ActivityManagerService.this.mPidsSelfLocked;
            synchronized (pidMap) {
                ProcessRecord pr = ActivityManagerService.this.mPidsSelfLocked.get(pid);
                return pr == null ? 0 : pr.mountMode;
            }
        }

        @Override
        public boolean isAppForeground(int uid) {
            return ActivityManagerService.this.isAppForeground(uid);
        }

        @Override
        public boolean isAppBad(ApplicationInfo info) {
            return ActivityManagerService.this.isAppBad(info);
        }

        @Override
        public void clearPendingBackup(int userId) {
            ActivityManagerService.this.clearPendingBackup(userId);
        }

        @Override
        public void prepareForPossibleShutdown() {
            ActivityManagerService.this.prepareForPossibleShutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasRunningForegroundService(int uid, int foregroundServicetype) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                boolean bl;
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    for (int i = 0; i < ActivityManagerService.this.mProcessList.mLruProcesses.size(); ++i) {
                        ProcessRecord pr = ActivityManagerService.this.mProcessList.mLruProcesses.get(i);
                        if (pr.uid != uid || (pr.getForegroundServiceTypes() & foregroundServicetype) == 0) break block5;
                        bl = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                {
                    block5: {
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return bl;
                    }
                    continue;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return false;
        }

        @Override
        public void registerProcessObserver(IProcessObserver processObserver) {
            ActivityManagerService.this.registerProcessObserver(processObserver);
        }

        @Override
        public void unregisterProcessObserver(IProcessObserver processObserver) {
            ActivityManagerService.this.unregisterProcessObserver(processObserver);
        }
    }

    static final class ProcStatsRunnable
    implements Runnable {
        private final ActivityManagerService mService;
        private final ProcessStatsService mProcessStats;

        ProcStatsRunnable(ActivityManagerService service, ProcessStatsService mProcessStats) {
            this.mService = service;
            this.mProcessStats = mProcessStats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mProcessStats.writeStateAsyncLocked();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
    }

    private static final class RecordPssRunnable
    implements Runnable {
        private final ActivityManagerService mService;
        private final ProcessRecord mProc;
        private final File mHeapdumpFile;

        RecordPssRunnable(ActivityManagerService service, ProcessRecord proc, File heapdumpFile) {
            this.mService = service;
            this.mProc = proc;
            this.mHeapdumpFile = heapdumpFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mService.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), null, DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
            ParcelFileDescriptor fd = null;
            try {
                this.mHeapdumpFile.delete();
                fd = ParcelFileDescriptor.open(this.mHeapdumpFile, 0x2E000000);
                IApplicationThread thread = this.mProc.thread;
                if (thread != null) {
                    try {
                        thread.dumpHeap(true, false, false, this.mHeapdumpFile.toString(), fd, null);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class MemoryUsageDumpOptions {
        boolean dumpDetails;
        boolean dumpFullDetails;
        boolean dumpDalvik;
        boolean dumpSummaryOnly;
        boolean dumpUnreachable;
        boolean oomOnly;
        boolean isCompact;
        boolean localOnly;
        boolean packages;
        boolean isCheckinRequest;
        boolean dumpSwapPss;
        boolean dumpProto;

        private MemoryUsageDumpOptions() {
        }
    }

    static final class MemItem {
        final boolean isProc;
        final String label;
        final String shortLabel;
        final long pss;
        final long swapPss;
        final int id;
        final boolean hasActivities;
        ArrayList<MemItem> subitems;

        public MemItem(String _label, String _shortLabel, long _pss, long _swapPss, int _id, boolean _hasActivities) {
            this.isProc = true;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.swapPss = _swapPss;
            this.id = _id;
            this.hasActivities = _hasActivities;
        }

        public MemItem(String _label, String _shortLabel, long _pss, long _swapPss, int _id) {
            this.isProc = false;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.swapPss = _swapPss;
            this.id = _id;
            this.hasActivities = false;
        }
    }

    public static class ItemMatcher {
        ArrayList<ComponentName> components;
        ArrayList<String> strings;
        ArrayList<Integer> objects;
        boolean all = true;

        public void build(String name) {
            ComponentName componentName = ComponentName.unflattenFromString(name);
            if (componentName != null) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(componentName);
                this.all = false;
            } else {
                int objectId = 0;
                try {
                    objectId = Integer.parseInt(name, 16);
                    if (this.objects == null) {
                        this.objects = new ArrayList();
                    }
                    this.objects.add(objectId);
                    this.all = false;
                }
                catch (RuntimeException e) {
                    if (this.strings == null) {
                        this.strings = new ArrayList();
                    }
                    this.strings.add(name);
                    this.all = false;
                }
            }
        }

        public int build(String[] args, int opti) {
            while (opti < args.length) {
                String name = args[opti];
                if ("--".equals(name)) {
                    return opti + 1;
                }
                this.build(name);
                ++opti;
            }
            return opti;
        }

        public boolean match(Object object, ComponentName comp) {
            int i;
            if (this.all) {
                return true;
            }
            if (this.components != null) {
                for (i = 0; i < this.components.size(); ++i) {
                    if (!this.components.get(i).equals(comp)) continue;
                    return true;
                }
            }
            if (this.objects != null) {
                for (i = 0; i < this.objects.size(); ++i) {
                    if (System.identityHashCode(object) != this.objects.get(i)) continue;
                    return true;
                }
            }
            if (this.strings != null) {
                String flat = comp.flattenToString();
                for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                    if (!flat.contains(this.strings.get(i2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class StartActivityRunnable
    implements Runnable {
        private final Context mContext;
        private final Intent mIntent;
        private final UserHandle mUserHandle;

        StartActivityRunnable(Context context, Intent intent, UserHandle userHandle) {
            this.mContext = context;
            this.mIntent = intent;
            this.mUserHandle = userHandle;
        }

        @Override
        public void run() {
            this.mContext.startActivityAsUser(this.mIntent, this.mUserHandle);
        }
    }

    class IntentFirewallInterface
    implements IntentFirewall.AMSInterface {
        IntentFirewallInterface() {
        }

        @Override
        public int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return ActivityManagerService.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        @Override
        public Object getAMSLock() {
            return ActivityManagerService.this;
        }
    }

    static class PermissionController
    extends IPermissionController.Stub {
        ActivityManagerService mActivityManagerService;

        PermissionController(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public boolean checkPermission(String permission2, int pid, int uid) {
            return this.mActivityManagerService.checkPermission(permission2, pid, uid) == 0;
        }

        @Override
        public int noteOp(String op, int uid, String packageName) {
            return this.mActivityManagerService.mAppOpsService.noteOperation(AppOpsManager.strOpToOp(op), uid, packageName);
        }

        @Override
        public String[] getPackagesForUid(int uid) {
            return this.mActivityManagerService.mContext.getPackageManager().getPackagesForUid(uid);
        }

        @Override
        public boolean isRuntimePermission(String permission2) {
            try {
                PermissionInfo info = this.mActivityManagerService.mContext.getPackageManager().getPermissionInfo(permission2, 0);
                return (info.protectionLevel & 0xF) == 1;
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Slog.e("ActivityManager", "No such permission: " + permission2, nnfe);
                return false;
            }
        }

        @Override
        public int getPackageUid(String packageName, int flags) {
            try {
                return this.mActivityManagerService.mContext.getPackageManager().getPackageUid(packageName, flags);
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                return -1;
            }
        }
    }

    static class ProcessInfoService
    extends IProcessInfoService.Stub {
        final ActivityManagerService mActivityManagerService;

        ProcessInfoService(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public void getProcessStatesFromPids(int[] pids, int[] states) {
            this.mActivityManagerService.getProcessStatesAndOomScoresForPIDs(pids, states, null);
        }

        @Override
        public void getProcessStatesAndOomScoresFromPids(int[] pids, int[] states, int[] scores) {
            this.mActivityManagerService.getProcessStatesAndOomScoresForPIDs(pids, states, scores);
        }
    }

    static class HiddenApiSettings
    extends ContentObserver
    implements DeviceConfig.OnPropertiesChangedListener {
        private final Context mContext;
        private boolean mBlacklistDisabled;
        private String mExemptionsStr;
        private List<String> mExemptions = Collections.emptyList();
        private int mLogSampleRate = -1;
        private int mStatslogSampleRate = -1;
        private int mPolicy = -1;
        public static final String HIDDEN_API_ACCESS_LOG_SAMPLING_RATE = "hidden_api_access_log_sampling_rate";
        public static final String HIDDEN_API_ACCESS_STATSLOG_SAMPLING_RATE = "hidden_api_access_statslog_sampling_rate";

        @Override
        public void onPropertiesChanged(DeviceConfig.Properties properties) {
            int logSampleRate = properties.getInt(HIDDEN_API_ACCESS_LOG_SAMPLING_RATE, this.mLogSampleRate);
            int statslogSampleRate = properties.getInt(HIDDEN_API_ACCESS_STATSLOG_SAMPLING_RATE, this.mStatslogSampleRate);
            this.setSampleRates(logSampleRate, statslogSampleRate);
        }

        private void setSampleRates(int logSampleRate, int statslogSampleRate) {
            if (logSampleRate >= 0 && logSampleRate <= 65536 && logSampleRate != this.mLogSampleRate) {
                this.mLogSampleRate = logSampleRate;
                android.os.Process.ZYGOTE_PROCESS.setHiddenApiAccessLogSampleRate(this.mLogSampleRate);
            }
            if (statslogSampleRate >= 0 && statslogSampleRate <= 65536 && statslogSampleRate != this.mStatslogSampleRate) {
                this.mStatslogSampleRate = statslogSampleRate;
                android.os.Process.ZYGOTE_PROCESS.setHiddenApiAccessStatslogSampleRate(this.mStatslogSampleRate);
            }
        }

        private void initializeSampleRates() {
            int logSampleRate = DeviceConfig.getInt("app_compat", HIDDEN_API_ACCESS_LOG_SAMPLING_RATE, 0);
            int statslogSampleRate = DeviceConfig.getInt("app_compat", HIDDEN_API_ACCESS_STATSLOG_SAMPLING_RATE, 0);
            this.setSampleRates(logSampleRate, statslogSampleRate);
        }

        public HiddenApiSettings(Handler handler, Context context) {
            super(handler);
            this.mContext = context;
        }

        public void registerObserver() {
            this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("hidden_api_blacklist_exemptions"), false, this);
            this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("hidden_api_policy"), false, this);
            this.initializeSampleRates();
            DeviceConfig.addOnPropertiesChangedListener("app_compat", this.mContext.getMainExecutor(), this);
            this.update();
        }

        private void update() {
            String exemptions = Settings.Global.getString(this.mContext.getContentResolver(), "hidden_api_blacklist_exemptions");
            if (!TextUtils.equals(exemptions, this.mExemptionsStr)) {
                this.mExemptionsStr = exemptions;
                if ("*".equals(exemptions)) {
                    this.mBlacklistDisabled = true;
                    this.mExemptions = Collections.emptyList();
                } else {
                    this.mBlacklistDisabled = false;
                    List<Object> list = this.mExemptions = TextUtils.isEmpty(exemptions) ? Collections.emptyList() : Arrays.asList(exemptions.split(","));
                }
                if (!android.os.Process.ZYGOTE_PROCESS.setApiBlacklistExemptions(this.mExemptions)) {
                    Slog.e("ActivityManager", "Failed to set API blacklist exemptions!");
                    this.mExemptions = Collections.emptyList();
                }
            }
            this.mPolicy = this.getValidEnforcementPolicy("hidden_api_policy");
        }

        private int getValidEnforcementPolicy(String settingsKey) {
            int policy = Settings.Global.getInt(this.mContext.getContentResolver(), settingsKey, -1);
            if (ApplicationInfo.isValidHiddenApiEnforcementPolicy(policy)) {
                return policy;
            }
            return -1;
        }

        boolean isDisabled() {
            return this.mBlacklistDisabled;
        }

        int getPolicy() {
            return this.mPolicy;
        }

        @Override
        public void onChange(boolean selfChange) {
            this.update();
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final ActivityManagerService mService;
        private static ActivityTaskManagerService sAtm;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ActivityManagerService(context, sAtm);
        }

        public static ActivityManagerService startService(SystemServiceManager ssm, ActivityTaskManagerService atm) {
            sAtm = atm;
            return ssm.startService(Lifecycle.class).getService();
        }

        @Override
        public void onStart() {
            this.mService.start();
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.mBootPhase = phase;
            if (phase == 500) {
                this.mService.mBatteryStatsService.systemServicesReady();
                this.mService.mServices.systemServicesReady();
            } else if (phase == 550) {
                this.mService.startBroadcastObservers();
            } else if (phase == 600) {
                this.mService.mPackageWatchdog.onPackagesReady();
            }
        }

        @Override
        public void onCleanupUser(int userId) {
            this.mService.mBatteryStatsService.onCleanupUser(userId);
        }

        public ActivityManagerService getService() {
            return this.mService;
        }
    }

    static class CpuBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;
        private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dumpCritical(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
                if (asProto) {
                    return;
                }
                if (!DumpUtils.checkDumpAndUsageStatsPermission(mActivityManagerService.mContext, "cpuinfo", pw)) {
                    return;
                }
                ProcessCpuTracker processCpuTracker = mActivityManagerService.mProcessCpuTracker;
                synchronized (processCpuTracker) {
                    pw.print(mActivityManagerService.mProcessCpuTracker.printCurrentLoad());
                    pw.print(mActivityManagerService.mProcessCpuTracker.printCurrentState(SystemClock.uptimeMillis()));
                }
            }
        };

        CpuBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            PriorityDump.dump(this.mPriorityDumper, fd, pw, args);
        }
    }

    static class DbBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        DbBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "dbinfo", pw)) {
                return;
            }
            this.mActivityManagerService.dumpDbInfo(fd, pw, args);
        }
    }

    static class GraphicsBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        GraphicsBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "gfxinfo", pw)) {
                return;
            }
            this.mActivityManagerService.dumpGraphicsHardwareUsage(fd, pw, args);
        }
    }

    static class MemBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;
        private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

            @Override
            public void dumpHigh(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
                this.dump(fd, pw, new String[]{"-a"}, asProto);
            }

            @Override
            public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
                mActivityManagerService.dumpApplicationMemoryUsage(fd, pw, "  ", args, false, null, asProto);
            }
        };

        MemBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "meminfo", pw)) {
                return;
            }
            PriorityDump.dump(this.mPriorityDumper, fd, pw, args);
        }
    }

    final class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.performAppGcsIfAppropriateLocked();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[17, 52, 30, 31] lbl11 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 12: {
                    ActivityManagerService.this.mServices.serviceTimeout((ProcessRecord)msg.obj);
                    return;
                }
                case 66: {
                    ActivityManagerService.this.mServices.serviceForegroundTimeout((ServiceRecord)msg.obj);
                    return;
                }
                case 69: {
                    ActivityManagerService.this.mServices.serviceForegroundCrash((ProcessRecord)msg.obj, msg.getData().getCharSequence(ActivityManagerService.SERVICE_RECORD_KEY));
                    return;
                }
                case 13: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            for (int i = ActivityManagerService.this.mProcessList.mLruProcesses.size() - 1; i >= 0; --i) {
                                ProcessRecord r = ActivityManagerService.this.mProcessList.mLruProcesses.get(i);
                                if (r.thread == null) continue;
                                try {
                                    r.thread.updateTimeZone();
                                    continue;
                                }
                                catch (RemoteException ex) {
                                    Slog.w("ActivityManager", "Failed to update time zone for: " + r.info.processName);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 35, 54, 30] lbl43 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 28: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.mProcessList.clearAllDnsCacheLocked();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[19, 36, 55, 30] lbl57 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 29: {
                    ActivityManagerService.this.mProcessList.setAllHttpProxy();
                    return;
                }
                case 20: {
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService i = ActivityManagerService.this;
                    synchronized (i) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.processStartTimedOutLocked(app);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[38, 56, 26, 30] lbl75 : MonitorExitStatement: MONITOREXIT : i
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 57: {
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService i = ActivityManagerService.this;
                    synchronized (i) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.processContentProviderPublishTimedOutLocked(app);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[39, 57, 27, 30] lbl90 : MonitorExitStatement: MONITOREXIT : i
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 22: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            int appId = msg.arg1;
                            int userId = msg.arg2;
                            Bundle bundle = (Bundle)msg.obj;
                            String pkg = bundle.getString("pkg");
                            String reason = bundle.getString("reason");
                            ActivityManagerService.this.forceStopPackageLocked(pkg, appId, false, false, true, false, false, userId, reason);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[20, 40, 58, 30] lbl110 : MonitorExitStatement: MONITOREXIT : app
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 71: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            AppZygote appZygote = (AppZygote)msg.obj;
                            ActivityManagerService.this.mProcessList.killAppZygoteIfNeededLocked(appZygote);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[21, 41, 59, 30] lbl125 : MonitorExitStatement: MONITOREXIT : app
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 27: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.checkExcessivePowerUsageLocked();
                            this.removeMessages(27);
                            Message nmsg = this.obtainMessage(27);
                            this.sendMessageDelayed(nmsg, ActivityManagerService.this.mConstants.POWER_CHECK_INTERVAL);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[22, 42, 60, 30] lbl143 : MonitorExitStatement: MONITOREXIT : app
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 33: {
                    final ArrayList memInfos = (ArrayList)msg.obj;
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            ActivityManagerService.this.reportMemUsage(memInfos);
                        }
                    };
                    thread.start();
                    return;
                }
                case 41: {
                    ActivityManagerService memInfos = ActivityManagerService.this;
                    synchronized (memInfos) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.mProcessList.updateAllTimePrefsLocked(msg.arg1);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[23, 44, 61, 30] lbl162 : MonitorExitStatement: MONITOREXIT : memInfos
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 49: {
                    int uid = msg.arg1;
                    byte[] firstPacket = (byte[])msg.obj;
                    PidMap userId = ActivityManagerService.this.mPidsSelfLocked;
                    synchronized (userId) {
                        int i = 0;
                        while (i < ActivityManagerService.this.mPidsSelfLocked.size()) {
                            ProcessRecord p = ActivityManagerService.this.mPidsSelfLocked.valueAt(i);
                            if (p.uid == uid && p.thread != null) {
                                try {
                                    p.thread.notifyCleartextNetwork(firstPacket);
                                }
                                catch (RemoteException reason) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                }
                case 50: {
                    boolean isUserInitiated;
                    String reportPackage;
                    long memLimit;
                    String procName;
                    int uid;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            uid = ActivityManagerService.this.mMemWatchDumpUid;
                            procName = uid == 1000 ? ActivityManagerService.this.mContext.getString(17039490) : ActivityManagerService.this.mMemWatchDumpProcName;
                            Pair<Long, String> val = ActivityManagerService.this.mMemWatchProcesses.get(procName, uid);
                            if (val == null) {
                                val = ActivityManagerService.this.mMemWatchProcesses.get(procName, 0);
                            }
                            if (val != null) {
                                memLimit = (Long)val.first;
                                reportPackage = (String)val.second;
                            } else {
                                memLimit = 0L;
                                reportPackage = null;
                            }
                            isUserInitiated = ActivityManagerService.this.mMemWatchIsUserInitiated;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[24, 46, 30, 63] lbl204 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    if (procName == null) {
                        return;
                    }
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    int titleId = isUserInitiated ? 17039877 : 17039875;
                    String text = ActivityManagerService.this.mContext.getString(titleId, procName);
                    Intent deleteIntent = new Intent();
                    deleteIntent.setAction("com.android.server.am.DELETE_DUMPHEAP");
                    Intent intent = new Intent();
                    intent.setClassName("android", DumpHeapActivity.class.getName());
                    intent.putExtra("process", procName);
                    intent.putExtra("size", memLimit);
                    intent.putExtra("is_user_initiated", isUserInitiated);
                    intent.putExtra("is_system_process", uid == 1000);
                    if (reportPackage != null) {
                        intent.putExtra("direct_launch", reportPackage);
                    }
                    int userId = UserHandle.getUserId(uid);
                    Notification notification = new Notification.Builder(ActivityManagerService.this.mContext, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303519).setAutoCancel(true).setTicker(text).setColor(ActivityManagerService.this.mContext.getColor(17170460)).setContentTitle(text).setContentText(ActivityManagerService.this.mContext.getText(17039876)).setContentIntent(PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, intent, 0x10000000, null, new UserHandle(userId))).setDeleteIntent(PendingIntent.getBroadcastAsUser(ActivityManagerService.this.mContext, 0, deleteIntent, 0, UserHandle.SYSTEM)).build();
                    try {
                        inm.enqueueNotificationWithTag("android", "android", null, 12, notification, userId);
                        return;
                    }
                    catch (RuntimeException e) {
                        Slog.w("ActivityManager", "Error showing notification for dump heap", e);
                        return;
                    }
                    catch (RemoteException throwable) {
                        return;
                    }
                }
                case 51: {
                    ActivityManagerService.this.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), null, DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
                    ActivityManagerService procName = ActivityManagerService.this;
                    synchronized (procName) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.mMemWatchDumpFile = null;
                            ActivityManagerService.this.mMemWatchDumpProcName = null;
                            ActivityManagerService.this.mMemWatchDumpPid = -1;
                            ActivityManagerService.this.mMemWatchDumpUid = -1;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[66, 29, 30, 47] lbl256 : MonitorExitStatement: MONITOREXIT : procName
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 56: {
                    IUiAutomationConnection connection = (IUiAutomationConnection)msg.obj;
                    try {
                        connection.shutdown();
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityManager", "Error shutting down UiAutomationConnection");
                    }
                    ActivityManagerService.this.mUserIsMonkey = false;
                    return;
                }
                case 58: {
                    ActivityManagerService.this.idleUids();
                    return;
                }
                case 63: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityManagerService.this.mProcessList.handleAllTrustStorageUpdateLocked();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[50, 68, 25, 30] lbl284 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
            }
        }
    }

    final class UiHandler
    extends Handler {
        public UiHandler() {
            super(UiThread.get().getLooper(), null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityManagerService.this.mAppErrors.handleShowAppErrorUi(msg);
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 2: {
                    ActivityManagerService.this.mAppErrors.handleShowAnrUi(msg);
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 26: {
                    data = (HashMap)msg.obj;
                    var3_5 = ActivityManagerService.this;
                    synchronized (var3_5) {
                        ActivityManagerService.boostPriorityForLockedSection();
                        proc = (ProcessRecord)data.get("app");
                        if (proc != null) ** GOTO lbl-1000
                        Slog.e("ActivityManager", "App not found when showing strict mode dialog.");
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    break;
lbl-1000:
                    // 1 sources

                    {
                        if (proc.crashDialog == null) ** GOTO lbl-1000
                        Slog.e("ActivityManager", "App already has strict mode dialog: " + proc);
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            res = (AppErrorResult)data.get("result");
                            if (ActivityManagerService.this.mAtmInternal.showStrictModeViolationDialog()) {
                                d = new StrictModeViolationDialog(ActivityManagerService.this.mUiContext, ActivityManagerService.this, res, proc);
                                d.show();
                                proc.crashDialog = d;
                            } else {
                                res.set(0);
                            }
                        }
                        catch (Throwable var7_12) {
                            // MONITOREXIT @DISABLED, blocks:[17, 5, 6, 9] lbl41 : MonitorExitStatement: MONITOREXIT : var3_5
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw var7_12;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 6: {
                    data = ActivityManagerService.this;
                    synchronized (data) {
                        ActivityManagerService.boostPriorityForLockedSection();
                        app = (ProcessRecord)msg.obj;
                        if (msg.arg1 != 0) {
                            if (!app.waitedForDebugger) {
                                d = new AppWaitingForDebuggerDialog(ActivityManagerService.this, ActivityManagerService.this.mUiContext, app);
                                app.waitDialog = d;
                                app.waitedForDebugger = true;
                                d.show();
                            }
                        } else if (app.waitDialog != null) {
                            app.waitDialog.dismiss();
                            app.waitDialog = null;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var8_13) {
                            // MONITOREXIT @DISABLED, blocks:[18, 4, 6, 10] lbl68 : MonitorExitStatement: MONITOREXIT : data
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw var8_13;
                        }
                    }
                }
                case 31: {
                    ActivityManagerService.access$200(ActivityManagerService.this);
                    break;
                }
                case 32: {
                    pid = msg.arg1;
                    uid = msg.arg2;
                    ActivityManagerService.access$300(ActivityManagerService.this, pid, uid);
                    break;
                }
                case 53: {
                    ActivityManagerService.this.dispatchUidsChanged();
                    break;
                }
                case 70: {
                    ActivityManagerService.this.dispatchOomAdjObserver((String)msg.obj);
                    break;
                }
                case 68: {
                    ActivityManagerService.this.pushTempWhitelist();
                }
            }
        }
    }

    private final class AppDeathRecipient
    implements IBinder.DeathRecipient {
        final ProcessRecord mApp;
        final int mPid;
        final IApplicationThread mAppThread;

        AppDeathRecipient(ProcessRecord app, int pid, IApplicationThread thread) {
            this.mApp = app;
            this.mPid = pid;
            this.mAppThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityManagerService.this.appDiedLocked(this.mApp, this.mPid, this.mAppThread, true);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
    }

    static interface OomAdjObserver {
        public void onOomAdjMessage(String var1);
    }

    static final class UidObserverRegistration {
        final int uid;
        final String pkg;
        final int which;
        final int cutpoint;
        int mSlowDispatchCount;
        int mMaxDispatchTime;
        final SparseIntArray lastProcStates;
        private static int[] ORIG_ENUMS = new int[]{4, 8, 2, 1};
        private static int[] PROTO_ENUMS = new int[]{3, 4, 2, 1};

        UidObserverRegistration(int _uid, String _pkg, int _which, int _cutpoint) {
            this.uid = _uid;
            this.pkg = _pkg;
            this.which = _which;
            this.cutpoint = _cutpoint;
            this.lastProcStates = this.cutpoint >= 0 ? new SparseIntArray() : null;
        }

        void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.uid);
            proto.write(1138166333442L, this.pkg);
            ProtoUtils.writeBitWiseFlagsToProtoEnum(proto, 2259152797699L, this.which, ORIG_ENUMS, PROTO_ENUMS);
            proto.write(1120986464260L, this.cutpoint);
            if (this.lastProcStates != null) {
                int NI = this.lastProcStates.size();
                for (int i = 0; i < NI; ++i) {
                    long pToken = proto.start(2246267895813L);
                    proto.write(0x10500000001L, this.lastProcStates.keyAt(i));
                    proto.write(1120986464258L, this.lastProcStates.valueAt(i));
                    proto.end(pToken);
                }
            }
            proto.end(token);
        }
    }

    static final class ProcessChangeItem {
        static final int CHANGE_ACTIVITIES = 1;
        static final int CHANGE_FOREGROUND_SERVICES = 2;
        int changes;
        int uid;
        int pid;
        int processState;
        boolean foregroundActivities;
        int foregroundServiceTypes;

        ProcessChangeItem() {
        }
    }

    class ProfileData {
        private String mProfileApp = null;
        private ProcessRecord mProfileProc = null;
        private ProfilerInfo mProfilerInfo = null;

        ProfileData() {
        }

        void setProfileApp(String profileApp) {
            this.mProfileApp = profileApp;
            if (ActivityManagerService.this.mAtmInternal != null) {
                ActivityManagerService.this.mAtmInternal.setProfileApp(profileApp);
            }
        }

        String getProfileApp() {
            return this.mProfileApp;
        }

        void setProfileProc(ProcessRecord profileProc) {
            this.mProfileProc = profileProc;
            if (ActivityManagerService.this.mAtmInternal != null) {
                ActivityManagerService.this.mAtmInternal.setProfileProc(profileProc == null ? null : profileProc.getWindowProcessController());
            }
        }

        ProcessRecord getProfileProc() {
            return this.mProfileProc;
        }

        void setProfilerInfo(ProfilerInfo profilerInfo) {
            this.mProfilerInfo = profilerInfo;
            if (ActivityManagerService.this.mAtmInternal != null) {
                ActivityManagerService.this.mAtmInternal.setProfilerInfo(profilerInfo);
            }
        }

        ProfilerInfo getProfilerInfo() {
            return this.mProfilerInfo;
        }
    }

    static final class PendingTempWhitelist {
        final int targetUid;
        final long duration;
        final String tag;

        PendingTempWhitelist(int _targetUid, long _duration, String _tag) {
            this.targetUid = _targetUid;
            this.duration = _duration;
            this.tag = _tag;
        }

        void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.targetUid);
            proto.write(1112396529666L, this.duration);
            proto.write(1138166333443L, this.tag);
            proto.end(token);
        }
    }

    private class Identity {
        public final IBinder token;
        public final int pid;
        public final int uid;

        Identity(IBinder _token, int _pid, int _uid) {
            this.token = _token;
            this.pid = _pid;
            this.uid = _uid;
        }
    }

    private final class DevelopmentSettingsObserver
    extends ContentObserver {
        private final Uri mUri;
        private final ComponentName mBugreportStorageProvider;

        public DevelopmentSettingsObserver() {
            super(ActivityManagerService.this.mHandler);
            this.mUri = Settings.Global.getUriFor("development_settings_enabled");
            this.mBugreportStorageProvider = new ComponentName("com.android.shell", "com.android.shell.BugreportStorageProvider");
            ActivityManagerService.this.mContext.getContentResolver().registerContentObserver(this.mUri, false, this, -1);
            this.onChange();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mUri.equals(uri)) {
                this.onChange();
            }
        }

        public void onChange() {
            boolean enabled = Settings.Global.getInt(ActivityManagerService.this.mContext.getContentResolver(), "development_settings_enabled", Build.IS_ENG ? 1 : 0) != 0;
            ActivityManagerService.this.mContext.getPackageManager().setComponentEnabledSetting(this.mBugreportStorageProvider, enabled ? 1 : 0, 0);
        }
    }

    static final class Association {
        final int mSourceUid;
        final String mSourceProcess;
        final int mTargetUid;
        final ComponentName mTargetComponent;
        final String mTargetProcess;
        int mCount;
        long mTime;
        int mNesting;
        long mStartTime;
        int mLastState = 22;
        long mLastStateUptime;
        long[] mStateTimes = new long[22];

        Association(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent, String targetProcess) {
            this.mSourceUid = sourceUid;
            this.mSourceProcess = sourceProcess;
            this.mTargetUid = targetUid;
            this.mTargetComponent = targetComponent;
            this.mTargetProcess = targetProcess;
        }
    }

    abstract class ImportanceToken
    implements IBinder.DeathRecipient {
        final int pid;
        final IBinder token;
        final String reason;

        ImportanceToken(int _pid, IBinder _token, String _reason) {
            this.pid = _pid;
            this.token = _token;
            this.reason = _reason;
        }

        public String toString() {
            return "ImportanceToken { " + Integer.toHexString(System.identityHashCode(this)) + " " + this.reason + " " + this.pid + " " + this.token + " }";
        }

        void writeToProto(ProtoOutputStream proto, long fieldId) {
            long pToken = proto.start(fieldId);
            proto.write(0x10500000001L, this.pid);
            if (this.token != null) {
                proto.write(1138166333442L, this.token.toString());
            }
            proto.write(1138166333443L, this.reason);
            proto.end(pToken);
        }
    }

    final class PidMap {
        private final SparseArray<ProcessRecord> mPidMap = new SparseArray();

        PidMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(ProcessRecord app) {
            PidMap pidMap = this;
            synchronized (pidMap) {
                this.mPidMap.put(app.pid, app);
            }
            ActivityManagerService.this.mAtmInternal.onProcessMapped(app.pid, app.getWindowProcessController());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ProcessRecord app) {
            boolean removed = false;
            PidMap pidMap = this;
            synchronized (pidMap) {
                ProcessRecord existingApp = this.mPidMap.get(app.pid);
                if (existingApp != null && existingApp.startSeq == app.startSeq) {
                    this.mPidMap.remove(app.pid);
                    removed = true;
                }
            }
            if (removed) {
                ActivityManagerService.this.mAtmInternal.onProcessUnMapped(app.pid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeIfNoThread(ProcessRecord app) {
            boolean removed = false;
            PidMap pidMap = this;
            synchronized (pidMap) {
                ProcessRecord existingApp = this.get(app.pid);
                if (existingApp != null && existingApp.startSeq == app.startSeq && app.thread == null) {
                    this.mPidMap.remove(app.pid);
                    removed = true;
                }
            }
            if (removed) {
                ActivityManagerService.this.mAtmInternal.onProcessUnMapped(app.pid);
            }
            return removed;
        }

        ProcessRecord get(int pid) {
            return this.mPidMap.get(pid);
        }

        int size() {
            return this.mPidMap.size();
        }

        ProcessRecord valueAt(int index) {
            return this.mPidMap.valueAt(index);
        }

        int keyAt(int index) {
            return this.mPidMap.keyAt(index);
        }

        int indexOfKey(int key) {
            return this.mPidMap.indexOfKey(key);
        }
    }

    private final class PackageAssociationInfo {
        private final String mSourcePackage;
        private final ArraySet<String> mAllowedPackageAssociations;
        private boolean mIsDebuggable;

        PackageAssociationInfo(String sourcePackage, ArraySet<String> allowedPackages, boolean isDebuggable) {
            this.mSourcePackage = sourcePackage;
            this.mAllowedPackageAssociations = allowedPackages;
            this.mIsDebuggable = isDebuggable;
        }

        boolean isPackageAssociationAllowed(String targetPackage) {
            return this.mIsDebuggable || this.mAllowedPackageAssociations.contains(targetPackage);
        }

        boolean isDebuggable() {
            return this.mIsDebuggable;
        }

        void setDebuggable(boolean isDebuggable) {
            this.mIsDebuggable = isDebuggable;
        }

        ArraySet<String> getAllowedPackageAssociations() {
            return this.mAllowedPackageAssociations;
        }
    }
}

