/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.IntentBindRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;

final class AppBindRecord {
    final ServiceRecord service;
    final IntentBindRecord intent;
    final ProcessRecord client;
    final ArraySet<ConnectionRecord> connections = new ArraySet();

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "service=" + this.service);
        pw.println(prefix + "client=" + this.client);
        this.dumpInIntentBind(pw, prefix);
    }

    void dumpInIntentBind(PrintWriter pw, String prefix) {
        int N = this.connections.size();
        if (N > 0) {
            pw.println(prefix + "Per-process Connections:");
            for (int i = 0; i < N; ++i) {
                ConnectionRecord c = this.connections.valueAt(i);
                pw.println(prefix + "  " + c);
            }
        }
    }

    AppBindRecord(ServiceRecord _service, IntentBindRecord _intent, ProcessRecord _client) {
        this.service = _service;
        this.intent = _intent;
        this.client = _client;
    }

    public String toString() {
        return "AppBindRecord{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.service.shortInstanceName + ":" + this.client.processName + "}";
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.service.shortInstanceName);
        proto.write(1138166333442L, this.client.processName);
        int N = this.connections.size();
        for (int i = 0; i < N; ++i) {
            ConnectionRecord conn = this.connections.valueAt(i);
            proto.write(2237677961219L, Integer.toHexString(System.identityHashCode(conn)));
        }
        proto.end(token);
    }
}

