/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.os.Debug;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.os.Trace;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.ServiceThread;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ProcessRecord;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class AppCompactor {
    @VisibleForTesting
    static final String KEY_USE_COMPACTION = "use_compaction";
    @VisibleForTesting
    static final String KEY_COMPACT_ACTION_1 = "compact_action_1";
    @VisibleForTesting
    static final String KEY_COMPACT_ACTION_2 = "compact_action_2";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_1 = "compact_throttle_1";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_2 = "compact_throttle_2";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_3 = "compact_throttle_3";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_4 = "compact_throttle_4";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_5 = "compact_throttle_5";
    @VisibleForTesting
    static final String KEY_COMPACT_THROTTLE_6 = "compact_throttle_6";
    @VisibleForTesting
    static final String KEY_COMPACT_STATSD_SAMPLE_RATE = "compact_statsd_sample_rate";
    @VisibleForTesting
    static final String KEY_COMPACT_FULL_RSS_THROTTLE_KB = "compact_full_rss_throttle_kb";
    @VisibleForTesting
    static final String KEY_COMPACT_FULL_DELTA_RSS_THROTTLE_KB = "compact_full_delta_rss_throttle_kb";
    @VisibleForTesting
    static final String KEY_COMPACT_PROC_STATE_THROTTLE = "compact_proc_state_throttle";
    private static final int COMPACT_ACTION_FILE_FLAG = 1;
    private static final int COMPACT_ACTION_ANON_FLAG = 2;
    private static final int COMPACT_ACTION_FULL_FLAG = 3;
    private static final int COMPACT_ACTION_NONE_FLAG = 4;
    private static final String COMPACT_ACTION_NONE = "";
    private static final String COMPACT_ACTION_FILE = "file";
    private static final String COMPACT_ACTION_ANON = "anon";
    private static final String COMPACT_ACTION_FULL = "all";
    @VisibleForTesting
    static final Boolean DEFAULT_USE_COMPACTION = false;
    @VisibleForTesting
    static final int DEFAULT_COMPACT_ACTION_1 = 1;
    @VisibleForTesting
    static final int DEFAULT_COMPACT_ACTION_2 = 3;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_1 = 5000L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_2 = 10000L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_3 = 500L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_4 = 10000L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_5 = 600000L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_THROTTLE_6 = 600000L;
    @VisibleForTesting
    static final float DEFAULT_STATSD_SAMPLE_RATE = 0.1f;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_FULL_RSS_THROTTLE_KB = 12000L;
    @VisibleForTesting
    static final long DEFAULT_COMPACT_FULL_DELTA_RSS_THROTTLE_KB = 8000L;
    @VisibleForTesting
    static final String DEFAULT_COMPACT_PROC_STATE_THROTTLE = String.valueOf(12);
    private PropertyChangedCallbackForTest mTestCallback;
    static final int COMPACT_PROCESS_SOME = 1;
    static final int COMPACT_PROCESS_FULL = 2;
    static final int COMPACT_PROCESS_PERSISTENT = 3;
    static final int COMPACT_PROCESS_BFGS = 4;
    static final int COMPACT_PROCESS_MSG = 1;
    static final int COMPACT_SYSTEM_MSG = 2;
    final ServiceThread mCompactionThread;
    private final ArrayList<ProcessRecord> mPendingCompactionProcesses = new ArrayList();
    private final ActivityManagerService mAm;
    private final DeviceConfig.OnPropertiesChangedListener mOnFlagsChangedListener = new DeviceConfig.OnPropertiesChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPropertiesChanged(DeviceConfig.Properties properties) {
            Object object = AppCompactor.this.mPhenotypeFlagLock;
            synchronized (object) {
                for (String name : properties.getKeyset()) {
                    if (AppCompactor.KEY_USE_COMPACTION.equals(name)) {
                        AppCompactor.this.updateUseCompaction();
                        continue;
                    }
                    if (AppCompactor.KEY_COMPACT_ACTION_1.equals(name) || AppCompactor.KEY_COMPACT_ACTION_2.equals(name)) {
                        AppCompactor.this.updateCompactionActions();
                        continue;
                    }
                    if (AppCompactor.KEY_COMPACT_THROTTLE_1.equals(name) || AppCompactor.KEY_COMPACT_THROTTLE_2.equals(name) || AppCompactor.KEY_COMPACT_THROTTLE_3.equals(name) || AppCompactor.KEY_COMPACT_THROTTLE_4.equals(name)) {
                        AppCompactor.this.updateCompactionThrottles();
                        continue;
                    }
                    if (AppCompactor.KEY_COMPACT_STATSD_SAMPLE_RATE.equals(name)) {
                        AppCompactor.this.updateStatsdSampleRate();
                        continue;
                    }
                    if (AppCompactor.KEY_COMPACT_FULL_RSS_THROTTLE_KB.equals(name)) {
                        AppCompactor.this.updateFullRssThrottle();
                        continue;
                    }
                    if (AppCompactor.KEY_COMPACT_FULL_DELTA_RSS_THROTTLE_KB.equals(name)) {
                        AppCompactor.this.updateFullDeltaRssThrottle();
                        continue;
                    }
                    if (!AppCompactor.KEY_COMPACT_PROC_STATE_THROTTLE.equals(name)) continue;
                    AppCompactor.this.updateProcStateThrottle();
                }
            }
            if (AppCompactor.this.mTestCallback != null) {
                AppCompactor.this.mTestCallback.onPropertyChanged();
            }
        }
    };
    private final Object mPhenotypeFlagLock = new Object();
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile String mCompactActionSome = AppCompactor.compactActionIntToString(1);
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile String mCompactActionFull = AppCompactor.compactActionIntToString(3);
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottleSomeSome = 5000L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottleSomeFull = 10000L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottleFullSome = 500L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottleFullFull = 10000L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottleBFGS = 600000L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mCompactThrottlePersistent = 600000L;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    private volatile boolean mUseCompaction = DEFAULT_USE_COMPACTION;
    private final Random mRandom = new Random();
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile float mStatsdSampleRate = 0.1f;
    @GuardedBy(value={"mPhenotypeFlagLock"})
    @VisibleForTesting
    volatile long mFullAnonRssThrottleKb = 12000L;
    @GuardedBy(value={"mPhenoypeFlagLock"})
    @VisibleForTesting
    volatile long mFullDeltaRssThrottleKb = 8000L;
    @GuardedBy(value={"mPhenoypeFlagLock"})
    @VisibleForTesting
    final Set<Integer> mProcStateThrottle;
    private Handler mCompactionHandler;
    private Map<Integer, LastCompactionStats> mLastCompactionStats = new LinkedHashMap<Integer, LastCompactionStats>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    };
    private int mSomeCompactionCount;
    private int mFullCompactionCount;
    private int mPersistentCompactionCount;
    private int mBfgsCompactionCount;

    public AppCompactor(ActivityManagerService am) {
        this.mAm = am;
        this.mCompactionThread = new ServiceThread("CompactionThread", -2, true);
        this.mProcStateThrottle = new HashSet<Integer>();
    }

    @VisibleForTesting
    AppCompactor(ActivityManagerService am, PropertyChangedCallbackForTest callback) {
        this(am);
        this.mTestCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        DeviceConfig.addOnPropertiesChangedListener("activity_manager", ActivityThread.currentApplication().getMainExecutor(), this.mOnFlagsChangedListener);
        Object object = this.mPhenotypeFlagLock;
        synchronized (object) {
            this.updateUseCompaction();
            this.updateCompactionActions();
            this.updateCompactionThrottles();
            this.updateStatsdSampleRate();
            this.updateFullRssThrottle();
            this.updateFullDeltaRssThrottle();
            this.updateProcStateThrottle();
        }
        Process.setThreadGroupAndCpuset(this.mCompactionThread.getThreadId(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useCompaction() {
        Object object = this.mPhenotypeFlagLock;
        synchronized (object) {
            return this.mUseCompaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mAm"})
    void dump(PrintWriter pw) {
        pw.println("AppCompactor settings");
        Object object = this.mPhenotypeFlagLock;
        synchronized (object) {
            pw.println("  use_compaction=" + this.mUseCompaction);
            pw.println("  compact_action_1=" + this.mCompactActionSome);
            pw.println("  compact_action_2=" + this.mCompactActionFull);
            pw.println("  compact_throttle_1=" + this.mCompactThrottleSomeSome);
            pw.println("  compact_throttle_2=" + this.mCompactThrottleSomeFull);
            pw.println("  compact_throttle_3=" + this.mCompactThrottleFullSome);
            pw.println("  compact_throttle_4=" + this.mCompactThrottleFullFull);
            pw.println("  compact_throttle_5=" + this.mCompactThrottleBFGS);
            pw.println("  compact_throttle_6=" + this.mCompactThrottlePersistent);
            pw.println("  compact_statsd_sample_rate=" + this.mStatsdSampleRate);
            pw.println("  compact_full_rss_throttle_kb=" + this.mFullAnonRssThrottleKb);
            pw.println("  compact_full_delta_rss_throttle_kb=" + this.mFullDeltaRssThrottleKb);
            pw.println("  compact_proc_state_throttle=" + Arrays.toString((Object[])this.mProcStateThrottle.toArray(new Integer[0])));
            pw.println("  " + this.mSomeCompactionCount + " some, " + this.mFullCompactionCount + " full, " + this.mPersistentCompactionCount + " persistent, " + this.mBfgsCompactionCount + " BFGS compactions.");
            pw.println("  Tracking last compaction stats for " + this.mLastCompactionStats.size() + " processes.");
        }
    }

    @GuardedBy(value={"mAm"})
    void compactAppSome(ProcessRecord app) {
        app.reqCompactAction = 1;
        this.mPendingCompactionProcesses.add(app);
        this.mCompactionHandler.sendMessage(this.mCompactionHandler.obtainMessage(1, app.setAdj, app.setProcState));
    }

    @GuardedBy(value={"mAm"})
    void compactAppFull(ProcessRecord app) {
        app.reqCompactAction = 2;
        this.mPendingCompactionProcesses.add(app);
        this.mCompactionHandler.sendMessage(this.mCompactionHandler.obtainMessage(1, app.setAdj, app.setProcState));
    }

    @GuardedBy(value={"mAm"})
    void compactAppPersistent(ProcessRecord app) {
        app.reqCompactAction = 3;
        this.mPendingCompactionProcesses.add(app);
        this.mCompactionHandler.sendMessage(this.mCompactionHandler.obtainMessage(1, app.curAdj, app.setProcState));
    }

    @GuardedBy(value={"mAm"})
    boolean shouldCompactPersistent(ProcessRecord app, long now) {
        return app.lastCompactTime == 0L || now - app.lastCompactTime > this.mCompactThrottlePersistent;
    }

    @GuardedBy(value={"mAm"})
    void compactAppBfgs(ProcessRecord app) {
        app.reqCompactAction = 4;
        this.mPendingCompactionProcesses.add(app);
        this.mCompactionHandler.sendMessage(this.mCompactionHandler.obtainMessage(1, app.curAdj, app.setProcState));
    }

    @GuardedBy(value={"mAm"})
    boolean shouldCompactBFGS(ProcessRecord app, long now) {
        return app.lastCompactTime == 0L || now - app.lastCompactTime > this.mCompactThrottleBFGS;
    }

    @GuardedBy(value={"mAm"})
    void compactAllSystem() {
        if (this.mUseCompaction) {
            this.mCompactionHandler.sendMessage(this.mCompactionHandler.obtainMessage(2));
        }
    }

    private native void compactSystem();

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateUseCompaction() {
        this.mUseCompaction = DeviceConfig.getBoolean("activity_manager", KEY_USE_COMPACTION, DEFAULT_USE_COMPACTION);
        if (this.mUseCompaction && !this.mCompactionThread.isAlive()) {
            this.mCompactionThread.start();
            this.mCompactionHandler = new MemCompactionHandler();
        }
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateCompactionActions() {
        int compactAction1 = DeviceConfig.getInt("activity_manager", KEY_COMPACT_ACTION_1, 1);
        int compactAction2 = DeviceConfig.getInt("activity_manager", KEY_COMPACT_ACTION_2, 3);
        this.mCompactActionSome = AppCompactor.compactActionIntToString(compactAction1);
        this.mCompactActionFull = AppCompactor.compactActionIntToString(compactAction2);
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateCompactionThrottles() {
        boolean useThrottleDefaults = false;
        String throttleSomeSomeFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_1);
        String throttleSomeFullFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_2);
        String throttleFullSomeFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_3);
        String throttleFullFullFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_4);
        String throttleBFGSFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_5);
        String throttlePersistentFlag = DeviceConfig.getProperty("activity_manager", KEY_COMPACT_THROTTLE_6);
        if (TextUtils.isEmpty(throttleSomeSomeFlag) || TextUtils.isEmpty(throttleSomeFullFlag) || TextUtils.isEmpty(throttleFullSomeFlag) || TextUtils.isEmpty(throttleFullFullFlag) || TextUtils.isEmpty(throttleBFGSFlag) || TextUtils.isEmpty(throttlePersistentFlag)) {
            useThrottleDefaults = true;
        } else {
            try {
                this.mCompactThrottleSomeSome = Integer.parseInt(throttleSomeSomeFlag);
                this.mCompactThrottleSomeFull = Integer.parseInt(throttleSomeFullFlag);
                this.mCompactThrottleFullSome = Integer.parseInt(throttleFullSomeFlag);
                this.mCompactThrottleFullFull = Integer.parseInt(throttleFullFullFlag);
                this.mCompactThrottleBFGS = Integer.parseInt(throttleBFGSFlag);
                this.mCompactThrottlePersistent = Integer.parseInt(throttlePersistentFlag);
            }
            catch (NumberFormatException e) {
                useThrottleDefaults = true;
            }
        }
        if (useThrottleDefaults) {
            this.mCompactThrottleSomeSome = 5000L;
            this.mCompactThrottleSomeFull = 10000L;
            this.mCompactThrottleFullSome = 500L;
            this.mCompactThrottleFullFull = 10000L;
            this.mCompactThrottleBFGS = 600000L;
            this.mCompactThrottlePersistent = 600000L;
        }
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateStatsdSampleRate() {
        this.mStatsdSampleRate = DeviceConfig.getFloat("activity_manager", KEY_COMPACT_STATSD_SAMPLE_RATE, 0.1f);
        this.mStatsdSampleRate = Math.min(1.0f, Math.max(0.0f, this.mStatsdSampleRate));
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateFullRssThrottle() {
        this.mFullAnonRssThrottleKb = DeviceConfig.getLong("activity_manager", KEY_COMPACT_FULL_RSS_THROTTLE_KB, 12000L);
        if (this.mFullAnonRssThrottleKb < 0L) {
            this.mFullAnonRssThrottleKb = 12000L;
        }
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateFullDeltaRssThrottle() {
        this.mFullDeltaRssThrottleKb = DeviceConfig.getLong("activity_manager", KEY_COMPACT_FULL_DELTA_RSS_THROTTLE_KB, 8000L);
        if (this.mFullDeltaRssThrottleKb < 0L) {
            this.mFullDeltaRssThrottleKb = 8000L;
        }
    }

    @GuardedBy(value={"mPhenotypeFlagLock"})
    private void updateProcStateThrottle() {
        String procStateThrottleString = DeviceConfig.getString("activity_manager", KEY_COMPACT_PROC_STATE_THROTTLE, DEFAULT_COMPACT_PROC_STATE_THROTTLE);
        if (!this.parseProcStateThrottle(procStateThrottleString)) {
            Slog.w("ActivityManager", "Unable to parse app compact proc state throttle \"" + procStateThrottleString + "\" falling back to default.");
            if (!this.parseProcStateThrottle(DEFAULT_COMPACT_PROC_STATE_THROTTLE)) {
                Slog.wtf("ActivityManager", "Unable to parse default app compact proc state throttle " + DEFAULT_COMPACT_PROC_STATE_THROTTLE);
            }
        }
    }

    private boolean parseProcStateThrottle(String procStateThrottleString) {
        String[] procStates = TextUtils.split(procStateThrottleString, ",");
        this.mProcStateThrottle.clear();
        for (String procState : procStates) {
            try {
                this.mProcStateThrottle.add(Integer.parseInt(procState));
            }
            catch (NumberFormatException e) {
                Slog.e("ActivityManager", "Failed to parse default app compaction proc state: " + procState);
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    static String compactActionIntToString(int action) {
        switch (action) {
            case 4: {
                return COMPACT_ACTION_NONE;
            }
            case 1: {
                return COMPACT_ACTION_FILE;
            }
            case 2: {
                return COMPACT_ACTION_ANON;
            }
            case 3: {
                return COMPACT_ACTION_FULL;
            }
        }
        return COMPACT_ACTION_NONE;
    }

    static /* synthetic */ ActivityManagerService access$1000(AppCompactor x0) {
        return x0.mAm;
    }

    static /* synthetic */ ArrayList access$1100(AppCompactor x0) {
        return x0.mPendingCompactionProcesses;
    }

    static /* synthetic */ Map access$1200(AppCompactor x0) {
        return x0.mLastCompactionStats;
    }

    static /* synthetic */ int access$1308(AppCompactor x0) {
        return x0.mSomeCompactionCount++;
    }

    static /* synthetic */ int access$1408(AppCompactor x0) {
        return x0.mFullCompactionCount++;
    }

    static /* synthetic */ int access$1508(AppCompactor x0) {
        return x0.mPersistentCompactionCount++;
    }

    static /* synthetic */ int access$1608(AppCompactor x0) {
        return x0.mBfgsCompactionCount++;
    }

    static /* synthetic */ Random access$1700(AppCompactor x0) {
        return x0.mRandom;
    }

    static /* synthetic */ void access$1800(AppCompactor x0) {
        x0.compactSystem();
    }

    private final class MemCompactionHandler
    extends Handler {
        private MemCompactionHandler() {
            super(AppCompactor.this.mCompactionThread.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    start = SystemClock.uptimeMillis();
                    lastOomAdj = msg.arg1;
                    procState = msg.arg2;
                    var15_5 = AppCompactor.access$1000(AppCompactor.this);
                    synchronized (var15_5) {
                        ActivityManagerService.boostPriorityForLockedSection();
                        proc = (ProcessRecord)AppCompactor.access$1100(AppCompactor.this).remove(0);
                        pendingAction = proc.reqCompactAction;
                        pid = proc.pid;
                        name = proc.processName;
                        if (pendingAction != 1 && pendingAction != 2 || proc.setAdj > 200) ** GOTO lbl-1000
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            lastCompactAction = proc.lastCompactAction;
                            lastCompactTime = proc.lastCompactTime;
                            lastCompactionStats = (LastCompactionStats)AppCompactor.access$1200(AppCompactor.this).remove(pid);
                        }
                        catch (Throwable var16_13) {
                            // MONITOREXIT @DISABLED, blocks:[21, 5, 7, 8] lbl25 : MonitorExitStatement: MONITOREXIT : var15_5
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw var16_13;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    if (pid == 0) {
                        return;
                    }
                    if (lastCompactTime != 0L && (pendingAction == 1 ? lastCompactAction == 1 && start - lastCompactTime < AppCompactor.this.mCompactThrottleSomeSome || lastCompactAction == 2 && start - lastCompactTime < AppCompactor.this.mCompactThrottleSomeFull : (pendingAction == 2 ? lastCompactAction == 1 && start - lastCompactTime < AppCompactor.this.mCompactThrottleFullSome || lastCompactAction == 2 && start - lastCompactTime < AppCompactor.this.mCompactThrottleFullFull : (pendingAction == 3 ? start - lastCompactTime < AppCompactor.this.mCompactThrottlePersistent : pendingAction == 4 && start - lastCompactTime < AppCompactor.this.mCompactThrottleBFGS)))) {
                        return;
                    }
                    switch (pendingAction) {
                        case 1: {
                            action = AppCompactor.this.mCompactActionSome;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            action = AppCompactor.this.mCompactActionFull;
                            break;
                        }
                        default: {
                            action = "";
                        }
                    }
                    if ("".equals(action)) {
                        return;
                    }
                    if (AppCompactor.this.mProcStateThrottle.contains(procState)) {
                        return;
                    }
                    rssBefore = Process.getRss(pid);
                    anonRssBefore = rssBefore[2];
                    if (rssBefore[0] == 0L && rssBefore[1] == 0L && rssBefore[2] == 0L && rssBefore[3] == 0L) {
                        return;
                    }
                    if (action.equals("all") || action.equals("anon")) {
                        if (AppCompactor.this.mFullAnonRssThrottleKb > 0L && anonRssBefore < AppCompactor.this.mFullAnonRssThrottleKb) {
                            return;
                        }
                        if (lastCompactionStats != null && AppCompactor.this.mFullDeltaRssThrottleKb > 0L && (absDelta = Math.abs(rssBefore[1] - (lastRss = lastCompactionStats.getRssAfterCompaction())[1]) + Math.abs(rssBefore[2] - lastRss[2]) + Math.abs(rssBefore[3] - lastRss[3])) <= AppCompactor.this.mFullDeltaRssThrottleKb) {
                            return;
                        }
                    }
                    switch (pendingAction) {
                        case 1: {
                            AppCompactor.access$1308(AppCompactor.this);
                            break;
                        }
                        case 2: {
                            AppCompactor.access$1408(AppCompactor.this);
                            break;
                        }
                        case 3: {
                            AppCompactor.access$1508(AppCompactor.this);
                            break;
                        }
                        case 4: {
                            AppCompactor.access$1608(AppCompactor.this);
                            break;
                        }
                    }
                    try {
                        Trace.traceBegin(64L, "Compact " + (pendingAction == 1 ? "some" : "full") + ": " + name);
                        zramFreeKbBefore = Debug.getZramFreeKb();
                        fos = new FileOutputStream("/proc/" + pid + "/reclaim");
                        fos.write(action.getBytes());
                        fos.close();
                        rssAfter = Process.getRss(pid);
                        end = SystemClock.uptimeMillis();
                        time = end - start;
                        zramFreeKbAfter = Debug.getZramFreeKb();
                        EventLog.writeEvent(30063, new Object[]{pid, name, action, rssBefore[0], rssBefore[1], rssBefore[2], rssBefore[3], rssAfter[0] - rssBefore[0], rssAfter[1] - rssBefore[1], rssAfter[2] - rssBefore[2], rssAfter[3] - rssBefore[3], time, lastCompactAction, lastCompactTime, lastOomAdj, procState, zramFreeKbBefore, zramFreeKbAfter - zramFreeKbBefore});
                        if (AppCompactor.access$1700(AppCompactor.this).nextFloat() < AppCompactor.this.mStatsdSampleRate) {
                            StatsLog.write(115, pid, name, pendingAction, rssBefore[0], rssBefore[1], rssBefore[2], rssBefore[3], rssAfter[0], rssAfter[1], rssAfter[2], rssAfter[3], time, lastCompactAction, lastCompactTime, lastOomAdj, ActivityManager.processStateAmToProto(procState), zramFreeKbBefore, zramFreeKbAfter);
                        }
                        var28_25 = AppCompactor.access$1000(AppCompactor.this);
                        synchronized (var28_25) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                proc.lastCompactTime = end;
                                proc.lastCompactAction = pendingAction;
                            }
                            catch (Throwable var29_26) {
                                // MONITOREXIT @DISABLED, blocks:[2, 6, 22, 7, 8] lbl97 : MonitorExitStatement: MONITOREXIT : var28_25
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw var29_26;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        if (!action.equals("all") && !action.equals("anon")) break;
                        AppCompactor.access$1200(AppCompactor.this).put(pid, new LastCompactionStats(rssAfter));
                        break;
                    }
                    catch (Exception var18_18) {
                        break;
                    }
                    finally {
                        Trace.traceEnd(64L);
                    }
                }
                case 2: {
                    Trace.traceBegin(64L, "compactSystem");
                    AppCompactor.access$1800(AppCompactor.this);
                    Trace.traceEnd(64L);
                }
            }
        }
    }

    private static final class LastCompactionStats {
        private final long[] mRssAfterCompaction;

        LastCompactionStats(long[] rss) {
            this.mRssAfterCompaction = rss;
        }

        long[] getRssAfterCompaction() {
            return this.mRssAfterCompaction;
        }
    }

    @VisibleForTesting
    static interface PropertyChangedCallbackForTest {
        public void onPropertyChanged();
    }
}

