/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.BidiFormatter;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.internal.logging.MetricsLogger;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class AppNotRespondingDialog
extends BaseErrorDialog
implements View.OnClickListener {
    private static final String TAG = "AppNotRespondingDialog";
    static final int FORCE_CLOSE = 1;
    static final int WAIT = 2;
    static final int WAIT_AND_REPORT = 3;
    public static final int CANT_SHOW = -1;
    public static final int ALREADY_SHOWING = -2;
    private final ActivityManagerService mService;
    private final ProcessRecord mProc;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            Intent appErrorIntent = null;
            MetricsLogger.action(AppNotRespondingDialog.this.getContext(), 317, msg.what);
            switch (msg.what) {
                case 1: {
                    AppNotRespondingDialog.this.mService.killAppAtUsersRequest(AppNotRespondingDialog.this.mProc, AppNotRespondingDialog.this);
                    break;
                }
                case 2: 
                case 3: {
                    ActivityManagerService activityManagerService = AppNotRespondingDialog.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ProcessRecord app = AppNotRespondingDialog.this.mProc;
                            if (msg.what == 3) {
                                appErrorIntent = ((AppNotRespondingDialog)AppNotRespondingDialog.this).mService.mAppErrors.createAppErrorIntentLocked(app, System.currentTimeMillis(), null);
                            }
                            app.setNotResponding(false);
                            app.notRespondingReport = null;
                            if (app.anrDialog == AppNotRespondingDialog.this) {
                                app.anrDialog = null;
                            }
                            ((AppNotRespondingDialog)AppNotRespondingDialog.this).mService.mServices.scheduleServiceTimeoutLocked(app);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[2, 3, 5, 7] lbl23 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    break;
                }
            }
            if (appErrorIntent != null) {
                try {
                    AppNotRespondingDialog.this.getContext().startActivity(appErrorIntent);
                }
                catch (ActivityNotFoundException e) {
                    Slog.w(AppNotRespondingDialog.TAG, "bug report receiver dissappeared", e);
                }
            }
            AppNotRespondingDialog.this.dismiss();
        }
    };

    public AppNotRespondingDialog(ActivityManagerService service, Context context, Data data) {
        super(context);
        int resid;
        this.mService = service;
        this.mProc = data.proc;
        Resources res = context.getResources();
        this.setCancelable(false);
        CharSequence name1 = data.aInfo != null ? data.aInfo.loadLabel(context.getPackageManager()) : null;
        CharSequence name2 = null;
        if (this.mProc.pkgList.size() == 1 && (name2 = context.getPackageManager().getApplicationLabel(this.mProc.info)) != null) {
            if (name1 != null) {
                resid = 17039497;
            } else {
                name1 = name2;
                name2 = this.mProc.processName;
                resid = 17039499;
            }
        } else if (name1 != null) {
            name2 = this.mProc.processName;
            resid = 17039498;
        } else {
            name1 = this.mProc.processName;
            resid = 17039500;
        }
        BidiFormatter bidi = BidiFormatter.getInstance();
        this.setTitle(name2 != null ? res.getString(resid, bidi.unicodeWrap(name1.toString()), bidi.unicodeWrap(name2.toString())) : res.getString(resid, bidi.unicodeWrap(name1.toString())));
        if (data.aboveSystem) {
            this.getWindow().setType(2010);
        }
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Application Not Responding: " + this.mProc.info.processName);
        attrs.privateFlags = 272;
        this.getWindow().setAttributes(attrs);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout frame = (FrameLayout)this.findViewById(16908331);
        Context context = this.getContext();
        LayoutInflater.from(context).inflate(17367092, (ViewGroup)frame, true);
        TextView report = (TextView)this.findViewById(16908706);
        report.setOnClickListener(this);
        boolean hasReceiver = this.mProc.errorReportReceiver != null;
        report.setVisibility(hasReceiver ? 0 : 8);
        TextView close = (TextView)this.findViewById(16908704);
        close.setOnClickListener(this);
        TextView wait = (TextView)this.findViewById(16908708);
        wait.setOnClickListener(this);
        ((View)this.findViewById(16908853)).setVisibility(0);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case 16908706: {
                this.mHandler.obtainMessage(3).sendToTarget();
                break;
            }
            case 16908704: {
                this.mHandler.obtainMessage(1).sendToTarget();
                break;
            }
            case 16908708: {
                this.mHandler.obtainMessage(2).sendToTarget();
                break;
            }
        }
    }

    static class Data {
        final ProcessRecord proc;
        final ApplicationInfo aInfo;
        final boolean aboveSystem;

        Data(ProcessRecord proc, ApplicationInfo aInfo, boolean aboveSystem) {
            this.proc = proc;
            this.aInfo = aInfo;
            this.aboveSystem = aboveSystem;
        }
    }
}

