/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityTaskManager;
import android.app.AppOpsManager;
import android.app.IActivityTaskManager;
import android.app.IAssistDataReceiver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AssistDataRequester
extends IAssistDataReceiver.Stub {
    public static final String KEY_RECEIVER_EXTRA_COUNT = "count";
    public static final String KEY_RECEIVER_EXTRA_INDEX = "index";
    private IWindowManager mWindowManager;
    @VisibleForTesting
    public IActivityTaskManager mActivityTaskManager;
    private Context mContext;
    private AppOpsManager mAppOpsManager;
    private AssistDataRequesterCallbacks mCallbacks;
    private Object mCallbacksLock;
    private int mRequestStructureAppOps;
    private int mRequestScreenshotAppOps;
    private boolean mCanceled;
    private int mPendingDataCount;
    private int mPendingScreenshotCount;
    private final ArrayList<Bundle> mAssistData = new ArrayList();
    private final ArrayList<Bitmap> mAssistScreenshot = new ArrayList();

    public AssistDataRequester(Context context, IWindowManager windowManager, AppOpsManager appOpsManager, AssistDataRequesterCallbacks callbacks, Object callbacksLock, int requestStructureAppOps, int requestScreenshotAppOps) {
        this.mCallbacks = callbacks;
        this.mCallbacksLock = callbacksLock;
        this.mWindowManager = windowManager;
        this.mActivityTaskManager = ActivityTaskManager.getService();
        this.mContext = context;
        this.mAppOpsManager = appOpsManager;
        this.mRequestStructureAppOps = requestStructureAppOps;
        this.mRequestScreenshotAppOps = requestScreenshotAppOps;
    }

    public void requestAutofillData(List<IBinder> activityTokens, int callingUid, String callingPackage) {
        this.requestData(activityTokens, true, true, false, true, false, callingUid, callingPackage);
    }

    public void requestAssistData(List<IBinder> activityTokens, boolean fetchData, boolean fetchScreenshot, boolean allowFetchData, boolean allowFetchScreenshot, int callingUid, String callingPackage) {
        this.requestData(activityTokens, false, fetchData, fetchScreenshot, allowFetchData, allowFetchScreenshot, callingUid, callingPackage);
    }

    private void requestData(List<IBinder> activityTokens, boolean requestAutofillData, boolean fetchData, boolean fetchScreenshot, boolean allowFetchData, boolean allowFetchScreenshot, int callingUid, String callingPackage) {
        if (activityTokens.isEmpty()) {
            this.tryDispatchRequestComplete();
            return;
        }
        boolean isAssistDataAllowed = false;
        try {
            isAssistDataAllowed = this.mActivityTaskManager.isAssistDataAllowedOnCurrentActivity();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        allowFetchData &= isAssistDataAllowed;
        allowFetchScreenshot &= fetchData && isAssistDataAllowed && this.mRequestScreenshotAppOps != -1;
        this.mCanceled = false;
        this.mPendingDataCount = 0;
        this.mPendingScreenshotCount = 0;
        this.mAssistData.clear();
        this.mAssistScreenshot.clear();
        if (fetchData) {
            if (this.mAppOpsManager.checkOpNoThrow(this.mRequestStructureAppOps, callingUid, callingPackage) == 0 && allowFetchData) {
                int numActivities = activityTokens.size();
                for (int i = 0; i < numActivities; ++i) {
                    IBinder topActivity = activityTokens.get(i);
                    try {
                        boolean result;
                        MetricsLogger.count(this.mContext, "assist_with_context", 1);
                        Bundle receiverExtras = new Bundle();
                        receiverExtras.putInt(KEY_RECEIVER_EXTRA_INDEX, i);
                        receiverExtras.putInt(KEY_RECEIVER_EXTRA_COUNT, numActivities);
                        boolean bl = requestAutofillData ? this.mActivityTaskManager.requestAutofillData(this, receiverExtras, topActivity, 0) : (result = this.mActivityTaskManager.requestAssistContextExtras(1, this, receiverExtras, topActivity, i == 0, i == 0));
                        if (result) {
                            ++this.mPendingDataCount;
                            continue;
                        }
                        if (i != 0) continue;
                        if (this.mCallbacks.canHandleReceivedAssistDataLocked()) {
                            this.dispatchAssistDataReceived(null);
                        } else {
                            this.mAssistData.add(null);
                        }
                        allowFetchScreenshot = false;
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            } else {
                if (this.mCallbacks.canHandleReceivedAssistDataLocked()) {
                    this.dispatchAssistDataReceived(null);
                } else {
                    this.mAssistData.add(null);
                }
                allowFetchScreenshot = false;
            }
        }
        if (fetchScreenshot) {
            if (this.mAppOpsManager.checkOpNoThrow(this.mRequestScreenshotAppOps, callingUid, callingPackage) == 0 && allowFetchScreenshot) {
                try {
                    MetricsLogger.count(this.mContext, "assist_with_screen", 1);
                    ++this.mPendingScreenshotCount;
                    this.mWindowManager.requestAssistScreenshot(this);
                }
                catch (RemoteException remoteException) {}
            } else if (this.mCallbacks.canHandleReceivedAssistDataLocked()) {
                this.dispatchAssistScreenshotReceived(null);
            } else {
                this.mAssistScreenshot.add(null);
            }
        }
        this.tryDispatchRequestComplete();
    }

    public void processPendingAssistData() {
        this.flushPendingAssistData();
        this.tryDispatchRequestComplete();
    }

    private void flushPendingAssistData() {
        int dataCount = this.mAssistData.size();
        for (int i = 0; i < dataCount; ++i) {
            this.dispatchAssistDataReceived(this.mAssistData.get(i));
        }
        this.mAssistData.clear();
        int screenshotsCount = this.mAssistScreenshot.size();
        for (int i = 0; i < screenshotsCount; ++i) {
            this.dispatchAssistScreenshotReceived(this.mAssistScreenshot.get(i));
        }
        this.mAssistScreenshot.clear();
    }

    public int getPendingDataCount() {
        return this.mPendingDataCount;
    }

    public int getPendingScreenshotCount() {
        return this.mPendingScreenshotCount;
    }

    public void cancel() {
        this.mCanceled = true;
        this.mPendingDataCount = 0;
        this.mPendingScreenshotCount = 0;
        this.mAssistData.clear();
        this.mAssistScreenshot.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHandleAssistData(Bundle data) {
        Object object = this.mCallbacksLock;
        synchronized (object) {
            if (this.mCanceled) {
                return;
            }
            --this.mPendingDataCount;
            if (this.mCallbacks.canHandleReceivedAssistDataLocked()) {
                this.flushPendingAssistData();
                this.dispatchAssistDataReceived(data);
                this.tryDispatchRequestComplete();
            } else {
                this.mAssistData.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHandleAssistScreenshot(Bitmap screenshot) {
        Object object = this.mCallbacksLock;
        synchronized (object) {
            if (this.mCanceled) {
                return;
            }
            --this.mPendingScreenshotCount;
            if (this.mCallbacks.canHandleReceivedAssistDataLocked()) {
                this.flushPendingAssistData();
                this.dispatchAssistScreenshotReceived(screenshot);
                this.tryDispatchRequestComplete();
            } else {
                this.mAssistScreenshot.add(screenshot);
            }
        }
    }

    private void dispatchAssistDataReceived(Bundle data) {
        Bundle receiverExtras;
        int activityIndex = 0;
        int activityCount = 0;
        Bundle bundle = receiverExtras = data != null ? data.getBundle("receiverExtras") : null;
        if (receiverExtras != null) {
            activityIndex = receiverExtras.getInt(KEY_RECEIVER_EXTRA_INDEX);
            activityCount = receiverExtras.getInt(KEY_RECEIVER_EXTRA_COUNT);
        }
        this.mCallbacks.onAssistDataReceivedLocked(data, activityIndex, activityCount);
    }

    private void dispatchAssistScreenshotReceived(Bitmap screenshot) {
        this.mCallbacks.onAssistScreenshotReceivedLocked(screenshot);
    }

    private void tryDispatchRequestComplete() {
        if (this.mPendingDataCount == 0 && this.mPendingScreenshotCount == 0 && this.mAssistData.isEmpty() && this.mAssistScreenshot.isEmpty()) {
            this.mCallbacks.onAssistRequestCompleted();
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mPendingDataCount=");
        pw.println(this.mPendingDataCount);
        pw.print(prefix);
        pw.print("mAssistData=");
        pw.println(this.mAssistData);
        pw.print(prefix);
        pw.print("mPendingScreenshotCount=");
        pw.println(this.mPendingScreenshotCount);
        pw.print(prefix);
        pw.print("mAssistScreenshot=");
        pw.println(this.mAssistScreenshot);
    }

    public static interface AssistDataRequesterCallbacks {
        @GuardedBy(value={"mCallbacksLock"})
        public boolean canHandleReceivedAssistDataLocked();

        @GuardedBy(value={"mCallbacksLock"})
        default public void onAssistDataReceivedLocked(Bundle data, int activityIndex, int activityCount) {
        }

        @GuardedBy(value={"mCallbacksLock"})
        default public void onAssistScreenshotReceivedLocked(Bitmap screenshot) {
        }

        @GuardedBy(value={"mCallbacksLock"})
        default public void onAssistRequestCompleted() {
        }
    }
}

