/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.BatteryStats;
import android.os.BatteryStatsInternal;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelFormatException;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.WorkSource;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.GpsBatteryStats;
import android.os.connectivity.WifiBatteryStats;
import android.os.health.HealthStatsParceler;
import android.os.health.HealthStatsWriter;
import android.os.health.UidHealthStats;
import android.provider.Settings;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.RailStats;
import com.android.internal.os.RpmStats;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.ParseUtils;
import com.android.server.LocalServices;
import com.android.server.am.BatteryExternalStatsWorker;
import com.android.server.am.HealthStatsBatteryStatsWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class BatteryStatsService
extends IBatteryStats.Stub
implements PowerManagerInternal.LowPowerModeListener,
BatteryStatsImpl.PlatformIdleStateCallback,
BatteryStatsImpl.RailEnergyDataCallback {
    static final String TAG = "BatteryStatsService";
    static final boolean DBG = false;
    private static IBatteryStats sService;
    final BatteryStatsImpl mStats;
    private final BatteryStatsImpl.UserInfoProvider mUserManagerUserInfoProvider;
    private final Context mContext;
    private final BatteryExternalStatsWorker mWorker;
    private CharsetDecoder mDecoderStat = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
    private ByteBuffer mUtf8BufferStat = ByteBuffer.allocateDirect(2048);
    private CharBuffer mUtf16BufferStat = CharBuffer.allocate(2048);
    private static final int MAX_LOW_POWER_STATS_SIZE = 2048;

    private native void getLowPowerStats(RpmStats var1);

    private native int getPlatformLowPowerStats(ByteBuffer var1);

    private native int getSubsystemLowPowerStats(ByteBuffer var1);

    private native void getRailEnergyPowerStats(RailStats var1);

    @Override
    public void fillLowPowerStats(RpmStats rpmStats) {
        this.getLowPowerStats(rpmStats);
    }

    @Override
    public void fillRailDataStats(RailStats railStats) {
        this.getRailEnergyPowerStats(railStats);
    }

    @Override
    public String getPlatformLowPowerStats() {
        int bytesWritten;
        block5: {
            block4: {
                this.mUtf8BufferStat.clear();
                this.mUtf16BufferStat.clear();
                this.mDecoderStat.reset();
                bytesWritten = this.getPlatformLowPowerStats(this.mUtf8BufferStat);
                if (bytesWritten >= 0) break block4;
                String string2 = null;
                return string2;
            }
            if (bytesWritten != 0) break block5;
            String string3 = "Empty";
            return string3;
        }
        this.mUtf8BufferStat.limit(bytesWritten);
        this.mDecoderStat.decode(this.mUtf8BufferStat, this.mUtf16BufferStat, true);
        this.mUtf16BufferStat.flip();
        String string4 = this.mUtf16BufferStat.toString();
        return string4;
    }

    @Override
    public String getSubsystemLowPowerStats() {
        int bytesWritten;
        block5: {
            block4: {
                this.mUtf8BufferStat.clear();
                this.mUtf16BufferStat.clear();
                this.mDecoderStat.reset();
                bytesWritten = this.getSubsystemLowPowerStats(this.mUtf8BufferStat);
                if (bytesWritten >= 0) break block4;
                String string2 = null;
                return string2;
            }
            if (bytesWritten != 0) break block5;
            String string3 = "Empty";
            return string3;
        }
        this.mUtf8BufferStat.limit(bytesWritten);
        this.mDecoderStat.decode(this.mUtf8BufferStat, this.mUtf16BufferStat, true);
        this.mUtf16BufferStat.flip();
        String string4 = this.mUtf16BufferStat.toString();
        return string4;
    }

    BatteryStatsService(Context context, File systemDir, Handler handler) {
        this.mContext = context;
        this.mUserManagerUserInfoProvider = new BatteryStatsImpl.UserInfoProvider(){
            private UserManagerInternal umi;

            @Override
            public int[] getUserIds() {
                if (this.umi == null) {
                    this.umi = LocalServices.getService(UserManagerInternal.class);
                }
                return this.umi != null ? this.umi.getUserIds() : null;
            }
        };
        this.mStats = new BatteryStatsImpl(systemDir, handler, this, this, this.mUserManagerUserInfoProvider);
        this.mWorker = new BatteryExternalStatsWorker(context, this.mStats);
        this.mStats.setExternalStatsSyncLocked(this.mWorker);
        this.mStats.setRadioScanningTimeoutLocked((long)this.mContext.getResources().getInteger(17694875) * 1000L);
        this.mStats.setPowerProfileLocked(new PowerProfile(context));
    }

    public void publish() {
        LocalServices.addService(BatteryStatsInternal.class, new LocalService());
        ServiceManager.addService("batterystats", this.asBinder());
    }

    public void systemServicesReady() {
        this.mStats.systemServicesReady(this.mContext);
    }

    private static void awaitUninterruptibly(Future<?> future) {
        while (true) {
            try {
                future.get();
                return;
            }
            catch (ExecutionException e) {
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void syncStats(String reason, int flags) {
        BatteryStatsService.awaitUninterruptibly(this.mWorker.scheduleSync(reason, flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPowerManagement() {
        PowerManagerInternal powerMgr = LocalServices.getService(PowerManagerInternal.class);
        powerMgr.registerLowPowerModeObserver(this);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePowerSaveModeLocked(powerMgr.getLowPowerState((int)9).batterySaverEnabled);
        }
        new WakeupReasonThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w("BatteryStats", "Writing battery stats before shutdown...");
        this.syncStats("shutdown", 31);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.shutdownLocked();
        }
        this.mWorker.shutdown();
    }

    public static IBatteryStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("batterystats");
        sService = BatteryStatsService.asInterface(b);
        return sService;
    }

    @Override
    public int getServiceType() {
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLowPowerModeChanged(PowerSaveState result) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePowerSaveModeLocked(result.batterySaverEnabled);
        }
    }

    public BatteryStatsImpl getActiveStatistics() {
        return this.mStats;
    }

    public void scheduleWriteToDisk() {
        this.mWorker.scheduleWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUid(int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.removeUidStatsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCleanupUser(int userId) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.onCleanupUserLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserRemoved(int userId) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.onUserRemovedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.addIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.scheduleRemoveIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessStart(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStartLocked(name, uid);
            StatsLog.write(28, uid, name, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessCrash(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessCrashLocked(name, uid);
            StatsLog.write(28, uid, name, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessAnr(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessAnrLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessFinish(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessFinishLocked(name, uid);
            StatsLog.write(28, uid, name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteUidProcessState(int uid, int state) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            StatsLog.write(27, uid, ActivityManager.processStateAmToProto(state));
            this.mStats.noteUidProcessStateLocked(uid, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getStatistics() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.syncStats("get-stats", 31);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getStatisticsStream() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.syncStats("get-stats", 31);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        try {
            return ParcelFileDescriptor.fromData(data, "battery-stats");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to create shared memory", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCharging() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.isCharging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeBatteryTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeChargeTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteEvent(int code, String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteEventLocked(code, name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncStartLocked(name, uid);
            StatsLog.write_non_chained(7, uid, null, name, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncFinishLocked(name, uid);
            StatsLog.write_non_chained(7, uid, null, name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobStart(String name, int uid, int standbyBucket, int jobid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobStartLocked(name, uid);
            StatsLog.write_non_chained(8, uid, null, name, 1, -1, standbyBucket, jobid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobFinish(String name, int uid, int stopReason, int standbyBucket, int jobid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobFinishLocked(name, uid, stopReason);
            StatsLog.write_non_chained(8, uid, null, name, 0, stopReason, standbyBucket, jobid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteJobsDeferred(int uid, int numDeferred, long sinceLast) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobsDeferredLocked(uid, numDeferred, sinceLast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWakupAlarm(String name, int uid, WorkSource workSource, String tag) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWakupAlarmLocked(name, uid, workSource, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmStart(String name, WorkSource workSource, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmStartLocked(name, workSource, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmFinish(String name, WorkSource workSource, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmFinishLocked(name, workSource, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeLocked(uid, pid, null, name, historyName, type, unimportantForLogging, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeLocked(uid, pid, null, name, historyName, type, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeFromSourceLocked(ws, pid, name, historyName, type, unimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteChangeWakelockFromSourceLocked(ws, pid, name, historyName, type, newWs, newPid, newName, newHistoryName, newType, newUnimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeFromSourceLocked(ws, pid, name, historyName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockStart(String name, String historyName, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockStart(name, historyName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockStartFromSource(name, historyName, workSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockFinish(String name, String historyName, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockFinish(name, historyName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLongPartialWakelockFinishFromSource(name, historyName, workSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartSensorLocked(uid, sensor);
            StatsLog.write_non_chained(5, uid, null, sensor, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopSensorLocked(uid, sensor);
            StatsLog.write_non_chained(5, uid, null, sensor, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOn(int uid, long durationMillis) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOnLocked(uid, durationMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteGpsChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteGpsChangedLocked(oldWs, newWs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteGpsSignalQuality(int signalLevel) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteGpsSignalQualityLocked(signalLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenState(int state) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            StatsLog.write(29, state);
            this.mStats.noteScreenStateLocked(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenBrightness(int brightness) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            StatsLog.write(9, brightness);
            this.mStats.noteScreenBrightnessLocked(brightness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteUserActivity(int uid, int event) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUserActivityLocked(uid, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeUp(String reason, int reasonUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWakeUpLocked(reason, reasonUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteInteractive(boolean interactive) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteInteractiveLocked(interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteConnectivityChanged(int type, String extra) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteConnectivityChangedLocked(type, extra);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteMobileRadioPowerState(int powerState, long timestampNs, int uid) {
        boolean update;
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            update = this.mStats.noteMobileRadioPowerStateLocked(powerState, timestampNs, uid);
        }
        if (update) {
            this.mWorker.scheduleSync("modem-data", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneSignalStrength(SignalStrength signalStrength) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneSignalStrengthLocked(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneDataConnectionState(int dataType, boolean hasData) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneDataConnectionStateLocked(dataType, hasData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneState(int state) {
        this.enforceCallingPermission();
        int simState = TelephonyManager.getDefault().getSimState();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneStateLocked(state, simState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOnLocked();
        }
        StatsLog.write(113, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOffLocked();
        }
        StatsLog.write(113, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartAudio(int uid) {
        this.enforceSelfOrCallingPermission(uid);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOnLocked(uid);
            StatsLog.write_non_chained(23, uid, null, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopAudio(int uid) {
        this.enforceSelfOrCallingPermission(uid);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOffLocked(uid);
            StatsLog.write_non_chained(23, uid, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartVideo(int uid) {
        this.enforceSelfOrCallingPermission(uid);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOnLocked(uid);
            StatsLog.write_non_chained(24, uid, null, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopVideo(int uid) {
        this.enforceSelfOrCallingPermission(uid);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOffLocked(uid);
            StatsLog.write_non_chained(24, uid, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetAudio() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetAudioLocked();
            StatsLog.write_non_chained(23, -1, null, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetVideo() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetVideoLocked();
            StatsLog.write_non_chained(24, -1, null, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOn(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOnLocked(uid);
            StatsLog.write_non_chained(26, uid, null, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOffLocked(uid);
            StatsLog.write_non_chained(26, uid, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOnLocked(uid);
            StatsLog.write_non_chained(25, uid, null, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOffLocked(uid);
            StatsLog.write_non_chained(25, uid, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetCamera() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetCameraLocked();
            StatsLog.write_non_chained(25, -1, null, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetFlashlight() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetFlashlightLocked();
            StatsLog.write_non_chained(26, -1, null, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRadioPowerState(int powerState, long tsNanos, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            if (this.mStats.isOnBattery()) {
                String type = powerState == 3 || powerState == 2 ? "active" : "inactive";
                this.mWorker.scheduleSync("wifi-data: " + type, 2);
            }
            this.mStats.noteWifiRadioPowerState(powerState, tsNanos, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunning(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningLocked(ws);
        }
        StatsLog.write(114, ws, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningChangedLocked(oldWs, newWs);
        }
        StatsLog.write(114, newWs, 1);
        StatsLog.write(114, oldWs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStoppedLocked(ws);
        }
        StatsLog.write(114, ws, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiState(int wifiState, String accessPoint) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStateLocked(wifiState, accessPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiSupplicantStateChangedLocked(supplState, failedAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRssiChanged(int newRssi) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRssiChangedLocked(newRssi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStarted(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStopped(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStartedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStartedFromSourceLocked(ws, csph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkInterfaceType(String iface, int networkType) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkInterfaceTypeLocked(iface, networkType);
        }
    }

    @Override
    public void noteNetworkStatsEnabled() {
        this.enforceCallingPermission();
        this.mWorker.scheduleSync("network-stats-enabled", 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteDeviceIdleMode(int mode, String activeReason, int activeUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteDeviceIdleModeLocked(mode, activeReason, activeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageInstalled(String pkgName, long versionCode) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageInstalledLocked(pkgName, versionCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageUninstalled(String pkgName) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageUninstalledLocked(pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanStarted(WorkSource ws, boolean isUnoptimized) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanStartedFromSourceLocked(ws, isUnoptimized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanStopped(WorkSource ws, boolean isUnoptimized) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanStoppedFromSourceLocked(ws, isUnoptimized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetBleScan() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetBluetoothScanLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBleScanResults(WorkSource ws, int numNewResults) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothScanResultsFromSourceLocked(ws, numNewResults);
        }
    }

    @Override
    public void noteWifiControllerActivity(WifiActivityEnergyInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid wifi data given: " + info);
            return;
        }
        this.mStats.updateWifiState(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBluetoothControllerActivity(BluetoothActivityEnergyInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid bluetooth data given: " + info);
            return;
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.updateBluetoothStateLocked(info);
        }
    }

    @Override
    public void noteModemControllerActivity(ModemActivityInfo info) {
        this.enforceCallingPermission();
        if (info == null || !info.isValid()) {
            Slog.e(TAG, "invalid modem data given: " + info);
            return;
        }
        this.mStats.updateMobileRadioState(info);
    }

    public boolean isOnBattery() {
        return this.mStats.isOnBattery();
    }

    @Override
    public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt, int chargeUAh, int chargeFullUAh) {
        this.enforceCallingPermission();
        this.mWorker.scheduleRunnable(() -> {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                boolean onBattery = BatteryStatsImpl.isOnBattery(plugType, status);
                if (this.mStats.isOnBattery() == onBattery) {
                    this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt, chargeUAh, chargeFullUAh);
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var9_9
                this.mWorker.scheduleSync("battery-state", 31);
            }
            this.mWorker.scheduleRunnable(() -> {
                BatteryStatsImpl batteryStatsImpl = this.mStats;
                synchronized (batteryStatsImpl) {
                    this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt, chargeUAh, chargeFullUAh);
                }
            });
        });
    }

    @Override
    public long getAwakeTimeBattery() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimeBattery();
    }

    @Override
    public long getAwakeTimePlugged() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimePlugged();
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private void enforceSelfOrCallingPermission(int uid) {
        if (Binder.getCallingUid() == uid) {
            return;
        }
        this.enforceCallingPermission();
    }

    private static native int nativeWaitWakeup(ByteBuffer var0);

    private void dumpHelp(PrintWriter pw) {
        pw.println("Battery stats (batterystats) dump options:");
        pw.println("  [--checkin] [--proto] [--history] [--history-start] [--charged] [-c]");
        pw.println("  [--daily] [--reset] [--write] [--new-daily] [--read-daily] [-h] [<package.name>]");
        pw.println("  --checkin: generate output for a checkin report; will write (and clear) the");
        pw.println("             last old completed stats when they had been reset.");
        pw.println("  -c: write the current stats in checkin format.");
        pw.println("  --proto: write the current aggregate stats (without history) in proto format.");
        pw.println("  --history: show only history data.");
        pw.println("  --history-start <num>: show only history data starting at given time offset.");
        pw.println("  --history-create-events <num>: create <num> of battery history events.");
        pw.println("  --charged: only output data since last charged.");
        pw.println("  --daily: only output full daily data.");
        pw.println("  --reset: reset the stats, clearing all current data.");
        pw.println("  --write: force write current collected stats to disk.");
        pw.println("  --new-daily: immediately create and write new daily stats record.");
        pw.println("  --read-daily: read-load last written daily stats.");
        pw.println("  --settings: dump the settings key/values related to batterystats");
        pw.println("  --cpu: dump cpu stats for debugging purpose");
        pw.println("  <package.name>: optional name of package to filter output by.");
        pw.println("  -h: print this help text.");
        pw.println("Battery stats (batterystats) commands:");
        pw.println("  enable|disable <option>");
        pw.println("    Enable or disable a running option.  Option state is not saved across boots.");
        pw.println("    Options are:");
        pw.println("      full-history: include additional detailed events in battery history:");
        pw.println("          wake_lock_in, alarms and proc events");
        pw.println("      no-auto-reset: don't automatically reset stats when unplugged");
        pw.println("      pretend-screen-off: pretend the screen is off, even if screen state changes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSettings(PrintWriter pw) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpConstantsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCpuStats(PrintWriter pw) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpCpuStatsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnableOrDisable(PrintWriter pw, int i, String[] args, boolean enable) {
        if (++i >= args.length) {
            pw.println("Missing option argument for " + (enable ? "--enable" : "--disable"));
            this.dumpHelp(pw);
            return -1;
        }
        if ("full-wake-history".equals(args[i]) || "full-history".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setRecordAllHistoryLocked(enable);
            }
        } else if ("no-auto-reset".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setNoAutoReset(enable);
            }
        } else if ("pretend-screen-off".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setPretendScreenOff(enable);
            }
        } else {
            pw.println("Unknown enable/disable option: " + args[i]);
            this.dumpHelp(pw);
            return -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int reqUid;
        long historyStart;
        boolean writeData;
        int flags;
        block80: {
            Object object;
            List<ApplicationInfo> apps;
            block81: {
                byte[] raw2;
                boolean isRealCheckin;
                boolean useCheckinFormat;
                block78: {
                    Object object2;
                    List<ApplicationInfo> apps2;
                    block79: {
                        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
                            return;
                        }
                        flags = 0;
                        useCheckinFormat = false;
                        boolean toProto = false;
                        isRealCheckin = false;
                        boolean noOutput = false;
                        writeData = false;
                        historyStart = -1L;
                        reqUid = -1;
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                String arg = args[i];
                                if ("--checkin".equals(arg)) {
                                    useCheckinFormat = true;
                                    isRealCheckin = true;
                                    continue;
                                }
                                if ("--history".equals(arg)) {
                                    flags |= 8;
                                    continue;
                                }
                                if ("--history-start".equals(arg)) {
                                    flags |= 8;
                                    if (++i >= args.length) {
                                        pw.println("Missing time argument for --history-since");
                                        this.dumpHelp(pw);
                                        return;
                                    }
                                    historyStart = ParseUtils.parseLong(args[i], 0L);
                                    writeData = true;
                                    continue;
                                }
                                if ("--history-create-events".equals(arg)) {
                                    if (++i >= args.length) {
                                        pw.println("Missing events argument for --history-create-events");
                                        this.dumpHelp(pw);
                                        return;
                                    }
                                    long events = ParseUtils.parseLong(args[i], 0L);
                                    BatteryStatsImpl batteryStatsImpl = this.mStats;
                                    synchronized (batteryStatsImpl) {
                                        this.mStats.createFakeHistoryEvents(events);
                                        pw.println("Battery history create events started.");
                                        noOutput = true;
                                        continue;
                                    }
                                }
                                if ("-c".equals(arg)) {
                                    useCheckinFormat = true;
                                    flags |= 0x10;
                                    continue;
                                }
                                if ("--proto".equals(arg)) {
                                    toProto = true;
                                    continue;
                                }
                                if ("--charged".equals(arg)) {
                                    flags |= 2;
                                    continue;
                                }
                                if ("--daily".equals(arg)) {
                                    flags |= 4;
                                    continue;
                                }
                                if ("--reset".equals(arg)) {
                                    BatteryStatsImpl events = this.mStats;
                                    synchronized (events) {
                                        this.mStats.resetAllStatsCmdLocked();
                                        pw.println("Battery stats reset.");
                                        noOutput = true;
                                    }
                                    this.mWorker.scheduleSync("dump", 31);
                                    continue;
                                }
                                if ("--write".equals(arg)) {
                                    this.syncStats("dump", 31);
                                    BatteryStatsImpl events = this.mStats;
                                    synchronized (events) {
                                        this.mStats.writeSyncLocked();
                                        pw.println("Battery stats written.");
                                        noOutput = true;
                                        continue;
                                    }
                                }
                                if ("--new-daily".equals(arg)) {
                                    BatteryStatsImpl events = this.mStats;
                                    synchronized (events) {
                                        this.mStats.recordDailyStatsLocked();
                                        pw.println("New daily stats written.");
                                        noOutput = true;
                                        continue;
                                    }
                                }
                                if ("--read-daily".equals(arg)) {
                                    BatteryStatsImpl events = this.mStats;
                                    synchronized (events) {
                                        this.mStats.readDailyStatsLocked();
                                        pw.println("Last daily stats read.");
                                        noOutput = true;
                                        continue;
                                    }
                                }
                                if ("--enable".equals(arg) || "enable".equals(arg)) {
                                    if ((i = this.doEnableOrDisable(pw, i, args, true)) < 0) {
                                        return;
                                    }
                                    pw.println("Enabled: " + args[i]);
                                    return;
                                }
                                if ("--disable".equals(arg) || "disable".equals(arg)) {
                                    if ((i = this.doEnableOrDisable(pw, i, args, false)) < 0) {
                                        return;
                                    }
                                    pw.println("Disabled: " + args[i]);
                                    return;
                                }
                                if ("-h".equals(arg)) {
                                    this.dumpHelp(pw);
                                    return;
                                }
                                if ("--settings".equals(arg)) {
                                    this.dumpSettings(pw);
                                    return;
                                }
                                if ("--cpu".equals(arg)) {
                                    this.dumpCpuStats(pw);
                                    return;
                                }
                                if ("-a".equals(arg)) {
                                    flags |= 0x20;
                                    continue;
                                }
                                if (arg.length() > 0 && arg.charAt(0) == '-') {
                                    pw.println("Unknown option: " + arg);
                                    this.dumpHelp(pw);
                                    return;
                                }
                                try {
                                    reqUid = this.mContext.getPackageManager().getPackageUidAsUser(arg, UserHandle.getCallingUserId());
                                    continue;
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    pw.println("Unknown package: " + arg);
                                    this.dumpHelp(pw);
                                    return;
                                }
                            }
                        }
                        if (noOutput) {
                            return;
                        }
                        long ident = Binder.clearCallingIdentity();
                        try {
                            if (BatteryStatsHelper.checkWifiOnly(this.mContext)) {
                                flags |= 0x40;
                            }
                            this.syncStats("dump", 31);
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                        if (reqUid >= 0 && (flags & 0xA) == 0) {
                            flags |= 2;
                            flags &= 0xFFFFFFEF;
                        }
                        if (!toProto) break block78;
                        apps2 = this.mContext.getPackageManager().getInstalledApplications(0x420000);
                        if (!isRealCheckin) break block79;
                        object2 = this.mStats.mCheckinFile;
                        synchronized (object2) {
                            block76: {
                                if (!this.mStats.mCheckinFile.exists()) break block79;
                                raw2 = this.mStats.mCheckinFile.readFully();
                                if (raw2 == null) break block76;
                                Parcel in = Parcel.obtain();
                                in.unmarshall(raw2, 0, raw2.length);
                                in.setDataPosition(0);
                                BatteryStatsImpl checkinStats = new BatteryStatsImpl(null, this.mStats.mHandler, null, null, this.mUserManagerUserInfoProvider);
                                checkinStats.readSummaryFromParcel(in);
                                in.recycle();
                                checkinStats.dumpProtoLocked(this.mContext, fd, apps2, flags, historyStart);
                                this.mStats.mCheckinFile.delete();
                                return;
                            }
                            try {
                            }
                            catch (ParcelFormatException | IOException e) {
                                Slog.w(TAG, "Failure reading checkin file " + this.mStats.mCheckinFile.getBaseFile(), e);
                            }
                        }
                    }
                    object2 = this.mStats;
                    synchronized (object2) {
                        this.mStats.dumpProtoLocked(this.mContext, fd, apps2, flags, historyStart);
                        if (writeData) {
                            this.mStats.writeAsyncLocked();
                        }
                    }
                }
                if (!useCheckinFormat) break block80;
                apps = this.mContext.getPackageManager().getInstalledApplications(0x420000);
                if (!isRealCheckin) break block81;
                object = this.mStats.mCheckinFile;
                synchronized (object) {
                    block77: {
                        if (!this.mStats.mCheckinFile.exists()) break block81;
                        raw2 = this.mStats.mCheckinFile.readFully();
                        if (raw2 == null) break block77;
                        Parcel in = Parcel.obtain();
                        in.unmarshall(raw2, 0, raw2.length);
                        in.setDataPosition(0);
                        BatteryStatsImpl checkinStats = new BatteryStatsImpl(null, this.mStats.mHandler, null, null, this.mUserManagerUserInfoProvider);
                        checkinStats.readSummaryFromParcel(in);
                        in.recycle();
                        checkinStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                        this.mStats.mCheckinFile.delete();
                        return;
                    }
                    try {
                    }
                    catch (ParcelFormatException | IOException e) {
                        Slog.w(TAG, "Failure reading checkin file " + this.mStats.mCheckinFile.getBaseFile(), e);
                    }
                }
            }
            object = this.mStats;
            synchronized (object) {
                this.mStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                if (writeData) {
                    this.mStats.writeAsyncLocked();
                }
            }
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpLocked(this.mContext, pw, flags, reqUid, historyStart);
            if (writeData) {
                this.mStats.writeAsyncLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CellularBatteryStats getCellularBatteryStats() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.getCellularBatteryStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WifiBatteryStats getWifiBatteryStats() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.getWifiBatteryStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GpsBatteryStats getGpsBatteryStats() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.getGpsBatteryStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthStatsParceler takeUidSnapshot(int requestUid) {
        if (requestUid != Binder.getCallingUid()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.shouldCollectExternalStats()) {
                this.syncStats("get-health-stats-for-uids", 31);
            }
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                try {
                    HealthStatsParceler healthStatsParceler = this.getHealthStatsForUidLocked(requestUid);
                    return healthStatsParceler;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception ex) {
                        Slog.w(TAG, "Crashed while writing for takeUidSnapshot(" + requestUid + ")", ex);
                        throw ex;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthStatsParceler[] takeUidSnapshots(int[] requestUids) {
        if (!BatteryStatsService.onlyCaller(requestUids)) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        }
        long ident = Binder.clearCallingIdentity();
        int i = -1;
        try {
            if (this.shouldCollectExternalStats()) {
                this.syncStats("get-health-stats-for-uids", 31);
            }
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                int N = requestUids.length;
                HealthStatsParceler[] results = new HealthStatsParceler[N];
                for (i = 0; i < N; ++i) {
                    results[i] = this.getHealthStatsForUidLocked(requestUids[i]);
                }
                HealthStatsParceler[] healthStatsParcelerArray = results;
                return healthStatsParcelerArray;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean shouldCollectExternalStats() {
        return SystemClock.elapsedRealtime() - this.mWorker.getLastCollectionTimeStamp() > this.mStats.getExternalStatsCollectionRateLimitMs();
    }

    private static boolean onlyCaller(int[] requestUids) {
        int caller = Binder.getCallingUid();
        int N = requestUids.length;
        for (int i = 0; i < N; ++i) {
            if (requestUids[i] == caller) continue;
            return false;
        }
        return true;
    }

    HealthStatsParceler getHealthStatsForUidLocked(int requestUid) {
        HealthStatsBatteryStatsWriter writer = new HealthStatsBatteryStatsWriter();
        HealthStatsWriter uidWriter = new HealthStatsWriter(UidHealthStats.CONSTANTS);
        BatteryStats.Uid uid = this.mStats.getUidStats().get(requestUid);
        if (uid != null) {
            writer.writeUid(uidWriter, this.mStats, uid);
        }
        return new HealthStatsParceler(uidWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setChargingStateUpdateDelayMillis(int delayMillis) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.POWER_SAVER", null);
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            boolean bl = Settings.Global.putLong(contentResolver, "battery_charging_state_update_delay", delayMillis);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    final class WakeupReasonThread
    extends Thread {
        private static final int MAX_REASON_SIZE = 512;
        private CharsetDecoder mDecoder;
        private ByteBuffer mUtf8Buffer;
        private CharBuffer mUtf16Buffer;

        WakeupReasonThread() {
            super("BatteryStats_wakeupReason");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority(-2);
            this.mDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            this.mUtf8Buffer = ByteBuffer.allocateDirect(512);
            this.mUtf16Buffer = CharBuffer.allocate(512);
            try {
                String reason;
                while ((reason = this.waitWakeup()) != null) {
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsService.this.mStats.noteWakeupReasonLocked(reason);
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                Slog.e(BatteryStatsService.TAG, "Failure reading wakeup reasons", e);
            }
        }

        private String waitWakeup() {
            this.mUtf8Buffer.clear();
            this.mUtf16Buffer.clear();
            this.mDecoder.reset();
            int bytesWritten = BatteryStatsService.nativeWaitWakeup(this.mUtf8Buffer);
            if (bytesWritten < 0) {
                return null;
            }
            if (bytesWritten == 0) {
                return "unknown";
            }
            this.mUtf8Buffer.limit(bytesWritten);
            this.mDecoder.decode(this.mUtf8Buffer, this.mUtf16Buffer, true);
            this.mUtf16Buffer.flip();
            return this.mUtf16Buffer.toString();
        }
    }

    private final class LocalService
    extends BatteryStatsInternal {
        private LocalService() {
        }

        @Override
        public String[] getWifiIfaces() {
            return (String[])BatteryStatsService.this.mStats.getWifiIfaces().clone();
        }

        @Override
        public String[] getMobileIfaces() {
            return (String[])BatteryStatsService.this.mStats.getMobileIfaces().clone();
        }

        @Override
        public void noteJobsDeferred(int uid, int numDeferred, long sinceLast) {
            BatteryStatsService.this.noteJobsDeferred(uid, numDeferred, sinceLast);
        }
    }
}

