/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.os.Handler;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.TimeUtils;
import java.io.PrintWriter;

public class BroadcastConstants {
    private static final String TAG = "BroadcastConstants";
    static final String KEY_TIMEOUT = "bcast_timeout";
    static final String KEY_SLOW_TIME = "bcast_slow_time";
    static final String KEY_DEFERRAL = "bcast_deferral";
    static final String KEY_DEFERRAL_DECAY_FACTOR = "bcast_deferral_decay_factor";
    static final String KEY_DEFERRAL_FLOOR = "bcast_deferral_floor";
    static final String KEY_ALLOW_BG_ACTIVITY_START_TIMEOUT = "bcast_allow_bg_activity_start_timeout";
    private static final long DEFAULT_TIMEOUT = 10000L;
    private static final long DEFAULT_SLOW_TIME = 5000L;
    private static final long DEFAULT_DEFERRAL = 5000L;
    private static final float DEFAULT_DEFERRAL_DECAY_FACTOR = 0.75f;
    private static final long DEFAULT_DEFERRAL_FLOOR = 0L;
    private static final long DEFAULT_ALLOW_BG_ACTIVITY_START_TIMEOUT = 10000L;
    public long TIMEOUT = 10000L;
    public long SLOW_TIME = 5000L;
    public long DEFERRAL = 5000L;
    public float DEFERRAL_DECAY_FACTOR = 0.75f;
    public long DEFERRAL_FLOOR = 0L;
    public long ALLOW_BG_ACTIVITY_START_TIMEOUT = 10000L;
    private String mSettingsKey;
    private SettingsObserver mSettingsObserver;
    private ContentResolver mResolver;
    private final KeyValueListParser mParser = new KeyValueListParser(',');

    public BroadcastConstants(String settingsKey) {
        this.mSettingsKey = settingsKey;
    }

    public void startObserving(Handler handler, ContentResolver resolver) {
        this.mResolver = resolver;
        this.mSettingsObserver = new SettingsObserver(handler);
        this.mResolver.registerContentObserver(Settings.Global.getUriFor(this.mSettingsKey), false, this.mSettingsObserver);
        this.updateConstants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConstants() {
        KeyValueListParser keyValueListParser = this.mParser;
        synchronized (keyValueListParser) {
            try {
                this.mParser.setString(Settings.Global.getString(this.mResolver, this.mSettingsKey));
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Bad broadcast settings in key '" + this.mSettingsKey + "'", e);
                return;
            }
            this.TIMEOUT = this.mParser.getLong(KEY_TIMEOUT, this.TIMEOUT);
            this.SLOW_TIME = this.mParser.getLong(KEY_SLOW_TIME, this.SLOW_TIME);
            this.DEFERRAL = this.mParser.getLong(KEY_DEFERRAL, this.DEFERRAL);
            this.DEFERRAL_DECAY_FACTOR = this.mParser.getFloat(KEY_DEFERRAL_DECAY_FACTOR, this.DEFERRAL_DECAY_FACTOR);
            this.DEFERRAL_FLOOR = this.mParser.getLong(KEY_DEFERRAL_FLOOR, this.DEFERRAL_FLOOR);
            this.ALLOW_BG_ACTIVITY_START_TIMEOUT = this.mParser.getLong(KEY_ALLOW_BG_ACTIVITY_START_TIMEOUT, this.ALLOW_BG_ACTIVITY_START_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        KeyValueListParser keyValueListParser = this.mParser;
        synchronized (keyValueListParser) {
            pw.println();
            pw.print("  Broadcast parameters (key=");
            pw.print(this.mSettingsKey);
            pw.print(", observing=");
            pw.print(this.mSettingsObserver != null);
            pw.println("):");
            pw.print("    ");
            pw.print(KEY_TIMEOUT);
            pw.print(" = ");
            TimeUtils.formatDuration(this.TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SLOW_TIME);
            pw.print(" = ");
            TimeUtils.formatDuration(this.SLOW_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_DEFERRAL);
            pw.print(" = ");
            TimeUtils.formatDuration(this.DEFERRAL, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_DEFERRAL_DECAY_FACTOR);
            pw.print(" = ");
            pw.println(this.DEFERRAL_DECAY_FACTOR);
            pw.print("    ");
            pw.print(KEY_DEFERRAL_FLOOR);
            pw.print(" = ");
            TimeUtils.formatDuration(this.DEFERRAL_FLOOR, pw);
            pw.print("    ");
            pw.print(KEY_ALLOW_BG_ACTIVITY_START_TIMEOUT);
            pw.print(" = ");
            TimeUtils.formatDuration(this.ALLOW_BG_ACTIVITY_START_TIMEOUT, pw);
            pw.println();
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange) {
            BroadcastConstants.this.updateConstants();
        }
    }
}

