/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Intent;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import com.android.server.AlarmManagerInternal;
import com.android.server.LocalServices;
import com.android.server.am.BroadcastConstants;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.BroadcastRecord;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Set;

public class BroadcastDispatcher {
    private static final String TAG = "BroadcastDispatcher";
    private final Object mLock;
    private final BroadcastQueue mQueue;
    private final BroadcastConstants mConstants;
    private final Handler mHandler;
    private AlarmManagerInternal mAlarm;
    final SparseIntArray mAlarmUids = new SparseIntArray();
    final AlarmManagerInternal.InFlightListener mAlarmListener = new AlarmManagerInternal.InFlightListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcastAlarmPending(int recipientUid) {
            Object object = BroadcastDispatcher.this.mLock;
            synchronized (object) {
                int newCount = BroadcastDispatcher.this.mAlarmUids.get(recipientUid, 0) + 1;
                BroadcastDispatcher.this.mAlarmUids.put(recipientUid, newCount);
                int numEntries = BroadcastDispatcher.this.mDeferredBroadcasts.size();
                for (int i = 0; i < numEntries; ++i) {
                    if (recipientUid != ((Deferrals)((BroadcastDispatcher)BroadcastDispatcher.this).mDeferredBroadcasts.get((int)i)).uid) continue;
                    Deferrals d = (Deferrals)BroadcastDispatcher.this.mDeferredBroadcasts.remove(i);
                    BroadcastDispatcher.this.mAlarmBroadcasts.add(d);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcastAlarmComplete(int recipientUid) {
            Object object = BroadcastDispatcher.this.mLock;
            synchronized (object) {
                int newCount = BroadcastDispatcher.this.mAlarmUids.get(recipientUid, 0) - 1;
                if (newCount >= 0) {
                    BroadcastDispatcher.this.mAlarmUids.put(recipientUid, newCount);
                } else {
                    Slog.wtf(BroadcastDispatcher.TAG, "Undercount of broadcast alarms in flight for " + recipientUid);
                    BroadcastDispatcher.this.mAlarmUids.put(recipientUid, 0);
                }
                if (newCount <= 0) {
                    int numEntries = BroadcastDispatcher.this.mAlarmBroadcasts.size();
                    for (int i = 0; i < numEntries; ++i) {
                        if (recipientUid != ((Deferrals)((BroadcastDispatcher)BroadcastDispatcher.this).mAlarmBroadcasts.get((int)i)).uid) continue;
                        Deferrals d = (Deferrals)BroadcastDispatcher.this.mAlarmBroadcasts.remove(i);
                        BroadcastDispatcher.insertLocked(BroadcastDispatcher.this.mDeferredBroadcasts, d);
                        break;
                    }
                }
            }
        }
    };
    final Runnable mScheduleRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BroadcastDispatcher.this.mLock;
            synchronized (object) {
                BroadcastDispatcher.this.mQueue.scheduleBroadcastsLocked();
                BroadcastDispatcher.this.mRecheckScheduled = false;
            }
        }
    };
    private boolean mRecheckScheduled = false;
    private final ArrayList<BroadcastRecord> mOrderedBroadcasts = new ArrayList();
    private final ArrayList<Deferrals> mDeferredBroadcasts = new ArrayList();
    private final ArrayList<Deferrals> mAlarmBroadcasts = new ArrayList();
    private BroadcastRecord mCurrentBroadcast;

    public BroadcastDispatcher(BroadcastQueue queue, BroadcastConstants constants, Handler handler, Object lock) {
        this.mQueue = queue;
        this.mConstants = constants;
        this.mHandler = handler;
        this.mLock = lock;
    }

    public void start() {
        this.mAlarm = LocalServices.getService(AlarmManagerInternal.class);
        this.mAlarm.registerInFlightListener(this.mAlarmListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentBroadcast == null && this.mOrderedBroadcasts.isEmpty() && BroadcastDispatcher.isDeferralsListEmpty(this.mDeferredBroadcasts) && BroadcastDispatcher.isDeferralsListEmpty(this.mAlarmBroadcasts);
        }
    }

    private static int pendingInDeferralsList(ArrayList<Deferrals> list) {
        int pending = 0;
        int numEntries = list.size();
        for (int i = 0; i < numEntries; ++i) {
            pending += list.get(i).size();
        }
        return pending;
    }

    private static boolean isDeferralsListEmpty(ArrayList<Deferrals> list) {
        return BroadcastDispatcher.pendingInDeferralsList(list) == 0;
    }

    public String describeStateLocked() {
        StringBuilder sb = new StringBuilder(128);
        if (this.mCurrentBroadcast != null) {
            sb.append("1 in flight, ");
        }
        sb.append(this.mOrderedBroadcasts.size());
        sb.append(" ordered");
        int n = BroadcastDispatcher.pendingInDeferralsList(this.mAlarmBroadcasts);
        if (n > 0) {
            sb.append(", ");
            sb.append(n);
            sb.append(" deferrals in alarm recipients");
        }
        if ((n = BroadcastDispatcher.pendingInDeferralsList(this.mDeferredBroadcasts)) > 0) {
            sb.append(", ");
            sb.append(n);
            sb.append(" deferred");
        }
        return sb.toString();
    }

    void enqueueOrderedBroadcastLocked(BroadcastRecord r) {
        this.mOrderedBroadcasts.add(r);
    }

    BroadcastRecord replaceBroadcastLocked(BroadcastRecord r, String typeForLogging) {
        BroadcastRecord old = this.replaceBroadcastLocked(this.mOrderedBroadcasts, r, typeForLogging);
        if (old == null) {
            old = this.replaceDeferredBroadcastLocked(this.mAlarmBroadcasts, r, typeForLogging);
        }
        if (old == null) {
            old = this.replaceDeferredBroadcastLocked(this.mDeferredBroadcasts, r, typeForLogging);
        }
        return old;
    }

    private BroadcastRecord replaceDeferredBroadcastLocked(ArrayList<Deferrals> list, BroadcastRecord r, String typeForLogging) {
        int numEntries = list.size();
        for (int i = 0; i < numEntries; ++i) {
            Deferrals d = list.get(i);
            BroadcastRecord old = this.replaceBroadcastLocked(d.broadcasts, r, typeForLogging);
            if (old == null) continue;
            return old;
        }
        return null;
    }

    private BroadcastRecord replaceBroadcastLocked(ArrayList<BroadcastRecord> list, BroadcastRecord r, String typeForLogging) {
        Intent intent = r.intent;
        for (int i = list.size() - 1; i >= 0; --i) {
            BroadcastRecord old = list.get(i);
            if (old.userId != r.userId || !intent.filterEquals(old.intent)) continue;
            r.deferred = old.deferred;
            list.set(i, r);
            return old;
        }
        return null;
    }

    boolean cleanupDisabledPackageReceiversLocked(String packageName, Set<String> filterByClasses, int userId, boolean doit) {
        boolean didSomething = this.cleanupBroadcastListDisabledReceiversLocked(this.mOrderedBroadcasts, packageName, filterByClasses, userId, doit);
        if (doit || !didSomething) {
            didSomething |= this.cleanupDeferralsListDisabledReceiversLocked(this.mAlarmBroadcasts, packageName, filterByClasses, userId, doit);
        }
        if (doit || !didSomething) {
            didSomething |= this.cleanupDeferralsListDisabledReceiversLocked(this.mDeferredBroadcasts, packageName, filterByClasses, userId, doit);
        }
        if ((doit || !didSomething) && this.mCurrentBroadcast != null) {
            didSomething |= this.mCurrentBroadcast.cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit);
        }
        return didSomething;
    }

    private boolean cleanupDeferralsListDisabledReceiversLocked(ArrayList<Deferrals> list, String packageName, Set<String> filterByClasses, int userId, boolean doit) {
        boolean didSomething = false;
        for (Deferrals d : list) {
            didSomething = this.cleanupBroadcastListDisabledReceiversLocked(d.broadcasts, packageName, filterByClasses, userId, doit);
            if (doit || !didSomething) continue;
            return true;
        }
        return didSomething;
    }

    private boolean cleanupBroadcastListDisabledReceiversLocked(ArrayList<BroadcastRecord> list, String packageName, Set<String> filterByClasses, int userId, boolean doit) {
        boolean didSomething = false;
        for (BroadcastRecord br : list) {
            if (doit || !(didSomething |= br.cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit))) continue;
            return true;
        }
        return didSomething;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        if (this.mCurrentBroadcast != null) {
            this.mCurrentBroadcast.writeToProto(proto, fieldId);
        }
        for (Deferrals d : this.mAlarmBroadcasts) {
            d.writeToProto(proto, fieldId);
        }
        for (BroadcastRecord br : this.mOrderedBroadcasts) {
            br.writeToProto(proto, fieldId);
        }
        for (Deferrals d : this.mDeferredBroadcasts) {
            d.writeToProto(proto, fieldId);
        }
    }

    public BroadcastRecord getActiveBroadcastLocked() {
        return this.mCurrentBroadcast;
    }

    public BroadcastRecord getNextBroadcastLocked(long now) {
        if (this.mCurrentBroadcast != null) {
            return this.mCurrentBroadcast;
        }
        boolean someQueued = !this.mOrderedBroadcasts.isEmpty();
        BroadcastRecord next = null;
        if (!this.mAlarmBroadcasts.isEmpty()) {
            next = BroadcastDispatcher.popLocked(this.mAlarmBroadcasts);
        }
        if (next == null && !this.mDeferredBroadcasts.isEmpty()) {
            for (int i = 0; i < this.mDeferredBroadcasts.size(); ++i) {
                Deferrals d = this.mDeferredBroadcasts.get(i);
                if (now < d.deferUntil && someQueued) break;
                if (d.broadcasts.size() <= 0) continue;
                next = d.broadcasts.remove(0);
                this.mDeferredBroadcasts.remove(i);
                d.deferredBy = this.calculateDeferral(d.deferredBy);
                d.deferUntil += d.deferredBy;
                BroadcastDispatcher.insertLocked(this.mDeferredBroadcasts, d);
                break;
            }
        }
        if (next == null && someQueued) {
            next = this.mOrderedBroadcasts.remove(0);
        }
        this.mCurrentBroadcast = next;
        return next;
    }

    public void retireBroadcastLocked(BroadcastRecord r) {
        if (r != this.mCurrentBroadcast) {
            Slog.wtf(TAG, "Retiring broadcast " + r + " doesn't match current outgoing " + this.mCurrentBroadcast);
        }
        this.mCurrentBroadcast = null;
    }

    public boolean isDeferringLocked(int uid) {
        Deferrals d = this.findUidLocked(uid);
        if (d != null && d.broadcasts.isEmpty() && SystemClock.uptimeMillis() >= d.deferUntil) {
            this.removeDeferral(d);
            return false;
        }
        return d != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDeferring(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            Deferrals d = this.findUidLocked(uid);
            if (d == null) {
                long now = SystemClock.uptimeMillis();
                d = new Deferrals(uid, now, this.mConstants.DEFERRAL, this.mAlarmUids.get(uid, 0));
                if (d.alarmCount == 0) {
                    BroadcastDispatcher.insertLocked(this.mDeferredBroadcasts, d);
                    this.scheduleDeferralCheckLocked(true);
                } else {
                    this.mAlarmBroadcasts.add(d);
                }
            } else {
                d.deferredBy = this.mConstants.DEFERRAL;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredBroadcast(int uid, BroadcastRecord br) {
        Object object = this.mLock;
        synchronized (object) {
            Deferrals d = this.findUidLocked(uid);
            if (d == null) {
                Slog.wtf(TAG, "Adding deferred broadcast but not tracking " + uid);
            } else if (br == null) {
                Slog.wtf(TAG, "Deferring null broadcast to " + uid);
            } else {
                br.deferred = true;
                d.add(br);
            }
        }
    }

    public void scheduleDeferralCheckLocked(boolean force) {
        if (!(!force && this.mRecheckScheduled || this.mDeferredBroadcasts.isEmpty())) {
            Deferrals d = this.mDeferredBroadcasts.get(0);
            if (!d.broadcasts.isEmpty()) {
                this.mHandler.removeCallbacks(this.mScheduleRunnable);
                this.mHandler.postAtTime(this.mScheduleRunnable, d.deferUntil);
                this.mRecheckScheduled = true;
            }
        }
    }

    public void cancelDeferralsLocked() {
        BroadcastDispatcher.zeroDeferralTimes(this.mAlarmBroadcasts);
        BroadcastDispatcher.zeroDeferralTimes(this.mDeferredBroadcasts);
    }

    private static void zeroDeferralTimes(ArrayList<Deferrals> list) {
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            Deferrals d = list.get(i);
            d.deferredBy = 0L;
            d.deferUntil = 0L;
        }
    }

    private Deferrals findUidLocked(int uid) {
        Deferrals d = BroadcastDispatcher.findUidLocked(uid, this.mDeferredBroadcasts);
        if (d == null) {
            d = BroadcastDispatcher.findUidLocked(uid, this.mAlarmBroadcasts);
        }
        return d;
    }

    private boolean removeDeferral(Deferrals d) {
        boolean didRemove = this.mDeferredBroadcasts.remove(d);
        if (!didRemove) {
            didRemove = this.mAlarmBroadcasts.remove(d);
        }
        return didRemove;
    }

    private static Deferrals findUidLocked(int uid, ArrayList<Deferrals> list) {
        int numElements = list.size();
        for (int i = 0; i < numElements; ++i) {
            Deferrals d = list.get(i);
            if (uid != d.uid) continue;
            return d;
        }
        return null;
    }

    private static BroadcastRecord popLocked(ArrayList<Deferrals> list) {
        Deferrals d = list.get(0);
        return d.broadcasts.isEmpty() ? null : d.broadcasts.remove(0);
    }

    private static void insertLocked(ArrayList<Deferrals> list, Deferrals d) {
        int i;
        int numElements = list.size();
        for (i = 0; i < numElements && d.deferUntil >= list.get((int)i).deferUntil; ++i) {
        }
        list.add(i, d);
    }

    private long calculateDeferral(long previous) {
        return Math.max(this.mConstants.DEFERRAL_FLOOR, (long)((float)previous * this.mConstants.DEFERRAL_DECAY_FACTOR));
    }

    boolean dumpLocked(PrintWriter pw, String dumpPackage, String queueName, SimpleDateFormat sdf) {
        Dumper dumper = new Dumper(pw, queueName, dumpPackage, sdf);
        boolean printed = false;
        dumper.setHeading("Currently in flight");
        dumper.setLabel("In-Flight Ordered Broadcast");
        if (this.mCurrentBroadcast != null) {
            dumper.dump(this.mCurrentBroadcast);
        } else {
            pw.println("  (null)");
        }
        dumper.setHeading("Active ordered broadcasts");
        dumper.setLabel("Active Ordered Broadcast");
        for (Deferrals d : this.mAlarmBroadcasts) {
            d.dumpLocked(dumper);
        }
        printed |= dumper.didPrint();
        for (BroadcastRecord br : this.mOrderedBroadcasts) {
            dumper.dump(br);
        }
        printed |= dumper.didPrint();
        dumper.setHeading("Deferred ordered broadcasts");
        dumper.setLabel("Deferred Ordered Broadcast");
        for (Deferrals d : this.mDeferredBroadcasts) {
            d.dumpLocked(dumper);
        }
        return printed |= dumper.didPrint();
    }

    class Dumper {
        final PrintWriter mPw;
        final String mQueueName;
        final String mDumpPackage;
        final SimpleDateFormat mSdf;
        boolean mPrinted;
        boolean mNeedSep;
        String mHeading;
        String mLabel;
        int mOrdinal;

        Dumper(PrintWriter pw, String queueName, String dumpPackage, SimpleDateFormat sdf) {
            this.mPw = pw;
            this.mQueueName = queueName;
            this.mDumpPackage = dumpPackage;
            this.mSdf = sdf;
            this.mPrinted = false;
            this.mNeedSep = true;
        }

        void setHeading(String heading) {
            this.mHeading = heading;
            this.mPrinted = false;
        }

        void setLabel(String label) {
            this.mLabel = "  " + label + " " + this.mQueueName + " #";
            this.mOrdinal = 0;
        }

        boolean didPrint() {
            return this.mPrinted;
        }

        void dump(BroadcastRecord br) {
            if (this.mDumpPackage == null || this.mDumpPackage.equals(br.callerPackage)) {
                if (!this.mPrinted) {
                    if (this.mNeedSep) {
                        this.mPw.println();
                    }
                    this.mPrinted = true;
                    this.mNeedSep = true;
                    this.mPw.println("  " + this.mHeading + " [" + this.mQueueName + "]:");
                }
                this.mPw.println(this.mLabel + this.mOrdinal + ":");
                ++this.mOrdinal;
                br.dump(this.mPw, "    ", this.mSdf);
            }
        }
    }

    static class Deferrals {
        final int uid;
        long deferredAt;
        long deferredBy;
        long deferUntil;
        int alarmCount;
        final ArrayList<BroadcastRecord> broadcasts;

        Deferrals(int uid, long now, long backoff, int count) {
            this.uid = uid;
            this.deferredAt = now;
            this.deferredBy = backoff;
            this.deferUntil = now + backoff;
            this.alarmCount = count;
            this.broadcasts = new ArrayList();
        }

        void add(BroadcastRecord br) {
            this.broadcasts.add(br);
        }

        int size() {
            return this.broadcasts.size();
        }

        boolean isEmpty() {
            return this.broadcasts.isEmpty();
        }

        void writeToProto(ProtoOutputStream proto, long fieldId) {
            for (BroadcastRecord br : this.broadcasts) {
                br.writeToProto(proto, fieldId);
            }
        }

        void dumpLocked(Dumper d) {
            for (BroadcastRecord br : this.broadcasts) {
                d.dump(br);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Deferrals{uid=");
            sb.append(this.uid);
            sb.append(", deferUntil=");
            sb.append(this.deferUntil);
            sb.append(", #broadcasts=");
            sb.append(this.broadcasts.size());
            sb.append("}");
            return sb.toString();
        }
    }
}

