/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IServiceConnection;
import android.app.PendingIntent;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.internal.app.procstats.AssociationState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.server.am.AppBindRecord;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import java.io.PrintWriter;

final class ConnectionRecord {
    final AppBindRecord binding;
    final ActivityServiceConnectionsHolder<ConnectionRecord> activity;
    final IServiceConnection conn;
    final int flags;
    final int clientLabel;
    final PendingIntent clientIntent;
    final int clientUid;
    final String clientProcessName;
    final String clientPackageName;
    public AssociationState.SourceState association;
    String stringName;
    boolean serviceDead;
    private static final int[] BIND_ORIG_ENUMS = new int[]{1, 2, 4, 0x800000, 8, 16, 32, 64, 128, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, 256, 4096};
    private static final int[] BIND_PROTO_ENUMS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17};

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "binding=" + this.binding);
        if (this.activity != null) {
            this.activity.dump(pw, prefix);
        }
        pw.println(prefix + "conn=" + this.conn.asBinder() + " flags=0x" + Integer.toHexString(this.flags));
    }

    ConnectionRecord(AppBindRecord _binding, ActivityServiceConnectionsHolder<ConnectionRecord> _activity, IServiceConnection _conn, int _flags, int _clientLabel, PendingIntent _clientIntent, int _clientUid, String _clientProcessName, String _clientPackageName) {
        this.binding = _binding;
        this.activity = _activity;
        this.conn = _conn;
        this.flags = _flags;
        this.clientLabel = _clientLabel;
        this.clientIntent = _clientIntent;
        this.clientUid = _clientUid;
        this.clientProcessName = _clientProcessName;
        this.clientPackageName = _clientPackageName;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean notHasFlag(int flag) {
        return (this.flags & flag) == 0;
    }

    public void startAssociationIfNeeded() {
        if (!(this.association != null || this.binding.service.app == null || this.binding.service.appInfo.uid == this.clientUid && this.binding.service.processName.equals(this.clientProcessName))) {
            ProcessStats.ProcessStateHolder holder = this.binding.service.app.pkgList.get(this.binding.service.instanceName.getPackageName());
            if (holder == null) {
                Slog.wtf("ActivityManager", "No package in referenced service " + this.binding.service.shortInstanceName + ": proc=" + this.binding.service.app);
            } else if (holder.pkg == null) {
                Slog.wtf("ActivityManager", "Inactive holder in referenced service " + this.binding.service.shortInstanceName + ": proc=" + this.binding.service.app);
            } else {
                this.association = holder.pkg.getAssociationStateLocked(holder.state, this.binding.service.instanceName.getClassName()).startSource(this.clientUid, this.clientProcessName, this.clientPackageName);
            }
        }
    }

    public void trackProcState(int procState, int seq, long now) {
        if (this.association != null) {
            this.association.trackProcState(procState, seq, now);
        }
    }

    public void stopAssociation() {
        if (this.association != null) {
            this.association.stop();
            this.association = null;
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConnectionRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(this.binding.client.userId);
        sb.append(' ');
        if ((this.flags & 1) != 0) {
            sb.append("CR ");
        }
        if ((this.flags & 2) != 0) {
            sb.append("DBG ");
        }
        if ((this.flags & 4) != 0) {
            sb.append("!FG ");
        }
        if ((this.flags & 0x800000) != 0) {
            sb.append("IMPB ");
        }
        if ((this.flags & 8) != 0) {
            sb.append("ABCLT ");
        }
        if ((this.flags & 0x10) != 0) {
            sb.append("OOM ");
        }
        if ((this.flags & 0x20) != 0) {
            sb.append("WPRI ");
        }
        if ((this.flags & 0x40) != 0) {
            sb.append("IMP ");
        }
        if ((this.flags & 0x80) != 0) {
            sb.append("WACT ");
        }
        if ((this.flags & 0x2000000) != 0) {
            sb.append("FGSA ");
        }
        if ((this.flags & 0x4000000) != 0) {
            sb.append("FGS ");
        }
        if ((this.flags & 0x8000000) != 0) {
            sb.append("LACT ");
        }
        if ((this.flags & 0x80000) != 0) {
            sb.append("SLTA ");
        }
        if ((this.flags & 0x10000000) != 0) {
            sb.append("VIS ");
        }
        if ((this.flags & 0x20000000) != 0) {
            sb.append("UI ");
        }
        if ((this.flags & 0x40000000) != 0) {
            sb.append("!VIS ");
        }
        if ((this.flags & 0x100) != 0) {
            sb.append("!PRCP ");
        }
        if ((this.flags & 0x1000) != 0) {
            sb.append("CAPS ");
        }
        if (this.serviceDead) {
            sb.append("DEAD ");
        }
        sb.append(this.binding.service.shortInstanceName);
        sb.append(":@");
        sb.append(Integer.toHexString(System.identityHashCode(this.conn.asBinder())));
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        if (this.binding == null) {
            return;
        }
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, Integer.toHexString(System.identityHashCode(this)));
        if (this.binding.client != null) {
            proto.write(1120986464258L, this.binding.client.userId);
        }
        ProtoUtils.writeBitWiseFlagsToProtoEnum(proto, 2259152797699L, this.flags, BIND_ORIG_ENUMS, BIND_PROTO_ENUMS);
        if (this.serviceDead) {
            proto.write(2259152797699L, 15);
        }
        if (this.binding.service != null) {
            proto.write(1138166333444L, this.binding.service.shortInstanceName);
        }
        proto.end(token);
    }
}

