/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ContentProviderHolder;
import android.content.ComponentName;
import android.content.IContentProvider;
import android.content.pm.ApplicationInfo;
import android.content.pm.ProviderInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.app.procstats.AssociationState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ProcessRecord;
import java.io.PrintWriter;
import java.util.ArrayList;

final class ContentProviderRecord
implements ComponentName.WithComponentName {
    final ActivityManagerService service;
    public final ProviderInfo info;
    final int uid;
    final ApplicationInfo appInfo;
    final ComponentName name;
    final boolean singleton;
    public IContentProvider provider;
    public boolean noReleaseNeeded;
    final ArrayList<ContentProviderConnection> connections = new ArrayList();
    ArrayMap<IBinder, ExternalProcessHandle> externalProcessTokenToHandle;
    int externalProcessNoHandleCount;
    ProcessRecord proc;
    ProcessRecord launchingApp;
    String stringName;
    String shortStringName;

    public ContentProviderRecord(ActivityManagerService _service, ProviderInfo _info, ApplicationInfo ai, ComponentName _name, boolean _singleton) {
        this.service = _service;
        this.info = _info;
        this.uid = ai.uid;
        this.appInfo = ai;
        this.name = _name;
        this.singleton = _singleton;
        this.noReleaseNeeded = !(this.uid != 0 && this.uid != 1000 || _name != null && "com.android.settings".equals(_name.getPackageName()));
    }

    public ContentProviderRecord(ContentProviderRecord cpr) {
        this.service = cpr.service;
        this.info = cpr.info;
        this.uid = cpr.uid;
        this.appInfo = cpr.appInfo;
        this.name = cpr.name;
        this.singleton = cpr.singleton;
        this.noReleaseNeeded = cpr.noReleaseNeeded;
    }

    public ContentProviderHolder newHolder(ContentProviderConnection conn) {
        ContentProviderHolder holder = new ContentProviderHolder(this.info);
        holder.provider = this.provider;
        holder.noReleaseNeeded = this.noReleaseNeeded;
        holder.connection = conn;
        return holder;
    }

    public void setProcess(ProcessRecord proc) {
        this.proc = proc;
        for (int iconn = this.connections.size() - 1; iconn >= 0; --iconn) {
            ContentProviderConnection conn = this.connections.get(iconn);
            if (proc != null) {
                conn.startAssociationIfNeeded();
                continue;
            }
            conn.stopAssociation();
        }
        if (this.externalProcessTokenToHandle != null) {
            for (int iext = this.externalProcessTokenToHandle.size() - 1; iext >= 0; --iext) {
                ExternalProcessHandle handle = this.externalProcessTokenToHandle.valueAt(iext);
                if (proc != null) {
                    handle.startAssociationIfNeeded(this);
                    continue;
                }
                handle.stopAssociation();
            }
        }
    }

    public boolean canRunHere(ProcessRecord app) {
        return (this.info.multiprocess || this.info.processName.equals(app.processName)) && this.uid == app.info.uid;
    }

    public void addExternalProcessHandleLocked(IBinder token, int callingUid, String callingTag) {
        if (token == null) {
            ++this.externalProcessNoHandleCount;
        } else {
            ExternalProcessHandle handle;
            if (this.externalProcessTokenToHandle == null) {
                this.externalProcessTokenToHandle = new ArrayMap();
            }
            if ((handle = this.externalProcessTokenToHandle.get(token)) == null) {
                handle = new ExternalProcessHandle(token, callingUid, callingTag);
                this.externalProcessTokenToHandle.put(token, handle);
                handle.startAssociationIfNeeded(this);
            }
            ++handle.mAcquisitionCount;
        }
    }

    public boolean removeExternalProcessHandleLocked(IBinder token) {
        if (this.hasExternalProcessHandles()) {
            ExternalProcessHandle handle;
            boolean hasHandle = false;
            if (this.externalProcessTokenToHandle != null && (handle = this.externalProcessTokenToHandle.get(token)) != null) {
                hasHandle = true;
                --handle.mAcquisitionCount;
                if (handle.mAcquisitionCount == 0) {
                    this.removeExternalProcessHandleInternalLocked(token);
                    return true;
                }
            }
            if (!hasHandle) {
                --this.externalProcessNoHandleCount;
                return true;
            }
        }
        return false;
    }

    private void removeExternalProcessHandleInternalLocked(IBinder token) {
        ExternalProcessHandle handle = this.externalProcessTokenToHandle.get(token);
        handle.unlinkFromOwnDeathLocked();
        handle.stopAssociation();
        this.externalProcessTokenToHandle.remove(token);
        if (this.externalProcessTokenToHandle.size() == 0) {
            this.externalProcessTokenToHandle = null;
        }
    }

    public boolean hasExternalProcessHandles() {
        return this.externalProcessTokenToHandle != null || this.externalProcessNoHandleCount > 0;
    }

    public boolean hasConnectionOrHandle() {
        return !this.connections.isEmpty() || this.hasExternalProcessHandles();
    }

    void dump(PrintWriter pw, String prefix, boolean full) {
        if (full) {
            pw.print(prefix);
            pw.print("package=");
            pw.print(this.info.applicationInfo.packageName);
            pw.print(" process=");
            pw.println(this.info.processName);
        }
        pw.print(prefix);
        pw.print("proc=");
        pw.println(this.proc);
        if (this.launchingApp != null) {
            pw.print(prefix);
            pw.print("launchingApp=");
            pw.println(this.launchingApp);
        }
        if (full) {
            pw.print(prefix);
            pw.print("uid=");
            pw.print(this.uid);
            pw.print(" provider=");
            pw.println(this.provider);
        }
        if (this.singleton) {
            pw.print(prefix);
            pw.print("singleton=");
            pw.println(this.singleton);
        }
        pw.print(prefix);
        pw.print("authority=");
        pw.println(this.info.authority);
        if (full && (this.info.isSyncable || this.info.multiprocess || this.info.initOrder != 0)) {
            pw.print(prefix);
            pw.print("isSyncable=");
            pw.print(this.info.isSyncable);
            pw.print(" multiprocess=");
            pw.print(this.info.multiprocess);
            pw.print(" initOrder=");
            pw.println(this.info.initOrder);
        }
        if (full) {
            if (this.hasExternalProcessHandles()) {
                pw.print(prefix);
                pw.print("externals:");
                if (this.externalProcessTokenToHandle != null) {
                    pw.print(" w/token=");
                    pw.print(this.externalProcessTokenToHandle.size());
                }
                if (this.externalProcessNoHandleCount > 0) {
                    pw.print(" notoken=");
                    pw.print(this.externalProcessNoHandleCount);
                }
                pw.println();
            }
        } else if (this.connections.size() > 0 || this.externalProcessNoHandleCount > 0) {
            pw.print(prefix);
            pw.print(this.connections.size());
            pw.print(" connections, ");
            pw.print(this.externalProcessNoHandleCount);
            pw.println(" external handles");
        }
        if (this.connections.size() > 0) {
            if (full) {
                pw.print(prefix);
                pw.println("Connections:");
            }
            for (int i = 0; i < this.connections.size(); ++i) {
                ContentProviderConnection conn = this.connections.get(i);
                pw.print(prefix);
                pw.print("  -> ");
                pw.println(conn.toClientString());
                if (conn.provider == this) continue;
                pw.print(prefix);
                pw.print("    *** WRONG PROVIDER: ");
                pw.println(conn.provider);
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ContentProviderRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(UserHandle.getUserId(this.uid));
        sb.append(' ');
        sb.append(this.name.flattenToShortString());
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public String toShortString() {
        if (this.shortStringName != null) {
            return this.shortStringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append('/');
        sb.append(this.name.flattenToShortString());
        this.shortStringName = sb.toString();
        return this.shortStringName;
    }

    @Override
    public ComponentName getComponentName() {
        return this.name;
    }

    private class ExternalProcessHandle
    implements IBinder.DeathRecipient {
        private static final String LOG_TAG = "ExternalProcessHanldle";
        final IBinder mToken;
        final int mOwningUid;
        final String mOwningProcessName;
        int mAcquisitionCount;
        AssociationState.SourceState mAssociation;

        public ExternalProcessHandle(IBinder token, int owningUid, String owningProcessName) {
            this.mToken = token;
            this.mOwningUid = owningUid;
            this.mOwningProcessName = owningProcessName;
            try {
                token.linkToDeath(this, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Couldn't register for death for token: " + this.mToken, re);
            }
        }

        public void unlinkFromOwnDeathLocked() {
            this.mToken.unlinkToDeath(this, 0);
        }

        public void startAssociationIfNeeded(ContentProviderRecord provider) {
            if (!(this.mAssociation != null || provider.proc == null || provider.appInfo.uid == this.mOwningUid && provider.info.processName.equals(this.mOwningProcessName))) {
                ProcessStats.ProcessStateHolder holder = provider.proc.pkgList.get(provider.name.getPackageName());
                if (holder == null) {
                    Slog.wtf("ActivityManager", "No package in referenced provider " + provider.name.toShortString() + ": proc=" + provider.proc);
                } else if (holder.pkg == null) {
                    Slog.wtf("ActivityManager", "Inactive holder in referenced provider " + provider.name.toShortString() + ": proc=" + provider.proc);
                } else {
                    this.mAssociation = holder.pkg.getAssociationStateLocked(holder.state, provider.name.getClassName()).startSource(this.mOwningUid, this.mOwningProcessName, null);
                }
            }
        }

        public void stopAssociation() {
            if (this.mAssociation != null) {
                this.mAssociation.stop();
                this.mAssociation = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ActivityManagerService activityManagerService = ContentProviderRecord.this.service;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (ContentProviderRecord.this.hasExternalProcessHandles() && ContentProviderRecord.this.externalProcessTokenToHandle.get(this.mToken) != null) {
                        ContentProviderRecord.this.removeExternalProcessHandleInternalLocked(this.mToken);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }
    }
}

