/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.BatteryStats;
import android.os.SystemClock;
import android.os.health.HealthStatsWriter;
import android.os.health.PackageHealthStats;
import android.os.health.PidHealthStats;
import android.os.health.ProcessHealthStats;
import android.os.health.ServiceHealthStats;
import android.os.health.TimerStat;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.Map;

public class HealthStatsBatteryStatsWriter {
    private final long mNowRealtimeMs = SystemClock.elapsedRealtime();
    private final long mNowUptimeMs = SystemClock.uptimeMillis();

    public void writeUid(HealthStatsWriter uidWriter, BatteryStats bs, BatteryStats.Uid uid) {
        long sum;
        HealthStatsWriter writer;
        int i;
        uidWriter.addMeasurement(10001, bs.computeBatteryRealtime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        uidWriter.addMeasurement(10002, bs.computeBatteryUptime(this.mNowUptimeMs * 1000L, 0) / 1000L);
        uidWriter.addMeasurement(10003, bs.computeBatteryScreenOffRealtime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        uidWriter.addMeasurement(10004, bs.computeBatteryScreenOffUptime(this.mNowUptimeMs * 1000L, 0) / 1000L);
        for (Map.Entry<String, ? extends BatteryStats.Uid.Wakelock> entry : uid.getWakelockStats().entrySet()) {
            String key = entry.getKey();
            BatteryStats.Uid.Wakelock wakelock = entry.getValue();
            BatteryStats.Timer timer = wakelock.getWakeTime(1);
            this.addTimers(uidWriter, 10005, key, timer);
            timer = wakelock.getWakeTime(0);
            this.addTimers(uidWriter, 10006, key, timer);
            timer = wakelock.getWakeTime(2);
            this.addTimers(uidWriter, 10007, key, timer);
            timer = wakelock.getWakeTime(18);
            this.addTimers(uidWriter, 10008, key, timer);
        }
        for (Map.Entry<String, Object> entry : uid.getSyncStats().entrySet()) {
            this.addTimers(uidWriter, 10009, entry.getKey(), (BatteryStats.Timer)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : uid.getJobStats().entrySet()) {
            this.addTimers(uidWriter, 10010, entry.getKey(), (BatteryStats.Timer)entry.getValue());
        }
        SparseArray<? extends BatteryStats.Uid.Sensor> sensors = uid.getSensorStats();
        int N = sensors.size();
        for (i = 0; i < N; ++i) {
            int n = sensors.keyAt(i);
            if (n == -10000) {
                this.addTimer(uidWriter, 10011, sensors.valueAt(i).getSensorTime());
                continue;
            }
            this.addTimers(uidWriter, 10012, Integer.toString(n), sensors.valueAt(i).getSensorTime());
        }
        SparseArray<? extends BatteryStats.Uid.Pid> pids = uid.getPidStats();
        N = pids.size();
        for (i = 0; i < N; ++i) {
            HealthStatsWriter healthStatsWriter = new HealthStatsWriter(PidHealthStats.CONSTANTS);
            this.writePid(healthStatsWriter, pids.valueAt(i));
            uidWriter.addStats(10013, Integer.toString(pids.keyAt(i)), healthStatsWriter);
        }
        for (Map.Entry<String, ? extends BatteryStats.Uid.Proc> entry : uid.getProcessStats().entrySet()) {
            writer = new HealthStatsWriter(ProcessHealthStats.CONSTANTS);
            this.writeProc(writer, entry.getValue());
            uidWriter.addStats(10014, entry.getKey(), writer);
        }
        for (Map.Entry<String, Object> entry : uid.getPackageStats().entrySet()) {
            writer = new HealthStatsWriter(PackageHealthStats.CONSTANTS);
            this.writePkg(writer, (BatteryStats.Uid.Pkg)entry.getValue());
            uidWriter.addStats(10015, entry.getKey(), writer);
        }
        BatteryStats.ControllerActivityCounter controller = uid.getWifiControllerActivity();
        if (controller != null) {
            uidWriter.addMeasurement(10016, controller.getIdleTimeCounter().getCountLocked(0));
            uidWriter.addMeasurement(10017, controller.getRxTimeCounter().getCountLocked(0));
            sum = 0L;
            for (Iterator<Map.Entry<String, Object>> iterator : controller.getTxTimeCounters()) {
                sum += ((BatteryStats.LongCounter)((Object)iterator)).getCountLocked(0);
            }
            uidWriter.addMeasurement(10018, sum);
            uidWriter.addMeasurement(10019, controller.getPowerCounter().getCountLocked(0));
        }
        if ((controller = uid.getBluetoothControllerActivity()) != null) {
            uidWriter.addMeasurement(10020, controller.getIdleTimeCounter().getCountLocked(0));
            uidWriter.addMeasurement(10021, controller.getRxTimeCounter().getCountLocked(0));
            sum = 0L;
            for (Iterator<Map.Entry<String, Object>> iterator : controller.getTxTimeCounters()) {
                sum += ((BatteryStats.LongCounter)((Object)iterator)).getCountLocked(0);
            }
            uidWriter.addMeasurement(10022, sum);
            uidWriter.addMeasurement(10023, controller.getPowerCounter().getCountLocked(0));
        }
        if ((controller = uid.getModemControllerActivity()) != null) {
            uidWriter.addMeasurement(10024, controller.getIdleTimeCounter().getCountLocked(0));
            uidWriter.addMeasurement(10025, controller.getRxTimeCounter().getCountLocked(0));
            sum = 0L;
            for (Iterator<Map.Entry<String, Object>> iterator : controller.getTxTimeCounters()) {
                sum += ((BatteryStats.LongCounter)((Object)iterator)).getCountLocked(0);
            }
            uidWriter.addMeasurement(10026, sum);
            uidWriter.addMeasurement(10027, controller.getPowerCounter().getCountLocked(0));
        }
        uidWriter.addMeasurement(10028, uid.getWifiRunningTime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        uidWriter.addMeasurement(10029, uid.getFullWifiLockTime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        uidWriter.addTimer(10030, uid.getWifiScanCount(0), uid.getWifiScanTime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        uidWriter.addMeasurement(10031, uid.getWifiMulticastTime(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        this.addTimer(uidWriter, 10032, uid.getAudioTurnedOnTimer());
        this.addTimer(uidWriter, 10033, uid.getVideoTurnedOnTimer());
        this.addTimer(uidWriter, 10034, uid.getFlashlightTurnedOnTimer());
        this.addTimer(uidWriter, 10035, uid.getCameraTurnedOnTimer());
        this.addTimer(uidWriter, 10036, uid.getForegroundActivityTimer());
        this.addTimer(uidWriter, 10037, uid.getBluetoothScanTimer());
        this.addTimer(uidWriter, 10038, uid.getProcessStateTimer(0));
        this.addTimer(uidWriter, 10039, uid.getProcessStateTimer(1));
        this.addTimer(uidWriter, 10040, uid.getProcessStateTimer(4));
        this.addTimer(uidWriter, 10041, uid.getProcessStateTimer(2));
        this.addTimer(uidWriter, 10042, uid.getProcessStateTimer(3));
        this.addTimer(uidWriter, 10043, uid.getProcessStateTimer(6));
        this.addTimer(uidWriter, 10044, uid.getVibratorOnTimer());
        uidWriter.addMeasurement(10045, uid.getUserActivityCount(0, 0));
        uidWriter.addMeasurement(10046, uid.getUserActivityCount(1, 0));
        uidWriter.addMeasurement(10047, uid.getUserActivityCount(2, 0));
        uidWriter.addMeasurement(10048, uid.getNetworkActivityBytes(0, 0));
        uidWriter.addMeasurement(10049, uid.getNetworkActivityBytes(1, 0));
        uidWriter.addMeasurement(10050, uid.getNetworkActivityBytes(2, 0));
        uidWriter.addMeasurement(10051, uid.getNetworkActivityBytes(3, 0));
        uidWriter.addMeasurement(10052, uid.getNetworkActivityBytes(4, 0));
        uidWriter.addMeasurement(10053, uid.getNetworkActivityBytes(5, 0));
        uidWriter.addMeasurement(10054, uid.getNetworkActivityPackets(0, 0));
        uidWriter.addMeasurement(10055, uid.getNetworkActivityPackets(1, 0));
        uidWriter.addMeasurement(10056, uid.getNetworkActivityPackets(2, 0));
        uidWriter.addMeasurement(10057, uid.getNetworkActivityPackets(3, 0));
        uidWriter.addMeasurement(10058, uid.getNetworkActivityPackets(4, 0));
        uidWriter.addMeasurement(10059, uid.getNetworkActivityPackets(5, 0));
        uidWriter.addTimer(10061, uid.getMobileRadioActiveCount(0), uid.getMobileRadioActiveTime(0));
        uidWriter.addMeasurement(10062, uid.getUserCpuTimeUs(0) / 1000L);
        uidWriter.addMeasurement(10063, uid.getSystemCpuTimeUs(0) / 1000L);
        uidWriter.addMeasurement(10064, 0L);
    }

    public void writePid(HealthStatsWriter pidWriter, BatteryStats.Uid.Pid pid) {
        if (pid == null) {
            return;
        }
        pidWriter.addMeasurement(20001, pid.mWakeNesting);
        pidWriter.addMeasurement(20002, pid.mWakeSumMs);
        pidWriter.addMeasurement(20002, pid.mWakeStartMs);
    }

    public void writeProc(HealthStatsWriter procWriter, BatteryStats.Uid.Proc proc) {
        procWriter.addMeasurement(30001, proc.getUserTime(0));
        procWriter.addMeasurement(30002, proc.getSystemTime(0));
        procWriter.addMeasurement(30003, proc.getStarts(0));
        procWriter.addMeasurement(30004, proc.getNumCrashes(0));
        procWriter.addMeasurement(30005, proc.getNumAnrs(0));
        procWriter.addMeasurement(30006, proc.getForegroundTime(0));
    }

    public void writePkg(HealthStatsWriter pkgWriter, BatteryStats.Uid.Pkg pkg) {
        for (Map.Entry<String, ? extends BatteryStats.Uid.Pkg.Serv> entry : pkg.getServiceStats().entrySet()) {
            HealthStatsWriter writer = new HealthStatsWriter(ServiceHealthStats.CONSTANTS);
            this.writeServ(writer, entry.getValue());
            pkgWriter.addStats(40001, entry.getKey(), writer);
        }
        for (Map.Entry<String, Object> entry : pkg.getWakeupAlarmStats().entrySet()) {
            BatteryStats.Counter counter = (BatteryStats.Counter)entry.getValue();
            if (counter == null) continue;
            pkgWriter.addMeasurements(40002, entry.getKey(), counter.getCountLocked(0));
        }
    }

    public void writeServ(HealthStatsWriter servWriter, BatteryStats.Uid.Pkg.Serv serv) {
        servWriter.addMeasurement(50001, serv.getStarts(0));
        servWriter.addMeasurement(50002, serv.getLaunches(0));
    }

    private void addTimer(HealthStatsWriter writer, int key, BatteryStats.Timer timer) {
        if (timer != null) {
            writer.addTimer(key, timer.getCountLocked(0), timer.getTotalTimeLocked(this.mNowRealtimeMs * 1000L, 0) / 1000L);
        }
    }

    private void addTimers(HealthStatsWriter writer, int key, String name, BatteryStats.Timer timer) {
        if (timer != null) {
            writer.addTimers(key, name, new TimerStat(timer.getCountLocked(0), timer.getTotalTimeLocked(this.mNowRealtimeMs * 1000L, 0) / 1000L));
        }
    }
}

