/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import com.android.internal.annotations.GuardedBy;
import com.android.server.am.ActivityManagerService;

public final class LowMemDetector {
    private static final String TAG = "LowMemDetector";
    private final ActivityManagerService mAm;
    private final LowMemThread mLowMemThread;
    private boolean mAvailable;
    private final Object mPressureStateLock = new Object();
    @GuardedBy(value={"mPressureStateLock"})
    private int mPressureState = 0;
    public static final int MEM_PRESSURE_NONE = 0;
    public static final int MEM_PRESSURE_LOW = 1;
    public static final int MEM_PRESSURE_MEDIUM = 2;
    public static final int MEM_PRESSURE_HIGH = 3;

    LowMemDetector(ActivityManagerService am) {
        this.mAm = am;
        this.mLowMemThread = new LowMemThread();
        if (this.init() != 0) {
            this.mAvailable = false;
        } else {
            this.mAvailable = true;
            this.mLowMemThread.start();
        }
    }

    public boolean isAvailable() {
        return this.mAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemFactor() {
        Object object = this.mPressureStateLock;
        synchronized (object) {
            return this.mPressureState;
        }
    }

    private native int init();

    private native int waitForPressure();

    private final class LowMemThread
    extends Thread {
        private LowMemThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int newPressureState;
                if ((newPressureState = LowMemDetector.this.waitForPressure()) == -1) break;
                Object object = LowMemDetector.this.mPressureStateLock;
                synchronized (object) {
                    LowMemDetector.this.mPressureState = newPressureState;
                }
            }
            LowMemDetector.this.mAvailable = false;
        }
    }
}

