/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ApplicationErrorReport;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.system.UnixSocketAddress;
import android.util.Slog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ProcessRecord;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;

final class NativeCrashListener
extends Thread {
    static final String TAG = "NativeCrashListener";
    static final boolean DEBUG = false;
    static final boolean MORE_DEBUG = false;
    static final String DEBUGGERD_SOCKET_PATH = "/data/system/ndebugsocket";
    static final long SOCKET_TIMEOUT_MILLIS = 10000L;
    final ActivityManagerService mAm;

    NativeCrashListener(ActivityManagerService am) {
        this.mAm = am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        ackSignal = new byte[1];
        socketFile = new File("/data/system/ndebugsocket");
        if (socketFile.exists()) {
            socketFile.delete();
        }
        try {
            serverFd = Os.socket(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0);
            sockAddr = UnixSocketAddress.createFileSystem("/data/system/ndebugsocket");
            Os.bind(serverFd, sockAddr);
            Os.listen(serverFd, 1);
            Os.chmod("/data/system/ndebugsocket", 511);
            while (true) lbl-1000:
            // 5 sources

            {
                peerFd = null;
                try {
                    peerFd = Os.accept(serverFd, null);
                    if (peerFd == null) ** GOTO lbl-1000
                    this.consumeNativeCrashData(peerFd);
                }
                catch (Exception e) {
                    Slog.w("NativeCrashListener", "Error handling connection", e);
                }
                finally {
                    if (peerFd == null) continue;
                    try {
                        Os.write(peerFd, ackSignal, 0, 1);
                    }
                    catch (Exception var5_10) {}
                    try {
                        Os.close(peerFd);
                    }
                    catch (ErrnoException var5_11) {}
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Slog.e("NativeCrashListener", "Unable to init native debug socket!", e);
            return;
        }
        ** GOTO lbl-1000
    }

    static int unpackInt(byte[] buf, int offset) {
        int b0 = buf[offset] & 0xFF;
        int b1 = buf[offset + 1] & 0xFF;
        int b2 = buf[offset + 2] & 0xFF;
        int b3 = buf[offset + 3] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    static int readExactly(FileDescriptor fd, byte[] buffer, int offset, int numBytes) throws ErrnoException, InterruptedIOException {
        int totalRead = 0;
        while (numBytes > 0) {
            int n = Os.read(fd, buffer, offset + totalRead, numBytes);
            if (n <= 0) {
                return -1;
            }
            numBytes -= n;
            totalRead += n;
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeNativeCrashData(FileDescriptor fd) {
        block12: {
            byte[] buf = new byte[4096];
            ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
            try {
                block13: {
                    int pid;
                    block14: {
                        int bytes;
                        ProcessRecord pr;
                        StructTimeval timeout = StructTimeval.fromMillis(10000L);
                        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, timeout);
                        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, timeout);
                        int headerBytes = NativeCrashListener.readExactly(fd, buf, 0, 8);
                        if (headerBytes != 8) {
                            Slog.e(TAG, "Unable to read from debuggerd");
                            return;
                        }
                        pid = NativeCrashListener.unpackInt(buf, 0);
                        int signal = NativeCrashListener.unpackInt(buf, 4);
                        if (pid <= 0) break block13;
                        ActivityManagerService.PidMap pidMap = this.mAm.mPidsSelfLocked;
                        synchronized (pidMap) {
                            pr = this.mAm.mPidsSelfLocked.get(pid);
                        }
                        if (pr == null) break block14;
                        if (pr.isPersistent()) {
                            return;
                        }
                        do {
                            if ((bytes = Os.read(fd, buf, 0, buf.length)) <= 0) continue;
                            if (buf[bytes - 1] == 0) {
                                os.write(buf, 0, bytes - 1);
                                break;
                            }
                            os.write(buf, 0, bytes);
                        } while (bytes > 0);
                        ActivityManagerService activityManagerService = this.mAm;
                        synchronized (activityManagerService) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                pr.setCrashing(true);
                                pr.forceCrashReport = true;
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl43 : MonitorExitStatement: MONITOREXIT : var10_13
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        String reportString = new String(os.toByteArray(), "UTF-8");
                        new NativeCrashReporter(pr, signal, reportString).start();
                        break block12;
                    }
                    Slog.w(TAG, "Couldn't find ProcessRecord for pid " + pid);
                    break block12;
                }
                Slog.e(TAG, "Bogus pid!");
            }
            catch (Exception e) {
                Slog.e(TAG, "Exception dealing with report", e);
            }
        }
    }

    class NativeCrashReporter
    extends Thread {
        ProcessRecord mApp;
        int mSignal;
        String mCrashReport;

        NativeCrashReporter(ProcessRecord app, int signal, String report) {
            super("NativeCrashReport");
            this.mApp = app;
            this.mSignal = signal;
            this.mCrashReport = report;
        }

        @Override
        public void run() {
            try {
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo();
                ci.exceptionClassName = "Native crash";
                ci.exceptionMessage = Os.strsignal(this.mSignal);
                ci.throwFileName = "unknown";
                ci.throwClassName = "unknown";
                ci.throwMethodName = "unknown";
                ci.stackTrace = this.mCrashReport;
                NativeCrashListener.this.mAm.handleApplicationCrashInner("native_crash", this.mApp, this.mApp.processName, ci);
            }
            catch (Exception e) {
                Slog.e(NativeCrashListener.TAG, "Unable to report native crash", e);
            }
        }
    }
}

