/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.util.RingBuffer;
import java.io.PrintWriter;

public class OomAdjProfiler {
    private static final boolean PROFILING_DISABLED = true;
    @GuardedBy(value={"this"})
    private boolean mOnBattery;
    @GuardedBy(value={"this"})
    private boolean mScreenOff;
    @GuardedBy(value={"this"})
    private long mOomAdjStartTimeMs;
    @GuardedBy(value={"this"})
    private boolean mOomAdjStarted;
    @GuardedBy(value={"this"})
    private CpuTimes mOomAdjRunTime = new CpuTimes();
    @GuardedBy(value={"this"})
    private CpuTimes mSystemServerCpuTime = new CpuTimes();
    @GuardedBy(value={"this"})
    private long mLastSystemServerCpuTimeMs;
    @GuardedBy(value={"this"})
    private boolean mSystemServerCpuTimeUpdateScheduled;
    private final ProcessCpuTracker mProcessCpuTracker = new ProcessCpuTracker(false);
    @GuardedBy(value={"this"})
    final RingBuffer<CpuTimes> mOomAdjRunTimesHist = new RingBuffer<CpuTimes>(CpuTimes.class, 10);
    @GuardedBy(value={"this"})
    final RingBuffer<CpuTimes> mSystemServerCpuTimesHist = new RingBuffer<CpuTimes>(CpuTimes.class, 10);

    void batteryPowerChanged(boolean onBattery) {
    }

    void onWakefulnessChanged(int wakefulness) {
    }

    void oomAdjStarted() {
    }

    void oomAdjEnded() {
    }

    private void scheduleSystemServerCpuTimeUpdate() {
    }

    private void updateSystemServerCpuTime(boolean onBattery, boolean screenOff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        OomAdjProfiler oomAdjProfiler = this;
        synchronized (oomAdjProfiler) {
            if (this.mSystemServerCpuTime.isEmpty()) {
                return;
            }
            this.mOomAdjRunTimesHist.append(this.mOomAdjRunTime);
            this.mSystemServerCpuTimesHist.append(this.mSystemServerCpuTime);
            this.mOomAdjRunTime = new CpuTimes();
            this.mSystemServerCpuTime = new CpuTimes();
        }
    }

    void dump(PrintWriter pw) {
    }

    private class CpuTimes {
        private long mOnBatteryTimeMs;
        private long mOnBatteryScreenOffTimeMs;

        private CpuTimes() {
        }

        public void addCpuTimeMs(long cpuTimeMs) {
            this.addCpuTimeMs(cpuTimeMs, OomAdjProfiler.this.mOnBattery, OomAdjProfiler.this.mScreenOff);
        }

        public void addCpuTimeMs(long cpuTimeMs, boolean onBattery, boolean screenOff) {
            if (onBattery) {
                this.mOnBatteryTimeMs += cpuTimeMs;
                if (screenOff) {
                    this.mOnBatteryScreenOffTimeMs += cpuTimeMs;
                }
            }
        }

        public boolean isEmpty() {
            return this.mOnBatteryTimeMs == 0L && this.mOnBatteryScreenOffTimeMs == 0L;
        }

        public String toString() {
            return "[" + this.mOnBatteryTimeMs + "," + this.mOnBatteryScreenOffTimeMs + "]";
        }
    }
}

