/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.am.ActiveUids;
import com.android.server.am.ActivityManagerConstants;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppCompactor;
import com.android.server.am.BackupRecord;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.EventLogTags;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import com.android.server.am.UidRecord;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import com.android.server.wm.WindowProcessController;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class OomAdjuster {
    private static final String TAG = "OomAdjuster";
    static final String OOM_ADJ_REASON_METHOD = "updateOomAdj";
    static final String OOM_ADJ_REASON_NONE = "updateOomAdj_meh";
    static final String OOM_ADJ_REASON_ACTIVITY = "updateOomAdj_activityChange";
    static final String OOM_ADJ_REASON_FINISH_RECEIVER = "updateOomAdj_finishReceiver";
    static final String OOM_ADJ_REASON_START_RECEIVER = "updateOomAdj_startReceiver";
    static final String OOM_ADJ_REASON_BIND_SERVICE = "updateOomAdj_bindService";
    static final String OOM_ADJ_REASON_UNBIND_SERVICE = "updateOomAdj_unbindService";
    static final String OOM_ADJ_REASON_START_SERVICE = "updateOomAdj_startService";
    static final String OOM_ADJ_REASON_GET_PROVIDER = "updateOomAdj_getProvider";
    static final String OOM_ADJ_REASON_REMOVE_PROVIDER = "updateOomAdj_removeProvider";
    static final String OOM_ADJ_REASON_UI_VISIBILITY = "updateOomAdj_uiVisibility";
    static final String OOM_ADJ_REASON_WHITELIST = "updateOomAdj_whitelistChange";
    static final String OOM_ADJ_REASON_PROCESS_BEGIN = "updateOomAdj_processBegin";
    static final String OOM_ADJ_REASON_PROCESS_END = "updateOomAdj_processEnd";
    PowerManagerInternal mLocalPowerManager;
    AppCompactor mAppCompact;
    ActivityManagerConstants mConstants;
    final long[] mTmpLong = new long[3];
    int mAdjSeq = 0;
    int mNumServiceProcs = 0;
    int mNewNumAServiceProcs = 0;
    int mNewNumServiceProcs = 0;
    int mNumNonCachedProcs = 0;
    int mNumCachedHiddenProcs = 0;
    ActiveUids mActiveUids;
    private final Handler mProcessGroupHandler;
    private final ArraySet<BroadcastQueue> mTmpBroadcastQueue = new ArraySet();
    private final ActivityManagerService mService;
    private final ProcessList mProcessList;
    private final ComputeOomAdjWindowCallback mTmpComputeOomAdjWindowCallback = new ComputeOomAdjWindowCallback();

    OomAdjuster(ActivityManagerService service, ProcessList processList, ActiveUids activeUids) {
        this.mService = service;
        this.mProcessList = processList;
        this.mActiveUids = activeUids;
        this.mLocalPowerManager = LocalServices.getService(PowerManagerInternal.class);
        this.mConstants = this.mService.mConstants;
        this.mAppCompact = new AppCompactor(this.mService);
        ServiceThread adjusterThread = new ServiceThread(TAG, -10, false);
        adjusterThread.start();
        Process.setThreadGroupAndCpuset(adjusterThread.getThreadId(), 5);
        this.mProcessGroupHandler = new Handler(adjusterThread.getLooper(), msg -> {
            Trace.traceBegin(64L, "setProcessGroup");
            int pid = msg.arg1;
            int group = msg.arg2;
            try {
                Process.setProcessGroup(pid, group);
            }
            catch (Exception exception) {
            }
            finally {
                Trace.traceEnd(64L);
            }
            return true;
        });
    }

    void initSettings() {
        this.mAppCompact.init();
    }

    @GuardedBy(value={"mService"})
    boolean updateOomAdjLocked(ProcessRecord app, boolean oomAdjAll, String oomAdjReason) {
        ProcessRecord TOP_APP = this.mService.getTopAppLocked();
        boolean wasCached = app.cached;
        ++this.mAdjSeq;
        int cachedAdj = app.getCurRawAdj() >= 900 ? app.getCurRawAdj() : 1001;
        boolean success = this.updateOomAdjLocked(app, cachedAdj, TOP_APP, false, SystemClock.uptimeMillis());
        if (oomAdjAll && (wasCached != app.cached || app.getCurRawAdj() == 1001)) {
            this.updateOomAdjLocked(oomAdjReason);
        }
        return success;
    }

    @GuardedBy(value={"mService"})
    private final boolean updateOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        if (app.thread == null) {
            return false;
        }
        this.computeOomAdjLocked(app, cachedAdj, TOP_APP, doingAll, now, false);
        return this.applyOomAdjLocked(app, doingAll, now, SystemClock.elapsedRealtime());
    }

    @GuardedBy(value={"mService"})
    void updateOomAdjLocked(String oomAdjReason) {
        int i;
        ProcessRecord app;
        int i2;
        int cachedFactor;
        int emptyFactor;
        Trace.traceBegin(64L, oomAdjReason);
        this.mService.mOomAdjProfiler.oomAdjStarted();
        ProcessRecord TOP_APP = this.mService.getTopAppLocked();
        long now = SystemClock.uptimeMillis();
        long nowElapsed = SystemClock.elapsedRealtime();
        long oldTime = now - 1800000L;
        int N = this.mProcessList.getLruSizeLocked();
        for (int i3 = this.mActiveUids.size() - 1; i3 >= 0; --i3) {
            UidRecord uidRec = this.mActiveUids.valueAt(i3);
            uidRec.reset();
        }
        if (this.mService.mAtmInternal != null) {
            this.mService.mAtmInternal.rankTaskLayersIfNeeded();
        }
        ++this.mAdjSeq;
        this.mNewNumServiceProcs = 0;
        this.mNewNumAServiceProcs = 0;
        int emptyProcessLimit = this.mConstants.CUR_MAX_EMPTY_PROCESSES;
        int cachedProcessLimit = this.mConstants.CUR_MAX_CACHED_PROCESSES - emptyProcessLimit;
        int numSlots = 10;
        int numEmptyProcs = N - this.mNumNonCachedProcs - this.mNumCachedHiddenProcs;
        if (numEmptyProcs > cachedProcessLimit) {
            numEmptyProcs = cachedProcessLimit;
        }
        if ((emptyFactor = (numEmptyProcs + 10 - 1) / 10) < 1) {
            emptyFactor = 1;
        }
        if ((cachedFactor = (this.mNumCachedHiddenProcs > 0 ? this.mNumCachedHiddenProcs + 10 - 1 : 1) / 10) < 1) {
            cachedFactor = 1;
        }
        int stepCached = -1;
        int stepEmpty = -1;
        int numCached = 0;
        int numCachedExtraGroup = 0;
        int numEmpty = 0;
        int numTrimming = 0;
        int lastCachedGroup = 0;
        int lastCachedGroupImportance = 0;
        int lastCachedGroupUid = 0;
        this.mNumNonCachedProcs = 0;
        this.mNumCachedHiddenProcs = 0;
        int curCachedAdj = 900;
        int nextCachedAdj = curCachedAdj + 10;
        int curCachedImpAdj = 0;
        int curEmptyAdj = 905;
        int nextEmptyAdj = curEmptyAdj + 10;
        boolean retryCycles = false;
        for (i2 = N - 1; i2 >= 0; --i2) {
            app = this.mProcessList.mLruProcesses.get(i2);
            app.containsCycle = false;
            app.setCurRawProcState(20);
            app.setCurRawAdj(1001);
        }
        block9: for (i2 = N - 1; i2 >= 0; --i2) {
            app = this.mProcessList.mLruProcesses.get(i2);
            if (app.killedByAm || app.thread == null) continue;
            app.procStateChanged = false;
            this.computeOomAdjLocked(app, 1001, TOP_APP, true, now, false);
            retryCycles |= app.containsCycle;
            if (app.curAdj < 1001) continue;
            switch (app.getCurProcState()) {
                case 17: 
                case 18: 
                case 19: {
                    boolean inGroup = false;
                    if (app.connectionGroup != 0) {
                        if (lastCachedGroupUid == app.uid && lastCachedGroup == app.connectionGroup) {
                            if (app.connectionImportance > lastCachedGroupImportance) {
                                lastCachedGroupImportance = app.connectionImportance;
                                if (curCachedAdj < nextCachedAdj && curCachedAdj < 999) {
                                    ++curCachedImpAdj;
                                }
                            }
                            inGroup = true;
                        } else {
                            lastCachedGroupUid = app.uid;
                            lastCachedGroup = app.connectionGroup;
                            lastCachedGroupImportance = app.connectionImportance;
                        }
                    }
                    if (!inGroup && curCachedAdj != nextCachedAdj) {
                        curCachedImpAdj = 0;
                        if (++stepCached >= cachedFactor) {
                            stepCached = 0;
                            curCachedAdj = nextCachedAdj;
                            if ((nextCachedAdj += 10) > 999) {
                                nextCachedAdj = 999;
                            }
                        }
                    }
                    app.setCurRawAdj(curCachedAdj + curCachedImpAdj);
                    app.curAdj = app.modifyRawOomAdj(curCachedAdj + curCachedImpAdj);
                    continue block9;
                }
                default: {
                    if (curEmptyAdj != nextEmptyAdj && ++stepEmpty >= emptyFactor) {
                        stepEmpty = 0;
                        curEmptyAdj = nextEmptyAdj;
                        if ((nextEmptyAdj += 10) > 999) {
                            nextEmptyAdj = 999;
                        }
                    }
                    app.setCurRawAdj(curEmptyAdj);
                    app.curAdj = app.modifyRawOomAdj(curEmptyAdj);
                }
            }
        }
        int cycleCount = 0;
        while (retryCycles && cycleCount < 10) {
            int i4;
            ++cycleCount;
            retryCycles = false;
            for (i4 = 0; i4 < N; ++i4) {
                ProcessRecord app2 = this.mProcessList.mLruProcesses.get(i4);
                if (app2.killedByAm || app2.thread == null || !app2.containsCycle) continue;
                --app2.adjSeq;
                --app2.completedAdjSeq;
            }
            for (i4 = 0; i4 < N; ++i4) {
                ProcessRecord app3 = this.mProcessList.mLruProcesses.get(i4);
                if (app3.killedByAm || app3.thread == null || !app3.containsCycle || !this.computeOomAdjLocked(app3, app3.getCurRawAdj(), TOP_APP, true, now, true)) continue;
                retryCycles = true;
            }
        }
        lastCachedGroupUid = 0;
        lastCachedGroup = 0;
        for (int i5 = N - 1; i5 >= 0; --i5) {
            ProcessRecord app4 = this.mProcessList.mLruProcesses.get(i5);
            if (app4.killedByAm || app4.thread == null) continue;
            this.applyOomAdjLocked(app4, true, now, nowElapsed);
            switch (app4.getCurProcState()) {
                case 17: 
                case 18: {
                    ++this.mNumCachedHiddenProcs;
                    ++numCached;
                    if (app4.connectionGroup != 0) {
                        if (lastCachedGroupUid == app4.info.uid && lastCachedGroup == app4.connectionGroup) {
                            ++numCachedExtraGroup;
                        } else {
                            lastCachedGroupUid = app4.info.uid;
                            lastCachedGroup = app4.connectionGroup;
                        }
                    } else {
                        lastCachedGroup = 0;
                        lastCachedGroupUid = 0;
                    }
                    if (numCached - numCachedExtraGroup <= cachedProcessLimit) break;
                    app4.kill("cached #" + numCached, true);
                    break;
                }
                case 20: {
                    if (numEmpty > this.mConstants.CUR_TRIM_EMPTY_PROCESSES && app4.lastActivityTime < oldTime) {
                        app4.kill("empty for " + (oldTime + 1800000L - app4.lastActivityTime) / 1000L + "s", true);
                        break;
                    }
                    if (++numEmpty <= emptyProcessLimit) break;
                    app4.kill("empty #" + numEmpty, true);
                    break;
                }
                default: {
                    ++this.mNumNonCachedProcs;
                }
            }
            if (app4.isolated && app4.services.size() <= 0 && app4.isolatedEntryPoint == null) {
                app4.kill("isolated not needed", true);
            } else {
                UidRecord uidRec = app4.uidRecord;
                if (uidRec != null) {
                    uidRec.ephemeral = app4.info.isInstantApp();
                    if (uidRec.getCurProcState() > app4.getCurProcState()) {
                        uidRec.setCurProcState(app4.getCurProcState());
                    }
                    if (app4.hasForegroundServices()) {
                        uidRec.foregroundServices = true;
                    }
                }
            }
            if (app4.getCurProcState() < 15 || app4.killedByAm) continue;
            ++numTrimming;
        }
        this.mService.incrementProcStateSeqAndNotifyAppsLocked();
        this.mNumServiceProcs = this.mNewNumServiceProcs;
        boolean allChanged = this.mService.updateLowMemStateLocked(numCached, numEmpty, numTrimming);
        if (this.mService.mAlwaysFinishActivities) {
            this.mService.mAtmInternal.scheduleDestroyAllActivities("always-finish");
        }
        if (allChanged) {
            this.mService.requestPssAllProcsLocked(now, false, this.mService.mProcessStats.isMemFactorLowered());
        }
        ArrayList<UidRecord> becameIdle = null;
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.startUidChanges();
        }
        for (i = this.mActiveUids.size() - 1; i >= 0; --i) {
            boolean isCached;
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            int uidChange = 0;
            if (uidRec.getCurProcState() == 21 || uidRec.setProcState == uidRec.getCurProcState() && uidRec.setWhitelist == uidRec.curWhitelist) continue;
            if (ActivityManager.isProcStateBackground(uidRec.getCurProcState()) && !uidRec.curWhitelist) {
                if (!ActivityManager.isProcStateBackground(uidRec.setProcState) || uidRec.setWhitelist) {
                    uidRec.lastBackgroundTime = nowElapsed;
                    if (!this.mService.mHandler.hasMessages(58)) {
                        this.mService.mHandler.sendEmptyMessageDelayed(58, this.mConstants.BACKGROUND_SETTLE_TIME);
                    }
                }
                if (uidRec.idle && !uidRec.setIdle) {
                    uidChange = 2;
                    if (becameIdle == null) {
                        becameIdle = new ArrayList<UidRecord>();
                    }
                    becameIdle.add(uidRec);
                }
            } else {
                if (uidRec.idle) {
                    uidChange = 4;
                    EventLogTags.writeAmUidActive(uidRec.uid);
                    uidRec.idle = false;
                }
                uidRec.lastBackgroundTime = 0L;
            }
            boolean wasCached = uidRec.setProcState > 12;
            boolean bl = isCached = uidRec.getCurProcState() > 12;
            if (wasCached != isCached || uidRec.setProcState == 21) {
                uidChange |= isCached ? 8 : 16;
            }
            uidRec.setProcState = uidRec.getCurProcState();
            uidRec.setWhitelist = uidRec.curWhitelist;
            uidRec.setIdle = uidRec.idle;
            this.mService.mAtmInternal.onUidProcStateChanged(uidRec.uid, uidRec.setProcState);
            this.mService.enqueueUidChangeLocked(uidRec, -1, uidChange);
            this.mService.noteUidProcessState(uidRec.uid, uidRec.getCurProcState());
            if (!uidRec.foregroundServices) continue;
            this.mService.mServices.foregroundServiceProcStateChangedLocked(uidRec);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.finishUidChanges();
        }
        if (becameIdle != null) {
            for (i = becameIdle.size() - 1; i >= 0; --i) {
                this.mService.mServices.stopInBackgroundLocked(((UidRecord)becameIdle.get((int)i)).uid);
            }
        }
        if (this.mService.mProcessStats.shouldWriteNowLocked(now)) {
            this.mService.mHandler.post(new ActivityManagerService.ProcStatsRunnable(this.mService, this.mService.mProcessStats));
        }
        this.mService.mProcessStats.updateTrackingAssociationsLocked(this.mAdjSeq, now);
        this.mService.mOomAdjProfiler.oomAdjEnded();
        Trace.traceEnd(64L);
    }

    private final boolean computeOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now, boolean cycleReEval) {
        int procState;
        int schedGroup;
        int adj;
        if (this.mAdjSeq == app.adjSeq) {
            if (app.adjSeq == app.completedAdjSeq) {
                return false;
            }
            app.containsCycle = true;
            return false;
        }
        if (app.thread == null) {
            app.adjSeq = this.mAdjSeq;
            app.setCurrentSchedulingGroup(0);
            app.setCurProcState(20);
            app.curAdj = 999;
            app.setCurRawAdj(999);
            app.completedAdjSeq = app.adjSeq;
            return false;
        }
        app.adjTypeCode = 0;
        app.adjSource = null;
        app.adjTarget = null;
        app.empty = false;
        app.cached = false;
        WindowProcessController wpc = app.getWindowProcessController();
        int appUid = app.info.uid;
        int logUid = this.mService.mCurOomAdjUid;
        int prevAppAdj = app.curAdj;
        int prevProcState = app.getCurProcState();
        if (app.maxAdj <= 0) {
            if (logUid == appUid) {
                this.mService.reportOomAdjMessageLocked("ActivityManager", "Making fixed: " + app);
            }
            app.adjType = "fixed";
            app.adjSeq = this.mAdjSeq;
            app.setCurRawAdj(app.maxAdj);
            app.setHasForegroundActivities(false);
            app.setCurrentSchedulingGroup(2);
            app.setCurProcState(0);
            app.systemNoUi = true;
            if (app == TOP_APP) {
                app.systemNoUi = false;
                app.setCurrentSchedulingGroup(3);
                app.adjType = "pers-top-activity";
            } else if (app.hasTopUi()) {
                app.systemNoUi = false;
                app.adjType = "pers-top-ui";
            } else if (wpc.hasVisibleActivities()) {
                app.systemNoUi = false;
            }
            if (!app.systemNoUi) {
                if (this.mService.mWakefulness == 1) {
                    app.setCurProcState(1);
                    app.setCurrentSchedulingGroup(3);
                } else {
                    app.setCurProcState(6);
                    app.setCurrentSchedulingGroup(1);
                }
            }
            app.setCurRawProcState(app.getCurProcState());
            app.curAdj = app.maxAdj;
            app.completedAdjSeq = app.adjSeq;
            return app.curAdj < prevAppAdj || app.getCurProcState() < prevProcState;
        }
        app.systemNoUi = false;
        int PROCESS_STATE_CUR_TOP = this.mService.mAtmInternal.getTopProcessState();
        boolean foregroundActivities = false;
        this.mTmpBroadcastQueue.clear();
        if (PROCESS_STATE_CUR_TOP == 2 && app == TOP_APP) {
            adj = 0;
            schedGroup = 3;
            app.adjType = "top-activity";
            foregroundActivities = true;
            procState = PROCESS_STATE_CUR_TOP;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making top: " + app);
            }
        } else if (app.runningRemoteAnimation) {
            adj = 100;
            schedGroup = 3;
            app.adjType = "running-remote-anim";
            procState = PROCESS_STATE_CUR_TOP;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making running remote anim: " + app);
            }
        } else if (app.getActiveInstrumentation() != null) {
            adj = 0;
            schedGroup = 2;
            app.adjType = "instrumentation";
            procState = 5;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making instrumentation: " + app);
            }
        } else if (this.mService.isReceivingBroadcastLocked(app, this.mTmpBroadcastQueue)) {
            adj = 0;
            schedGroup = this.mTmpBroadcastQueue.contains(this.mService.mFgBroadcastQueue) ? 2 : 0;
            app.adjType = "broadcast";
            procState = 12;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making broadcast: " + app);
            }
        } else if (app.executingServices.size() > 0) {
            adj = 0;
            schedGroup = app.execServicesFg ? 2 : 0;
            app.adjType = "exec-service";
            procState = 11;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making exec-service: " + app);
            }
        } else if (app == TOP_APP) {
            adj = 0;
            schedGroup = 0;
            app.adjType = "top-sleeping";
            foregroundActivities = true;
            procState = PROCESS_STATE_CUR_TOP;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making top (sleeping): " + app);
            }
        } else {
            schedGroup = 0;
            adj = cachedAdj;
            procState = 20;
            app.cached = true;
            app.empty = true;
            app.adjType = "cch-empty";
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Making empty: " + app);
            }
        }
        if (!foregroundActivities && wpc.hasActivities()) {
            this.mTmpComputeOomAdjWindowCallback.initialize(app, adj, foregroundActivities, procState, schedGroup, appUid, logUid, PROCESS_STATE_CUR_TOP);
            int minLayer = wpc.computeOomAdjFromActivities(99, this.mTmpComputeOomAdjWindowCallback);
            adj = this.mTmpComputeOomAdjWindowCallback.adj;
            foregroundActivities = this.mTmpComputeOomAdjWindowCallback.foregroundActivities;
            procState = this.mTmpComputeOomAdjWindowCallback.procState;
            schedGroup = this.mTmpComputeOomAdjWindowCallback.schedGroup;
            if (adj == 100) {
                adj += minLayer;
            }
        }
        if (procState > 19 && app.hasRecentTasks()) {
            procState = 19;
            app.adjType = "cch-rec";
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to cached recent: " + app);
            }
        }
        if (adj > 200 || procState > 3) {
            if (app.hasForegroundServices()) {
                adj = 200;
                if (app.hasLocationForegroundServices()) {
                    procState = 3;
                    app.adjType = "fg-service-location";
                } else {
                    procState = 5;
                    app.adjType = "fg-service";
                }
                app.cached = false;
                schedGroup = 2;
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise to " + app.adjType + ": " + app + " ");
                }
            } else if (app.hasOverlayUi()) {
                adj = 200;
                procState = 7;
                app.cached = false;
                app.adjType = "has-overlay-ui";
                schedGroup = 2;
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise to overlay ui: " + app);
                }
            }
        }
        if (app.hasForegroundServices() && adj > 50 && (app.lastTopTime + this.mConstants.TOP_TO_FGS_GRACE_DURATION > now || app.setProcState <= 2)) {
            adj = 50;
            app.adjType = "fg-service-act";
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Raise to recent fg: " + app);
            }
        }
        if ((adj > 200 || procState > 9) && app.forcingToImportant != null) {
            adj = 200;
            procState = 9;
            app.cached = false;
            app.adjType = "force-imp";
            app.adjSource = app.forcingToImportant;
            schedGroup = 2;
            if (logUid == appUid) {
                this.reportOomAdjMessageLocked("ActivityManager", "Raise to force imp: " + app);
            }
        }
        if (this.mService.mAtmInternal.isHeavyWeightProcess(app.getWindowProcessController())) {
            if (adj > 400) {
                adj = 400;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "heavy";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to heavy: " + app);
                }
            }
            if (procState > 14) {
                procState = 14;
                app.adjType = "heavy";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to heavy: " + app);
                }
            }
        }
        if (wpc.isHomeProcess()) {
            if (adj > 600) {
                adj = 600;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "home";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to home: " + app);
                }
            }
            if (procState > 15) {
                procState = 15;
                app.adjType = "home";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to home: " + app);
                }
            }
        }
        if (wpc.isPreviousProcess() && app.hasActivities()) {
            if (adj > 700) {
                adj = 700;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "previous";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to prev: " + app);
                }
            }
            if (procState > 16) {
                procState = 16;
                app.adjType = "previous";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to prev: " + app);
                }
            }
        }
        app.setCurRawAdj(!cycleReEval ? adj : Math.min(adj, app.getCurRawAdj()));
        app.setCurRawProcState(!cycleReEval ? procState : Math.min(procState, app.getCurRawProcState()));
        app.hasStartedServices = false;
        app.adjSeq = this.mAdjSeq;
        BackupRecord backupTarget = this.mService.mBackupTargets.get(app.userId);
        if (backupTarget != null && app == backupTarget.app) {
            if (adj > 300) {
                adj = 300;
                if (procState > 9) {
                    procState = 9;
                }
                app.adjType = "backup";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to backup: " + app);
                }
                app.cached = false;
            }
            if (procState > 10) {
                procState = 10;
                app.adjType = "backup";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to backup: " + app);
                }
            }
        }
        for (int is = app.services.size() - 1; is >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --is) {
            ServiceRecord s = app.services.valueAt(is);
            if (s.startRequested) {
                app.hasStartedServices = true;
                if (procState > 11) {
                    procState = 11;
                    app.adjType = "started-services";
                    if (logUid == appUid) {
                        this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to started service: " + app);
                    }
                }
                if (app.hasShownUi && !wpc.isHomeProcess()) {
                    if (adj > 500) {
                        app.adjType = "cch-started-ui-services";
                    }
                } else {
                    if (now < s.lastActivity + this.mConstants.MAX_SERVICE_INACTIVITY && adj > 500) {
                        adj = 500;
                        app.adjType = "started-services";
                        if (logUid == appUid) {
                            this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to started service: " + app);
                        }
                        app.cached = false;
                    }
                    if (adj > 500) {
                        app.adjType = "cch-started-services";
                    }
                }
            }
            ArrayMap<IBinder, ArrayList<ConnectionRecord>> serviceConnections = s.getConnections();
            for (int conni = serviceConnections.size() - 1; conni >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --conni) {
                ArrayList<ConnectionRecord> clist = serviceConnections.valueAt(conni);
                for (int i = 0; i < clist.size() && (adj > 0 || schedGroup == 0 || procState > 2); ++i) {
                    ConnectionRecord cr = clist.get(i);
                    if (cr.binding.client == app) continue;
                    boolean trackedProcState = false;
                    if ((cr.flags & 0x20) == 0) {
                        ProcessRecord client = cr.binding.client;
                        this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now, cycleReEval);
                        if (this.shouldSkipDueToCycle(app, client, procState, adj, cycleReEval)) continue;
                        int clientAdj = client.getCurRawAdj();
                        int clientProcState = client.getCurRawProcState();
                        if (clientProcState >= 17) {
                            clientProcState = 20;
                        }
                        String adjType = null;
                        if ((cr.flags & 0x10) != 0) {
                            if (app.hasShownUi && !wpc.isHomeProcess()) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-ui-services";
                                }
                                app.cached = false;
                                clientAdj = adj;
                                clientProcState = procState;
                            } else if (now >= s.lastActivity + this.mConstants.MAX_SERVICE_INACTIVITY) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-services";
                                }
                                clientAdj = adj;
                            }
                        }
                        if (adj > clientAdj) {
                            if (app.hasShownUi && !wpc.isHomeProcess() && clientAdj > 200) {
                                if (adj >= 900) {
                                    adjType = "cch-bound-ui-services";
                                }
                            } else {
                                int newAdj;
                                if ((cr.flags & 0x48) != 0) {
                                    if (clientAdj >= -700) {
                                        newAdj = clientAdj;
                                    } else {
                                        newAdj = -700;
                                        schedGroup = 2;
                                        procState = 0;
                                        cr.trackProcState(procState, this.mAdjSeq, now);
                                        trackedProcState = true;
                                    }
                                } else {
                                    newAdj = (cr.flags & 0x100) != 0 && clientAdj < 200 && adj > 250 ? 250 : ((cr.flags & 0x40000000) != 0 && clientAdj < 200 && adj > 200 ? 200 : (clientAdj >= 200 ? clientAdj : (adj > 100 ? Math.max(clientAdj, 100) : adj)));
                                }
                                if (!client.cached) {
                                    app.cached = false;
                                }
                                if (adj > newAdj) {
                                    adj = newAdj;
                                    app.setCurRawAdj(adj);
                                    adjType = "service";
                                }
                            }
                        }
                        if ((cr.flags & 0x800004) == 0) {
                            int curSchedGroup = client.getCurrentSchedulingGroup();
                            if (curSchedGroup > schedGroup) {
                                schedGroup = (cr.flags & 0x40) != 0 ? curSchedGroup : 2;
                            }
                            if (clientProcState < 2) {
                                int bestState;
                                int n = bestState = cr.hasFlag(4096) ? 3 : 6;
                                clientProcState = (cr.flags & 0x4000000) != 0 ? bestState : (this.mService.mWakefulness == 1 && (cr.flags & 0x2000000) != 0 ? bestState : 7);
                            } else if (clientProcState == 2) {
                                if (cr.notHasFlag(4096)) {
                                    clientProcState = 4;
                                }
                            } else if (clientProcState <= 5 && cr.notHasFlag(4096)) {
                                clientProcState = 5;
                            }
                        } else if ((cr.flags & 0x800000) == 0) {
                            if (clientProcState < 9) {
                                clientProcState = 9;
                            }
                        } else if (clientProcState < 8) {
                            clientProcState = 8;
                        }
                        if (schedGroup < 3 && (cr.flags & 0x80000) != 0) {
                            schedGroup = 3;
                        }
                        if (!trackedProcState) {
                            cr.trackProcState(clientProcState, this.mAdjSeq, now);
                        }
                        if (procState > clientProcState) {
                            procState = clientProcState;
                            app.setCurRawProcState(procState);
                            if (adjType == null) {
                                adjType = "service";
                            }
                        }
                        if (procState < 8 && (cr.flags & 0x20000000) != 0) {
                            app.setPendingUiClean(true);
                        }
                        if (adjType != null) {
                            app.adjType = adjType;
                            app.adjTypeCode = 2;
                            app.adjSource = cr.binding.client;
                            app.adjSourceProcState = clientProcState;
                            app.adjTarget = s.instanceName;
                            if (logUid == appUid) {
                                this.reportOomAdjMessageLocked("ActivityManager", "Raise to " + adjType + ": " + app + ", due to " + cr.binding.client + " adj=" + adj + " procState=" + ProcessList.makeProcStateString(procState));
                            }
                        }
                    }
                    if ((cr.flags & 0x8000000) != 0) {
                        app.treatLikeActivity = true;
                    }
                    ActivityServiceConnectionsHolder<ConnectionRecord> a = cr.activity;
                    if ((cr.flags & 0x80) == 0 || a == null || adj <= 0 || !a.isActivityVisible()) continue;
                    adj = 0;
                    app.setCurRawAdj(adj);
                    if ((cr.flags & 4) == 0) {
                        schedGroup = (cr.flags & 0x40) != 0 ? 4 : 2;
                    }
                    app.cached = false;
                    app.adjType = "service";
                    app.adjTypeCode = 2;
                    app.adjSource = a;
                    app.adjSourceProcState = procState;
                    app.adjTarget = s.instanceName;
                    if (logUid != appUid) continue;
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise to service w/activity: " + app);
                }
            }
        }
        for (int provi = app.pubProviders.size() - 1; provi >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --provi) {
            ContentProviderRecord cpr = app.pubProviders.valueAt(provi);
            for (int i = cpr.connections.size() - 1; i >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --i) {
                ContentProviderConnection conn = cpr.connections.get(i);
                ProcessRecord client = conn.client;
                if (client == app) continue;
                this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now, cycleReEval);
                if (this.shouldSkipDueToCycle(app, client, procState, adj, cycleReEval)) continue;
                int clientAdj = client.getCurRawAdj();
                int clientProcState = client.getCurRawProcState();
                if (clientProcState >= 17) {
                    clientProcState = 20;
                }
                String adjType = null;
                if (adj > clientAdj) {
                    if (app.hasShownUi && !wpc.isHomeProcess() && clientAdj > 200) {
                        adjType = "cch-ui-provider";
                    } else {
                        adj = clientAdj > 0 ? clientAdj : 0;
                        app.setCurRawAdj(adj);
                        adjType = "provider";
                    }
                    app.cached &= client.cached;
                }
                if (clientProcState <= 5) {
                    if (adjType == null) {
                        adjType = "provider";
                    }
                    clientProcState = clientProcState == 2 ? 4 : 6;
                }
                conn.trackProcState(clientProcState, this.mAdjSeq, now);
                if (procState > clientProcState) {
                    procState = clientProcState;
                    app.setCurRawProcState(procState);
                }
                if (client.getCurrentSchedulingGroup() > schedGroup) {
                    schedGroup = 2;
                }
                if (adjType == null) continue;
                app.adjType = adjType;
                app.adjTypeCode = 1;
                app.adjSource = client;
                app.adjSourceProcState = clientProcState;
                app.adjTarget = cpr.name;
                if (logUid != appUid) continue;
                this.reportOomAdjMessageLocked("ActivityManager", "Raise to " + adjType + ": " + app + ", due to " + client + " adj=" + adj + " procState=" + ProcessList.makeProcStateString(procState));
            }
            if (!cpr.hasExternalProcessHandles()) continue;
            if (adj > 0) {
                adj = 0;
                app.setCurRawAdj(adj);
                schedGroup = 2;
                app.cached = false;
                app.adjType = "ext-provider";
                app.adjTarget = cpr.name;
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to external provider: " + app);
                }
            }
            if (procState <= 7) continue;
            procState = 7;
            app.setCurRawProcState(procState);
            if (logUid != appUid) continue;
            this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to external provider: " + app);
        }
        if (app.lastProviderTime > 0L && app.lastProviderTime + this.mConstants.CONTENT_PROVIDER_RETAIN_TIME > now) {
            if (adj > 700) {
                adj = 700;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "recent-provider";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to recent provider: " + app);
                }
            }
            if (procState > 16) {
                procState = 16;
                app.adjType = "recent-provider";
                if (logUid == appUid) {
                    this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to recent provider: " + app);
                }
            }
        }
        if (procState >= 20) {
            if (app.hasClientActivities()) {
                procState = 18;
                app.adjType = "cch-client-act";
            } else if (app.treatLikeActivity) {
                procState = 17;
                app.adjType = "cch-as-act";
            }
        }
        if (adj == 500) {
            if (doingAll) {
                app.serviceb = this.mNewNumAServiceProcs > this.mNumServiceProcs / 3;
                ++this.mNewNumServiceProcs;
                if (!app.serviceb) {
                    if (this.mService.mLastMemoryLevel > 0 && app.lastPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
                        app.serviceHighRam = true;
                        app.serviceb = true;
                    } else {
                        ++this.mNewNumAServiceProcs;
                    }
                } else {
                    app.serviceHighRam = false;
                }
            }
            if (app.serviceb) {
                adj = 800;
            }
        }
        app.setCurRawAdj(adj);
        if (adj > app.maxAdj) {
            adj = app.maxAdj;
            if (app.maxAdj <= 250) {
                schedGroup = 2;
            }
        }
        if (procState >= 6 && this.mService.mWakefulness != 1 && schedGroup > 1) {
            schedGroup = 1;
        }
        app.curAdj = app.modifyRawOomAdj(adj);
        app.setCurrentSchedulingGroup(schedGroup);
        app.setCurProcState(procState);
        app.setCurRawProcState(procState);
        app.setHasForegroundActivities(foregroundActivities);
        app.completedAdjSeq = this.mAdjSeq;
        return app.curAdj < prevAppAdj || app.getCurProcState() < prevProcState;
    }

    private boolean shouldSkipDueToCycle(ProcessRecord app, ProcessRecord client, int procState, int adj, boolean cycleReEval) {
        if (client.containsCycle) {
            app.containsCycle = true;
            if (client.completedAdjSeq < this.mAdjSeq) {
                if (cycleReEval) {
                    if (client.getCurRawProcState() >= procState && client.getCurRawAdj() >= adj) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @GuardedBy(value={"mService"})
    void reportOomAdjMessageLocked(String tag, String msg) {
        Slog.d(tag, msg);
        if (this.mService.mCurOomAdjObserver != null) {
            this.mService.mUiHandler.obtainMessage(70, msg).sendToTarget();
        }
    }

    @GuardedBy(value={"mService"})
    private final boolean applyOomAdjLocked(ProcessRecord app, boolean doingAll, long now, long nowElapsed) {
        int changes;
        boolean success;
        block56: {
            int curSchedGroup;
            success = true;
            if (app.getCurRawAdj() != app.setRawAdj) {
                app.setRawAdj = app.getCurRawAdj();
            }
            changes = 0;
            if (this.mAppCompact.useCompaction() && this.mService.mBooted) {
                if (app.curAdj != app.setAdj) {
                    if (app.setAdj <= 200 && (app.curAdj == 700 || app.curAdj == 600)) {
                        this.mAppCompact.compactAppSome(app);
                    } else if ((app.setAdj < 900 || app.setAdj > 999) && app.curAdj >= 900 && app.curAdj <= 999) {
                        this.mAppCompact.compactAppFull(app);
                    }
                } else if (this.mService.mWakefulness != 1 && app.setAdj < 0 && this.mAppCompact.shouldCompactPersistent(app, now)) {
                    this.mAppCompact.compactAppPersistent(app);
                } else if (this.mService.mWakefulness != 1 && app.getCurProcState() == 6 && this.mAppCompact.shouldCompactBFGS(app, now)) {
                    this.mAppCompact.compactAppBfgs(app);
                }
            }
            if (app.curAdj != app.setAdj) {
                ProcessList.setOomAdj(app.pid, app.uid, app.curAdj);
                if (this.mService.mCurOomAdjUid == app.info.uid) {
                    String msg = "Set " + app.pid + " " + app.processName + " adj " + app.curAdj + ": " + app.adjType;
                    this.reportOomAdjMessageLocked("ActivityManager", msg);
                }
                app.setAdj = app.curAdj;
                app.verifiedAdj = -10000;
            }
            if (app.setSchedGroup != (curSchedGroup = app.getCurrentSchedulingGroup())) {
                int oldSchedGroup = app.setSchedGroup;
                app.setSchedGroup = curSchedGroup;
                if (this.mService.mCurOomAdjUid == app.uid) {
                    String msg = "Setting sched group of " + app.processName + " to " + curSchedGroup + ": " + app.adjType;
                    this.reportOomAdjMessageLocked("ActivityManager", msg);
                }
                if (app.waitingToKill != null && app.curReceivers.isEmpty() && app.setSchedGroup == 0) {
                    app.kill(app.waitingToKill, true);
                    success = false;
                } else {
                    int processGroup;
                    switch (curSchedGroup) {
                        case 0: {
                            processGroup = 0;
                            break;
                        }
                        case 3: 
                        case 4: {
                            processGroup = 5;
                            break;
                        }
                        case 1: {
                            processGroup = 7;
                            break;
                        }
                        default: {
                            processGroup = -1;
                        }
                    }
                    this.mProcessGroupHandler.sendMessage(this.mProcessGroupHandler.obtainMessage(0, app.pid, processGroup));
                    try {
                        if (curSchedGroup == 3) {
                            if (oldSchedGroup != 3) {
                                app.getWindowProcessController().onTopProcChanged();
                                if (this.mService.mUseFifoUiScheduling) {
                                    app.savedPriority = Process.getThreadPriority(app.pid);
                                    ActivityManagerService.scheduleAsFifoPriority(app.pid, true);
                                    if (app.renderThreadTid != 0) {
                                        ActivityManagerService.scheduleAsFifoPriority(app.renderThreadTid, true);
                                    }
                                } else {
                                    Process.setThreadPriority(app.pid, -10);
                                    if (app.renderThreadTid != 0) {
                                        try {
                                            Process.setThreadPriority(app.renderThreadTid, -10);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                    }
                                }
                            }
                            break block56;
                        }
                        if (oldSchedGroup != 3 || curSchedGroup == 3) break block56;
                        app.getWindowProcessController().onTopProcChanged();
                        if (this.mService.mUseFifoUiScheduling) {
                            try {
                                Process.setThreadScheduler(app.pid, 0, 0);
                                Process.setThreadPriority(app.pid, app.savedPriority);
                                if (app.renderThreadTid != 0) {
                                    Process.setThreadScheduler(app.renderThreadTid, 0, 0);
                                    Process.setThreadPriority(app.renderThreadTid, -4);
                                }
                                break block56;
                            }
                            catch (IllegalArgumentException e) {
                                Slog.w(TAG, "Failed to set scheduling policy, thread does not exist:\n" + e);
                            }
                            catch (SecurityException e) {
                                Slog.w(TAG, "Failed to set scheduling policy, not allowed:\n" + e);
                            }
                            break block56;
                        }
                        Process.setThreadPriority(app.pid, 0);
                        if (app.renderThreadTid != 0) {
                            Process.setThreadPriority(app.renderThreadTid, 0);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (app.repForegroundActivities != app.hasForegroundActivities()) {
            app.repForegroundActivities = app.hasForegroundActivities();
            changes |= 1;
        }
        if (app.getReportedProcState() != app.getCurProcState()) {
            app.setReportedProcState(app.getCurProcState());
            if (app.thread != null) {
                try {
                    app.thread.setProcessState(app.getReportedProcState());
                }
                catch (RemoteException oldSchedGroup) {
                    // empty catch block
                }
            }
        }
        if (app.setProcState == 21 || ProcessList.procStatesDifferForMem(app.getCurProcState(), app.setProcState)) {
            app.lastStateTime = now;
            app.nextPssTime = ProcessList.computeNextPssTime(app.getCurProcState(), app.procStateMemTracker, this.mService.mTestPssMode, this.mService.mAtmInternal.isSleeping(), now);
        } else if ((now > app.nextPssTime || now > app.lastPssTime + 3600000L && now > app.lastStateTime + ProcessList.minTimeFromStateChange(this.mService.mTestPssMode)) && this.mService.requestPssLocked(app, app.setProcState)) {
            app.nextPssTime = ProcessList.computeNextPssTime(app.getCurProcState(), app.procStateMemTracker, this.mService.mTestPssMode, this.mService.mAtmInternal.isSleeping(), now);
        }
        if (app.setProcState != app.getCurProcState()) {
            boolean curImportant;
            if (this.mService.mCurOomAdjUid == app.uid) {
                String msg = "Proc state change of " + app.processName + " to " + ProcessList.makeProcStateString(app.getCurProcState()) + " (" + app.getCurProcState() + "): " + app.adjType;
                this.reportOomAdjMessageLocked("ActivityManager", msg);
            }
            boolean setImportant = app.setProcState < 11;
            boolean bl = curImportant = app.getCurProcState() < 11;
            if (setImportant && !curImportant) {
                app.setWhenUnimportant(now);
                app.lastCpuTime = 0L;
            }
            this.maybeUpdateUsageStatsLocked(app, nowElapsed);
            this.maybeUpdateLastTopTime(app, now);
            app.setProcState = app.getCurProcState();
            if (app.setProcState >= 15) {
                app.notCachedSinceIdle = false;
            }
            if (!doingAll) {
                this.mService.setProcessTrackerStateLocked(app, this.mService.mProcessStats.getMemFactorLocked(), now);
            } else {
                app.procStateChanged = true;
            }
        } else if (app.reportedInteraction && nowElapsed - app.getInteractionEventTime() > this.mConstants.USAGE_STATS_INTERACTION_INTERVAL) {
            this.maybeUpdateUsageStatsLocked(app, nowElapsed);
        } else if (!app.reportedInteraction && nowElapsed - app.getFgInteractionTime() > this.mConstants.SERVICE_USAGE_INTERACTION_TIME) {
            this.maybeUpdateUsageStatsLocked(app, nowElapsed);
        }
        if (changes != 0) {
            ActivityManagerService.ProcessChangeItem item = this.mService.enqueueProcessChangeItemLocked(app.pid, app.info.uid);
            item.changes = changes;
            item.foregroundActivities = app.repForegroundActivities;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void maybeUpdateUsageStats(ProcessRecord app, long nowElapsed) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.maybeUpdateUsageStatsLocked(app, nowElapsed);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @GuardedBy(value={"mService"})
    private void maybeUpdateUsageStatsLocked(ProcessRecord app, long nowElapsed) {
        boolean isInteraction;
        if (this.mService.mUsageStatsService == null) {
            return;
        }
        if (app.getCurProcState() <= 2 || app.getCurProcState() == 4) {
            isInteraction = true;
            app.setFgInteractionTime(0L);
        } else if (app.getCurProcState() <= 5) {
            if (app.getFgInteractionTime() == 0L) {
                app.setFgInteractionTime(nowElapsed);
                isInteraction = false;
            } else {
                isInteraction = nowElapsed > app.getFgInteractionTime() + this.mConstants.SERVICE_USAGE_INTERACTION_TIME;
            }
        } else {
            isInteraction = app.getCurProcState() <= 7;
            app.setFgInteractionTime(0L);
        }
        if (isInteraction && (!app.reportedInteraction || nowElapsed - app.getInteractionEventTime() > this.mConstants.USAGE_STATS_INTERACTION_INTERVAL)) {
            app.setInteractionEventTime(nowElapsed);
            String[] packages = app.getPackageList();
            if (packages != null) {
                for (int i = 0; i < packages.length; ++i) {
                    this.mService.mUsageStatsService.reportEvent(packages[i], app.userId, 6);
                }
            }
        }
        app.reportedInteraction = isInteraction;
        if (!isInteraction) {
            app.setInteractionEventTime(0L);
        }
    }

    private void maybeUpdateLastTopTime(ProcessRecord app, long nowUptime) {
        if (app.setProcState <= 2 && app.getCurProcState() > 2) {
            app.lastTopTime = nowUptime;
        }
    }

    @GuardedBy(value={"mService"})
    void idleUidsLocked() {
        int N = this.mActiveUids.size();
        if (N <= 0) {
            return;
        }
        long nowElapsed = SystemClock.elapsedRealtime();
        long maxBgTime = nowElapsed - this.mConstants.BACKGROUND_SETTLE_TIME;
        long nextTime = 0L;
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.startUidChanges();
        }
        for (int i = N - 1; i >= 0; --i) {
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            long bgTime = uidRec.lastBackgroundTime;
            if (bgTime <= 0L || uidRec.idle) continue;
            if (bgTime <= maxBgTime) {
                EventLogTags.writeAmUidIdle(uidRec.uid);
                uidRec.idle = true;
                uidRec.setIdle = true;
                this.mService.doStopUidLocked(uidRec.uid, uidRec);
                continue;
            }
            if (nextTime != 0L && nextTime <= bgTime) continue;
            nextTime = bgTime;
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.finishUidChanges();
        }
        if (nextTime > 0L) {
            this.mService.mHandler.removeMessages(58);
            this.mService.mHandler.sendEmptyMessageDelayed(58, nextTime + this.mConstants.BACKGROUND_SETTLE_TIME - nowElapsed);
        }
    }

    @GuardedBy(value={"mService"})
    final void setAppIdTempWhitelistStateLocked(int appId, boolean onWhitelist) {
        boolean changed = false;
        for (int i = this.mActiveUids.size() - 1; i >= 0; --i) {
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            if (UserHandle.getAppId(uidRec.uid) != appId || uidRec.curWhitelist == onWhitelist) continue;
            uidRec.curWhitelist = onWhitelist;
            changed = true;
        }
        if (changed) {
            this.updateOomAdjLocked(OOM_ADJ_REASON_WHITELIST);
        }
    }

    @GuardedBy(value={"mService"})
    final void setUidTempWhitelistStateLocked(int uid, boolean onWhitelist) {
        boolean changed = false;
        UidRecord uidRec = this.mActiveUids.get(uid);
        if (uidRec != null && uidRec.curWhitelist != onWhitelist) {
            uidRec.curWhitelist = onWhitelist;
            this.updateOomAdjLocked(OOM_ADJ_REASON_WHITELIST);
        }
    }

    @GuardedBy(value={"mService"})
    void dumpProcessListVariablesLocked(ProtoOutputStream proto) {
        proto.write(1120986464305L, this.mAdjSeq);
        proto.write(1120986464306L, this.mProcessList.mLruSeq);
        proto.write(1120986464307L, this.mNumNonCachedProcs);
        proto.write(1120986464309L, this.mNumServiceProcs);
        proto.write(1120986464310L, this.mNewNumServiceProcs);
    }

    @GuardedBy(value={"mService"})
    void dumpSequenceNumbersLocked(PrintWriter pw) {
        pw.println("  mAdjSeq=" + this.mAdjSeq + " mLruSeq=" + this.mProcessList.mLruSeq);
    }

    @GuardedBy(value={"mService"})
    void dumpProcCountsLocked(PrintWriter pw) {
        pw.println("  mNumNonCachedProcs=" + this.mNumNonCachedProcs + " (" + this.mProcessList.getLruSizeLocked() + " total) mNumCachedHiddenProcs=" + this.mNumCachedHiddenProcs + " mNumServiceProcs=" + this.mNumServiceProcs + " mNewNumServiceProcs=" + this.mNewNumServiceProcs);
    }

    @GuardedBy(value={"mService"})
    void dumpAppCompactorSettings(PrintWriter pw) {
        this.mAppCompact.dump(pw);
    }

    private final class ComputeOomAdjWindowCallback
    implements WindowProcessController.ComputeOomAdjCallback {
        ProcessRecord app;
        int adj;
        boolean foregroundActivities;
        int procState;
        int schedGroup;
        int appUid;
        int logUid;
        int processStateCurTop;

        private ComputeOomAdjWindowCallback() {
        }

        void initialize(ProcessRecord app, int adj, boolean foregroundActivities, int procState, int schedGroup, int appUid, int logUid, int processStateCurTop) {
            this.app = app;
            this.adj = adj;
            this.foregroundActivities = foregroundActivities;
            this.procState = procState;
            this.schedGroup = schedGroup;
            this.appUid = appUid;
            this.logUid = logUid;
            this.processStateCurTop = processStateCurTop;
        }

        @Override
        public void onVisibleActivity() {
            if (this.adj > 100) {
                this.adj = 100;
                this.app.adjType = "vis-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to vis-activity: " + this.app);
                }
            }
            if (this.procState > this.processStateCurTop) {
                this.procState = this.processStateCurTop;
                this.app.adjType = "vis-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to vis-activity (top): " + this.app);
                }
            }
            if (this.schedGroup < 2) {
                this.schedGroup = 2;
            }
            this.app.cached = false;
            this.app.empty = false;
            this.foregroundActivities = true;
        }

        @Override
        public void onPausedActivity() {
            if (this.adj > 200) {
                this.adj = 200;
                this.app.adjType = "pause-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to pause-activity: " + this.app);
                }
            }
            if (this.procState > this.processStateCurTop) {
                this.procState = this.processStateCurTop;
                this.app.adjType = "pause-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to pause-activity (top): " + this.app);
                }
            }
            if (this.schedGroup < 2) {
                this.schedGroup = 2;
            }
            this.app.cached = false;
            this.app.empty = false;
            this.foregroundActivities = true;
        }

        @Override
        public void onStoppingActivity(boolean finishing) {
            if (this.adj > 200) {
                this.adj = 200;
                this.app.adjType = "stop-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise adj to stop-activity: " + this.app);
                }
            }
            if (!finishing && this.procState > 16) {
                this.procState = 16;
                this.app.adjType = "stop-activity";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to stop-activity: " + this.app);
                }
            }
            this.app.cached = false;
            this.app.empty = false;
            this.foregroundActivities = true;
        }

        @Override
        public void onOtherActivity() {
            if (this.procState > 17) {
                this.procState = 17;
                this.app.adjType = "cch-act";
                if (this.logUid == this.appUid) {
                    OomAdjuster.this.reportOomAdjMessageLocked("ActivityManager", "Raise procstate to cached activity: " + this.app);
                }
            }
        }
    }
}

