/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.LocalServices;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.UserController;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.SafeActivityOptions;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PendingIntentController {
    private static final String TAG = "ActivityManager";
    private static final String TAG_MU = "ActivityManager_MU";
    final Object mLock = new Object();
    final Handler mH;
    ActivityManagerInternal mAmInternal;
    final UserController mUserController;
    final ActivityTaskManagerInternal mAtmInternal;
    final HashMap<PendingIntentRecord.Key, WeakReference<PendingIntentRecord>> mIntentSenderRecords = new HashMap();

    PendingIntentController(Looper looper, UserController userController) {
        this.mH = new Handler(looper);
        this.mAtmInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        this.mUserController = userController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActivityManagerInternalAdded() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingIntentRecord getIntentSender(int type, String packageName, int callingUid, int userId, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle bOptions) {
        Object object = this.mLock;
        synchronized (object) {
            PendingIntentRecord rec;
            if (intents != null) {
                for (int i = 0; i < intents.length; ++i) {
                    intents[i].setDefusable(true);
                }
            }
            Bundle.setDefusable(bOptions, true);
            boolean noCreate = (flags & 0x20000000) != 0;
            boolean cancelCurrent = (flags & 0x10000000) != 0;
            boolean updateCurrent = (flags & 0x8000000) != 0;
            PendingIntentRecord.Key key = new PendingIntentRecord.Key(type, packageName, token, resultWho, requestCode, intents, resolvedTypes, flags &= 0xC7FFFFFF, SafeActivityOptions.fromBundle(bOptions), userId);
            WeakReference<PendingIntentRecord> ref = this.mIntentSenderRecords.get(key);
            PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
            if (rec != null) {
                if (!cancelCurrent) {
                    if (updateCurrent) {
                        if (rec.key.requestIntent != null) {
                            rec.key.requestIntent.replaceExtras(intents != null ? intents[intents.length - 1] : null);
                        }
                        if (intents != null) {
                            intents[intents.length - 1] = rec.key.requestIntent;
                            rec.key.allIntents = intents;
                            rec.key.allResolvedTypes = resolvedTypes;
                        } else {
                            rec.key.allIntents = null;
                            rec.key.allResolvedTypes = null;
                        }
                    }
                    return rec;
                }
                this.makeIntentSenderCanceled(rec);
                this.mIntentSenderRecords.remove(key);
            }
            if (noCreate) {
                return rec;
            }
            rec = new PendingIntentRecord(this, key, callingUid);
            this.mIntentSenderRecords.put(key, rec.ref);
            return rec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removePendingIntentsForPackage(String packageName, int userId, int appId, boolean doIt) {
        boolean didSomething = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIntentSenderRecords.size() <= 0) {
                return false;
            }
            Iterator<WeakReference<PendingIntentRecord>> it = this.mIntentSenderRecords.values().iterator();
            while (it.hasNext()) {
                WeakReference<PendingIntentRecord> wpir = it.next();
                if (wpir == null) {
                    it.remove();
                    continue;
                }
                PendingIntentRecord pir = (PendingIntentRecord)wpir.get();
                if (pir == null) {
                    it.remove();
                    continue;
                }
                if (packageName != null ? UserHandle.getAppId(pir.uid) != appId || userId != -1 && pir.key.userId != userId || !pir.key.packageName.equals(packageName) : pir.key.userId != userId) continue;
                if (!doIt) {
                    return true;
                }
                didSomething = true;
                it.remove();
                this.makeIntentSenderCanceled(pir);
                if (pir.key.activity == null) continue;
                Message m = PooledLambda.obtainMessage(PendingIntentController::clearPendingResultForActivity, this, pir.key.activity, pir.ref);
                this.mH.sendMessage(m);
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntentSender(IIntentSender sender) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            PendingIntentRecord rec = (PendingIntentRecord)sender;
            try {
                int uid = AppGlobals.getPackageManager().getPackageUid(rec.key.packageName, 0x10000000, UserHandle.getCallingUserId());
                if (!UserHandle.isSameApp(uid, Binder.getCallingUid())) {
                    String msg = "Permission Denial: cancelIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " is not allowed to cancel package " + rec.key.packageName;
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
            this.cancelIntentSender(rec, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntentSender(PendingIntentRecord rec, boolean cleanActivity) {
        Object object = this.mLock;
        synchronized (object) {
            this.makeIntentSenderCanceled(rec);
            this.mIntentSenderRecords.remove(rec.key);
            if (cleanActivity && rec.key.activity != null) {
                Message m = PooledLambda.obtainMessage(PendingIntentController::clearPendingResultForActivity, this, rec.key.activity, rec.ref);
                this.mH.sendMessage(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        boolean isCancelled;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            PendingIntentRecord pendingIntent = (PendingIntentRecord)sender;
            isCancelled = pendingIntent.canceled;
            if (!isCancelled) {
                pendingIntent.registerCancelListenerLocked(receiver);
            }
        }
        if (isCancelled) {
            try {
                receiver.send(0, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            ((PendingIntentRecord)sender).unregisterCancelListenerLocked(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPendingIntentWhitelistDuration(IIntentSender target, IBinder whitelistToken, long duration) {
        if (!(target instanceof PendingIntentRecord)) {
            Slog.w(TAG, "markAsSentFromNotification(): not a PendingIntentRecord: " + target);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            ((PendingIntentRecord)target).setWhitelistDurationLocked(whitelistToken, duration);
        }
    }

    private void makeIntentSenderCanceled(PendingIntentRecord rec) {
        rec.canceled = true;
        RemoteCallbackList<IResultReceiver> callbacks = rec.detachCancelListenersLocked();
        if (callbacks != null) {
            Message m = PooledLambda.obtainMessage(PendingIntentController::handlePendingIntentCancelled, this, callbacks);
            this.mH.sendMessage(m);
        }
    }

    private void handlePendingIntentCancelled(RemoteCallbackList<IResultReceiver> callbacks) {
        int N = callbacks.beginBroadcast();
        for (int i = 0; i < N; ++i) {
            try {
                callbacks.getBroadcastItem(i).send(0, null);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        callbacks.finishBroadcast();
        callbacks.kill();
    }

    private void clearPendingResultForActivity(IBinder activityToken, WeakReference<PendingIntentRecord> pir) {
        this.mAtmInternal.clearPendingResultForActivity(activityToken, pir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpPendingIntents(PrintWriter pw, boolean dumpAll, String dumpPackage) {
        Object object = this.mLock;
        synchronized (object) {
            boolean printed = false;
            pw.println("ACTIVITY MANAGER PENDING INTENTS (dumpsys activity intents)");
            if (this.mIntentSenderRecords.size() > 0) {
                int i;
                ArrayMap<String, ArrayList<PendingIntentRecord>> byPackage = new ArrayMap<String, ArrayList<PendingIntentRecord>>();
                ArrayList<WeakReference<PendingIntentRecord>> weakRefs = new ArrayList<WeakReference<PendingIntentRecord>>();
                for (WeakReference<PendingIntentRecord> ref : this.mIntentSenderRecords.values()) {
                    PendingIntentRecord rec;
                    PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
                    if (rec == null) {
                        weakRefs.add(ref);
                        continue;
                    }
                    if (dumpPackage != null && !dumpPackage.equals(rec.key.packageName)) continue;
                    ArrayList<PendingIntentRecord> list = (ArrayList<PendingIntentRecord>)byPackage.get(rec.key.packageName);
                    if (list == null) {
                        list = new ArrayList<PendingIntentRecord>();
                        byPackage.put(rec.key.packageName, list);
                    }
                    list.add(rec);
                }
                for (i = 0; i < byPackage.size(); ++i) {
                    ArrayList intents = (ArrayList)byPackage.valueAt(i);
                    printed = true;
                    pw.print("  * ");
                    pw.print((String)byPackage.keyAt(i));
                    pw.print(": ");
                    pw.print(intents.size());
                    pw.println(" items");
                    for (int j = 0; j < intents.size(); ++j) {
                        pw.print("    #");
                        pw.print(j);
                        pw.print(": ");
                        pw.println(intents.get(j));
                        if (!dumpAll) continue;
                        ((PendingIntentRecord)intents.get(j)).dump(pw, "      ");
                    }
                }
                if (weakRefs.size() > 0) {
                    printed = true;
                    pw.println("  * WEAK REFS:");
                    for (i = 0; i < weakRefs.size(); ++i) {
                        pw.print("    #");
                        pw.print(i);
                        pw.print(": ");
                        pw.println(weakRefs.get(i));
                    }
                }
            }
            if (!printed) {
                pw.println("  (nothing)");
            }
        }
    }
}

