/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.ProgressReporter;
import com.android.server.UiThread;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.EventLogTags;
import java.util.List;

public abstract class PreBootBroadcaster
extends IIntentReceiver.Stub {
    private static final String TAG = "PreBootBroadcaster";
    private final ActivityManagerService mService;
    private final int mUserId;
    private final ProgressReporter mProgress;
    private final boolean mQuiet;
    private final Intent mIntent;
    private final List<ResolveInfo> mTargets;
    private int mIndex = 0;
    private static final int MSG_SHOW = 1;
    private static final int MSG_HIDE = 2;
    private Handler mHandler = new Handler(UiThread.get().getLooper(), null, true){

        @Override
        public void handleMessage(Message msg) {
            Context context = ((PreBootBroadcaster)PreBootBroadcaster.this).mService.mContext;
            NotificationManager notifManager = context.getSystemService(NotificationManager.class);
            int max = msg.arg1;
            int index = msg.arg2;
            switch (msg.what) {
                case 1: {
                    CharSequence title = context.getText(17039494);
                    Intent intent = new Intent();
                    intent.setClassName("com.android.settings", "com.android.settings.HelpTrampoline");
                    intent.putExtra("android.intent.extra.TEXT", "help_url_upgrading");
                    PendingIntent contentIntent = context.getPackageManager().resolveActivity(intent, 0) != null ? PendingIntent.getActivity(context, 0, intent, 0) : null;
                    Notification notif = new Notification.Builder(((PreBootBroadcaster)PreBootBroadcaster.this).mService.mContext, SystemNotificationChannels.UPDATES).setSmallIcon(17303519).setWhen(0L).setOngoing(true).setTicker(title).setColor(context.getColor(17170460)).setContentTitle(title).setContentIntent(contentIntent).setVisibility(1).setProgress(max, index, false).build();
                    notifManager.notifyAsUser(PreBootBroadcaster.TAG, 13, notif, UserHandle.of(PreBootBroadcaster.this.mUserId));
                    break;
                }
                case 2: {
                    notifManager.cancelAsUser(PreBootBroadcaster.TAG, 13, UserHandle.of(PreBootBroadcaster.this.mUserId));
                }
            }
        }
    };

    public PreBootBroadcaster(ActivityManagerService service, int userId, ProgressReporter progress, boolean quiet) {
        this.mService = service;
        this.mUserId = userId;
        this.mProgress = progress;
        this.mQuiet = quiet;
        this.mIntent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        this.mIntent.addFlags(0x2000100);
        this.mTargets = this.mService.mContext.getPackageManager().queryBroadcastReceiversAsUser(this.mIntent, 0x100000, UserHandle.of(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNext() {
        if (this.mIndex >= this.mTargets.size()) {
            this.mHandler.obtainMessage(2).sendToTarget();
            this.onFinished();
            return;
        }
        if (!this.mService.isUserRunning(this.mUserId, 0)) {
            Slog.i(TAG, "User " + this.mUserId + " is no longer running; skipping remaining receivers");
            this.mHandler.obtainMessage(2).sendToTarget();
            this.onFinished();
            return;
        }
        if (!this.mQuiet) {
            this.mHandler.obtainMessage(1, this.mTargets.size(), this.mIndex).sendToTarget();
        }
        ResolveInfo ri = this.mTargets.get(this.mIndex++);
        ComponentName componentName = ri.activityInfo.getComponentName();
        if (this.mProgress != null) {
            CharSequence label = ri.activityInfo.loadLabel(this.mService.mContext.getPackageManager());
            this.mProgress.setProgress(this.mIndex, this.mTargets.size(), this.mService.mContext.getString(17039488, label));
        }
        Slog.i(TAG, "Pre-boot of " + componentName.toShortString() + " for user " + this.mUserId);
        EventLogTags.writeAmPreBoot(this.mUserId, componentName.getPackageName());
        this.mIntent.setComponent(componentName);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mService.broadcastIntentLocked(null, null, this.mIntent, null, this, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, Binder.getCallingUid(), Binder.getCallingPid(), this.mUserId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl32 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
        this.sendNext();
    }

    public abstract void onFinished();
}

