/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.IApplicationThread;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.AppZygote;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.EventLog;
import android.util.LongSparseArray;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ProcessMap;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.os.Zygote;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.MemInfoReader;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.Watchdog;
import com.android.server.am.ActiveUids;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.EventLogTags;
import com.android.server.am.HostingRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.UidRecord;
import com.android.server.pm.dex.DexManager;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import libcore.io.IoUtils;

public final class ProcessList {
    static final String TAG = "ActivityManager";
    static final int MIN_CRASH_INTERVAL = 60000;
    static final int INVALID_ADJ = -10000;
    static final int UNKNOWN_ADJ = 1001;
    static final int CACHED_APP_MAX_ADJ = 999;
    static final int CACHED_APP_MIN_ADJ = 900;
    static final int CACHED_APP_LMK_FIRST_ADJ = 950;
    static final int CACHED_APP_IMPORTANCE_LEVELS = 5;
    static final int SERVICE_B_ADJ = 800;
    static final int PREVIOUS_APP_ADJ = 700;
    static final int HOME_APP_ADJ = 600;
    static final int SERVICE_ADJ = 500;
    static final int HEAVY_WEIGHT_APP_ADJ = 400;
    static final int BACKUP_APP_ADJ = 300;
    static final int PERCEPTIBLE_LOW_APP_ADJ = 250;
    static final int PERCEPTIBLE_APP_ADJ = 200;
    static final int VISIBLE_APP_ADJ = 100;
    static final int VISIBLE_APP_LAYER_MAX = 99;
    static final int PERCEPTIBLE_RECENT_FOREGROUND_APP_ADJ = 50;
    static final int FOREGROUND_APP_ADJ = 0;
    static final int PERSISTENT_SERVICE_ADJ = -700;
    static final int PERSISTENT_PROC_ADJ = -800;
    static final int SYSTEM_ADJ = -900;
    static final int NATIVE_ADJ = -1000;
    static final int PAGE_SIZE = 4096;
    static final int SCHED_GROUP_BACKGROUND = 0;
    static final int SCHED_GROUP_RESTRICTED = 1;
    static final int SCHED_GROUP_DEFAULT = 2;
    public static final int SCHED_GROUP_TOP_APP = 3;
    static final int SCHED_GROUP_TOP_APP_BOUND = 4;
    static final int MIN_CACHED_APPS = 2;
    static final long MAX_EMPTY_TIME = 1800000L;
    static final int TRIM_CRITICAL_THRESHOLD = 3;
    static final int TRIM_LOW_THRESHOLD = 5;
    private static final String PROPERTY_USE_APP_IMAGE_STARTUP_CACHE = "persist.device_config.runtime_native.use_app_image_startup_cache";
    static final byte LMK_TARGET = 0;
    static final byte LMK_PROCPRIO = 1;
    static final byte LMK_PROCREMOVE = 2;
    static final byte LMK_PROCPURGE = 3;
    static final byte LMK_GETKILLCNT = 4;
    ActivityManagerService mService = null;
    static KillHandler sKillHandler = null;
    static ServiceThread sKillThread = null;
    private final int[] mOomAdj = new int[]{0, 100, 200, 250, 900, 950};
    private final int[] mOomMinFreeLow = new int[]{12288, 18432, 24576, 36864, 43008, 49152};
    private final int[] mOomMinFreeHigh = new int[]{73728, 92160, 110592, 129024, 147456, 184320};
    private final int[] mOomMinFree = new int[this.mOomAdj.length];
    private final long mTotalMemMb;
    private long mCachedRestoreLevel;
    private boolean mHaveDisplaySize;
    private static Object sLmkdSocketLock = new Object();
    @GuardedBy(value={"sLmkdSocketLock"})
    private static LocalSocket sLmkdSocket;
    @GuardedBy(value={"sLmkdSocketLock"})
    private static OutputStream sLmkdOutputStream;
    @GuardedBy(value={"sLmkdSocketLock"})
    private static InputStream sLmkdInputStream;
    @GuardedBy(value={"mService"})
    final StringBuilder mStringBuilder = new StringBuilder(256);
    @GuardedBy(value={"mService"})
    @VisibleForTesting
    long mProcStateSeqCounter = 0L;
    @GuardedBy(value={"mService"})
    private long mProcStartSeqCounter = 0L;
    @GuardedBy(value={"mService"})
    final LongSparseArray<ProcessRecord> mPendingStarts = new LongSparseArray();
    final ArrayList<ProcessRecord> mLruProcesses = new ArrayList();
    int mLruProcessActivityStart = 0;
    int mLruProcessServiceStart = 0;
    int mLruSeq = 0;
    ActiveUids mActiveUids;
    final SparseArray<ProcessRecord> mIsolatedProcesses = new SparseArray();
    final ProcessMap<AppZygote> mAppZygotes = new ProcessMap();
    final ArrayMap<AppZygote, ArrayList<ProcessRecord>> mAppZygoteProcesses = new ArrayMap();
    @VisibleForTesting
    IsolatedUidRange mGlobalIsolatedUids = new IsolatedUidRange(99000, 99999);
    @VisibleForTesting
    IsolatedUidRangeAllocator mAppIsolatedUidRangeAllocator = new IsolatedUidRangeAllocator(90000, 98999, 100);
    final ArrayList<ProcessRecord> mRemovedProcesses = new ArrayList();
    final MyProcessMap mProcessNames = new MyProcessMap();
    public static final int PSS_SAFE_TIME_FROM_STATE_CHANGE = 1000;
    public static final int PSS_MIN_TIME_FROM_STATE_CHANGE = 15000;
    public static final int PSS_MAX_INTERVAL = 3600000;
    public static final int PSS_ALL_INTERVAL = 1200000;
    private static final int PSS_FIRST_PERSISTENT_INTERVAL = 30000;
    private static final int PSS_FIRST_TOP_INTERVAL = 10000;
    private static final int PSS_FIRST_BACKGROUND_INTERVAL = 20000;
    private static final int PSS_FIRST_CACHED_INTERVAL = 20000;
    private static final int PSS_SAME_PERSISTENT_INTERVAL = 600000;
    private static final int PSS_SAME_TOP_INTERVAL = 60000;
    private static final int PSS_SAME_IMPORTANT_INTERVAL = 600000;
    private static final int PSS_SAME_SERVICE_INTERVAL = 300000;
    private static final int PSS_SAME_CACHED_INTERVAL = 600000;
    private static final int PSS_FIRST_ASLEEP_PERSISTENT_INTERVAL = 60000;
    private static final int PSS_FIRST_ASLEEP_TOP_INTERVAL = 20000;
    private static final int PSS_FIRST_ASLEEP_BACKGROUND_INTERVAL = 30000;
    private static final int PSS_FIRST_ASLEEP_CACHED_INTERVAL = 60000;
    public static final int PSS_TEST_MIN_TIME_FROM_STATE_CHANGE = 10000;
    private static final int PSS_TEST_FIRST_TOP_INTERVAL = 3000;
    private static final int PSS_TEST_FIRST_BACKGROUND_INTERVAL = 5000;
    private static final int PSS_TEST_SAME_IMPORTANT_INTERVAL = 10000;
    private static final int PSS_TEST_SAME_BACKGROUND_INTERVAL = 15000;
    public static final int PROC_MEM_PERSISTENT = 0;
    public static final int PROC_MEM_TOP = 1;
    public static final int PROC_MEM_IMPORTANT = 2;
    public static final int PROC_MEM_SERVICE = 3;
    public static final int PROC_MEM_CACHED = 4;
    public static final int PROC_MEM_NUM = 5;
    private static final int[] sProcStateToProcMem;
    private static final long[] sFirstAwakePssTimes;
    private static final long[] sSameAwakePssTimes;
    private static final long[] sFirstAsleepPssTimes;
    private static final long[] sSameAsleepPssTimes;
    private static final long[] sTestFirstPssTimes;
    private static final long[] sTestSamePssTimes;

    ProcessList() {
        MemInfoReader minfo = new MemInfoReader();
        minfo.readMemInfo();
        this.mTotalMemMb = minfo.getTotalSize() / 0x100000L;
        this.updateOomLevels(0, 0, false);
    }

    void init(ActivityManagerService service, ActiveUids activeUids) {
        this.mService = service;
        this.mActiveUids = activeUids;
        if (sKillHandler == null) {
            sKillThread = new ServiceThread("ActivityManager:kill", 10, true);
            sKillThread.start();
            sKillHandler = new KillHandler(sKillThread.getLooper());
        }
    }

    void applyDisplaySize(WindowManagerService wm) {
        if (!this.mHaveDisplaySize) {
            Point p = new Point();
            wm.getBaseDisplaySize(0, p);
            if (p.x != 0 && p.y != 0) {
                this.updateOomLevels(p.x, p.y, true);
                this.mHaveDisplaySize = true;
            }
        }
    }

    private void updateOomLevels(int displayWidth, int displayHeight, boolean write) {
        int i;
        float scale;
        float scaleMem = (float)(this.mTotalMemMb - 350L) / 350.0f;
        int minSize = 384000;
        int maxSize = 1024000;
        float scaleDisp = ((float)(displayWidth * displayHeight) - (float)minSize) / (float)(maxSize - minSize);
        float f = scale = scaleMem > scaleDisp ? scaleMem : scaleDisp;
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 1.0f) {
            scale = 1.0f;
        }
        int minfree_adj = Resources.getSystem().getInteger(17694829);
        int minfree_abs = Resources.getSystem().getInteger(17694828);
        boolean is64bit = Build.SUPPORTED_64_BIT_ABIS.length > 0;
        for (i = 0; i < this.mOomAdj.length; ++i) {
            int low = this.mOomMinFreeLow[i];
            int high = this.mOomMinFreeHigh[i];
            if (is64bit) {
                if (i == 4) {
                    high = high * 3 / 2;
                } else if (i == 5) {
                    high = high * 7 / 4;
                }
            }
            this.mOomMinFree[i] = (int)((float)low + (float)(high - low) * scale);
        }
        if (minfree_abs >= 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                this.mOomMinFree[i] = (int)((float)minfree_abs * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
            }
        }
        if (minfree_adj != 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                int n = i;
                this.mOomMinFree[n] = this.mOomMinFree[n] + (int)((float)minfree_adj * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
                if (this.mOomMinFree[i] >= 0) continue;
                this.mOomMinFree[i] = 0;
            }
        }
        this.mCachedRestoreLevel = this.getMemLevel(999) / 1024L / 3L;
        int reserve = displayWidth * displayHeight * 4 * 3 / 1024;
        int reserve_adj = Resources.getSystem().getInteger(17694809);
        int reserve_abs = Resources.getSystem().getInteger(17694808);
        if (reserve_abs >= 0) {
            reserve = reserve_abs;
        }
        if (reserve_adj != 0 && (reserve += reserve_adj) < 0) {
            reserve = 0;
        }
        if (write) {
            ByteBuffer buf = ByteBuffer.allocate(4 * (2 * this.mOomAdj.length + 1));
            buf.putInt(0);
            for (int i2 = 0; i2 < this.mOomAdj.length; ++i2) {
                buf.putInt(this.mOomMinFree[i2] * 1024 / 4096);
                buf.putInt(this.mOomAdj[i2]);
            }
            ProcessList.writeLmkd(buf, null);
            SystemProperties.set("sys.sysctl.extra_free_kbytes", Integer.toString(reserve));
        }
    }

    public static int computeEmptyProcessLimit(int totalProcessLimit) {
        return totalProcessLimit / 2;
    }

    private static String buildOomTag(String prefix, String compactPrefix, String space, int val, int base, boolean compact) {
        int diff = val - base;
        if (diff == 0) {
            if (compact) {
                return compactPrefix;
            }
            if (space == null) {
                return prefix;
            }
            return prefix + space;
        }
        if (diff < 10) {
            return prefix + (compact ? "+" : "+ ") + Integer.toString(diff);
        }
        return prefix + "+" + Integer.toString(diff);
    }

    public static String makeOomAdjString(int setAdj, boolean compact) {
        if (setAdj >= 900) {
            return ProcessList.buildOomTag("cch", "cch", "   ", setAdj, 900, compact);
        }
        if (setAdj >= 800) {
            return ProcessList.buildOomTag("svcb  ", "svcb", null, setAdj, 800, compact);
        }
        if (setAdj >= 700) {
            return ProcessList.buildOomTag("prev  ", "prev", null, setAdj, 700, compact);
        }
        if (setAdj >= 600) {
            return ProcessList.buildOomTag("home  ", "home", null, setAdj, 600, compact);
        }
        if (setAdj >= 500) {
            return ProcessList.buildOomTag("svc   ", "svc", null, setAdj, 500, compact);
        }
        if (setAdj >= 400) {
            return ProcessList.buildOomTag("hvy   ", "hvy", null, setAdj, 400, compact);
        }
        if (setAdj >= 300) {
            return ProcessList.buildOomTag("bkup  ", "bkup", null, setAdj, 300, compact);
        }
        if (setAdj >= 250) {
            return ProcessList.buildOomTag("prcl  ", "prcl", null, setAdj, 250, compact);
        }
        if (setAdj >= 200) {
            return ProcessList.buildOomTag("prcp  ", "prcp", null, setAdj, 200, compact);
        }
        if (setAdj >= 100) {
            return ProcessList.buildOomTag("vis", "vis", "   ", setAdj, 100, compact);
        }
        if (setAdj >= 0) {
            return ProcessList.buildOomTag("fore  ", "fore", null, setAdj, 0, compact);
        }
        if (setAdj >= -700) {
            return ProcessList.buildOomTag("psvc  ", "psvc", null, setAdj, -700, compact);
        }
        if (setAdj >= -800) {
            return ProcessList.buildOomTag("pers  ", "pers", null, setAdj, -800, compact);
        }
        if (setAdj >= -900) {
            return ProcessList.buildOomTag("sys   ", "sys", null, setAdj, -900, compact);
        }
        if (setAdj >= -1000) {
            return ProcessList.buildOomTag("ntv  ", "ntv", null, setAdj, -1000, compact);
        }
        return Integer.toString(setAdj);
    }

    public static String makeProcStateString(int curProcState) {
        String procState;
        switch (curProcState) {
            case 0: {
                procState = "PER ";
                break;
            }
            case 1: {
                procState = "PERU";
                break;
            }
            case 2: {
                procState = "TOP ";
                break;
            }
            case 3: {
                procState = "FGSL";
                break;
            }
            case 4: {
                procState = "BTOP";
                break;
            }
            case 5: {
                procState = "FGS ";
                break;
            }
            case 6: {
                procState = "BFGS";
                break;
            }
            case 7: {
                procState = "IMPF";
                break;
            }
            case 8: {
                procState = "IMPB";
                break;
            }
            case 9: {
                procState = "TRNB";
                break;
            }
            case 10: {
                procState = "BKUP";
                break;
            }
            case 11: {
                procState = "SVC ";
                break;
            }
            case 12: {
                procState = "RCVR";
                break;
            }
            case 13: {
                procState = "TPSL";
                break;
            }
            case 14: {
                procState = "HVY ";
                break;
            }
            case 15: {
                procState = "HOME";
                break;
            }
            case 16: {
                procState = "LAST";
                break;
            }
            case 17: {
                procState = "CAC ";
                break;
            }
            case 18: {
                procState = "CACC";
                break;
            }
            case 19: {
                procState = "CRE ";
                break;
            }
            case 20: {
                procState = "CEM ";
                break;
            }
            case 21: {
                procState = "NONE";
                break;
            }
            default: {
                procState = "??";
            }
        }
        return procState;
    }

    public static int makeProcStateProtoEnum(int curProcState) {
        switch (curProcState) {
            case 0: {
                return 1000;
            }
            case 1: {
                return 1001;
            }
            case 2: {
                return 1002;
            }
            case 3: {
                return 1003;
            }
            case 4: {
                return 1020;
            }
            case 5: {
                return 1003;
            }
            case 6: {
                return 1004;
            }
            case 13: {
                return 1011;
            }
            case 7: {
                return 1005;
            }
            case 8: {
                return 1006;
            }
            case 9: {
                return 1007;
            }
            case 10: {
                return 1008;
            }
            case 14: {
                return 1012;
            }
            case 11: {
                return 1009;
            }
            case 12: {
                return 1010;
            }
            case 15: {
                return 1013;
            }
            case 16: {
                return 1014;
            }
            case 17: {
                return 1015;
            }
            case 18: {
                return 1016;
            }
            case 19: {
                return 1017;
            }
            case 20: {
                return 1018;
            }
            case 21: {
                return 1019;
            }
            case -1: {
                return 999;
            }
        }
        return 998;
    }

    public static void appendRamKb(StringBuilder sb, long ramKb) {
        int j = 0;
        int fact = 10;
        while (j < 6) {
            if (ramKb < (long)fact) {
                sb.append(' ');
            }
            ++j;
            fact *= 10;
        }
        sb.append(ramKb);
    }

    public static boolean procStatesDifferForMem(int procState1, int procState2) {
        return sProcStateToProcMem[procState1] != sProcStateToProcMem[procState2];
    }

    public static long minTimeFromStateChange(boolean test) {
        return test ? 10000L : 15000L;
    }

    public static void commitNextPssTime(ProcStateMemTracker tracker) {
        if (tracker.mPendingMemState >= 0) {
            tracker.mHighestMem[tracker.mPendingMemState] = tracker.mPendingHighestMemState;
            tracker.mScalingFactor[tracker.mPendingMemState] = tracker.mPendingScalingFactor;
            tracker.mTotalHighestMem = tracker.mPendingHighestMemState;
            tracker.mPendingMemState = -1;
        }
    }

    public static void abortNextPssTime(ProcStateMemTracker tracker) {
        tracker.mPendingMemState = -1;
    }

    public static long computeNextPssTime(int procState, ProcStateMemTracker tracker, boolean test, boolean sleeping, long now) {
        float scalingFactor;
        boolean first;
        int memState = sProcStateToProcMem[procState];
        if (tracker != null) {
            int highestMemState = memState < tracker.mTotalHighestMem ? memState : tracker.mTotalHighestMem;
            first = highestMemState < tracker.mHighestMem[memState];
            tracker.mPendingMemState = memState;
            tracker.mPendingHighestMemState = highestMemState;
            if (first) {
                scalingFactor = 1.0f;
                tracker.mPendingScalingFactor = 1.0f;
            } else {
                scalingFactor = tracker.mScalingFactor[memState];
                tracker.mPendingScalingFactor = scalingFactor * 1.5f;
            }
        } else {
            first = true;
            scalingFactor = 1.0f;
        }
        long[] table = test ? (first ? sTestFirstPssTimes : sTestSamePssTimes) : (first ? (sleeping ? sFirstAsleepPssTimes : sFirstAwakePssTimes) : (sleeping ? sSameAsleepPssTimes : sSameAwakePssTimes));
        long delay = (long)((float)table[memState] * scalingFactor);
        if (delay > 3600000L) {
            delay = 3600000L;
        }
        return now + delay;
    }

    long getMemLevel(int adjustment) {
        for (int i = 0; i < this.mOomAdj.length; ++i) {
            if (adjustment > this.mOomAdj[i]) continue;
            return this.mOomMinFree[i] * 1024;
        }
        return this.mOomMinFree[this.mOomAdj.length - 1] * 1024;
    }

    long getCachedRestoreThresholdKb() {
        return this.mCachedRestoreLevel;
    }

    public static void setOomAdj(int pid, int uid, int amt) {
        if (pid <= 0) {
            return;
        }
        if (amt == 1001) {
            return;
        }
        long start = SystemClock.elapsedRealtime();
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putInt(1);
        buf.putInt(pid);
        buf.putInt(uid);
        buf.putInt(amt);
        ProcessList.writeLmkd(buf, null);
        long now = SystemClock.elapsedRealtime();
        if (now - start > 250L) {
            Slog.w(TAG, "SLOW OOM ADJ: " + (now - start) + "ms for pid " + pid + " = " + amt);
        }
    }

    public static final void remove(int pid) {
        if (pid <= 0) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(2);
        buf.putInt(pid);
        ProcessList.writeLmkd(buf, null);
    }

    public static final Integer getLmkdKillCount(int min_oom_adj, int max_oom_adj) {
        ByteBuffer buf = ByteBuffer.allocate(12);
        ByteBuffer repl = ByteBuffer.allocate(8);
        buf.putInt(4);
        buf.putInt(min_oom_adj);
        buf.putInt(max_oom_adj);
        if (ProcessList.writeLmkd(buf, repl)) {
            int i = repl.getInt();
            if (i != 4) {
                Slog.e(TAG, "Failed to get kill count, code mismatch");
                return null;
            }
            return new Integer(repl.getInt());
        }
        return null;
    }

    @GuardedBy(value={"sLmkdSocketLock"})
    private static boolean openLmkdSocketLS() {
        try {
            sLmkdSocket = new LocalSocket(3);
            sLmkdSocket.connect(new LocalSocketAddress("lmkd", LocalSocketAddress.Namespace.RESERVED));
            sLmkdOutputStream = sLmkdSocket.getOutputStream();
            sLmkdInputStream = sLmkdSocket.getInputStream();
        }
        catch (IOException ex) {
            Slog.w(TAG, "lowmemorykiller daemon socket open failed");
            sLmkdSocket = null;
            return false;
        }
        return true;
    }

    @GuardedBy(value={"sLmkdSocketLock"})
    private static boolean writeLmkdCommandLS(ByteBuffer buf) {
        try {
            sLmkdOutputStream.write(buf.array(), 0, buf.position());
        }
        catch (IOException ex) {
            Slog.w(TAG, "Error writing to lowmemorykiller socket");
            IoUtils.closeQuietly(sLmkdSocket);
            sLmkdSocket = null;
            return false;
        }
        return true;
    }

    @GuardedBy(value={"sLmkdSocketLock"})
    private static boolean readLmkdReplyLS(ByteBuffer buf) {
        try {
            int len = sLmkdInputStream.read(buf.array(), 0, buf.array().length);
            if (len == buf.array().length) {
                return true;
            }
        }
        catch (IOException ex) {
            Slog.w(TAG, "Error reading from lowmemorykiller socket");
        }
        IoUtils.closeQuietly(sLmkdSocket);
        sLmkdSocket = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeLmkd(ByteBuffer buf, ByteBuffer repl) {
        Object object = sLmkdSocketLock;
        synchronized (object) {
            for (int i = 0; i < 3; ++i) {
                if (sLmkdSocket == null) {
                    if (!ProcessList.openLmkdSocketLS()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    ByteBuffer purge_buf = ByteBuffer.allocate(4);
                    purge_buf.putInt(3);
                    if (!ProcessList.writeLmkdCommandLS(purge_buf)) continue;
                }
                if (!ProcessList.writeLmkdCommandLS(buf) || repl != null && !ProcessList.readLmkdReplyLS(repl)) continue;
                return true;
            }
        }
        return false;
    }

    static void killProcessGroup(int uid, int pid) {
        if (sKillHandler != null) {
            sKillHandler.sendMessage(sKillHandler.obtainMessage(4000, uid, pid));
        } else {
            Slog.w(TAG, "Asked to kill process group before system bringup!");
            Process.killProcessGroup(uid, pid);
        }
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid, boolean keepIfLarge) {
        ProcessRecord proc;
        if (uid == 1000) {
            SparseArray procs = this.mProcessNames.getMap().get(processName);
            if (procs == null) {
                return null;
            }
            int procCount = procs.size();
            for (int i = 0; i < procCount; ++i) {
                int procUid = procs.keyAt(i);
                if (UserHandle.isApp(procUid) || !UserHandle.isSameUser(procUid, uid)) continue;
                return (ProcessRecord)procs.valueAt(i);
            }
        }
        if ((proc = (ProcessRecord)this.mProcessNames.get(processName, uid)) != null && !keepIfLarge && this.mService.mLastMemoryLevel > 0 && proc.setProcState >= 20 && proc.lastCachedPss >= this.getCachedRestoreThresholdKb()) {
            if (proc.baseProcessTracker != null) {
                proc.baseProcessTracker.reportCachedKill(proc.pkgList.mPkgList, proc.lastCachedPss);
                for (int ipkg = proc.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                    ProcessStats.ProcessStateHolder holder = proc.pkgList.valueAt(ipkg);
                    StatsLog.write(17, proc.info.uid, holder.state.getName(), holder.state.getPackage(), proc.lastCachedPss, holder.appVersion);
                }
            }
            proc.kill(Long.toString(proc.lastCachedPss) + "k from cached", true);
        }
        return proc;
    }

    void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        long homeAppMem = this.getMemLevel(600);
        long cachedAppMem = this.getMemLevel(900);
        outInfo.availMem = Process.getFreeMemory();
        outInfo.totalMem = Process.getTotalMemory();
        outInfo.threshold = homeAppMem;
        outInfo.lowMemory = outInfo.availMem < homeAppMem + (cachedAppMem - homeAppMem) / 2L;
        outInfo.hiddenAppThreshold = cachedAppMem;
        outInfo.secondaryServerThreshold = this.getMemLevel(500);
        outInfo.visibleAppThreshold = this.getMemLevel(100);
        outInfo.foregroundAppThreshold = this.getMemLevel(0);
    }

    ProcessRecord findAppProcessLocked(IBinder app, String reason) {
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord p = (ProcessRecord)apps.valueAt(ia);
                if (p.thread == null || p.thread.asBinder() != app) continue;
                return p;
            }
        }
        Slog.w(TAG, "Can't find mystery application for " + reason + " from pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid() + ": " + app);
        return null;
    }

    private void checkSlow(long startTime, String where) {
        long now = SystemClock.uptimeMillis();
        if (now - startTime > 50L) {
            Slog.w(TAG, "Slow operation: " + (now - startTime) + "ms so far, now at " + where);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mService"})
    boolean startProcessLocked(ProcessRecord app, HostingRecord hostingRecord, boolean disableHiddenApiChecks, boolean mountExtStorageFull, String abiOverride) {
        if (app.pendingStart) {
            return true;
        }
        long startTime = SystemClock.elapsedRealtime();
        if (app.pid > 0 && app.pid != ActivityManagerService.MY_PID) {
            this.checkSlow(startTime, "startProcess: removing from pids map");
            this.mService.mPidsSelfLocked.remove(app);
            this.mService.mHandler.removeMessages(20, app);
            this.checkSlow(startTime, "startProcess: done removing from pids map");
            app.setPid(0);
            app.startSeq = 0L;
        }
        this.mService.mProcessesOnHold.remove(app);
        this.checkSlow(startTime, "startProcess: starting to update cpu stats");
        this.mService.updateCpuStats();
        this.checkSlow(startTime, "startProcess: done updating cpu stats");
        try {
            String requiredAbi;
            String useAppImageCache;
            String genMiniDebugInfoProperty;
            String genDebugInfoProperty;
            try {
                int userId = UserHandle.getUserId(app.uid);
                AppGlobals.getPackageManager().checkPackageStartable(app.info.packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            int uid = app.uid;
            int[] gids = null;
            int mountExternal = 0;
            if (!app.isolated) {
                int[] permGids = null;
                try {
                    this.checkSlow(startTime, "startProcess: getting gids from package manager");
                    IPackageManager pm = AppGlobals.getPackageManager();
                    permGids = pm.getPackageGids(app.info.packageName, 0x10000000, app.userId);
                    if (StorageManager.hasIsolatedStorage() && mountExtStorageFull) {
                        mountExternal = 6;
                    } else {
                        StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
                        mountExternal = storageManagerInternal.getExternalStorageMountMode(uid, app.info.packageName);
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                if (ArrayUtils.isEmpty(permGids)) {
                    gids = new int[3];
                } else {
                    gids = new int[permGids.length + 3];
                    System.arraycopy(permGids, 0, gids, 3, permGids.length);
                }
                gids[0] = UserHandle.getSharedAppGid(UserHandle.getAppId(uid));
                gids[1] = UserHandle.getCacheAppGid(UserHandle.getAppId(uid));
                gids[2] = UserHandle.getUserGid(UserHandle.getUserId(uid));
                if (gids[0] == -1) {
                    gids[0] = gids[2];
                }
                if (gids[1] == -1) {
                    gids[1] = gids[2];
                }
            }
            app.mountMode = mountExternal;
            this.checkSlow(startTime, "startProcess: building args");
            if (this.mService.mAtmInternal.isFactoryTestProcess(app.getWindowProcessController())) {
                uid = 0;
            }
            int runtimeFlags = 0;
            if ((app.info.flags & 2) != 0) {
                runtimeFlags |= 1;
                runtimeFlags |= 0x100;
                runtimeFlags |= 2;
                if (Settings.Global.getInt(this.mService.mContext.getContentResolver(), "art_verifier_verify_debuggable", 1) == 0) {
                    runtimeFlags |= 0x200;
                    Slog.w(TAG, app + ": ART verification disabled");
                }
            }
            if ((app.info.flags & 0x4000) != 0 || this.mService.mSafeMode) {
                runtimeFlags |= 8;
            }
            if ((app.info.privateFlags & 0x800000) != 0) {
                runtimeFlags |= 0x8000;
            }
            if ("1".equals(SystemProperties.get("debug.checkjni"))) {
                runtimeFlags |= 2;
            }
            if ("1".equals(genDebugInfoProperty = SystemProperties.get("debug.generate-debug-info")) || "true".equals(genDebugInfoProperty)) {
                runtimeFlags |= 0x20;
            }
            if ("1".equals(genMiniDebugInfoProperty = SystemProperties.get("dalvik.vm.minidebuginfo")) || "true".equals(genMiniDebugInfoProperty)) {
                runtimeFlags |= 0x800;
            }
            if ("1".equals(SystemProperties.get("debug.jni.logging"))) {
                runtimeFlags |= 0x10;
            }
            if ("1".equals(SystemProperties.get("debug.assert"))) {
                runtimeFlags |= 4;
            }
            if (this.mService.mNativeDebuggingApp != null && this.mService.mNativeDebuggingApp.equals(app.processName)) {
                runtimeFlags |= 0x40;
                runtimeFlags |= 0x20;
                runtimeFlags |= 0x80;
                this.mService.mNativeDebuggingApp = null;
            }
            if (app.info.isEmbeddedDexUsed() || app.info.isPrivilegedApp() && DexManager.isPackageSelectedToRunOob(app.pkgList.mPkgList.keySet())) {
                runtimeFlags |= 0x400;
            }
            if (!disableHiddenApiChecks && !this.mService.mHiddenApiBlacklist.isDisabled()) {
                app.info.maybeUpdateHiddenApiEnforcementPolicy(this.mService.mHiddenApiBlacklist.getPolicy());
                int policy = app.info.getHiddenApiEnforcementPolicy();
                int policyBits = policy << Zygote.API_ENFORCEMENT_POLICY_SHIFT;
                if ((policyBits & 0x3000) != policyBits) {
                    throw new IllegalStateException("Invalid API policy: " + policy);
                }
                runtimeFlags |= policyBits;
            }
            if (!TextUtils.isEmpty(useAppImageCache = SystemProperties.get(PROPERTY_USE_APP_IMAGE_STARTUP_CACHE, "")) && !useAppImageCache.equals("false")) {
                runtimeFlags |= 0x10000;
            }
            String invokeWith = null;
            if ((app.info.flags & 2) != 0) {
                String wrapperFileName = app.info.nativeLibraryDir + "/wrap.sh";
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                try {
                    if (new File(wrapperFileName).exists()) {
                        invokeWith = "/system/bin/logwrapper " + wrapperFileName;
                    }
                }
                finally {
                    StrictMode.setThreadPolicy(oldPolicy);
                }
            }
            String string2 = requiredAbi = abiOverride != null ? abiOverride : app.info.primaryCpuAbi;
            if (requiredAbi == null) {
                requiredAbi = Build.SUPPORTED_ABIS[0];
            }
            String instructionSet = null;
            if (app.info.primaryCpuAbi != null) {
                instructionSet = VMRuntime.getInstructionSet(app.info.primaryCpuAbi);
            }
            app.gids = gids;
            app.setRequiredAbi(requiredAbi);
            app.instructionSet = instructionSet;
            if (TextUtils.isEmpty(app.info.seInfoUser)) {
                Slog.wtf(TAG, "SELinux tag not defined", new IllegalStateException("SELinux tag not defined for " + app.info.packageName + " (uid " + app.uid + ")"));
            }
            String seInfo = app.info.seInfo + (TextUtils.isEmpty(app.info.seInfoUser) ? "" : app.info.seInfoUser);
            String entryPoint = "android.app.ActivityThread";
            return this.startProcessLocked(hostingRecord, "android.app.ActivityThread", app, uid, gids, runtimeFlags, mountExternal, seInfo, requiredAbi, instructionSet, invokeWith, startTime);
        }
        catch (RuntimeException e) {
            Slog.e(TAG, "Failure starting process " + app.processName, e);
            this.mService.forceStopPackageLocked(app.info.packageName, UserHandle.getAppId(app.uid), false, false, true, false, false, app.userId, "start failure");
            return false;
        }
    }

    @GuardedBy(value={"mService"})
    boolean startProcessLocked(HostingRecord hostingRecord, String entryPoint, ProcessRecord app, int uid, int[] gids, int runtimeFlags, int mountExternal, String seInfo, String requiredAbi, String instructionSet, String invokeWith, long startTime) {
        app.pendingStart = true;
        app.killedByAm = false;
        app.removed = false;
        app.killed = false;
        if (app.startSeq != 0L) {
            Slog.wtf(TAG, "startProcessLocked processName:" + app.processName + " with non-zero startSeq:" + app.startSeq);
        }
        if (app.pid != 0) {
            Slog.wtf(TAG, "startProcessLocked processName:" + app.processName + " with non-zero pid:" + app.pid);
        }
        app.startSeq = ++this.mProcStartSeqCounter;
        long startSeq = this.mProcStartSeqCounter;
        app.setStartParams(uid, hostingRecord, seInfo, startTime);
        app.setUsingWrapper(invokeWith != null || SystemProperties.get("wrap." + app.processName) != null);
        this.mPendingStarts.put(startSeq, app);
        if (this.mService.mConstants.FLAG_PROCESS_START_ASYNC) {
            this.mService.mProcStartHandler.post(() -> {
                try {
                    Process.ProcessStartResult startResult = this.startProcess(app.hostingRecord, entryPoint, app, app.startUid, gids, runtimeFlags, mountExternal, app.seInfo, requiredAbi, instructionSet, invokeWith, app.startTime);
                    ActivityManagerService activityManagerService = this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.handleProcessStartedLocked(app, startResult, startSeq);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                catch (RuntimeException e) {
                    ActivityManagerService activityManagerService = this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            Slog.e(TAG, "Failure starting process " + app.processName, e);
                            this.mPendingStarts.remove(startSeq);
                            app.pendingStart = false;
                            this.mService.forceStopPackageLocked(app.info.packageName, UserHandle.getAppId(app.uid), false, false, true, false, false, app.userId, "start failure");
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[3, 6, 7] lbl31 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
            });
            return true;
        }
        try {
            Process.ProcessStartResult startResult = this.startProcess(hostingRecord, entryPoint, app, uid, gids, runtimeFlags, mountExternal, seInfo, requiredAbi, instructionSet, invokeWith, startTime);
            this.handleProcessStartedLocked(app, startResult.pid, startResult.usingWrapper, startSeq, false);
        }
        catch (RuntimeException e) {
            Slog.e(TAG, "Failure starting process " + app.processName, e);
            app.pendingStart = false;
            this.mService.forceStopPackageLocked(app.info.packageName, UserHandle.getAppId(app.uid), false, false, true, false, false, app.userId, "start failure");
        }
        return app.pid > 0;
    }

    @GuardedBy(value={"mService"})
    public void killAppZygoteIfNeededLocked(AppZygote appZygote) {
        ApplicationInfo appInfo = appZygote.getAppInfo();
        ArrayList<ProcessRecord> zygoteProcesses = this.mAppZygoteProcesses.get(appZygote);
        if (zygoteProcesses != null && zygoteProcesses.size() == 0) {
            this.mAppZygotes.remove(appInfo.processName, appInfo.uid);
            this.mAppZygoteProcesses.remove(appZygote);
            this.mAppIsolatedUidRangeAllocator.freeUidRangeLocked(appInfo);
            appZygote.stopZygote();
        }
    }

    @GuardedBy(value={"mService"})
    private void removeProcessFromAppZygoteLocked(ProcessRecord app) {
        AppZygote appZygote;
        IsolatedUidRange appUidRange = this.mAppIsolatedUidRangeAllocator.getIsolatedUidRangeLocked(app.info.processName, app.hostingRecord.getDefiningUid());
        if (appUidRange != null) {
            appUidRange.freeIsolatedUidLocked(app.uid);
        }
        if ((appZygote = this.mAppZygotes.get(app.info.processName, app.hostingRecord.getDefiningUid())) != null) {
            ArrayList<ProcessRecord> zygoteProcesses = this.mAppZygoteProcesses.get(appZygote);
            zygoteProcesses.remove(app);
            if (zygoteProcesses.size() == 0) {
                this.mService.mHandler.removeMessages(71);
                if (app.removed) {
                    this.killAppZygoteIfNeededLocked(appZygote);
                } else {
                    Message msg = this.mService.mHandler.obtainMessage(71);
                    msg.obj = appZygote;
                    this.mService.mHandler.sendMessageDelayed(msg, 5000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppZygote createAppZygoteForProcessIfNeeded(ProcessRecord app) {
        AppZygote appZygote;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ArrayList<ProcessRecord> zygoteProcessList;
                ActivityManagerService.boostPriorityForLockedSection();
                int uid = app.hostingRecord.getDefiningUid();
                AppZygote appZygote2 = this.mAppZygotes.get(app.info.processName, uid);
                if (appZygote2 == null) {
                    IsolatedUidRange uidRange = this.mAppIsolatedUidRangeAllocator.getIsolatedUidRangeLocked(app.info.processName, app.hostingRecord.getDefiningUid());
                    int userId = UserHandle.getUserId(uid);
                    int firstUid = UserHandle.getUid(userId, uidRange.mFirstUid);
                    int lastUid = UserHandle.getUid(userId, uidRange.mLastUid);
                    ApplicationInfo appInfo = new ApplicationInfo(app.info);
                    appInfo.packageName = app.hostingRecord.getDefiningPackageName();
                    appInfo.uid = uid;
                    appZygote2 = new AppZygote(appInfo, uid, firstUid, lastUid);
                    this.mAppZygotes.put(app.info.processName, uid, appZygote2);
                    zygoteProcessList = new ArrayList();
                    this.mAppZygoteProcesses.put(appZygote2, zygoteProcessList);
                } else {
                    this.mService.mHandler.removeMessages(71, appZygote2);
                    zygoteProcessList = this.mAppZygoteProcesses.get(appZygote2);
                }
                zygoteProcessList.add(app);
                appZygote = appZygote2;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl30 : MonitorExitStatement: MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return appZygote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process.ProcessStartResult startProcess(HostingRecord hostingRecord, String entryPoint, ProcessRecord app, int uid, int[] gids, int runtimeFlags, int mountExternal, String seInfo, String requiredAbi, String instructionSet, String invokeWith, long startTime) {
        try {
            Process.ProcessStartResult startResult;
            Trace.traceBegin(64L, "Start proc: " + app.processName);
            this.checkSlow(startTime, "startProcess: asking zygote to start proc");
            if (hostingRecord.usesWebviewZygote()) {
                startResult = Process.startWebView(entryPoint, app.processName, uid, uid, gids, runtimeFlags, mountExternal, app.info.targetSdkVersion, seInfo, requiredAbi, instructionSet, app.info.dataDir, null, app.info.packageName, new String[]{"seq=" + app.startSeq});
            } else if (hostingRecord.usesAppZygote()) {
                AppZygote appZygote = this.createAppZygoteForProcessIfNeeded(app);
                startResult = appZygote.getProcess().start(entryPoint, app.processName, uid, uid, gids, runtimeFlags, mountExternal, app.info.targetSdkVersion, seInfo, requiredAbi, instructionSet, app.info.dataDir, null, app.info.packageName, false, new String[]{"seq=" + app.startSeq});
            } else {
                startResult = Process.start(entryPoint, app.processName, uid, uid, gids, runtimeFlags, mountExternal, app.info.targetSdkVersion, seInfo, requiredAbi, instructionSet, app.info.dataDir, invokeWith, app.info.packageName, new String[]{"seq=" + app.startSeq});
            }
            this.checkSlow(startTime, "startProcess: returned from zygote!");
            Process.ProcessStartResult processStartResult = startResult;
            return processStartResult;
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    @GuardedBy(value={"mService"})
    final void startProcessLocked(ProcessRecord app, HostingRecord hostingRecord) {
        this.startProcessLocked(app, hostingRecord, null);
    }

    @GuardedBy(value={"mService"})
    final boolean startProcessLocked(ProcessRecord app, HostingRecord hostingRecord, String abiOverride) {
        return this.startProcessLocked(app, hostingRecord, false, false, abiOverride);
    }

    @GuardedBy(value={"mService"})
    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, HostingRecord hostingRecord, boolean allowWhileBooting, boolean isolated, int isolatedUid, boolean keepIfLarge, String abiOverride, String entryPoint, String[] entryPointArgs, Runnable crashHandler) {
        ProcessRecord app;
        long startTime = SystemClock.elapsedRealtime();
        if (!isolated) {
            app = this.getProcessRecordLocked(processName, info.uid, keepIfLarge);
            this.checkSlow(startTime, "startProcess: after getProcessRecord");
            if ((intentFlags & 4) != 0) {
                if (this.mService.mAppErrors.isBadProcessLocked(info)) {
                    return null;
                }
            } else {
                this.mService.mAppErrors.resetProcessCrashTimeLocked(info);
                if (this.mService.mAppErrors.isBadProcessLocked(info)) {
                    EventLog.writeEvent(30016, UserHandle.getUserId(info.uid), info.uid, info.processName);
                    this.mService.mAppErrors.clearBadProcessLocked(info);
                    if (app != null) {
                        app.bad = false;
                    }
                }
            }
        } else {
            app = null;
        }
        if (app != null && app.pid > 0) {
            if (!knownToBeDead && !app.killed || app.thread == null) {
                app.addPackage(info.packageName, info.longVersionCode, this.mService.mProcessStats);
                this.checkSlow(startTime, "startProcess: done, added package to proc");
                return app;
            }
            this.checkSlow(startTime, "startProcess: bad proc running, killing");
            ProcessList.killProcessGroup(app.uid, app.pid);
            this.mService.handleAppDiedLocked(app, true, true);
            this.checkSlow(startTime, "startProcess: done killing old proc");
        }
        if (app == null) {
            this.checkSlow(startTime, "startProcess: creating new process record");
            app = this.newProcessRecordLocked(info, processName, isolated, isolatedUid, hostingRecord);
            if (app == null) {
                Slog.w(TAG, "Failed making new process record for " + processName + "/" + info.uid + " isolated=" + isolated);
                return null;
            }
            app.crashHandler = crashHandler;
            app.isolatedEntryPoint = entryPoint;
            app.isolatedEntryPointArgs = entryPointArgs;
            this.checkSlow(startTime, "startProcess: done creating new process record");
        } else {
            app.addPackage(info.packageName, info.longVersionCode, this.mService.mProcessStats);
            this.checkSlow(startTime, "startProcess: added package to existing proc");
        }
        if (!(this.mService.mProcessesReady || this.mService.isAllowedWhileBooting(info) || allowWhileBooting)) {
            if (!this.mService.mProcessesOnHold.contains(app)) {
                this.mService.mProcessesOnHold.add(app);
            }
            this.checkSlow(startTime, "startProcess: returning with proc on hold");
            return app;
        }
        this.checkSlow(startTime, "startProcess: stepping in to startProcess");
        boolean success = this.startProcessLocked(app, hostingRecord, abiOverride);
        this.checkSlow(startTime, "startProcess: done starting proc!");
        return success ? app : null;
    }

    @GuardedBy(value={"mService"})
    private String isProcStartValidLocked(ProcessRecord app, long expectedStartSeq) {
        StringBuilder sb = null;
        if (app.killedByAm) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("killedByAm=true;");
        }
        if (this.mProcessNames.get(app.processName, app.uid) != app) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("No entry in mProcessNames;");
        }
        if (!app.pendingStart) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("pendingStart=false;");
        }
        if (app.startSeq > expectedStartSeq) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("seq=" + app.startSeq + ",expected=" + expectedStartSeq + ";");
        }
        return sb == null ? null : sb.toString();
    }

    @GuardedBy(value={"mService"})
    private boolean handleProcessStartedLocked(ProcessRecord pending, Process.ProcessStartResult startResult, long expectedStartSeq) {
        if (this.mPendingStarts.get(expectedStartSeq) == null) {
            if (pending.pid == startResult.pid) {
                pending.setUsingWrapper(startResult.usingWrapper);
            }
            return false;
        }
        return this.handleProcessStartedLocked(pending, startResult.pid, startResult.usingWrapper, expectedStartSeq, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mService"})
    boolean handleProcessStartedLocked(ProcessRecord app, int pid, boolean usingWrapper, long expectedStartSeq, boolean procAttached) {
        ProcessRecord oldApp;
        this.mPendingStarts.remove(expectedStartSeq);
        String reason = this.isProcStartValidLocked(app, expectedStartSeq);
        if (reason != null) {
            Slog.w(TAG, app + " start not valid, killing pid=" + pid + ", " + reason);
            app.pendingStart = false;
            Process.killProcessQuiet(pid);
            Process.killProcessGroup(app.uid, app.pid);
            return false;
        }
        this.mService.mBatteryStatsService.noteProcessStart(app.processName, app.info.uid);
        this.checkSlow(app.startTime, "startProcess: done updating battery stats");
        EventLog.writeEvent(30014, UserHandle.getUserId(app.startUid), pid, app.startUid, app.processName, app.hostingRecord.getType(), app.hostingRecord.getName() != null ? app.hostingRecord.getName() : "");
        try {
            AppGlobals.getPackageManager().logAppProcessStartIfNeeded(app.processName, app.uid, app.seInfo, app.info.sourceDir, pid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (app.isPersistent()) {
            Watchdog.getInstance().processStarted(app.processName, pid);
        }
        this.checkSlow(app.startTime, "startProcess: building log message");
        StringBuilder buf = this.mStringBuilder;
        buf.setLength(0);
        buf.append("Start proc ");
        buf.append(pid);
        buf.append(':');
        buf.append(app.processName);
        buf.append('/');
        UserHandle.formatUid(buf, app.startUid);
        if (app.isolatedEntryPoint != null) {
            buf.append(" [");
            buf.append(app.isolatedEntryPoint);
            buf.append("]");
        }
        buf.append(" for ");
        buf.append(app.hostingRecord.getType());
        if (app.hostingRecord.getName() != null) {
            buf.append(" ");
            buf.append(app.hostingRecord.getName());
        }
        this.mService.reportUidInfoMessageLocked(TAG, buf.toString(), app.startUid);
        app.setPid(pid);
        app.setUsingWrapper(usingWrapper);
        app.pendingStart = false;
        this.checkSlow(app.startTime, "startProcess: starting to update pids map");
        ActivityManagerService.PidMap pidMap = this.mService.mPidsSelfLocked;
        synchronized (pidMap) {
            oldApp = this.mService.mPidsSelfLocked.get(pid);
        }
        if (oldApp != null && !app.isolated) {
            Slog.wtf(TAG, "handleProcessStartedLocked process:" + app.processName + " startSeq:" + app.startSeq + " pid:" + pid + " belongs to another existing app:" + oldApp.processName + " startSeq:" + oldApp.startSeq);
            this.mService.cleanUpApplicationRecordLocked(oldApp, false, false, -1, true);
        }
        this.mService.mPidsSelfLocked.put(app);
        pidMap = this.mService.mPidsSelfLocked;
        synchronized (pidMap) {
            if (!procAttached) {
                Message msg = this.mService.mHandler.obtainMessage(20);
                msg.obj = app;
                this.mService.mHandler.sendMessageDelayed(msg, usingWrapper ? 1200000L : 10000L);
            }
        }
        this.checkSlow(app.startTime, "startProcess: done updating pids map");
        return true;
    }

    final void removeLruProcessLocked(ProcessRecord app) {
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui >= 0) {
            if (!app.killed) {
                if (app.isPersistent()) {
                    Slog.w(TAG, "Removing persistent process that hasn't been killed: " + app);
                } else {
                    Slog.wtfStack(TAG, "Removing process that hasn't been killed: " + app);
                    if (app.pid > 0) {
                        Process.killProcessQuiet(app.pid);
                        ProcessList.killProcessGroup(app.uid, app.pid);
                    } else {
                        app.pendingStart = false;
                    }
                }
            }
            if (lrui <= this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui <= this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
    }

    @GuardedBy(value={"mService"})
    boolean killPackageProcessesLocked(String packageName, int appId, int userId, int minOomAdj, String reason) {
        return this.killPackageProcessesLocked(packageName, appId, userId, minOomAdj, false, true, true, false, false, reason);
    }

    @GuardedBy(value={"mService"})
    final boolean killPackageProcessesLocked(String packageName, int appId, int userId, int minOomAdj, boolean callerWillRestart, boolean allowRestart, boolean doit, boolean evenPersistent, boolean setRemoved, String reason) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                if (app.isPersistent() && !evenPersistent) continue;
                if (app.removed) {
                    if (!doit) continue;
                    procs.add(app);
                    continue;
                }
                if (app.setAdj < minOomAdj) continue;
                if (packageName == null) {
                    if (userId != -1 && app.userId != userId || appId >= 0 && UserHandle.getAppId(app.uid) != appId) {
                        continue;
                    }
                } else {
                    boolean isDep;
                    boolean bl = isDep = app.pkgDeps != null && app.pkgDeps.contains(packageName);
                    if (!isDep && UserHandle.getAppId(app.uid) != appId || userId != -1 && app.userId != userId || !app.pkgList.containsKey(packageName) && !isDep) continue;
                }
                if (!doit) {
                    return true;
                }
                if (setRemoved) {
                    app.removed = true;
                }
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), callerWillRestart, allowRestart, reason);
        }
        ArrayList<AppZygote> zygotesToKill = new ArrayList<AppZygote>();
        for (SparseArray<AppZygote> appZygotes : this.mAppZygotes.getMap().values()) {
            for (int i = 0; i < appZygotes.size(); ++i) {
                int appZygoteUid = appZygotes.keyAt(i);
                if (userId != -1 && UserHandle.getUserId(appZygoteUid) != userId || appId >= 0 && UserHandle.getAppId(appZygoteUid) != appId) continue;
                AppZygote appZygote = appZygotes.valueAt(i);
                if (packageName != null && !packageName.equals(appZygote.getAppInfo().packageName)) continue;
                zygotesToKill.add(appZygote);
            }
        }
        for (AppZygote appZygote : zygotesToKill) {
            this.killAppZygoteIfNeededLocked(appZygote);
        }
        this.mService.updateOomAdjLocked("updateOomAdj_processEnd");
        return N > 0;
    }

    @GuardedBy(value={"mService"})
    boolean removeProcessLocked(ProcessRecord app, boolean callerWillRestart, boolean allowRestart, String reason) {
        String name = app.processName;
        int uid = app.uid;
        ProcessRecord old = (ProcessRecord)this.mProcessNames.get(name, uid);
        if (old != app) {
            Slog.w(TAG, "Ignoring remove of inactive process: " + app);
            return false;
        }
        this.removeProcessNameLocked(name, uid);
        this.mService.mAtmInternal.clearHeavyWeightProcessIfEquals(app.getWindowProcessController());
        boolean needRestart = false;
        if (app.pid > 0 && app.pid != ActivityManagerService.MY_PID || app.pid == 0 && app.pendingStart) {
            int pid = app.pid;
            if (pid > 0) {
                this.mService.mPidsSelfLocked.remove(app);
                this.mService.mHandler.removeMessages(20, app);
                this.mService.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
                if (app.isolated) {
                    this.mService.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
                    this.mService.getPackageManagerInternalLocked().removeIsolatedUid(app.uid);
                }
            }
            boolean willRestart = false;
            if (app.isPersistent() && !app.isolated) {
                if (!callerWillRestart) {
                    willRestart = true;
                } else {
                    needRestart = true;
                }
            }
            app.kill(reason, true);
            this.mService.handleAppDiedLocked(app, willRestart, allowRestart);
            if (willRestart) {
                this.removeLruProcessLocked(app);
                this.mService.addAppLocked(app.info, null, false, null);
            }
        } else {
            this.mRemovedProcesses.add(app);
        }
        return needRestart;
    }

    @GuardedBy(value={"mService"})
    final void addProcessNameLocked(ProcessRecord proc) {
        ProcessRecord old = this.removeProcessNameLocked(proc.processName, proc.uid);
        if (old == proc && proc.isPersistent()) {
            Slog.w(TAG, "Re-adding persistent process " + proc);
        } else if (old != null) {
            Slog.wtf(TAG, "Already have existing proc " + old + " when adding " + proc);
        }
        UidRecord uidRec = this.mActiveUids.get(proc.uid);
        if (uidRec == null) {
            uidRec = new UidRecord(proc.uid);
            if (Arrays.binarySearch(this.mService.mDeviceIdleTempWhitelist, UserHandle.getAppId(proc.uid)) >= 0 || this.mService.mPendingTempWhitelist.indexOfKey(proc.uid) >= 0) {
                uidRec.curWhitelist = true;
                uidRec.setWhitelist = true;
            }
            uidRec.updateHasInternetPermission();
            this.mActiveUids.put(proc.uid, uidRec);
            EventLogTags.writeAmUidRunning(uidRec.uid);
            this.mService.noteUidProcessState(uidRec.uid, uidRec.getCurProcState());
        }
        proc.uidRecord = uidRec;
        proc.renderThreadTid = 0;
        ++uidRec.numProcs;
        this.mProcessNames.put(proc.processName, proc.uid, proc);
        if (proc.isolated) {
            this.mIsolatedProcesses.put(proc.uid, proc);
        }
    }

    @GuardedBy(value={"mService"})
    private IsolatedUidRange getOrCreateIsolatedUidRangeLocked(ApplicationInfo info, HostingRecord hostingRecord) {
        if (hostingRecord == null || !hostingRecord.usesAppZygote()) {
            return this.mGlobalIsolatedUids;
        }
        return this.mAppIsolatedUidRangeAllocator.getOrCreateIsolatedUidRangeLocked(info.processName, hostingRecord.getDefiningUid());
    }

    @GuardedBy(value={"mService"})
    final ProcessRecord newProcessRecordLocked(ApplicationInfo info, String customProcess, boolean isolated, int isolatedUid, HostingRecord hostingRecord) {
        String proc = customProcess != null ? customProcess : info.processName;
        int userId = UserHandle.getUserId(info.uid);
        int uid = info.uid;
        if (isolated) {
            if (isolatedUid == 0) {
                IsolatedUidRange uidRange = this.getOrCreateIsolatedUidRangeLocked(info, hostingRecord);
                if (uidRange == null) {
                    return null;
                }
                uid = uidRange.allocateIsolatedUidLocked(userId);
                if (uid == -1) {
                    return null;
                }
            } else {
                uid = isolatedUid;
            }
            this.mService.getPackageManagerInternalLocked().addIsolatedUid(uid, info.uid);
            this.mService.mBatteryStatsService.addIsolatedUid(uid, info.uid);
            StatsLog.write(43, info.uid, uid, 1);
        }
        ProcessRecord r = new ProcessRecord(this.mService, info, proc, uid);
        if (!this.mService.mBooted && !this.mService.mBooting && userId == 0 && (info.flags & 9) == 9) {
            r.setCurrentSchedulingGroup(2);
            r.setSchedGroup = 2;
            r.setPersistent(true);
            r.maxAdj = -800;
        }
        if (isolated && isolatedUid != 0) {
            r.maxAdj = -700;
        }
        this.addProcessNameLocked(r);
        return r;
    }

    @GuardedBy(value={"mService"})
    final ProcessRecord removeProcessNameLocked(String name, int uid) {
        return this.removeProcessNameLocked(name, uid, null);
    }

    @GuardedBy(value={"mService"})
    final ProcessRecord removeProcessNameLocked(String name, int uid, ProcessRecord expecting) {
        ProcessRecord record;
        ProcessRecord old = (ProcessRecord)this.mProcessNames.get(name, uid);
        if (expecting == null || old == expecting) {
            this.mProcessNames.remove(name, uid);
        }
        if (old != null && old.uidRecord != null) {
            --old.uidRecord.numProcs;
            if (old.uidRecord.numProcs == 0) {
                this.mService.enqueueUidChangeLocked(old.uidRecord, -1, 1);
                EventLogTags.writeAmUidStopped(uid);
                this.mActiveUids.remove(uid);
                this.mService.noteUidProcessState(uid, 21);
            }
            old.uidRecord = null;
        }
        this.mIsolatedProcesses.remove(uid);
        this.mGlobalIsolatedUids.freeIsolatedUidLocked(uid);
        ProcessRecord processRecord = record = expecting != null ? expecting : old;
        if (record != null && record.appZygote) {
            this.removeProcessFromAppZygoteLocked(record);
        }
        return old;
    }

    @GuardedBy(value={"mService"})
    void updateCoreSettingsLocked(Bundle settings) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord processRecord = this.mLruProcesses.get(i);
            try {
                if (processRecord.thread == null) continue;
                processRecord.thread.setCoreSettings(settings);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @GuardedBy(value={"mService"})
    void killAllBackgroundProcessesExceptLocked(int minTargetSdk, int maxProcState) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                if (!app.removed && (minTargetSdk >= 0 && app.info.targetSdkVersion >= minTargetSdk || maxProcState >= 0 && app.setProcState <= maxProcState)) continue;
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background except");
        }
    }

    @GuardedBy(value={"mService"})
    void updateAllTimePrefsLocked(int timePref) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null) continue;
            try {
                r.thread.updateTimePrefs(timePref);
                continue;
            }
            catch (RemoteException ex) {
                Slog.w(TAG, "Failed to update preferences for: " + r.info.processName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAllHttpProxy() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord r = this.mLruProcesses.get(i);
                    if (r.pid == ActivityManagerService.MY_PID || r.thread == null || r.isolated) continue;
                    try {
                        r.thread.updateHttpProxy();
                        continue;
                    }
                    catch (RemoteException ex) {
                        Slog.w(TAG, "Failed to update http proxy for: " + r.info.processName);
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        ActivityThread.updateHttpProxy(this.mService.mContext);
    }

    @GuardedBy(value={"mService"})
    void clearAllDnsCacheLocked() {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null) continue;
            try {
                r.thread.clearDnsCache();
                continue;
            }
            catch (RemoteException ex) {
                Slog.w(TAG, "Failed to clear dns cache for: " + r.info.processName);
            }
        }
    }

    @GuardedBy(value={"mService"})
    void handleAllTrustStorageUpdateLocked() {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null) continue;
            try {
                r.thread.handleTrustStorageUpdate();
                continue;
            }
            catch (RemoteException ex) {
                Slog.w(TAG, "Failed to handle trust storage update for: " + r.info.processName);
            }
        }
    }

    @GuardedBy(value={"mService"})
    int updateLruProcessInternalLocked(ProcessRecord app, long now, int index, int lruSeq, String what, Object obj, ProcessRecord srcApp) {
        app.lastActivityTime = now;
        if (app.hasActivitiesOrRecentTasks()) {
            return index;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui < 0) {
            Slog.wtf(TAG, "Adding dependent process " + app + " not on LRU list: " + what + " " + obj + " from " + srcApp);
            return index;
        }
        if (lrui >= index) {
            return index;
        }
        if (lrui >= this.mLruProcessActivityStart && index < this.mLruProcessActivityStart) {
            return index;
        }
        this.mLruProcesses.remove(lrui);
        if (index > 0) {
            --index;
        }
        this.mLruProcesses.add(index, app);
        app.lruSeq = lruSeq;
        return index;
    }

    private void updateClientActivitiesOrdering(ProcessRecord topApp, int topI, int bottomI, int endIndex) {
        if (topApp.hasActivitiesOrRecentTasks() || topApp.treatLikeActivity || !topApp.hasClientActivities()) {
            return;
        }
        int uid = topApp.info.uid;
        if (topApp.connectionGroup > 0) {
            int endImportance = topApp.connectionImportance;
            for (int i = endIndex; i >= bottomI; --i) {
                ProcessRecord subProc = this.mLruProcesses.get(i);
                if (subProc.info.uid != uid || subProc.connectionGroup != topApp.connectionGroup) continue;
                if (i == endIndex && subProc.connectionImportance >= endImportance) {
                    --endIndex;
                    endImportance = subProc.connectionImportance;
                    continue;
                }
                boolean moved = false;
                for (int pos = topI; pos > endIndex; --pos) {
                    ProcessRecord posProc = this.mLruProcesses.get(pos);
                    if (subProc.connectionImportance > posProc.connectionImportance) continue;
                    this.mLruProcesses.remove(i);
                    this.mLruProcesses.add(pos, subProc);
                    moved = true;
                    --endIndex;
                    break;
                }
                if (moved) continue;
                this.mLruProcesses.remove(i);
                this.mLruProcesses.add(endIndex - 1, subProc);
                --endIndex;
                endImportance = subProc.connectionImportance;
            }
        }
        int i = endIndex;
        while (i >= bottomI) {
            ProcessRecord subProc = this.mLruProcesses.get(i);
            if (subProc.info.uid != uid) {
                if (i < endIndex) {
                    boolean hasActivity = false;
                    int connUid = 0;
                    int connGroup = 0;
                    while (i >= bottomI) {
                        this.mLruProcesses.remove(i);
                        this.mLruProcesses.add(endIndex, subProc);
                        if (--i < bottomI) break;
                        subProc = this.mLruProcesses.get(i);
                        if (subProc.hasActivitiesOrRecentTasks() || subProc.treatLikeActivity) {
                            if (hasActivity) break;
                            hasActivity = true;
                        } else if (subProc.hasClientActivities()) {
                            if (hasActivity) {
                                if (connUid == 0 || connUid != subProc.info.uid || connGroup == 0 || connGroup != subProc.connectionGroup) {
                                    break;
                                }
                            } else {
                                hasActivity = true;
                                connUid = subProc.info.uid;
                                connGroup = subProc.connectionGroup;
                            }
                        }
                        --endIndex;
                    }
                }
                --endIndex;
                while (endIndex >= bottomI) {
                    ProcessRecord endProc = this.mLruProcesses.get(endIndex);
                    if (endProc.info.uid == uid) break;
                    --endIndex;
                }
                if (endIndex >= bottomI) {
                    ProcessRecord endProc = this.mLruProcesses.get(endIndex);
                    --endIndex;
                    while (endIndex >= bottomI) {
                        ProcessRecord nextEndProc = this.mLruProcesses.get(endIndex);
                        if (nextEndProc.info.uid != uid || nextEndProc.connectionGroup != endProc.connectionGroup) break;
                        --endIndex;
                    }
                }
                i = endIndex;
                continue;
            }
            --i;
        }
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean activityChange, ProcessRecord client) {
        int j;
        int nextIndex;
        int N;
        long now;
        boolean hasActivity = app.hasActivitiesOrRecentTasks() || app.hasClientActivities() || app.treatLikeActivity;
        boolean hasService = false;
        if (!activityChange && hasActivity) {
            return;
        }
        ++this.mLruSeq;
        app.lastActivityTime = now = SystemClock.uptimeMillis();
        if (hasActivity ? (N = this.mLruProcesses.size()) > 0 && this.mLruProcesses.get(N - 1) == app : this.mLruProcessServiceStart > 0 && this.mLruProcesses.get(this.mLruProcessServiceStart - 1) == app) {
            return;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (app.isPersistent() && lrui >= 0) {
            return;
        }
        if (lrui >= 0) {
            if (lrui < this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui < this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
        int nextActivityIndex = -1;
        if (hasActivity) {
            int N2 = this.mLruProcesses.size();
            nextIndex = this.mLruProcessServiceStart;
            if (!app.hasActivitiesOrRecentTasks() && !app.treatLikeActivity && this.mLruProcessActivityStart < N2 - 1) {
                int endIndex;
                int pos;
                for (pos = N2 - 1; pos > this.mLruProcessActivityStart; --pos) {
                    ProcessRecord posproc = this.mLruProcesses.get(pos);
                    if (posproc.info.uid == app.info.uid) break;
                }
                this.mLruProcesses.add(pos, app);
                if (pos == this.mLruProcessActivityStart) {
                    ++this.mLruProcessActivityStart;
                }
                if (pos == this.mLruProcessServiceStart) {
                    ++this.mLruProcessServiceStart;
                }
                if ((endIndex = pos - 1) < this.mLruProcessActivityStart) {
                    endIndex = this.mLruProcessActivityStart;
                }
                nextActivityIndex = endIndex;
                this.updateClientActivitiesOrdering(app, pos, this.mLruProcessActivityStart, endIndex);
            } else {
                this.mLruProcesses.add(app);
                nextActivityIndex = this.mLruProcesses.size() - 1;
            }
        } else {
            int index = this.mLruProcessServiceStart;
            if (client != null) {
                int clientIndex = this.mLruProcesses.lastIndexOf(client);
                if (clientIndex <= lrui) {
                    clientIndex = lrui;
                }
                if (clientIndex >= 0 && index > clientIndex) {
                    index = clientIndex;
                }
            }
            this.mLruProcesses.add(index, app);
            nextIndex = index - 1;
            ++this.mLruProcessActivityStart;
            ++this.mLruProcessServiceStart;
            if (index > 1) {
                this.updateClientActivitiesOrdering(app, this.mLruProcessServiceStart - 1, 0, index - 1);
            }
        }
        app.lruSeq = this.mLruSeq;
        for (j = app.connections.size() - 1; j >= 0; --j) {
            ConnectionRecord cr = app.connections.valueAt(j);
            if (cr.binding == null || cr.serviceDead || cr.binding.service == null || cr.binding.service.app == null || cr.binding.service.app.lruSeq == this.mLruSeq || (cr.flags & 0x40000130) != 0 || cr.binding.service.app.isPersistent()) continue;
            if (cr.binding.service.app.hasClientActivities()) {
                if (nextActivityIndex < 0) continue;
                nextActivityIndex = this.updateLruProcessInternalLocked(cr.binding.service.app, now, nextActivityIndex, this.mLruSeq, "service connection", cr, app);
                continue;
            }
            nextIndex = this.updateLruProcessInternalLocked(cr.binding.service.app, now, nextIndex, this.mLruSeq, "service connection", cr, app);
        }
        for (j = app.conProviders.size() - 1; j >= 0; --j) {
            ContentProviderRecord cpr = app.conProviders.get((int)j).provider;
            if (cpr.proc == null || cpr.proc.lruSeq == this.mLruSeq || cpr.proc.isPersistent()) continue;
            nextIndex = this.updateLruProcessInternalLocked(cpr.proc, now, nextIndex, this.mLruSeq, "provider reference", cpr, app);
        }
    }

    final ProcessRecord getLRURecordForAppLocked(IApplicationThread thread) {
        IBinder threadBinder = thread.asBinder();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.thread.asBinder() != threadBinder) continue;
            return rec;
        }
        return null;
    }

    boolean haveBackgroundProcessLocked() {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.setProcState < 17) continue;
            return true;
        }
        return false;
    }

    private static int procStateToImportance(int procState, int memAdj, ActivityManager.RunningAppProcessInfo currApp, int clientTargetSdk) {
        int imp = ActivityManager.RunningAppProcessInfo.procStateToImportanceForTargetSdk(procState, clientTargetSdk);
        currApp.lru = imp == 400 ? memAdj : 0;
        return imp;
    }

    @GuardedBy(value={"mService"})
    void fillInProcMemInfoLocked(ProcessRecord app, ActivityManager.RunningAppProcessInfo outInfo, int clientTargetSdk) {
        outInfo.pid = app.pid;
        outInfo.uid = app.info.uid;
        if (this.mService.mAtmInternal.isHeavyWeightProcess(app.getWindowProcessController())) {
            outInfo.flags |= 1;
        }
        if (app.isPersistent()) {
            outInfo.flags |= 2;
        }
        if (app.hasActivities()) {
            outInfo.flags |= 4;
        }
        outInfo.lastTrimLevel = app.trimMemoryLevel;
        int adj = app.curAdj;
        int procState = app.getCurProcState();
        outInfo.importance = ProcessList.procStateToImportance(procState, adj, outInfo, clientTargetSdk);
        outInfo.importanceReasonCode = app.adjTypeCode;
        outInfo.processState = app.getCurProcState();
        outInfo.isFocused = app == this.mService.getTopAppLocked();
        outInfo.lastActivityTime = app.lastActivityTime;
    }

    @GuardedBy(value={"mService"})
    List<ActivityManager.RunningAppProcessInfo> getRunningAppProcessesLocked(boolean allUsers, int userId, boolean allUids, int callingUid, int clientTargetSdk) {
        ArrayList<ActivityManager.RunningAppProcessInfo> runList = null;
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ActivityServiceConnectionsHolder r;
            int pid;
            ProcessRecord app = this.mLruProcesses.get(i);
            if (!allUsers && app.userId != userId || !allUids && app.uid != callingUid || app.thread == null || app.isCrashing() || app.isNotResponding()) continue;
            ActivityManager.RunningAppProcessInfo currApp = new ActivityManager.RunningAppProcessInfo(app.processName, app.pid, app.getPackageList());
            this.fillInProcMemInfoLocked(app, currApp, clientTargetSdk);
            if (app.adjSource instanceof ProcessRecord) {
                currApp.importanceReasonPid = ((ProcessRecord)app.adjSource).pid;
                currApp.importanceReasonImportance = ActivityManager.RunningAppProcessInfo.procStateToImportance(app.adjSourceProcState);
            } else if (app.adjSource instanceof ActivityServiceConnectionsHolder && (pid = (r = (ActivityServiceConnectionsHolder)app.adjSource).getActivityPid()) != -1) {
                currApp.importanceReasonPid = pid;
            }
            if (app.adjTarget instanceof ComponentName) {
                currApp.importanceReasonComponent = (ComponentName)app.adjTarget;
            }
            if (runList == null) {
                runList = new ArrayList<ActivityManager.RunningAppProcessInfo>();
            }
            runList.add(currApp);
        }
        return runList;
    }

    @GuardedBy(value={"mService"})
    int getLruSizeLocked() {
        return this.mLruProcesses.size();
    }

    @GuardedBy(value={"mService"})
    void dumpLruListHeaderLocked(PrintWriter pw) {
        pw.print("  Process LRU list (sorted by oom_adj, ");
        pw.print(this.mLruProcesses.size());
        pw.print(" total, non-act at ");
        pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
        pw.print(", non-svc at ");
        pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
        pw.println("):");
    }

    @GuardedBy(value={"mService"})
    ArrayList<ProcessRecord> collectProcessesLocked(int start, boolean allPkgs, String[] args) {
        ArrayList<ProcessRecord> procs;
        if (args != null && args.length > start && args[start].charAt(0) != '-') {
            procs = new ArrayList();
            int pid = -1;
            try {
                pid = Integer.parseInt(args[start]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (proc.pid > 0 && proc.pid == pid) {
                    procs.add(proc);
                    continue;
                }
                if (allPkgs && proc.pkgList != null && proc.pkgList.containsKey(args[start])) {
                    procs.add(proc);
                    continue;
                }
                if (!proc.processName.equals(args[start])) continue;
                procs.add(proc);
            }
            if (procs.size() <= 0) {
                return null;
            }
        } else {
            procs = new ArrayList<ProcessRecord>(this.mLruProcesses);
        }
        return procs;
    }

    @GuardedBy(value={"mService"})
    void updateApplicationInfoLocked(List<String> packagesToUpdate, int userId, boolean updateFrameworkRes) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (app.thread == null || userId != -1 && app.userId != userId) continue;
            int packageCount = app.pkgList.size();
            for (int j = 0; j < packageCount; ++j) {
                String packageName = app.pkgList.keyAt(j);
                if (!updateFrameworkRes && !packagesToUpdate.contains(packageName)) continue;
                try {
                    ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 1024, app.userId);
                    if (ai == null) continue;
                    app.thread.scheduleApplicationInfoChanged(ai);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w(TAG, String.format("Failed to update %s ApplicationInfo for %s", packageName, app));
                }
            }
        }
    }

    @GuardedBy(value={"mService"})
    void sendPackageBroadcastLocked(int cmd, String[] packages, int userId) {
        boolean foundProcess = false;
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null || userId != -1 && r.userId != userId) continue;
            try {
                for (int index = packages.length - 1; index >= 0 && !foundProcess; --index) {
                    if (!packages[index].equals(r.info.packageName)) continue;
                    foundProcess = true;
                }
                r.thread.dispatchPackageBroadcast(cmd, packages);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (!foundProcess) {
            try {
                AppGlobals.getPackageManager().notifyPackagesReplacedReceived(packages);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @GuardedBy(value={"mService"})
    int getUidProcStateLocked(int uid) {
        UidRecord uidRec = this.mActiveUids.get(uid);
        return uidRec == null ? 21 : uidRec.getCurProcState();
    }

    @GuardedBy(value={"mService"})
    UidRecord getUidRecordLocked(int uid) {
        return this.mActiveUids.get(uid);
    }

    @GuardedBy(value={"mService"})
    void doStopUidForIdleUidsLocked() {
        int size = this.mActiveUids.size();
        for (int i = 0; i < size; ++i) {
            int uid = this.mActiveUids.keyAt(i);
            if (UserHandle.isCore(uid)) continue;
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            if (!uidRec.idle) continue;
            this.mService.doStopUidLocked(uidRec.uid, uidRec);
        }
    }

    static {
        sProcStateToProcMem = new int[]{0, 0, 1, 2, 2, 1, 2, 2, 2, 2, 2, 3, 4, 1, 2, 4, 4, 4, 4, 4, 4};
        sFirstAwakePssTimes = new long[]{30000L, 10000L, 20000L, 20000L, 20000L};
        sSameAwakePssTimes = new long[]{600000L, 60000L, 600000L, 300000L, 600000L};
        sFirstAsleepPssTimes = new long[]{60000L, 20000L, 30000L, 30000L, 60000L};
        sSameAsleepPssTimes = new long[]{600000L, 60000L, 600000L, 300000L, 600000L};
        sTestFirstPssTimes = new long[]{3000L, 3000L, 5000L, 5000L, 5000L};
        sTestSamePssTimes = new long[]{15000L, 10000L, 10000L, 15000L, 15000L};
    }

    public static final class ProcStateMemTracker {
        final int[] mHighestMem = new int[5];
        final float[] mScalingFactor = new float[5];
        int mTotalHighestMem = 4;
        int mPendingMemState;
        int mPendingHighestMemState;
        float mPendingScalingFactor;

        public ProcStateMemTracker() {
            for (int i = 0; i < 5; ++i) {
                this.mHighestMem[i] = 5;
                this.mScalingFactor[i] = 1.0f;
            }
            this.mPendingMemState = -1;
        }

        public void dumpLine(PrintWriter pw) {
            pw.print("best=");
            pw.print(this.mTotalHighestMem);
            pw.print(" (");
            boolean needSep = false;
            for (int i = 0; i < 5; ++i) {
                if (this.mHighestMem[i] >= 5) continue;
                if (needSep) {
                    pw.print(", ");
                    needSep = false;
                }
                pw.print(i);
                pw.print("=");
                pw.print(this.mHighestMem[i]);
                pw.print(" ");
                pw.print(this.mScalingFactor[i]);
                pw.print("x");
                needSep = true;
            }
            pw.print(")");
            if (this.mPendingMemState >= 0) {
                pw.print(" / pending state=");
                pw.print(this.mPendingMemState);
                pw.print(" highest=");
                pw.print(this.mPendingHighestMemState);
                pw.print(" ");
                pw.print(this.mPendingScalingFactor);
                pw.print("x");
            }
            pw.println();
        }
    }

    final class KillHandler
    extends Handler {
        static final int KILL_PROCESS_GROUP_MSG = 4000;

        public KillHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4000: {
                    Trace.traceBegin(64L, "killProcessGroup");
                    Process.killProcessGroup(msg.arg1, msg.arg2);
                    Trace.traceEnd(64L);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    final class MyProcessMap
    extends ProcessMap<ProcessRecord> {
        MyProcessMap() {
        }

        @Override
        public ProcessRecord put(String name, int uid, ProcessRecord value) {
            ProcessRecord r = super.put(name, uid, value);
            ProcessList.this.mService.mAtmInternal.onProcessAdded(r.getWindowProcessController());
            return r;
        }

        @Override
        public ProcessRecord remove(String name, int uid) {
            ProcessRecord r = (ProcessRecord)super.remove(name, uid);
            ProcessList.this.mService.mAtmInternal.onProcessRemoved(name, uid);
            return r;
        }
    }

    final class IsolatedUidRangeAllocator {
        private final int mFirstUid;
        private final int mNumUidRanges;
        private final int mNumUidsPerRange;
        @GuardedBy(value={"ProcessList.this.mService"})
        private final BitSet mAvailableUidRanges;
        @GuardedBy(value={"ProcessList.this.mService"})
        private final ProcessMap<IsolatedUidRange> mAppRanges = new ProcessMap();

        IsolatedUidRangeAllocator(int firstUid, int lastUid, int numUidsPerRange) {
            this.mFirstUid = firstUid;
            this.mNumUidsPerRange = numUidsPerRange;
            this.mNumUidRanges = (lastUid - firstUid + 1) / numUidsPerRange;
            this.mAvailableUidRanges = new BitSet(this.mNumUidRanges);
            this.mAvailableUidRanges.set(0, this.mNumUidRanges);
        }

        @GuardedBy(value={"ProcessList.this.mService"})
        IsolatedUidRange getIsolatedUidRangeLocked(String processName, int uid) {
            return this.mAppRanges.get(processName, uid);
        }

        @GuardedBy(value={"ProcessList.this.mService"})
        IsolatedUidRange getOrCreateIsolatedUidRangeLocked(String processName, int uid) {
            IsolatedUidRange range = this.getIsolatedUidRangeLocked(processName, uid);
            if (range == null) {
                int uidRangeIndex = this.mAvailableUidRanges.nextSetBit(0);
                if (uidRangeIndex < 0) {
                    return null;
                }
                this.mAvailableUidRanges.clear(uidRangeIndex);
                int actualUid = this.mFirstUid + uidRangeIndex * this.mNumUidsPerRange;
                range = new IsolatedUidRange(actualUid, actualUid + this.mNumUidsPerRange - 1);
                this.mAppRanges.put(processName, uid, range);
            }
            return range;
        }

        @GuardedBy(value={"ProcessList.this.mService"})
        void freeUidRangeLocked(ApplicationInfo info) {
            IsolatedUidRange range = this.mAppRanges.get(info.processName, info.uid);
            if (range != null) {
                int uidRangeIndex = (range.mFirstUid - this.mFirstUid) / this.mNumUidsPerRange;
                this.mAvailableUidRanges.set(uidRangeIndex);
                this.mAppRanges.remove(info.processName, info.uid);
            }
        }
    }

    final class IsolatedUidRange {
        @VisibleForTesting
        public final int mFirstUid;
        @VisibleForTesting
        public final int mLastUid;
        @GuardedBy(value={"ProcessList.this.mService"})
        private final SparseBooleanArray mUidUsed = new SparseBooleanArray();
        @GuardedBy(value={"ProcessList.this.mService"})
        private int mNextUid;

        IsolatedUidRange(int firstUid, int lastUid) {
            this.mFirstUid = firstUid;
            this.mLastUid = lastUid;
            this.mNextUid = firstUid;
        }

        @GuardedBy(value={"ProcessList.this.mService"})
        int allocateIsolatedUidLocked(int userId) {
            int stepsLeft = this.mLastUid - this.mFirstUid + 1;
            for (int i = 0; i < stepsLeft; ++i) {
                if (this.mNextUid < this.mFirstUid || this.mNextUid > this.mLastUid) {
                    this.mNextUid = this.mFirstUid;
                }
                int uid = UserHandle.getUid(userId, this.mNextUid);
                ++this.mNextUid;
                if (this.mUidUsed.get(uid, false)) continue;
                this.mUidUsed.put(uid, true);
                return uid;
            }
            return -1;
        }

        @GuardedBy(value={"ProcessList.this.mService"})
        void freeIsolatedUidLocked(int uid) {
            int appId = UserHandle.getAppId(uid);
            this.mUidUsed.delete(appId);
        }
    }
}

