/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ApplicationErrorReport;
import android.app.Dialog;
import android.app.IApplicationThread;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.VersionedPackage;
import android.content.res.CompatibilityInfo;
import android.os.Binder;
import android.os.Debug;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.Zygote;
import com.android.server.Watchdog;
import com.android.server.am.ActiveInstrumentation;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.HostingRecord;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import com.android.server.am.UidRecord;
import com.android.server.wm.WindowProcessController;
import com.android.server.wm.WindowProcessListener;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProcessRecord
implements WindowProcessListener {
    private static final String TAG = "ActivityManager";
    private final ActivityManagerService mService;
    final ApplicationInfo info;
    final boolean isolated;
    final boolean appZygote;
    final int uid;
    final int userId;
    final String processName;
    final PackageList pkgList = new PackageList();
    final ProcessList.ProcStateMemTracker procStateMemTracker = new ProcessList.ProcStateMemTracker();
    UidRecord uidRecord;
    ArraySet<String> pkgDeps;
    IApplicationThread thread;
    ProcessState baseProcessTracker;
    BatteryStatsImpl.Uid.Proc curProcBatteryStats;
    int pid;
    String procStatFile;
    int[] gids;
    private String mRequiredAbi;
    String instructionSet;
    boolean starting;
    long lastActivityTime;
    long lastPssTime;
    long nextPssTime;
    long lastStateTime;
    long initialIdlePss;
    long lastPss;
    long lastSwapPss;
    long lastCachedPss;
    long lastCachedSwapPss;
    int maxAdj;
    private int mCurRawAdj;
    int setRawAdj;
    int curAdj;
    int setAdj;
    int verifiedAdj;
    long lastCompactTime;
    int reqCompactAction;
    int lastCompactAction;
    private int mCurSchedGroup;
    int setSchedGroup;
    int trimMemoryLevel;
    private int mCurProcState = 21;
    private int mRepProcState = 21;
    private int mCurRawProcState = 21;
    int setProcState = 21;
    int pssProcState = 21;
    int pssStatType;
    int savedPriority;
    int renderThreadTid;
    ServiceRecord connectionService;
    int connectionGroup;
    int connectionImportance;
    boolean serviceb;
    boolean serviceHighRam;
    boolean notCachedSinceIdle;
    private boolean mHasClientActivities;
    boolean hasStartedServices;
    private boolean mHasForegroundServices;
    private int mFgServiceTypes;
    private int mRepFgServiceTypes;
    private boolean mHasForegroundActivities;
    boolean repForegroundActivities;
    boolean systemNoUi;
    boolean hasShownUi;
    private boolean mHasTopUi;
    private boolean mHasOverlayUi;
    boolean runningRemoteAnimation;
    private boolean mPendingUiClean;
    boolean hasAboveClient;
    boolean treatLikeActivity;
    boolean bad;
    boolean killedByAm;
    boolean killed;
    boolean procStateChanged;
    boolean reportedInteraction;
    boolean unlocked;
    private long mInteractionEventTime;
    private long mFgInteractionTime;
    String waitingToKill;
    Object forcingToImportant;
    int adjSeq;
    int completedAdjSeq;
    boolean containsCycle;
    int lruSeq;
    CompatibilityInfo compat;
    IBinder.DeathRecipient deathRecipient;
    private ActiveInstrumentation mInstr;
    private boolean mUsingWrapper;
    final ArraySet<BroadcastRecord> curReceivers = new ArraySet();
    private long mWhenUnimportant;
    long lastCpuTime;
    long curCpuTime;
    long lastRequestedGc;
    long lastLowMemory;
    long lastProviderTime;
    long lastTopTime;
    boolean reportLowMemory;
    boolean empty;
    boolean cached;
    String adjType;
    int adjTypeCode;
    Object adjSource;
    int adjSourceProcState;
    Object adjTarget;
    Runnable crashHandler;
    Debug.MemoryInfo lastMemInfo;
    long lastMemInfoTime;
    private final WindowProcessController mWindowProcessController;
    final ArraySet<ServiceRecord> services = new ArraySet();
    final ArraySet<ServiceRecord> executingServices = new ArraySet();
    final ArraySet<ConnectionRecord> connections = new ArraySet();
    final ArraySet<ReceiverList> receivers = new ArraySet();
    final ArrayMap<String, ContentProviderRecord> pubProviders = new ArrayMap();
    final ArrayList<ContentProviderConnection> conProviders = new ArrayList();
    final ArraySet<Binder> mAllowBackgroundActivityStartsTokens = new ArraySet();
    private ArraySet<Integer> mBoundClientUids = new ArraySet();
    String isolatedEntryPoint;
    String[] isolatedEntryPointArgs;
    boolean execServicesFg;
    private boolean mPersistent;
    private boolean mCrashing;
    Dialog crashDialog;
    boolean forceCrashReport;
    private boolean mNotResponding;
    Dialog anrDialog;
    volatile boolean removed;
    private boolean mDebugging;
    boolean waitedForDebugger;
    Dialog waitDialog;
    String shortStringName;
    String stringName;
    boolean pendingStart;
    long startSeq;
    int mountMode;
    ActivityManager.ProcessErrorStateInfo crashingReport;
    ActivityManager.ProcessErrorStateInfo notRespondingReport;
    ComponentName errorReportReceiver;
    public boolean inFullBackup;
    boolean whitelistManager;
    HostingRecord hostingRecord;
    String seInfo;
    long startTime;
    int startUid;

    void setStartParams(int startUid, HostingRecord hostingRecord, String seInfo, long startTime) {
        this.startUid = startUid;
        this.hostingRecord = hostingRecord;
        this.seInfo = seInfo;
        this.startTime = startTime;
    }

    void dump(PrintWriter pw, String prefix) {
        int i;
        long nowUptime = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("user #");
        pw.print(this.userId);
        pw.print(" uid=");
        pw.print(this.info.uid);
        if (this.uid != this.info.uid) {
            pw.print(" ISOLATED uid=");
            pw.print(this.uid);
        }
        pw.print(" gids={");
        if (this.gids != null) {
            for (int gi = 0; gi < this.gids.length; ++gi) {
                if (gi != 0) {
                    pw.print(", ");
                }
                pw.print(this.gids[gi]);
            }
        }
        pw.println("}");
        pw.print(prefix);
        pw.print("mRequiredAbi=");
        pw.print(this.mRequiredAbi);
        pw.print(" instructionSet=");
        pw.println(this.instructionSet);
        if (this.info.className != null) {
            pw.print(prefix);
            pw.print("class=");
            pw.println(this.info.className);
        }
        if (this.info.manageSpaceActivityName != null) {
            pw.print(prefix);
            pw.print("manageSpaceActivityName=");
            pw.println(this.info.manageSpaceActivityName);
        }
        pw.print(prefix);
        pw.print("dir=");
        pw.print(this.info.sourceDir);
        pw.print(" publicDir=");
        pw.print(this.info.publicSourceDir);
        pw.print(" data=");
        pw.println(this.info.dataDir);
        pw.print(prefix);
        pw.print("packageList={");
        for (i = 0; i < this.pkgList.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.pkgList.keyAt(i));
        }
        pw.println("}");
        if (this.pkgDeps != null) {
            pw.print(prefix);
            pw.print("packageDependencies={");
            for (i = 0; i < this.pkgDeps.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.pkgDeps.valueAt(i));
            }
            pw.println("}");
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.println(this.compat);
        if (this.mInstr != null) {
            pw.print(prefix);
            pw.print("mInstr=");
            pw.println(this.mInstr);
        }
        pw.print(prefix);
        pw.print("thread=");
        pw.println(this.thread);
        pw.print(prefix);
        pw.print("pid=");
        pw.print(this.pid);
        pw.print(" starting=");
        pw.println(this.starting);
        pw.print(prefix);
        pw.print("lastActivityTime=");
        TimeUtils.formatDuration(this.lastActivityTime, nowUptime, pw);
        pw.print(" lastPssTime=");
        TimeUtils.formatDuration(this.lastPssTime, nowUptime, pw);
        pw.print(" pssStatType=");
        pw.print(this.pssStatType);
        pw.print(" nextPssTime=");
        TimeUtils.formatDuration(this.nextPssTime, nowUptime, pw);
        pw.println();
        pw.print(prefix);
        pw.print("adjSeq=");
        pw.print(this.adjSeq);
        pw.print(" lruSeq=");
        pw.print(this.lruSeq);
        pw.print(" lastPss=");
        DebugUtils.printSizeValue(pw, this.lastPss * 1024L);
        pw.print(" lastSwapPss=");
        DebugUtils.printSizeValue(pw, this.lastSwapPss * 1024L);
        pw.print(" lastCachedPss=");
        DebugUtils.printSizeValue(pw, this.lastCachedPss * 1024L);
        pw.print(" lastCachedSwapPss=");
        DebugUtils.printSizeValue(pw, this.lastCachedSwapPss * 1024L);
        pw.println();
        pw.print(prefix);
        pw.print("procStateMemTracker: ");
        this.procStateMemTracker.dumpLine(pw);
        pw.print(prefix);
        pw.print("cached=");
        pw.print(this.cached);
        pw.print(" empty=");
        pw.println(this.empty);
        if (this.serviceb) {
            pw.print(prefix);
            pw.print("serviceb=");
            pw.print(this.serviceb);
            pw.print(" serviceHighRam=");
            pw.println(this.serviceHighRam);
        }
        if (this.notCachedSinceIdle) {
            pw.print(prefix);
            pw.print("notCachedSinceIdle=");
            pw.print(this.notCachedSinceIdle);
            pw.print(" initialIdlePss=");
            pw.println(this.initialIdlePss);
        }
        pw.print(prefix);
        pw.print("oom: max=");
        pw.print(this.maxAdj);
        pw.print(" curRaw=");
        pw.print(this.mCurRawAdj);
        pw.print(" setRaw=");
        pw.print(this.setRawAdj);
        pw.print(" cur=");
        pw.print(this.curAdj);
        pw.print(" set=");
        pw.println(this.setAdj);
        pw.print(prefix);
        pw.print("lastCompactTime=");
        pw.print(this.lastCompactTime);
        pw.print(" lastCompactAction=");
        pw.print(this.lastCompactAction);
        pw.print(prefix);
        pw.print("mCurSchedGroup=");
        pw.print(this.mCurSchedGroup);
        pw.print(" setSchedGroup=");
        pw.print(this.setSchedGroup);
        pw.print(" systemNoUi=");
        pw.print(this.systemNoUi);
        pw.print(" trimMemoryLevel=");
        pw.println(this.trimMemoryLevel);
        pw.print(prefix);
        pw.print("curProcState=");
        pw.print(this.getCurProcState());
        pw.print(" mRepProcState=");
        pw.print(this.mRepProcState);
        pw.print(" pssProcState=");
        pw.print(this.pssProcState);
        pw.print(" setProcState=");
        pw.print(this.setProcState);
        pw.print(" lastStateTime=");
        TimeUtils.formatDuration(this.lastStateTime, nowUptime, pw);
        pw.println();
        if (this.hasShownUi || this.mPendingUiClean || this.hasAboveClient || this.treatLikeActivity) {
            pw.print(prefix);
            pw.print("hasShownUi=");
            pw.print(this.hasShownUi);
            pw.print(" pendingUiClean=");
            pw.print(this.mPendingUiClean);
            pw.print(" hasAboveClient=");
            pw.print(this.hasAboveClient);
            pw.print(" treatLikeActivity=");
            pw.println(this.treatLikeActivity);
        }
        if (this.connectionService != null || this.connectionGroup != 0) {
            pw.print(prefix);
            pw.print("connectionGroup=");
            pw.print(this.connectionGroup);
            pw.print(" Importance=");
            pw.print(this.connectionImportance);
            pw.print(" Service=");
            pw.println(this.connectionService);
        }
        if (this.hasTopUi() || this.hasOverlayUi() || this.runningRemoteAnimation) {
            pw.print(prefix);
            pw.print("hasTopUi=");
            pw.print(this.hasTopUi());
            pw.print(" hasOverlayUi=");
            pw.print(this.hasOverlayUi());
            pw.print(" runningRemoteAnimation=");
            pw.println(this.runningRemoteAnimation);
        }
        if (this.mHasForegroundServices || this.forcingToImportant != null) {
            pw.print(prefix);
            pw.print("mHasForegroundServices=");
            pw.print(this.mHasForegroundServices);
            pw.print(" forcingToImportant=");
            pw.println(this.forcingToImportant);
        }
        if (this.reportedInteraction || this.mFgInteractionTime != 0L) {
            pw.print(prefix);
            pw.print("reportedInteraction=");
            pw.print(this.reportedInteraction);
            if (this.mInteractionEventTime != 0L) {
                pw.print(" time=");
                TimeUtils.formatDuration(this.mInteractionEventTime, SystemClock.elapsedRealtime(), pw);
            }
            if (this.mFgInteractionTime != 0L) {
                pw.print(" fgInteractionTime=");
                TimeUtils.formatDuration(this.mFgInteractionTime, SystemClock.elapsedRealtime(), pw);
            }
            pw.println();
        }
        if (this.mPersistent || this.removed) {
            pw.print(prefix);
            pw.print("persistent=");
            pw.print(this.mPersistent);
            pw.print(" removed=");
            pw.println(this.removed);
        }
        if (this.mHasClientActivities || this.mHasForegroundActivities || this.repForegroundActivities) {
            pw.print(prefix);
            pw.print("hasClientActivities=");
            pw.print(this.mHasClientActivities);
            pw.print(" foregroundActivities=");
            pw.print(this.mHasForegroundActivities);
            pw.print(" (rep=");
            pw.print(this.repForegroundActivities);
            pw.println(")");
        }
        if (this.lastProviderTime > 0L) {
            pw.print(prefix);
            pw.print("lastProviderTime=");
            TimeUtils.formatDuration(this.lastProviderTime, nowUptime, pw);
            pw.println();
        }
        if (this.lastTopTime > 0L) {
            pw.print(prefix);
            pw.print("lastTopTime=");
            TimeUtils.formatDuration(this.lastTopTime, nowUptime, pw);
            pw.println();
        }
        if (this.hasStartedServices) {
            pw.print(prefix);
            pw.print("hasStartedServices=");
            pw.println(this.hasStartedServices);
        }
        if (this.pendingStart) {
            pw.print(prefix);
            pw.print("pendingStart=");
            pw.println(this.pendingStart);
        }
        pw.print(prefix);
        pw.print("startSeq=");
        pw.println(this.startSeq);
        pw.print(prefix);
        pw.print("mountMode=");
        pw.println(DebugUtils.valueToString(Zygote.class, "MOUNT_EXTERNAL_", this.mountMode));
        if (this.setProcState > 11) {
            pw.print(prefix);
            pw.print("lastCpuTime=");
            pw.print(this.lastCpuTime);
            if (this.lastCpuTime > 0L) {
                pw.print(" timeUsed=");
                TimeUtils.formatDuration(this.curCpuTime - this.lastCpuTime, pw);
            }
            pw.print(" whenUnimportant=");
            TimeUtils.formatDuration(this.mWhenUnimportant - nowUptime, pw);
            pw.println();
        }
        pw.print(prefix);
        pw.print("lastRequestedGc=");
        TimeUtils.formatDuration(this.lastRequestedGc, nowUptime, pw);
        pw.print(" lastLowMemory=");
        TimeUtils.formatDuration(this.lastLowMemory, nowUptime, pw);
        pw.print(" reportLowMemory=");
        pw.println(this.reportLowMemory);
        if (this.killed || this.killedByAm || this.waitingToKill != null) {
            pw.print(prefix);
            pw.print("killed=");
            pw.print(this.killed);
            pw.print(" killedByAm=");
            pw.print(this.killedByAm);
            pw.print(" waitingToKill=");
            pw.println(this.waitingToKill);
        }
        if (this.mDebugging || this.mCrashing || this.crashDialog != null || this.mNotResponding || this.anrDialog != null || this.bad) {
            pw.print(prefix);
            pw.print("mDebugging=");
            pw.print(this.mDebugging);
            pw.print(" mCrashing=");
            pw.print(this.mCrashing);
            pw.print(" ");
            pw.print(this.crashDialog);
            pw.print(" mNotResponding=");
            pw.print(this.mNotResponding);
            pw.print(" ");
            pw.print(this.anrDialog);
            pw.print(" bad=");
            pw.print(this.bad);
            if (this.errorReportReceiver != null) {
                pw.print(" errorReportReceiver=");
                pw.print(this.errorReportReceiver.flattenToShortString());
            }
            pw.println();
        }
        if (this.whitelistManager) {
            pw.print(prefix);
            pw.print("whitelistManager=");
            pw.println(this.whitelistManager);
        }
        if (this.isolatedEntryPoint != null || this.isolatedEntryPointArgs != null) {
            pw.print(prefix);
            pw.print("isolatedEntryPoint=");
            pw.println(this.isolatedEntryPoint);
            pw.print(prefix);
            pw.print("isolatedEntryPointArgs=");
            pw.println(Arrays.toString(this.isolatedEntryPointArgs));
        }
        this.mWindowProcessController.dump(pw, prefix);
        if (this.services.size() > 0) {
            pw.print(prefix);
            pw.println("Services:");
            for (i = 0; i < this.services.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.services.valueAt(i));
            }
        }
        if (this.executingServices.size() > 0) {
            pw.print(prefix);
            pw.print("Executing Services (fg=");
            pw.print(this.execServicesFg);
            pw.println(")");
            for (i = 0; i < this.executingServices.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.executingServices.valueAt(i));
            }
        }
        if (this.connections.size() > 0) {
            pw.print(prefix);
            pw.println("Connections:");
            for (i = 0; i < this.connections.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.connections.valueAt(i));
            }
        }
        if (this.pubProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Published Providers:");
            for (i = 0; i < this.pubProviders.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.pubProviders.keyAt(i));
                pw.print(prefix);
                pw.print("    -> ");
                pw.println(this.pubProviders.valueAt(i));
            }
        }
        if (this.conProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Connected Providers:");
            for (i = 0; i < this.conProviders.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.conProviders.get(i).toShortString());
            }
        }
        if (!this.curReceivers.isEmpty()) {
            pw.print(prefix);
            pw.println("Current Receivers:");
            for (i = 0; i < this.curReceivers.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.curReceivers.valueAt(i));
            }
        }
        if (this.receivers.size() > 0) {
            pw.print(prefix);
            pw.println("Receivers:");
            for (i = 0; i < this.receivers.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.receivers.valueAt(i));
            }
        }
        if (this.mAllowBackgroundActivityStartsTokens.size() > 0) {
            pw.print(prefix);
            pw.println("Background activity start whitelist tokens:");
            for (i = 0; i < this.mAllowBackgroundActivityStartsTokens.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.mAllowBackgroundActivityStartsTokens.valueAt(i));
            }
        }
    }

    ProcessRecord(ActivityManagerService _service, ApplicationInfo _info, String _processName, int _uid) {
        this.mService = _service;
        this.info = _info;
        this.isolated = _info.uid != _uid;
        this.appZygote = UserHandle.getAppId(_uid) >= 90000 && UserHandle.getAppId(_uid) <= 98999;
        this.uid = _uid;
        this.userId = UserHandle.getUserId(_uid);
        this.processName = _processName;
        this.maxAdj = 1001;
        this.setRawAdj = -10000;
        this.mCurRawAdj = -10000;
        this.verifiedAdj = -10000;
        this.setAdj = -10000;
        this.curAdj = -10000;
        this.mPersistent = false;
        this.removed = false;
        this.lastPssTime = this.nextPssTime = SystemClock.uptimeMillis();
        this.lastStateTime = this.nextPssTime;
        this.mWindowProcessController = new WindowProcessController(this.mService.mActivityTaskManager, this.info, this.processName, this.uid, this.userId, this, this);
        this.pkgList.put(_info.packageName, new ProcessStats.ProcessStateHolder(_info.longVersionCode));
    }

    public void setPid(int _pid) {
        this.pid = _pid;
        this.mWindowProcessController.setPid(this.pid);
        this.procStatFile = null;
        this.shortStringName = null;
        this.stringName = null;
    }

    public void makeActive(IApplicationThread _thread, ProcessStatsService tracker) {
        if (this.thread == null) {
            ProcessState origBase = this.baseProcessTracker;
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList.mPkgList);
                for (int ipkg = this.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                    StatsLog.write(3, this.uid, this.processName, this.pkgList.keyAt(ipkg), ActivityManager.processStateAmToProto(-1), this.pkgList.valueAt((int)ipkg).appVersion);
                }
                origBase.makeInactive();
            }
            this.baseProcessTracker = tracker.getProcessStateLocked(this.info.packageName, this.info.uid, this.info.longVersionCode, this.processName);
            this.baseProcessTracker.makeActive();
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                tracker.updateProcessStateHolderLocked(holder, this.pkgList.keyAt(i), this.info.uid, this.info.longVersionCode, this.processName);
                if (holder.state == this.baseProcessTracker) continue;
                holder.state.makeActive();
            }
        }
        this.thread = _thread;
        this.mWindowProcessController.setThread(this.thread);
    }

    public void makeInactive(ProcessStatsService tracker) {
        this.thread = null;
        this.mWindowProcessController.setThread(null);
        ProcessState origBase = this.baseProcessTracker;
        if (origBase != null) {
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList.mPkgList);
                for (int ipkg = this.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                    StatsLog.write(3, this.uid, this.processName, this.pkgList.keyAt(ipkg), ActivityManager.processStateAmToProto(-1), this.pkgList.valueAt((int)ipkg).appVersion);
                }
                origBase.makeInactive();
            }
            this.baseProcessTracker = null;
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                holder.pkg = null;
                holder.state = null;
            }
        }
    }

    boolean hasActivities() {
        return this.mWindowProcessController.hasActivities();
    }

    boolean hasActivitiesOrRecentTasks() {
        return this.mWindowProcessController.hasActivitiesOrRecentTasks();
    }

    boolean hasRecentTasks() {
        return this.mWindowProcessController.hasRecentTasks();
    }

    public boolean isInterestingToUserLocked() {
        if (this.mWindowProcessController.isInterestingToUser()) {
            return true;
        }
        int servicesSize = this.services.size();
        for (int i = 0; i < servicesSize; ++i) {
            ServiceRecord r = this.services.valueAt(i);
            if (!r.isForeground) continue;
            return true;
        }
        return false;
    }

    public void unlinkDeathRecipient() {
        if (this.deathRecipient != null && this.thread != null) {
            this.thread.asBinder().unlinkToDeath(this.deathRecipient, 0);
        }
        this.deathRecipient = null;
    }

    void updateHasAboveClientLocked() {
        this.hasAboveClient = false;
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            ConnectionRecord cr = this.connections.valueAt(i);
            if ((cr.flags & 8) == 0) continue;
            this.hasAboveClient = true;
            break;
        }
    }

    int modifyRawOomAdj(int adj) {
        if (this.hasAboveClient && adj >= 0) {
            if (adj < 100) {
                adj = 100;
            } else if (adj < 200) {
                adj = 200;
            } else if (adj < 250) {
                adj = 250;
            } else if (adj < 900) {
                adj = 900;
            } else if (adj < 999) {
                ++adj;
            }
        }
        return adj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCrash(String message) {
        if (!this.killedByAm && this.thread != null) {
            if (this.pid == Process.myPid()) {
                Slog.w(TAG, "scheduleCrash: trying to crash system process!");
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.thread.scheduleCrash(message);
            }
            catch (RemoteException e) {
                this.kill("scheduleCrash for '" + message + "' failed", true);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    void kill(String reason, boolean noisy) {
        if (!this.killedByAm) {
            Trace.traceBegin(64L, "kill");
            if (this.mService != null && (noisy || this.info.uid == this.mService.mCurOomAdjUid)) {
                this.mService.reportUidInfoMessageLocked(TAG, "Killing " + this.toShortString() + " (adj " + this.setAdj + "): " + reason, this.info.uid);
            }
            if (this.pid > 0) {
                EventLog.writeEvent(30023, this.userId, this.pid, this.processName, this.setAdj, reason);
                Process.killProcessQuiet(this.pid);
                ProcessList.killProcessGroup(this.uid, this.pid);
            } else {
                this.pendingStart = false;
            }
            if (!this.mPersistent) {
                this.killed = true;
                this.killedByAm = true;
            }
            Trace.traceEnd(64L);
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        this.writeToProto(proto, fieldId, -1);
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, int lruIndex) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.pid);
        proto.write(1138166333442L, this.processName);
        proto.write(1120986464259L, this.info.uid);
        if (UserHandle.getAppId(this.info.uid) >= 10000) {
            proto.write(1120986464260L, this.userId);
            proto.write(0x10500000005L, UserHandle.getAppId(this.info.uid));
        }
        if (this.uid != this.info.uid) {
            proto.write(1120986464262L, UserHandle.getAppId(this.uid));
        }
        proto.write(1133871366151L, this.mPersistent);
        if (lruIndex >= 0) {
            proto.write(1120986464264L, lruIndex);
        }
        proto.end(token);
    }

    public String toShortString() {
        if (this.shortStringName != null) {
            return this.shortStringName;
        }
        StringBuilder sb = new StringBuilder(128);
        this.toShortString(sb);
        this.shortStringName = sb.toString();
        return this.shortStringName;
    }

    void toShortString(StringBuilder sb) {
        sb.append(this.pid);
        sb.append(':');
        sb.append(this.processName);
        sb.append('/');
        if (this.info.uid < 10000) {
            sb.append(this.uid);
        } else {
            sb.append('u');
            sb.append(this.userId);
            int appId = UserHandle.getAppId(this.info.uid);
            if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
            if (this.uid != this.info.uid) {
                sb.append('i');
                sb.append(UserHandle.getAppId(this.uid) - 99000);
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        this.toShortString(sb);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public String makeAdjReason() {
        if (this.adjSource != null || this.adjTarget != null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(' ');
            if (this.adjTarget instanceof ComponentName) {
                sb.append(((ComponentName)this.adjTarget).flattenToShortString());
            } else if (this.adjTarget != null) {
                sb.append(this.adjTarget.toString());
            } else {
                sb.append("{null}");
            }
            sb.append("<=");
            if (this.adjSource instanceof ProcessRecord) {
                sb.append("Proc{");
                sb.append(((ProcessRecord)this.adjSource).toShortString());
                sb.append("}");
            } else if (this.adjSource != null) {
                sb.append(this.adjSource.toString());
            } else {
                sb.append("{null}");
            }
            return sb.toString();
        }
        return null;
    }

    public boolean addPackage(String pkg, long versionCode, ProcessStatsService tracker) {
        if (!this.pkgList.containsKey(pkg)) {
            ProcessStats.ProcessStateHolder holder = new ProcessStats.ProcessStateHolder(versionCode);
            if (this.baseProcessTracker != null) {
                tracker.updateProcessStateHolderLocked(holder, pkg, this.info.uid, versionCode, this.processName);
                this.pkgList.put(pkg, holder);
                if (holder.state != this.baseProcessTracker) {
                    holder.state.makeActive();
                }
            } else {
                this.pkgList.put(pkg, holder);
            }
            return true;
        }
        return false;
    }

    public int getSetAdjWithServices() {
        if (this.setAdj >= 900 && this.hasStartedServices) {
            return 800;
        }
        return this.setAdj;
    }

    public void forceProcessStateUpTo(int newState) {
        if (this.mRepProcState > newState) {
            this.mRepProcState = newState;
            this.setCurProcState(newState);
            this.setCurRawProcState(newState);
            for (int ipkg = this.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                StatsLog.write(3, this.uid, this.processName, this.pkgList.keyAt(ipkg), ActivityManager.processStateAmToProto(this.mRepProcState), this.pkgList.valueAt((int)ipkg).appVersion);
            }
        }
    }

    public void resetPackageList(ProcessStatsService tracker) {
        int N = this.pkgList.size();
        if (this.baseProcessTracker != null) {
            long now = SystemClock.uptimeMillis();
            this.baseProcessTracker.setState(-1, tracker.getMemFactorLocked(), now, this.pkgList.mPkgList);
            for (int ipkg = this.pkgList.size() - 1; ipkg >= 0; --ipkg) {
                StatsLog.write(3, this.uid, this.processName, this.pkgList.keyAt(ipkg), ActivityManager.processStateAmToProto(-1), this.pkgList.valueAt((int)ipkg).appVersion);
            }
            if (N != 1) {
                for (int i = 0; i < N; ++i) {
                    ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                    if (holder.state == null || holder.state == this.baseProcessTracker) continue;
                    holder.state.makeInactive();
                }
                this.pkgList.clear();
                ProcessStats.ProcessStateHolder holder = new ProcessStats.ProcessStateHolder(this.info.longVersionCode);
                tracker.updateProcessStateHolderLocked(holder, this.info.packageName, this.info.uid, this.info.longVersionCode, this.processName);
                this.pkgList.put(this.info.packageName, holder);
                if (holder.state != this.baseProcessTracker) {
                    holder.state.makeActive();
                }
            }
        } else if (N != 1) {
            this.pkgList.clear();
            this.pkgList.put(this.info.packageName, new ProcessStats.ProcessStateHolder(this.info.longVersionCode));
        }
    }

    public String[] getPackageList() {
        int size = this.pkgList.size();
        if (size == 0) {
            return null;
        }
        String[] list = new String[size];
        for (int i = 0; i < this.pkgList.size(); ++i) {
            list[i] = this.pkgList.keyAt(i);
        }
        return list;
    }

    public List<VersionedPackage> getPackageListWithVersionCode() {
        int size = this.pkgList.size();
        if (size == 0) {
            return null;
        }
        ArrayList<VersionedPackage> list = new ArrayList<VersionedPackage>();
        for (int i = 0; i < this.pkgList.size(); ++i) {
            list.add(new VersionedPackage(this.pkgList.keyAt(i), this.pkgList.valueAt((int)i).appVersion));
        }
        return list;
    }

    WindowProcessController getWindowProcessController() {
        return this.mWindowProcessController;
    }

    void setCurrentSchedulingGroup(int curSchedGroup) {
        this.mCurSchedGroup = curSchedGroup;
        this.mWindowProcessController.setCurrentSchedulingGroup(curSchedGroup);
    }

    int getCurrentSchedulingGroup() {
        return this.mCurSchedGroup;
    }

    void setCurProcState(int curProcState) {
        this.mCurProcState = curProcState;
        this.mWindowProcessController.setCurrentProcState(this.mCurProcState);
    }

    int getCurProcState() {
        return this.mCurProcState;
    }

    void setCurRawProcState(int curRawProcState) {
        this.mCurRawProcState = curRawProcState;
    }

    int getCurRawProcState() {
        return this.mCurRawProcState;
    }

    void setReportedProcState(int repProcState) {
        this.mRepProcState = repProcState;
        for (int ipkg = this.pkgList.size() - 1; ipkg >= 0; --ipkg) {
            StatsLog.write(3, this.uid, this.processName, this.pkgList.keyAt(ipkg), ActivityManager.processStateAmToProto(this.mRepProcState), this.pkgList.valueAt((int)ipkg).appVersion);
        }
        this.mWindowProcessController.setReportedProcState(repProcState);
    }

    int getReportedProcState() {
        return this.mRepProcState;
    }

    void setCrashing(boolean crashing) {
        this.mCrashing = crashing;
        this.mWindowProcessController.setCrashing(crashing);
    }

    boolean isCrashing() {
        return this.mCrashing;
    }

    void setNotResponding(boolean notResponding) {
        this.mNotResponding = notResponding;
        this.mWindowProcessController.setNotResponding(notResponding);
    }

    boolean isNotResponding() {
        return this.mNotResponding;
    }

    void setPersistent(boolean persistent) {
        this.mPersistent = persistent;
        this.mWindowProcessController.setPersistent(persistent);
    }

    boolean isPersistent() {
        return this.mPersistent;
    }

    public void setRequiredAbi(String requiredAbi) {
        this.mRequiredAbi = requiredAbi;
        this.mWindowProcessController.setRequiredAbi(requiredAbi);
    }

    String getRequiredAbi() {
        return this.mRequiredAbi;
    }

    void setHasForegroundServices(boolean hasForegroundServices, int fgServiceTypes) {
        this.mHasForegroundServices = hasForegroundServices;
        this.mFgServiceTypes = fgServiceTypes;
        this.mWindowProcessController.setHasForegroundServices(hasForegroundServices);
    }

    boolean hasForegroundServices() {
        return this.mHasForegroundServices;
    }

    boolean hasLocationForegroundServices() {
        return this.mHasForegroundServices && (this.mFgServiceTypes & 8) != 0;
    }

    int getForegroundServiceTypes() {
        return this.mHasForegroundServices ? this.mFgServiceTypes : 0;
    }

    int getReportedForegroundServiceTypes() {
        return this.mRepFgServiceTypes;
    }

    void setReportedForegroundServiceTypes(int foregroundServiceTypes) {
        this.mRepFgServiceTypes = foregroundServiceTypes;
    }

    void setHasForegroundActivities(boolean hasForegroundActivities) {
        this.mHasForegroundActivities = hasForegroundActivities;
        this.mWindowProcessController.setHasForegroundActivities(hasForegroundActivities);
    }

    boolean hasForegroundActivities() {
        return this.mHasForegroundActivities;
    }

    void setHasClientActivities(boolean hasClientActivities) {
        this.mHasClientActivities = hasClientActivities;
        this.mWindowProcessController.setHasClientActivities(hasClientActivities);
    }

    boolean hasClientActivities() {
        return this.mHasClientActivities;
    }

    void setHasTopUi(boolean hasTopUi) {
        this.mHasTopUi = hasTopUi;
        this.mWindowProcessController.setHasTopUi(hasTopUi);
    }

    boolean hasTopUi() {
        return this.mHasTopUi;
    }

    void setHasOverlayUi(boolean hasOverlayUi) {
        this.mHasOverlayUi = hasOverlayUi;
        this.mWindowProcessController.setHasOverlayUi(hasOverlayUi);
    }

    boolean hasOverlayUi() {
        return this.mHasOverlayUi;
    }

    void setInteractionEventTime(long interactionEventTime) {
        this.mInteractionEventTime = interactionEventTime;
        this.mWindowProcessController.setInteractionEventTime(interactionEventTime);
    }

    long getInteractionEventTime() {
        return this.mInteractionEventTime;
    }

    void setFgInteractionTime(long fgInteractionTime) {
        this.mFgInteractionTime = fgInteractionTime;
        this.mWindowProcessController.setFgInteractionTime(fgInteractionTime);
    }

    long getFgInteractionTime() {
        return this.mFgInteractionTime;
    }

    void setWhenUnimportant(long whenUnimportant) {
        this.mWhenUnimportant = whenUnimportant;
        this.mWindowProcessController.setWhenUnimportant(whenUnimportant);
    }

    long getWhenUnimportant() {
        return this.mWhenUnimportant;
    }

    void setDebugging(boolean debugging) {
        this.mDebugging = debugging;
        this.mWindowProcessController.setDebugging(debugging);
    }

    boolean isDebugging() {
        return this.mDebugging;
    }

    void setUsingWrapper(boolean usingWrapper) {
        this.mUsingWrapper = usingWrapper;
        this.mWindowProcessController.setUsingWrapper(usingWrapper);
    }

    boolean isUsingWrapper() {
        return this.mUsingWrapper;
    }

    void addAllowBackgroundActivityStartsToken(Binder entity) {
        if (entity == null) {
            return;
        }
        this.mAllowBackgroundActivityStartsTokens.add(entity);
        this.mWindowProcessController.setAllowBackgroundActivityStarts(true);
    }

    void removeAllowBackgroundActivityStartsToken(Binder entity) {
        if (entity == null) {
            return;
        }
        this.mAllowBackgroundActivityStartsTokens.remove(entity);
        this.mWindowProcessController.setAllowBackgroundActivityStarts(!this.mAllowBackgroundActivityStartsTokens.isEmpty());
    }

    void addBoundClientUid(int clientUid) {
        this.mBoundClientUids.add(clientUid);
        this.mWindowProcessController.setBoundClientUids(this.mBoundClientUids);
    }

    void updateBoundClientUids() {
        if (this.services.isEmpty()) {
            this.clearBoundClientUids();
            return;
        }
        ArraySet<Integer> boundClientUids = new ArraySet<Integer>();
        int K = this.services.size();
        for (int j = 0; j < K; ++j) {
            ArrayMap<IBinder, ArrayList<ConnectionRecord>> conns = this.services.valueAt(j).getConnections();
            int N = conns.size();
            for (int conni = 0; conni < N; ++conni) {
                ArrayList<ConnectionRecord> c = conns.valueAt(conni);
                for (int i = 0; i < c.size(); ++i) {
                    boundClientUids.add(c.get((int)i).clientUid);
                }
            }
        }
        this.mBoundClientUids = boundClientUids;
        this.mWindowProcessController.setBoundClientUids(this.mBoundClientUids);
    }

    void addBoundClientUidsOfNewService(ServiceRecord sr) {
        if (sr == null) {
            return;
        }
        ArrayMap<IBinder, ArrayList<ConnectionRecord>> conns = sr.getConnections();
        for (int conni = conns.size() - 1; conni >= 0; --conni) {
            ArrayList<ConnectionRecord> c = conns.valueAt(conni);
            for (int i = 0; i < c.size(); ++i) {
                this.mBoundClientUids.add(c.get((int)i).clientUid);
            }
        }
        this.mWindowProcessController.setBoundClientUids(this.mBoundClientUids);
    }

    void clearBoundClientUids() {
        this.mBoundClientUids.clear();
        this.mWindowProcessController.setBoundClientUids(this.mBoundClientUids);
    }

    void setActiveInstrumentation(ActiveInstrumentation instr) {
        this.mInstr = instr;
        boolean isInstrumenting = instr != null;
        this.mWindowProcessController.setInstrumenting(isInstrumenting, isInstrumenting && instr.mHasBackgroundActivityStartsPermission);
    }

    ActiveInstrumentation getActiveInstrumentation() {
        return this.mInstr;
    }

    void setCurRawAdj(int curRawAdj) {
        this.mCurRawAdj = curRawAdj;
        this.mWindowProcessController.setPerceptible(curRawAdj <= 200);
    }

    int getCurRawAdj() {
        return this.mCurRawAdj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void clearProfilerIfNeeded() {
        block4: {
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mService.mProfileData.getProfileProc() != null && this.mService.mProfileData.getProfilerInfo() != null && this.mService.mProfileData.getProfileProc() == this) break block4;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mService.clearProfilerLocked();
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServiceConnectionActivities() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mService.mServices.updateServiceConnectionActivitiesLocked(this);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPendingUiClean(boolean pendingUiClean) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mPendingUiClean = pendingUiClean;
                this.mWindowProcessController.setPendingUiClean(pendingUiClean);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    boolean hasPendingUiClean() {
        return this.mPendingUiClean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPendingUiCleanAndForceProcessStateUpTo(int newState) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.setPendingUiClean(true);
                this.forceProcessStateUpTo(newState);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProcessInfo(boolean updateServiceConnectionActivities, boolean activityChange, boolean updateOomAdj) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (updateServiceConnectionActivities) {
                    this.mService.mServices.updateServiceConnectionActivitiesLocked(this);
                }
                this.mService.mProcessList.updateLruProcessLocked(this, activityChange, null);
                if (updateOomAdj) {
                    this.mService.updateOomAdjLocked("updateOomAdj_activityChange");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public long getCpuTime() {
        return this.mService.mProcessCpuTracker.getCpuTimeForPid(this.pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartActivity(int topProcessState, boolean setProfileProc, String packageName, long versionCode) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.waitingToKill = null;
                if (setProfileProc) {
                    this.mService.mProfileData.setProfileProc(this);
                }
                if (packageName != null) {
                    this.addPackage(packageName, versionCode, this.mService.mProcessStats);
                }
                this.updateProcessInfo(false, true, true);
                this.hasShownUi = true;
                this.setPendingUiClean(true);
                this.forceProcessStateUpTo(topProcessState);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var6_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appDied() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mService.appDiedLocked(this);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    public long getInputDispatchingTimeout() {
        return this.mWindowProcessController.getInputDispatchingTimeout();
    }

    public int getProcessClassEnum() {
        if (this.pid == ActivityManagerService.MY_PID) {
            return 3;
        }
        if (this.info == null) {
            return 0;
        }
        return (this.info.flags & 1) != 0 ? 2 : 1;
    }

    @VisibleForTesting
    boolean isSilentAnr() {
        return !this.getShowBackground() && !this.isInterestingForBackgroundTraces();
    }

    @VisibleForTesting
    List<ProcessRecord> getLruProcessList() {
        return this.mService.mProcessList.mLruProcesses;
    }

    @VisibleForTesting
    boolean isMonitorCpuUsage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void appNotResponding(String activityShortComponentName, ApplicationInfo aInfo, String parentShortComponentName, WindowProcessController parentProcess, boolean aboveSystem, String annotation) {
        StringBuilder info;
        block39: {
            long anrTime;
            SparseArray<Boolean> lastPids;
            ArrayList<Integer> firstPids;
            block40: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    firstPids = new ArrayList<Integer>(5);
                                    lastPids = new SparseArray<Boolean>(20);
                                    this.mWindowProcessController.appEarlyNotResponding(annotation, () -> this.kill("anr", true));
                                    anrTime = SystemClock.uptimeMillis();
                                    if (this.isMonitorCpuUsage()) {
                                        this.mService.updateCpuStatsNow();
                                    }
                                    ActivityManagerService activityManagerService = this.mService;
                                    // MONITORENTER : activityManagerService
                                    ActivityManagerService.boostPriorityForLockedSection();
                                    if (!this.mService.mAtmInternal.isShuttingDown()) break block34;
                                    Slog.i(TAG, "During shutdown skipping ANR: " + this + " " + annotation);
                                    // MONITOREXIT : activityManagerService
                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                    return;
                                }
                                if (!this.isNotResponding()) break block35;
                                Slog.i(TAG, "Skipping duplicate ANR: " + this + " " + annotation);
                                // MONITOREXIT : activityManagerService
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                return;
                            }
                            if (!this.isCrashing()) break block36;
                            Slog.i(TAG, "Crashing app skipping ANR: " + this + " " + annotation);
                            // MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            return;
                        }
                        if (!this.killedByAm) break block37;
                        Slog.i(TAG, "App already killed by AM skipping ANR: " + this + " " + annotation);
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (!this.killed) break block38;
                    Slog.i(TAG, "Skipping died app ANR: " + this + " " + annotation);
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                try {
                    this.setNotResponding(true);
                    EventLog.writeEvent(30008, this.userId, this.pid, this.processName, this.info.flags, annotation);
                    firstPids.add(this.pid);
                    if (!this.isSilentAnr()) {
                        int parentPid = this.pid;
                        if (parentProcess != null && parentProcess.getPid() > 0) {
                            parentPid = parentProcess.getPid();
                        }
                        if (parentPid != this.pid) {
                            firstPids.add(parentPid);
                        }
                        if (ActivityManagerService.MY_PID != this.pid && ActivityManagerService.MY_PID != parentPid) {
                            firstPids.add(ActivityManagerService.MY_PID);
                        }
                        for (int i = this.getLruProcessList().size() - 1; i >= 0; --i) {
                            int myPid;
                            ProcessRecord r = this.getLruProcessList().get(i);
                            if (r == null || r.thread == null || (myPid = r.pid) <= 0 || myPid == this.pid || myPid == parentPid || myPid == ActivityManagerService.MY_PID) continue;
                            if (r.isPersistent()) {
                                firstPids.add(myPid);
                                continue;
                            }
                            if (r.treatLikeActivity) {
                                firstPids.add(myPid);
                                continue;
                            }
                            lastPids.put(myPid, Boolean.TRUE);
                        }
                    }
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                info = new StringBuilder();
                info.setLength(0);
                info.append("ANR in ").append(this.processName);
                if (activityShortComponentName == null) break block40;
                info.append(" (").append(activityShortComponentName).append(")");
            }
            info.append("\n");
            info.append("PID: ").append(this.pid).append("\n");
            if (annotation != null) {
                info.append("Reason: ").append(annotation).append("\n");
            }
            if (parentShortComponentName != null && parentShortComponentName.equals(activityShortComponentName)) {
                info.append("Parent: ").append(parentShortComponentName).append("\n");
            }
            ProcessCpuTracker processCpuTracker = new ProcessCpuTracker(true);
            String[] nativeProcs = null;
            if (!this.isSilentAnr()) {
                nativeProcs = Watchdog.NATIVE_STACKS_OF_INTEREST;
            } else {
                for (int i = 0; i < Watchdog.NATIVE_STACKS_OF_INTEREST.length; ++i) {
                    if (!Watchdog.NATIVE_STACKS_OF_INTEREST[i].equals(this.processName)) continue;
                    nativeProcs = new String[]{this.processName};
                    break;
                }
            }
            int[] pids = nativeProcs == null ? null : Process.getPidsForCommands(nativeProcs);
            ArrayList<Integer> nativePids = null;
            if (pids != null) {
                nativePids = new ArrayList<Integer>(pids.length);
                for (int i : pids) {
                    nativePids.add(i);
                }
            }
            File tracesFile = ActivityManagerService.dumpStackTraces(firstPids, this.isSilentAnr() ? null : processCpuTracker, this.isSilentAnr() ? null : lastPids, nativePids);
            String cpuInfo = null;
            if (this.isMonitorCpuUsage()) {
                this.mService.updateCpuStatsNow();
                ProcessCpuTracker processCpuTracker2 = this.mService.mProcessCpuTracker;
                // MONITORENTER : processCpuTracker2
                cpuInfo = this.mService.mProcessCpuTracker.printCurrentState(anrTime);
                // MONITOREXIT : processCpuTracker2
                info.append(processCpuTracker.printCurrentLoad());
                info.append(cpuInfo);
            }
            info.append(processCpuTracker.printCurrentState(anrTime));
            Slog.e(TAG, info.toString());
            if (tracesFile == null) {
                Process.sendSignal(this.pid, 3);
            }
            StatsLog.write(79, this.uid, this.processName, activityShortComponentName == null ? "unknown" : activityShortComponentName, annotation, this.info != null ? (this.info.isInstantApp() ? 2 : 1) : 0, this.isInterestingToUserLocked() ? 2 : 1, this.getProcessClassEnum(), this.info != null ? this.info.packageName : "");
            ProcessRecord parentPr = parentProcess != null ? (ProcessRecord)parentProcess.mOwner : null;
            this.mService.addErrorToDropBox("anr", this, this.processName, activityShortComponentName, parentShortComponentName, parentPr, annotation, cpuInfo, tracesFile, null);
            if (this.mWindowProcessController.appNotResponding(info.toString(), () -> this.kill("anr", true), () -> {
                ActivityManagerService activityManagerService = this.mService;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        this.mService.mServices.scheduleServiceTimeoutLocked(this);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
            })) {
                return;
            }
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mService.mBatteryStatsService != null) {
                    this.mService.mBatteryStatsService.noteProcessAnr(this.processName, this.uid);
                }
                if (!this.isSilentAnr() || this.isDebugging()) break block39;
                this.kill("bg anr", true);
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.makeAppNotRespondingLocked(activityShortComponentName, annotation != null ? "ANR " + annotation : "ANR", info.toString());
        if (this.mService.mUiHandler != null) {
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = new AppNotRespondingDialog.Data(this, aInfo, aboveSystem);
            this.mService.mUiHandler.sendMessage(msg);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void makeAppNotRespondingLocked(String activity, String shortMsg, String longMsg) {
        this.setNotResponding(true);
        if (this.mService.mAppErrors != null) {
            this.notRespondingReport = this.mService.mAppErrors.generateProcessError(this, 2, activity, shortMsg, longMsg, null);
        }
        this.startAppProblemLocked();
        this.getWindowProcessController().stopFreezingActivities();
    }

    void startAppProblemLocked() {
        this.errorReportReceiver = null;
        for (int userId : this.mService.mUserController.getCurrentProfileIds()) {
            if (this.userId != userId) continue;
            this.errorReportReceiver = ApplicationErrorReport.getErrorReportReceiver(this.mService.mContext, this.info.packageName, this.info.flags);
        }
        this.mService.skipCurrentReceiverLocked(this);
    }

    private boolean isInterestingForBackgroundTraces() {
        if (this.pid == ActivityManagerService.MY_PID) {
            return true;
        }
        return this.isInterestingToUserLocked() || this.info != null && "com.android.systemui".equals(this.info.packageName) || this.hasTopUi() || this.hasOverlayUi();
    }

    private boolean getShowBackground() {
        return Settings.Secure.getInt(this.mService.mContext.getContentResolver(), "anr_show_background", 0) != 0;
    }

    final class PackageList {
        final ArrayMap<String, ProcessStats.ProcessStateHolder> mPkgList = new ArrayMap();

        PackageList() {
        }

        ProcessStats.ProcessStateHolder put(String key, ProcessStats.ProcessStateHolder value) {
            ProcessRecord.this.mWindowProcessController.addPackage(key);
            return this.mPkgList.put(key, value);
        }

        void clear() {
            this.mPkgList.clear();
            ProcessRecord.this.mWindowProcessController.clearPackageList();
        }

        int size() {
            return this.mPkgList.size();
        }

        String keyAt(int index) {
            return this.mPkgList.keyAt(index);
        }

        public ProcessStats.ProcessStateHolder valueAt(int index) {
            return this.mPkgList.valueAt(index);
        }

        ProcessStats.ProcessStateHolder get(String pkgName) {
            return this.mPkgList.get(pkgName);
        }

        boolean containsKey(Object key) {
            return this.mPkgList.containsKey(key);
        }
    }
}

