/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.DumpUtils;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ContentProviderRecord;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class ProviderMap {
    private static final String TAG = "ProviderMap";
    private static final boolean DBG = false;
    private final ActivityManagerService mAm;
    private final HashMap<String, ContentProviderRecord> mSingletonByName = new HashMap();
    private final HashMap<ComponentName, ContentProviderRecord> mSingletonByClass = new HashMap();
    private final SparseArray<HashMap<String, ContentProviderRecord>> mProvidersByNamePerUser = new SparseArray();
    private final SparseArray<HashMap<ComponentName, ContentProviderRecord>> mProvidersByClassPerUser = new SparseArray();

    ProviderMap(ActivityManagerService am) {
        this.mAm = am;
    }

    ContentProviderRecord getProviderByName(String name) {
        return this.getProviderByName(name, -1);
    }

    ContentProviderRecord getProviderByName(String name, int userId) {
        ContentProviderRecord record = this.mSingletonByName.get(name);
        if (record != null) {
            return record;
        }
        return this.getProvidersByName(userId).get(name);
    }

    ContentProviderRecord getProviderByClass(ComponentName name) {
        return this.getProviderByClass(name, -1);
    }

    ContentProviderRecord getProviderByClass(ComponentName name, int userId) {
        ContentProviderRecord record = this.mSingletonByClass.get(name);
        if (record != null) {
            return record;
        }
        return this.getProvidersByClass(userId).get(name);
    }

    void putProviderByName(String name, ContentProviderRecord record) {
        if (record.singleton) {
            this.mSingletonByName.put(name, record);
        } else {
            int userId = UserHandle.getUserId(record.appInfo.uid);
            this.getProvidersByName(userId).put(name, record);
        }
    }

    void putProviderByClass(ComponentName name, ContentProviderRecord record) {
        if (record.singleton) {
            this.mSingletonByClass.put(name, record);
        } else {
            int userId = UserHandle.getUserId(record.appInfo.uid);
            this.getProvidersByClass(userId).put(name, record);
        }
    }

    void removeProviderByName(String name, int userId) {
        if (this.mSingletonByName.containsKey(name)) {
            this.mSingletonByName.remove(name);
        } else {
            if (userId < 0) {
                throw new IllegalArgumentException("Bad user " + userId);
            }
            HashMap<String, ContentProviderRecord> map = this.getProvidersByName(userId);
            map.remove(name);
            if (map.size() == 0) {
                this.mProvidersByNamePerUser.remove(userId);
            }
        }
    }

    void removeProviderByClass(ComponentName name, int userId) {
        if (this.mSingletonByClass.containsKey(name)) {
            this.mSingletonByClass.remove(name);
        } else {
            if (userId < 0) {
                throw new IllegalArgumentException("Bad user " + userId);
            }
            HashMap<ComponentName, ContentProviderRecord> map = this.getProvidersByClass(userId);
            map.remove(name);
            if (map.size() == 0) {
                this.mProvidersByClassPerUser.remove(userId);
            }
        }
    }

    private HashMap<String, ContentProviderRecord> getProvidersByName(int userId) {
        if (userId < 0) {
            throw new IllegalArgumentException("Bad user " + userId);
        }
        HashMap<String, ContentProviderRecord> map = this.mProvidersByNamePerUser.get(userId);
        if (map == null) {
            HashMap<String, ContentProviderRecord> newMap = new HashMap<String, ContentProviderRecord>();
            this.mProvidersByNamePerUser.put(userId, newMap);
            return newMap;
        }
        return map;
    }

    HashMap<ComponentName, ContentProviderRecord> getProvidersByClass(int userId) {
        if (userId < 0) {
            throw new IllegalArgumentException("Bad user " + userId);
        }
        HashMap<ComponentName, ContentProviderRecord> map = this.mProvidersByClassPerUser.get(userId);
        if (map == null) {
            HashMap<ComponentName, ContentProviderRecord> newMap = new HashMap<ComponentName, ContentProviderRecord>();
            this.mProvidersByClassPerUser.put(userId, newMap);
            return newMap;
        }
        return map;
    }

    private boolean collectPackageProvidersLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, HashMap<ComponentName, ContentProviderRecord> providers, ArrayList<ContentProviderRecord> result) {
        boolean didSomething = false;
        for (ContentProviderRecord provider : providers.values()) {
            boolean sameComponent = packageName == null || provider.info.packageName.equals(packageName) && (filterByClasses == null || filterByClasses.contains(provider.name.getClassName()));
            if (!sameComponent || provider.proc != null && !evenPersistent && provider.proc.isPersistent()) continue;
            if (!doit) {
                return true;
            }
            didSomething = true;
            result.add(provider);
        }
        return didSomething;
    }

    boolean collectPackageProvidersLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId, ArrayList<ContentProviderRecord> result) {
        boolean didSomething = false;
        if (userId == -1 || userId == 0) {
            didSomething = this.collectPackageProvidersLocked(packageName, filterByClasses, doit, evenPersistent, this.mSingletonByClass, result);
        }
        if (!doit && didSomething) {
            return true;
        }
        if (userId == -1) {
            for (int i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
                if (!this.collectPackageProvidersLocked(packageName, filterByClasses, doit, evenPersistent, this.mProvidersByClassPerUser.valueAt(i), result)) continue;
                if (!doit) {
                    return true;
                }
                didSomething = true;
            }
        } else {
            HashMap<ComponentName, ContentProviderRecord> items = this.getProvidersByClass(userId);
            if (items != null) {
                didSomething |= this.collectPackageProvidersLocked(packageName, filterByClasses, doit, evenPersistent, items, result);
            }
        }
        return didSomething;
    }

    private boolean dumpProvidersByClassLocked(PrintWriter pw, boolean dumpAll, String dumpPackage, String header, boolean needSep, HashMap<ComponentName, ContentProviderRecord> map) {
        Iterator<Map.Entry<ComponentName, ContentProviderRecord>> it = map.entrySet().iterator();
        boolean written = false;
        while (it.hasNext()) {
            Map.Entry<ComponentName, ContentProviderRecord> e = it.next();
            ContentProviderRecord r = e.getValue();
            if (dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
            if (needSep) {
                pw.println("");
                needSep = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            written = true;
            pw.print("  * ");
            pw.println(r);
            r.dump(pw, "    ", dumpAll);
        }
        return written;
    }

    private boolean dumpProvidersByNameLocked(PrintWriter pw, String dumpPackage, String header, boolean needSep, HashMap<String, ContentProviderRecord> map) {
        Iterator<Map.Entry<String, ContentProviderRecord>> it = map.entrySet().iterator();
        boolean written = false;
        while (it.hasNext()) {
            Map.Entry<String, ContentProviderRecord> e = it.next();
            ContentProviderRecord r = e.getValue();
            if (dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
            if (needSep) {
                pw.println("");
                needSep = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            written = true;
            pw.print("  ");
            pw.print(e.getKey());
            pw.print(": ");
            pw.println(r.toShortString());
        }
        return written;
    }

    boolean dumpProvidersLocked(PrintWriter pw, boolean dumpAll, String dumpPackage) {
        int i;
        boolean needSep = false;
        if (this.mSingletonByClass.size() > 0) {
            needSep |= this.dumpProvidersByClassLocked(pw, dumpAll, dumpPackage, "  Published single-user content providers (by class):", needSep, this.mSingletonByClass);
        }
        for (i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
            HashMap<ComponentName, ContentProviderRecord> map = this.mProvidersByClassPerUser.valueAt(i);
            needSep |= this.dumpProvidersByClassLocked(pw, dumpAll, dumpPackage, "  Published user " + this.mProvidersByClassPerUser.keyAt(i) + " content providers (by class):", needSep, map);
        }
        if (dumpAll) {
            needSep |= this.dumpProvidersByNameLocked(pw, dumpPackage, "  Single-user authority to provider mappings:", needSep, this.mSingletonByName);
            for (i = 0; i < this.mProvidersByNamePerUser.size(); ++i) {
                needSep |= this.dumpProvidersByNameLocked(pw, dumpPackage, "  User " + this.mProvidersByNamePerUser.keyAt(i) + " authority to provider mappings:", needSep, this.mProvidersByNamePerUser.valueAt(i));
            }
        }
        return needSep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ContentProviderRecord> getProvidersForName(String name) {
        ArrayList<ContentProviderRecord> allProviders = new ArrayList<ContentProviderRecord>();
        ArrayList<ContentProviderRecord> ret = new ArrayList<ContentProviderRecord>();
        Predicate filter = DumpUtils.filterRecord(name);
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                allProviders.addAll(this.mSingletonByClass.values());
                for (int i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
                    allProviders.addAll(this.mProvidersByClassPerUser.valueAt(i).values());
                }
                CollectionUtils.addIf(allProviders, ret, filter);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var5_5
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        ret.sort(Comparator.comparing(ComponentName.WithComponentName::getComponentName));
        return ret;
    }

    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<ContentProviderRecord> providers = this.getProvidersForName(name);
        if (providers.size() <= 0) {
            return false;
        }
        boolean needSep = false;
        for (int i = 0; i < providers.size(); ++i) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            this.dumpProvider("", fd, pw, providers.get(i), args, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProvider(String prefix, FileDescriptor fd, PrintWriter pw, ContentProviderRecord r, String[] args, boolean dumpAll) {
        for (String s : args) {
            if (dumpAll || !s.contains("--proto")) continue;
            if (r.proc != null && r.proc.thread != null) {
                this.dumpToTransferPipe(null, fd, pw, r, args);
            }
            return;
        }
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                pw.print(prefix);
                pw.print("PROVIDER ");
                pw.print(r);
                pw.print(" pid=");
                if (r.proc != null) {
                    pw.println(r.proc.pid);
                } else {
                    pw.println("(not running)");
                }
                if (dumpAll) {
                    r.dump(pw, innerPrefix, true);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl27 : MonitorExitStatement: MONITOREXIT : var8_9
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (r.proc != null && r.proc.thread != null) {
            pw.println("    Client:");
            pw.flush();
            this.dumpToTransferPipe("      ", fd, pw, r, args);
        }
    }

    protected boolean dumpProviderProto(FileDescriptor fd, PrintWriter pw, String name, String[] args) {
        String[] newArgs = Arrays.copyOf(args, args.length + 1);
        newArgs[args.length] = "--proto";
        ArrayList<ContentProviderRecord> providers = this.getProvidersForName(name);
        if (providers.size() <= 0) {
            return false;
        }
        for (int i = 0; i < providers.size(); ++i) {
            ContentProviderRecord r = providers.get(i);
            if (r.proc == null || r.proc.thread == null) continue;
            this.dumpToTransferPipe(null, fd, pw, r, newArgs);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToTransferPipe(String prefix, FileDescriptor fd, PrintWriter pw, ContentProviderRecord r, String[] args) {
        try {
            TransferPipe tp = new TransferPipe();
            try {
                r.proc.thread.dumpProvider(tp.getWriteFd(), r.provider.asBinder(), args);
                tp.setBufferPrefix(prefix);
                tp.go(fd, 2000L);
            }
            finally {
                tp.kill();
            }
        }
        catch (IOException ex) {
            pw.println("      Failure while dumping the provider: " + ex);
        }
        catch (RemoteException ex) {
            pw.println("      Got a RemoteException while dumping the service");
        }
    }
}

