/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.SystemProperties;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;

public class SettingsToPropertiesMapper {
    private static final String TAG = "SettingsToPropertiesMapper";
    private static final String SYSTEM_PROPERTY_PREFIX = "persist.device_config.";
    private static final String RESET_PERFORMED_PROPERTY = "device_config.reset_performed";
    private static final String RESET_RECORD_FILE_PATH = "/data/server_configurable_flags/reset_flags";
    private static final String SYSTEM_PROPERTY_VALID_CHARACTERS_REGEX = "^[\\w\\.\\-@:]*$";
    private static final String SYSTEM_PROPERTY_INVALID_SUBSTRING = "..";
    private static final int SYSTEM_PROPERTY_MAX_LENGTH = 92;
    private static final String GLOBAL_SETTINGS_CATEGORY = "global_settings";
    @VisibleForTesting
    static final String[] sGlobalSettings = new String[]{"native_flags_health_check_enabled"};
    @VisibleForTesting
    static final String[] sDeviceConfigScopes = new String[]{"activity_manager_native_boot", "input_native_boot", "intelligence_content_suggestions", "media_native", "netd_native", "runtime_native", "runtime_native_boot"};
    private final String[] mGlobalSettings;
    private final String[] mDeviceConfigScopes;
    private final ContentResolver mContentResolver;

    @VisibleForTesting
    protected SettingsToPropertiesMapper(ContentResolver contentResolver, String[] globalSettings, String[] deviceConfigScopes) {
        this.mContentResolver = contentResolver;
        this.mGlobalSettings = globalSettings;
        this.mDeviceConfigScopes = deviceConfigScopes;
    }

    @VisibleForTesting
    void updatePropertiesFromSettings() {
        for (final String globalSetting : this.mGlobalSettings) {
            Uri settingUri = Settings.Global.getUriFor(globalSetting);
            final String propName = SettingsToPropertiesMapper.makePropertyName(GLOBAL_SETTINGS_CATEGORY, globalSetting);
            if (settingUri == null) {
                SettingsToPropertiesMapper.log("setting uri is null for globalSetting " + globalSetting);
                continue;
            }
            if (propName == null) {
                SettingsToPropertiesMapper.log("invalid prop name for globalSetting " + globalSetting);
                continue;
            }
            ContentObserver co = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange) {
                    SettingsToPropertiesMapper.this.updatePropertyFromSetting(globalSetting, propName);
                }
            };
            if (!SettingsToPropertiesMapper.isNativeFlagsResetPerformed()) {
                this.updatePropertyFromSetting(globalSetting, propName);
            }
            this.mContentResolver.registerContentObserver(settingUri, false, co);
        }
        for (String deviceConfigScope : this.mDeviceConfigScopes) {
            DeviceConfig.addOnPropertiesChangedListener(deviceConfigScope, AsyncTask.THREAD_POOL_EXECUTOR, properties -> {
                String scope = properties.getNamespace();
                for (String key : properties.getKeyset()) {
                    String propertyName = SettingsToPropertiesMapper.makePropertyName(scope, key);
                    if (propertyName == null) {
                        SettingsToPropertiesMapper.log("unable to construct system property for " + scope + "/" + key);
                        return;
                    }
                    this.setProperty(propertyName, properties.getString(key, null));
                }
            });
        }
    }

    public static SettingsToPropertiesMapper start(ContentResolver contentResolver) {
        SettingsToPropertiesMapper mapper = new SettingsToPropertiesMapper(contentResolver, sGlobalSettings, sDeviceConfigScopes);
        mapper.updatePropertiesFromSettings();
        return mapper;
    }

    public static boolean isNativeFlagsResetPerformed() {
        String value = SystemProperties.get(RESET_PERFORMED_PROPERTY);
        return "true".equals(value);
    }

    public static String[] getResetNativeCategories() {
        if (!SettingsToPropertiesMapper.isNativeFlagsResetPerformed()) {
            return new String[0];
        }
        String content = SettingsToPropertiesMapper.getResetFlagsFileContent();
        if (TextUtils.isEmpty(content)) {
            return new String[0];
        }
        String[] property_names = content.split(";");
        HashSet<String> categories = new HashSet<String>();
        for (String property_name : property_names) {
            String[] segments = property_name.split("\\.");
            if (segments.length < 3) {
                SettingsToPropertiesMapper.log("failed to extract category name from property " + property_name);
                continue;
            }
            categories.add(segments[2]);
        }
        return categories.toArray(new String[0]);
    }

    @VisibleForTesting
    static String makePropertyName(String categoryName, String flagName) {
        String propertyName = SYSTEM_PROPERTY_PREFIX + categoryName + "." + flagName;
        if (!propertyName.matches(SYSTEM_PROPERTY_VALID_CHARACTERS_REGEX) || propertyName.contains(SYSTEM_PROPERTY_INVALID_SUBSTRING)) {
            return null;
        }
        return propertyName;
    }

    private void setProperty(String key, String value) {
        if (value == null) {
            if (TextUtils.isEmpty(SystemProperties.get(key))) {
                return;
            }
            value = "";
        } else if (value.length() > 92) {
            SettingsToPropertiesMapper.log(value + " exceeds system property max length.");
            return;
        }
        try {
            SystemProperties.set(key, value);
        }
        catch (Exception e) {
            SettingsToPropertiesMapper.log("Unable to set property " + key + " value '" + value + "'", e);
        }
    }

    private static void log(String msg, Exception e) {
        if (Build.IS_DEBUGGABLE) {
            Slog.wtf(TAG, msg, e);
        } else {
            Slog.e(TAG, msg, e);
        }
    }

    private static void log(String msg) {
        if (Build.IS_DEBUGGABLE) {
            Slog.wtf(TAG, msg);
        } else {
            Slog.e(TAG, msg);
        }
    }

    @VisibleForTesting
    static String getResetFlagsFileContent() {
        String content = null;
        try {
            File reset_flag_file = new File(RESET_RECORD_FILE_PATH);
            BufferedReader br = new BufferedReader(new FileReader(reset_flag_file));
            content = br.readLine();
            br.close();
        }
        catch (IOException ioe) {
            SettingsToPropertiesMapper.log("failed to read file /data/server_configurable_flags/reset_flags", ioe);
        }
        return content;
    }

    @VisibleForTesting
    void updatePropertyFromSetting(String settingName, String propName) {
        String settingValue = Settings.Global.getString(this.mContentResolver, settingName);
        this.setProperty(propName, settingValue);
    }
}

