/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.os.UserManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.TextView;
import com.android.internal.annotations.GuardedBy;
import com.android.server.am.ActivityManagerService;

class UserSwitchingDialog
extends AlertDialog
implements ViewTreeObserver.OnWindowShownListener {
    private static final String TAG = "ActivityManagerUserSwitchingDialog";
    private static final int WINDOW_SHOWN_TIMEOUT_MS = 3000;
    private final ActivityManagerService mService;
    private final int mUserId;
    private static final int MSG_START_USER = 1;
    @GuardedBy(value={"this"})
    private boolean mStartedUser;
    protected final UserInfo mOldUser;
    protected final UserInfo mNewUser;
    private final String mSwitchingFromSystemUserMessage;
    private final String mSwitchingToSystemUserMessage;
    protected final Context mContext;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UserSwitchingDialog.this.startUser();
                }
            }
        }
    };

    public UserSwitchingDialog(ActivityManagerService service, Context context, UserInfo oldUser, UserInfo newUser, boolean aboveSystem, String switchingFromSystemUserMessage, String switchingToSystemUserMessage) {
        super(context);
        this.mContext = context;
        this.mService = service;
        this.mUserId = newUser.id;
        this.mOldUser = oldUser;
        this.mNewUser = newUser;
        this.mSwitchingFromSystemUserMessage = switchingFromSystemUserMessage;
        this.mSwitchingToSystemUserMessage = switchingToSystemUserMessage;
        this.inflateContent();
        if (aboveSystem) {
            this.getWindow().setType(2010);
        }
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.privateFlags = 272;
        this.getWindow().setAttributes(attrs);
    }

    void inflateContent() {
        this.setCancelable(false);
        Resources res = this.getContext().getResources();
        View view = LayoutInflater.from(this.getContext()).inflate(17367332, null);
        String viewMessage = null;
        if (UserManager.isSplitSystemUser() && this.mNewUser.id == 0) {
            viewMessage = res.getString(17041182, this.mOldUser.name);
        } else if (UserManager.isDeviceInDemoMode(this.mContext)) {
            viewMessage = this.mOldUser.isDemo() ? res.getString(17039854) : res.getString(17039855);
        } else {
            if (this.mOldUser.id == 0) {
                viewMessage = this.mSwitchingFromSystemUserMessage;
            } else if (this.mNewUser.id == 0) {
                viewMessage = this.mSwitchingToSystemUserMessage;
            }
            if (viewMessage == null) {
                viewMessage = res.getString(17041185, this.mNewUser.name);
            }
        }
        ((TextView)view.findViewById(16908299)).setText(viewMessage);
        this.setView(view);
    }

    @Override
    public void show() {
        super.show();
        View decorView = this.getWindow().getDecorView();
        if (decorView != null) {
            decorView.getViewTreeObserver().addOnWindowShownListener(this);
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 3000L);
    }

    @Override
    public void onWindowShown() {
        this.startUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startUser() {
        UserSwitchingDialog userSwitchingDialog = this;
        synchronized (userSwitchingDialog) {
            if (!this.mStartedUser) {
                this.mService.mUserController.startUserInForeground(this.mUserId);
                this.dismiss();
                this.mStartedUser = true;
                View decorView = this.getWindow().getDecorView();
                if (decorView != null) {
                    decorView.getViewTreeObserver().removeOnWindowShownListener(this);
                }
                this.mHandler.removeMessages(1);
            }
        }
    }
}

