/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appbinding;

import android.app.AppGlobals;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.ServiceInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import com.android.server.am.PersistentConnection;
import com.android.server.appbinding.AppBindingConstants;
import com.android.server.appbinding.finders.AppServiceFinder;
import com.android.server.appbinding.finders.CarrierMessagingClientServiceFinder;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.function.Consumer;

public class AppBindingService
extends Binder {
    public static final String TAG = "AppBindingService";
    public static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final Injector mInjector;
    private final Context mContext;
    private final Handler mHandler;
    private final IPackageManager mIPackageManager;
    @GuardedBy(value={"mLock"})
    private AppBindingConstants mConstants;
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mRunningUsers = new SparseBooleanArray(2);
    @GuardedBy(value={"mLock"})
    private final ArrayList<AppServiceFinder> mApps = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final ArrayList<AppServiceConnection> mConnections = new ArrayList();
    private final ContentObserver mSettingsObserver = new ContentObserver(null){

        @Override
        public void onChange(boolean selfChange) {
            AppBindingService.this.refreshConstants();
        }
    };
    @VisibleForTesting
    final BroadcastReceiver mPackageUserMonitor = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String packageName;
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                Slog.w(AppBindingService.TAG, "Intent broadcast does not contain user handle: " + intent);
                return;
            }
            String action = intent.getAction();
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                AppBindingService.this.onUserRemoved(userId);
                return;
            }
            Uri intentUri = intent.getData();
            String string2 = packageName = intentUri != null ? intentUri.getSchemeSpecificPart() : null;
            if (packageName == null) {
                Slog.w(AppBindingService.TAG, "Intent broadcast does not contain package name: " + intent);
                return;
            }
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            switch (action) {
                case "android.intent.action.PACKAGE_ADDED": {
                    if (!replacing) break;
                    AppBindingService.this.handlePackageAddedReplacing(packageName, userId);
                }
            }
        }
    };

    private AppBindingService(Injector injector, Context context) {
        this.mInjector = injector;
        this.mContext = context;
        this.mIPackageManager = injector.getIPackageManager();
        this.mHandler = BackgroundThread.getHandler();
        this.mApps.add(new CarrierMessagingClientServiceFinder(context, this::onAppChanged, this.mHandler));
        this.mConstants = AppBindingConstants.initializeFromString("");
    }

    private void forAllAppsLocked(Consumer<AppServiceFinder> consumer) {
        for (int i = 0; i < this.mApps.size(); ++i) {
            consumer.accept(this.mApps.get(i));
        }
    }

    private void onBootPhase(int phase) {
        switch (phase) {
            case 550: {
                this.onPhaseActivityManagerReady();
                break;
            }
            case 600: {
                this.onPhaseThirdPartyAppsCanStart();
            }
        }
    }

    private void onPhaseActivityManagerReady() {
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mPackageUserMonitor, UserHandle.ALL, packageFilter, null, this.mHandler);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(this.mPackageUserMonitor, UserHandle.ALL, userFilter, null, this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("app_binding_constants"), false, this.mSettingsObserver);
        this.refreshConstants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConstants() {
        String newSetting = this.mInjector.getGlobalSettingString(this.mContext.getContentResolver(), "app_binding_constants");
        Object object = this.mLock;
        synchronized (object) {
            if (TextUtils.equals(this.mConstants.sourceSettings, newSetting)) {
                return;
            }
            Slog.i(TAG, "Updating constants with: " + newSetting);
            this.mConstants = AppBindingConstants.initializeFromString(newSetting);
            this.rebindAllLocked("settings update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPhaseThirdPartyAppsCanStart() {
        Object object = this.mLock;
        synchronized (object) {
            this.forAllAppsLocked(AppServiceFinder::startMonitoring);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunningUsers.append(userId, true);
            this.bindServicesLocked(userId, null, "user start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.bindServicesLocked(userId, null, "user unlock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unbindServicesLocked(userId, null, "user stop");
            this.mRunningUsers.delete(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.forAllAppsLocked(app -> app.onUserRemoved(userId));
            this.mRunningUsers.delete(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAppChanged(AppServiceFinder finder, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            String reason = finder.getAppDescription() + " changed";
            this.unbindServicesLocked(userId, finder, reason);
            this.bindServicesLocked(userId, finder, reason);
        }
    }

    private AppServiceFinder findFinderLocked(int userId, String packageName) {
        for (int i = 0; i < this.mApps.size(); ++i) {
            AppServiceFinder app = this.mApps.get(i);
            if (!packageName.equals(app.getTargetPackage(userId))) continue;
            return app;
        }
        return null;
    }

    private AppServiceConnection findConnectionLock(int userId, AppServiceFinder target) {
        for (int i = 0; i < this.mConnections.size(); ++i) {
            AppServiceConnection conn = this.mConnections.get(i);
            if (conn.getUserId() != userId || conn.getFinder() != target) continue;
            return conn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageAddedReplacing(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            AppServiceFinder finder = this.findFinderLocked(userId, packageName);
            if (finder != null) {
                this.unbindServicesLocked(userId, finder, "package update");
                this.bindServicesLocked(userId, finder, "package update");
            }
        }
    }

    private void rebindAllLocked(String reason) {
        for (int i = 0; i < this.mRunningUsers.size(); ++i) {
            if (!this.mRunningUsers.valueAt(i)) continue;
            int userId = this.mRunningUsers.keyAt(i);
            this.unbindServicesLocked(userId, null, reason);
            this.bindServicesLocked(userId, null, reason);
        }
    }

    private void bindServicesLocked(int userId, AppServiceFinder target, String reasonForLog) {
        for (int i = 0; i < this.mApps.size(); ++i) {
            ServiceInfo service;
            AppServiceFinder app = this.mApps.get(i);
            if (target != null && target != app) continue;
            AppServiceConnection existingConn = this.findConnectionLock(userId, app);
            if (existingConn != null) {
                this.unbindServicesLocked(userId, target, reasonForLog);
            }
            if ((service = app.findService(userId, this.mIPackageManager, this.mConstants)) == null) continue;
            AppServiceConnection conn = new AppServiceConnection(this.mContext, userId, this.mConstants, this.mHandler, app, service.getComponentName());
            this.mConnections.add(conn);
            conn.bind();
        }
    }

    private void unbindServicesLocked(int userId, AppServiceFinder target, String reasonForLog) {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            AppServiceConnection conn = this.mConnections.get(i);
            if (conn.getUserId() != userId || target != null && conn.getFinder() != target) continue;
            this.mConnections.remove(i);
            conn.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        if (args.length > 0 && "-s".equals(args[0])) {
            this.dumpSimple(pw);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int i;
            this.mConstants.dump("  ", pw);
            pw.println();
            pw.print("  Running users:");
            for (i = 0; i < this.mRunningUsers.size(); ++i) {
                if (!this.mRunningUsers.valueAt(i)) continue;
                pw.print(" ");
                pw.print(this.mRunningUsers.keyAt(i));
            }
            pw.println();
            pw.println("  Connections:");
            for (i = 0; i < this.mConnections.size(); ++i) {
                AppServiceConnection conn = this.mConnections.get(i);
                pw.print("    App type: ");
                pw.print(conn.getFinder().getAppDescription());
                pw.println();
                conn.dump("      ", pw);
            }
            if (this.mConnections.size() == 0) {
                pw.println("    None:");
            }
            pw.println();
            pw.println("  Finders:");
            this.forAllAppsLocked(app -> app.dump("    ", pw));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSimple(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                AppServiceConnection conn = this.mConnections.get(i);
                pw.print("conn,");
                pw.print(conn.getFinder().getAppDescription());
                pw.print(",");
                pw.print(conn.getUserId());
                pw.print(",");
                pw.print(conn.getComponentName().getPackageName());
                pw.print(",");
                pw.print(conn.getComponentName().getClassName());
                pw.print(",");
                pw.print(conn.isBound() ? "bound" : "not-bound");
                pw.print(",");
                pw.print(conn.isConnected() ? "connected" : "not-connected");
                pw.print(",#con=");
                pw.print(conn.getNumConnected());
                pw.print(",#dis=");
                pw.print(conn.getNumDisconnected());
                pw.print(",#died=");
                pw.print(conn.getNumBindingDied());
                pw.print(",backoff=");
                pw.print(conn.getNextBackoffMs());
                pw.println();
            }
            this.forAllAppsLocked(app -> app.dumpSimple(pw));
        }
    }

    AppBindingConstants getConstantsForTest() {
        return this.mConstants;
    }

    private static class AppServiceConnection
    extends PersistentConnection<IInterface> {
        private final AppBindingConstants mConstants;
        private final AppServiceFinder mFinder;

        AppServiceConnection(Context context, int userId, AppBindingConstants constants, Handler handler, AppServiceFinder finder, ComponentName componentName) {
            super(AppBindingService.TAG, context, handler, userId, componentName, constants.SERVICE_RECONNECT_BACKOFF_SEC, constants.SERVICE_RECONNECT_BACKOFF_INCREASE, constants.SERVICE_RECONNECT_MAX_BACKOFF_SEC, constants.SERVICE_STABLE_CONNECTION_THRESHOLD_SEC);
            this.mFinder = finder;
            this.mConstants = constants;
        }

        @Override
        protected int getBindFlags() {
            return this.mFinder.getBindFlags(this.mConstants);
        }

        @Override
        protected IInterface asInterface(IBinder obj) {
            return this.mFinder.asInterface(obj);
        }

        public AppServiceFinder getFinder() {
            return this.mFinder;
        }
    }

    public static class Lifecycle
    extends SystemService {
        final AppBindingService mService;

        public Lifecycle(Context context) {
            this(context, new Injector());
        }

        Lifecycle(Context context, Injector injector) {
            super(context);
            this.mService = new AppBindingService(injector, context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("app_binding", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.onBootPhase(phase);
        }

        @Override
        public void onStartUser(int userHandle) {
            this.mService.onStartUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userId) {
            this.mService.onUnlockUser(userId);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.onStopUser(userHandle);
        }
    }

    static class Injector {
        Injector() {
        }

        public IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        public String getGlobalSettingString(ContentResolver resolver, String key) {
            return Settings.Global.getString(resolver, key);
        }
    }
}

