/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appbinding.finders;

import android.content.Context;
import android.content.pm.IPackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.appbinding.AppBindingConstants;
import com.android.server.appbinding.AppBindingUtils;
import java.io.PrintWriter;
import java.util.function.BiConsumer;

public abstract class AppServiceFinder<TServiceType, TServiceInterfaceType extends IInterface> {
    protected static final String TAG = "AppBindingService";
    protected static final boolean DEBUG = false;
    protected final Context mContext;
    protected final BiConsumer<AppServiceFinder, Integer> mListener;
    protected final Handler mHandler;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseArray<String> mTargetPackages = new SparseArray(4);
    @GuardedBy(value={"mLock"})
    private final SparseArray<ServiceInfo> mTargetServices = new SparseArray(4);
    @GuardedBy(value={"mLock"})
    private final SparseArray<String> mLastMessages = new SparseArray(4);

    public AppServiceFinder(Context context, BiConsumer<AppServiceFinder, Integer> listener, Handler callbackHandler) {
        this.mContext = context;
        this.mListener = listener;
        this.mHandler = callbackHandler;
    }

    protected boolean isEnabled(AppBindingConstants constants) {
        return true;
    }

    public abstract String getAppDescription();

    public void startMonitoring() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTargetPackages.delete(userId);
            this.mTargetServices.delete(userId);
            this.mLastMessages.delete(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceInfo findService(int userId, IPackageManager ipm, AppBindingConstants constants) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTargetPackages.put(userId, null);
            this.mTargetServices.put(userId, null);
            this.mLastMessages.put(userId, null);
            if (!this.isEnabled(constants)) {
                String message = "feature disabled";
                this.mLastMessages.put(userId, "feature disabled");
                Slog.i(TAG, this.getAppDescription() + " " + "feature disabled");
                return null;
            }
            String targetPackage = this.getTargetPackage(userId);
            if (targetPackage == null) {
                String message = "Target package not found";
                this.mLastMessages.put(userId, "Target package not found");
                Slog.w(TAG, this.getAppDescription() + " u" + userId + " " + "Target package not found");
                return null;
            }
            this.mTargetPackages.put(userId, targetPackage);
            StringBuilder errorMessage = new StringBuilder();
            ServiceInfo service = AppBindingUtils.findService(targetPackage, userId, this.getServiceAction(), this.getServicePermission(), this.getServiceClass(), ipm, errorMessage);
            if (service == null) {
                String message = errorMessage.toString();
                this.mLastMessages.put(userId, message);
                return null;
            }
            String error = this.validateService(service);
            if (error != null) {
                this.mLastMessages.put(userId, error);
                Log.e(TAG, error);
                return null;
            }
            String message = "Valid service found";
            this.mLastMessages.put(userId, "Valid service found");
            this.mTargetServices.put(userId, service);
            return service;
        }
    }

    protected abstract Class<TServiceType> getServiceClass();

    public abstract TServiceInterfaceType asInterface(IBinder var1);

    public abstract String getTargetPackage(int var1);

    protected abstract String getServiceAction();

    protected abstract String getServicePermission();

    protected String validateService(ServiceInfo service) {
        return null;
    }

    public abstract int getBindFlags(AppBindingConstants var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("App type: ");
        pw.print(this.getAppDescription());
        pw.println();
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mTargetPackages.size(); ++i) {
                int userId = this.mTargetPackages.keyAt(i);
                pw.print(prefix);
                pw.print("  User: ");
                pw.print(userId);
                pw.println();
                pw.print(prefix);
                pw.print("    Package: ");
                pw.print(this.mTargetPackages.get(userId));
                pw.println();
                pw.print(prefix);
                pw.print("    Service: ");
                pw.print(this.mTargetServices.get(userId));
                pw.println();
                pw.print(prefix);
                pw.print("    Message: ");
                pw.print(this.mLastMessages.get(userId));
                pw.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSimple(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mTargetPackages.size(); ++i) {
                int userId = this.mTargetPackages.keyAt(i);
                pw.print("finder,");
                pw.print(this.getAppDescription());
                pw.print(",");
                pw.print(userId);
                pw.print(",");
                pw.print(this.mTargetPackages.get(userId));
                pw.print(",");
                pw.print(this.mTargetServices.get(userId));
                pw.print(",");
                pw.print(this.mLastMessages.get(userId));
                pw.println();
            }
        }
    }
}

