/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appbinding.finders;

import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleManager;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.UserHandle;
import android.service.carrier.CarrierMessagingClientService;
import android.service.carrier.ICarrierMessagingClientService;
import android.text.TextUtils;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.CollectionUtils;
import com.android.server.appbinding.AppBindingConstants;
import com.android.server.appbinding.finders.AppServiceFinder;
import java.util.function.BiConsumer;

public class CarrierMessagingClientServiceFinder
extends AppServiceFinder<CarrierMessagingClientService, ICarrierMessagingClientService> {
    private final RoleManager mRoleManager;
    private final OnRoleHoldersChangedListener mRoleHolderChangedListener = (role, user) -> {
        if ("android.app.role.SMS".equals(role)) {
            this.mListener.accept(this, user.getIdentifier());
        }
    };

    public CarrierMessagingClientServiceFinder(Context context, BiConsumer<AppServiceFinder, Integer> listener, Handler callbackHandler) {
        super(context, listener, callbackHandler);
        this.mRoleManager = context.getSystemService(RoleManager.class);
    }

    @Override
    protected boolean isEnabled(AppBindingConstants constants) {
        return constants.SMS_SERVICE_ENABLED && this.mContext.getResources().getBoolean(17891560);
    }

    @Override
    public String getAppDescription() {
        return "[Default SMS app]";
    }

    @Override
    protected Class<CarrierMessagingClientService> getServiceClass() {
        return CarrierMessagingClientService.class;
    }

    @Override
    public ICarrierMessagingClientService asInterface(IBinder obj) {
        return ICarrierMessagingClientService.Stub.asInterface(obj);
    }

    @Override
    protected String getServiceAction() {
        return "android.telephony.action.CARRIER_MESSAGING_CLIENT_SERVICE";
    }

    @Override
    protected String getServicePermission() {
        return "android.permission.BIND_CARRIER_MESSAGING_CLIENT_SERVICE";
    }

    @Override
    public String getTargetPackage(int userId) {
        String ret = CollectionUtils.firstOrNull(this.mRoleManager.getRoleHoldersAsUser("android.app.role.SMS", UserHandle.of(userId)));
        return ret;
    }

    @Override
    public void startMonitoring() {
        this.mRoleManager.addOnRoleHoldersChangedListenerAsUser(BackgroundThread.getExecutor(), this.mRoleHolderChangedListener, UserHandle.ALL);
    }

    @Override
    protected String validateService(ServiceInfo service) {
        String packageName = service.packageName;
        String process = service.processName;
        if (process == null || TextUtils.equals(packageName, process)) {
            return "Service must not run on the main process";
        }
        return null;
    }

    @Override
    public int getBindFlags(AppBindingConstants constants) {
        return constants.SMS_APP_BIND_FLAGS;
    }
}

