/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appop;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.Message;
import android.os.RemoteCallback;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.LongSparseArray;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.AtomicDirectory;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class HistoricalRegistry {
    private static final boolean DEBUG = false;
    private static final boolean KEEP_WTF_LOG = Build.IS_DEBUGGABLE;
    private static final String LOG_TAG = HistoricalRegistry.class.getSimpleName();
    private static final String PARAMETER_DELIMITER = ",";
    private static final String PARAMETER_ASSIGNMENT = "=";
    @GuardedBy(value={"mLock"})
    private LinkedList<AppOpsManager.HistoricalOps> mPendingWrites = new LinkedList();
    private final Object mOnDiskLock = new Object();
    private final Object mInMemoryLock;
    private static final int MSG_WRITE_PENDING_HISTORY = 1;
    private static final int DEFAULT_MODE = 1;
    private static final long DEFAULT_SNAPSHOT_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(15L);
    private static final long DEFAULT_COMPRESSION_STEP = 10L;
    private static final String HISTORY_FILE_SUFFIX = ".xml";
    @GuardedBy(value={"mInMemoryLock"})
    private final int mMode = 0;
    @GuardedBy(value={"mInMemoryLock"})
    private long mBaseSnapshotInterval = DEFAULT_SNAPSHOT_INTERVAL_MILLIS;
    @GuardedBy(value={"mInMemoryLock"})
    private long mIntervalCompressionMultiplier = 10L;
    @GuardedBy(value={"mInMemoryLock"})
    private AppOpsManager.HistoricalOps mCurrentHistoricalOps;
    @GuardedBy(value={"mInMemoryLock"})
    private long mNextPersistDueTimeMillis;
    @GuardedBy(value={"mInMemoryLock"})
    private long mPendingHistoryOffsetMillis;
    @GuardedBy(value={"mOnDiskLock"})
    private Persistence mPersistence;

    HistoricalRegistry(Object lock) {
        this.mInMemoryLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady(final ContentResolver resolver) {
        Uri uri = Settings.Global.getUriFor("appop_history_parameters");
        resolver.registerContentObserver(uri, false, new ContentObserver(FgThread.getHandler()){

            @Override
            public void onChange(boolean selfChange) {
                HistoricalRegistry.this.updateParametersFromSetting(resolver);
            }
        });
        this.updateParametersFromSetting(resolver);
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
            }
        }
    }

    private boolean isPersistenceInitializedMLocked() {
        return this.mPersistence != null;
    }

    private void updateParametersFromSetting(ContentResolver resolver) {
        String[] parameters;
        String setting = Settings.Global.getString(resolver, "appop_history_parameters");
        if (setting == null) {
            return;
        }
        String modeValue = null;
        String baseSnapshotIntervalValue = null;
        String intervalMultiplierValue = null;
        block12: for (String parameter : parameters = setting.split(PARAMETER_DELIMITER)) {
            String key;
            String[] parts = parameter.split(PARAMETER_ASSIGNMENT);
            if (parts.length != 2) continue;
            switch (key = parts[0].trim()) {
                case "mode": {
                    modeValue = parts[1].trim();
                    continue block12;
                }
                case "baseIntervalMillis": {
                    baseSnapshotIntervalValue = parts[1].trim();
                    continue block12;
                }
                case "intervalMultiplier": {
                    intervalMultiplierValue = parts[1].trim();
                    continue block12;
                }
                default: {
                    Slog.w(LOG_TAG, "Unknown parameter: " + parameter);
                }
            }
        }
        if (modeValue != null && baseSnapshotIntervalValue != null && intervalMultiplierValue != null) {
            try {
                int mode = AppOpsManager.parseHistoricalMode(modeValue);
                long baseSnapshotInterval = Long.parseLong(baseSnapshotIntervalValue);
                int intervalCompressionMultiplier = Integer.parseInt(intervalMultiplierValue);
                this.setHistoryParameters(mode, baseSnapshotInterval, intervalCompressionMultiplier);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Slog.w(LOG_TAG, "Bad value forappop_history_parameters=" + setting + " resetting!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String prefix, PrintWriter pw, int filterUid, String filterPackage, int filterOp) {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                pw.println();
                pw.print(prefix);
                pw.print("History:");
                pw.print("  mode=");
                pw.println(AppOpsManager.historicalModeToString(0));
                StringDumpVisitor visitor = new StringDumpVisitor(prefix + "  ", pw, filterUid, filterPackage, filterOp);
                long nowMillis = System.currentTimeMillis();
                AppOpsManager.HistoricalOps currentOps = this.getUpdatedPendingHistoricalOpsMLocked(nowMillis);
                HistoricalRegistry.makeRelativeToEpochStart(currentOps, nowMillis);
                currentOps.accept(visitor);
                if (this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    return;
                }
                List<AppOpsManager.HistoricalOps> ops = this.mPersistence.readHistoryDLocked();
                if (ops != null) {
                    long remainingToFillBatchMillis = this.mNextPersistDueTimeMillis - nowMillis - this.mBaseSnapshotInterval;
                    int opCount = ops.size();
                    for (int i = 0; i < opCount; ++i) {
                        AppOpsManager.HistoricalOps op = ops.get(i);
                        op.offsetBeginAndEndTime(remainingToFillBatchMillis);
                        HistoricalRegistry.makeRelativeToEpochStart(op, nowMillis);
                        op.accept(visitor);
                    }
                } else {
                    pw.println("  Empty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMode() {
        Object object = this.mInMemoryLock;
        synchronized (object) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getHistoricalOpsFromDiskRaw(int uid, String packageName, String[] opNames, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                if (!this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    callback.sendResult(new Bundle());
                    return;
                }
                AppOpsManager.HistoricalOps result = new AppOpsManager.HistoricalOps(beginTimeMillis, endTimeMillis);
                this.mPersistence.collectHistoricalOpsDLocked(result, uid, packageName, opNames, beginTimeMillis, endTimeMillis, flags);
                Bundle payload = new Bundle();
                payload.putParcelable("historical_ops", result);
                callback.sendResult(payload);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getHistoricalOps(int uid, String packageName, String[] opNames, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) {
        long currentTimeMillis = System.currentTimeMillis();
        if (endTimeMillis == Long.MAX_VALUE) {
            endTimeMillis = currentTimeMillis;
        }
        long inMemoryAdjBeginTimeMillis = Math.max(currentTimeMillis - endTimeMillis, 0L);
        long inMemoryAdjEndTimeMillis = Math.max(currentTimeMillis - beginTimeMillis, 0L);
        AppOpsManager.HistoricalOps result = new AppOpsManager.HistoricalOps(inMemoryAdjBeginTimeMillis, inMemoryAdjEndTimeMillis);
        Object object = this.mOnDiskLock;
        synchronized (object) {
            boolean collectOpsFromDisk;
            ArrayList<AppOpsManager.HistoricalOps> pendingWrites;
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                if (!this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    callback.sendResult(new Bundle());
                    return;
                }
                AppOpsManager.HistoricalOps currentOps = this.getUpdatedPendingHistoricalOpsMLocked(currentTimeMillis);
                if (inMemoryAdjBeginTimeMillis < currentOps.getEndTimeMillis() && inMemoryAdjEndTimeMillis > currentOps.getBeginTimeMillis()) {
                    AppOpsManager.HistoricalOps currentOpsCopy = new AppOpsManager.HistoricalOps(currentOps);
                    currentOpsCopy.filter(uid, packageName, opNames, inMemoryAdjBeginTimeMillis, inMemoryAdjEndTimeMillis);
                    result.merge(currentOpsCopy);
                }
                pendingWrites = new ArrayList<AppOpsManager.HistoricalOps>(this.mPendingWrites);
                this.mPendingWrites.clear();
                collectOpsFromDisk = inMemoryAdjEndTimeMillis > currentOps.getEndTimeMillis();
            }
            if (collectOpsFromDisk) {
                this.persistPendingHistory(pendingWrites);
                long onDiskAndInMemoryOffsetMillis = currentTimeMillis - this.mNextPersistDueTimeMillis + this.mBaseSnapshotInterval;
                long onDiskAdjBeginTimeMillis = Math.max(inMemoryAdjBeginTimeMillis - onDiskAndInMemoryOffsetMillis, 0L);
                long onDiskAdjEndTimeMillis = Math.max(inMemoryAdjEndTimeMillis - onDiskAndInMemoryOffsetMillis, 0L);
                this.mPersistence.collectHistoricalOpsDLocked(result, uid, packageName, opNames, onDiskAdjBeginTimeMillis, onDiskAdjEndTimeMillis, flags);
            }
            result.setBeginAndEndTime(beginTimeMillis, endTimeMillis);
            Bundle payload = new Bundle();
            payload.putParcelable("historical_ops", result);
            callback.sendResult(payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementOpAccessedCount(int op, int uid, String packageName, int uidState, int flags) {
        Object object = this.mInMemoryLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementOpRejected(int op, int uid, String packageName, int uidState, int flags) {
        Object object = this.mInMemoryLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseOpAccessDuration(int op, int uid, String packageName, int uidState, int flags, long increment) {
        Object object = this.mInMemoryLock;
        synchronized (object) {
        }
    }

    void setHistoryParameters(int mode, long baseSnapshotInterval, long intervalCompressionMultiplier) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offsetHistory(long offsetMillis) {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                if (!this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    return;
                }
                List<AppOpsManager.HistoricalOps> history = this.mPersistence.readHistoryDLocked();
                this.clearHistory();
                if (history != null) {
                    int historySize = history.size();
                    for (int i = 0; i < historySize; ++i) {
                        AppOpsManager.HistoricalOps ops = history.get(i);
                        ops.offsetBeginAndEndTime(offsetMillis);
                    }
                    if (offsetMillis < 0L) {
                        this.pruneFutureOps(history);
                    }
                    this.mPersistence.persistHistoricalOpsDLocked(history);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHistoricalOps(AppOpsManager.HistoricalOps ops) {
        ArrayList<AppOpsManager.HistoricalOps> pendingWrites;
        Object object = this.mInMemoryLock;
        synchronized (object) {
            if (!this.isPersistenceInitializedMLocked()) {
                Slog.e(LOG_TAG, "Interaction before persistence initialized");
                return;
            }
            ops.offsetBeginAndEndTime(this.mBaseSnapshotInterval);
            this.mPendingWrites.offerFirst(ops);
            pendingWrites = new ArrayList<AppOpsManager.HistoricalOps>(this.mPendingWrites);
            this.mPendingWrites.clear();
        }
        this.persistPendingHistory(pendingWrites);
    }

    private void resampleHistoryOnDiskInMemoryDMLocked(long offsetMillis) {
        this.mPersistence = new Persistence(this.mBaseSnapshotInterval, this.mIntervalCompressionMultiplier);
        this.offsetHistory(offsetMillis);
    }

    void resetHistoryParameters() {
        if (!this.isPersistenceInitializedMLocked()) {
            Slog.e(LOG_TAG, "Interaction before persistence initialized");
            return;
        }
        this.setHistoryParameters(1, DEFAULT_SNAPSHOT_INTERVAL_MILLIS, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearHistory(int uid, String packageName) {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                if (!this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    return;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearHistory() {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                if (!this.isPersistenceInitializedMLocked()) {
                    Slog.e(LOG_TAG, "Interaction before persistence initialized");
                    return;
                }
                this.clearHistoryOnDiskDLocked();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistoryOnDiskDLocked() {
        BackgroundThread.getHandler().removeMessages(1);
        Object object = this.mInMemoryLock;
        synchronized (object) {
            this.mCurrentHistoricalOps = null;
            this.mNextPersistDueTimeMillis = System.currentTimeMillis();
            this.mPendingWrites.clear();
        }
        Persistence.clearHistoryDLocked();
    }

    private AppOpsManager.HistoricalOps getUpdatedPendingHistoricalOpsMLocked(long now) {
        if (this.mCurrentHistoricalOps != null) {
            long remainingTimeMillis = this.mNextPersistDueTimeMillis - now;
            if (remainingTimeMillis > this.mBaseSnapshotInterval) {
                this.mPendingHistoryOffsetMillis = remainingTimeMillis - this.mBaseSnapshotInterval;
            }
            long elapsedTimeMillis = this.mBaseSnapshotInterval - remainingTimeMillis;
            this.mCurrentHistoricalOps.setEndTime(elapsedTimeMillis);
            if (remainingTimeMillis > 0L) {
                return this.mCurrentHistoricalOps;
            }
            if (this.mCurrentHistoricalOps.isEmpty()) {
                this.mCurrentHistoricalOps.setBeginAndEndTime(0L, 0L);
                this.mNextPersistDueTimeMillis = now + this.mBaseSnapshotInterval;
                return this.mCurrentHistoricalOps;
            }
            this.mCurrentHistoricalOps.offsetBeginAndEndTime(this.mBaseSnapshotInterval);
            this.mCurrentHistoricalOps.setBeginTime(this.mCurrentHistoricalOps.getEndTimeMillis() - this.mBaseSnapshotInterval);
            long overdueTimeMillis = Math.abs(remainingTimeMillis);
            this.mCurrentHistoricalOps.offsetBeginAndEndTime(overdueTimeMillis);
            this.schedulePersistHistoricalOpsMLocked(this.mCurrentHistoricalOps);
        }
        this.mCurrentHistoricalOps = new AppOpsManager.HistoricalOps(0L, 0L);
        this.mNextPersistDueTimeMillis = now + this.mBaseSnapshotInterval;
        return this.mCurrentHistoricalOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistPendingHistory() {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            ArrayList<AppOpsManager.HistoricalOps> pendingWrites;
            Object object2 = this.mInMemoryLock;
            synchronized (object2) {
                pendingWrites = new ArrayList<AppOpsManager.HistoricalOps>(this.mPendingWrites);
                this.mPendingWrites.clear();
                if (this.mPendingHistoryOffsetMillis != 0L) {
                    this.resampleHistoryOnDiskInMemoryDMLocked(this.mPendingHistoryOffsetMillis);
                    this.mPendingHistoryOffsetMillis = 0L;
                }
            }
            this.persistPendingHistory(pendingWrites);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistPendingHistory(List<AppOpsManager.HistoricalOps> pendingWrites) {
        Object object = this.mOnDiskLock;
        synchronized (object) {
            BackgroundThread.getHandler().removeMessages(1);
            if (pendingWrites.isEmpty()) {
                return;
            }
            int opCount = pendingWrites.size();
            for (int i = 0; i < opCount; ++i) {
                AppOpsManager.HistoricalOps current = pendingWrites.get(i);
                if (i <= 0) continue;
                AppOpsManager.HistoricalOps previous = pendingWrites.get(i - 1);
                current.offsetBeginAndEndTime(previous.getBeginTimeMillis());
            }
            this.mPersistence.persistHistoricalOpsDLocked(pendingWrites);
        }
    }

    private void schedulePersistHistoricalOpsMLocked(AppOpsManager.HistoricalOps ops) {
        Message message = PooledLambda.obtainMessage(HistoricalRegistry::persistPendingHistory, this);
        message.what = 1;
        BackgroundThread.getHandler().sendMessage(message);
        this.mPendingWrites.offerFirst(ops);
    }

    private static void makeRelativeToEpochStart(AppOpsManager.HistoricalOps ops, long nowMillis) {
        ops.setBeginAndEndTime(nowMillis - ops.getEndTimeMillis(), nowMillis - ops.getBeginTimeMillis());
    }

    private void pruneFutureOps(List<AppOpsManager.HistoricalOps> ops) {
        int opCount = ops.size();
        for (int i = opCount - 1; i >= 0; --i) {
            AppOpsManager.HistoricalOps op = ops.get(i);
            if (op.getEndTimeMillis() <= this.mBaseSnapshotInterval) {
                ops.remove(i);
                continue;
            }
            if (op.getBeginTimeMillis() >= this.mBaseSnapshotInterval) continue;
            double filterScale = (double)(op.getEndTimeMillis() - this.mBaseSnapshotInterval) / (double)op.getDurationMillis();
            Persistence.spliceFromBeginning(op, filterScale);
        }
    }

    private static void wtf(String message, Throwable t, File storage) {
        block17: {
            Slog.wtf(LOG_TAG, message, t);
            if (KEEP_WTF_LOG) {
                try {
                    File file = new File(new File(Environment.getDataSystemDirectory(), "appops"), "wtf" + TimeUtils.formatForLogging(System.currentTimeMillis()));
                    if (!file.createNewFile()) break block17;
                    try (PrintWriter writer = new PrintWriter(file);){
                        if (t != null) {
                            writer.append('\n').append(t.toString());
                        }
                        writer.append('\n').append(Debug.getCallers(10));
                        if (storage != null) {
                            writer.append("\nfiles: " + Arrays.toString(storage.listFiles()));
                        } else {
                            writer.append("\nfiles: none");
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private final class StringDumpVisitor
    implements AppOpsManager.HistoricalOpsVisitor {
        private final long mNow = System.currentTimeMillis();
        private final SimpleDateFormat mDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private final Date mDate = new Date();
        private final String mOpsPrefix;
        private final String mUidPrefix;
        private final String mPackagePrefix;
        private final String mEntryPrefix;
        private final String mUidStatePrefix;
        private final PrintWriter mWriter;
        private final int mFilterUid;
        private final String mFilterPackage;
        private final int mFilterOp;

        StringDumpVisitor(String prefix, PrintWriter writer, int filterUid, String filterPackage, int filterOp) {
            this.mOpsPrefix = prefix + "  ";
            this.mUidPrefix = this.mOpsPrefix + "  ";
            this.mPackagePrefix = this.mUidPrefix + "  ";
            this.mEntryPrefix = this.mPackagePrefix + "  ";
            this.mUidStatePrefix = this.mEntryPrefix + "  ";
            this.mWriter = writer;
            this.mFilterUid = filterUid;
            this.mFilterPackage = filterPackage;
            this.mFilterOp = filterOp;
        }

        @Override
        public void visitHistoricalOps(AppOpsManager.HistoricalOps ops) {
            this.mWriter.println();
            this.mWriter.print(this.mOpsPrefix);
            this.mWriter.println("snapshot:");
            this.mWriter.print(this.mUidPrefix);
            this.mWriter.print("begin = ");
            this.mDate.setTime(ops.getBeginTimeMillis());
            this.mWriter.print(this.mDateFormatter.format(this.mDate));
            this.mWriter.print("  (");
            TimeUtils.formatDuration(ops.getBeginTimeMillis() - this.mNow, this.mWriter);
            this.mWriter.println(")");
            this.mWriter.print(this.mUidPrefix);
            this.mWriter.print("end = ");
            this.mDate.setTime(ops.getEndTimeMillis());
            this.mWriter.print(this.mDateFormatter.format(this.mDate));
            this.mWriter.print("  (");
            TimeUtils.formatDuration(ops.getEndTimeMillis() - this.mNow, this.mWriter);
            this.mWriter.println(")");
        }

        @Override
        public void visitHistoricalUidOps(AppOpsManager.HistoricalUidOps ops) {
            if (this.mFilterUid != -1 && this.mFilterUid != ops.getUid()) {
                return;
            }
            this.mWriter.println();
            this.mWriter.print(this.mUidPrefix);
            this.mWriter.print("Uid ");
            UserHandle.formatUid(this.mWriter, ops.getUid());
            this.mWriter.println(":");
        }

        @Override
        public void visitHistoricalPackageOps(AppOpsManager.HistoricalPackageOps ops) {
            if (this.mFilterPackage != null && !this.mFilterPackage.equals(ops.getPackageName())) {
                return;
            }
            this.mWriter.print(this.mPackagePrefix);
            this.mWriter.print("Package ");
            this.mWriter.print(ops.getPackageName());
            this.mWriter.println(":");
        }

        @Override
        public void visitHistoricalOp(AppOpsManager.HistoricalOp ops) {
            if (this.mFilterOp != -1 && this.mFilterOp != ops.getOpCode()) {
                return;
            }
            this.mWriter.print(this.mEntryPrefix);
            this.mWriter.print(AppOpsManager.opToName(ops.getOpCode()));
            this.mWriter.println(":");
            LongSparseArray<Object> keys = ops.collectKeys();
            int keyCount = keys.size();
            for (int i = 0; i < keyCount; ++i) {
                long accessDuration;
                long rejectCount;
                long key = keys.keyAt(i);
                int uidState = AppOpsManager.extractUidStateFromKey(key);
                int flags = AppOpsManager.extractFlagsFromKey(key);
                boolean printedUidState = false;
                long accessCount = ops.getAccessCount(uidState, uidState, flags);
                if (accessCount > 0L) {
                    if (!printedUidState) {
                        this.mWriter.print(this.mUidStatePrefix);
                        this.mWriter.print(AppOpsManager.keyToString(key));
                        this.mWriter.print(" = ");
                        printedUidState = true;
                    }
                    this.mWriter.print("access=");
                    this.mWriter.print(accessCount);
                }
                if ((rejectCount = ops.getRejectCount(uidState, uidState, flags)) > 0L) {
                    if (!printedUidState) {
                        this.mWriter.print(this.mUidStatePrefix);
                        this.mWriter.print(AppOpsManager.keyToString(key));
                        this.mWriter.print(" = ");
                        printedUidState = true;
                    } else {
                        this.mWriter.print(", ");
                    }
                    this.mWriter.print("reject=");
                    this.mWriter.print(rejectCount);
                }
                if ((accessDuration = ops.getAccessDuration(uidState, uidState, flags)) > 0L) {
                    if (!printedUidState) {
                        this.mWriter.print(this.mUidStatePrefix);
                        this.mWriter.print(AppOpsManager.keyToString(key));
                        this.mWriter.print(" = ");
                        printedUidState = true;
                    } else {
                        this.mWriter.print(", ");
                    }
                    this.mWriter.print("duration=");
                    TimeUtils.formatDuration(accessDuration, this.mWriter);
                }
                if (!printedUidState) continue;
                this.mWriter.println("");
            }
        }
    }

    private static class HistoricalFilesInvariant {
        private final List<File> mBeginFiles = new ArrayList<File>();

        private HistoricalFilesInvariant() {
        }

        public void startTracking(File folder) {
            File[] files = folder.listFiles();
            if (files != null) {
                Collections.addAll(this.mBeginFiles, files);
            }
        }

        public void stopTracking(File folder) {
            ArrayList<File> endFiles = new ArrayList<File>();
            File[] files = folder.listFiles();
            if (files != null) {
                Collections.addAll(endFiles, files);
            }
            long beginOldestFileOffsetMillis = HistoricalFilesInvariant.getOldestFileOffsetMillis(this.mBeginFiles);
            long endOldestFileOffsetMillis = HistoricalFilesInvariant.getOldestFileOffsetMillis(endFiles);
            if (endOldestFileOffsetMillis < beginOldestFileOffsetMillis) {
                String message = "History loss detected!\nold files: " + this.mBeginFiles;
                HistoricalRegistry.wtf(message, null, folder);
                throw new IllegalStateException(message);
            }
        }

        private static long getOldestFileOffsetMillis(List<File> files) {
            if (files.isEmpty()) {
                return 0L;
            }
            String longestName = files.get(0).getName();
            int fileCount = files.size();
            for (int i = 1; i < fileCount; ++i) {
                File file = files.get(i);
                if (file.getName().length() <= longestName.length()) continue;
                longestName = file.getName();
            }
            return Long.parseLong(longestName.replace(HistoricalRegistry.HISTORY_FILE_SUFFIX, ""));
        }
    }

    private static final class Persistence {
        private static final boolean DEBUG = false;
        private static final String LOG_TAG = Persistence.class.getSimpleName();
        private static final String TAG_HISTORY = "history";
        private static final String TAG_OPS = "ops";
        private static final String TAG_UID = "uid";
        private static final String TAG_PACKAGE = "pkg";
        private static final String TAG_OP = "op";
        private static final String TAG_STATE = "st";
        private static final String ATTR_VERSION = "ver";
        private static final String ATTR_NAME = "na";
        private static final String ATTR_ACCESS_COUNT = "ac";
        private static final String ATTR_REJECT_COUNT = "rc";
        private static final String ATTR_ACCESS_DURATION = "du";
        private static final String ATTR_BEGIN_TIME = "beg";
        private static final String ATTR_END_TIME = "end";
        private static final String ATTR_OVERFLOW = "ov";
        private static final int CURRENT_VERSION = 2;
        private final long mBaseSnapshotInterval;
        private final long mIntervalCompressionMultiplier;
        private static final AtomicDirectory sHistoricalAppOpsDir = new AtomicDirectory(new File(new File(Environment.getDataSystemDirectory(), "appops"), "history"));

        Persistence(long baseSnapshotInterval, long intervalCompressionMultiplier) {
            this.mBaseSnapshotInterval = baseSnapshotInterval;
            this.mIntervalCompressionMultiplier = intervalCompressionMultiplier;
        }

        private File generateFile(File baseDir, int depth) {
            long globalBeginMillis = this.computeGlobalIntervalBeginMillis(depth);
            return new File(baseDir, Long.toString(globalBeginMillis) + HistoricalRegistry.HISTORY_FILE_SUFFIX);
        }

        void clearHistoryDLocked(int uid, String packageName) {
            List<AppOpsManager.HistoricalOps> historicalOps = this.readHistoryDLocked();
            if (historicalOps == null) {
                return;
            }
            for (int index = 0; index < historicalOps.size(); ++index) {
                historicalOps.get(index).clearHistory(uid, packageName);
            }
            Persistence.clearHistoryDLocked();
            this.persistHistoricalOpsDLocked(historicalOps);
        }

        static void clearHistoryDLocked() {
            sHistoricalAppOpsDir.delete();
        }

        void persistHistoricalOpsDLocked(List<AppOpsManager.HistoricalOps> ops) {
            try {
                File newBaseDir = sHistoricalAppOpsDir.startWrite();
                File oldBaseDir = sHistoricalAppOpsDir.getBackupDirectory();
                Set<String> oldFileNames = Persistence.getHistoricalFileNames(oldBaseDir);
                this.handlePersistHistoricalOpsRecursiveDLocked(newBaseDir, oldBaseDir, ops, oldFileNames, 0);
                sHistoricalAppOpsDir.finishWrite();
            }
            catch (Throwable t) {
                HistoricalRegistry.wtf("Failed to write historical app ops, restoring backup", t, null);
                sHistoricalAppOpsDir.failWrite();
            }
        }

        List<AppOpsManager.HistoricalOps> readHistoryRawDLocked() {
            return this.collectHistoricalOpsBaseDLocked(-1, null, null, 0L, Long.MAX_VALUE, 31);
        }

        List<AppOpsManager.HistoricalOps> readHistoryDLocked() {
            List<AppOpsManager.HistoricalOps> result = this.readHistoryRawDLocked();
            if (result != null) {
                int opCount = result.size();
                for (int i = 0; i < opCount; ++i) {
                    result.get(i).offsetBeginAndEndTime(this.mBaseSnapshotInterval);
                }
            }
            return result;
        }

        long getLastPersistTimeMillisDLocked() {
            File baseDir = null;
            try {
                baseDir = sHistoricalAppOpsDir.startRead();
                File[] files = baseDir.listFiles();
                if (files != null && files.length > 0) {
                    File shortestFile = null;
                    for (File candidate : files) {
                        String candidateName = candidate.getName();
                        if (!candidateName.endsWith(HistoricalRegistry.HISTORY_FILE_SUFFIX)) continue;
                        if (shortestFile == null) {
                            shortestFile = candidate;
                            continue;
                        }
                        if (candidateName.length() >= shortestFile.getName().length()) continue;
                        shortestFile = candidate;
                    }
                    if (shortestFile == null) {
                        return 0L;
                    }
                    String shortestNameNoExtension = shortestFile.getName().replace(HistoricalRegistry.HISTORY_FILE_SUFFIX, "");
                    try {
                        return Long.parseLong(shortestNameNoExtension);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                sHistoricalAppOpsDir.finishRead();
            }
            catch (Throwable e) {
                HistoricalRegistry.wtf("Error reading historical app ops. Deleting history.", e, baseDir);
                sHistoricalAppOpsDir.delete();
            }
            return 0L;
        }

        private void collectHistoricalOpsDLocked(AppOpsManager.HistoricalOps currentOps, int filterUid, String filterPackageName, String[] filterOpNames, long filterBeingMillis, long filterEndMillis, int filterFlags) {
            LinkedList<AppOpsManager.HistoricalOps> readOps = this.collectHistoricalOpsBaseDLocked(filterUid, filterPackageName, filterOpNames, filterBeingMillis, filterEndMillis, filterFlags);
            if (readOps != null) {
                int readCount = readOps.size();
                for (int i = 0; i < readCount; ++i) {
                    AppOpsManager.HistoricalOps readOp = (AppOpsManager.HistoricalOps)readOps.get(i);
                    currentOps.merge(readOp);
                }
            }
        }

        private LinkedList<AppOpsManager.HistoricalOps> collectHistoricalOpsBaseDLocked(int filterUid, String filterPackageName, String[] filterOpNames, long filterBeginTimeMillis, long filterEndTimeMillis, int filterFlags) {
            File baseDir = null;
            try {
                baseDir = sHistoricalAppOpsDir.startRead();
                Set<String> historyFiles = Persistence.getHistoricalFileNames(baseDir);
                long[] globalContentOffsetMillis = new long[]{0L};
                LinkedList<AppOpsManager.HistoricalOps> ops = this.collectHistoricalOpsRecursiveDLocked(baseDir, filterUid, filterPackageName, filterOpNames, filterBeginTimeMillis, filterEndTimeMillis, filterFlags, globalContentOffsetMillis, null, 0, historyFiles);
                sHistoricalAppOpsDir.finishRead();
                return ops;
            }
            catch (Throwable t) {
                HistoricalRegistry.wtf("Error reading historical app ops. Deleting history.", t, baseDir);
                sHistoricalAppOpsDir.delete();
                return null;
            }
        }

        private LinkedList<AppOpsManager.HistoricalOps> collectHistoricalOpsRecursiveDLocked(File baseDir, int filterUid, String filterPackageName, String[] filterOpNames, long filterBeginTimeMillis, long filterEndTimeMillis, int filterFlags, long[] globalContentOffsetMillis, LinkedList<AppOpsManager.HistoricalOps> outOps, int depth, Set<String> historyFiles) throws IOException, XmlPullParserException {
            int i;
            int opCount;
            long currentIntervalEndMillis;
            long previousIntervalEndMillis = (long)Math.pow(this.mIntervalCompressionMultiplier, depth) * this.mBaseSnapshotInterval;
            List<AppOpsManager.HistoricalOps> readOps = this.readHistoricalOpsLocked(baseDir, previousIntervalEndMillis, currentIntervalEndMillis = (long)Math.pow(this.mIntervalCompressionMultiplier, depth + 1) * this.mBaseSnapshotInterval, filterUid, filterPackageName, filterOpNames, filterBeginTimeMillis = Math.max(filterBeginTimeMillis - previousIntervalEndMillis, 0L), filterEndTimeMillis -= previousIntervalEndMillis, filterFlags, globalContentOffsetMillis, depth, historyFiles);
            if (readOps != null && readOps.isEmpty()) {
                return outOps;
            }
            if ((outOps = this.collectHistoricalOpsRecursiveDLocked(baseDir, filterUid, filterPackageName, filterOpNames, filterBeginTimeMillis, filterEndTimeMillis, filterFlags, globalContentOffsetMillis, outOps, depth + 1, historyFiles)) != null) {
                opCount = outOps.size();
                for (i = 0; i < opCount; ++i) {
                    AppOpsManager.HistoricalOps collectedOp = outOps.get(i);
                    collectedOp.offsetBeginAndEndTime(currentIntervalEndMillis);
                }
            }
            if (readOps != null) {
                if (outOps == null) {
                    outOps = new LinkedList();
                }
                opCount = readOps.size();
                for (i = opCount - 1; i >= 0; --i) {
                    outOps.offerFirst(readOps.get(i));
                }
            }
            return outOps;
        }

        private void handlePersistHistoricalOpsRecursiveDLocked(File newBaseDir, File oldBaseDir, List<AppOpsManager.HistoricalOps> passedOps, Set<String> oldFileNames, int depth) throws IOException, XmlPullParserException {
            int existingOpCount;
            long previousIntervalEndMillis = (long)Math.pow(this.mIntervalCompressionMultiplier, depth) * this.mBaseSnapshotInterval;
            long currentIntervalEndMillis = (long)Math.pow(this.mIntervalCompressionMultiplier, depth + 1) * this.mBaseSnapshotInterval;
            if (passedOps == null || passedOps.isEmpty()) {
                if (!oldFileNames.isEmpty()) {
                    File oldFile = this.generateFile(oldBaseDir, depth);
                    if (oldFileNames.remove(oldFile.getName())) {
                        File newFile = this.generateFile(newBaseDir, depth);
                        Files.createLink(newFile.toPath(), oldFile.toPath());
                    }
                    this.handlePersistHistoricalOpsRecursiveDLocked(newBaseDir, oldBaseDir, passedOps, oldFileNames, depth + 1);
                }
                return;
            }
            int passedOpCount = passedOps.size();
            for (int i = 0; i < passedOpCount; ++i) {
                AppOpsManager.HistoricalOps passedOp = passedOps.get(i);
                passedOp.offsetBeginAndEndTime(-previousIntervalEndMillis);
            }
            List<AppOpsManager.HistoricalOps> existingOps = this.readHistoricalOpsLocked(oldBaseDir, previousIntervalEndMillis, currentIntervalEndMillis, -1, null, null, Long.MIN_VALUE, Long.MAX_VALUE, 31, null, depth, null);
            if (existingOps != null && (existingOpCount = existingOps.size()) > 0) {
                long elapsedTimeMillis = passedOps.get(passedOps.size() - 1).getEndTimeMillis();
                for (int i = 0; i < existingOpCount; ++i) {
                    AppOpsManager.HistoricalOps existingOp = existingOps.get(i);
                    existingOp.offsetBeginAndEndTime(elapsedTimeMillis);
                }
            }
            long slotDurationMillis = previousIntervalEndMillis;
            LinkedList<AppOpsManager.HistoricalOps> allOps = new LinkedList<AppOpsManager.HistoricalOps>(passedOps);
            if (existingOps != null) {
                allOps.addAll(existingOps);
            }
            ArrayList<AppOpsManager.HistoricalOps> persistedOps = null;
            ArrayList<AppOpsManager.HistoricalOps> overflowedOps = null;
            long intervalOverflowMillis = 0L;
            int opCount = allOps.size();
            for (int i = 0; i < opCount; ++i) {
                AppOpsManager.HistoricalOps overflowedOp;
                AppOpsManager.HistoricalOps persistedOp;
                AppOpsManager.HistoricalOps op = (AppOpsManager.HistoricalOps)allOps.get(i);
                if (op.getEndTimeMillis() <= currentIntervalEndMillis) {
                    persistedOp = op;
                    overflowedOp = null;
                } else if (op.getBeginTimeMillis() < currentIntervalEndMillis) {
                    persistedOp = op;
                    intervalOverflowMillis = op.getEndTimeMillis() - currentIntervalEndMillis;
                    if (intervalOverflowMillis > previousIntervalEndMillis) {
                        double splitScale = (double)intervalOverflowMillis / (double)op.getDurationMillis();
                        overflowedOp = Persistence.spliceFromEnd(op, splitScale);
                        intervalOverflowMillis = op.getEndTimeMillis() - currentIntervalEndMillis;
                    } else {
                        overflowedOp = null;
                    }
                } else {
                    persistedOp = null;
                    overflowedOp = op;
                }
                if (persistedOp != null) {
                    if (persistedOps == null) {
                        persistedOps = new ArrayList<AppOpsManager.HistoricalOps>();
                    }
                    persistedOps.add(persistedOp);
                }
                if (overflowedOp == null) continue;
                if (overflowedOps == null) {
                    overflowedOps = new ArrayList<AppOpsManager.HistoricalOps>();
                }
                overflowedOps.add(overflowedOp);
            }
            File newFile = this.generateFile(newBaseDir, depth);
            oldFileNames.remove(newFile.getName());
            if (persistedOps != null) {
                Persistence.normalizeSnapshotForSlotDuration(persistedOps, slotDurationMillis);
                this.writeHistoricalOpsDLocked(persistedOps, intervalOverflowMillis, newFile);
            }
            this.handlePersistHistoricalOpsRecursiveDLocked(newBaseDir, oldBaseDir, overflowedOps, oldFileNames, depth + 1);
        }

        private List<AppOpsManager.HistoricalOps> readHistoricalOpsLocked(File baseDir, long intervalBeginMillis, long intervalEndMillis, int filterUid, String filterPackageName, String[] filterOpNames, long filterBeginTimeMillis, long filterEndTimeMillis, int filterFlags, long[] cumulativeOverflowMillis, int depth, Set<String> historyFiles) throws IOException, XmlPullParserException {
            File file = this.generateFile(baseDir, depth);
            if (historyFiles != null) {
                historyFiles.remove(file.getName());
            }
            if (filterBeginTimeMillis >= filterEndTimeMillis || filterEndTimeMillis < intervalBeginMillis) {
                return Collections.emptyList();
            }
            if (filterBeginTimeMillis >= intervalEndMillis + (intervalEndMillis - intervalBeginMillis) / this.mIntervalCompressionMultiplier + (cumulativeOverflowMillis != null ? cumulativeOverflowMillis[0] : 0L) || !file.exists()) {
                if (historyFiles == null || historyFiles.isEmpty()) {
                    return Collections.emptyList();
                }
                return null;
            }
            return this.readHistoricalOpsLocked(file, filterUid, filterPackageName, filterOpNames, filterBeginTimeMillis, filterEndTimeMillis, filterFlags, cumulativeOverflowMillis);
        }

        private List<AppOpsManager.HistoricalOps> readHistoricalOpsLocked(File file, int filterUid, String filterPackageName, String[] filterOpNames, long filterBeginTimeMillis, long filterEndTimeMillis, int filterFlags, long[] cumulativeOverflowMillis) throws IOException, XmlPullParserException {
            ArrayList<AppOpsManager.HistoricalOps> allOps = null;
            try (FileInputStream stream = new FileInputStream(file);){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, StandardCharsets.UTF_8.name());
                XmlUtils.beginDocument(parser, TAG_HISTORY);
                int version = XmlUtils.readIntAttribute(parser, ATTR_VERSION);
                if (version < 2) {
                    throw new IllegalStateException("Dropping unsupported history version 1 for file:" + file);
                }
                long overflowMillis = XmlUtils.readLongAttribute(parser, ATTR_OVERFLOW, 0L);
                int depth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, depth)) {
                    AppOpsManager.HistoricalOps ops;
                    if (!TAG_OPS.equals(parser.getName()) || (ops = this.readeHistoricalOpsDLocked(parser, filterUid, filterPackageName, filterOpNames, filterBeginTimeMillis, filterEndTimeMillis, filterFlags, cumulativeOverflowMillis)) == null) continue;
                    if (ops.isEmpty()) {
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (allOps == null) {
                        allOps = new ArrayList<AppOpsManager.HistoricalOps>();
                    }
                    allOps.add(ops);
                }
                if (cumulativeOverflowMillis != null) {
                    cumulativeOverflowMillis[0] = cumulativeOverflowMillis[0] + overflowMillis;
                }
            }
            catch (FileNotFoundException e) {
                Slog.i(LOG_TAG, "No history file: " + file.getName());
                return Collections.emptyList();
            }
            return allOps;
        }

        private AppOpsManager.HistoricalOps readeHistoricalOpsDLocked(XmlPullParser parser, int filterUid, String filterPackageName, String[] filterOpNames, long filterBeginTimeMillis, long filterEndTimeMillis, int filterFlags, long[] cumulativeOverflowMillis) throws IOException, XmlPullParserException {
            long beginTimeMillis = XmlUtils.readLongAttribute(parser, ATTR_BEGIN_TIME, 0L) + (cumulativeOverflowMillis != null ? cumulativeOverflowMillis[0] : 0L);
            long endTimeMillis = XmlUtils.readLongAttribute(parser, ATTR_END_TIME, 0L) + (cumulativeOverflowMillis != null ? cumulativeOverflowMillis[0] : 0L);
            if (filterEndTimeMillis < beginTimeMillis) {
                return null;
            }
            if (filterBeginTimeMillis > endTimeMillis) {
                return new AppOpsManager.HistoricalOps(0L, 0L);
            }
            long filteredBeginTimeMillis = Math.max(beginTimeMillis, filterBeginTimeMillis);
            long filteredEndTimeMillis = Math.min(endTimeMillis, filterEndTimeMillis);
            double filterScale = (double)(filteredEndTimeMillis - filteredBeginTimeMillis) / (double)(endTimeMillis - beginTimeMillis);
            AppOpsManager.HistoricalOps ops = null;
            int depth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, depth)) {
                if (!TAG_UID.equals(parser.getName())) continue;
                AppOpsManager.HistoricalOps returnedOps = this.readHistoricalUidOpsDLocked(ops, parser, filterUid, filterPackageName, filterOpNames, filterFlags, filterScale);
                if (ops != null) continue;
                ops = returnedOps;
            }
            if (ops != null) {
                ops.setBeginAndEndTime(filteredBeginTimeMillis, filteredEndTimeMillis);
            }
            return ops;
        }

        private AppOpsManager.HistoricalOps readHistoricalUidOpsDLocked(AppOpsManager.HistoricalOps ops, XmlPullParser parser, int filterUid, String filterPackageName, String[] filterOpNames, int filterFlags, double filterScale) throws IOException, XmlPullParserException {
            int uid = XmlUtils.readIntAttribute(parser, ATTR_NAME);
            if (filterUid != -1 && filterUid != uid) {
                XmlUtils.skipCurrentTag(parser);
                return null;
            }
            int depth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, depth)) {
                if (!TAG_PACKAGE.equals(parser.getName())) continue;
                AppOpsManager.HistoricalOps returnedOps = this.readHistoricalPackageOpsDLocked(ops, uid, parser, filterPackageName, filterOpNames, filterFlags, filterScale);
                if (ops != null) continue;
                ops = returnedOps;
            }
            return ops;
        }

        private AppOpsManager.HistoricalOps readHistoricalPackageOpsDLocked(AppOpsManager.HistoricalOps ops, int uid, XmlPullParser parser, String filterPackageName, String[] filterOpNames, int filterFlags, double filterScale) throws IOException, XmlPullParserException {
            String packageName = XmlUtils.readStringAttribute(parser, ATTR_NAME);
            if (filterPackageName != null && !filterPackageName.equals(packageName)) {
                XmlUtils.skipCurrentTag(parser);
                return null;
            }
            int depth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, depth)) {
                if (!TAG_OP.equals(parser.getName())) continue;
                AppOpsManager.HistoricalOps returnedOps = this.readHistoricalOpDLocked(ops, uid, packageName, parser, filterOpNames, filterFlags, filterScale);
                if (ops != null) continue;
                ops = returnedOps;
            }
            return ops;
        }

        private AppOpsManager.HistoricalOps readHistoricalOpDLocked(AppOpsManager.HistoricalOps ops, int uid, String packageName, XmlPullParser parser, String[] filterOpNames, int filterFlags, double filterScale) throws IOException, XmlPullParserException {
            int op = XmlUtils.readIntAttribute(parser, ATTR_NAME);
            if (filterOpNames != null && !ArrayUtils.contains(filterOpNames, AppOpsManager.opToPublicName(op))) {
                XmlUtils.skipCurrentTag(parser);
                return null;
            }
            int depth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, depth)) {
                if (!TAG_STATE.equals(parser.getName())) continue;
                AppOpsManager.HistoricalOps returnedOps = this.readStateDLocked(ops, uid, packageName, op, parser, filterFlags, filterScale);
                if (ops != null) continue;
                ops = returnedOps;
            }
            return ops;
        }

        private AppOpsManager.HistoricalOps readStateDLocked(AppOpsManager.HistoricalOps ops, int uid, String packageName, int op, XmlPullParser parser, int filterFlags, double filterScale) throws IOException {
            long accessDuration;
            long rejectCount;
            long key = XmlUtils.readLongAttribute(parser, ATTR_NAME);
            int flags = AppOpsManager.extractFlagsFromKey(key) & filterFlags;
            if (flags == 0) {
                return null;
            }
            int uidState = AppOpsManager.extractUidStateFromKey(key);
            long accessCount = XmlUtils.readLongAttribute(parser, ATTR_ACCESS_COUNT, 0L);
            if (accessCount > 0L) {
                if (!Double.isNaN(filterScale)) {
                    accessCount = (long)AppOpsManager.HistoricalOps.round((double)accessCount * filterScale);
                }
                if (ops == null) {
                    ops = new AppOpsManager.HistoricalOps(0L, 0L);
                }
                ops.increaseAccessCount(op, uid, packageName, uidState, flags, accessCount);
            }
            if ((rejectCount = XmlUtils.readLongAttribute(parser, ATTR_REJECT_COUNT, 0L)) > 0L) {
                if (!Double.isNaN(filterScale)) {
                    rejectCount = (long)AppOpsManager.HistoricalOps.round((double)rejectCount * filterScale);
                }
                if (ops == null) {
                    ops = new AppOpsManager.HistoricalOps(0L, 0L);
                }
                ops.increaseRejectCount(op, uid, packageName, uidState, flags, rejectCount);
            }
            if ((accessDuration = XmlUtils.readLongAttribute(parser, ATTR_ACCESS_DURATION, 0L)) > 0L) {
                if (!Double.isNaN(filterScale)) {
                    accessDuration = (long)AppOpsManager.HistoricalOps.round((double)accessDuration * filterScale);
                }
                if (ops == null) {
                    ops = new AppOpsManager.HistoricalOps(0L, 0L);
                }
                ops.increaseAccessDuration(op, uid, packageName, uidState, flags, accessDuration);
            }
            return ops;
        }

        private void writeHistoricalOpsDLocked(List<AppOpsManager.HistoricalOps> allOps, long intervalOverflowMillis, File file) throws IOException {
            FileOutputStream output = sHistoricalAppOpsDir.openWrite(file);
            try {
                XmlSerializer serializer = Xml.newSerializer();
                serializer.setOutput(output, StandardCharsets.UTF_8.name());
                serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                serializer.startDocument(null, true);
                serializer.startTag(null, TAG_HISTORY);
                serializer.attribute(null, ATTR_VERSION, String.valueOf(2));
                if (intervalOverflowMillis != 0L) {
                    serializer.attribute(null, ATTR_OVERFLOW, Long.toString(intervalOverflowMillis));
                }
                if (allOps != null) {
                    int opsCount = allOps.size();
                    for (int i = 0; i < opsCount; ++i) {
                        AppOpsManager.HistoricalOps ops = allOps.get(i);
                        this.writeHistoricalOpDLocked(ops, serializer);
                    }
                }
                serializer.endTag(null, TAG_HISTORY);
                serializer.endDocument();
                sHistoricalAppOpsDir.closeWrite(output);
            }
            catch (IOException e) {
                sHistoricalAppOpsDir.failWrite(output);
                throw e;
            }
        }

        private void writeHistoricalOpDLocked(AppOpsManager.HistoricalOps ops, XmlSerializer serializer) throws IOException {
            serializer.startTag(null, TAG_OPS);
            serializer.attribute(null, ATTR_BEGIN_TIME, Long.toString(ops.getBeginTimeMillis()));
            serializer.attribute(null, ATTR_END_TIME, Long.toString(ops.getEndTimeMillis()));
            int uidCount = ops.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                AppOpsManager.HistoricalUidOps uidOp = ops.getUidOpsAt(i);
                this.writeHistoricalUidOpsDLocked(uidOp, serializer);
            }
            serializer.endTag(null, TAG_OPS);
        }

        private void writeHistoricalUidOpsDLocked(AppOpsManager.HistoricalUidOps uidOps, XmlSerializer serializer) throws IOException {
            serializer.startTag(null, TAG_UID);
            serializer.attribute(null, ATTR_NAME, Integer.toString(uidOps.getUid()));
            int packageCount = uidOps.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                AppOpsManager.HistoricalPackageOps packageOps = uidOps.getPackageOpsAt(i);
                this.writeHistoricalPackageOpsDLocked(packageOps, serializer);
            }
            serializer.endTag(null, TAG_UID);
        }

        private void writeHistoricalPackageOpsDLocked(AppOpsManager.HistoricalPackageOps packageOps, XmlSerializer serializer) throws IOException {
            serializer.startTag(null, TAG_PACKAGE);
            serializer.attribute(null, ATTR_NAME, packageOps.getPackageName());
            int opCount = packageOps.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                AppOpsManager.HistoricalOp op = packageOps.getOpAt(i);
                this.writeHistoricalOpDLocked(op, serializer);
            }
            serializer.endTag(null, TAG_PACKAGE);
        }

        private void writeHistoricalOpDLocked(AppOpsManager.HistoricalOp op, XmlSerializer serializer) throws IOException {
            LongSparseArray<Object> keys = op.collectKeys();
            if (keys == null || keys.size() <= 0) {
                return;
            }
            serializer.startTag(null, TAG_OP);
            serializer.attribute(null, ATTR_NAME, Integer.toString(op.getOpCode()));
            int keyCount = keys.size();
            for (int i = 0; i < keyCount; ++i) {
                this.writeStateOnLocked(op, keys.keyAt(i), serializer);
            }
            serializer.endTag(null, TAG_OP);
        }

        private void writeStateOnLocked(AppOpsManager.HistoricalOp op, long key, XmlSerializer serializer) throws IOException {
            int uidState = AppOpsManager.extractUidStateFromKey(key);
            int flags = AppOpsManager.extractFlagsFromKey(key);
            long accessCount = op.getAccessCount(uidState, uidState, flags);
            long rejectCount = op.getRejectCount(uidState, uidState, flags);
            long accessDuration = op.getAccessDuration(uidState, uidState, flags);
            if (accessCount <= 0L && rejectCount <= 0L && accessDuration <= 0L) {
                return;
            }
            serializer.startTag(null, TAG_STATE);
            serializer.attribute(null, ATTR_NAME, Long.toString(key));
            if (accessCount > 0L) {
                serializer.attribute(null, ATTR_ACCESS_COUNT, Long.toString(accessCount));
            }
            if (rejectCount > 0L) {
                serializer.attribute(null, ATTR_REJECT_COUNT, Long.toString(rejectCount));
            }
            if (accessDuration > 0L) {
                serializer.attribute(null, ATTR_ACCESS_DURATION, Long.toString(accessDuration));
            }
            serializer.endTag(null, TAG_STATE);
        }

        private static void enforceOpsWellFormed(List<AppOpsManager.HistoricalOps> ops) {
            if (ops == null) {
                return;
            }
            AppOpsManager.HistoricalOps current = null;
            int opsCount = ops.size();
            for (int i = 0; i < opsCount; ++i) {
                AppOpsManager.HistoricalOps previous = current;
                current = ops.get(i);
                if (current.isEmpty()) {
                    throw new IllegalStateException("Empty ops:\n" + Persistence.opsToDebugString(ops));
                }
                if (current.getEndTimeMillis() < current.getBeginTimeMillis()) {
                    throw new IllegalStateException("Begin after end:\n" + Persistence.opsToDebugString(ops));
                }
                if (previous == null) continue;
                if (previous.getEndTimeMillis() > current.getBeginTimeMillis()) {
                    throw new IllegalStateException("Intersecting ops:\n" + Persistence.opsToDebugString(ops));
                }
                if (previous.getBeginTimeMillis() <= current.getBeginTimeMillis()) continue;
                throw new IllegalStateException("Non increasing ops:\n" + Persistence.opsToDebugString(ops));
            }
        }

        private long computeGlobalIntervalBeginMillis(int depth) {
            long beginTimeMillis = 0L;
            for (int i = 0; i < depth + 1; ++i) {
                beginTimeMillis = (long)((double)beginTimeMillis + Math.pow(this.mIntervalCompressionMultiplier, i));
            }
            return beginTimeMillis * this.mBaseSnapshotInterval;
        }

        private static AppOpsManager.HistoricalOps spliceFromEnd(AppOpsManager.HistoricalOps ops, double spliceRatio) {
            AppOpsManager.HistoricalOps splice = ops.spliceFromEnd(spliceRatio);
            return splice;
        }

        private static AppOpsManager.HistoricalOps spliceFromBeginning(AppOpsManager.HistoricalOps ops, double spliceRatio) {
            AppOpsManager.HistoricalOps splice = ops.spliceFromBeginning(spliceRatio);
            return splice;
        }

        private static void normalizeSnapshotForSlotDuration(List<AppOpsManager.HistoricalOps> ops, long slotDurationMillis) {
            int opCount = ops.size();
            for (int processedIdx = opCount - 1; processedIdx >= 0; --processedIdx) {
                AppOpsManager.HistoricalOps candidateOp;
                long candidateSlotIntersectionMillis;
                AppOpsManager.HistoricalOps processedOp = ops.get(processedIdx);
                long slotBeginTimeMillis = Math.max(processedOp.getEndTimeMillis() - slotDurationMillis, 0L);
                for (int candidateIdx = processedIdx - 1; candidateIdx >= 0 && (candidateSlotIntersectionMillis = (candidateOp = ops.get(candidateIdx)).getEndTimeMillis() - Math.min(slotBeginTimeMillis, processedOp.getBeginTimeMillis())) > 0L; --candidateIdx) {
                    float candidateSplitRatio = (float)candidateSlotIntersectionMillis / (float)candidateOp.getDurationMillis();
                    if (Float.compare(candidateSplitRatio, 1.0f) >= 0) {
                        ops.remove(candidateIdx);
                        --processedIdx;
                        processedOp.merge(candidateOp);
                        continue;
                    }
                    AppOpsManager.HistoricalOps endSplice = Persistence.spliceFromEnd(candidateOp, candidateSplitRatio);
                    if (endSplice != null) {
                        processedOp.merge(endSplice);
                    }
                    if (!candidateOp.isEmpty()) continue;
                    ops.remove(candidateIdx);
                    --processedIdx;
                }
            }
        }

        private static String opsToDebugString(List<AppOpsManager.HistoricalOps> ops) {
            StringBuilder builder = new StringBuilder();
            int opCount = ops.size();
            for (int i = 0; i < opCount; ++i) {
                builder.append("  ");
                builder.append(ops.get(i));
                if (i >= opCount - 1) continue;
                builder.append('\n');
            }
            return builder.toString();
        }

        private static Set<String> getHistoricalFileNames(File historyDir) {
            File[] files = historyDir.listFiles();
            if (files == null) {
                return Collections.emptySet();
            }
            ArraySet<String> fileNames = new ArraySet<String>(files.length);
            for (File file : files) {
                fileNames.add(file.getName());
            }
            return fileNames;
        }
    }
}

