/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appprediction;

import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionSessionId;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.IPredictionCallback;
import android.app.prediction.IPredictionManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.LocalServices;
import com.android.server.appprediction.AppPredictionManagerServiceShellCommand;
import com.android.server.appprediction.AppPredictionPerUserService;
import com.android.server.infra.AbstractMasterSystemService;
import com.android.server.infra.FrameworkResourcesServiceNameResolver;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.FileDescriptor;
import java.util.function.Consumer;

public class AppPredictionManagerService
extends AbstractMasterSystemService<AppPredictionManagerService, AppPredictionPerUserService> {
    private static final String TAG = AppPredictionManagerService.class.getSimpleName();
    private static final int MAX_TEMP_SERVICE_DURATION_MS = 120000;
    private ActivityTaskManagerInternal mActivityTaskManagerInternal = LocalServices.getService(ActivityTaskManagerInternal.class);

    public AppPredictionManagerService(Context context) {
        super(context, new FrameworkResourcesServiceNameResolver(context, 17039696), null);
    }

    @Override
    protected AppPredictionPerUserService newServiceLocked(int resolvedUserId, boolean disabled) {
        return new AppPredictionPerUserService(this, this.mLock, resolvedUserId);
    }

    @Override
    public void onStart() {
        this.publishBinderService("app_prediction", new PredictionManagerServiceStub());
    }

    @Override
    protected void enforceCallingPermissionForManagement() {
        this.getContext().enforceCallingPermission("android.permission.MANAGE_APP_PREDICTIONS", TAG);
    }

    @Override
    protected int getMaximumTemporaryServiceDurationMs() {
        return 120000;
    }

    private class PredictionManagerServiceStub
    extends IPredictionManager.Stub {
        private PredictionManagerServiceStub() {
        }

        @Override
        public void createPredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId) {
            this.runForUserLocked("createPredictionSession", service -> service.onCreatePredictionSessionLocked(context, sessionId));
        }

        @Override
        public void notifyAppTargetEvent(AppPredictionSessionId sessionId, AppTargetEvent event) {
            this.runForUserLocked("notifyAppTargetEvent", service -> service.notifyAppTargetEventLocked(sessionId, event));
        }

        @Override
        public void notifyLaunchLocationShown(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) {
            this.runForUserLocked("notifyLaunchLocationShown", service -> service.notifyLaunchLocationShownLocked(sessionId, launchLocation, targetIds));
        }

        @Override
        public void sortAppTargets(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) {
            this.runForUserLocked("sortAppTargets", service -> service.sortAppTargetsLocked(sessionId, targets, callback));
        }

        @Override
        public void registerPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
            this.runForUserLocked("registerPredictionUpdates", service -> service.registerPredictionUpdatesLocked(sessionId, callback));
        }

        @Override
        public void unregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
            this.runForUserLocked("unregisterPredictionUpdates", service -> service.unregisterPredictionUpdatesLocked(sessionId, callback));
        }

        @Override
        public void requestPredictionUpdate(AppPredictionSessionId sessionId) {
            this.runForUserLocked("requestPredictionUpdate", service -> service.requestPredictionUpdateLocked(sessionId));
        }

        @Override
        public void onDestroyPredictionSession(AppPredictionSessionId sessionId) {
            this.runForUserLocked("onDestroyPredictionSession", service -> service.onDestroyPredictionSessionLocked(sessionId));
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new AppPredictionManagerServiceShellCommand(AppPredictionManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runForUserLocked(String func, Consumer<AppPredictionPerUserService> c) {
            int userId = UserHandle.getCallingUserId();
            Context ctx = AppPredictionManagerService.this.getContext();
            if (ctx.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") != 0 && !AppPredictionManagerService.this.mServiceNameResolver.isTemporary(userId) && !AppPredictionManagerService.this.mActivityTaskManagerInternal.isCallerRecents(Binder.getCallingUid())) {
                String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " expected caller to hold PACKAGE_USAGE_STATS permission";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            long origId = Binder.clearCallingIdentity();
            try {
                Object object = AppPredictionManagerService.this.mLock;
                synchronized (object) {
                    AppPredictionPerUserService service = (AppPredictionPerUserService)AppPredictionManagerService.this.getServiceForUserLocked(userId);
                    c.accept(service);
                }
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }
}

