/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appprediction;

import android.os.ShellCommand;
import com.android.server.appprediction.AppPredictionManagerService;
import java.io.PrintWriter;

public class AppPredictionManagerServiceShellCommand
extends ShellCommand {
    private static final String TAG = AppPredictionManagerServiceShellCommand.class.getSimpleName();
    private final AppPredictionManagerService mService;

    public AppPredictionManagerServiceShellCommand(AppPredictionManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        block3 : switch (cmd) {
            case "set": {
                String what;
                switch (what = this.getNextArgRequired()) {
                    case "temporary-service": {
                        int userId = Integer.parseInt(this.getNextArgRequired());
                        String serviceName = this.getNextArg();
                        if (serviceName == null) {
                            this.mService.resetTemporaryService(userId);
                            return 0;
                        }
                        int duration = Integer.parseInt(this.getNextArgRequired());
                        this.mService.setTemporaryService(userId, serviceName, duration);
                        pw.println("AppPredictionService temporarily set to " + serviceName + " for " + duration + "ms");
                        break block3;
                    }
                }
                break;
            }
            default: {
                return this.handleDefaultCommands(cmd);
            }
        }
        return 0;
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("AppPredictionManagerService commands:");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  set temporary-service USER_ID [COMPONENT_NAME DURATION]");
            pw.println("    Temporarily (for DURATION ms) changes the service implemtation.");
            pw.println("    To reset, call with just the USER_ID argument.");
            pw.println("");
        }
    }
}

