/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appprediction;

import android.app.AppGlobals;
import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionSessionId;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.IPredictionCallback;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ServiceInfo;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.appprediction.AppPredictionManagerService;
import com.android.server.appprediction.RemoteAppPredictionService;
import com.android.server.infra.AbstractPerUserSystemService;
import java.util.function.Consumer;

public class AppPredictionPerUserService
extends AbstractPerUserSystemService<AppPredictionPerUserService, AppPredictionManagerService>
implements RemoteAppPredictionService.RemoteAppPredictionServiceCallbacks {
    private static final String TAG = AppPredictionPerUserService.class.getSimpleName();
    @GuardedBy(value={"mLock"})
    private RemoteAppPredictionService mRemoteService;
    @GuardedBy(value={"mLock"})
    private boolean mZombie;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<AppPredictionSessionId, AppPredictionSessionInfo> mSessionInfos = new ArrayMap();

    protected AppPredictionPerUserService(AppPredictionManagerService master, Object lock, int userId) {
        super(master, lock, userId);
    }

    @Override
    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        ServiceInfo si;
        try {
            si = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 128, this.mUserId);
        }
        catch (RemoteException e) {
            throw new PackageManager.NameNotFoundException("Could not get service for " + serviceComponent);
        }
        return si;
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected boolean updateLocked(boolean disabled) {
        boolean enabledChanged = super.updateLocked(disabled);
        if (enabledChanged && !this.isEnabledLocked()) {
            this.mRemoteService = null;
        }
        return enabledChanged;
    }

    @GuardedBy(value={"mLock"})
    public void onCreatePredictionSessionLocked(AppPredictionContext context, AppPredictionSessionId sessionId) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.onCreatePredictionSession(context, sessionId);
            if (!this.mSessionInfos.containsKey(sessionId)) {
                this.mSessionInfos.put(sessionId, new AppPredictionSessionInfo(sessionId, context, this::removeAppPredictionSessionInfo));
            }
        }
    }

    @GuardedBy(value={"mLock"})
    public void notifyAppTargetEventLocked(AppPredictionSessionId sessionId, AppTargetEvent event) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.notifyAppTargetEvent(sessionId, event);
        }
    }

    @GuardedBy(value={"mLock"})
    public void notifyLaunchLocationShownLocked(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.notifyLaunchLocationShown(sessionId, launchLocation, targetIds);
        }
    }

    @GuardedBy(value={"mLock"})
    public void sortAppTargetsLocked(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.sortAppTargets(sessionId, targets, callback);
        }
    }

    @GuardedBy(value={"mLock"})
    public void registerPredictionUpdatesLocked(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.registerPredictionUpdates(sessionId, callback);
            AppPredictionSessionInfo sessionInfo = this.mSessionInfos.get(sessionId);
            if (sessionInfo != null) {
                sessionInfo.addCallbackLocked(callback);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    public void unregisterPredictionUpdatesLocked(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.unregisterPredictionUpdates(sessionId, callback);
            AppPredictionSessionInfo sessionInfo = this.mSessionInfos.get(sessionId);
            if (sessionInfo != null) {
                sessionInfo.removeCallbackLocked(callback);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    public void requestPredictionUpdateLocked(AppPredictionSessionId sessionId) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.requestPredictionUpdate(sessionId);
        }
    }

    @GuardedBy(value={"mLock"})
    public void onDestroyPredictionSessionLocked(AppPredictionSessionId sessionId) {
        RemoteAppPredictionService service = this.getRemoteServiceLocked();
        if (service != null) {
            service.onDestroyPredictionSession(sessionId);
            AppPredictionSessionInfo sessionInfo = this.mSessionInfos.get(sessionId);
            if (sessionInfo != null) {
                sessionInfo.destroy();
            }
        }
    }

    @Override
    public void onFailureOrTimeout(boolean timedOut) {
        if (this.isDebug()) {
            Slog.d(TAG, "onFailureOrTimeout(): timed out=" + timedOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectedStateChanged(boolean connected) {
        if (this.isDebug()) {
            Slog.d(TAG, "onConnectedStateChanged(): connected=" + connected);
        }
        if (connected) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mZombie) {
                    if (this.mRemoteService == null) {
                        Slog.w(TAG, "Cannot resurrect sessions because remote service is null");
                        return;
                    }
                    this.mZombie = false;
                    this.resurrectSessionsLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDied(RemoteAppPredictionService service) {
        if (this.isDebug()) {
            Slog.w(TAG, "onServiceDied(): service=" + service);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mZombie = true;
        }
    }

    private void resurrectSessionsLocked() {
        int numSessions = this.mSessionInfos.size();
        if (this.isDebug()) {
            Slog.d(TAG, "Resurrecting remote service (" + this.mRemoteService + ") on " + numSessions + " sessions.");
        }
        for (AppPredictionSessionInfo sessionInfo : this.mSessionInfos.values()) {
            sessionInfo.resurrectSessionLocked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAppPredictionSessionInfo(AppPredictionSessionId sessionId) {
        if (this.isDebug()) {
            Slog.d(TAG, "removeAppPredictionSessionInfo(): sessionId=" + sessionId);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionInfos.remove(sessionId);
        }
    }

    @GuardedBy(value={"mLock"})
    private RemoteAppPredictionService getRemoteServiceLocked() {
        if (this.mRemoteService == null) {
            String serviceName = this.getComponentNameLocked();
            if (serviceName == null) {
                if (((AppPredictionManagerService)this.mMaster).verbose) {
                    Slog.v(TAG, "getRemoteServiceLocked(): not set");
                }
                return null;
            }
            ComponentName serviceComponent = ComponentName.unflattenFromString(serviceName);
            this.mRemoteService = new RemoteAppPredictionService(this.getContext(), "android.service.appprediction.AppPredictionService", serviceComponent, this.mUserId, this, ((AppPredictionManagerService)this.mMaster).isBindInstantServiceAllowed(), ((AppPredictionManagerService)this.mMaster).verbose);
        }
        return this.mRemoteService;
    }

    private static final class AppPredictionSessionInfo {
        private static final boolean DEBUG = false;
        private final AppPredictionSessionId mSessionId;
        private final AppPredictionContext mPredictionContext;
        private final Consumer<AppPredictionSessionId> mRemoveSessionInfoAction;
        private final RemoteCallbackList<IPredictionCallback> mCallbacks = new RemoteCallbackList<IPredictionCallback>(){

            @Override
            public void onCallbackDied(IPredictionCallback callback) {
                if (mCallbacks.getRegisteredCallbackCount() == 0) {
                    this.destroy();
                }
            }
        };

        AppPredictionSessionInfo(AppPredictionSessionId id2, AppPredictionContext predictionContext, Consumer<AppPredictionSessionId> removeSessionInfoAction) {
            this.mSessionId = id2;
            this.mPredictionContext = predictionContext;
            this.mRemoveSessionInfoAction = removeSessionInfoAction;
        }

        void addCallbackLocked(IPredictionCallback callback) {
            this.mCallbacks.register(callback);
        }

        void removeCallbackLocked(IPredictionCallback callback) {
            this.mCallbacks.unregister(callback);
        }

        void destroy() {
            this.mCallbacks.kill();
            this.mRemoveSessionInfoAction.accept(this.mSessionId);
        }

        void resurrectSessionLocked(AppPredictionPerUserService service) {
            int callbackCount = this.mCallbacks.getRegisteredCallbackCount();
            service.onCreatePredictionSessionLocked(this.mPredictionContext, this.mSessionId);
            this.mCallbacks.broadcast(callback -> service.registerPredictionUpdatesLocked(this.mSessionId, (IPredictionCallback)callback));
        }
    }
}

