/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appprediction;

import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionSessionId;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.IPredictionCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.IBinder;
import android.service.appprediction.IPredictionService;
import com.android.internal.infra.AbstractMultiplePendingRequestsRemoteService;
import com.android.internal.infra.AbstractRemoteService;

public class RemoteAppPredictionService
extends AbstractMultiplePendingRequestsRemoteService<RemoteAppPredictionService, IPredictionService> {
    private static final String TAG = "RemoteAppPredictionService";
    private static final long TIMEOUT_REMOTE_REQUEST_MILLIS = 2000L;
    private final RemoteAppPredictionServiceCallbacks mCallback;

    public RemoteAppPredictionService(Context context, String serviceInterface, ComponentName componentName, int userId, RemoteAppPredictionServiceCallbacks callback, boolean bindInstantServiceAllowed, boolean verbose) {
        super(context, serviceInterface, componentName, userId, callback, context.getMainThreadHandler(), bindInstantServiceAllowed ? 0x400000 : 0, verbose, 1);
        this.mCallback = callback;
    }

    @Override
    protected IPredictionService getServiceInterface(IBinder service) {
        return IPredictionService.Stub.asInterface(service);
    }

    @Override
    protected long getTimeoutIdleBindMillis() {
        return 0L;
    }

    @Override
    protected long getRemoteRequestMillis() {
        return 2000L;
    }

    public void onCreatePredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId) {
        this.scheduleAsyncRequest(s -> s.onCreatePredictionSession(context, sessionId));
    }

    public void notifyAppTargetEvent(AppPredictionSessionId sessionId, AppTargetEvent event) {
        this.scheduleAsyncRequest(s -> s.notifyAppTargetEvent(sessionId, event));
    }

    public void notifyLaunchLocationShown(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) {
        this.scheduleAsyncRequest(s -> s.notifyLaunchLocationShown(sessionId, launchLocation, targetIds));
    }

    public void sortAppTargets(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) {
        this.scheduleAsyncRequest(s -> s.sortAppTargets(sessionId, targets, callback));
    }

    public void registerPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        this.scheduleAsyncRequest(s -> s.registerPredictionUpdates(sessionId, callback));
    }

    public void unregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        this.scheduleAsyncRequest(s -> s.unregisterPredictionUpdates(sessionId, callback));
    }

    public void requestPredictionUpdate(AppPredictionSessionId sessionId) {
        this.scheduleAsyncRequest(s -> s.requestPredictionUpdate(sessionId));
    }

    public void onDestroyPredictionSession(AppPredictionSessionId sessionId) {
        this.scheduleAsyncRequest(s -> s.onDestroyPredictionSession(sessionId));
    }

    @Override
    protected void handleOnConnectedStateChanged(boolean connected) {
        if (this.mCallback != null) {
            this.mCallback.onConnectedStateChanged(connected);
        }
    }

    public static interface RemoteAppPredictionServiceCallbacks
    extends AbstractRemoteService.VultureCallback<RemoteAppPredictionService> {
        public void onFailureOrTimeout(boolean var1);

        public void onConnectedStateChanged(boolean var1);
    }
}

