/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.attention;

import android.app.ActivityManager;
import android.attention.AttentionManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.DeviceConfig;
import android.service.attention.IAttentionCallback;
import android.service.attention.IAttentionService;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;

public class AttentionManagerService
extends SystemService {
    private static final String LOG_TAG = "AttentionManagerService";
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_SERVICE_ENABLED = true;
    private static final long CONNECTION_TTL_MILLIS = 60000L;
    private static final long STALE_AFTER_MILLIS = 5000L;
    private static final String SERVICE_ENABLED = "service_enabled";
    private static String sTestAttentionServicePackage;
    private final Context mContext;
    private final PowerManager mPowerManager;
    private final Object mLock;
    @GuardedBy(value={"mLock"})
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private AttentionHandler mAttentionHandler;
    @VisibleForTesting
    ComponentName mComponentName;

    public AttentionManagerService(Context context) {
        this(context, (PowerManager)context.getSystemService("power"), new Object(), null);
        this.mAttentionHandler = new AttentionHandler();
    }

    @VisibleForTesting
    AttentionManagerService(Context context, PowerManager powerManager, Object lock, AttentionHandler handler) {
        super(context);
        this.mContext = Preconditions.checkNotNull(context);
        this.mPowerManager = powerManager;
        this.mLock = lock;
        this.mAttentionHandler = handler;
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mContext.registerReceiver(new ScreenStateReceiver(), new IntentFilter("android.intent.action.SCREEN_OFF"));
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("attention", new BinderService());
        this.publishLocalService(AttentionManagerInternal.class, new LocalService());
    }

    @Override
    public void onSwitchUser(int userId) {
        this.cancelAndUnbindLocked(this.peekUserStateLocked(userId));
    }

    public static boolean isServiceConfigured(Context context) {
        return !TextUtils.isEmpty(AttentionManagerService.getServiceConfigPackage(context));
    }

    private boolean isServiceAvailable() {
        if (this.mComponentName == null) {
            this.mComponentName = AttentionManagerService.resolveAttentionService(this.mContext);
        }
        return this.mComponentName != null;
    }

    private boolean isAttentionServiceSupported() {
        return this.isServiceEnabled() && this.isServiceAvailable();
    }

    @VisibleForTesting
    protected boolean isServiceEnabled() {
        return DeviceConfig.getBoolean("attention_manager_service", SERVICE_ENABLED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean checkAttention(long timeout, AttentionManagerInternal.AttentionCallbackInternal callbackInternal) {
        Preconditions.checkNotNull(callbackInternal);
        if (!this.isAttentionServiceSupported()) {
            Slog.w(LOG_TAG, "Trying to call checkAttention() on an unsupported device.");
            return false;
        }
        if (!this.mPowerManager.isInteractive()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            long now = SystemClock.uptimeMillis();
            this.freeIfInactiveLocked();
            UserState userState = this.getOrCreateCurrentUserStateLocked();
            userState.bindLocked();
            AttentionCheckCache cache = userState.mAttentionCheckCache;
            if (cache != null && now < cache.mLastComputed + 5000L) {
                callbackInternal.onSuccess(cache.mResult, cache.mTimestamp);
                return true;
            }
            if (!(userState.mCurrentAttentionCheck == null || userState.mCurrentAttentionCheck.mIsDispatched && userState.mCurrentAttentionCheck.mIsFulfilled)) {
                return false;
            }
            userState.mCurrentAttentionCheck = this.createAttentionCheck(callbackInternal, userState);
            if (userState.mService != null) {
                try {
                    this.cancelAfterTimeoutLocked(timeout);
                    userState.mService.checkAttention(userState.mCurrentAttentionCheck.mIAttentionCallback);
                    userState.mCurrentAttentionCheck.mIsDispatched = true;
                }
                catch (RemoteException e) {
                    Slog.e(LOG_TAG, "Cannot call into the AttentionService");
                    return false;
                }
            }
            return true;
        }
    }

    private AttentionCheck createAttentionCheck(final AttentionManagerInternal.AttentionCallbackInternal callbackInternal, final UserState userState) {
        IAttentionCallback.Stub iAttentionCallback = new IAttentionCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(int result, long timestamp) {
                if (!userState.mCurrentAttentionCheck.mIsFulfilled) {
                    callbackInternal.onSuccess(result, timestamp);
                    userState.mCurrentAttentionCheck.mIsFulfilled = true;
                }
                Object object = AttentionManagerService.this.mLock;
                synchronized (object) {
                    userState.mAttentionCheckCache = new AttentionCheckCache(SystemClock.uptimeMillis(), result, timestamp);
                }
                StatsLog.write(143, result);
            }

            @Override
            public void onFailure(int error) {
                if (!userState.mCurrentAttentionCheck.mIsFulfilled) {
                    callbackInternal.onFailure(error);
                    userState.mCurrentAttentionCheck.mIsFulfilled = true;
                }
                StatsLog.write(143, error);
            }
        };
        return new AttentionCheck(callbackInternal, iAttentionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cancelAttentionCheck(AttentionManagerInternal.AttentionCallbackInternal callbackInternal) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.peekCurrentUserStateLocked();
            if (userState == null) {
                return;
            }
            if (!userState.mCurrentAttentionCheck.mCallbackInternal.equals(callbackInternal)) {
                Slog.w(LOG_TAG, "Cannot cancel a non-current request");
                return;
            }
            this.cancel(userState);
        }
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    protected void freeIfInactiveLocked() {
        this.mAttentionHandler.removeMessages(1);
        this.mAttentionHandler.sendEmptyMessageDelayed(1, 60000L);
    }

    @GuardedBy(value={"mLock"})
    private void cancelAfterTimeoutLocked(long timeout) {
        this.mAttentionHandler.sendEmptyMessageDelayed(2, timeout);
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    protected UserState getOrCreateCurrentUserStateLocked() {
        return this.getOrCreateUserStateLocked(ActivityManager.getCurrentUser());
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    protected UserState getOrCreateUserStateLocked(int userId) {
        UserState result = this.mUserStates.get(userId);
        if (result == null) {
            result = new UserState(userId, this.mContext, this.mLock, this.mAttentionHandler, this.mComponentName);
            this.mUserStates.put(userId, result);
        }
        return result;
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    protected UserState peekCurrentUserStateLocked() {
        return this.peekUserStateLocked(ActivityManager.getCurrentUser());
    }

    @GuardedBy(value={"mLock"})
    private UserState peekUserStateLocked(int userId) {
        return this.mUserStates.get(userId);
    }

    private static String getServiceConfigPackage(Context context) {
        return context.getPackageManager().getAttentionServicePackageName();
    }

    private static ComponentName resolveAttentionService(Context context) {
        String resolvedPackage;
        String serviceConfigPackage = AttentionManagerService.getServiceConfigPackage(context);
        int flags = 0x100000;
        if (!TextUtils.isEmpty(sTestAttentionServicePackage)) {
            resolvedPackage = sTestAttentionServicePackage;
            flags = 128;
        } else if (!TextUtils.isEmpty(serviceConfigPackage)) {
            resolvedPackage = serviceConfigPackage;
        } else {
            return null;
        }
        Intent intent = new Intent("android.service.attention.AttentionService").setPackage(resolvedPackage);
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, flags);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.wtf(LOG_TAG, String.format("Service %s not found in package %s", "android.service.attention.AttentionService", serviceConfigPackage));
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        String permission2 = serviceInfo.permission;
        if ("android.permission.BIND_ATTENTION_SERVICE".equals(permission2)) {
            return serviceInfo.getComponentName();
        }
        Slog.e(LOG_TAG, String.format("Service %s should require %s permission. Found %s permission", serviceInfo.getComponentName(), "android.permission.BIND_ATTENTION_SERVICE", serviceInfo.permission));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(IndentingPrintWriter ipw) {
        ipw.println("Attention Manager Service (dumpsys attention) state:\n");
        ipw.println("AttentionServicePackageName=" + AttentionManagerService.getServiceConfigPackage(this.mContext));
        ipw.println("Resolved component:");
        if (this.mComponentName != null) {
            ipw.increaseIndent();
            ipw.println("Component=" + this.mComponentName.getPackageName());
            ipw.println("Class=" + this.mComponentName.getClassName());
            ipw.decreaseIndent();
        }
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mUserStates.size();
            ipw.print("Number user states: ");
            ipw.println(size);
            if (size > 0) {
                ipw.increaseIndent();
                for (int i = 0; i < size; ++i) {
                    UserState userState = this.mUserStates.valueAt(i);
                    ipw.print(i);
                    ipw.print(":");
                    userState.dump(ipw);
                    ipw.println();
                }
                ipw.decreaseIndent();
            }
        }
    }

    @VisibleForTesting
    void cancel(UserState userState) {
        if (userState == null || userState.mCurrentAttentionCheck == null) {
            return;
        }
        if (userState.mCurrentAttentionCheck.mIsFulfilled) {
            return;
        }
        if (userState.mService == null) {
            userState.mCurrentAttentionCheck.cancelInternal();
            return;
        }
        try {
            userState.mService.cancelAttentionCheck(userState.mCurrentAttentionCheck.mIAttentionCallback);
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Unable to cancel attention check");
            userState.mCurrentAttentionCheck.cancelInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void cancelAndUnbindLocked(UserState userState) {
        Object object = this.mLock;
        synchronized (object) {
            if (userState == null) {
                return;
            }
            this.cancel(userState);
            if (userState.mService == null) {
                return;
            }
            this.mAttentionHandler.post(() -> this.mContext.unbindService(userState.mConnection));
            userState.mConnection.cleanupService();
            this.mUserStates.remove(userState.mUserId);
        }
    }

    private final class BinderService
    extends Binder {
        AttentionManagerServiceShellCommand mAttentionManagerServiceShellCommand;

        private BinderService() {
            this.mAttentionManagerServiceShellCommand = new AttentionManagerServiceShellCommand();
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            this.mAttentionManagerServiceShellCommand.exec(this, in, out, err, args, callback, resultReceiver);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(AttentionManagerService.this.mContext, AttentionManagerService.LOG_TAG, pw)) {
                return;
            }
            AttentionManagerService.this.dumpInternal(new IndentingPrintWriter((Writer)pw, "  "));
        }
    }

    private final class AttentionManagerServiceShellCommand
    extends ShellCommand {
        final TestableAttentionCallbackInternal mTestableAttentionCallback = new TestableAttentionCallbackInternal();

        private AttentionManagerServiceShellCommand() {
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter err = this.getErrPrintWriter();
            try {
                switch (cmd) {
                    case "getAttentionServiceComponent": {
                        return this.cmdResolveAttentionServiceComponent();
                    }
                    case "call": {
                        switch (this.getNextArgRequired()) {
                            case "checkAttention": {
                                return this.cmdCallCheckAttention();
                            }
                            case "cancelCheckAttention": {
                                return this.cmdCallCancelAttention();
                            }
                        }
                        throw new IllegalArgumentException("Invalid argument");
                    }
                    case "setTestableAttentionService": {
                        return this.cmdSetTestableAttentionService(this.getNextArgRequired());
                    }
                    case "clearTestableAttentionService": {
                        return this.cmdClearTestableAttentionService();
                    }
                    case "getLastTestCallbackCode": {
                        return this.cmdGetLastTestCallbackCode();
                    }
                }
                return this.handleDefaultCommands(cmd);
            }
            catch (IllegalArgumentException e) {
                err.println("Error: " + e.getMessage());
                return -1;
            }
        }

        private int cmdSetTestableAttentionService(String testingServicePackage) {
            PrintWriter out = this.getOutPrintWriter();
            if (TextUtils.isEmpty(testingServicePackage)) {
                out.println("false");
            } else {
                sTestAttentionServicePackage = testingServicePackage;
                this.resetStates();
                out.println(AttentionManagerService.this.mComponentName != null ? "true" : "false");
            }
            return 0;
        }

        private int cmdClearTestableAttentionService() {
            sTestAttentionServicePackage = "";
            this.mTestableAttentionCallback.reset();
            this.resetStates();
            return 0;
        }

        private int cmdCallCheckAttention() {
            PrintWriter out = this.getOutPrintWriter();
            boolean calledSuccessfully = AttentionManagerService.this.checkAttention(2000L, this.mTestableAttentionCallback);
            out.println(calledSuccessfully ? "true" : "false");
            return 0;
        }

        private int cmdCallCancelAttention() {
            PrintWriter out = this.getOutPrintWriter();
            AttentionManagerService.this.cancelAttentionCheck(this.mTestableAttentionCallback);
            out.println("true");
            return 0;
        }

        private int cmdResolveAttentionServiceComponent() {
            PrintWriter out = this.getOutPrintWriter();
            ComponentName resolvedComponent = AttentionManagerService.resolveAttentionService(AttentionManagerService.this.mContext);
            out.println(resolvedComponent != null ? resolvedComponent.flattenToShortString() : "");
            return 0;
        }

        private int cmdGetLastTestCallbackCode() {
            PrintWriter out = this.getOutPrintWriter();
            out.println(this.mTestableAttentionCallback.getLastCallbackCode());
            return 0;
        }

        private void resetStates() {
            AttentionManagerService.this.mComponentName = AttentionManagerService.resolveAttentionService(AttentionManagerService.this.mContext);
            AttentionManagerService.this.mUserStates.clear();
        }

        @Override
        public void onHelp() {
            PrintWriter out = this.getOutPrintWriter();
            out.println("Attention commands: ");
            out.println("  setTestableAttentionService <service_package>: Bind to a custom implementation of attention service");
            out.println("  ---<service_package>:");
            out.println("       := Package containing the Attention Service implementation to bind to");
            out.println("  ---returns:");
            out.println("       := true, if was bound successfully");
            out.println("       := false, if was not bound successfully");
            out.println("  clearTestableAttentionService: Undo custom bindings. Revert to previous behavior");
            out.println("  getAttentionServiceComponent: Get the current service component string");
            out.println("  ---returns:");
            out.println("       := If valid, the component string (in shorten form) for the currently bound service.");
            out.println("       := else, empty string");
            out.println("  call checkAttention: Calls check attention");
            out.println("  ---returns:");
            out.println("       := true, if the call was successfully dispatched to the service implementation. (to see the result, call getLastTestCallbackCode)");
            out.println("       := false, otherwise");
            out.println("  call cancelCheckAttention: Cancels check attention");
            out.println("  getLastTestCallbackCode");
            out.println("  ---returns:");
            out.println("       := An integer, representing the last callback code received from the bounded implementation. If none, it will return -1");
        }

        class TestableAttentionCallbackInternal
        extends AttentionManagerInternal.AttentionCallbackInternal {
            private int mLastCallbackCode = -1;

            TestableAttentionCallbackInternal() {
            }

            @Override
            public void onSuccess(int result, long timestamp) {
                this.mLastCallbackCode = result;
            }

            @Override
            public void onFailure(int error) {
                this.mLastCallbackCode = error;
            }

            public void reset() {
                this.mLastCallbackCode = -1;
            }

            public int getLastCallbackCode() {
                return this.mLastCallbackCode;
            }
        }
    }

    private final class ScreenStateReceiver
    extends BroadcastReceiver {
        private ScreenStateReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                AttentionManagerService.this.cancelAndUnbindLocked(AttentionManagerService.this.peekCurrentUserStateLocked());
            }
        }
    }

    @VisibleForTesting
    protected class AttentionHandler
    extends Handler {
        private static final int CHECK_CONNECTION_EXPIRATION = 1;
        private static final int ATTENTION_CHECK_TIMEOUT = 2;

        AttentionHandler() {
            super(Looper.myLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    for (int i = 0; i < AttentionManagerService.this.mUserStates.size(); ++i) {
                        AttentionManagerService.this.cancelAndUnbindLocked((UserState)AttentionManagerService.this.mUserStates.valueAt(i));
                    }
                    break;
                }
                case 2: {
                    Object object = AttentionManagerService.this.mLock;
                    synchronized (object) {
                        AttentionManagerService.this.cancel(AttentionManagerService.this.peekCurrentUserStateLocked());
                        break;
                    }
                }
            }
        }
    }

    @VisibleForTesting
    protected static class UserState {
        private final ComponentName mComponentName;
        private final AttentionServiceConnection mConnection = new AttentionServiceConnection();
        @GuardedBy(value={"mLock"})
        IAttentionService mService;
        @GuardedBy(value={"mLock"})
        AttentionCheck mCurrentAttentionCheck;
        @GuardedBy(value={"mLock"})
        AttentionCheckCache mAttentionCheckCache;
        @GuardedBy(value={"mLock"})
        private boolean mBinding;
        private final int mUserId;
        private final Context mContext;
        private final Object mLock;
        private final Handler mAttentionHandler;

        UserState(int userId, Context context, Object lock, Handler handler, ComponentName componentName) {
            this.mUserId = userId;
            this.mContext = Preconditions.checkNotNull(context);
            this.mLock = Preconditions.checkNotNull(lock);
            this.mComponentName = Preconditions.checkNotNull(componentName);
            this.mAttentionHandler = handler;
        }

        @GuardedBy(value={"mLock"})
        private void handlePendingCallbackLocked() {
            if (!this.mCurrentAttentionCheck.mIsDispatched) {
                if (this.mService != null) {
                    try {
                        this.mService.checkAttention(this.mCurrentAttentionCheck.mIAttentionCallback);
                        this.mCurrentAttentionCheck.mIsDispatched = true;
                    }
                    catch (RemoteException e) {
                        Slog.e(AttentionManagerService.LOG_TAG, "Cannot call into the AttentionService");
                    }
                } else {
                    this.mCurrentAttentionCheck.mCallbackInternal.onFailure(2);
                }
            }
        }

        @GuardedBy(value={"mLock"})
        private void bindLocked() {
            if (this.mBinding || this.mService != null) {
                return;
            }
            this.mBinding = true;
            this.mAttentionHandler.post(() -> {
                Intent serviceIntent = new Intent("android.service.attention.AttentionService").setComponent(this.mComponentName);
                this.mContext.bindServiceAsUser(serviceIntent, this.mConnection, 1, UserHandle.CURRENT);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dump(IndentingPrintWriter pw) {
            pw.println("userId=" + this.mUserId);
            Object object = this.mLock;
            synchronized (object) {
                pw.println("binding=" + this.mBinding);
                pw.println("current attention check:");
                if (this.mCurrentAttentionCheck != null) {
                    pw.increaseIndent();
                    pw.println("is dispatched=" + this.mCurrentAttentionCheck.mIsDispatched);
                    pw.println("is fulfilled:=" + this.mCurrentAttentionCheck.mIsFulfilled);
                    pw.decreaseIndent();
                }
                pw.println("attention check cache:");
                if (this.mAttentionCheckCache != null) {
                    pw.increaseIndent();
                    pw.println("last computed=" + this.mAttentionCheckCache.mLastComputed);
                    pw.println("timestamp=" + this.mAttentionCheckCache.mTimestamp);
                    pw.println("result=" + this.mAttentionCheckCache.mResult);
                    pw.decreaseIndent();
                }
            }
        }

        private class AttentionServiceConnection
        implements ServiceConnection {
            private AttentionServiceConnection() {
            }

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                this.init(IAttentionService.Stub.asInterface(service));
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onBindingDied(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onNullBinding(ComponentName name) {
                this.cleanupService();
            }

            void cleanupService() {
                this.init(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void init(IAttentionService service) {
                Object object = UserState.this.mLock;
                synchronized (object) {
                    UserState.this.mService = service;
                    UserState.this.mBinding = false;
                    UserState.this.handlePendingCallbackLocked();
                }
            }
        }
    }

    @VisibleForTesting
    static final class AttentionCheck {
        private final AttentionManagerInternal.AttentionCallbackInternal mCallbackInternal;
        private final IAttentionCallback mIAttentionCallback;
        private boolean mIsDispatched;
        private boolean mIsFulfilled;

        AttentionCheck(AttentionManagerInternal.AttentionCallbackInternal callbackInternal, IAttentionCallback iAttentionCallback) {
            this.mCallbackInternal = callbackInternal;
            this.mIAttentionCallback = iAttentionCallback;
        }

        void cancelInternal() {
            this.mIsFulfilled = true;
            this.mCallbackInternal.onFailure(3);
        }
    }

    private static final class AttentionCheckCache {
        private final long mLastComputed;
        private final int mResult;
        private final long mTimestamp;

        AttentionCheckCache(long lastComputed, int result, long timestamp) {
            this.mLastComputed = lastComputed;
            this.mResult = result;
            this.mTimestamp = timestamp;
        }
    }

    private final class LocalService
    extends AttentionManagerInternal {
        private LocalService() {
        }

        @Override
        public boolean isAttentionServiceSupported() {
            return AttentionManagerService.this.isAttentionServiceSupported();
        }

        @Override
        public boolean checkAttention(long timeout, AttentionManagerInternal.AttentionCallbackInternal callbackInternal) {
            return AttentionManagerService.this.checkAttention(timeout, callbackInternal);
        }

        @Override
        public void cancelAttentionCheck(AttentionManagerInternal.AttentionCallbackInternal callbackInternal) {
            AttentionManagerService.this.cancelAttentionCheck(callbackInternal);
        }
    }
}

