/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothProfile;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioRoutesObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.audio.AudioDeviceInventory;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.AudioService;
import com.android.server.audio.AudioServiceEvents;
import com.android.server.audio.BtHelper;

final class AudioDeviceBroker {
    private static final String TAG = "AS.AudioDeviceBroker";
    private static final long BROKER_WAKELOCK_TIMEOUT_MS = 5000L;
    static final int BTA2DP_DOCK_TIMEOUT_MS = 8000;
    static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private final AudioService mAudioService;
    private final Context mContext;
    private int mForcedUseForComm;
    private int mForcedUseForCommExt;
    private final AudioDeviceInventory mDeviceInventory;
    private final BtHelper mBtHelper;
    private static final Object sLastDeviceConnectionMsgTimeLock = new Object();
    @GuardedBy(value={"sLastDeviceConnectionMsgTimeLock"})
    private static long sLastDeviceConnectMsgTime = 0L;
    private final Object mDeviceStateLock = new Object();
    @GuardedBy(value={"mDeviceStateLock"})
    private boolean mBluetoothA2dpEnabled;
    final Object mSetModeLock = new Object();
    private BrokerHandler mBrokerHandler;
    private BrokerThread mBrokerThread;
    private PowerManager.WakeLock mBrokerEventWakeLock;
    private static final int MSG_RESTORE_DEVICES = 1;
    private static final int MSG_L_SET_WIRED_DEVICE_CONNECTION_STATE = 2;
    private static final int MSG_I_BROADCAST_BT_CONNECTION_STATE = 3;
    private static final int MSG_IIL_SET_FORCE_USE = 4;
    private static final int MSG_IIL_SET_FORCE_BT_A2DP_USE = 5;
    private static final int MSG_IL_SET_A2DP_SINK_CONNECTION_STATE = 6;
    private static final int MSG_IL_SET_A2DP_SOURCE_CONNECTION_STATE = 7;
    private static final int MSG_IL_SET_HEARING_AID_CONNECTION_STATE = 8;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_IL_BTA2DP_DOCK_TIMEOUT = 10;
    private static final int MSG_L_A2DP_DEVICE_CONFIG_CHANGE = 11;
    private static final int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 12;
    private static final int MSG_REPORT_NEW_ROUTES = 13;
    private static final int MSG_II_SET_HEARING_AID_VOLUME = 14;
    private static final int MSG_I_SET_AVRCP_ABSOLUTE_VOLUME = 15;
    private static final int MSG_I_DISCONNECT_BT_SCO = 16;
    private static final int MSG_TOGGLE_HDMI = 17;
    private static final int MSG_L_A2DP_ACTIVE_DEVICE_CHANGE = 18;
    private static final int MSG_DISCONNECT_A2DP = 19;
    private static final int MSG_DISCONNECT_A2DP_SINK = 20;
    private static final int MSG_DISCONNECT_BT_HEARING_AID = 21;
    private static final int MSG_DISCONNECT_BT_HEADSET = 22;
    private static final int MSG_L_BT_SERVICE_CONNECTED_PROFILE_A2DP = 23;
    private static final int MSG_L_BT_SERVICE_CONNECTED_PROFILE_A2DP_SINK = 24;
    private static final int MSG_L_BT_SERVICE_CONNECTED_PROFILE_HEARING_AID = 25;
    private static final int MSG_L_BT_SERVICE_CONNECTED_PROFILE_HEADSET = 26;
    private static final int MSG_L_A2DP_DEVICE_CONNECTION_CHANGE_EXT = 27;
    private static final int MSG_L_HEARING_AID_DEVICE_CONNECTION_CHANGE_EXT = 28;
    private static final int MSG_L_SCOCLIENT_DIED = 29;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;

    AudioDeviceBroker(Context context, AudioService service) {
        this.mContext = context;
        this.mAudioService = service;
        this.setupMessaging(context);
        this.mBtHelper = new BtHelper(this);
        this.mDeviceInventory = new AudioDeviceInventory(this);
        this.mForcedUseForCommExt = this.mForcedUseForComm = 0;
    }

    Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSystemReady() {
        Object object = this.mSetModeLock;
        synchronized (object) {
            Object object2 = this.mDeviceStateLock;
            synchronized (object2) {
                this.mBtHelper.onSystemReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAudioServerDied() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.onSetForceUse(0, this.mForcedUseForComm, "onAudioServerDied");
            this.onSetForceUse(2, this.mForcedUseForComm, "onAudioServerDied");
        }
        this.sendMsgNoDelay(1, 0);
    }

    void setForceUse_Async(int useCase, int config, String eventSource) {
        this.sendIILMsgNoDelay(4, 2, useCase, config, eventSource);
    }

    void toggleHdmiIfConnected_Async() {
        this.sendMsgNoDelay(17, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectAllBluetoothProfiles() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mBtHelper.disconnectAllBluetoothProfiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveBtEvent(Intent intent) {
        Object object = this.mSetModeLock;
        synchronized (object) {
            Object object2 = this.mDeviceStateLock;
            synchronized (object2) {
                this.mBtHelper.receiveBtEvent(intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBluetoothA2dpOn_Async(boolean on, String source) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            if (this.mBluetoothA2dpEnabled == on) {
                return;
            }
            this.mBluetoothA2dpEnabled = on;
            this.mBrokerHandler.removeMessages(5);
            this.sendIILMsgNoDelay(5, 2, 1, this.mBluetoothA2dpEnabled ? 0 : 10, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSpeakerphoneOn(boolean on, String eventSource) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            boolean wasOn = this.isSpeakerphoneOn();
            if (on) {
                if (this.mForcedUseForComm == 3) {
                    this.setForceUse_Async(2, 0, eventSource);
                }
                this.mForcedUseForComm = 1;
            } else if (this.mForcedUseForComm == 1) {
                this.mForcedUseForComm = 0;
            }
            this.mForcedUseForCommExt = this.mForcedUseForComm;
            this.setForceUse_Async(0, this.mForcedUseForComm, eventSource);
            return wasOn != this.isSpeakerphoneOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSpeakerphoneOn() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mForcedUseForCommExt == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mDeviceInventory.setWiredDeviceConnectionState(type, state, address, name, caller);
        }
    }

    void postBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int a2dpVolume) {
        BtDeviceConnectionInfo info = new BtDeviceConnectionInfo(device, state, profile, suppressNoisyIntent, a2dpVolume);
        this.sendLMsgNoDelay(27, 2, info);
    }

    void postBluetoothHearingAidDeviceConnectionState(BluetoothDevice device, int state, boolean suppressNoisyIntent, int musicDevice, String eventSource) {
        HearingAidDeviceConnectionInfo info = new HearingAidDeviceConnectionInfo(device, state, suppressNoisyIntent, musicDevice, eventSource);
        this.sendLMsgNoDelay(28, 2, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBluetoothScoOnByApp(boolean on) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mForcedUseForCommExt = on ? 3 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBluetoothScoOnForApp() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mForcedUseForCommExt == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBluetoothScoOn(boolean on, String eventSource) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            if (on) {
                if (!this.mBtHelper.isBluetoothScoOn()) {
                    this.mForcedUseForCommExt = 3;
                    return;
                }
                this.mForcedUseForComm = 3;
            } else if (this.mForcedUseForComm == 3) {
                this.mForcedUseForComm = 0;
            }
            this.mForcedUseForCommExt = this.mForcedUseForComm;
            AudioSystem.setParameters("BT_SCO=" + (on ? "on" : "off"));
            this.sendIILMsgNoDelay(4, 2, 0, this.mForcedUseForComm, eventSource);
            this.sendIILMsgNoDelay(4, 2, 2, this.mForcedUseForComm, eventSource);
        }
        this.mAudioService.postUpdateRingerModeServiceInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mDeviceInventory.startWatchingRoutes(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioRoutesInfo getCurAudioRoutes() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mDeviceInventory.getCurAudioRoutes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAvrcpAbsoluteVolumeSupported() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mBtHelper.isAvrcpAbsoluteVolumeSupported();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBluetoothA2dpOn() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    void postSetAvrcpAbsoluteVolumeIndex(int index) {
        this.sendIMsgNoDelay(15, 0, index);
    }

    void postSetHearingAidVolumeIndex(int index, int streamType) {
        this.sendIIMsgNoDelay(14, 0, index, streamType);
    }

    void postDisconnectBluetoothSco(int exceptPid) {
        this.sendIMsgNoDelay(16, 0, exceptPid);
    }

    void postBluetoothA2dpDeviceConfigChange(BluetoothDevice device) {
        this.sendLMsgNoDelay(11, 2, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mSetModeLock"})
    void startBluetoothScoForClient_Sync(IBinder cb, int scoAudioMode, String eventSource) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mBtHelper.startBluetoothScoForClient(cb, scoAudioMode, eventSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mSetModeLock"})
    void stopBluetoothScoForClient_Sync(IBinder cb, String eventSource) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mBtHelper.stopBluetoothScoForClient(cb, eventSource);
        }
    }

    void postAccessoryPlugMediaUnmute(int device) {
        this.mAudioService.postAccessoryPlugMediaUnmute(device);
    }

    int getVssVolumeForDevice(int streamType, int device) {
        return this.mAudioService.getVssVolumeForDevice(streamType, device);
    }

    int getModeOwnerPid() {
        return this.mAudioService.getModeOwnerPid();
    }

    int getDeviceForStream(int streamType) {
        return this.mAudioService.getDeviceForStream(streamType);
    }

    void postApplyVolumeOnDevice(int streamType, int device, String caller) {
        this.mAudioService.postApplyVolumeOnDevice(streamType, device, caller);
    }

    void postSetVolumeIndexOnDevice(int streamType, int vssVolIndex, int device, String caller) {
        this.mAudioService.postSetVolumeIndexOnDevice(streamType, vssVolIndex, device, caller);
    }

    void postObserveDevicesForAllStreams() {
        this.mAudioService.postObserveDevicesForAllStreams();
    }

    boolean isInCommunication() {
        return this.mAudioService.isInCommunication();
    }

    boolean hasMediaDynamicPolicy() {
        return this.mAudioService.hasMediaDynamicPolicy();
    }

    ContentResolver getContentResolver() {
        return this.mAudioService.getContentResolver();
    }

    void checkMusicActive(int deviceType, String caller) {
        this.mAudioService.checkMusicActive(deviceType, caller);
    }

    void checkVolumeCecOnHdmiConnection(int state, String caller) {
        this.mAudioService.postCheckVolumeCecOnHdmiConnection(state, caller);
    }

    boolean hasAudioFocusUsers() {
        return this.mAudioService.hasAudioFocusUsers();
    }

    void postBroadcastScoConnectionState(int state) {
        this.sendIMsgNoDelay(3, 2, state);
    }

    void postBroadcastBecomingNoisy() {
        this.sendMsgNoDelay(12, 0);
    }

    void postA2dpSinkConnection(int state, BtHelper.BluetoothA2dpDeviceInfo btDeviceInfo, int delay) {
        this.sendILMsg(6, 2, state, btDeviceInfo, delay);
    }

    void postA2dpSourceConnection(int state, BtHelper.BluetoothA2dpDeviceInfo btDeviceInfo, int delay) {
        this.sendILMsg(7, 2, state, btDeviceInfo, delay);
    }

    void postSetWiredDeviceConnectionState(AudioDeviceInventory.WiredDeviceConnectionState connectionState, int delay) {
        this.sendLMsg(2, 2, connectionState, delay);
    }

    void postSetHearingAidConnectionState(int state, BluetoothDevice device, int delay) {
        this.sendILMsg(8, 2, state, device, delay);
    }

    void postDisconnectA2dp() {
        this.sendMsgNoDelay(19, 2);
    }

    void postDisconnectA2dpSink() {
        this.sendMsgNoDelay(20, 2);
    }

    void postDisconnectHearingAid() {
        this.sendMsgNoDelay(21, 2);
    }

    void postDisconnectHeadset() {
        this.sendMsgNoDelay(22, 2);
    }

    void postBtA2dpProfileConnected(BluetoothA2dp a2dpProfile) {
        this.sendLMsgNoDelay(23, 2, a2dpProfile);
    }

    void postBtA2dpSinkProfileConnected(BluetoothProfile profile) {
        this.sendLMsgNoDelay(24, 2, profile);
    }

    void postBtHeasetProfileConnected(BluetoothHeadset headsetProfile) {
        this.sendLMsgNoDelay(26, 2, headsetProfile);
    }

    void postBtHearingAidProfileConnected(BluetoothHearingAid hearingAidProfile) {
        this.sendLMsgNoDelay(25, 2, hearingAidProfile);
    }

    void postScoClientDied(Object obj) {
        this.sendLMsgNoDelay(29, 2, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBluetoothA2dpOnInt(boolean on, String source) {
        String eventSource = "setBluetoothA2dpOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid() + " src:" + source;
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            this.mBrokerHandler.removeMessages(5);
            this.onSetForceUse(1, this.mBluetoothA2dpEnabled ? 0 : 10, eventSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleDeviceConnection(boolean connect, int device, String address, String deviceName) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mDeviceInventory.handleDeviceConnection(connect, device, address, deviceName);
        }
    }

    @GuardedBy(value={"mDeviceStateLock"})
    void handleSetA2dpSinkConnectionState(int state, BtHelper.BluetoothA2dpDeviceInfo btDeviceInfo) {
        int intState = state == 2 ? 1 : 0;
        int delay = this.mDeviceInventory.checkSendBecomingNoisyIntent(128, intState, 0);
        String addr = btDeviceInfo == null ? "null" : btDeviceInfo.getBtDevice().getAddress();
        this.sendILMsg(6, 2, state, btDeviceInfo, delay);
    }

    void postSetA2dpSourceConnectionState(int state, BtHelper.BluetoothA2dpDeviceInfo btDeviceInfo) {
        boolean intState = state == 2;
        this.sendILMsgNoDelay(7, 2, state, btDeviceInfo);
    }

    void handleFailureToConnectToBtHeadsetService(int delay) {
        this.sendMsg(9, 0, delay);
    }

    void handleCancelFailureToConnectToBtHeadsetService() {
        this.mBrokerHandler.removeMessages(9);
    }

    void postReportNewRoutes() {
        this.sendMsgNoDelay(13, 1);
    }

    void cancelA2dpDockTimeout() {
        this.mBrokerHandler.removeMessages(10);
    }

    void postA2dpActiveDeviceChange(BtHelper.BluetoothA2dpDeviceInfo btDeviceInfo) {
        this.sendLMsgNoDelay(18, 2, btDeviceInfo);
    }

    boolean hasScheduledA2dpDockTimeout() {
        return this.mBrokerHandler.hasMessages(10);
    }

    boolean hasScheduledA2dpSinkConnectionState(BluetoothDevice btDevice) {
        return this.mBrokerHandler.hasMessages(6, new BtHelper.BluetoothA2dpDeviceInfo(btDevice));
    }

    void setA2dpDockTimeout(String address, int a2dpCodec, int delayMs) {
        this.sendILMsg(10, 2, a2dpCodec, address, delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAvrcpAbsoluteVolumeSupported(boolean supported) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            this.mBtHelper.setAvrcpAbsoluteVolumeSupported(supported);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getBluetoothA2dpEnabled() {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getA2dpCodec(BluetoothDevice device) {
        Object object = this.mDeviceStateLock;
        synchronized (object) {
            return this.mBtHelper.getA2dpCodec(device);
        }
    }

    private void onSetForceUse(int useCase, int config, String eventSource) {
        if (useCase == 1) {
            this.postReportNewRoutes();
        }
        AudioService.sForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(useCase, config, eventSource));
        AudioSystem.setForceUse(useCase, config);
    }

    private void onSendBecomingNoisyIntent() {
        AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("broadcast ACTION_AUDIO_BECOMING_NOISY").printLog(TAG));
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    private void setupMessaging(Context ctxt) {
        PowerManager pm = (PowerManager)ctxt.getSystemService("power");
        this.mBrokerEventWakeLock = pm.newWakeLock(1, "handleAudioDeviceEvent");
        this.mBrokerThread = new BrokerThread();
        this.mBrokerThread.start();
        this.waitForBrokerHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBrokerHandlerCreation() {
        AudioDeviceBroker audioDeviceBroker = this;
        synchronized (audioDeviceBroker) {
            while (this.mBrokerHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interruption while waiting on BrokerHandler");
                }
            }
        }
    }

    private static boolean isMessageHandledUnderWakelock(int msgId) {
        switch (msgId) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    private void sendMsg(int msg, int existingMsgPolicy, int delay) {
        this.sendIILMsg(msg, existingMsgPolicy, 0, 0, null, delay);
    }

    private void sendILMsg(int msg, int existingMsgPolicy, int arg, Object obj, int delay) {
        this.sendIILMsg(msg, existingMsgPolicy, arg, 0, obj, delay);
    }

    private void sendLMsg(int msg, int existingMsgPolicy, Object obj, int delay) {
        this.sendIILMsg(msg, existingMsgPolicy, 0, 0, obj, delay);
    }

    private void sendIMsg(int msg, int existingMsgPolicy, int arg, int delay) {
        this.sendIILMsg(msg, existingMsgPolicy, arg, 0, null, delay);
    }

    private void sendMsgNoDelay(int msg, int existingMsgPolicy) {
        this.sendIILMsg(msg, existingMsgPolicy, 0, 0, null, 0);
    }

    private void sendIMsgNoDelay(int msg, int existingMsgPolicy, int arg) {
        this.sendIILMsg(msg, existingMsgPolicy, arg, 0, null, 0);
    }

    private void sendIIMsgNoDelay(int msg, int existingMsgPolicy, int arg1, int arg2) {
        this.sendIILMsg(msg, existingMsgPolicy, arg1, arg2, null, 0);
    }

    private void sendILMsgNoDelay(int msg, int existingMsgPolicy, int arg, Object obj) {
        this.sendIILMsg(msg, existingMsgPolicy, arg, 0, obj, 0);
    }

    private void sendLMsgNoDelay(int msg, int existingMsgPolicy, Object obj) {
        this.sendIILMsg(msg, existingMsgPolicy, 0, 0, obj, 0);
    }

    private void sendIILMsgNoDelay(int msg, int existingMsgPolicy, int arg1, int arg2, Object obj) {
        this.sendIILMsg(msg, existingMsgPolicy, arg1, arg2, obj, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIILMsg(int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            this.mBrokerHandler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && this.mBrokerHandler.hasMessages(msg)) {
            return;
        }
        if (AudioDeviceBroker.isMessageHandledUnderWakelock(msg)) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mBrokerEventWakeLock.acquire(5000L);
            }
            catch (Exception e) {
                Log.e(TAG, "Exception acquiring wakelock", e);
            }
            Binder.restoreCallingIdentity(identity);
        }
        Object object = sLastDeviceConnectionMsgTimeLock;
        synchronized (object) {
            long time = SystemClock.uptimeMillis() + (long)delay;
            switch (msg) {
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 18: {
                    if (sLastDeviceConnectMsgTime >= time) {
                        time = sLastDeviceConnectMsgTime + 30L;
                    }
                    sLastDeviceConnectMsgTime = time;
                    break;
                }
            }
            this.mBrokerHandler.sendMessageAtTime(this.mBrokerHandler.obtainMessage(msg, arg1, arg2, obj), time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastToAll(Intent intent) {
        intent.addFlags(0x4000000);
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private class BrokerHandler
    extends Handler {
        private BrokerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onRestoreDevices();
                        AudioDeviceBroker.this.mBtHelper.onAudioServerDiedRestoreA2dp();
                        break;
                    }
                }
                case 2: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onSetWiredDeviceConnectionState((AudioDeviceInventory.WiredDeviceConnectionState)msg.obj);
                        break;
                    }
                }
                case 3: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.onBroadcastScoConnectionState(msg.arg1);
                        break;
                    }
                }
                case 4: 
                case 5: {
                    AudioDeviceBroker.this.onSetForceUse(msg.arg1, msg.arg2, (String)msg.obj);
                    break;
                }
                case 13: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onReportNewRoutes();
                        break;
                    }
                }
                case 6: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onSetA2dpSinkConnectionState((BtHelper.BluetoothA2dpDeviceInfo)msg.obj, msg.arg1);
                        break;
                    }
                }
                case 7: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onSetA2dpSourceConnectionState((BtHelper.BluetoothA2dpDeviceInfo)msg.obj, msg.arg1);
                        break;
                    }
                }
                case 8: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onSetHearingAidConnectionState((BluetoothDevice)msg.obj, msg.arg1, AudioDeviceBroker.this.mAudioService.getHearingAidStreamType());
                        break;
                    }
                }
                case 9: {
                    Object object = AudioDeviceBroker.this.mSetModeLock;
                    synchronized (object) {
                        Object object2 = AudioDeviceBroker.this.mDeviceStateLock;
                        synchronized (object2) {
                            AudioDeviceBroker.this.mBtHelper.resetBluetoothSco();
                        }
                    }
                }
                case 10: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onMakeA2dpDeviceUnavailableNow((String)msg.obj, msg.arg1);
                        break;
                    }
                }
                case 11: {
                    BluetoothDevice btDevice = (BluetoothDevice)msg.obj;
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        int a2dpCodec = AudioDeviceBroker.this.mBtHelper.getA2dpCodec(btDevice);
                        AudioDeviceBroker.this.mDeviceInventory.onBluetoothA2dpActiveDeviceChange(new BtHelper.BluetoothA2dpDeviceInfo(btDevice, -1, a2dpCodec), 0);
                        break;
                    }
                }
                case 12: {
                    AudioDeviceBroker.this.onSendBecomingNoisyIntent();
                    break;
                }
                case 14: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.setHearingAidVolume(msg.arg1, msg.arg2);
                        break;
                    }
                }
                case 15: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.setAvrcpAbsoluteVolumeIndex(msg.arg1);
                        break;
                    }
                }
                case 16: {
                    Object object = AudioDeviceBroker.this.mSetModeLock;
                    synchronized (object) {
                        Object object3 = AudioDeviceBroker.this.mDeviceStateLock;
                        synchronized (object3) {
                            AudioDeviceBroker.this.mBtHelper.disconnectBluetoothSco(msg.arg1);
                        }
                    }
                }
                case 29: {
                    Object object = AudioDeviceBroker.this.mSetModeLock;
                    synchronized (object) {
                        Object object4 = AudioDeviceBroker.this.mDeviceStateLock;
                        synchronized (object4) {
                            AudioDeviceBroker.this.mBtHelper.scoClientDied(msg.obj);
                        }
                    }
                }
                case 17: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onToggleHdmi();
                        break;
                    }
                }
                case 18: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.onBluetoothA2dpActiveDeviceChange((BtHelper.BluetoothA2dpDeviceInfo)msg.obj, 1);
                        break;
                    }
                }
                case 19: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.disconnectA2dp();
                        break;
                    }
                }
                case 20: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.disconnectA2dpSink();
                        break;
                    }
                }
                case 21: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.disconnectHearingAid();
                        break;
                    }
                }
                case 22: {
                    Object object = AudioDeviceBroker.this.mSetModeLock;
                    synchronized (object) {
                        Object object5 = AudioDeviceBroker.this.mDeviceStateLock;
                        synchronized (object5) {
                            AudioDeviceBroker.this.mBtHelper.disconnectHeadset();
                        }
                    }
                }
                case 23: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.onA2dpProfileConnected((BluetoothA2dp)msg.obj);
                        break;
                    }
                }
                case 24: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.onA2dpSinkProfileConnected((BluetoothProfile)msg.obj);
                        break;
                    }
                }
                case 25: {
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mBtHelper.onHearingAidProfileConnected((BluetoothHearingAid)msg.obj);
                        break;
                    }
                }
                case 26: {
                    Object object = AudioDeviceBroker.this.mSetModeLock;
                    synchronized (object) {
                        Object object6 = AudioDeviceBroker.this.mDeviceStateLock;
                        synchronized (object6) {
                            AudioDeviceBroker.this.mBtHelper.onHeadsetProfileConnected((BluetoothHeadset)msg.obj);
                        }
                    }
                }
                case 27: {
                    BtDeviceConnectionInfo info = (BtDeviceConnectionInfo)msg.obj;
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent  state=" + info.mState + " addr=" + info.mDevice.getAddress() + " prof=" + info.mProfile + " supprNoisy=" + info.mSupprNoisy + " vol=" + info.mVolume).printLog(AudioDeviceBroker.TAG));
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.setBluetoothA2dpDeviceConnectionState(info.mDevice, info.mState, info.mProfile, info.mSupprNoisy, 0, info.mVolume);
                        break;
                    }
                }
                case 28: {
                    HearingAidDeviceConnectionInfo info = (HearingAidDeviceConnectionInfo)msg.obj;
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("setHearingAidDeviceConnectionState state=" + info.mState + " addr=" + info.mDevice.getAddress() + " supprNoisy=" + info.mSupprNoisy + " src=" + info.mEventSource).printLog(AudioDeviceBroker.TAG));
                    Object object = AudioDeviceBroker.this.mDeviceStateLock;
                    synchronized (object) {
                        AudioDeviceBroker.this.mDeviceInventory.setBluetoothHearingAidDeviceConnectionState(info.mDevice, info.mState, info.mSupprNoisy, info.mMusicDevice);
                        break;
                    }
                }
                default: {
                    Log.wtf(AudioDeviceBroker.TAG, "Invalid message " + msg.what);
                }
            }
            if (AudioDeviceBroker.isMessageHandledUnderWakelock(msg.what)) {
                try {
                    AudioDeviceBroker.this.mBrokerEventWakeLock.release();
                }
                catch (Exception e) {
                    Log.e(AudioDeviceBroker.TAG, "Exception releasing wakelock", e);
                }
            }
        }
    }

    private class BrokerThread
    extends Thread {
        BrokerThread() {
            super("AudioDeviceBroker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioDeviceBroker audioDeviceBroker = AudioDeviceBroker.this;
            synchronized (audioDeviceBroker) {
                AudioDeviceBroker.this.mBrokerHandler = new BrokerHandler();
                AudioDeviceBroker.this.notify();
            }
            Looper.loop();
        }
    }

    private static final class HearingAidDeviceConnectionInfo {
        final BluetoothDevice mDevice;
        final int mState;
        final boolean mSupprNoisy;
        final int mMusicDevice;
        final String mEventSource;

        HearingAidDeviceConnectionInfo(BluetoothDevice device, int state, boolean suppressNoisyIntent, int musicDevice, String eventSource) {
            this.mDevice = device;
            this.mState = state;
            this.mSupprNoisy = suppressNoisyIntent;
            this.mMusicDevice = musicDevice;
            this.mEventSource = eventSource;
        }
    }

    private static final class BtDeviceConnectionInfo {
        final BluetoothDevice mDevice;
        final int mState;
        final int mProfile;
        final boolean mSupprNoisy;
        final int mVolume;

        BtDeviceConnectionInfo(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int vol) {
            this.mDevice = device;
            this.mState = state;
            this.mProfile = profile;
            this.mSupprNoisy = suppressNoisyIntent;
            this.mVolume = vol;
        }
    }
}

