/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioPort;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioRoutesObserver;
import android.os.Binder;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.audio.AudioDeviceBroker;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.AudioService;
import com.android.server.audio.AudioServiceEvents;
import com.android.server.audio.BtHelper;
import java.util.ArrayList;

public final class AudioDeviceInventory {
    private static final String TAG = "AS.AudioDeviceInventory";
    private final ArrayMap<String, DeviceInfo> mConnectedDevices = new ArrayMap();
    private final AudioDeviceBroker mDeviceBroker;
    private String mDockAddress;
    final AudioRoutesInfo mCurAudioRoutes = new AudioRoutesInfo();
    final RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers = new RemoteCallbackList();
    private static final int DEVICE_OVERRIDE_A2DP_ROUTE_ON_PLUG = 67264524;
    private int mBecomingNoisyIntentDevices = 201490316;
    private static final String CONNECT_INTENT_KEY_PORT_NAME = "portName";
    private static final String CONNECT_INTENT_KEY_STATE = "state";
    private static final String CONNECT_INTENT_KEY_ADDRESS = "address";
    private static final String CONNECT_INTENT_KEY_HAS_PLAYBACK = "hasPlayback";
    private static final String CONNECT_INTENT_KEY_HAS_CAPTURE = "hasCapture";
    private static final String CONNECT_INTENT_KEY_HAS_MIDI = "hasMIDI";
    private static final String CONNECT_INTENT_KEY_DEVICE_CLASS = "class";

    AudioDeviceInventory(AudioDeviceBroker broker) {
        this.mDeviceBroker = broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRestoreDevices() {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
                DeviceInfo di = this.mConnectedDevices.valueAt(i);
                AudioSystem.setDeviceConnectionState(di.mDeviceType, 1, di.mDeviceAddress, di.mDeviceName, di.mDeviceCodecFormat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    void onSetA2dpSinkConnectionState(BtHelper.BluetoothA2dpDeviceInfo btInfo, int state) {
        BluetoothDevice btDevice = btInfo.getBtDevice();
        int a2dpVolume = btInfo.getVolume();
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("A2DP sink connected: device addr=" + address + " state=" + state + " vol=" + a2dpVolume));
        int a2dpCodec = btInfo.getCodec();
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = DeviceInfo.makeDeviceListKey(128, btDevice.getAddress());
            DeviceInfo di = this.mConnectedDevices.get(key);
            boolean bl = isConnected = di != null;
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address, 8000);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address, di.mDeviceCodecFormat);
                }
            } else if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.mDeviceBroker.cancelA2dpDockTimeout();
                    this.mDockAddress = address;
                } else if (this.mDeviceBroker.hasScheduledA2dpDockTimeout() && this.mDockAddress != null) {
                    this.mDeviceBroker.cancelA2dpDockTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress, 0);
                }
                if (a2dpVolume != -1) {
                    this.mDeviceBroker.postSetVolumeIndexOnDevice(3, a2dpVolume * 10, 128, "onSetA2dpSinkConnectionState");
                }
                this.makeA2dpDeviceAvailable(address, BtHelper.getName(btDevice), "onSetA2dpSinkConnectionState", a2dpCodec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSetA2dpSourceConnectionState(BtHelper.BluetoothA2dpDeviceInfo btInfo, int state) {
        BluetoothDevice btDevice = btInfo.getBtDevice();
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = DeviceInfo.makeDeviceListKey(-2147352576, address);
            DeviceInfo di = this.mConnectedDevices.get(key);
            boolean bl = isConnected = di != null;
            if (isConnected && state != 2) {
                this.makeA2dpSrcUnavailable(address);
            } else if (!isConnected && state == 2) {
                this.makeA2dpSrcAvailable(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSetHearingAidConnectionState(BluetoothDevice btDevice, int state, int streamType) {
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("onSetHearingAidConnectionState addr=" + address));
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = DeviceInfo.makeDeviceListKey(0x8000000, btDevice.getAddress());
            DeviceInfo di = this.mConnectedDevices.get(key);
            boolean bl = isConnected = di != null;
            if (isConnected && state != 2) {
                this.makeHearingAidDeviceUnavailable(address);
            } else if (!isConnected && state == 2) {
                this.makeHearingAidDeviceAvailable(address, BtHelper.getName(btDevice), streamType, "onSetHearingAidConnectionState");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    void onBluetoothA2dpActiveDeviceChange(BtHelper.BluetoothA2dpDeviceInfo btInfo, int event) {
        BluetoothDevice btDevice = btInfo.getBtDevice();
        if (btDevice == null) {
            return;
        }
        int a2dpVolume = btInfo.getVolume();
        int a2dpCodec = btInfo.getCodec();
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("onBluetoothA2dpActiveDeviceChange addr=" + address + " event=" + BtHelper.a2dpDeviceEventToString(event)));
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (this.mDeviceBroker.hasScheduledA2dpSinkConnectionState(btDevice)) {
                AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("A2dp config change ignored"));
                return;
            }
            String key = DeviceInfo.makeDeviceListKey(128, address);
            DeviceInfo di = this.mConnectedDevices.get(key);
            if (di == null) {
                Log.e(TAG, "invalid null DeviceInfo in onBluetoothA2dpActiveDeviceChange");
                return;
            }
            if (event == 1) {
                if (a2dpVolume != -1) {
                    this.mDeviceBroker.postSetVolumeIndexOnDevice(3, a2dpVolume * 10, 128, "onBluetoothA2dpActiveDeviceChange");
                }
            } else if (event == 0 && di.mDeviceCodecFormat != a2dpCodec) {
                di.mDeviceCodecFormat = a2dpCodec;
                this.mConnectedDevices.replace(key, di);
            }
            if (AudioSystem.handleDeviceConfigChange(128, address, BtHelper.getName(btDevice), a2dpCodec) != 0) {
                int musicDevice = this.mDeviceBroker.getDeviceForStream(3);
                this.setBluetoothA2dpDeviceConnectionState(btDevice, 0, 2, false, musicDevice, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMakeA2dpDeviceUnavailableNow(String address, int a2dpCodec) {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            this.makeA2dpDeviceUnavailableNow(address, a2dpCodec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReportNewRoutes() {
        int n = this.mRoutesObservers.beginBroadcast();
        if (n > 0) {
            AudioRoutesInfo routes;
            AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
            synchronized (audioRoutesInfo) {
                routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            }
            while (n > 0) {
                IAudioRoutesObserver obs = this.mRoutesObservers.getBroadcastItem(--n);
                try {
                    obs.dispatchAudioRoutesChanged(routes);
                }
                catch (RemoteException remoteException) {}
            }
        }
        this.mRoutesObservers.finishBroadcast();
        this.mDeviceBroker.postObserveDevicesForAllStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSetWiredDeviceConnectionState(WiredDeviceConnectionState wdcs) {
        AudioService.sDeviceLogger.log(new AudioServiceEvents.WiredDevConnectEvent(wdcs));
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (wdcs.mState == 0 && (wdcs.mType & 0x402600C) != 0) {
                this.mDeviceBroker.setBluetoothA2dpOnInt(true, "onSetWiredDeviceConnectionState state DISCONNECTED");
            }
            if (!this.handleDeviceConnection(wdcs.mState == 1, wdcs.mType, wdcs.mAddress, wdcs.mName)) {
                return;
            }
            if (wdcs.mState != 0) {
                if ((wdcs.mType & 0x402600C) != 0) {
                    this.mDeviceBroker.setBluetoothA2dpOnInt(false, "onSetWiredDeviceConnectionState state not DISCONNECTED");
                }
                this.mDeviceBroker.checkMusicActive(wdcs.mType, wdcs.mCaller);
            }
            if (wdcs.mType == 1024) {
                this.mDeviceBroker.checkVolumeCecOnHdmiConnection(wdcs.mState, wdcs.mCaller);
            }
            this.sendDeviceConnectionIntent(wdcs.mType, wdcs.mState, wdcs.mAddress, wdcs.mName);
            this.updateAudioRoutes(wdcs.mType, wdcs.mState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onToggleHdmi() {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            String key = DeviceInfo.makeDeviceListKey(1024, "");
            DeviceInfo di = this.mConnectedDevices.get(key);
            if (di == null) {
                Log.e(TAG, "invalid null DeviceInfo in onToggleHdmi");
                return;
            }
            this.setWiredDeviceConnectionState(1024, 0, "", "", "android");
            this.setWiredDeviceConnectionState(1024, 1, "", "", "android");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleDeviceConnection(boolean connect, int device, String address, String deviceName) {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String deviceKey = DeviceInfo.makeDeviceListKey(device, address);
            DeviceInfo di = this.mConnectedDevices.get(deviceKey);
            boolean bl = isConnected = di != null;
            if (connect && !isConnected) {
                int res = AudioSystem.setDeviceConnectionState(device, 1, address, deviceName, 0);
                if (res != 0) {
                    Slog.e(TAG, "not connecting device 0x" + Integer.toHexString(device) + " due to command error " + res);
                    return false;
                }
                this.mConnectedDevices.put(deviceKey, new DeviceInfo(device, deviceName, address, 0));
                this.mDeviceBroker.postAccessoryPlugMediaUnmute(device);
                return true;
            }
            if (!connect && isConnected) {
                AudioSystem.setDeviceConnectionState(device, 0, address, deviceName, 0);
                this.mConnectedDevices.remove(deviceKey);
                return true;
            }
            Log.w(TAG, "handleDeviceConnection() failed, deviceKey=" + deviceKey + ", deviceSpec=" + di + ", connect=" + connect);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectA2dp() {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            ArraySet toRemove = new ArraySet();
            this.mConnectedDevices.values().forEach(deviceInfo -> {
                if (deviceInfo.mDeviceType == 128) {
                    toRemove.add(deviceInfo.mDeviceAddress);
                }
            });
            if (toRemove.size() > 0) {
                int delay = this.checkSendBecomingNoisyIntentInt(128, 0, 0);
                toRemove.stream().forEach(deviceAddress -> this.makeA2dpDeviceUnavailableLater((String)deviceAddress, delay));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectA2dpSink() {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            ArraySet toRemove = new ArraySet();
            this.mConnectedDevices.values().forEach(deviceInfo -> {
                if (deviceInfo.mDeviceType == -2147352576) {
                    toRemove.add(deviceInfo.mDeviceAddress);
                }
            });
            toRemove.stream().forEach(deviceAddress -> this.makeA2dpSrcUnavailable((String)deviceAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectHearingAid() {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            ArraySet toRemove = new ArraySet();
            this.mConnectedDevices.values().forEach(deviceInfo -> {
                if (deviceInfo.mDeviceType == 0x8000000) {
                    toRemove.add(deviceInfo.mDeviceAddress);
                }
            });
            if (toRemove.size() > 0) {
                int delay = this.checkSendBecomingNoisyIntentInt(0x8000000, 0, 0);
                toRemove.stream().forEach(deviceAddress -> this.makeHearingAidDeviceUnavailable((String)deviceAddress));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkSendBecomingNoisyIntent(int device, int state, int musicDevice) {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            return this.checkSendBecomingNoisyIntentInt(device, state, musicDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(observer);
            return routes;
        }
    }

    AudioRoutesInfo getCurAudioRoutes() {
        return this.mCurAudioRoutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    void setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int musicDevice, int a2dpVolume) {
        if (profile != 2 && profile != 11) {
            throw new IllegalArgumentException("invalid profile " + profile);
        }
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            int delay;
            if (profile == 2 && !suppressNoisyIntent) {
                int intState = state == 2 ? 1 : 0;
                delay = this.checkSendBecomingNoisyIntentInt(128, intState, musicDevice);
            } else {
                delay = 0;
            }
            int a2dpCodec = this.mDeviceBroker.getA2dpCodec(device);
            BtHelper.BluetoothA2dpDeviceInfo a2dpDeviceInfo = new BtHelper.BluetoothA2dpDeviceInfo(device, a2dpVolume, a2dpCodec);
            if (profile == 2) {
                if (delay == 0) {
                    this.onSetA2dpSinkConnectionState(a2dpDeviceInfo, state);
                } else {
                    this.mDeviceBroker.postA2dpSinkConnection(state, a2dpDeviceInfo, delay);
                }
            } else {
                this.mDeviceBroker.postA2dpSourceConnection(state, a2dpDeviceInfo, delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setWiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            int delay = this.checkSendBecomingNoisyIntentInt(type, state, 0);
            this.mDeviceBroker.postSetWiredDeviceConnectionState(new WiredDeviceConnectionState(type, state, address, name, caller), delay);
            return delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setBluetoothHearingAidDeviceConnectionState(BluetoothDevice device, int state, boolean suppressNoisyIntent, int musicDevice) {
        ArrayMap<String, DeviceInfo> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            int delay;
            if (!suppressNoisyIntent) {
                int intState = state == 2 ? 1 : 0;
                delay = this.checkSendBecomingNoisyIntentInt(0x8000000, intState, musicDevice);
            } else {
                delay = 0;
            }
            this.mDeviceBroker.postSetHearingAidConnectionState(state, device, delay);
            return delay;
        }
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeA2dpDeviceAvailable(String address, String name, String eventSource, int a2dpCodec) {
        this.mDeviceBroker.setBluetoothA2dpOnInt(true, eventSource);
        AudioSystem.setDeviceConnectionState(128, 1, address, name, a2dpCodec);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(DeviceInfo.makeDeviceListKey(128, address), new DeviceInfo(128, name, address, a2dpCodec));
        this.mDeviceBroker.postAccessoryPlugMediaUnmute(128);
        this.setCurrentAudioRouteNameIfPossible(name);
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeA2dpDeviceUnavailableNow(String address, int a2dpCodec) {
        if (address == null) {
            return;
        }
        this.mDeviceBroker.setAvrcpAbsoluteVolumeSupported(false);
        AudioSystem.setDeviceConnectionState(128, 0, address, "", a2dpCodec);
        this.mConnectedDevices.remove(DeviceInfo.makeDeviceListKey(128, address));
        this.setCurrentAudioRouteNameIfPossible(null);
        if (this.mDockAddress == address) {
            this.mDockAddress = null;
        }
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeA2dpDeviceUnavailableLater(String address, int delayMs) {
        AudioSystem.setParameters("A2dpSuspended=true");
        String deviceKey = DeviceInfo.makeDeviceListKey(128, address);
        DeviceInfo deviceInfo = this.mConnectedDevices.get(deviceKey);
        int a2dpCodec = deviceInfo != null ? deviceInfo.mDeviceCodecFormat : 0;
        this.mConnectedDevices.remove(deviceKey);
        this.mDeviceBroker.setA2dpDockTimeout(address, a2dpCodec, delayMs);
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeA2dpSrcAvailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 1, address, "", 0);
        this.mConnectedDevices.put(DeviceInfo.makeDeviceListKey(-2147352576, address), new DeviceInfo(-2147352576, "", address, 0));
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeA2dpSrcUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 0, address, "", 0);
        this.mConnectedDevices.remove(DeviceInfo.makeDeviceListKey(-2147352576, address));
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeHearingAidDeviceAvailable(String address, String name, int streamType, String eventSource) {
        int hearingAidVolIndex = this.mDeviceBroker.getVssVolumeForDevice(streamType, 0x8000000);
        this.mDeviceBroker.postSetHearingAidVolumeIndex(hearingAidVolIndex, streamType);
        AudioSystem.setDeviceConnectionState(0x8000000, 1, address, name, 0);
        this.mConnectedDevices.put(DeviceInfo.makeDeviceListKey(0x8000000, address), new DeviceInfo(0x8000000, name, address, 0));
        this.mDeviceBroker.postAccessoryPlugMediaUnmute(0x8000000);
        this.mDeviceBroker.postApplyVolumeOnDevice(streamType, 0x8000000, "makeHearingAidDeviceAvailable");
        this.setCurrentAudioRouteNameIfPossible(name);
    }

    @GuardedBy(value={"mConnectedDevices"})
    private void makeHearingAidDeviceUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(0x8000000, 0, address, "", 0);
        this.mConnectedDevices.remove(DeviceInfo.makeDeviceListKey(0x8000000, address));
        this.setCurrentAudioRouteNameIfPossible(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mConnectedDevices"})
    private void setCurrentAudioRouteNameIfPossible(String name) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (TextUtils.equals(this.mCurAudioRoutes.bluetoothName, name)) {
                return;
            }
            if (name != null || !this.isCurrentDeviceConnected()) {
                this.mCurAudioRoutes.bluetoothName = name;
                this.mDeviceBroker.postReportNewRoutes();
            }
        }
    }

    @GuardedBy(value={"mConnectedDevices"})
    private boolean isCurrentDeviceConnected() {
        return this.mConnectedDevices.values().stream().anyMatch(deviceInfo -> TextUtils.equals(deviceInfo.mDeviceName, this.mCurAudioRoutes.bluetoothName));
    }

    @GuardedBy(value={"mConnectedDevices"})
    private int checkSendBecomingNoisyIntentInt(int device, int state, int musicDevice) {
        if (state != 0) {
            return 0;
        }
        if ((device & this.mBecomingNoisyIntentDevices) == 0) {
            return 0;
        }
        int delay = 0;
        int devices = 0;
        for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
            int dev = this.mConnectedDevices.valueAt((int)i).mDeviceType;
            if ((dev & Integer.MIN_VALUE) != 0 || (dev & this.mBecomingNoisyIntentDevices) == 0) continue;
            devices |= dev;
        }
        if (musicDevice == 0) {
            musicDevice = this.mDeviceBroker.getDeviceForStream(3);
        }
        if ((device == musicDevice || this.mDeviceBroker.isInCommunication()) && device == devices && !this.mDeviceBroker.hasMediaDynamicPolicy() && (musicDevice & 0x8000) == 0) {
            if (!AudioSystem.isStreamActive(3, 0) && !this.mDeviceBroker.hasAudioFocusUsers()) {
                AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("dropping ACTION_AUDIO_BECOMING_NOISY").printLog(TAG));
                return 0;
            }
            this.mDeviceBroker.postBroadcastBecomingNoisy();
            delay = 1000;
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeviceConnectionIntent(int device, int state, String address, String deviceName) {
        Intent intent = new Intent();
        switch (device) {
            case 4: {
                intent.setAction("android.intent.action.HEADSET_PLUG");
                intent.putExtra("microphone", 1);
                break;
            }
            case 8: 
            case 131072: {
                intent.setAction("android.intent.action.HEADSET_PLUG");
                intent.putExtra("microphone", 0);
                break;
            }
            case 0x4000000: {
                intent.setAction("android.intent.action.HEADSET_PLUG");
                intent.putExtra("microphone", AudioSystem.getDeviceConnectionState(-2113929216, "") == 1 ? 1 : 0);
                break;
            }
            case -2113929216: {
                if (AudioSystem.getDeviceConnectionState(0x4000000, "") == 1) {
                    intent.setAction("android.intent.action.HEADSET_PLUG");
                    intent.putExtra("microphone", 1);
                    break;
                }
                return;
            }
            case 1024: 
            case 262144: {
                this.configureHdmiPlugIntent(intent, state);
            }
        }
        if (intent.getAction() == null) {
            return;
        }
        intent.putExtra(CONNECT_INTENT_KEY_STATE, state);
        intent.putExtra(CONNECT_INTENT_KEY_ADDRESS, address);
        intent.putExtra(CONNECT_INTENT_KEY_PORT_NAME, deviceName);
        intent.addFlags(0x40000000);
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManager.broadcastStickyIntent(intent, -2);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudioRoutes(int device, int state) {
        int connType = 0;
        switch (device) {
            case 4: {
                connType = 1;
                break;
            }
            case 8: 
            case 131072: {
                connType = 2;
                break;
            }
            case 1024: 
            case 262144: {
                connType = 8;
                break;
            }
            case 16384: 
            case 0x4000000: {
                connType = 16;
            }
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (connType == 0) {
                return;
            }
            int newConn = this.mCurAudioRoutes.mainType;
            newConn = state != 0 ? (newConn |= connType) : (newConn &= ~connType);
            if (newConn != this.mCurAudioRoutes.mainType) {
                this.mCurAudioRoutes.mainType = newConn;
                this.mDeviceBroker.postReportNewRoutes();
            }
        }
    }

    private void configureHdmiPlugIntent(Intent intent, int state) {
        intent.setAction("android.media.action.HDMI_AUDIO_PLUG");
        intent.putExtra("android.media.extra.AUDIO_PLUG_STATE", state);
        if (state != 1) {
            return;
        }
        ArrayList<AudioPort> ports = new ArrayList<AudioPort>();
        int[] portGeneration = new int[1];
        int status = AudioSystem.listAudioPorts(ports, portGeneration);
        if (status != 0) {
            Log.e(TAG, "listAudioPorts error " + status + " in configureHdmiPlugIntent");
            return;
        }
        for (AudioPort port : ports) {
            AudioDevicePort devicePort;
            if (!(port instanceof AudioDevicePort) || (devicePort = (AudioDevicePort)port).type() != 1024 && devicePort.type() != 262144) continue;
            int[] formats = AudioFormat.filterPublicFormats(devicePort.formats());
            if (formats.length > 0) {
                ArrayList<Integer> encodingList = new ArrayList<Integer>(1);
                for (int format : formats) {
                    if (format == 0) continue;
                    encodingList.add(format);
                }
                int[] encodingArray = encodingList.stream().mapToInt(i -> i).toArray();
                intent.putExtra("android.media.extra.ENCODINGS", encodingArray);
            }
            int maxChannels = 0;
            for (int mask : devicePort.channelMasks()) {
                int channelCount = AudioFormat.channelCountFromOutChannelMask(mask);
                if (channelCount <= maxChannels) continue;
                maxChannels = channelCount;
            }
            intent.putExtra("android.media.extra.MAX_CHANNEL_COUNT", maxChannels);
        }
    }

    class WiredDeviceConnectionState {
        public final int mType;
        public final int mState;
        public final String mAddress;
        public final String mName;
        public final String mCaller;

        WiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
            this.mType = type;
            this.mState = state;
            this.mAddress = address;
            this.mName = name;
            this.mCaller = caller;
        }
    }

    private static class DeviceInfo {
        final int mDeviceType;
        final String mDeviceName;
        final String mDeviceAddress;
        int mDeviceCodecFormat;

        DeviceInfo(int deviceType, String deviceName, String deviceAddress, int deviceCodecFormat) {
            this.mDeviceType = deviceType;
            this.mDeviceName = deviceName;
            this.mDeviceAddress = deviceAddress;
            this.mDeviceCodecFormat = deviceCodecFormat;
        }

        public String toString() {
            return "[DeviceInfo: type:0x" + Integer.toHexString(this.mDeviceType) + " name:" + this.mDeviceName + " addr:" + this.mDeviceAddress + " codec: " + Integer.toHexString(this.mDeviceCodecFormat) + "]";
        }

        private static String makeDeviceListKey(int device, String deviceAddress) {
            return "0x" + Integer.toHexString(device) + ":" + deviceAddress;
        }
    }
}

