/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IUidObserver;
import android.app.NotificationManager;
import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleManager;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiAudioSystemClient;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.media.AudioAttributes;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioServerStateDispatcher;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.PlayerBase;
import android.media.SoundPool;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.AudioProductStrategy;
import android.media.audiopolicy.AudioVolumeGroup;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.media.projection.IMediaProjectionManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.util.SparseIntArray;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.audio.AudioDeviceBroker;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.AudioServiceEvents;
import com.android.server.audio.MediaFocusControl;
import com.android.server.audio.PlaybackActivityMonitor;
import com.android.server.audio.RecordingActivityMonitor;
import com.android.server.audio.RotationHelper;
import com.android.server.pm.UserManagerService;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xmlpull.v1.XmlPullParserException;

public class AudioService
extends IAudioService.Stub
implements AccessibilityManager.TouchExplorationStateChangeListener,
AccessibilityManager.AccessibilityServicesStateChangeListener {
    private static final String TAG = "AS.AudioService";
    protected static final boolean DEBUG_MODE = false;
    protected static final boolean DEBUG_AP = false;
    protected static final boolean DEBUG_VOL = false;
    protected static final boolean DEBUG_DEVICES = false;
    private static final int PERSIST_DELAY = 500;
    private static final int UNMUTE_STREAM_DELAY = 350;
    private static final int FLAG_ADJUST_VOLUME = 1;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AppOpsManager mAppOps;
    private final int mPlatformType;
    private final boolean mIsSingleVolume;
    private final VolumeController mVolumeController = new VolumeController();
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_DEVICE_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_AUDIO_SERVER_DIED = 4;
    private static final int MSG_PLAY_SOUND_EFFECT = 5;
    private static final int MSG_LOAD_SOUND_EFFECTS = 7;
    private static final int MSG_SET_FORCE_USE = 8;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_SET_ALL_VOLUMES = 10;
    private static final int MSG_CHECK_MUSIC_ACTIVE = 11;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 12;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 13;
    private static final int MSG_PERSIST_SAFE_VOLUME_STATE = 14;
    private static final int MSG_UNLOAD_SOUND_EFFECTS = 15;
    private static final int MSG_SYSTEM_READY = 16;
    private static final int MSG_PERSIST_MUSIC_ACTIVE_MS = 17;
    private static final int MSG_UNMUTE_STREAM = 18;
    private static final int MSG_DYN_POLICY_MIX_STATE_UPDATE = 19;
    private static final int MSG_INDICATE_SYSTEM_READY = 20;
    private static final int MSG_ACCESSORY_PLUG_MEDIA_UNMUTE = 21;
    private static final int MSG_NOTIFY_VOL_EVENT = 22;
    private static final int MSG_DISPATCH_AUDIO_SERVER_STATE = 23;
    private static final int MSG_ENABLE_SURROUND_FORMATS = 24;
    private static final int MSG_UPDATE_RINGER_MODE = 25;
    private static final int MSG_SET_DEVICE_STREAM_VOLUME = 26;
    private static final int MSG_OBSERVE_DEVICES_FOR_ALL_STREAMS = 27;
    private static final int MSG_HDMI_VOLUME_CHECK = 28;
    private static final int MSG_PLAYBACK_CONFIG_CHANGE = 29;
    private static final int MSG_DISABLE_AUDIO_FOR_UID = 100;
    private static final int INDICATE_SYSTEM_READY_RETRY_DELAY_MS = 1000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode = 0;
    private final Object mSettingsLock = new Object();
    private SoundPool mSoundPool;
    private final Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final List<String> SOUND_EFFECT_FILES = new ArrayList<String>();
    private final int[][] SOUND_EFFECT_FILES_MAP = new int[10][2];
    protected static int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15, 15};
    protected static int[] MIN_STREAM_VOLUME = new int[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1};
    private final int[] STREAM_VOLUME_ALIAS_VOICE = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3, 3};
    private final int[] STREAM_VOLUME_ALIAS_TELEVISION = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private final int[] STREAM_VOLUME_ALIAS_DEFAULT = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3, 3};
    protected static int[] mStreamVolumeAlias;
    private static final int[] STREAM_VOLUME_OPS;
    private final boolean mUseFixedVolume;
    protected static final int DEFAULT_VOL_STREAM_NO_PLAYBACK = 3;
    private final AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        @Override
        public void onError(int error) {
            switch (error) {
                case 100: {
                    AudioService.this.mRecordMonitor.onAudioServerDied();
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 0);
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 23, 2, 0, 0, null, 0);
                    break;
                }
            }
        }
    };
    @GuardedBy(value={"mSettingsLock"})
    private int mRingerMode;
    @GuardedBy(value={"mSettingsLock"})
    private int mRingerModeExternal = -1;
    private int mRingerModeAffectedStreams = 0;
    private int mZenModeAffectedStreams = 0;
    private int mRingerAndZenModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private final boolean mHasVibrator;
    private Vibrator mVibrator;
    private static final AudioAttributes VIBRATION_ATTRIBUTES;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private IMediaProjectionManager mProjectionService;
    private final UserManagerInternal mUserManagerInternal;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final UserManagerInternal.UserRestrictionsListener mUserRestrictionsListener = new AudioServiceUserRestrictionsListener();
    @GuardedBy(value={"mDeviceBroker.mSetModeLock"})
    final ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private boolean mSystemReady;
    private boolean mUserSwitchedReceived;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper = null;
    private static int sSoundEffectVolumeDb;
    private int mPrevVolDirection = 0;
    private int mVolumeControlStream = -1;
    private boolean mUserSelectedVolumeControlStream = false;
    private final Object mForceControlStreamLock = new Object();
    private ForceControlStreamClient mForceControlStreamClient = null;
    private volatile IRingtonePlayer mRingtonePlayer;
    int mFixedVolumeDevices = 2890752;
    int mFullVolumeDevices = 0;
    int mAbsVolumeMultiModeCaseDevices = 0x8000000;
    private final boolean mMonitorRotation;
    private boolean mDockAudioMediaEnabled = true;
    private int mDockState = 0;
    private StreamVolumeCommand mPendingVolumeCommand;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private final MediaFocusControl mMediaFocusControl;
    private float[] mPrescaleAbsoluteVolume = new float[]{0.5f, 0.7f, 0.85f};
    private NotificationManager mNm;
    private AudioManagerInternal.RingerModeDelegate mRingerModeDelegate;
    private VolumePolicy mVolumePolicy = VolumePolicy.DEFAULT;
    private long mLoweredFromNormalToVibrateTime;
    private int[] mAccessibilityServiceUids;
    private final Object mAccessibilityServiceUidsLock = new Object();
    private int mEncodedSurroundMode;
    private String mEnabledSurroundFormats;
    private boolean mSurroundModeChanged;
    @GuardedBy(value={"mSettingsLock"})
    private int mAssistantUid;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            this.disableAudioForUid(false, uid);
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
            this.disableAudioForUid(cached, uid);
        }

        private void disableAudioForUid(boolean disable, int uid) {
            AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 100, disable ? 1 : 0, uid, null, 0);
        }
    };
    RoleObserver mRoleObserver;
    private AtomicBoolean mVoiceActive = new AtomicBoolean(false);
    private final IPlaybackConfigDispatcher mVoiceActivityMonitor = new IPlaybackConfigDispatcher.Stub(){

        @Override
        public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) {
            AudioService.sendMsg(AudioService.this.mAudioHandler, 29, 0, 0, 0, configs, 0);
        }
    };
    private int mRmtSbmxFullVolRefCount = 0;
    private ArrayList<RmtSbmxFullVolDeathHandler> mRmtSbmxFullVolDeathHandlers = new ArrayList();
    private static final String TAG_AUDIO_ASSETS = "audio_assets";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_GROUP = "group";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String TAG_ASSET = "asset";
    private static final String ATTR_ASSET_ID = "id";
    private static final String ATTR_ASSET_FILE = "file";
    private static final String ASSET_FILE_VERSION = "1.0";
    private static final String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static final int SOUND_EFFECTS_LOAD_TIMEOUT_MS = 5000;
    static final int CONNECTION_STATE_DISCONNECTED = 0;
    static final int CONNECTION_STATE_CONNECTED = 1;
    private static final int DEVICE_MEDIA_UNMUTED_ON_PLUG = 67266444;
    private static final int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private static final int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private static final int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private static final int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private int mSafeMediaVolumeState;
    private final Object mSafeMediaVolumeStateLock = new Object();
    private int mMcc = 0;
    private int mSafeMediaVolumeIndex;
    private float mSafeUsbMediaVolumeDbfs;
    private int mSafeUsbMediaVolumeIndex;
    final int mSafeMediaVolumeDevices = 0x400000C;
    private int mMusicActiveMs;
    private static final int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static final int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static final int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private final Object mHdmiClientLock = new Object();
    private boolean mHdmiSystemAudioSupported = false;
    @GuardedBy(value={"mHdmiClientLock"})
    private HdmiTvClient mHdmiTvClient;
    @GuardedBy(value={"mHdmiClientLock"})
    private HdmiControlManager mHdmiManager;
    @GuardedBy(value={"mHdmiClientLock"})
    private HdmiPlaybackClient mHdmiPlaybackClient;
    private boolean mHdmiCecSink;
    @GuardedBy(value={"mHdmiClientLock"})
    private HdmiAudioSystemClient mHdmiAudioSystemClient;
    private MyDisplayStatusCallback mHdmiDisplayStatusCallback = new MyDisplayStatusCallback();
    private static final int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 0;
    private static final int TOUCH_EXPLORE_STREAM_TYPE_OVERRIDE_DELAY_MS = 1000;
    private static int sStreamOverrideDelayMs;
    private static boolean sIndependentA11yVolume;
    @GuardedBy(value={"mSettingsLock"})
    private boolean mCameraSoundForced;
    static final int LOG_NB_EVENTS_PHONE_STATE = 20;
    static final int LOG_NB_EVENTS_DEVICE_CONNECTION = 30;
    static final int LOG_NB_EVENTS_FORCE_USE = 20;
    static final int LOG_NB_EVENTS_VOLUME = 40;
    static final int LOG_NB_EVENTS_DYN_POLICY = 10;
    private final AudioEventLogger mModeLogger = new AudioEventLogger(20, "phone state (logged after successfull call to AudioSystem.setPhoneState(int))");
    static final AudioEventLogger sDeviceLogger;
    static final AudioEventLogger sForceUseLogger;
    static final AudioEventLogger sVolumeLogger;
    private final AudioEventLogger mDynPolicyLogger = new AudioEventLogger(10, "dynamic policy events (logged when command received by AudioService)");
    private static final String[] RINGER_MODE_NAMES;
    private final Object mExtVolumeControllerLock = new Object();
    private IAudioPolicyCallback mExtVolumeController;
    private final AudioSystem.DynamicPolicyCallback mDynPolicyCallback = new AudioSystem.DynamicPolicyCallback(){

        @Override
        public void onDynamicPolicyMixStateUpdate(String regId, int state) {
            if (!TextUtils.isEmpty(regId)) {
                AudioService.sendMsg(AudioService.this.mAudioHandler, 19, 2, state, 0, regId, 0);
            }
        }
    };
    private final RecordingActivityMonitor mRecordMonitor;
    private final PlaybackActivityMonitor mPlaybackMonitor;
    private final AudioDeviceBroker mDeviceBroker;
    private HashMap<IBinder, AsdProxy> mAudioServerStateListeners = new HashMap();
    private final HashMap<IBinder, AudioPolicyProxy> mAudioPolicies = new HashMap();
    @GuardedBy(value={"mAudioPolicies"})
    private int mAudioPolicyCounter = 0;

    private boolean isPlatformVoice() {
        return this.mPlatformType == 1;
    }

    boolean isPlatformTelevision() {
        return this.mPlatformType == 2;
    }

    boolean isPlatformAutomotive() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
    }

    int getVssVolumeForDevice(int stream, int device) {
        return this.mStreamStates[stream].getIndex(device);
    }

    public static String makeAlsaAddressString(int card, int device) {
        return "card=" + card + ";device=" + device + ";";
    }

    public AudioService(Context context) {
        int defaultSystemVolume;
        int defaultAlarmVolume;
        int defaultMusicVolume;
        int defaultCallVolume;
        int maxCallVolume;
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mPlatformType = AudioSystem.getPlatformType(context);
        this.mIsSingleVolume = AudioSystem.isSingleVolume(context);
        this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mAudioEventWakeLock = pm.newWakeLock(1, "handleAudioEvent");
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        boolean bl = this.mHasVibrator = this.mVibrator == null ? false : this.mVibrator.hasVibrator();
        if (AudioProductStrategy.getAudioProductStrategies().size() > 0) {
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                int minVolume;
                AudioAttributes attr2 = AudioProductStrategy.getAudioAttributesForStrategyWithLegacyStreamType(streamType);
                int maxVolume = AudioSystem.getMaxVolumeIndexForAttributes(attr2);
                if (maxVolume != -1) {
                    AudioService.MAX_STREAM_VOLUME[streamType] = maxVolume;
                }
                if ((minVolume = AudioSystem.getMinVolumeIndexForAttributes(attr2)) == -1) continue;
                AudioService.MIN_STREAM_VOLUME[streamType] = minVolume;
            }
        }
        if ((maxCallVolume = SystemProperties.getInt("ro.config.vc_call_vol_steps", -1)) != -1) {
            AudioService.MAX_STREAM_VOLUME[0] = maxCallVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[0] = (defaultCallVolume = SystemProperties.getInt("ro.config.vc_call_vol_default", -1)) != -1 && defaultCallVolume <= MAX_STREAM_VOLUME[0] && defaultCallVolume >= MIN_STREAM_VOLUME[0] ? defaultCallVolume : maxCallVolume * 3 / 4;
        int maxMusicVolume = SystemProperties.getInt("ro.config.media_vol_steps", -1);
        if (maxMusicVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[3] = maxMusicVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[3] = (defaultMusicVolume = SystemProperties.getInt("ro.config.media_vol_default", -1)) != -1 && defaultMusicVolume <= MAX_STREAM_VOLUME[3] && defaultMusicVolume >= MIN_STREAM_VOLUME[3] ? defaultMusicVolume : (this.isPlatformTelevision() ? MAX_STREAM_VOLUME[3] / 4 : MAX_STREAM_VOLUME[3] / 3);
        int maxAlarmVolume = SystemProperties.getInt("ro.config.alarm_vol_steps", -1);
        if (maxAlarmVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[4] = maxAlarmVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[4] = (defaultAlarmVolume = SystemProperties.getInt("ro.config.alarm_vol_default", -1)) != -1 && defaultAlarmVolume <= MAX_STREAM_VOLUME[4] ? defaultAlarmVolume : 6 * MAX_STREAM_VOLUME[4] / 7;
        int maxSystemVolume = SystemProperties.getInt("ro.config.system_vol_steps", -1);
        if (maxSystemVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[1] = maxSystemVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[1] = (defaultSystemVolume = SystemProperties.getInt("ro.config.system_vol_default", -1)) != -1 && defaultSystemVolume <= MAX_STREAM_VOLUME[1] ? defaultSystemVolume : MAX_STREAM_VOLUME[1];
        sSoundEffectVolumeDb = context.getResources().getInteger(17694893);
        this.createAudioSystemThread();
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean cameraSoundForced = this.readCameraSoundForced();
        this.mCameraSoundForced = new Boolean(cameraSoundForced);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, new String("AudioService ctor"), 0);
        this.mSafeMediaVolumeState = Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0);
        this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694877) * 10;
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17891558);
        this.mDeviceBroker = new AudioDeviceBroker(this.mContext, this);
        this.updateStreamVolumeAlias(false, TAG);
        this.readPersistedSettings();
        this.readUserRestrictions();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        this.mSafeUsbMediaVolumeIndex = this.getSafeUsbMediaVolumeIndex();
        this.mPlaybackMonitor = new PlaybackActivityMonitor(context, MAX_STREAM_VOLUME[4]);
        this.mMediaFocusControl = new MediaFocusControl(this.mContext, this.mPlaybackMonitor);
        this.mRecordMonitor = new RecordingActivityMonitor(this.mContext);
        AudioService.readAndSetLowRamDevice();
        this.mRingerAndZenModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_BACKGROUND");
        intentFilter.addAction("android.intent.action.USER_FOREGROUND");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            RotationHelper.init(this.mContext, this.mAudioHandler);
        }
        intentFilter.addAction("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION");
        intentFilter.addAction("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, intentFilter, null, null);
        LocalServices.addService(AudioManagerInternal.class, new AudioServiceInternal());
        this.mUserManagerInternal.addUserRestrictionsListener(this.mUserRestrictionsListener);
        this.mRecordMonitor.initMonitor();
        float[] preScale = new float[]{this.mContext.getResources().getFraction(0x1130003, 1, 1), this.mContext.getResources().getFraction(18022404, 1, 1), this.mContext.getResources().getFraction(18022405, 1, 1)};
        for (int i = 0; i < preScale.length; ++i) {
            if (!(0.0f <= preScale[i]) || !(preScale[i] <= 1.0f)) continue;
            this.mPrescaleAbsoluteVolume[i] = preScale[i];
        }
    }

    public void systemReady() {
        AudioService.sendMsg(this.mAudioHandler, 16, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSystemReady() {
        this.mSystemReady = true;
        this.scheduleLoadSoundEffects();
        this.mDeviceBroker.onSystemReady();
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.hdmi.cec")) {
            Object object = this.mHdmiClientLock;
            synchronized (object) {
                this.mHdmiManager = this.mContext.getSystemService(HdmiControlManager.class);
                this.mHdmiTvClient = this.mHdmiManager.getTvClient();
                if (this.mHdmiTvClient != null) {
                    this.mFixedVolumeDevices &= 0xFFD3FFFD;
                }
                this.mHdmiPlaybackClient = this.mHdmiManager.getPlaybackClient();
                if (this.mHdmiPlaybackClient != null) {
                    this.mFixedVolumeDevices &= 0xFFFFFBFF;
                    this.mFullVolumeDevices |= 0x400;
                }
                this.mHdmiCecSink = false;
                this.mHdmiAudioSystemClient = this.mHdmiManager.getAudioSystemClient();
            }
        }
        this.mNm = (NotificationManager)this.mContext.getSystemService("notification");
        AudioService.sendMsg(this.mAudioHandler, 13, 0, 0, 0, TAG, SystemProperties.getBoolean("audio.safemedia.bypass", false) ? 0 : 30000);
        this.initA11yMonitoring();
        this.mRoleObserver = new RoleObserver();
        this.mRoleObserver.register();
        this.onIndicateSystemReady();
    }

    void onIndicateSystemReady() {
        if (AudioSystem.systemReady() == 0) {
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 20, 0, 0, 0, null, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAudioServerDied() {
        int forSys;
        if (!this.mSystemReady || AudioSystem.checkAudioFlinger() != 0) {
            Log.e(TAG, "Audioserver died.");
            AudioService.sendMsg(this.mAudioHandler, 4, 1, 0, 0, null, 500);
            return;
        }
        Log.e(TAG, "Audioserver started.");
        AudioSystem.setParameters("restarting=true");
        AudioService.readAndSetLowRamDevice();
        this.mDeviceBroker.onAudioServerDied();
        if (AudioSystem.setPhoneState(this.mMode) == 0) {
            this.mModeLogger.log(new AudioEventLogger.StringEvent("onAudioServerDied causes setPhoneState(" + AudioSystem.modeToString(this.mMode) + ")"));
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            forSys = this.mCameraSoundForced ? 11 : 0;
        }
        this.mDeviceBroker.setForceUse_Async(4, forSys, "onAudioServerDied");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            AudioSystem.initStreamVolume(streamType, streamState.mIndexMin / 10, streamState.mIndexMax / 10);
            streamState.applyAllVolumes();
        }
        this.updateMasterMono(this.mContentResolver);
        this.updateMasterBalance(this.mContentResolver);
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        if (this.mMonitorRotation) {
            RotationHelper.updateOrientation();
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mSettingsLock;
        synchronized (hashMap) {
            int forDock = this.mDockAudioMediaEnabled ? 8 : 0;
            this.mDeviceBroker.setForceUse_Async(3, forDock, "onAudioServerDied");
            this.sendEncodedSurroundMode(this.mContentResolver, "onAudioServerDied");
            this.sendEnabledSurroundFormats(this.mContentResolver, true);
            this.updateAssistantUId(true);
            this.updateRttEanbled(this.mContentResolver);
        }
        hashMap = this.mAccessibilityServiceUidsLock;
        synchronized (hashMap) {
            AudioSystem.setA11yServicesUids(this.mAccessibilityServiceUids);
        }
        hashMap = this.mHdmiClientLock;
        synchronized (hashMap) {
            if (this.mHdmiManager != null && this.mHdmiTvClient != null) {
                this.setHdmiSystemAudioSupported(this.mHdmiSystemAudioSupported);
            }
        }
        hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                policy.connectMixes();
            }
        }
        this.onIndicateSystemReady();
        AudioSystem.setParameters("restarting=false");
        AudioService.sendMsg(this.mAudioHandler, 23, 2, 1, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchAudioServerStateChange(boolean state) {
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            for (AsdProxy asdp : this.mAudioServerStateListeners.values()) {
                try {
                    asdp.callback().dispatchAudioServerStateChange(state);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Could not call dispatchAudioServerStateChange()", e);
                }
            }
        }
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    @Override
    public List<AudioProductStrategy> getAudioProductStrategies() {
        return AudioProductStrategy.getAudioProductStrategies();
    }

    @Override
    public List<AudioVolumeGroup> getAudioVolumeGroups() {
        return AudioVolumeGroup.getAudioVolumeGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllAliasStreamVolumes() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
                    this.mStreamStates[streamType].setAllIndexes(this.mStreamStates[mStreamVolumeAlias[streamType]], TAG);
                    if (this.mStreamStates[streamType].mIsMuted) continue;
                    this.mStreamStates[streamType].applyAllVolumes();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    void postCheckVolumeCecOnHdmiConnection(int state, String caller) {
        AudioService.sendMsg(this.mAudioHandler, 28, 0, state, 0, caller, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCheckVolumeCecOnHdmiConnection(int state, String caller) {
        if (state == 1) {
            if (this.isPlatformTelevision()) {
                this.checkAddAllFixedVolumeDevices(1024, caller);
                Object object = this.mHdmiClientLock;
                synchronized (object) {
                    if (this.mHdmiManager != null && this.mHdmiPlaybackClient != null) {
                        this.mHdmiCecSink = false;
                        this.mHdmiPlaybackClient.queryDisplayStatus(this.mHdmiDisplayStatusCallback);
                    }
                }
            }
            this.sendEnabledSurroundFormats(this.mContentResolver, true);
        } else if (this.isPlatformTelevision()) {
            Object object = this.mHdmiClientLock;
            synchronized (object) {
                if (this.mHdmiManager != null) {
                    this.mHdmiCecSink = false;
                }
            }
        }
    }

    private void checkAddAllFixedVolumeDevices(int device, String caller) {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            if (!this.mStreamStates[streamType].hasIndexForDevice(device)) {
                this.mStreamStates[streamType].setIndex(this.mStreamStates[mStreamVolumeAlias[streamType]].getIndex(0x40000000), device, caller);
            }
            this.mStreamStates[streamType].checkFixedVolumeDevices();
        }
    }

    private void checkAllFixedVolumeDevices() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            this.mStreamStates[streamType].checkFixedVolumeDevices();
        }
    }

    private void checkAllFixedVolumeDevices(int streamType) {
        this.mStreamStates[streamType].checkFixedVolumeDevices();
    }

    private void checkMuteAffectedStreams() {
        for (int i = 0; i < this.mStreamStates.length; ++i) {
            VolumeStreamState vss = this.mStreamStates[i];
            if (vss.mIndexMin <= 0 || vss.mStreamType == 0 || vss.mStreamType == 6) continue;
            this.mMuteAffectedStreams &= ~(1 << vss.mStreamType);
        }
    }

    private void createStreamStates() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS_INT[mStreamVolumeAlias[i]], i);
        }
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        this.checkMuteAffectedStreams();
        this.updateDefaultVolumes();
    }

    private void updateDefaultVolumes() {
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (stream == mStreamVolumeAlias[stream]) continue;
            AudioSystem.DEFAULT_STREAM_VOLUME[stream] = this.rescaleIndex(AudioSystem.DEFAULT_STREAM_VOLUME[mStreamVolumeAlias[stream]], mStreamVolumeAlias[stream], stream);
        }
    }

    private void dumpStreamStates(PrintWriter pw) {
        pw.println("\nStream volumes (device: index)");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < numStreamTypes; ++i) {
            pw.println("- " + AudioSystem.STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(pw);
            pw.println("");
        }
        pw.print("\n- mute affected streams = 0x");
        pw.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateStreamVolumeAlias(boolean updateVolumes, String caller) {
        int dtmfStreamAlias;
        int a11yStreamAlias;
        int n = a11yStreamAlias = sIndependentA11yVolume ? 10 : 3;
        if (this.mIsSingleVolume) {
            mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_TELEVISION;
            dtmfStreamAlias = 3;
        } else {
            switch (this.mPlatformType) {
                case 1: {
                    mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_VOICE;
                    dtmfStreamAlias = 2;
                    break;
                }
                default: {
                    mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_DEFAULT;
                    dtmfStreamAlias = 3;
                }
            }
        }
        if (this.mIsSingleVolume) {
            this.mRingerModeAffectedStreams = 0;
        } else if (this.isInCommunication()) {
            dtmfStreamAlias = 0;
            this.mRingerModeAffectedStreams &= 0xFFFFFEFF;
        } else {
            this.mRingerModeAffectedStreams |= 0x100;
        }
        AudioService.mStreamVolumeAlias[8] = dtmfStreamAlias;
        AudioService.mStreamVolumeAlias[10] = a11yStreamAlias;
        if (!updateVolumes || this.mStreamStates == null) return;
        this.updateDefaultVolumes();
        Object object = this.mSettingsLock;
        synchronized (object) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                this.mStreamStates[8].setAllIndexes(this.mStreamStates[dtmfStreamAlias], caller);
                this.mStreamStates[10].mVolumeIndexSettingName = Settings.System.VOLUME_SETTINGS_INT[a11yStreamAlias];
                this.mStreamStates[10].setAllIndexes(this.mStreamStates[a11yStreamAlias], caller);
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
        {
            if (sIndependentA11yVolume) {
                this.mStreamStates[10].readSettings();
            }
            this.setRingerModeInt(this.getRingerModeInternal(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[10], 0);
            return;
        }
    }

    private void readDockAudioSettings(ContentResolver cr) {
        this.mDockAudioMediaEnabled = Settings.Global.getInt(cr, "dock_audio_media_enabled", 0) == 1;
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 3, this.mDockAudioMediaEnabled ? 8 : 0, new String("readDockAudioSettings"), 0);
    }

    private void updateMasterMono(ContentResolver cr) {
        boolean masterMono = Settings.System.getIntForUser(cr, "master_mono", 0, -2) == 1;
        AudioSystem.setMasterMono(masterMono);
    }

    private void updateMasterBalance(ContentResolver cr) {
        float masterBalance = Settings.System.getFloatForUser(cr, "master_balance", 0.0f, -2);
        if (AudioSystem.setMasterBalance(masterBalance) != 0) {
            Log.e(TAG, String.format("setMasterBalance failed for %f", Float.valueOf(masterBalance)));
        }
    }

    private void sendEncodedSurroundMode(ContentResolver cr, String eventSource) {
        int encodedSurroundMode = Settings.Global.getInt(cr, "encoded_surround_output", 0);
        this.sendEncodedSurroundMode(encodedSurroundMode, eventSource);
    }

    private void sendEncodedSurroundMode(int encodedSurroundMode, String eventSource) {
        int forceSetting = 16;
        switch (encodedSurroundMode) {
            case 0: {
                forceSetting = 0;
                break;
            }
            case 1: {
                forceSetting = 13;
                break;
            }
            case 2: {
                forceSetting = 14;
                break;
            }
            case 3: {
                forceSetting = 15;
                break;
            }
            default: {
                Log.e(TAG, "updateSurroundSoundSettings: illegal value " + encodedSurroundMode);
            }
        }
        if (forceSetting != 16) {
            this.mDeviceBroker.setForceUse_Async(6, forceSetting, eventSource);
        }
    }

    private void sendEnabledSurroundFormats(ContentResolver cr, boolean forceUpdate) {
        if (this.mEncodedSurroundMode != 3) {
            return;
        }
        String enabledSurroundFormats = Settings.Global.getString(cr, "encoded_surround_output_enabled_formats");
        if (enabledSurroundFormats == null) {
            enabledSurroundFormats = "";
        }
        if (!forceUpdate && TextUtils.equals(enabledSurroundFormats, this.mEnabledSurroundFormats)) {
            return;
        }
        this.mEnabledSurroundFormats = enabledSurroundFormats;
        String[] surroundFormats = TextUtils.split(enabledSurroundFormats, ",");
        ArrayList<Integer> formats = new ArrayList<Integer>();
        for (String format : surroundFormats) {
            try {
                int audioFormat = Integer.valueOf(format);
                boolean isSurroundFormat = false;
                for (int sf : AudioFormat.SURROUND_SOUND_ENCODING) {
                    if (sf != audioFormat) continue;
                    isSurroundFormat = true;
                    break;
                }
                if (!isSurroundFormat || formats.contains(audioFormat)) continue;
                formats.add(audioFormat);
            }
            catch (Exception e) {
                Log.e(TAG, "Invalid enabled surround format:" + format);
            }
        }
        Settings.Global.putString(this.mContext.getContentResolver(), "encoded_surround_output_enabled_formats", TextUtils.join((CharSequence)",", formats));
        AudioService.sendMsg(this.mAudioHandler, 24, 2, 0, 0, formats, 0);
    }

    private void onEnableSurroundFormats(ArrayList<Integer> enabledSurroundFormats) {
        for (int surroundFormat : AudioFormat.SURROUND_SOUND_ENCODING) {
            boolean enabled = enabledSurroundFormats.contains(surroundFormat);
            int ret = AudioSystem.setSurroundFormatEnabled(surroundFormat, enabled);
            Log.i(TAG, "enable surround format:" + surroundFormat + " " + enabled + " " + ret);
        }
    }

    @GuardedBy(value={"mSettingsLock"})
    private void updateAssistantUId(boolean forceUpdate) {
        PackageManager pm;
        int assistantUid = 0;
        String packageName = "";
        if (this.mRoleObserver != null) {
            packageName = this.mRoleObserver.getAssistantRoleHolder();
        }
        if (TextUtils.isEmpty(packageName)) {
            String assistantName = Settings.Secure.getStringForUser(this.mContentResolver, "voice_interaction_service", -2);
            if (TextUtils.isEmpty(assistantName)) {
                assistantName = Settings.Secure.getStringForUser(this.mContentResolver, "assistant", -2);
            }
            if (!TextUtils.isEmpty(assistantName)) {
                ComponentName componentName = ComponentName.unflattenFromString(assistantName);
                if (componentName == null) {
                    Slog.w(TAG, "Invalid service name for voice_interaction_service: " + assistantName);
                    return;
                }
                packageName = componentName.getPackageName();
            }
        }
        if (!TextUtils.isEmpty(packageName) && (pm = this.mContext.getPackageManager()).checkPermission("android.permission.CAPTURE_AUDIO_HOTWORD", packageName) == 0) {
            try {
                assistantUid = pm.getPackageUid(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "updateAssistantUId() could not find UID for package: " + packageName);
            }
        }
        if (assistantUid != this.mAssistantUid || forceUpdate) {
            AudioSystem.setAssistantUid(assistantUid);
            this.mAssistantUid = assistantUid;
        }
    }

    private void updateRttEanbled(ContentResolver cr) {
        boolean rttEnabled = Settings.Secure.getIntForUser(cr, "rtt_calling_mode", 0, -2) != 0;
        AudioSystem.setRttEnabled(rttEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistedSettings() {
        ContentResolver cr = this.mContentResolver;
        int ringerModeFromSettings = Settings.Global.getInt(cr, "mode_ringer", 2);
        int ringerMode = ringerModeFromSettings;
        if (!this.isValidRingerMode(ringerMode)) {
            ringerMode = 2;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != ringerModeFromSettings) {
            Settings.Global.putInt(cr, "mode_ringer", ringerMode);
        }
        if (this.mUseFixedVolume || this.mIsSingleVolume) {
            ringerMode = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
            if (this.mRingerModeExternal == -1) {
                this.mRingerModeExternal = this.mRingerMode;
            }
            this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(0, 1, this.mHasVibrator ? 2 : 0);
            this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(this.mVibrateSetting, 0, this.mHasVibrator ? 2 : 0);
            this.updateRingerAndZenModeAffectedStreams();
            this.readDockAudioSettings(cr);
            this.sendEncodedSurroundMode(cr, "readPersistedSettings");
            this.sendEnabledSurroundFormats(cr, true);
            this.updateAssistantUId(true);
            this.updateRttEanbled(cr);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(cr, "mute_streams_affected", 111, -2);
        this.updateMasterMono(cr);
        this.updateMasterBalance(cr);
        this.broadcastRingerMode("android.media.RINGER_MODE_CHANGED", this.mRingerModeExternal);
        this.broadcastRingerMode("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", this.mRingerMode);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mVolumeController.loadSettings(cr);
    }

    private void readUserRestrictions() {
        boolean masterMute;
        int currentUser = this.getCurrentUserId();
        boolean bl = masterMute = this.mUserManagerInternal.getUserRestriction(currentUser, "disallow_unmute_device") || this.mUserManagerInternal.getUserRestriction(currentUser, "no_adjust_volume");
        if (this.mUseFixedVolume) {
            masterMute = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        this.setSystemAudioMute(masterMute);
        AudioSystem.setMasterMute(masterMute);
        this.broadcastMasterMuteStatus(masterMute);
        boolean microphoneMute = this.mUserManagerInternal.getUserRestriction(currentUser, "no_unmute_microphone");
        AudioSystem.muteMicrophone(microphoneMute);
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        int srcRange = this.mStreamStates[srcStream].getMaxIndex() - this.mStreamStates[srcStream].getMinIndex();
        int dstRange = this.mStreamStates[dstStream].getMaxIndex() - this.mStreamStates[dstStream].getMinIndex();
        if (srcRange == 0) {
            Log.e(TAG, "rescaleIndex : index range should not be zero");
            return this.mStreamStates[dstStream].getMinIndex();
        }
        return this.mStreamStates[dstStream].getMinIndex() + ((index - this.mStreamStates[srcStream].getMinIndex()) * dstRange + srcRange / 2) / srcRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, String caller) {
        IAudioPolicyCallback extVolCtlr;
        Object object = this.mExtVolumeControllerLock;
        synchronized (object) {
            extVolCtlr = this.mExtVolumeController;
        }
        if (extVolCtlr != null) {
            AudioService.sendMsg(this.mAudioHandler, 22, 2, direction, 0, extVolCtlr, 0);
        } else {
            this.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags, callingPackage, caller, Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, String caller, int uid) {
        int streamType;
        if (direction != 0) {
            sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(0, suggestedStreamType, direction, flags, callingPackage + "/" + caller + " uid:" + uid));
        }
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            if (this.mUserSelectedVolumeControlStream) {
                streamType = this.mVolumeControlStream;
            } else {
                int maybeActiveStreamType = this.getActiveStreamType(suggestedStreamType);
                boolean activeForReal = maybeActiveStreamType == 2 || maybeActiveStreamType == 5 ? this.wasStreamActiveRecently(maybeActiveStreamType, 0) : AudioSystem.isStreamActive(maybeActiveStreamType, 0);
                streamType = activeForReal || this.mVolumeControlStream == -1 ? maybeActiveStreamType : this.mVolumeControlStream;
            }
        }
        boolean isMute = this.isMuteAdjust(direction);
        this.ensureValidStreamType(streamType);
        int resolvedStream = mStreamVolumeAlias[streamType];
        if ((flags & 4) != 0 && resolvedStream != 2) {
            flags &= 0xFFFFFFFB;
        }
        if (this.mVolumeController.suppressAdjustment(resolvedStream, flags, isMute) && !this.mIsSingleVolume) {
            direction = 0;
            flags &= 0xFFFFFFFB;
            flags &= 0xFFFFFFEF;
        }
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, caller, uid);
    }

    @Override
    public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) {
        if (streamType == 10 && !this.canChangeAccessibilityVolume()) {
            Log.w(TAG, "Trying to call adjustStreamVolume() for a11y withoutCHANGE_ACCESSIBILITY_VOLUME / callingPackage=" + callingPackage);
            return;
        }
        sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(1, streamType, direction, flags, callingPackage));
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage, String caller, int uid) {
        int step;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        boolean isMuteAdjust = this.isMuteAdjust(direction);
        if (isMuteAdjust && !this.isStreamAffectedByMute(streamType)) {
            return;
        }
        if (isMuteAdjust && (streamType == 0 || streamType == 6) && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: adjustStreamVolume from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        int streamTypeAlias = mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamTypeAlias);
        int aliasIndex = streamState.getIndex(device);
        boolean adjustVolume = true;
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (uid == 1000) {
            uid = UserHandle.getUid(this.getCurrentUserId(), UserHandle.getAppId(uid));
        }
        if (this.mAppOps.noteOp(STREAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            this.mPendingVolumeCommand = null;
        }
        flags &= 0xFFFFFFDF;
        if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
            flags |= 0x20;
            step = this.mSafeMediaVolumeState == 3 && (device & 0x400000C) != 0 ? this.safeMediaVolumeIndex(device) : streamState.getMaxIndex();
            if (aliasIndex != 0) {
                aliasIndex = step;
            }
        } else {
            step = this.rescaleIndex(10, streamType, streamTypeAlias);
        }
        if ((flags & 2) != 0 || streamTypeAlias == this.getUiSoundsStreamType()) {
            int result;
            int ringerMode = this.getRingerModeInternal();
            if (ringerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            boolean bl = adjustVolume = ((result = this.checkForRingerModeChange(aliasIndex, direction, step, streamState.mIsMuted, callingPackage, flags)) & 1) != 0;
            if ((result & 0x80) != 0) {
                flags |= 0x80;
            }
            if ((result & 0x800) != 0) {
                flags |= 0x800;
            }
        }
        if (!this.volumeAdjustmentAllowedByDnd(streamTypeAlias, flags)) {
            adjustVolume = false;
        }
        int oldIndex = this.mStreamStates[streamType].getIndex(device);
        if (adjustVolume && direction != 0) {
            this.mAudioHandler.removeMessages(18);
            if (isMuteAdjust) {
                boolean state;
                if (direction == 101) {
                    state = !streamState.mIsMuted;
                } else {
                    boolean bl = state = direction == -100;
                }
                if (streamTypeAlias == 3) {
                    this.setSystemAudioMute(state);
                }
                for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
                    if (streamTypeAlias != mStreamVolumeAlias[stream] || this.readCameraSoundForced() && this.mStreamStates[stream].getStreamType() == 7) continue;
                    this.mStreamStates[stream].mute(state);
                }
            } else if (direction == 1 && !this.checkSafeMediaVolume(streamTypeAlias, aliasIndex + step, device)) {
                Log.e(TAG, "adjustStreamVolume() safe volume index = " + oldIndex);
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
            } else if ((device & this.mFullVolumeDevices) == 0 && (streamState.adjustIndex(direction * step, device, caller) || streamState.mIsMuted)) {
                if (streamState.mIsMuted) {
                    if (direction == 1) {
                        streamState.mute(false);
                    } else if (direction == -1 && this.mIsSingleVolume) {
                        AudioService.sendMsg(this.mAudioHandler, 18, 2, streamTypeAlias, flags, null, 350);
                    }
                }
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            int newIndex = this.mStreamStates[streamType].getIndex(device);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                this.mDeviceBroker.postSetAvrcpAbsoluteVolumeIndex(newIndex / 10);
            }
            if ((device & 0x8000000) != 0 && streamType == this.getHearingAidStreamType()) {
                this.mDeviceBroker.postSetHearingAidVolumeIndex(newIndex, streamType);
            }
            if (streamTypeAlias == 3) {
                this.setSystemAudioVolume(oldIndex, newIndex, this.getStreamMaxVolume(streamType), flags);
            }
            Object object2 = this.mHdmiClientLock;
            synchronized (object2) {
                if (this.mHdmiManager != null) {
                    if (this.mHdmiCecSink && streamTypeAlias == 3 && (device & this.mFullVolumeDevices) != 0) {
                        int keyCode = 0;
                        switch (direction) {
                            case 1: {
                                keyCode = 24;
                                break;
                            }
                            case -1: {
                                keyCode = 25;
                                break;
                            }
                            case 101: {
                                keyCode = 164;
                                break;
                            }
                        }
                        if (keyCode != 0) {
                            long ident = Binder.clearCallingIdentity();
                            try {
                                this.mHdmiPlaybackClient.sendKeyEvent(keyCode, true);
                                this.mHdmiPlaybackClient.sendKeyEvent(keyCode, false);
                            }
                            finally {
                                Binder.restoreCallingIdentity(ident);
                            }
                        }
                    }
                    if (this.mHdmiAudioSystemClient != null && this.mHdmiSystemAudioSupported && streamTypeAlias == 3 && (oldIndex != newIndex || isMuteAdjust)) {
                        long identity = Binder.clearCallingIdentity();
                        this.mHdmiAudioSystemClient.sendReportAudioStatusCecCommand(isMuteAdjust, this.getStreamVolume(3), this.getStreamMaxVolume(3), this.isStreamMute(3));
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }
        }
        int index = this.mStreamStates[streamType].getIndex(device);
        this.sendVolumeUpdate(streamType, oldIndex, index, flags, device);
    }

    private void onUnmuteStream(int stream, int flags) {
        VolumeStreamState streamState = this.mStreamStates[stream];
        streamState.mute(false);
        int device = this.getDeviceForStream(stream);
        int index = this.mStreamStates[stream].getIndex(device);
        this.sendVolumeUpdate(stream, index, index, flags, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemAudioVolume(int oldVolume, int newVolume, int maxVolume, int flags) {
        Object object = this.mHdmiClientLock;
        synchronized (object) {
            if (this.mHdmiManager == null || this.mHdmiTvClient == null || oldVolume == newVolume || (flags & 0x100) != 0 || !this.mHdmiSystemAudioSupported) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mHdmiTvClient.setSystemAudioVolume(oldVolume, newVolume, maxVolume);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private int getNewRingerMode(int stream, int index, int flags) {
        if (this.mIsSingleVolume) {
            return this.getRingerModeExternal();
        }
        if ((flags & 2) != 0 || stream == this.getUiSoundsStreamType()) {
            int newRingerMode = index == 0 ? (this.mHasVibrator ? 1 : (this.mVolumePolicy.volumeDownToEnterSilent ? 0 : 2)) : 2;
            return newRingerMode;
        }
        return this.getRingerModeExternal();
    }

    private boolean isAndroidNPlus(String caller) {
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(caller, 0, UserHandle.getUserId(Binder.getCallingUid()));
            return applicationInfo.targetSdkVersion >= 24;
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    private boolean wouldToggleZenMode(int newMode) {
        if (this.getRingerModeExternal() == 0 && newMode != 0) {
            return true;
        }
        return this.getRingerModeExternal() != 0 && newMode == 0;
    }

    private void onSetStreamVolume(int streamType, int index, int flags, int device, String caller) {
        int stream = mStreamVolumeAlias[streamType];
        this.setStreamVolumeInt(stream, index, device, false, caller);
        if ((flags & 2) != 0 || stream == this.getUiSoundsStreamType()) {
            this.setRingerMode(this.getNewRingerMode(stream, index, flags), "AS.AudioService.onSetStreamVolume", false);
        }
        if (streamType != 6) {
            this.mStreamStates[stream].mute(index == 0);
        }
    }

    private void enforceModifyAudioRoutingPermission() {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING") != 0) {
            throw new SecurityException("Missing MODIFY_AUDIO_ROUTING permission");
        }
    }

    @Override
    public void setVolumeIndexForAttributes(AudioAttributes attr2, int index, int flags, String callingPackage) {
        this.enforceModifyAudioRoutingPermission();
        Preconditions.checkNotNull(attr2, "attr must not be null");
        int stream = AudioProductStrategy.getLegacyStreamTypeForStrategyWithAudioAttributes(attr2);
        int device = this.getDeviceForStream(stream);
        int oldIndex = AudioSystem.getVolumeIndexForAttributes(attr2, device);
        AudioSystem.setVolumeIndexForAttributes(attr2, index, device);
        int volumeGroup = this.getVolumeGroupIdForAttributes(attr2);
        AudioVolumeGroup avg = this.getAudioVolumeGroupById(volumeGroup);
        if (avg == null) {
            return;
        }
        for (int groupedStream : avg.getLegacyStreamTypes()) {
            this.setStreamVolume(groupedStream, index, flags, callingPackage, callingPackage, Binder.getCallingUid());
        }
    }

    private AudioVolumeGroup getAudioVolumeGroupById(int volumeGroupId) {
        for (AudioVolumeGroup avg : AudioVolumeGroup.getAudioVolumeGroups()) {
            if (avg.getId() != volumeGroupId) continue;
            return avg;
        }
        Log.e(TAG, ": invalid volume group id: " + volumeGroupId + " requested");
        return null;
    }

    @Override
    public int getVolumeIndexForAttributes(AudioAttributes attr2) {
        this.enforceModifyAudioRoutingPermission();
        Preconditions.checkNotNull(attr2, "attr must not be null");
        int stream = AudioProductStrategy.getLegacyStreamTypeForStrategyWithAudioAttributes(attr2);
        int device = this.getDeviceForStream(stream);
        return AudioSystem.getVolumeIndexForAttributes(attr2, device);
    }

    @Override
    public int getMaxVolumeIndexForAttributes(AudioAttributes attr2) {
        this.enforceModifyAudioRoutingPermission();
        Preconditions.checkNotNull(attr2, "attr must not be null");
        return AudioSystem.getMaxVolumeIndexForAttributes(attr2);
    }

    @Override
    public int getMinVolumeIndexForAttributes(AudioAttributes attr2) {
        this.enforceModifyAudioRoutingPermission();
        Preconditions.checkNotNull(attr2, "attr must not be null");
        return AudioSystem.getMinVolumeIndexForAttributes(attr2);
    }

    @Override
    public void setStreamVolume(int streamType, int index, int flags, String callingPackage) {
        if (streamType == 10 && !this.canChangeAccessibilityVolume()) {
            Log.w(TAG, "Trying to call setStreamVolume() for a11y without CHANGE_ACCESSIBILITY_VOLUME  callingPackage=" + callingPackage);
            return;
        }
        if (streamType == 0 && index == 0 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "Trying to call setStreamVolume() for STREAM_VOICE_CALL and index 0 without MODIFY_PHONE_STATE  callingPackage=" + callingPackage);
            return;
        }
        sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(2, streamType, index, flags, callingPackage));
        this.setStreamVolume(streamType, index, flags, callingPackage, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canChangeAccessibilityVolume() {
        Object object = this.mAccessibilityServiceUidsLock;
        synchronized (object) {
            if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_ACCESSIBILITY_VOLUME")) {
                return true;
            }
            if (this.mAccessibilityServiceUids != null) {
                int callingUid = Binder.getCallingUid();
                for (int i = 0; i < this.mAccessibilityServiceUids.length; ++i) {
                    if (this.mAccessibilityServiceUids[i] != callingUid) continue;
                    return true;
                }
            }
            return false;
        }
    }

    int getHearingAidStreamType() {
        return this.getHearingAidStreamType(this.mMode);
    }

    private int getHearingAidStreamType(int mode) {
        switch (mode) {
            case 2: 
            case 3: {
                return 0;
            }
        }
        if (this.mVoiceActive.get()) {
            return 0;
        }
        return 3;
    }

    private void onPlaybackConfigChange(List<AudioPlaybackConfiguration> configs) {
        boolean voiceActive = false;
        for (AudioPlaybackConfiguration config : configs) {
            int usage = config.getAudioAttributes().getUsage();
            if (usage != 2 && usage != 3 || config.getPlayerState() != 2) continue;
            voiceActive = true;
            break;
        }
        if (this.mVoiceActive.getAndSet(voiceActive) != voiceActive) {
            this.updateHearingAidVolumeOnVoiceActivityUpdate();
        }
    }

    private void updateHearingAidVolumeOnVoiceActivityUpdate() {
        int streamType = this.getHearingAidStreamType();
        int index = this.getStreamVolume(streamType);
        sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(6, this.mVoiceActive.get(), streamType, index));
        this.mDeviceBroker.postSetHearingAidVolumeIndex(index * 10, streamType);
    }

    void updateAbsVolumeMultiModeDevices(int oldMode, int newMode) {
        if (oldMode == newMode) {
            return;
        }
        switch (newMode) {
            case 0: 
            case 2: 
            case 3: {
                break;
            }
            case 1: {
                return;
            }
            default: {
                return;
            }
        }
        int streamType = this.getHearingAidStreamType(newMode);
        int device = AudioSystem.getDevicesForStream(streamType);
        if ((device & this.mAbsVolumeMultiModeCaseDevices) == 0) {
            return;
        }
        if ((device & this.mAbsVolumeMultiModeCaseDevices) == 0x8000000) {
            int index = this.getStreamVolume(streamType);
            sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(7, newMode, streamType, index));
            this.mDeviceBroker.postSetHearingAidVolumeIndex(index * 10, streamType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamVolume(int streamType, int index, int flags, String callingPackage, String caller, int uid) {
        int oldIndex;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamType);
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (uid == 1000) {
            uid = UserHandle.getUid(this.getCurrentUserId(), UserHandle.getAppId(uid));
        }
        if (this.mAppOps.noteOp(STREAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        if (this.isAndroidNPlus(callingPackage) && this.wouldToggleZenMode(this.getNewRingerMode(streamTypeAlias, index, flags)) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(callingPackage)) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        if (!this.volumeAdjustmentAllowedByDnd(streamTypeAlias, flags)) {
            return;
        }
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            this.mPendingVolumeCommand = null;
            oldIndex = streamState.getIndex(device);
            index = this.rescaleIndex(index * 10, streamType, streamTypeAlias);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                this.mDeviceBroker.postSetAvrcpAbsoluteVolumeIndex(index / 10);
            }
            if ((device & 0x8000000) != 0 && streamType == this.getHearingAidStreamType()) {
                Log.i(TAG, "setStreamVolume postSetHearingAidVolumeIndex index=" + index + " stream=" + streamType);
                this.mDeviceBroker.postSetHearingAidVolumeIndex(index, streamType);
            }
            if (streamTypeAlias == 3) {
                this.setSystemAudioVolume(oldIndex, index, this.getStreamMaxVolume(streamType), flags);
            }
            flags &= 0xFFFFFFDF;
            if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
                flags |= 0x20;
                if (index != 0) {
                    index = this.mSafeMediaVolumeState == 3 && (device & 0x400000C) != 0 ? this.safeMediaVolumeIndex(device) : streamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(streamTypeAlias, index, device)) {
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
                this.mPendingVolumeCommand = new StreamVolumeCommand(streamType, index, flags, device);
            } else {
                this.onSetStreamVolume(streamType, index, flags, device, caller);
                index = this.mStreamStates[streamType].getIndex(device);
            }
        }
        object = this.mHdmiClientLock;
        synchronized (object) {
            if (this.mHdmiManager != null && this.mHdmiAudioSystemClient != null && this.mHdmiSystemAudioSupported && streamTypeAlias == 3 && oldIndex != index) {
                long identity = Binder.clearCallingIdentity();
                this.mHdmiAudioSystemClient.sendReportAudioStatusCecCommand(false, this.getStreamVolume(3), this.getStreamMaxVolume(3), this.isStreamMute(3));
                Binder.restoreCallingIdentity(identity);
            }
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags, device);
    }

    private int getVolumeGroupIdForAttributes(AudioAttributes attributes) {
        Preconditions.checkNotNull(attributes, "attributes must not be null");
        int volumeGroupId = this.getVolumeGroupIdForAttributesInt(attributes);
        if (volumeGroupId != -1) {
            return volumeGroupId;
        }
        return this.getVolumeGroupIdForAttributesInt(AudioProductStrategy.sDefaultAttributes);
    }

    private int getVolumeGroupIdForAttributesInt(AudioAttributes attributes) {
        Preconditions.checkNotNull(attributes, "attributes must not be null");
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            int volumeGroupId = productStrategy.getVolumeGroupIdForAudioAttributes(attributes);
            if (volumeGroupId == -1) continue;
            return volumeGroupId;
        }
        return -1;
    }

    private boolean volumeAdjustmentAllowedByDnd(int streamTypeAlias, int flags) {
        switch (this.mNm.getZenMode()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: {
                return !this.isStreamMutedByRingerOrZenMode(streamTypeAlias) || streamTypeAlias == this.getUiSoundsStreamType() || (flags & 2) != 0;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceVolumeControlStream(int streamType, IBinder cb) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            return;
        }
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            if (this.mVolumeControlStream != -1 && streamType != -1) {
                this.mUserSelectedVolumeControlStream = true;
            }
            this.mVolumeControlStream = streamType;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
                this.mUserSelectedVolumeControlStream = false;
            } else if (null == this.mForceControlStreamClient) {
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            } else if (this.mForceControlStreamClient.getBinder() == cb) {
                Log.d(TAG, "forceVolumeControlStream cb:" + cb + " is already linked.");
            } else {
                this.mForceControlStreamClient.release();
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastToAll(Intent intent) {
        intent.addFlags(0x4000000);
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcastToAll(Intent intent) {
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentUserId() {
        long ident = Binder.clearCallingIdentity();
        try {
            UserInfo currentUser = ActivityManager.getService().getCurrentUser();
            int n = currentUser.id;
            return n;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return 0;
    }

    protected void sendVolumeUpdate(int streamType, int oldIndex, int index, int flags, int device) {
        if ((streamType = mStreamVolumeAlias[streamType]) == 3) {
            flags = this.updateFlagsForTvPlatform(flags);
            if ((device & this.mFullVolumeDevices) != 0) {
                flags &= 0xFFFFFFFE;
            }
        }
        this.mVolumeController.postVolumeChanged(streamType, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateFlagsForTvPlatform(int flags) {
        Object object = this.mHdmiClientLock;
        synchronized (object) {
            if (this.mHdmiTvClient != null && this.mHdmiSystemAudioSupported && (flags & 0x100) == 0) {
                flags &= 0xFFFFFFFE;
            }
        }
        return flags;
    }

    private void sendMasterMuteUpdate(boolean muted, int flags) {
        this.mVolumeController.postMasterMuteChanged(this.updateFlagsForTvPlatform(flags));
        this.broadcastMasterMuteStatus(muted);
    }

    private void broadcastMasterMuteStatus(boolean muted) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", muted);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, int device, boolean force, String caller) {
        if ((device & this.mFullVolumeDevices) != 0) {
            return;
        }
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.setIndex(index, device, caller) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemAudioMute(boolean state) {
        Object object = this.mHdmiClientLock;
        synchronized (object) {
            if (this.mHdmiManager == null || this.mHdmiTvClient == null || !this.mHdmiSystemAudioSupported) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mHdmiTvClient.setSystemAudioMute(state);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStreamMute(int streamType) {
        if (streamType == Integer.MIN_VALUE) {
            streamType = this.getActiveStreamType(streamType);
        }
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            this.ensureValidStreamType(streamType);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mStreamStates[streamType].mIsMuted;
        }
    }

    private boolean discardRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        for (RmtSbmxFullVolDeathHandler handler : this.mRmtSbmxFullVolDeathHandlers) {
            if (!handler.isHandlerFor(cb)) continue;
            handler.forget();
            this.mRmtSbmxFullVolDeathHandlers.remove(handler);
            return true;
        }
        return false;
    }

    private boolean hasRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        Iterator<RmtSbmxFullVolDeathHandler> it = this.mRmtSbmxFullVolDeathHandlers.iterator();
        while (it.hasNext()) {
            if (!it.next().isHandlerFor(cb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) {
        if (cb == null) {
            return;
        }
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.CAPTURE_AUDIO_OUTPUT")) {
            Log.w(TAG, "Trying to call forceRemoteSubmixFullVolume() without CAPTURE_AUDIO_OUTPUT");
            return;
        }
        ArrayList<RmtSbmxFullVolDeathHandler> arrayList = this.mRmtSbmxFullVolDeathHandlers;
        synchronized (arrayList) {
            boolean applyRequired = false;
            if (startForcing) {
                if (!this.hasRmtSbmxFullVolDeathHandlerFor(cb)) {
                    this.mRmtSbmxFullVolDeathHandlers.add(new RmtSbmxFullVolDeathHandler(cb));
                    if (this.mRmtSbmxFullVolRefCount == 0) {
                        this.mFullVolumeDevices |= 0x8000;
                        this.mFixedVolumeDevices |= 0x8000;
                        applyRequired = true;
                    }
                    ++this.mRmtSbmxFullVolRefCount;
                }
            } else if (this.discardRmtSbmxFullVolDeathHandlerFor(cb) && this.mRmtSbmxFullVolRefCount > 0) {
                --this.mRmtSbmxFullVolRefCount;
                if (this.mRmtSbmxFullVolRefCount == 0) {
                    this.mFullVolumeDevices &= 0xFFFF7FFF;
                    this.mFixedVolumeDevices &= 0xFFFF7FFF;
                    applyRequired = true;
                }
            }
            if (applyRequired) {
                this.checkAllFixedVolumeDevices(3);
                this.mStreamStates[3].applyAllVolumes();
            }
        }
    }

    private void setMasterMuteInternal(boolean mute, int flags, String callingPackage, int uid, int userId) {
        if (uid == 1000) {
            uid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        }
        if (!mute && this.mAppOps.noteOp(33, uid, callingPackage) != 0) {
            return;
        }
        if (userId != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            return;
        }
        this.setMasterMuteInternalNoCallerCheck(mute, flags, userId);
    }

    private void setMasterMuteInternalNoCallerCheck(boolean mute, int flags, int userId) {
        if (!this.isPlatformAutomotive() && this.mUseFixedVolume) {
            return;
        }
        if ((this.isPlatformAutomotive() && userId == 0 || this.getCurrentUserId() == userId) && mute != AudioSystem.getMasterMute()) {
            this.setSystemAudioMute(mute);
            AudioSystem.setMasterMute(mute);
            this.sendMasterMuteUpdate(mute, flags);
            Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", mute);
            this.sendBroadcastToAll(intent);
        }
    }

    @Override
    public boolean isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    @Override
    public void setMasterMute(boolean mute, int flags, String callingPackage, int userId) {
        this.setMasterMuteInternal(mute, flags, callingPackage, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            int index = this.mStreamStates[streamType].getIndex(device);
            if (this.mStreamStates[streamType].mIsMuted) {
                index = 0;
            }
            if (index != 0 && mStreamVolumeAlias[streamType] == 3 && (device & this.mFixedVolumeDevices) != 0) {
                index = this.mStreamStates[streamType].getMaxIndex();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (index + 5) / 10;
        }
    }

    @Override
    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    @Override
    public int getStreamMinVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMinIndex() + 5) / 10;
    }

    @Override
    public int getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        return (this.mStreamStates[streamType].getIndex(device) + 5) / 10;
    }

    @Override
    public int getUiSoundsStreamType() {
        return mStreamVolumeAlias[1];
    }

    @Override
    public void setMicrophoneMute(boolean on, String callingPackage, int userId) {
        int uid = Binder.getCallingUid();
        if (uid == 1000) {
            uid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        }
        if (!on && this.mAppOps.noteOp(44, uid, callingPackage) != 0) {
            return;
        }
        if (!this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        if (userId != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            return;
        }
        this.setMicrophoneMuteNoCallerCheck(on, userId);
    }

    private void setMicrophoneMuteNoCallerCheck(boolean on, int userId) {
        if (this.getCurrentUserId() == userId) {
            boolean currentMute = AudioSystem.isMicrophoneMuted();
            long identity = Binder.clearCallingIdentity();
            AudioSystem.muteMicrophone(on);
            Binder.restoreCallingIdentity(identity);
            if (on != currentMute) {
                this.mContext.sendBroadcast(new Intent("android.media.action.MICROPHONE_MUTE_CHANGED").setFlags(0x40000000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRingerModeExternal() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerModeExternal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRingerModeInternal() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    private void ensureValidRingerMode(int ringerMode) {
        if (!this.isValidRingerMode(ringerMode)) {
            throw new IllegalArgumentException("Bad ringer mode " + ringerMode);
        }
    }

    @Override
    public boolean isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= 2;
    }

    @Override
    public void setRingerModeExternal(int ringerMode, String caller) {
        if (this.isAndroidNPlus(caller) && this.wouldToggleZenMode(ringerMode) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(caller)) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        this.setRingerMode(ringerMode, caller, true);
    }

    @Override
    public void setRingerModeInternal(int ringerMode, String caller) {
        this.enforceVolumeController("setRingerModeInternal");
        this.setRingerMode(ringerMode, caller, false);
    }

    public void silenceRingerModeInternal(String reason) {
        VibrationEffect effect = null;
        int ringerMode = 0;
        int toastText = 0;
        int silenceRingerSetting = 0;
        if (this.mContext.getResources().getBoolean(17891571)) {
            silenceRingerSetting = Settings.Secure.getIntForUser(this.mContentResolver, "volume_hush_gesture", 0, -2);
        }
        switch (silenceRingerSetting) {
            case 2: {
                effect = VibrationEffect.get(1);
                ringerMode = 0;
                toastText = 17041194;
                break;
            }
            case 1: {
                effect = VibrationEffect.get(5);
                ringerMode = 1;
                toastText = 17041195;
            }
        }
        this.maybeVibrate(effect, reason);
        this.setRingerModeInternal(ringerMode, reason);
        Toast.makeText(this.mContext, toastText, 0).show();
    }

    private boolean maybeVibrate(VibrationEffect effect, String reason) {
        boolean hapticsDisabled;
        if (!this.mHasVibrator) {
            return false;
        }
        boolean bl = hapticsDisabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 0, -2) == 0;
        if (hapticsDisabled) {
            return false;
        }
        if (effect == null) {
            return false;
        }
        this.mVibrator.vibrate(Binder.getCallingUid(), this.mContext.getOpPackageName(), effect, reason, VIBRATION_ATTRIBUTES);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerMode(int ringerMode, String caller, boolean external) {
        if (this.mUseFixedVolume || this.mIsSingleVolume) {
            return;
        }
        if (caller == null || caller.length() == 0) {
            throw new IllegalArgumentException("Bad caller: " + caller);
        }
        this.ensureValidRingerMode(ringerMode);
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Object object = this.mSettingsLock;
            synchronized (object) {
                int ringerModeInternal = this.getRingerModeInternal();
                int ringerModeExternal = this.getRingerModeExternal();
                if (external) {
                    this.setRingerModeExt(ringerMode);
                    if (this.mRingerModeDelegate != null) {
                        ringerMode = this.mRingerModeDelegate.onSetRingerModeExternal(ringerModeExternal, ringerMode, caller, ringerModeInternal, this.mVolumePolicy);
                    }
                    if (ringerMode != ringerModeInternal) {
                        this.setRingerModeInt(ringerMode, true);
                    }
                } else {
                    if (ringerMode != ringerModeInternal) {
                        this.setRingerModeInt(ringerMode, true);
                    }
                    if (this.mRingerModeDelegate != null) {
                        ringerMode = this.mRingerModeDelegate.onSetRingerModeInternal(ringerModeInternal, ringerMode, caller, ringerModeExternal, this.mVolumePolicy);
                    }
                    this.setRingerModeExt(ringerMode);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeExt(int ringerMode) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (ringerMode == this.mRingerModeExternal) {
                return;
            }
            this.mRingerModeExternal = ringerMode;
        }
        this.broadcastRingerMode("android.media.RINGER_MODE_CHANGED", ringerMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @GuardedBy(value={"mSettingsLock"})
    private void muteRingerModeStreams() {
        int ringerMode;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        if (this.mNm == null) {
            this.mNm = (NotificationManager)this.mContext.getSystemService("notification");
        }
        boolean ringerModeMute = (ringerMode = this.mRingerMode) == 1 || ringerMode == 0;
        boolean shouldRingSco = ringerMode == 1 && this.isBluetoothScoOn();
        String eventSource = "muteRingerModeStreams() from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 7, shouldRingSco ? 3 : 0, eventSource, 0);
        int streamType = numStreamTypes - 1;
        while (streamType >= 0) {
            boolean shouldMute;
            boolean isMuted = this.isStreamMutedByRingerOrZenMode(streamType);
            boolean muteAllowedBySco = !shouldRingSco || streamType != 2;
            boolean shouldZenMute = this.shouldZenMuteStream(streamType);
            boolean bl = shouldMute = shouldZenMute || ringerModeMute && this.isStreamAffectedByRingerMode(streamType) && muteAllowedBySco;
            if (isMuted != shouldMute) {
                if (!shouldMute) {
                    if (mStreamVolumeAlias[streamType] == 2) {
                        Class<VolumeStreamState> clazz = VolumeStreamState.class;
                        // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
                        VolumeStreamState vss = this.mStreamStates[streamType];
                        for (int i = 0; i < vss.mIndexMap.size(); ++i) {
                            int device = vss.mIndexMap.keyAt(i);
                            int value = vss.mIndexMap.valueAt(i);
                            if (value != 0) continue;
                            vss.setIndex(10, device, TAG);
                        }
                        int device = this.getDeviceForStream(streamType);
                        AudioService.sendMsg(this.mAudioHandler, 1, 2, device, 0, this.mStreamStates[streamType], 500);
                        // MONITOREXIT : clazz
                    }
                    this.mStreamStates[streamType].mute(false);
                    this.mRingerAndZenModeMutedStreams &= ~(1 << streamType);
                } else {
                    this.mStreamStates[streamType].mute(true);
                    this.mRingerAndZenModeMutedStreams |= 1 << streamType;
                }
            }
            --streamType;
        }
    }

    private boolean isAlarm(int streamType) {
        return streamType == 4;
    }

    private boolean isNotificationOrRinger(int streamType) {
        return streamType == 5 || streamType == 2;
    }

    private boolean isMedia(int streamType) {
        return streamType == 3;
    }

    private boolean isSystem(int streamType) {
        return streamType == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeInt(int ringerMode, boolean persist) {
        boolean change;
        Object object = this.mSettingsLock;
        synchronized (object) {
            change = this.mRingerMode != ringerMode;
            this.mRingerMode = ringerMode;
            this.muteRingerModeStreams();
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
        if (change) {
            this.broadcastRingerMode("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", ringerMode);
        }
    }

    void postUpdateRingerModeServiceInt() {
        AudioService.sendMsg(this.mAudioHandler, 25, 2, 0, 0, null, 0);
    }

    private void onUpdateRingerModeServiceInt() {
        this.setRingerModeInt(this.getRingerModeInternal(), false);
    }

    @Override
    public boolean shouldVibrate(int vibrateType) {
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.getRingerModeExternal() != 0;
            }
            case 2: {
                return this.getRingerModeExternal() == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getVibrateSetting(int vibrateType) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    @Override
    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
    }

    int getModeOwnerPid() {
        int modeOwnerPid = 0;
        try {
            modeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modeOwnerPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int mode, IBinder cb, String callingPackage) {
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode == 2 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: setMode(MODE_IN_CALL) from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int oldModeOwnerPid = 0;
        int newModeOwnerPid = 0;
        Object object = this.mDeviceBroker.mSetModeLock;
        synchronized (object) {
            if (!this.mSetModeDeathHandlers.isEmpty()) {
                oldModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
            }
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid(), callingPackage);
        }
        if (newModeOwnerPid != oldModeOwnerPid && newModeOwnerPid != 0) {
            this.mDeviceBroker.postDisconnectBluetoothSco(newModeOwnerPid);
        }
    }

    @GuardedBy(value={"mDeviceBroker.mSetModeLock"})
    private int setModeInt(int mode, IBinder cb, int pid, String caller) {
        int actualMode;
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e(TAG, "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int oldMode = this.mMode;
        int status = 0;
        do {
            actualMode = mode;
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    actualMode = hdlr.getMode();
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (actualMode != this.mMode) {
                long identity = Binder.clearCallingIdentity();
                status = AudioSystem.setPhoneState(actualMode);
                Binder.restoreCallingIdentity(identity);
                if (status == 0) {
                    this.mMode = actualMode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            if (actualMode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            this.mModeLogger.log(new AudioServiceEvents.PhoneStateEvent(caller, pid, mode, newModeOwnerPid, actualMode));
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int device = this.getDeviceForStream(streamType);
            int index = this.mStreamStates[mStreamVolumeAlias[streamType]].getIndex(device);
            this.setStreamVolumeInt(mStreamVolumeAlias[streamType], index, device, true, caller);
            this.updateStreamVolumeAlias(true, caller);
            this.updateAbsVolumeMultiModeDevices(oldMode, actualMode);
        }
        return newModeOwnerPid;
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    private void loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTouchSoundAssets() {
        block17: {
            XmlResourceParser parser = null;
            if (!SOUND_EFFECT_FILES.isEmpty()) {
                return;
            }
            this.loadTouchSoundAssetDefaults();
            try {
                String element;
                boolean inTouchSoundsGroup;
                block18: {
                    String name;
                    parser = this.mContext.getResources().getXml(0x1170001);
                    XmlUtils.beginDocument(parser, TAG_AUDIO_ASSETS);
                    String version = parser.getAttributeValue(null, ATTR_VERSION);
                    inTouchSoundsGroup = false;
                    if (!ASSET_FILE_VERSION.equals(version)) break block17;
                    do {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) break block18;
                    } while (!element.equals(TAG_GROUP) || !GROUP_TOUCH_SOUNDS.equals(name = parser.getAttributeValue(null, ATTR_GROUP_NAME)));
                    inTouchSoundsGroup = true;
                }
                while (inTouchSoundsGroup) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!element.equals(TAG_ASSET)) break;
                    String id2 = parser.getAttributeValue(null, ATTR_ASSET_ID);
                    String file = parser.getAttributeValue(null, ATTR_ASSET_FILE);
                    try {
                        Field field = AudioManager.class.getField(id2);
                        int fx = field.getInt(null);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "Invalid touch sound ID: " + id2);
                        continue;
                    }
                    int i = SOUND_EFFECT_FILES.indexOf(file);
                    if (i == -1) {
                        i = SOUND_EFFECT_FILES.size();
                        SOUND_EFFECT_FILES.add(file);
                    }
                    this.SOUND_EFFECT_FILES_MAP[fx][0] = i;
                }
            }
            catch (Resources.NotFoundException e) {
                Log.w(TAG, "audio assets file not found", e);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "XML parser exception reading touch sound assets", e);
            }
            catch (IOException e) {
                Log.w(TAG, "I/O exception reading touch sound assets", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
    }

    @Override
    public void playSoundEffect(int effectType) {
        this.playSoundEffectVolume(effectType, -1.0f);
    }

    @Override
    public void playSoundEffectVolume(int effectType, float volume) {
        if (this.isStreamMutedByRingerOrZenMode(1)) {
            return;
        }
        if (effectType >= 10 || effectType < 0) {
            Log.w(TAG, "AudioService effectType value " + effectType + " out of range");
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 5, 2, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSoundEffects() {
        LoadSoundEffectReply reply;
        int attempts = 3;
        LoadSoundEffectReply loadSoundEffectReply = reply = new LoadSoundEffectReply();
        synchronized (loadSoundEffectReply) {
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, reply, 0);
            while (reply.mStatus == 1 && attempts-- > 0) {
                try {
                    reply.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "loadSoundEffects Interrupted while waiting sound pool loaded.");
                }
            }
        }
        return reply.mStatus == 0;
    }

    protected void scheduleLoadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, null, 0);
    }

    @Override
    public void unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 15, 2, 0, 0, null, 0);
    }

    @Override
    public void reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readAudioSettings(boolean userSwitch) {
        this.readPersistedSettings();
        this.readUserRestrictions();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (userSwitch && mStreamVolumeAlias[streamType] == 3) continue;
            streamState.readSettings();
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            if (streamState.mIsMuted && (!this.isStreamAffectedByMute(streamType) && !this.isStreamMutedByRingerOrZenMode(streamType) || this.mUseFixedVolume)) {
                streamState.mIsMuted = false;
            }
            // MONITOREXIT : clazz
        }
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        this.checkMuteAffectedStreams();
        Object object = this.mSafeMediaVolumeStateLock;
        // MONITORENTER : object
        this.mMusicActiveMs = MathUtils.constrain(Settings.Secure.getIntForUser(this.mContentResolver, "unsafe_volume_music_active_ms", 0, -2), 0, 72000000);
        if (this.mSafeMediaVolumeState == 3) {
            this.enforceSafeMediaVolume(TAG);
        }
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSpeakerphoneOn(boolean on) {
        String eventSource;
        boolean stateChanged;
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                for (SetModeDeathHandler h : this.mSetModeDeathHandlers) {
                    if (h.getMode() != 2) continue;
                    Log.w(TAG, "getMode is call, Permission Denial: setSpeakerphoneOn from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                    return;
                }
            }
        }
        if (!(stateChanged = this.mDeviceBroker.setSpeakerphoneOn(on, eventSource = "setSpeakerphoneOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid()))) return;
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(new Intent("android.media.action.SPEAKERPHONE_STATE_CHANGED").setFlags(0x40000000), UserHandle.ALL);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return this.mDeviceBroker.isSpeakerphoneOn();
    }

    @Override
    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (UserHandle.getCallingAppId() >= 10000) {
            this.mDeviceBroker.setBluetoothScoOnByApp(on);
            return;
        }
        String eventSource = "setBluetoothScoOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        this.mDeviceBroker.setBluetoothScoOn(on, eventSource);
    }

    @Override
    public boolean isBluetoothScoOn() {
        return this.mDeviceBroker.isBluetoothScoOnForApp();
    }

    @Override
    public void setBluetoothA2dpOn(boolean on) {
        String eventSource = "setBluetoothA2dpOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        this.mDeviceBroker.setBluetoothA2dpOn_Async(on, eventSource);
    }

    @Override
    public boolean isBluetoothA2dpOn() {
        return this.mDeviceBroker.isBluetoothA2dpOn();
    }

    @Override
    public void startBluetoothSco(IBinder cb, int targetSdkVersion) {
        int scoAudioMode = targetSdkVersion < 18 ? 0 : -1;
        String eventSource = "startBluetoothSco()" + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        this.startBluetoothScoInt(cb, scoAudioMode, eventSource);
    }

    @Override
    public void startBluetoothScoVirtualCall(IBinder cb) {
        String eventSource = "startBluetoothScoVirtualCall()" + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        this.startBluetoothScoInt(cb, 0, eventSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBluetoothScoInt(IBinder cb, int scoAudioMode, String eventSource) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        Object object = this.mDeviceBroker.mSetModeLock;
        synchronized (object) {
            this.mDeviceBroker.startBluetoothScoForClient_Sync(cb, scoAudioMode, eventSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        String eventSource = "stopBluetoothSco()" + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        Object object = this.mDeviceBroker.mSetModeLock;
        synchronized (object) {
            this.mDeviceBroker.stopBluetoothScoForClient_Sync(cb, eventSource);
        }
    }

    ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCheckMusicActive(String caller) {
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            int device;
            if (this.mSafeMediaVolumeState == 2 && ((device = this.getDeviceForStream(3)) & 0x400000C) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 11, 0, 0, 0, caller, 60000);
                int index = this.mStreamStates[3].getIndex(device);
                if (AudioSystem.isStreamActive(3, 0) && index > this.safeMediaVolumeIndex(device)) {
                    this.mMusicActiveMs += 60000;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true, caller);
                        this.mMusicActiveMs = 0;
                    }
                    this.saveMusicActiveMs();
                }
            }
        }
    }

    private void saveMusicActiveMs() {
        this.mAudioHandler.obtainMessage(17, this.mMusicActiveMs, 0).sendToTarget();
    }

    private int getSafeUsbMediaVolumeIndex() {
        int index;
        float gainDB;
        int min = MIN_STREAM_VOLUME[3];
        int max = MAX_STREAM_VOLUME[3];
        this.mSafeUsbMediaVolumeDbfs = (float)this.mContext.getResources().getInteger(17694878) / 100.0f;
        while (Math.abs(max - min) > 1 && !Float.isNaN(gainDB = AudioSystem.getStreamVolumeDB(3, index = (max + min) / 2, 0x4000000))) {
            if (gainDB == this.mSafeUsbMediaVolumeDbfs) {
                min = index;
                break;
            }
            if (gainDB < this.mSafeUsbMediaVolumeDbfs) {
                min = index;
                continue;
            }
            max = index;
        }
        return min * 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConfigureSafeVolume(boolean force, String caller) {
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            int mcc = this.mContext.getResources().getConfiguration().mcc;
            if (this.mMcc != mcc || this.mMcc == 0 && force) {
                int persistedState;
                this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694877) * 10;
                this.mSafeUsbMediaVolumeIndex = this.getSafeUsbMediaVolumeIndex();
                boolean safeMediaVolumeEnabled = SystemProperties.getBoolean("audio.safemedia.force", false) || this.mContext.getResources().getBoolean(0x11100B0);
                boolean safeMediaVolumeBypass = SystemProperties.getBoolean("audio.safemedia.bypass", false);
                if (safeMediaVolumeEnabled && !safeMediaVolumeBypass) {
                    persistedState = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        if (this.mMusicActiveMs == 0) {
                            this.mSafeMediaVolumeState = 3;
                            this.enforceSafeMediaVolume(caller);
                        } else {
                            this.mSafeMediaVolumeState = 2;
                        }
                    }
                } else {
                    persistedState = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = mcc;
                AudioService.sendMsg(this.mAudioHandler, 14, 2, persistedState, 0, null, 0);
            }
        }
    }

    private int checkForRingerModeChange(int oldIndex, int direction, int step, boolean isMuted, String caller, int flags) {
        int result = 1;
        if (this.isPlatformTelevision() || this.mIsSingleVolume) {
            return result;
        }
        int ringerMode = this.getRingerModeInternal();
        switch (ringerMode) {
            case 2: {
                if (direction == -1) {
                    if (this.mHasVibrator) {
                        if (step > oldIndex || oldIndex >= 2 * step) break;
                        ringerMode = 1;
                        this.mLoweredFromNormalToVibrateTime = SystemClock.uptimeMillis();
                        break;
                    }
                    if (oldIndex != step || !this.mVolumePolicy.volumeDownToEnterSilent) break;
                    ringerMode = 0;
                    break;
                }
                if (!this.mIsSingleVolume || direction != 101 && direction != -100) break;
                ringerMode = this.mHasVibrator ? 1 : 0;
                result &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e(TAG, "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    break;
                }
                if (direction == -1) {
                    if (this.mIsSingleVolume && oldIndex >= 2 * step && isMuted) {
                        ringerMode = 2;
                    } else if (this.mPrevVolDirection != -1) {
                        if (this.mVolumePolicy.volumeDownToEnterSilent) {
                            long diff = SystemClock.uptimeMillis() - this.mLoweredFromNormalToVibrateTime;
                            if (diff > (long)this.mVolumePolicy.vibrateToSilentDebounce && this.mRingerModeDelegate.canVolumeDownEnterSilent()) {
                                ringerMode = 0;
                            }
                        } else {
                            result |= 0x800;
                        }
                    }
                } else if (direction == 1 || direction == 101 || direction == 100) {
                    ringerMode = 2;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 0: {
                if (this.mIsSingleVolume && direction == -1 && oldIndex >= 2 * step && isMuted) {
                    ringerMode = 2;
                } else if (direction == 1 || direction == 101 || direction == 100) {
                    if (!this.mVolumePolicy.volumeUpToExitSilent) {
                        result |= 0x80;
                    } else {
                        ringerMode = this.mHasVibrator && direction == 1 ? 1 : 2;
                    }
                }
                result &= 0xFFFFFFFE;
                break;
            }
            default: {
                Log.e(TAG, "checkForRingerModeChange() wrong ringer mode: " + ringerMode);
            }
        }
        if (this.isAndroidNPlus(caller) && this.wouldToggleZenMode(ringerMode) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(caller) && (flags & 0x1000) == 0) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        this.setRingerMode(ringerMode, "AS.AudioService.checkForRingerModeChange", false);
        this.mPrevVolDirection = direction;
        return result;
    }

    @Override
    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean shouldZenMuteStream(int streamType) {
        if (this.mNm.getZenMode() != 1) {
            return false;
        }
        NotificationManager.Policy zenPolicy = this.mNm.getConsolidatedNotificationPolicy();
        boolean muteAlarms = (zenPolicy.priorityCategories & 0x20) == 0;
        boolean muteMedia = (zenPolicy.priorityCategories & 0x40) == 0;
        boolean muteSystem = (zenPolicy.priorityCategories & 0x80) == 0;
        boolean muteNotificationAndRing = ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(this.mNm.getConsolidatedNotificationPolicy());
        return muteAlarms && this.isAlarm(streamType) || muteMedia && this.isMedia(streamType) || muteSystem && this.isSystem(streamType) || muteNotificationAndRing && this.isNotificationOrRinger(streamType);
    }

    private boolean isStreamMutedByRingerOrZenMode(int streamType) {
        return (this.mRingerAndZenModeMutedStreams & 1 << streamType) != 0;
    }

    private boolean updateZenModeAffectedStreams() {
        int zenModeAffectedStreams = 0;
        if (this.mSystemReady && this.mNm.getZenMode() == 1) {
            NotificationManager.Policy zenPolicy = this.mNm.getConsolidatedNotificationPolicy();
            if ((zenPolicy.priorityCategories & 0x20) == 0) {
                zenModeAffectedStreams |= 0x10;
            }
            if ((zenPolicy.priorityCategories & 0x40) == 0) {
                zenModeAffectedStreams |= 8;
            }
            if ((zenPolicy.priorityCategories & 0x80) == 0) {
                zenModeAffectedStreams |= 2;
            }
        }
        if (this.mZenModeAffectedStreams != zenModeAffectedStreams) {
            this.mZenModeAffectedStreams = zenModeAffectedStreams;
            return true;
        }
        return false;
    }

    @GuardedBy(value={"mSettingsLock"})
    private boolean updateRingerAndZenModeAffectedStreams() {
        boolean updatedZenModeAffectedStreams = this.updateZenModeAffectedStreams();
        int ringerModeAffectedStreams = Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        if (this.mIsSingleVolume) {
            ringerModeAffectedStreams = 0;
        } else if (this.mRingerModeDelegate != null) {
            ringerModeAffectedStreams = this.mRingerModeDelegate.getRingerModeAffectedStreams(ringerModeAffectedStreams);
        }
        ringerModeAffectedStreams = this.mCameraSoundForced ? (ringerModeAffectedStreams &= 0xFFFFFF7F) : (ringerModeAffectedStreams |= 0x80);
        ringerModeAffectedStreams = mStreamVolumeAlias[8] == 2 ? (ringerModeAffectedStreams |= 0x100) : (ringerModeAffectedStreams &= 0xFFFFFEFF);
        if (ringerModeAffectedStreams != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", ringerModeAffectedStreams, -2);
            this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
            return true;
        }
        return updatedZenModeAffectedStreams;
    }

    @Override
    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        switch (direction) {
            case -100: 
            case -1: 
            case 0: 
            case 1: 
            case 100: 
            case 101: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction " + direction);
            }
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private boolean isMuteAdjust(int adjust) {
        return adjust == -100 || adjust == 100 || adjust == 101;
    }

    boolean isInCommunication() {
        boolean IsInCall = false;
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        long ident = Binder.clearCallingIdentity();
        IsInCall = telecomManager.isInCall();
        Binder.restoreCallingIdentity(ident);
        return IsInCall || this.getMode() == 3 || this.getMode() == 2;
    }

    private boolean wasStreamActiveRecently(int stream, int delay_ms) {
        return AudioSystem.isStreamActive(stream, delay_ms) || AudioSystem.isStreamActiveRemotely(stream, delay_ms);
    }

    private int getActiveStreamType(int suggestedStreamType) {
        if (this.mIsSingleVolume && suggestedStreamType == Integer.MIN_VALUE) {
            return 3;
        }
        switch (this.mPlatformType) {
            case 1: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        return 6;
                    }
                    return 0;
                }
                if (suggestedStreamType == Integer.MIN_VALUE) {
                    if (this.wasStreamActiveRecently(2, sStreamOverrideDelayMs)) {
                        return 2;
                    }
                    if (this.wasStreamActiveRecently(5, sStreamOverrideDelayMs)) {
                        return 5;
                    }
                    return 3;
                }
                if (this.wasStreamActiveRecently(5, sStreamOverrideDelayMs)) {
                    return 5;
                }
                if (!this.wasStreamActiveRecently(2, sStreamOverrideDelayMs)) break;
                return 2;
            }
        }
        if (this.isInCommunication()) {
            if (AudioSystem.getForceUse(0) == 3) {
                return 6;
            }
            return 0;
        }
        if (AudioSystem.isStreamActive(5, sStreamOverrideDelayMs)) {
            return 5;
        }
        if (AudioSystem.isStreamActive(2, sStreamOverrideDelayMs)) {
            return 2;
        }
        if (suggestedStreamType == Integer.MIN_VALUE) {
            if (AudioSystem.isStreamActive(5, sStreamOverrideDelayMs)) {
                return 5;
            }
            if (AudioSystem.isStreamActive(2, sStreamOverrideDelayMs)) {
                return 2;
            }
            return 3;
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode(String action, int ringerMode) {
        Intent broadcast = new Intent(action);
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", ringerMode);
        broadcast.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(broadcast);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (this.mActivityManagerInternal.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.sendBroadcastToAll(broadcast);
        }
    }

    private void queueMsgUnderWakeLock(Handler handler, int msg, int arg1, int arg2, Object obj, int delay) {
        long ident = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(ident);
        AudioService.sendMsg(handler, msg, 2, arg1, arg2, obj, delay);
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        long time = SystemClock.uptimeMillis() + (long)delay;
        handler.sendMessageAtTime(handler.obtainMessage(msg, arg1, arg2, obj), time);
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    int getDeviceForStream(int stream) {
        int device = this.getDevicesForStream(stream);
        if ((device & device - 1) != 0) {
            device = (device & 2) != 0 ? 2 : ((device & 0x40000) != 0 ? 262144 : ((device & 0x80000) != 0 ? 524288 : ((device & 0x200000) != 0 ? 0x200000 : (device &= 0x380))));
        }
        return device;
    }

    private int getDevicesForStream(int stream) {
        return this.getDevicesForStream(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDevicesForStream(int stream, boolean checkOthers) {
        this.ensureValidStreamType(stream);
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.mStreamStates[stream].observeDevicesForStream_syncVSS(checkOthers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void observeDevicesForStreams(int skipStream) {
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
                if (stream == skipStream) continue;
                this.mStreamStates[stream].observeDevicesForStream_syncVSS(false);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void postObserveDevicesForAllStreams() {
        AudioService.sendMsg(this.mAudioHandler, 27, 2, 0, 0, null, 0);
    }

    private void onObserveDevicesForAllStreams() {
        this.observeDevicesForStreams(-1);
    }

    @Override
    public void setWiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
        if (state != 1 && state != 0) {
            throw new IllegalArgumentException("Invalid state " + state);
        }
        this.mDeviceBroker.setWiredDeviceConnectionState(type, state, address, name, caller);
    }

    @Override
    public void setBluetoothHearingAidDeviceConnectionState(BluetoothDevice device, int state, boolean suppressNoisyIntent, int musicDevice) {
        if (device == null) {
            throw new IllegalArgumentException("Illegal null device");
        }
        if (state != 2 && state != 0) {
            throw new IllegalArgumentException("Illegal BluetoothProfile state for device  (dis)connection, got " + state);
        }
        if (state == 2) {
            this.mPlaybackMonitor.registerPlaybackCallback(this.mVoiceActivityMonitor, true);
        } else {
            this.mPlaybackMonitor.unregisterPlaybackCallback(this.mVoiceActivityMonitor);
        }
        this.mDeviceBroker.postBluetoothHearingAidDeviceConnectionState(device, state, suppressNoisyIntent, musicDevice, "AudioService");
    }

    @Override
    public void setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int a2dpVolume) {
        if (device == null) {
            throw new IllegalArgumentException("Illegal null device");
        }
        if (state != 2 && state != 0) {
            throw new IllegalArgumentException("Illegal BluetoothProfile state for device  (dis)connection, got " + state);
        }
        this.mDeviceBroker.postBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(device, state, profile, suppressNoisyIntent, a2dpVolume);
    }

    @Override
    public void handleBluetoothA2dpDeviceConfigChange(BluetoothDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Illegal null device");
        }
        this.mDeviceBroker.postBluetoothA2dpDeviceConfigChange(device);
    }

    void postAccessoryPlugMediaUnmute(int newDevice) {
        AudioService.sendMsg(this.mAudioHandler, 21, 2, newDevice, 0, null, 0);
    }

    private void onAccessoryPlugMediaUnmute(int newDevice) {
        if (this.mNm.getZenMode() != 2 && (newDevice & 0x402678C) != 0 && this.mStreamStates[3].mIsMuted && this.mStreamStates[3].getIndex(newDevice) != 0 && (newDevice & AudioSystem.getDevicesForStream(3)) != 0) {
            this.mStreamStates[3].mute(false);
        }
    }

    @Override
    public boolean hasHapticChannels(Uri uri) {
        MediaExtractor extractor = new MediaExtractor();
        try {
            extractor.setDataSource(this.mContext, uri, null);
            for (int i = 0; i < extractor.getTrackCount(); ++i) {
                MediaFormat format = extractor.getTrackFormat(i);
                if (!format.containsKey("haptic-channel-count") || format.getInteger("haptic-channel-count") <= 0) continue;
                return true;
            }
        }
        catch (IOException e) {
            Log.e(TAG, "hasHapticChannels failure:" + e);
        }
        return false;
    }

    void postSetVolumeIndexOnDevice(int streamType, int vssVolIndex, int device, String caller) {
        AudioService.sendMsg(this.mAudioHandler, 26, 2, 0, 0, new DeviceVolumeUpdate(streamType, vssVolIndex, device, caller), 0);
    }

    void postApplyVolumeOnDevice(int streamType, int device, String caller) {
        AudioService.sendMsg(this.mAudioHandler, 26, 2, 0, 0, new DeviceVolumeUpdate(streamType, device, caller), 0);
    }

    private void onSetVolumeIndexOnDevice(DeviceVolumeUpdate update) {
        VolumeStreamState streamState = this.mStreamStates[update.mStreamType];
        if (update.hasVolumeIndex()) {
            int index = update.getVolumeIndex();
            streamState.setIndex(index, update.mDevice, update.mCaller);
            sVolumeLogger.log(new AudioEventLogger.StringEvent(update.mCaller + " dev:0x" + Integer.toHexString(update.mDevice) + " volIdx:" + index));
        } else {
            sVolumeLogger.log(new AudioEventLogger.StringEvent(update.mCaller + " update vol on dev:0x" + Integer.toHexString(update.mDevice)));
        }
        this.setDeviceVolume(streamState, update.mDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceVolume(VolumeStreamState streamState, int device) {
        boolean isAvrcpAbsVolSupported = this.mDeviceBroker.isAvrcpAbsoluteVolumeSupported();
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            streamState.applyDeviceVolume_syncVSS(device, isAvrcpAbsVolSupported);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                int streamDevice = this.getDeviceForStream(streamType);
                if (device != streamDevice && isAvrcpAbsVolSupported && (device & 0x380) != 0) {
                    this.mStreamStates[streamType].applyDeviceVolume_syncVSS(device, isAvrcpAbsVolSupported);
                }
                this.mStreamStates[streamType].applyDeviceVolume_syncVSS(streamDevice, isAvrcpAbsVolSupported);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            AudioService.sendMsg(this.mAudioHandler, 1, 2, device, 0, streamState, 500);
            return;
        }
    }

    @Override
    public void avrcpSupportsAbsoluteVolume(String address, boolean support) {
        sVolumeLogger.log(new AudioEventLogger.StringEvent("avrcpSupportsAbsoluteVolume addr=" + address + " support=" + support));
        this.mDeviceBroker.setAvrcpAbsoluteVolumeSupported(support);
        AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[3], 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasMediaDynamicPolicy() {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app;
            if (this.mAudioPolicies.isEmpty()) {
                return false;
            }
            Collection<AudioPolicyProxy> appColl = this.mAudioPolicies.values();
            Iterator<AudioPolicyProxy> iterator = appColl.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(app = iterator.next()).hasMixAffectingUsage(1));
            return true;
        }
    }

    void checkMusicActive(int deviceType, String caller) {
        if ((deviceType & 0x400000C) != 0) {
            AudioService.sendMsg(this.mAudioHandler, 11, 0, 0, 0, caller, 60000);
        }
    }

    private void handleAudioEffectBroadcast(Context context, Intent intent) {
        ResolveInfo ri;
        String target = intent.getPackage();
        if (target != null) {
            Log.w(TAG, "effect broadcast already targeted to " + target);
            return;
        }
        intent.addFlags(32);
        List<ResolveInfo> ril = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        if (ril != null && ril.size() != 0 && (ri = ril.get(0)) != null && ri.activityInfo != null && ri.activityInfo.packageName != null) {
            intent.setPackage(ri.activityInfo.packageName);
            context.sendBroadcastAsUser(intent, UserHandle.ALL);
            return;
        }
        Log.w(TAG, "couldn't find receiver package for effect intent");
    }

    private void killBackgroundUserProcessesWithRecordAudioPermission(UserInfo oldUser) {
        List packages;
        PackageManager pm = this.mContext.getPackageManager();
        ComponentName homeActivityName = null;
        if (!oldUser.isManagedProfile()) {
            homeActivityName = LocalServices.getService(ActivityTaskManagerInternal.class).getHomeActivityForUser(oldUser.id);
        }
        String[] permissions = new String[]{"android.permission.RECORD_AUDIO"};
        try {
            packages = AppGlobals.getPackageManager().getPackagesHoldingPermissions(permissions, 0, oldUser.id).getList();
        }
        catch (RemoteException e) {
            throw new AndroidRuntimeException(e);
        }
        for (int j = packages.size() - 1; j >= 0; --j) {
            PackageInfo pkg = (PackageInfo)packages.get(j);
            if (UserHandle.getAppId(pkg.applicationInfo.uid) < 10000 || pm.checkPermission("android.permission.INTERACT_ACROSS_USERS", pkg.packageName) == 0 || homeActivityName != null && pkg.packageName.equals(homeActivityName.getPackageName()) && pkg.applicationInfo.isSystemApp()) continue;
            try {
                int uid = pkg.applicationInfo.uid;
                ActivityManager.getService().killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), "killBackgroundUserProcessesWithAudioRecordPermission");
                continue;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling killUid", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceFocusDuckingForAccessibility(AudioAttributes aa, int request, int uid) {
        if (aa == null || aa.getUsage() != 11 || request != 3) {
            return false;
        }
        Bundle extraInfo = aa.getBundle();
        if (extraInfo == null || !extraInfo.getBoolean("a11y_force_ducking")) {
            return false;
        }
        if (uid == 0) {
            return true;
        }
        Object object = this.mAccessibilityServiceUidsLock;
        synchronized (object) {
            if (this.mAccessibilityServiceUids != null) {
                int callingUid = Binder.getCallingUid();
                for (int i = 0; i < this.mAccessibilityServiceUids.length; ++i) {
                    if (this.mAccessibilityServiceUids[i] != callingUid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, IAudioPolicyCallback pcb, int sdk) {
        if ((flags & 4) == 4) {
            if ("AudioFocus_For_Phone_Ring_And_Calls".equals(clientId)) {
                if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE")) {
                    Log.e(TAG, "Invalid permission to (un)lock audio focus", new Exception());
                    return 0;
                }
            } else {
                HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
                synchronized (hashMap) {
                    if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                        Log.e(TAG, "Invalid unregistered AudioPolicy to (un)lock audio focus");
                        return 0;
                    }
                }
            }
        }
        if (callingPackageName == null || clientId == null || aa == null) {
            Log.e(TAG, "Invalid null parameter to request audio focus");
            return 0;
        }
        return this.mMediaFocusControl.requestAudioFocus(aa, durationHint, cb, fd, clientId, callingPackageName, flags, sdk, this.forceFocusDuckingForAccessibility(aa, durationHint, Binder.getCallingUid()));
    }

    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) {
        return this.mMediaFocusControl.abandonAudioFocus(fd, clientId, aa, callingPackageName);
    }

    @Override
    public void unregisterAudioFocusClient(String clientId) {
        this.mMediaFocusControl.unregisterAudioFocusClient(clientId);
    }

    @Override
    public int getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    @Override
    public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) {
        return MediaFocusControl.getFocusRampTimeMs(focusGain, attr2);
    }

    boolean hasAudioFocusUsers() {
        return this.mMediaFocusControl.hasAudioFocusUsers();
    }

    private boolean readCameraSoundForced() {
        return SystemProperties.getBoolean("audio.camerasound.force", false) || this.mContext.getResources().getBoolean(17891385);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleConfigurationChanged(Context context) {
        try {
            Configuration config = context.getResources().getConfiguration();
            AudioService.sendMsg(this.mAudioHandler, 12, 0, 0, 0, TAG, 0);
            boolean cameraSoundForced = this.readCameraSoundForced();
            Object object = this.mSettingsLock;
            // MONITORENTER : object
            boolean cameraSoundForcedChanged = cameraSoundForced != this.mCameraSoundForced;
            this.mCameraSoundForced = cameraSoundForced;
            if (cameraSoundForcedChanged) {
                if (!this.mIsSingleVolume) {
                    Class<VolumeStreamState> clazz = VolumeStreamState.class;
                    // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
                    VolumeStreamState s = this.mStreamStates[7];
                    if (cameraSoundForced) {
                        s.setAllIndexesToMax();
                        this.mRingerModeAffectedStreams &= 0xFFFFFF7F;
                    } else {
                        s.setAllIndexes(this.mStreamStates[1], TAG);
                        this.mRingerModeAffectedStreams |= 0x80;
                    }
                    // MONITOREXIT : clazz
                    this.setRingerModeInt(this.getRingerModeInternal(), false);
                }
                this.mDeviceBroker.setForceUse_Async(4, cameraSoundForced ? 11 : 0, "handleConfigurationChanged");
                AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
            }
            // MONITOREXIT : object
            this.mVolumeController.setLayoutDirection(config.getLayoutDirection());
            return;
        }
        catch (Exception e) {
            Log.e(TAG, "Error handling configuration change: ", e);
        }
    }

    @Override
    public void setRingtonePlayer(IRingtonePlayer player) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = player;
    }

    @Override
    public IRingtonePlayer getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    @Override
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        return this.mDeviceBroker.startWatchingRoutes(observer);
    }

    private int safeMediaVolumeIndex(int device) {
        if ((device & 0x400000C) == 0) {
            return MAX_STREAM_VOLUME[3];
        }
        if (device == 0x4000000) {
            return this.mSafeUsbMediaVolumeIndex;
        }
        return this.mSafeMediaVolumeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSafeMediaVolumeEnabled(boolean on, String caller) {
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (on && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume(caller);
                } else if (!on && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 1;
                    this.saveMusicActiveMs();
                    AudioService.sendMsg(this.mAudioHandler, 11, 0, 0, 0, caller, 60000);
                }
            }
        }
    }

    private void enforceSafeMediaVolume(String caller) {
        VolumeStreamState streamState = this.mStreamStates[3];
        int devices = 0x400000C;
        int i = 0;
        while (devices != 0) {
            int device;
            if (((device = 1 << i++) & devices) == 0) continue;
            int index = streamState.getIndex(device);
            if (index > this.safeMediaVolumeIndex(device)) {
                streamState.setIndex(this.safeMediaVolumeIndex(device), device, caller);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            devices &= ~device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSafeMediaVolume(int streamType, int index, int device) {
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            return this.mSafeMediaVolumeState != 3 || mStreamVolumeAlias[streamType] != 3 || (device & 0x400000C) == 0 || index <= this.safeMediaVolumeIndex(device);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSafeMediaVolume(String callingPackage) {
        this.enforceVolumeController("disable the safe media volume");
        Object object = this.mSafeMediaVolumeStateLock;
        synchronized (object) {
            this.setSafeMediaVolumeEnabled(false, callingPackage);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice, callingPackage);
                this.mPendingVolumeCommand = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setHdmiSystemAudioSupported(boolean on) {
        int device = 0;
        Object object = this.mHdmiClientLock;
        synchronized (object) {
            if (this.mHdmiManager != null) {
                if (this.mHdmiTvClient == null && this.mHdmiAudioSystemClient == null) {
                    Log.w(TAG, "Only Hdmi-Cec enabled TV or audio system device supportssystem audio mode.");
                    return device;
                }
                if (this.mHdmiSystemAudioSupported != on) {
                    this.mHdmiSystemAudioSupported = on;
                    int config = on ? 12 : 0;
                    this.mDeviceBroker.setForceUse_Async(5, config, "setHdmiSystemAudioSupported");
                }
                device = this.getDevicesForStream(3);
            }
        }
        return device;
    }

    @Override
    public boolean isHdmiSystemAudioSupported() {
        return this.mHdmiSystemAudioSupported;
    }

    private void initA11yMonitoring() {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        this.updateDefaultStreamOverrideDelay(accessibilityManager.isTouchExplorationEnabled());
        this.updateA11yVolumeAlias(accessibilityManager.isAccessibilityVolumeStreamActive());
        accessibilityManager.addTouchExplorationStateChangeListener(this, null);
        accessibilityManager.addAccessibilityServicesStateChangeListener(this, null);
    }

    @Override
    public void onTouchExplorationStateChanged(boolean enabled) {
        this.updateDefaultStreamOverrideDelay(enabled);
    }

    private void updateDefaultStreamOverrideDelay(boolean touchExploreEnabled) {
        sStreamOverrideDelayMs = touchExploreEnabled ? 1000 : 0;
    }

    @Override
    public void onAccessibilityServicesStateChanged(AccessibilityManager accessibilityManager) {
        this.updateA11yVolumeAlias(accessibilityManager.isAccessibilityVolumeStreamActive());
    }

    private void updateA11yVolumeAlias(boolean a11VolEnabled) {
        if (sIndependentA11yVolume != a11VolEnabled) {
            sIndependentA11yVolume = a11VolEnabled;
            this.updateStreamVolumeAlias(true, TAG);
            this.mVolumeController.setA11yMode(sIndependentA11yVolume ? 1 : 0);
            this.mVolumeController.postVolumeChanged(10, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraSoundForced() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mCameraSoundForced;
        }
    }

    private void dumpRingerMode(PrintWriter pw) {
        pw.println("\nRinger mode: ");
        pw.println("- mode (internal) = " + RINGER_MODE_NAMES[this.mRingerMode]);
        pw.println("- mode (external) = " + RINGER_MODE_NAMES[this.mRingerModeExternal]);
        this.dumpRingerModeStreams(pw, "affected", this.mRingerModeAffectedStreams);
        this.dumpRingerModeStreams(pw, "muted", this.mRingerAndZenModeMutedStreams);
        pw.print("- delegate = ");
        pw.println(this.mRingerModeDelegate);
    }

    private void dumpRingerModeStreams(PrintWriter pw, String type, int streams) {
        pw.print("- ringer mode ");
        pw.print(type);
        pw.print(" streams = 0x");
        pw.print(Integer.toHexString(streams));
        if (streams != 0) {
            pw.print(" (");
            boolean first = true;
            for (int i = 0; i < AudioSystem.STREAM_NAMES.length; ++i) {
                int stream = 1 << i;
                if ((streams & stream) == 0) continue;
                if (!first) {
                    pw.print(',');
                }
                pw.print(AudioSystem.STREAM_NAMES[i]);
                streams &= ~stream;
                first = false;
            }
            if (streams != 0) {
                if (!first) {
                    pw.print(',');
                }
                pw.print(streams);
            }
            pw.print(')');
        }
        pw.println();
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        this.mMediaFocusControl.dump(pw);
        this.dumpStreamStates(pw);
        this.dumpRingerMode(pw);
        pw.println("\nAudio routes:");
        pw.print("  mMainType=0x");
        pw.println(Integer.toHexString(this.mDeviceBroker.getCurAudioRoutes().mainType));
        pw.print("  mBluetoothName=");
        pw.println(this.mDeviceBroker.getCurAudioRoutes().bluetoothName);
        pw.println("\nOther state:");
        pw.print("  mVolumeController=");
        pw.println(this.mVolumeController);
        pw.print("  mSafeMediaVolumeState=");
        pw.println(AudioService.safeMediaVolumeStateToString(this.mSafeMediaVolumeState));
        pw.print("  mSafeMediaVolumeIndex=");
        pw.println(this.mSafeMediaVolumeIndex);
        pw.print("  mSafeUsbMediaVolumeIndex=");
        pw.println(this.mSafeUsbMediaVolumeIndex);
        pw.print("  mSafeUsbMediaVolumeDbfs=");
        pw.println(this.mSafeUsbMediaVolumeDbfs);
        pw.print("  sIndependentA11yVolume=");
        pw.println(sIndependentA11yVolume);
        pw.print("  mPendingVolumeCommand=");
        pw.println(this.mPendingVolumeCommand);
        pw.print("  mMusicActiveMs=");
        pw.println(this.mMusicActiveMs);
        pw.print("  mMcc=");
        pw.println(this.mMcc);
        pw.print("  mCameraSoundForced=");
        pw.println(this.mCameraSoundForced);
        pw.print("  mHasVibrator=");
        pw.println(this.mHasVibrator);
        pw.print("  mVolumePolicy=");
        pw.println(this.mVolumePolicy);
        pw.print("  mAvrcpAbsVolSupported=");
        pw.println(this.mDeviceBroker.isAvrcpAbsoluteVolumeSupported());
        pw.print("  mIsSingleVolume=");
        pw.println(this.mIsSingleVolume);
        pw.print("  mUseFixedVolume=");
        pw.println(this.mUseFixedVolume);
        pw.print("  mFixedVolumeDevices=0x");
        pw.println(Integer.toHexString(this.mFixedVolumeDevices));
        pw.print("  mHdmiCecSink=");
        pw.println(this.mHdmiCecSink);
        pw.print("  mHdmiAudioSystemClient=");
        pw.println(this.mHdmiAudioSystemClient);
        pw.print("  mHdmiPlaybackClient=");
        pw.println(this.mHdmiPlaybackClient);
        pw.print("  mHdmiTvClient=");
        pw.println(this.mHdmiTvClient);
        pw.print("  mHdmiSystemAudioSupported=");
        pw.println(this.mHdmiSystemAudioSupported);
        this.dumpAudioPolicies(pw);
        this.mDynPolicyLogger.dump(pw);
        this.mPlaybackMonitor.dump(pw);
        this.mRecordMonitor.dump(pw);
        pw.println("\n");
        pw.println("\nEvent logs:");
        this.mModeLogger.dump(pw);
        pw.println("\n");
        sDeviceLogger.dump(pw);
        pw.println("\n");
        sForceUseLogger.dump(pw);
        pw.println("\n");
        sVolumeLogger.dump(pw);
    }

    private static String safeMediaVolumeStateToString(int state) {
        switch (state) {
            case 0: {
                return "SAFE_MEDIA_VOLUME_NOT_CONFIGURED";
            }
            case 1: {
                return "SAFE_MEDIA_VOLUME_DISABLED";
            }
            case 2: {
                return "SAFE_MEDIA_VOLUME_INACTIVE";
            }
            case 3: {
                return "SAFE_MEDIA_VOLUME_ACTIVE";
            }
        }
        return null;
    }

    private static void readAndSetLowRamDevice() {
        boolean isLowRamDevice = ActivityManager.isLowRamDeviceStatic();
        long totalMemory = 0x40000000L;
        try {
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            ActivityManager.getService().getMemoryInfo(info);
            totalMemory = info.totalMem;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot obtain MemoryInfo from ActivityManager, assume low memory device");
            isLowRamDevice = true;
        }
        int status = AudioSystem.setLowRamDevice(isLowRamDevice, totalMemory);
        if (status != 0) {
            Log.w(TAG, "AudioFlinger informed of device's low RAM attribute; status " + status);
        }
    }

    private void enforceVolumeController(String action) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "Only SystemUI can " + action);
    }

    @Override
    public void setVolumeController(final IVolumeController controller) {
        this.enforceVolumeController("set the volume controller");
        if (this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.postDismiss();
        if (controller != null) {
            try {
                controller.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        if (AudioService.this.mVolumeController.isSameBinder(controller)) {
                            Log.w(AudioService.TAG, "Current remote volume controller died, unregistering");
                            AudioService.this.setVolumeController(null);
                        }
                    }
                }, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mVolumeController.setController(controller);
    }

    @Override
    public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        this.enforceVolumeController("notify about volume controller visibility");
        if (!this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.setVisible(visible);
    }

    @Override
    public void setVolumePolicy(VolumePolicy policy) {
        this.enforceVolumeController("set volume policy");
        if (policy != null && !policy.equals(this.mVolumePolicy)) {
            this.mVolumePolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) {
        AudioSystem.setDynamicPolicyCallback(this.mDynPolicyCallback);
        if (!this.isPolicyRegisterAllowed(policyConfig, isFocusPolicy || isTestFocusPolicy || hasFocusListener, isVolumeController, projection)) {
            Slog.w(TAG, "Permission denied to register audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING or MediaProjection that can project audio");
            return null;
        }
        this.mDynPolicyLogger.log(new AudioEventLogger.StringEvent("registerAudioPolicy for " + pcb.asBinder() + " with config:" + policyConfig).printLog(TAG));
        String regId = null;
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            if (this.mAudioPolicies.containsKey(pcb.asBinder())) {
                Slog.e(TAG, "Cannot re-register policy");
                return null;
            }
            try {
                AudioPolicyProxy app = new AudioPolicyProxy(policyConfig, pcb, hasFocusListener, isFocusPolicy, isTestFocusPolicy, isVolumeController, projection);
                pcb.asBinder().linkToDeath(app, 0);
                regId = app.getRegistrationId();
                this.mAudioPolicies.put(pcb.asBinder(), app);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Audio policy registration failed, could not link to " + pcb + " binder death", e);
                return null;
            }
            catch (IllegalStateException e) {
                Slog.w(TAG, "Audio policy registration failed for binder " + pcb, e);
                return null;
            }
            return regId;
        }
    }

    private boolean isPolicyRegisterAllowed(AudioPolicyConfig policyConfig, boolean hasFocusAccess, boolean isVolumeController, IMediaProjection projection) {
        boolean requireValidProjection = false;
        boolean requireCaptureAudioOrMediaOutputPerm = false;
        boolean requireModifyRouting = false;
        if (hasFocusAccess || isVolumeController) {
            requireModifyRouting |= true;
        } else if (policyConfig.getMixes().isEmpty()) {
            requireModifyRouting |= true;
        }
        for (AudioMix mix : policyConfig.getMixes()) {
            if (mix.getRule().allowPrivilegedPlaybackCapture()) {
                requireCaptureAudioOrMediaOutputPerm |= true;
                String error = AudioMix.canBeUsedForPrivilegedCapture(mix.getFormat());
                if (error != null) {
                    Log.e(TAG, error);
                    return false;
                }
            }
            if (mix.getRouteFlags() == 3 && projection != null) {
                requireValidProjection |= true;
                continue;
            }
            requireModifyRouting |= true;
        }
        if (requireCaptureAudioOrMediaOutputPerm && !this.callerHasPermission("android.permission.CAPTURE_MEDIA_OUTPUT") && !this.callerHasPermission("android.permission.CAPTURE_AUDIO_OUTPUT")) {
            Log.e(TAG, "Privileged audio capture requires CAPTURE_MEDIA_OUTPUT or CAPTURE_AUDIO_OUTPUT system permission");
            return false;
        }
        if (requireValidProjection && !this.canProjectAudio(projection)) {
            return false;
        }
        if (requireModifyRouting && !this.callerHasPermission("android.permission.MODIFY_AUDIO_ROUTING")) {
            Log.e(TAG, "Can not capture audio without MODIFY_AUDIO_ROUTING");
            return false;
        }
        return true;
    }

    private boolean callerHasPermission(String permission2) {
        return this.mContext.checkCallingPermission(permission2) == 0;
    }

    private boolean canProjectAudio(IMediaProjection projection) {
        if (projection == null) {
            Log.e(TAG, "MediaProjection is null");
            return false;
        }
        IMediaProjectionManager projectionService = this.getProjectionService();
        if (projectionService == null) {
            Log.e(TAG, "Can't get service IMediaProjectionManager");
            return false;
        }
        try {
            if (!projectionService.isValidMediaProjection(projection)) {
                Log.w(TAG, "App passed invalid MediaProjection token");
                return false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call .isValidMediaProjection() on IMediaProjectionManager" + projectionService.asBinder(), e);
            return false;
        }
        try {
            if (!projection.canProjectAudio()) {
                Log.w(TAG, "App passed MediaProjection that can not project audio");
                return false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call .canProjectAudio() on valid IMediaProjection" + projection.asBinder(), e);
            return false;
        }
        return true;
    }

    private IMediaProjectionManager getProjectionService() {
        if (this.mProjectionService == null) {
            IBinder b = ServiceManager.getService("media_projection");
            this.mProjectionService = IMediaProjectionManager.Stub.asInterface(b);
        }
        return this.mProjectionService;
    }

    @Override
    public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) {
        this.unregisterAudioPolicy(pcb);
    }

    @Override
    public void unregisterAudioPolicy(IAudioPolicyCallback pcb) {
        if (pcb == null) {
            return;
        }
        this.unregisterAudioPolicyInt(pcb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAudioPolicyInt(IAudioPolicyCallback pcb) {
        this.mDynPolicyLogger.log(new AudioEventLogger.StringEvent("unregisterAudioPolicyAsync for " + pcb.asBinder()).printLog(TAG));
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.mAudioPolicies.remove(pcb.asBinder());
            if (app == null) {
                Slog.w(TAG, "Trying to unregister unknown audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
                return;
            }
            pcb.asBinder().unlinkToDeath(app, 0);
            app.release();
        }
    }

    @GuardedBy(value={"mAudioPolicies"})
    private AudioPolicyProxy checkUpdateForPolicy(IAudioPolicyCallback pcb, String errorMsg) {
        boolean hasPermissionForPolicy;
        boolean bl = hasPermissionForPolicy = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        if (!hasPermissionForPolicy) {
            Slog.w(TAG, errorMsg + " for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return null;
        }
        AudioPolicyProxy app = this.mAudioPolicies.get(pcb.asBinder());
        if (app == null) {
            Slog.w(TAG, errorMsg + " for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", unregistered policy");
            return null;
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot add AudioMix in audio policy");
            if (app == null) {
                return -1;
            }
            return app.addMixes(policyConfig.getMixes()) == 0 ? 0 : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot add AudioMix in audio policy");
            if (app == null) {
                return -1;
            }
            return app.removeMixes(policyConfig.getMixes()) == 0 ? 0 : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot change device affinity in audio policy");
            if (app == null) {
                return -1;
            }
            if (!app.hasMixRoutedToDevices(deviceTypes, deviceAddresses)) {
                return -1;
            }
            return app.setUidDeviceAffinities(uid, deviceTypes, deviceAddresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot remove device affinity in audio policy");
            if (app == null) {
                return -1;
            }
            return app.removeUidDeviceAffinities(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot change audio policy focus properties");
            if (app == null) {
                return -1;
            }
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                Slog.e(TAG, "Cannot change audio policy focus properties, unregistered policy");
                return -1;
            }
            if (duckingBehavior == 1) {
                for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                    if (policy.mFocusDuckBehavior != 1) continue;
                    Slog.e(TAG, "Cannot change audio policy ducking behavior, already handled");
                    return -1;
                }
            }
            app.mFocusDuckBehavior = duckingBehavior;
            this.mMediaFocusControl.setDuckingInExtPolicyAvailable(duckingBehavior == 1);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRegisteredDynamicPolicy() {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            return !this.mAudioPolicies.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtVolumeController(IAudioPolicyCallback apc) {
        if (!this.mContext.getResources().getBoolean(17891462)) {
            Log.e(TAG, "Cannot set external volume controller: device not set for volume keys handled in PhoneWindowManager");
            return;
        }
        Object object = this.mExtVolumeControllerLock;
        synchronized (object) {
            if (this.mExtVolumeController != null && !this.mExtVolumeController.asBinder().pingBinder()) {
                Log.e(TAG, "Cannot set external volume controller: existing controller");
            }
            this.mExtVolumeController = apc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAudioPolicies(PrintWriter pw) {
        pw.println("\nAudio policies:");
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                pw.println(policy.toLogFriendlyString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onDynPolicyMixStateUpdate(String regId, int state) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy policy;
            Iterator<AudioPolicyProxy> iterator = this.mAudioPolicies.values().iterator();
            block5: while (true) {
                AudioMix mix;
                if (!iterator.hasNext()) return;
                policy = iterator.next();
                Iterator<AudioMix> iterator2 = policy.getMixes().iterator();
                do {
                    if (!iterator2.hasNext()) continue block5;
                } while (!(mix = iterator2.next()).getRegistration().equals(regId));
                break;
            }
            try {
                policy.mPolicyCallback.notifyMixStateUpdate(regId, state);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyMixStateUpdate() on IAudioPolicyCallback " + policy.mPolicyCallback.asBinder(), e);
            }
            return;
        }
    }

    @Override
    public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) {
        boolean isPrivileged = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        this.mRecordMonitor.registerRecordingCallback(rcdb, isPrivileged);
    }

    @Override
    public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) {
        this.mRecordMonitor.unregisterRecordingCallback(rcdb);
    }

    @Override
    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() {
        boolean isPrivileged = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        return this.mRecordMonitor.getActiveRecordingConfigurations(isPrivileged);
    }

    @Override
    public int trackRecorder(IBinder recorder) {
        return this.mRecordMonitor.trackRecorder(recorder);
    }

    @Override
    public void recorderEvent(int riid, int event) {
        this.mRecordMonitor.recorderEvent(riid, event);
    }

    @Override
    public void releaseRecorder(int riid) {
        this.mRecordMonitor.releaseRecorder(riid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableRingtoneSync(int userId) {
        int callingUserId = UserHandle.getCallingUserId();
        if (callingUserId != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "disable sound settings syncing for another profile");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putIntForUser(this.mContentResolver, "sync_parent_sounds", 0, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        boolean isPrivileged = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        this.mPlaybackMonitor.registerPlaybackCallback(pcdb, isPrivileged);
    }

    @Override
    public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        this.mPlaybackMonitor.unregisterPlaybackCallback(pcdb);
    }

    @Override
    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() {
        boolean isPrivileged = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        return this.mPlaybackMonitor.getActivePlaybackConfigurations(isPrivileged);
    }

    @Override
    public int trackPlayer(PlayerBase.PlayerIdCard pic) {
        return this.mPlaybackMonitor.trackPlayer(pic);
    }

    @Override
    public void playerAttributes(int piid, AudioAttributes attr2) {
        this.mPlaybackMonitor.playerAttributes(piid, attr2, Binder.getCallingUid());
    }

    @Override
    public void playerEvent(int piid, int event) {
        this.mPlaybackMonitor.playerEvent(piid, event, Binder.getCallingUid());
    }

    @Override
    public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) {
        this.mPlaybackMonitor.playerHasOpPlayAudio(piid, hasOpPlayAudio, Binder.getCallingUid());
    }

    @Override
    public void releasePlayer(int piid) {
        this.mPlaybackMonitor.releasePlayer(piid, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) {
        if (afi == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusInfo");
        }
        if (pcb == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy callback");
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                throw new IllegalStateException("Unregistered AudioPolicy for focus dispatch");
            }
            return this.mMediaFocusControl.dispatchFocusChange(afi, focusChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) {
        if (afi == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusInfo");
        }
        if (pcb == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy callback");
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                throw new IllegalStateException("Unregistered AudioPolicy for external focus");
            }
            this.mMediaFocusControl.setFocusRequestResultFromExtPolicy(afi, requestResult);
        }
    }

    private void checkMonitorAudioServerStatePermission() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING") != 0) {
            throw new SecurityException("Not allowed to monitor audioserver state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) {
        this.checkMonitorAudioServerStatePermission();
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            if (this.mAudioServerStateListeners.containsKey(asd.asBinder())) {
                Slog.w(TAG, "Cannot re-register audio server state dispatcher");
                return;
            }
            AsdProxy asdp = new AsdProxy(asd);
            try {
                asd.asBinder().linkToDeath(asdp, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mAudioServerStateListeners.put(asd.asBinder(), asdp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) {
        this.checkMonitorAudioServerStatePermission();
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            AsdProxy asdp = this.mAudioServerStateListeners.remove(asd.asBinder());
            if (asdp == null) {
                Slog.w(TAG, "Trying to unregister unknown audioserver state dispatcher for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
                return;
            }
            asd.asBinder().unlinkToDeath(asdp, 0);
        }
    }

    @Override
    public boolean isAudioServerRunning() {
        this.checkMonitorAudioServerStatePermission();
        return AudioSystem.checkAudioFlinger() == 0;
    }

    static /* synthetic */ int[] access$9202(AudioService x0, int[] x1) {
        x0.mAccessibilityServiceUids = x1;
        return x1;
    }

    static {
        STREAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36, 64};
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
        sIndependentA11yVolume = false;
        sDeviceLogger = new AudioEventLogger(30, "wired/A2DP/hearing aid device connection");
        sForceUseLogger = new AudioEventLogger(20, "force use (logged before setForceUse() is executed)");
        sVolumeLogger = new AudioEventLogger(40, "volume changes (logged when command received by AudioService)");
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    private class AsdProxy
    implements IBinder.DeathRecipient {
        private final IAudioServerStateDispatcher mAsd;

        AsdProxy(IAudioServerStateDispatcher asd) {
            this.mAsd = asd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            HashMap hashMap = AudioService.this.mAudioServerStateListeners;
            synchronized (hashMap) {
                AudioService.this.mAudioServerStateListeners.remove(this.mAsd.asBinder());
            }
        }

        IAudioServerStateDispatcher callback() {
            return this.mAsd;
        }
    }

    public class AudioPolicyProxy
    extends AudioPolicyConfig
    implements IBinder.DeathRecipient {
        private static final String TAG = "AudioPolicyProxy";
        final IAudioPolicyCallback mPolicyCallback;
        final boolean mHasFocusListener;
        final boolean mIsVolumeController;
        final HashMap<Integer, AudioDeviceArray> mUidDeviceAffinities;
        final IMediaProjection mProjection;
        UnregisterOnStopCallback mProjectionCallback;
        int mFocusDuckBehavior;
        boolean mIsFocusPolicy;
        boolean mIsTestFocusPolicy;

        AudioPolicyProxy(AudioPolicyConfig config, IAudioPolicyCallback token, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) {
            int status;
            super(config);
            this.mUidDeviceAffinities = new HashMap();
            this.mFocusDuckBehavior = 0;
            this.mIsFocusPolicy = false;
            this.mIsTestFocusPolicy = false;
            this.setRegistration(new String(config.hashCode() + ":ap:" + AudioService.this.mAudioPolicyCounter++));
            this.mPolicyCallback = token;
            this.mHasFocusListener = hasFocusListener;
            this.mIsVolumeController = isVolumeController;
            this.mProjection = projection;
            if (this.mHasFocusListener) {
                AudioService.this.mMediaFocusControl.addFocusFollower(this.mPolicyCallback);
                if (isFocusPolicy) {
                    this.mIsFocusPolicy = true;
                    this.mIsTestFocusPolicy = isTestFocusPolicy;
                    AudioService.this.mMediaFocusControl.setFocusPolicy(this.mPolicyCallback, this.mIsTestFocusPolicy);
                }
            }
            if (this.mIsVolumeController) {
                AudioService.this.setExtVolumeController(this.mPolicyCallback);
            }
            if (this.mProjection != null) {
                this.mProjectionCallback = new UnregisterOnStopCallback();
                try {
                    this.mProjection.registerCallback(this.mProjectionCallback);
                }
                catch (RemoteException e) {
                    this.release();
                    throw new IllegalStateException("MediaProjection callback registration failed, could not link to " + projection + " binder death", e);
                }
            }
            if ((status = this.connectMixes()) != 0) {
                this.release();
                throw new IllegalStateException("Could not connect mix, error: " + status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mAudioPolicies;
            synchronized (object) {
                Log.i(TAG, "audio policy " + this.mPolicyCallback + " died");
                this.release();
                AudioService.this.mAudioPolicies.remove(this.mPolicyCallback.asBinder());
            }
            if (this.mIsVolumeController) {
                object = AudioService.this.mExtVolumeControllerLock;
                synchronized (object) {
                    AudioService.this.mExtVolumeController = null;
                }
            }
        }

        String getRegistrationId() {
            return this.getRegistration();
        }

        void release() {
            if (this.mIsFocusPolicy) {
                AudioService.this.mMediaFocusControl.unsetFocusPolicy(this.mPolicyCallback, this.mIsTestFocusPolicy);
            }
            if (this.mFocusDuckBehavior == 1) {
                AudioService.this.mMediaFocusControl.setDuckingInExtPolicyAvailable(false);
            }
            if (this.mHasFocusListener) {
                AudioService.this.mMediaFocusControl.removeFocusFollower(this.mPolicyCallback);
            }
            if (this.mProjectionCallback != null) {
                try {
                    this.mProjection.unregisterCallback(this.mProjectionCallback);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Fail to unregister Audiopolicy callback from MediaProjection");
                }
            }
            long identity = Binder.clearCallingIdentity();
            AudioSystem.registerPolicyMixes(this.mMixes, false);
            Binder.restoreCallingIdentity(identity);
        }

        boolean hasMixAffectingUsage(int usage) {
            for (AudioMix mix : this.mMixes) {
                if (!mix.isAffectingUsage(usage)) continue;
                return true;
            }
            return false;
        }

        boolean hasMixRoutedToDevices(int[] deviceTypes, String[] deviceAddresses) {
            for (int i = 0; i < deviceTypes.length; ++i) {
                boolean hasDevice = false;
                for (AudioMix mix : this.mMixes) {
                    if (!mix.isRoutedToDevice(deviceTypes[i], deviceAddresses[i])) continue;
                    hasDevice = true;
                    break;
                }
                if (hasDevice) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int addMixes(ArrayList<AudioMix> mixes) {
            ArrayList arrayList = this.mMixes;
            synchronized (arrayList) {
                AudioSystem.registerPolicyMixes(this.mMixes, false);
                this.add(mixes);
                return AudioSystem.registerPolicyMixes(this.mMixes, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int removeMixes(ArrayList<AudioMix> mixes) {
            ArrayList arrayList = this.mMixes;
            synchronized (arrayList) {
                AudioSystem.registerPolicyMixes(this.mMixes, false);
                this.remove(mixes);
                return AudioSystem.registerPolicyMixes(this.mMixes, true);
            }
        }

        int connectMixes() {
            long identity = Binder.clearCallingIdentity();
            int status = AudioSystem.registerPolicyMixes(this.mMixes, true);
            Binder.restoreCallingIdentity(identity);
            return status;
        }

        int setUidDeviceAffinities(int uid, int[] types, String[] addresses) {
            int res;
            long identity;
            Integer Uid2 = new Integer(uid);
            if (this.mUidDeviceAffinities.remove(Uid2) != null) {
                identity = Binder.clearCallingIdentity();
                res = AudioSystem.removeUidDeviceAffinities(uid);
                Binder.restoreCallingIdentity(identity);
                if (res != 0) {
                    Log.e(TAG, "AudioSystem. removeUidDeviceAffinities(" + uid + ") failed,  cannot call AudioSystem.setUidDeviceAffinities");
                    return -1;
                }
            }
            identity = Binder.clearCallingIdentity();
            res = AudioSystem.setUidDeviceAffinities(uid, types, addresses);
            Binder.restoreCallingIdentity(identity);
            if (res == 0) {
                this.mUidDeviceAffinities.put(Uid2, new AudioDeviceArray(types, addresses));
                return 0;
            }
            Log.e(TAG, "AudioSystem. setUidDeviceAffinities(" + uid + ") failed");
            return -1;
        }

        int removeUidDeviceAffinities(int uid) {
            if (this.mUidDeviceAffinities.remove(new Integer(uid)) != null) {
                long identity = Binder.clearCallingIdentity();
                int res = AudioSystem.removeUidDeviceAffinities(uid);
                Binder.restoreCallingIdentity(identity);
                if (res == 0) {
                    return 0;
                }
            }
            Log.e(TAG, "AudioSystem. removeUidDeviceAffinities failed");
            return -1;
        }

        @Override
        public String toLogFriendlyString() {
            String textDump = super.toLogFriendlyString();
            textDump = textDump + " Proxy:\n";
            textDump = textDump + "   is focus policy= " + this.mIsFocusPolicy + "\n";
            if (this.mIsFocusPolicy) {
                textDump = textDump + "     focus duck behaviour= " + this.mFocusDuckBehavior + "\n";
                textDump = textDump + "     is test focus policy= " + this.mIsTestFocusPolicy + "\n";
                textDump = textDump + "     has focus listener= " + this.mHasFocusListener + "\n";
            }
            textDump = textDump + "   media projection= " + this.mProjection + "\n";
            return textDump;
        }

        private final class UnregisterOnStopCallback
        extends IMediaProjectionCallback.Stub {
            private UnregisterOnStopCallback() {
            }

            @Override
            public void onStop() {
                AudioService.this.unregisterAudioPolicyAsync(AudioPolicyProxy.this.mPolicyCallback);
            }
        }
    }

    private static final class AudioDeviceArray {
        final int[] mDeviceTypes;
        final String[] mDeviceAddresses;

        AudioDeviceArray(int[] types, String[] addresses) {
            this.mDeviceTypes = types;
            this.mDeviceAddresses = addresses;
        }
    }

    final class AudioServiceInternal
    extends AudioManagerInternal {
        AudioServiceInternal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRingerModeDelegate(AudioManagerInternal.RingerModeDelegate delegate) {
            AudioService.this.mRingerModeDelegate = delegate;
            if (AudioService.this.mRingerModeDelegate != null) {
                Object object = AudioService.this.mSettingsLock;
                synchronized (object) {
                    AudioService.this.updateRingerAndZenModeAffectedStreams();
                }
                this.setRingerModeInternal(this.getRingerModeInternal(), "AS.AudioService.setRingerModeDelegate");
            }
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.adjustSuggestedStreamVolume(direction, streamType, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            if (direction != 0) {
                sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(5, streamType, direction, flags, callingPackage + " uid:" + uid));
            }
            AudioService.this.adjustStreamVolume(streamType, direction, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.setStreamVolume(streamType, direction, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public int getRingerModeInternal() {
            return AudioService.this.getRingerModeInternal();
        }

        @Override
        public void setRingerModeInternal(int ringerMode, String caller) {
            AudioService.this.setRingerModeInternal(ringerMode, caller);
        }

        @Override
        public void silenceRingerModeInternal(String caller) {
            AudioService.this.silenceRingerModeInternal(caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateRingerModeAffectedStreamsInternal() {
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerAndZenModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(this.getRingerModeInternal(), false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAccessibilityServiceUids(IntArray uids) {
            Object object = AudioService.this.mAccessibilityServiceUidsLock;
            synchronized (object) {
                if (uids.size() == 0) {
                    AudioService.access$9202(AudioService.this, null);
                } else {
                    boolean changed;
                    boolean bl = changed = AudioService.this.mAccessibilityServiceUids == null || AudioService.this.mAccessibilityServiceUids.length != uids.size();
                    if (!changed) {
                        for (int i = 0; i < AudioService.this.mAccessibilityServiceUids.length; ++i) {
                            if (uids.get(i) == AudioService.this.mAccessibilityServiceUids[i]) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (changed) {
                        AudioService.access$9202(AudioService.this, uids.toArray());
                    }
                }
                AudioSystem.setA11yServicesUids(AudioService.this.mAccessibilityServiceUids);
            }
        }
    }

    public static class VolumeController {
        private static final String TAG = "VolumeController";
        private IVolumeController mController;
        private boolean mVisible;
        private long mNextLongPress;
        private int mLongPressTimeout;

        public void setController(IVolumeController controller) {
            this.mController = controller;
            this.mVisible = false;
        }

        public void loadSettings(ContentResolver cr) {
            this.mLongPressTimeout = Settings.Secure.getIntForUser(cr, "long_press_timeout", 500, -2);
        }

        public boolean suppressAdjustment(int resolvedStream, int flags, boolean isMute) {
            if (isMute) {
                return false;
            }
            boolean suppress = false;
            if (resolvedStream == 3 && this.mController != null) {
                long now = SystemClock.uptimeMillis();
                if ((flags & 1) != 0 && !this.mVisible) {
                    if (this.mNextLongPress < now) {
                        this.mNextLongPress = now + (long)this.mLongPressTimeout;
                    }
                    suppress = true;
                } else if (this.mNextLongPress > 0L) {
                    if (now > this.mNextLongPress) {
                        this.mNextLongPress = 0L;
                    } else {
                        suppress = true;
                    }
                }
            }
            return suppress;
        }

        public void setVisible(boolean visible) {
            this.mVisible = visible;
        }

        public boolean isSameBinder(IVolumeController controller) {
            return Objects.equals(this.asBinder(), VolumeController.binder(controller));
        }

        public IBinder asBinder() {
            return VolumeController.binder(this.mController);
        }

        private static IBinder binder(IVolumeController controller) {
            return controller == null ? null : controller.asBinder();
        }

        public String toString() {
            return "VolumeController(" + this.asBinder() + ",mVisible=" + this.mVisible + ")";
        }

        public void postDisplaySafeVolumeWarning(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.displaySafeVolumeWarning(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling displaySafeVolumeWarning", e);
            }
        }

        public void postVolumeChanged(int streamType, int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.volumeChanged(streamType, flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling volumeChanged", e);
            }
        }

        public void postMasterMuteChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterMuteChanged(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling masterMuteChanged", e);
            }
        }

        public void setLayoutDirection(int layoutDirection) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setLayoutDirection(layoutDirection);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling setLayoutDirection", e);
            }
        }

        public void postDismiss() {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.dismiss();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling dismiss", e);
            }
        }

        public void setA11yMode(int a11yMode) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setA11yMode(a11yMode);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling setA11Mode", e);
            }
        }
    }

    private class MyDisplayStatusCallback
    implements HdmiPlaybackClient.DisplayStatusCallback {
        private MyDisplayStatusCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(int status) {
            Object object = AudioService.this.mHdmiClientLock;
            synchronized (object) {
                if (AudioService.this.mHdmiManager != null) {
                    AudioService.this.mHdmiCecSink = status != -1;
                    AudioService.this.mFullVolumeDevices = AudioService.this.mHdmiCecSink ? (AudioService.this.mFullVolumeDevices |= 0x400) : (AudioService.this.mFullVolumeDevices &= 0xFFFFFBFF);
                    AudioService.this.checkAddAllFixedVolumeDevices(1024, "HdmiPlaybackClient.DisplayStatusCallback");
                }
            }
        }
    }

    private class AudioServiceUserRestrictionsListener
    implements UserManagerInternal.UserRestrictionsListener {
        private AudioServiceUserRestrictionsListener() {
        }

        @Override
        public void onUserRestrictionsChanged(int userId, Bundle newRestrictions, Bundle prevRestrictions) {
            boolean isRestricted;
            boolean wasRestricted = prevRestrictions.getBoolean("no_unmute_microphone");
            if (wasRestricted != (isRestricted = newRestrictions.getBoolean("no_unmute_microphone"))) {
                AudioService.this.setMicrophoneMuteNoCallerCheck(isRestricted, userId);
            }
            wasRestricted = prevRestrictions.getBoolean("no_adjust_volume") || prevRestrictions.getBoolean("disallow_unmute_device");
            boolean bl = isRestricted = newRestrictions.getBoolean("no_adjust_volume") || newRestrictions.getBoolean("disallow_unmute_device");
            if (wasRestricted != isRestricted) {
                AudioService.this.setMasterMuteInternalNoCallerCheck(isRestricted, 0, userId);
            }
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                if (dockState != 3 && (dockState != 0 || AudioService.this.mDockState != 3)) {
                    AudioService.this.mDeviceBroker.setForceUse_Async(3, config, "ACTION_DOCK_EVENT intent");
                }
                AudioService.this.mDockState = dockState;
            } else if (action.equals("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED") || action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                AudioService.this.mDeviceBroker.receiveBtEvent(intent);
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                if (AudioService.this.mMonitorRotation) {
                    RotationHelper.enable();
                }
                AudioSystem.setParameters("screen_state=on");
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                if (AudioService.this.mMonitorRotation) {
                    RotationHelper.disable();
                }
                AudioSystem.setParameters("screen_state=off");
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                AudioService.this.handleConfigurationChanged(context);
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                if (AudioService.this.mUserSwitchedReceived) {
                    AudioService.this.mDeviceBroker.postBroadcastBecomingNoisy();
                }
                AudioService.this.mUserSwitchedReceived = true;
                AudioService.this.mMediaFocusControl.discardAudioFocusOwner();
                AudioService.this.readAudioSettings(true);
                AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, AudioService.this.mStreamStates[3], 0);
            } else if (action.equals("android.intent.action.USER_BACKGROUND")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userId >= 0) {
                    UserInfo userInfo = UserManagerService.getInstance().getUserInfo(userId);
                    AudioService.this.killBackgroundUserProcessesWithRecordAudioPermission(userInfo);
                }
                UserManagerService.getInstance().setUserRestriction("no_record_audio", true, userId);
            } else if (action.equals("android.intent.action.USER_FOREGROUND")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                UserManagerService.getInstance().setUserRestriction("no_record_audio", false, userId);
            } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                if (state == 10 || state == 13) {
                    AudioService.this.mDeviceBroker.disconnectAllBluetoothProfiles();
                }
            } else if (action.equals("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION") || action.equals("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION")) {
                AudioService.this.handleAudioEffectBroadcast(context, intent);
            } else if (action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                int[] suspendedUids = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                String[] suspendedPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                if (suspendedPackages == null || suspendedUids == null || suspendedPackages.length != suspendedUids.length) {
                    return;
                }
                for (int i = 0; i < suspendedUids.length; ++i) {
                    if (TextUtils.isEmpty(suspendedPackages[i])) continue;
                    AudioService.this.mMediaFocusControl.noFocusForSuspendedApp(suspendedPackages[i], suspendedUids[i]);
                }
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("zen_mode"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("zen_mode_config_etag"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("master_mono"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("master_balance"), false, this);
            AudioService.this.mEncodedSurroundMode = Settings.Global.getInt(AudioService.this.mContentResolver, "encoded_surround_output", 0);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("encoded_surround_output"), false, this);
            AudioService.this.mEnabledSurroundFormats = Settings.Global.getString(AudioService.this.mContentResolver, "encoded_surround_output_enabled_formats");
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("encoded_surround_output_enabled_formats"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("voice_interaction_service"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("rtt_calling_mode"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerAndZenModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerModeInternal(), false);
                }
                AudioService.this.readDockAudioSettings(AudioService.this.mContentResolver);
                AudioService.this.updateMasterMono(AudioService.this.mContentResolver);
                AudioService.this.updateMasterBalance(AudioService.this.mContentResolver);
                this.updateEncodedSurroundOutput();
                AudioService.this.sendEnabledSurroundFormats(AudioService.this.mContentResolver, AudioService.this.mSurroundModeChanged);
                AudioService.this.updateAssistantUId(false);
                AudioService.this.updateRttEanbled(AudioService.this.mContentResolver);
            }
        }

        private void updateEncodedSurroundOutput() {
            int newSurroundMode = Settings.Global.getInt(AudioService.this.mContentResolver, "encoded_surround_output", 0);
            if (AudioService.this.mEncodedSurroundMode != newSurroundMode) {
                AudioService.this.sendEncodedSurroundMode(newSurroundMode, "SettingsObserver");
                AudioService.this.mDeviceBroker.toggleHdmiIfConnected_Async();
                AudioService.this.mEncodedSurroundMode = newSurroundMode;
                AudioService.this.mSurroundModeChanged = true;
            } else {
                AudioService.this.mSurroundModeChanged = false;
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setAllVolumes(VolumeStreamState streamState) {
            streamState.applyAllVolumes();
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                AudioService.this.mStreamStates[streamType].applyAllVolumes();
            }
        }

        private void persistVolume(VolumeStreamState streamState, int device) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            if (AudioService.this.mIsSingleVolume && streamState.mStreamType != 3) {
                return;
            }
            if (streamState.hasValidSettingsName()) {
                Settings.System.putIntForUser(AudioService.this.mContentResolver, streamState.getSettingNameForDevice(device), (streamState.getIndex(device) + 5) / 10, -2);
            }
        }

        private void persistRingerMode(int ringerMode) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(AudioService.this.mContentResolver, "mode_ringer", ringerMode);
        }

        private String getSoundEffectFilePath(int effectType) {
            String filePath = Environment.getProductDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
            if (!new File(filePath).isFile()) {
                filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
            }
            return filePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onLoadSoundEffects() {
            int status;
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int effect;
                if (!AudioService.this.mSystemReady) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() called before boot complete");
                    return false;
                }
                if (AudioService.this.mSoundPool != null) {
                    return true;
                }
                AudioService.this.loadTouchSoundAssets();
                AudioService.this.mSoundPool = new SoundPool.Builder().setMaxStreams(4).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).build();
                AudioService.this.mSoundPoolCallBack = null;
                AudioService.this.mSoundPoolListenerThread = new SoundPoolListenerThread();
                AudioService.this.mSoundPoolListenerThread.start();
                int attempts = 3;
                while (AudioService.this.mSoundPoolCallBack == null && attempts-- > 0) {
                    try {
                        AudioService.this.mSoundEffectsLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Log.w(AudioService.TAG, "Interrupted while waiting sound pool listener thread.");
                    }
                }
                if (AudioService.this.mSoundPoolCallBack == null) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() SoundPool listener or thread creation error");
                    if (AudioService.this.mSoundPoolLooper != null) {
                        AudioService.this.mSoundPoolLooper.quit();
                        AudioService.this.mSoundPoolLooper = null;
                    }
                    AudioService.this.mSoundPoolListenerThread = null;
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                    return false;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = -1;
                }
                int numSamples = 0;
                for (effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                    if (poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                        String filePath = this.getSoundEffectFilePath(effect);
                        int sampleId = AudioService.this.mSoundPool.load(filePath, 0);
                        if (sampleId <= 0) {
                            Log.w(AudioService.TAG, "Soundpool could not load file: " + filePath);
                            continue;
                        }
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                        poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                        ++numSamples;
                        continue;
                    }
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]];
                }
                if (numSamples > 0) {
                    AudioService.this.mSoundPoolCallBack.setSamples(poolId);
                    attempts = 3;
                    status = 1;
                    while (status == 1 && attempts-- > 0) {
                        try {
                            AudioService.this.mSoundEffectsLock.wait(5000L);
                            status = AudioService.this.mSoundPoolCallBack.status();
                        }
                        catch (InterruptedException e) {
                            Log.w(AudioService.TAG, "Interrupted while waiting sound pool callback.");
                        }
                    }
                } else {
                    status = -1;
                }
                if (AudioService.this.mSoundPoolLooper != null) {
                    AudioService.this.mSoundPoolLooper.quit();
                    AudioService.this.mSoundPoolLooper = null;
                }
                AudioService.this.mSoundPoolListenerThread = null;
                if (status != 0) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects(), Error " + status + " while loading samples");
                    for (effect = 0; effect < 10; ++effect) {
                        if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    }
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                }
            }
            return status == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnloadSoundEffects() {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = 0;
                }
                for (int effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                    AudioService.this.mSoundPool.unload(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1]);
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
                }
                AudioService.this.mSoundPool.release();
                AudioService.this.mSoundPool = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPlaySoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)volume / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        String filePath = this.getSoundEffectFilePath(effectType);
                        mediaPlayer.setDataSource(filePath);
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(volFloat);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            @Override
                            public void onCompletion(MediaPlayer mp) {
                                AudioHandler.this.cleanupPlayer(mp);
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            @Override
                            public boolean onError(MediaPlayer mp, int what, int extra) {
                                AudioHandler.this.cleanupPlayer(mp);
                                return true;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                    }
                    catch (IllegalStateException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                    }
                }
            }
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        private void onPersistSafeVolumeState(int state) {
            Settings.Global.putInt(AudioService.this.mContentResolver, "audio_safe_volume_state", state);
        }

        private void onNotifyVolumeEvent(IAudioPolicyCallback apc, int direction) {
            try {
                apc.notifyVolumeAdjust(direction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AudioService.this.setDeviceVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 3: {
                    this.persistRingerMode(AudioService.this.getRingerModeInternal());
                    break;
                }
                case 4: {
                    AudioService.this.onAudioServerDied();
                    break;
                }
                case 23: {
                    AudioService.this.onDispatchAudioServerStateChange(msg.arg1 == 1);
                    break;
                }
                case 15: {
                    this.onUnloadSoundEffects();
                    break;
                }
                case 7: {
                    LoadSoundEffectReply reply;
                    boolean loaded = this.onLoadSoundEffects();
                    if (msg.obj == null) break;
                    LoadSoundEffectReply loadSoundEffectReply = reply = (LoadSoundEffectReply)msg.obj;
                    synchronized (loadSoundEffectReply) {
                        reply.mStatus = loaded ? 0 : -1;
                        reply.notify();
                        break;
                    }
                }
                case 5: {
                    this.onPlaySoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 8: {
                    String eventSource = (String)msg.obj;
                    int useCase = msg.arg1;
                    int config = msg.arg2;
                    if (useCase == 1) {
                        Log.wtf(AudioService.TAG, "Invalid force use FOR_MEDIA in AudioService from " + eventSource);
                        break;
                    }
                    sForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(useCase, config, eventSource));
                    AudioSystem.setForceUse(useCase, config);
                    break;
                }
                case 100: {
                    AudioService.this.mPlaybackMonitor.disableAudioForUid(msg.arg1 == 1, msg.arg2);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 11: {
                    AudioService.this.onCheckMusicActive((String)msg.obj);
                    break;
                }
                case 12: 
                case 13: {
                    AudioService.this.onConfigureSafeVolume(msg.what == 13, (String)msg.obj);
                    break;
                }
                case 14: {
                    this.onPersistSafeVolumeState(msg.arg1);
                    break;
                }
                case 16: {
                    AudioService.this.onSystemReady();
                    break;
                }
                case 20: {
                    AudioService.this.onIndicateSystemReady();
                    break;
                }
                case 21: {
                    AudioService.this.onAccessoryPlugMediaUnmute(msg.arg1);
                    break;
                }
                case 17: {
                    int musicActiveMs = msg.arg1;
                    Settings.Secure.putIntForUser(AudioService.this.mContentResolver, "unsafe_volume_music_active_ms", musicActiveMs, -2);
                    break;
                }
                case 18: {
                    AudioService.this.onUnmuteStream(msg.arg1, msg.arg2);
                    break;
                }
                case 19: {
                    AudioService.this.onDynPolicyMixStateUpdate((String)msg.obj, msg.arg1);
                    break;
                }
                case 22: {
                    this.onNotifyVolumeEvent((IAudioPolicyCallback)msg.obj, msg.arg1);
                    break;
                }
                case 24: {
                    AudioService.this.onEnableSurroundFormats((ArrayList)msg.obj);
                    break;
                }
                case 25: {
                    AudioService.this.onUpdateRingerModeServiceInt();
                    break;
                }
                case 26: {
                    AudioService.this.onSetVolumeIndexOnDevice((DeviceVolumeUpdate)msg.obj);
                    break;
                }
                case 27: {
                    AudioService.this.onObserveDevicesForAllStreams();
                    break;
                }
                case 28: {
                    AudioService.this.onCheckVolumeCecOnHdmiConnection(msg.arg1, (String)msg.obj);
                    break;
                }
                case 29: {
                    AudioService.this.onPlaybackConfigChange((List)msg.obj);
                }
            }
        }
    }

    private static final class DeviceVolumeUpdate {
        final int mStreamType;
        final int mDevice;
        final String mCaller;
        private static final int NO_NEW_INDEX = -2049;
        private final int mVssVolIndex;

        DeviceVolumeUpdate(int streamType, int vssVolIndex, int device, String caller) {
            this.mStreamType = streamType;
            this.mVssVolIndex = vssVolIndex;
            this.mDevice = device;
            this.mCaller = caller;
        }

        DeviceVolumeUpdate(int streamType, int device, String caller) {
            this.mStreamType = streamType;
            this.mVssVolIndex = -2049;
            this.mDevice = device;
            this.mCaller = caller;
        }

        boolean hasVolumeIndex() {
            return this.mVssVolIndex != -2049;
        }

        int getVolumeIndex() throws IllegalStateException {
            Preconditions.checkState(this.mVssVolIndex != -2049);
            return this.mVssVolIndex;
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super("AudioService");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    private class VolumeStreamState {
        private final int mStreamType;
        private int mIndexMin;
        private int mIndexMax;
        private boolean mIsMuted;
        private String mVolumeIndexSettingName;
        private int mObservedDevices;
        private final SparseIntArray mIndexMap = new SparseIntArray(8);
        private final Intent mVolumeChanged;
        private final Intent mStreamDevicesChanged;

        private VolumeStreamState(String settingName, int streamType) {
            this.mVolumeIndexSettingName = settingName;
            this.mStreamType = streamType;
            this.mIndexMin = MIN_STREAM_VOLUME[streamType] * 10;
            this.mIndexMax = MAX_STREAM_VOLUME[streamType] * 10;
            AudioSystem.initStreamVolume(streamType, this.mIndexMin / 10, this.mIndexMax / 10);
            this.readSettings();
            this.mVolumeChanged = new Intent("android.media.VOLUME_CHANGED_ACTION");
            this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
            this.mStreamDevicesChanged = new Intent("android.media.STREAM_DEVICES_CHANGED_ACTION");
            this.mStreamDevicesChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
        }

        public int observeDevicesForStream_syncVSS(boolean checkOthers) {
            int devices = AudioSystem.getDevicesForStream(this.mStreamType);
            if (devices == this.mObservedDevices) {
                return devices;
            }
            int prevDevices = this.mObservedDevices;
            this.mObservedDevices = devices;
            if (checkOthers) {
                AudioService.this.observeDevicesForStreams(this.mStreamType);
            }
            if (mStreamVolumeAlias[this.mStreamType] == this.mStreamType) {
                EventLogTags.writeStreamDevicesChanged(this.mStreamType, prevDevices, devices);
            }
            AudioService.this.sendBroadcastToAll(this.mStreamDevicesChanged.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_DEVICES", prevDevices).putExtra("android.media.EXTRA_VOLUME_STREAM_DEVICES", devices));
            return devices;
        }

        public String getSettingNameForDevice(int device) {
            if (!this.hasValidSettingsName()) {
                return null;
            }
            String suffix = AudioSystem.getOutputDeviceName(device);
            if (suffix.isEmpty()) {
                return this.mVolumeIndexSettingName;
            }
            return this.mVolumeIndexSettingName + "_" + suffix;
        }

        private boolean hasValidSettingsName() {
            return this.mVolumeIndexSettingName != null && !this.mVolumeIndexSettingName.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void readSettings() {
            Class<VolumeStreamState> clazz = AudioService.this.mSettingsLock;
            // MONITORENTER : clazz
            Class<VolumeStreamState> clazz2 = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            if (AudioService.this.mUseFixedVolume) {
                this.mIndexMap.put(0x40000000, this.mIndexMax);
                // MONITOREXIT : clazz2
                // MONITOREXIT : clazz
                return;
            }
            if (this.mStreamType == 1 || this.mStreamType == 7) {
                int index = 10 * AudioSystem.DEFAULT_STREAM_VOLUME[this.mStreamType];
                if (AudioService.this.mCameraSoundForced) {
                    index = this.mIndexMax;
                }
                this.mIndexMap.put(0x40000000, index);
                // MONITOREXIT : clazz2
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz2
            // MONITOREXIT : clazz
            clazz = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            int remainingDevices = 0x4FFFFFFF;
            int i = 0;
            while (true) {
                if (remainingDevices == 0) {
                    // MONITOREXIT : clazz
                    return;
                }
                int device = 1 << i;
                if ((device & remainingDevices) != 0) {
                    int index;
                    int defaultIndex;
                    remainingDevices &= ~device;
                    int n = defaultIndex = device == 0x40000000 ? AudioSystem.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                    if (!this.hasValidSettingsName()) {
                        index = defaultIndex;
                    } else {
                        String name = this.getSettingNameForDevice(device);
                        index = Settings.System.getIntForUser(AudioService.this.mContentResolver, name, defaultIndex, -2);
                    }
                    if (index != -1) {
                        this.mIndexMap.put(device, this.getValidIndex(10 * index));
                    }
                }
                ++i;
            }
        }

        private int getAbsoluteVolumeIndex(int index) {
            index = index == 0 ? 0 : (index > 0 && index <= 3 ? (int)((float)this.mIndexMax * AudioService.this.mPrescaleAbsoluteVolume[index - 1]) / 10 : (this.mIndexMax + 5) / 10);
            return index;
        }

        private void setStreamVolumeIndex(int index, int device) {
            if (this.mStreamType == 6 && index == 0 && !this.mIsMuted) {
                index = 1;
            }
            AudioSystem.setStreamVolumeIndexAS(this.mStreamType, index, device);
        }

        void applyDeviceVolume_syncVSS(int device, boolean isAvrcpAbsVolSupported) {
            int index = this.mIsMuted ? 0 : ((device & 0x380) != 0 && isAvrcpAbsVolSupported ? this.getAbsoluteVolumeIndex((this.getIndex(device) + 5) / 10) : ((device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : ((device & 0x8000000) != 0 ? (this.mIndexMax + 5) / 10 : (this.getIndex(device) + 5) / 10)));
            this.setStreamVolumeIndex(index, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyAllVolumes() {
            boolean isAvrcpAbsVolSupported = AudioService.this.mDeviceBroker.isAvrcpAbsoluteVolumeSupported();
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index;
                for (int i = 0; i < this.mIndexMap.size(); ++i) {
                    int device = this.mIndexMap.keyAt(i);
                    if (device == 0x40000000) continue;
                    index = this.mIsMuted ? 0 : ((device & 0x380) != 0 && isAvrcpAbsVolSupported ? this.getAbsoluteVolumeIndex((this.getIndex(device) + 5) / 10) : ((device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : ((device & 0x8000000) != 0 ? (this.mIndexMax + 5) / 10 : (this.mIndexMap.valueAt(i) + 5) / 10)));
                    this.setStreamVolumeIndex(index, device);
                }
                index = this.mIsMuted ? 0 : (this.getIndex(0x40000000) + 5) / 10;
                this.setStreamVolumeIndex(index, 0x40000000);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public boolean adjustIndex(int deltaIndex, int device, String caller) {
            return this.setIndex(this.getIndex(device) + deltaIndex, device, caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setIndex(int index, int device, String caller) {
            boolean changed;
            int oldIndex;
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                Class<VolumeStreamState> clazz = VolumeStreamState.class;
                synchronized (VolumeStreamState.class) {
                    oldIndex = this.getIndex(device);
                    index = this.getValidIndex(index);
                    if (this.mStreamType == 7 && AudioService.this.mCameraSoundForced) {
                        index = this.mIndexMax;
                    }
                    this.mIndexMap.put(device, index);
                    changed = oldIndex != index;
                    boolean isCurrentDevice = device == AudioService.this.getDeviceForStream(this.mStreamType);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState aliasStreamState = AudioService.this.mStreamStates[streamType];
                        if (streamType == this.mStreamType || mStreamVolumeAlias[streamType] != this.mStreamType || !changed && aliasStreamState.hasIndexForDevice(device)) continue;
                        int scaledIndex = AudioService.this.rescaleIndex(index, this.mStreamType, streamType);
                        aliasStreamState.setIndex(scaledIndex, device, caller);
                        if (!isCurrentDevice) continue;
                        aliasStreamState.setIndex(scaledIndex, AudioService.this.getDeviceForStream(streamType), caller);
                    }
                    if (changed && this.mStreamType == 2 && device == 2) {
                        for (int i = 0; i < this.mIndexMap.size(); ++i) {
                            int otherDevice = this.mIndexMap.keyAt(i);
                            if ((otherDevice & 0x70) == 0) continue;
                            this.mIndexMap.put(otherDevice, index);
                        }
                    }
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                }
            }
            {
                if (changed) {
                    oldIndex = (oldIndex + 5) / 10;
                    index = (index + 5) / 10;
                    if (mStreamVolumeAlias[this.mStreamType] == this.mStreamType) {
                        if (caller == null) {
                            Log.w(AudioService.TAG, "No caller for volume_changed event", new Throwable());
                        }
                        EventLogTags.writeVolumeChanged(this.mStreamType, oldIndex, index, this.mIndexMax / 10, caller);
                    }
                    this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
                    this.mVolumeChanged.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
                    this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE_ALIAS", mStreamVolumeAlias[this.mStreamType]);
                    AudioService.this.sendBroadcastToAll(this.mVolumeChanged);
                }
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndex(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index = this.mIndexMap.get(device, -1);
                if (index == -1) {
                    index = this.mIndexMap.get(0x40000000);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasIndexForDevice(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mIndexMap.get(device, -1) != -1;
            }
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public int getMinIndex() {
            return this.mIndexMin;
        }

        @GuardedBy(value={"VolumeStreamState.class"})
        public void setAllIndexes(VolumeStreamState srcStream, String caller) {
            if (this.mStreamType == srcStream.mStreamType) {
                return;
            }
            int srcStreamType = srcStream.getStreamType();
            int index = srcStream.getIndex(0x40000000);
            index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                this.mIndexMap.put(this.mIndexMap.keyAt(i), index);
            }
            SparseIntArray srcMap = srcStream.mIndexMap;
            for (int i = 0; i < srcMap.size(); ++i) {
                int device = srcMap.keyAt(i);
                index = srcMap.valueAt(i);
                index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
                this.setIndex(index, device, caller);
            }
        }

        @GuardedBy(value={"VolumeStreamState.class"})
        public void setAllIndexesToMax() {
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                this.mIndexMap.put(this.mIndexMap.keyAt(i), this.mIndexMax);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mute(boolean state) {
            boolean changed = false;
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (state != this.mIsMuted) {
                    changed = true;
                    this.mIsMuted = state;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, this, 0);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (changed) {
                    Intent intent = new Intent("android.media.STREAM_MUTE_CHANGED_ACTION");
                    intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
                    intent.putExtra("android.media.EXTRA_STREAM_VOLUME_MUTED", state);
                    AudioService.this.sendBroadcastToAll(intent);
                }
                return;
            }
        }

        public int getStreamType() {
            return this.mStreamType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkFixedVolumeDevices() {
            boolean isAvrcpAbsVolSupported = AudioService.this.mDeviceBroker.isAvrcpAbsoluteVolumeSupported();
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (mStreamVolumeAlias[this.mStreamType] == 3) {
                    for (int i = 0; i < this.mIndexMap.size(); ++i) {
                        int device = this.mIndexMap.keyAt(i);
                        int index = this.mIndexMap.valueAt(i);
                        if ((device & AudioService.this.mFullVolumeDevices) != 0 || (device & AudioService.this.mFixedVolumeDevices) != 0 && index != 0) {
                            this.mIndexMap.put(device, this.mIndexMax);
                        }
                        this.applyDeviceVolume_syncVSS(device, isAvrcpAbsVolSupported);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private int getValidIndex(int index) {
            if (index < this.mIndexMin) {
                return this.mIndexMin;
            }
            if (AudioService.this.mUseFixedVolume || index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private void dump(PrintWriter pw) {
            int device;
            pw.print("   Muted: ");
            pw.println(this.mIsMuted);
            pw.print("   Min: ");
            pw.println((this.mIndexMin + 5) / 10);
            pw.print("   Max: ");
            pw.println((this.mIndexMax + 5) / 10);
            pw.print("   streamVolume:");
            pw.println(AudioService.this.getStreamVolume(this.mStreamType));
            pw.print("   Current: ");
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                String deviceName;
                if (i > 0) {
                    pw.print(", ");
                }
                device = this.mIndexMap.keyAt(i);
                pw.print(Integer.toHexString(device));
                String string2 = deviceName = device == 0x40000000 ? "default" : AudioSystem.getOutputDeviceName(device);
                if (!deviceName.isEmpty()) {
                    pw.print(" (");
                    pw.print(deviceName);
                    pw.print(")");
                }
                pw.print(": ");
                int index = (this.mIndexMap.valueAt(i) + 5) / 10;
                pw.print(index);
            }
            pw.println();
            pw.print("   Devices: ");
            int devices = AudioService.this.getDevicesForStream(this.mStreamType);
            int i = 0;
            int n = 0;
            while ((device = 1 << i) != 0x40000000) {
                if ((devices & device) != 0) {
                    if (n++ > 0) {
                        pw.print(", ");
                    }
                    pw.print(AudioSystem.getOutputDeviceName(device));
                }
                ++i;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BtProfileConnectionState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }

    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        int mStatus = 1;
        List<Integer> mSamples = new ArrayList<Integer>();

        private SoundPoolCallback() {
        }

        public int status() {
            return this.mStatus;
        }

        public void setSamples(int[] samples) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                this.mSamples.add(samples[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int i = this.mSamples.indexOf(sampleId);
                if (i >= 0) {
                    this.mSamples.remove(i);
                }
                if (status != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = status;
                    AudioService.this.mSoundEffectsLock.notify();
                }
            }
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService.this.mSoundPoolLooper = Looper.myLooper();
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.this.mSoundPoolCallBack = new SoundPoolCallback();
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    class LoadSoundEffectReply {
        public int mStatus = 1;

        LoadSoundEffectReply() {
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mPid;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb, int pid) {
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            int oldModeOwnerPid = 0;
            int newModeOwnerPid = 0;
            Object object = ((AudioService)AudioService.this).mDeviceBroker.mSetModeLock;
            synchronized (object) {
                int index;
                Log.w(AudioService.TAG, "setMode() client died");
                if (!AudioService.this.mSetModeDeathHandlers.isEmpty()) {
                    oldModeOwnerPid = AudioService.this.mSetModeDeathHandlers.get(0).getPid();
                }
                if ((index = AudioService.this.mSetModeDeathHandlers.indexOf(this)) < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = AudioService.this.setModeInt(0, this.mCb, this.mPid, AudioService.TAG);
                }
            }
            if (newModeOwnerPid != oldModeOwnerPid && newModeOwnerPid != 0) {
                AudioService.this.mDeviceBroker.postDisconnectBluetoothSco(newModeOwnerPid);
            }
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class RmtSbmxFullVolDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mICallback;

        RmtSbmxFullVolDeathHandler(IBinder cb) {
            this.mICallback = cb;
            try {
                cb.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.e(AudioService.TAG, "can't link to death", e);
            }
        }

        boolean isHandlerFor(IBinder cb) {
            return this.mICallback.equals(cb);
        }

        void forget() {
            try {
                this.mICallback.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(AudioService.TAG, "error unlinking to death", e);
            }
        }

        @Override
        public void binderDied() {
            Log.w(AudioService.TAG, "Recorder with remote submix at full volume died " + this.mICallback);
            AudioService.this.forceRemoteSubmixFullVolume(false, this.mICallback);
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        ForceControlStreamClient(IBinder cb) {
            if (cb != null) {
                try {
                    cb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w(AudioService.TAG, "ForceControlStreamClient() could not link to " + cb + " binder death");
                    cb = null;
                }
            }
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mForceControlStreamLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mForceControlStreamClient != this) {
                    Log.w(AudioService.TAG, "unregistered control stream client died");
                } else {
                    AudioService.this.mForceControlStreamClient = null;
                    AudioService.this.mVolumeControlStream = -1;
                    AudioService.this.mUserSelectedVolumeControlStream = false;
                }
            }
        }

        public void release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    class StreamVolumeCommand {
        public final int mStreamType;
        public final int mIndex;
        public final int mFlags;
        public final int mDevice;

        StreamVolumeCommand(int streamType, int index, int flags, int device) {
            this.mStreamType = streamType;
            this.mIndex = index;
            this.mFlags = flags;
            this.mDevice = device;
        }

        public String toString() {
            return "{streamType=" + this.mStreamType + ",index=" + this.mIndex + ",flags=" + this.mFlags + ",device=" + this.mDevice + '}';
        }
    }

    class RoleObserver
    implements OnRoleHoldersChangedListener {
        private RoleManager mRm;
        private final Executor mExecutor;

        RoleObserver() {
            this.mExecutor = AudioService.this.mContext.getMainExecutor();
        }

        public void register() {
            this.mRm = (RoleManager)AudioService.this.mContext.getSystemService("role");
            if (this.mRm != null) {
                this.mRm.addOnRoleHoldersChangedListenerAsUser(this.mExecutor, this, UserHandle.ALL);
                AudioService.this.updateAssistantUId(true);
            }
        }

        @Override
        public void onRoleHoldersChanged(String roleName, UserHandle user) {
            if ("android.app.role.ASSISTANT".equals(roleName)) {
                AudioService.this.updateAssistantUId(false);
            }
        }

        public String getAssistantRoleHolder() {
            String assitantPackage = "";
            if (this.mRm != null) {
                List<String> assistants = this.mRm.getRoleHolders("android.app.role.ASSISTANT");
                assitantPackage = assistants.size() == 0 ? "" : assistants.get(0);
            }
            return assitantPackage;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private AudioService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new AudioService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("audio", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemReady();
            }
        }
    }
}

