/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothCodecStatus;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothProfile;
import android.content.Intent;
import android.media.AudioSystem;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.audio.AudioDeviceBroker;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.AudioService;
import com.android.server.audio.AudioServiceEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BtHelper {
    private static final String TAG = "AS.BtHelper";
    private final AudioDeviceBroker mDeviceBroker;
    private final ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private BluetoothHearingAid mHearingAid;
    private BluetoothA2dp mA2dp;
    private boolean mAvrcpAbsVolSupported = false;
    private int mScoConnectionState;
    private int mScoAudioState;
    private int mScoAudioMode;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_REQ = 4;
    private static final int SCO_STATE_DEACTIVATING = 5;
    static final int SCO_MODE_UNDEFINED = -1;
    static final int SCO_MODE_VIRTUAL_CALL = 0;
    private static final int SCO_MODE_RAW = 1;
    private static final int SCO_MODE_VR = 2;
    private static final int SCO_MODE_MAX = 2;
    private static final int BT_HEARING_AID_GAIN_MIN = -128;
    static final int EVENT_DEVICE_CONFIG_CHANGE = 0;
    static final int EVENT_ACTIVE_DEVICE_CHANGE = 1;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            switch (profile) {
                case 2: {
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("BT profile service: connecting A2DP profile"));
                    BtHelper.this.mDeviceBroker.postBtA2dpProfileConnected((BluetoothA2dp)proxy);
                    break;
                }
                case 11: {
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("BT profile service: connecting A2DP_SINK profile"));
                    BtHelper.this.mDeviceBroker.postBtA2dpSinkProfileConnected(proxy);
                    break;
                }
                case 1: {
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("BT profile service: connecting HEADSET profile"));
                    BtHelper.this.mDeviceBroker.postBtHeasetProfileConnected((BluetoothHeadset)proxy);
                    break;
                }
                case 21: {
                    AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent("BT profile service: connecting HEARING_AID profile"));
                    BtHelper.this.mDeviceBroker.postBtHearingAidProfileConnected((BluetoothHearingAid)proxy);
                    break;
                }
            }
        }

        @Override
        public void onServiceDisconnected(int profile) {
            switch (profile) {
                case 2: {
                    BtHelper.this.mDeviceBroker.postDisconnectA2dp();
                    break;
                }
                case 11: {
                    BtHelper.this.mDeviceBroker.postDisconnectA2dpSink();
                    break;
                }
                case 1: {
                    BtHelper.this.mDeviceBroker.postDisconnectHeadset();
                    break;
                }
                case 21: {
                    BtHelper.this.mDeviceBroker.postDisconnectHearingAid();
                    break;
                }
            }
        }
    };

    BtHelper(AudioDeviceBroker broker) {
        this.mDeviceBroker = broker;
    }

    static String a2dpDeviceEventToString(int event) {
        switch (event) {
            case 0: {
                return "DEVICE_CONFIG_CHANGE";
            }
            case 1: {
                return "ACTIVE_DEVICE_CHANGE";
            }
        }
        return new String("invalid event:" + event);
    }

    static String getName(BluetoothDevice device) {
        String deviceName = device.getName();
        if (deviceName == null) {
            return "";
        }
        return deviceName;
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void onSystemReady() {
        this.mScoConnectionState = -1;
        this.resetBluetoothSco();
        this.getBluetoothHeadset();
        Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
        this.sendStickyBroadcastToAll(newIntent);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mDeviceBroker.getContext(), this.mBluetoothProfileServiceListener, 2);
            adapter.getProfileProxy(this.mDeviceBroker.getContext(), this.mBluetoothProfileServiceListener, 21);
        }
    }

    synchronized void onAudioServerDiedRestoreA2dp() {
        int forMed = this.mDeviceBroker.getBluetoothA2dpEnabled() ? 0 : 10;
        this.mDeviceBroker.setForceUse_Async(1, forMed, "onAudioServerDied()");
    }

    synchronized boolean isAvrcpAbsoluteVolumeSupported() {
        return this.mA2dp != null && this.mAvrcpAbsVolSupported;
    }

    synchronized void setAvrcpAbsoluteVolumeSupported(boolean supported) {
        this.mAvrcpAbsVolSupported = supported;
        Log.i(TAG, "setAvrcpAbsoluteVolumeSupported supported=" + supported);
    }

    synchronized void setAvrcpAbsoluteVolumeIndex(int index) {
        if (this.mA2dp == null) {
            // empty if block
        }
        if (!this.mAvrcpAbsVolSupported) {
            AudioService.sVolumeLogger.log(new AudioEventLogger.StringEvent("setAvrcpAbsoluteVolumeIndex: abs vol not supported ").printLog(TAG));
            return;
        }
        AudioService.sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(4, index));
        this.mA2dp.setAvrcpAbsoluteVolume(index);
    }

    synchronized int getA2dpCodec(BluetoothDevice device) {
        if (this.mA2dp == null) {
            return 0;
        }
        BluetoothCodecStatus btCodecStatus = this.mA2dp.getCodecStatus(device);
        if (btCodecStatus == null) {
            return 0;
        }
        BluetoothCodecConfig btCodecConfig = btCodecStatus.getCodecConfig();
        if (btCodecConfig == null) {
            return 0;
        }
        return this.mapBluetoothCodecToAudioFormat(btCodecConfig.getCodecType());
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void receiveBtEvent(Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED")) {
            BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            this.setBtScoActiveDevice(btDevice);
        } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
            boolean broadcast = false;
            int scoAudioState = -1;
            int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
            if (!(this.mScoClients.isEmpty() || this.mScoAudioState != 3 && this.mScoAudioState != 1 && this.mScoAudioState != 4 && this.mScoAudioState != 5)) {
                broadcast = true;
            }
            switch (btState) {
                case 12: {
                    scoAudioState = 1;
                    if (this.mScoAudioState != 3 && this.mScoAudioState != 4) {
                        this.mScoAudioState = 2;
                    }
                    this.mDeviceBroker.setBluetoothScoOn(true, "BtHelper.receiveBtEvent");
                    break;
                }
                case 10: {
                    this.mDeviceBroker.setBluetoothScoOn(false, "BtHelper.receiveBtEvent");
                    scoAudioState = 0;
                    if (this.mScoAudioState == 1 && this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && BtHelper.connectBluetoothScoAudioHelper(this.mBluetoothHeadset, this.mBluetoothHeadsetDevice, this.mScoAudioMode)) {
                        this.mScoAudioState = 3;
                        broadcast = false;
                        break;
                    }
                    this.clearAllScoClients(0, this.mScoAudioState == 3);
                    this.mScoAudioState = 0;
                    break;
                }
                case 11: {
                    if (this.mScoAudioState == 3 || this.mScoAudioState == 4) break;
                    this.mScoAudioState = 2;
                    break;
                }
                default: {
                    broadcast = false;
                }
            }
            if (broadcast) {
                this.broadcastScoConnectionState(scoAudioState);
                Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", scoAudioState);
                this.sendStickyBroadcastToAll(newIntent);
            }
        }
    }

    synchronized boolean isBluetoothScoOn() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 12) {
            Log.w(TAG, "isBluetoothScoOn(true) returning false because " + this.mBluetoothHeadsetDevice + " is not in audio connected mode");
            return false;
        }
        return true;
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void disconnectBluetoothSco(int exceptPid) {
        this.checkScoAudioState();
        if (this.mScoAudioState == 2) {
            return;
        }
        this.clearAllScoClients(exceptPid, true);
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void startBluetoothScoForClient(IBinder cb, int scoAudioMode, String eventSource) {
        ScoClient client = this.getScoClient(cb, true);
        long ident = Binder.clearCallingIdentity();
        try {
            eventSource = eventSource + " client count before=" + client.getCount();
            AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent(eventSource));
            client.incCount(scoAudioMode);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Null ScoClient", e);
        }
        Binder.restoreCallingIdentity(ident);
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void stopBluetoothScoForClient(IBinder cb, String eventSource) {
        ScoClient client = this.getScoClient(cb, false);
        long ident = Binder.clearCallingIdentity();
        if (client != null) {
            eventSource = eventSource + " client count before=" + client.getCount();
            AudioService.sDeviceLogger.log(new AudioEventLogger.StringEvent(eventSource));
            client.decCount();
        }
        Binder.restoreCallingIdentity(ident);
    }

    synchronized void setHearingAidVolume(int index, int streamType) {
        if (this.mHearingAid == null) {
            return;
        }
        int gainDB = (int)AudioSystem.getStreamVolumeDB(streamType, index / 10, 0x8000000);
        if (gainDB < -128) {
            gainDB = -128;
        }
        AudioService.sVolumeLogger.log(new AudioServiceEvents.VolumeEvent(3, index, gainDB));
        this.mHearingAid.setVolume(gainDB);
    }

    synchronized void onBroadcastScoConnectionState(int state) {
        if (state == this.mScoConnectionState) {
            return;
        }
        Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
        newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
        this.sendStickyBroadcastToAll(newIntent);
        this.mScoConnectionState = state;
    }

    synchronized void disconnectAllBluetoothProfiles() {
        this.mDeviceBroker.postDisconnectA2dp();
        this.mDeviceBroker.postDisconnectA2dpSink();
        this.mDeviceBroker.postDisconnectHeadset();
        this.mDeviceBroker.postDisconnectHearingAid();
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void resetBluetoothSco() {
        this.clearAllScoClients(0, false);
        this.mScoAudioState = 0;
        this.broadcastScoConnectionState(0);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mDeviceBroker.setBluetoothScoOn(false, "resetBluetoothSco");
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void disconnectHeadset() {
        this.setBtScoActiveDevice(null);
        this.mBluetoothHeadset = null;
    }

    synchronized void onA2dpProfileConnected(BluetoothA2dp a2dp) {
        this.mA2dp = a2dp;
        List<BluetoothDevice> deviceList = this.mA2dp.getConnectedDevices();
        if (deviceList.isEmpty()) {
            return;
        }
        BluetoothDevice btDevice = deviceList.get(0);
        int state = this.mA2dp.getConnectionState(btDevice);
        this.mDeviceBroker.handleSetA2dpSinkConnectionState(state, new BluetoothA2dpDeviceInfo(btDevice));
    }

    synchronized void onA2dpSinkProfileConnected(BluetoothProfile profile) {
        List<BluetoothDevice> deviceList = profile.getConnectedDevices();
        if (deviceList.isEmpty()) {
            return;
        }
        BluetoothDevice btDevice = deviceList.get(0);
        int state = profile.getConnectionState(btDevice);
        this.mDeviceBroker.postSetA2dpSourceConnectionState(state, new BluetoothA2dpDeviceInfo(btDevice));
    }

    synchronized void onHearingAidProfileConnected(BluetoothHearingAid hearingAid) {
        this.mHearingAid = hearingAid;
        List<BluetoothDevice> deviceList = this.mHearingAid.getConnectedDevices();
        if (deviceList.isEmpty()) {
            return;
        }
        BluetoothDevice btDevice = deviceList.get(0);
        int state = this.mHearingAid.getConnectionState(btDevice);
        this.mDeviceBroker.postBluetoothHearingAidDeviceConnectionState(btDevice, state, false, 0, "mBluetoothProfileServiceListener");
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void onHeadsetProfileConnected(BluetoothHeadset headset) {
        this.mDeviceBroker.handleCancelFailureToConnectToBtHeadsetService();
        this.mBluetoothHeadset = headset;
        this.setBtScoActiveDevice(this.mBluetoothHeadset.getActiveDevice());
        this.checkScoAudioState();
        if (this.mScoAudioState != 1 && this.mScoAudioState != 4) {
            return;
        }
        boolean status = false;
        if (this.mBluetoothHeadsetDevice != null) {
            switch (this.mScoAudioState) {
                case 1: {
                    status = BtHelper.connectBluetoothScoAudioHelper(this.mBluetoothHeadset, this.mBluetoothHeadsetDevice, this.mScoAudioMode);
                    if (!status) break;
                    this.mScoAudioState = 3;
                    break;
                }
                case 4: {
                    status = BtHelper.disconnectBluetoothScoAudioHelper(this.mBluetoothHeadset, this.mBluetoothHeadsetDevice, this.mScoAudioMode);
                    if (!status) break;
                    this.mScoAudioState = 5;
                }
            }
        }
        if (!status) {
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
    }

    private void broadcastScoConnectionState(int state) {
        this.mDeviceBroker.postBroadcastScoConnectionState(state);
    }

    private boolean handleBtScoActiveDeviceChange(BluetoothDevice btDevice, boolean isActive) {
        if (btDevice == null) {
            return true;
        }
        String address = btDevice.getAddress();
        BluetoothClass btClass = btDevice.getBluetoothClass();
        int inDevice = -2147483640;
        int[] outDeviceTypes = new int[]{16, 32, 64};
        if (btClass != null) {
            switch (btClass.getDeviceClass()) {
                case 1028: 
                case 1032: {
                    outDeviceTypes = new int[]{32};
                    break;
                }
                case 1056: {
                    outDeviceTypes = new int[]{64};
                }
            }
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        String btDeviceName = BtHelper.getName(btDevice);
        boolean result = false;
        if (isActive) {
            result |= this.mDeviceBroker.handleDeviceConnection(isActive, outDeviceTypes[0], address, btDeviceName);
        } else {
            for (int outDeviceType : outDeviceTypes) {
                result |= this.mDeviceBroker.handleDeviceConnection(isActive, outDeviceType, address, btDeviceName);
            }
        }
        result = this.mDeviceBroker.handleDeviceConnection(isActive, inDevice, address, btDeviceName) && result;
        return result;
    }

    @GuardedBy(value={"BtHelper.this"})
    private void setBtScoActiveDevice(BluetoothDevice btDevice) {
        Log.i(TAG, "setBtScoActiveDevice: " + this.mBluetoothHeadsetDevice + " -> " + btDevice);
        BluetoothDevice previousActiveDevice = this.mBluetoothHeadsetDevice;
        if (Objects.equals(btDevice, previousActiveDevice)) {
            return;
        }
        if (!this.handleBtScoActiveDeviceChange(previousActiveDevice, false)) {
            Log.w(TAG, "setBtScoActiveDevice() failed to remove previous device " + previousActiveDevice);
        }
        if (!this.handleBtScoActiveDeviceChange(btDevice, true)) {
            Log.e(TAG, "setBtScoActiveDevice() failed to add new device " + btDevice);
            btDevice = null;
        }
        this.mBluetoothHeadsetDevice = btDevice;
        if (this.mBluetoothHeadsetDevice == null) {
            this.resetBluetoothSco();
        }
    }

    @GuardedBy(value={"AudioDeviceBroker.mDeviceStateLock"})
    synchronized void scoClientDied(Object obj) {
        ScoClient client = (ScoClient)obj;
        Log.w(TAG, "SCO client died");
        int index = this.mScoClients.indexOf(client);
        if (index < 0) {
            Log.w(TAG, "unregistered SCO client died");
        } else {
            client.clearCount(true);
            this.mScoClients.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcastToAll(Intent intent) {
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mDeviceBroker.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static boolean disconnectBluetoothScoAudioHelper(BluetoothHeadset bluetoothHeadset, BluetoothDevice device, int scoAudioMode) {
        switch (scoAudioMode) {
            case 1: {
                return bluetoothHeadset.disconnectAudio();
            }
            case 0: {
                return bluetoothHeadset.stopScoUsingVirtualVoiceCall();
            }
            case 2: {
                return bluetoothHeadset.stopVoiceRecognition(device);
            }
        }
        return false;
    }

    private static boolean connectBluetoothScoAudioHelper(BluetoothHeadset bluetoothHeadset, BluetoothDevice device, int scoAudioMode) {
        switch (scoAudioMode) {
            case 1: {
                return bluetoothHeadset.connectAudio();
            }
            case 0: {
                return bluetoothHeadset.startScoUsingVirtualVoiceCall();
            }
            case 2: {
                return bluetoothHeadset.startVoiceRecognition(device);
            }
        }
        return false;
    }

    private void checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    private ScoClient getScoClient(IBinder cb, boolean create) {
        for (ScoClient existingClient : this.mScoClients) {
            if (existingClient.getBinder() != cb) continue;
            return existingClient;
        }
        if (create) {
            ScoClient newClient = new ScoClient(cb);
            this.mScoClients.add(newClient);
            return newClient;
        }
        return null;
    }

    @GuardedBy(value={"BtHelper.this"})
    private void clearAllScoClients(int exceptPid, boolean stopSco) {
        ScoClient savedClient = null;
        for (ScoClient cl : this.mScoClients) {
            if (cl.getPid() != exceptPid) {
                cl.clearCount(stopSco);
                continue;
            }
            savedClient = cl;
        }
        this.mScoClients.clear();
        if (savedClient != null) {
            this.mScoClients.add(savedClient);
        }
    }

    private boolean getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mDeviceBroker.getContext(), this.mBluetoothProfileServiceListener, 1);
        }
        this.mDeviceBroker.handleFailureToConnectToBtHeadsetService(result ? 3000 : 0);
        return result;
    }

    private int mapBluetoothCodecToAudioFormat(int btCodecType) {
        switch (btCodecType) {
            case 0: {
                return 0x1F000000;
            }
            case 1: {
                return 0x4000000;
            }
            case 2: {
                return 0x20000000;
            }
            case 3: {
                return 0x21000000;
            }
            case 4: {
                return 0x23000000;
            }
        }
        return 0;
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        @Override
        public void binderDied() {
            BtHelper.this.mDeviceBroker.postScoClientDied(this);
        }

        @GuardedBy(value={"BtHelper.this"})
        void incCount(int scoAudioMode) {
            if (!this.requestScoState(12, scoAudioMode)) {
                Log.e(BtHelper.TAG, "Request sco connected with scoAudioMode(" + scoAudioMode + ") failed");
                return;
            }
            if (this.mStartcount == 0) {
                try {
                    this.mCb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w(BtHelper.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                }
            }
            ++this.mStartcount;
        }

        @GuardedBy(value={"BtHelper.this"})
        void decCount() {
            if (this.mStartcount == 0) {
                Log.w(BtHelper.TAG, "ScoClient.decCount() already 0");
            } else {
                --this.mStartcount;
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(BtHelper.TAG, "decCount() going to 0 but not registered to binder");
                    }
                }
                if (!this.requestScoState(10, 0)) {
                    Log.w(BtHelper.TAG, "Request sco disconnected with scoAudioMode(0) failed");
                }
            }
        }

        @GuardedBy(value={"BtHelper.this"})
        void clearCount(boolean stopSco) {
            if (this.mStartcount != 0) {
                try {
                    this.mCb.unlinkToDeath(this, 0);
                }
                catch (NoSuchElementException e) {
                    Log.w(BtHelper.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                }
            }
            this.mStartcount = 0;
            if (stopSco) {
                this.requestScoState(10, 0);
            }
        }

        int getCount() {
            return this.mStartcount;
        }

        IBinder getBinder() {
            return this.mCb;
        }

        int getPid() {
            return this.mCreatorPid;
        }

        private int totalCount() {
            int count = 0;
            for (ScoClient mScoClient : BtHelper.this.mScoClients) {
                count += mScoClient.getCount();
            }
            return count;
        }

        @GuardedBy(value={"BtHelper.this"})
        private boolean requestScoState(int state, int scoAudioMode) {
            BtHelper.this.checkScoAudioState();
            int clientCount = this.totalCount();
            if (clientCount != 0) {
                Log.i(BtHelper.TAG, "requestScoState: state=" + state + ", scoAudioMode=" + scoAudioMode + ", clientCount=" + clientCount);
                return true;
            }
            if (state == 12) {
                BtHelper.this.broadcastScoConnectionState(2);
                int modeOwnerPid = BtHelper.this.mDeviceBroker.getModeOwnerPid();
                if (modeOwnerPid != 0 && modeOwnerPid != this.mCreatorPid) {
                    Log.w(BtHelper.TAG, "requestScoState: audio mode is not NORMAL and modeOwnerPid " + modeOwnerPid + " != creatorPid " + this.mCreatorPid);
                    BtHelper.this.broadcastScoConnectionState(0);
                    return false;
                }
                switch (BtHelper.this.mScoAudioState) {
                    case 0: {
                        BtHelper.this.mScoAudioMode = scoAudioMode;
                        if (scoAudioMode == -1) {
                            BtHelper.this.mScoAudioMode = 0;
                            if (BtHelper.this.mBluetoothHeadsetDevice != null) {
                                BtHelper.this.mScoAudioMode = Settings.Global.getInt(BtHelper.this.mDeviceBroker.getContentResolver(), "bluetooth_sco_channel_" + BtHelper.this.mBluetoothHeadsetDevice.getAddress(), 0);
                                if (BtHelper.this.mScoAudioMode > 2 || BtHelper.this.mScoAudioMode < 0) {
                                    BtHelper.this.mScoAudioMode = 0;
                                }
                            }
                        }
                        if (BtHelper.this.mBluetoothHeadset == null) {
                            if (BtHelper.this.getBluetoothHeadset()) {
                                BtHelper.this.mScoAudioState = 1;
                                break;
                            }
                            Log.w(BtHelper.TAG, "requestScoState: getBluetoothHeadset failed during connection, mScoAudioMode=" + BtHelper.this.mScoAudioMode);
                            BtHelper.this.broadcastScoConnectionState(0);
                            return false;
                        }
                        if (BtHelper.this.mBluetoothHeadsetDevice == null) {
                            Log.w(BtHelper.TAG, "requestScoState: no active device while connecting, mScoAudioMode=" + BtHelper.this.mScoAudioMode);
                            BtHelper.this.broadcastScoConnectionState(0);
                            return false;
                        }
                        if (BtHelper.connectBluetoothScoAudioHelper(BtHelper.this.mBluetoothHeadset, BtHelper.this.mBluetoothHeadsetDevice, BtHelper.this.mScoAudioMode)) {
                            BtHelper.this.mScoAudioState = 3;
                            break;
                        }
                        Log.w(BtHelper.TAG, "requestScoState: connect to " + BtHelper.this.mBluetoothHeadsetDevice + " failed, mScoAudioMode=" + BtHelper.this.mScoAudioMode);
                        BtHelper.this.broadcastScoConnectionState(0);
                        return false;
                    }
                    case 5: {
                        BtHelper.this.mScoAudioState = 1;
                        break;
                    }
                    case 4: {
                        BtHelper.this.mScoAudioState = 3;
                        BtHelper.this.broadcastScoConnectionState(1);
                        break;
                    }
                    default: {
                        Log.w(BtHelper.TAG, "requestScoState: failed to connect in state " + BtHelper.this.mScoAudioState + ", scoAudioMode=" + scoAudioMode);
                        BtHelper.this.broadcastScoConnectionState(0);
                        return false;
                    }
                }
            } else if (state == 10) {
                switch (BtHelper.this.mScoAudioState) {
                    case 3: {
                        if (BtHelper.this.mBluetoothHeadset == null) {
                            if (BtHelper.this.getBluetoothHeadset()) {
                                BtHelper.this.mScoAudioState = 4;
                                break;
                            }
                            Log.w(BtHelper.TAG, "requestScoState: getBluetoothHeadset failed during disconnection, mScoAudioMode=" + BtHelper.this.mScoAudioMode);
                            BtHelper.this.mScoAudioState = 0;
                            BtHelper.this.broadcastScoConnectionState(0);
                            return false;
                        }
                        if (BtHelper.this.mBluetoothHeadsetDevice == null) {
                            BtHelper.this.mScoAudioState = 0;
                            BtHelper.this.broadcastScoConnectionState(0);
                            break;
                        }
                        if (BtHelper.disconnectBluetoothScoAudioHelper(BtHelper.this.mBluetoothHeadset, BtHelper.this.mBluetoothHeadsetDevice, BtHelper.this.mScoAudioMode)) {
                            BtHelper.this.mScoAudioState = 5;
                            break;
                        }
                        BtHelper.this.mScoAudioState = 0;
                        BtHelper.this.broadcastScoConnectionState(0);
                        break;
                    }
                    case 1: {
                        BtHelper.this.mScoAudioState = 0;
                        BtHelper.this.broadcastScoConnectionState(0);
                        break;
                    }
                    default: {
                        Log.w(BtHelper.TAG, "requestScoState: failed to disconnect in state " + BtHelper.this.mScoAudioState + ", scoAudioMode=" + scoAudioMode);
                        BtHelper.this.broadcastScoConnectionState(0);
                        return false;
                    }
                }
            }
            return true;
        }
    }

    static class BluetoothA2dpDeviceInfo {
        private final BluetoothDevice mBtDevice;
        private final int mVolume;
        private final int mCodec;

        BluetoothA2dpDeviceInfo(BluetoothDevice btDevice) {
            this(btDevice, -1, 0);
        }

        BluetoothA2dpDeviceInfo(BluetoothDevice btDevice, int volume, int codec) {
            this.mBtDevice = btDevice;
            this.mVolume = volume;
            this.mCodec = codec;
        }

        public BluetoothDevice getBtDevice() {
            return this.mBtDevice;
        }

        public int getVolume() {
            return this.mVolume;
        }

        public int getCodec() {
            return this.mCodec;
        }
    }
}

