/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.app.AppOpsManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusInfo;
import android.media.IAudioFocusDispatcher;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.FocusRequester;
import com.android.server.audio.PlayerFocusEnforcer;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class MediaFocusControl
implements PlayerFocusEnforcer {
    private static final String TAG = "MediaFocusControl";
    static final boolean DEBUG = false;
    static final boolean ENFORCE_DUCKING = true;
    static final boolean ENFORCE_DUCKING_FOR_NEW = true;
    static final int DUCKING_IN_APP_SDK_LEVEL = 25;
    static final boolean ENFORCE_MUTING_FOR_RING_OR_CALL = true;
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private PlayerFocusEnforcer mFocusEnforcer;
    private boolean mRingOrCallActive = false;
    private final Object mExtFocusChangeLock = new Object();
    @GuardedBy(value={"mExtFocusChangeLock"})
    private long mExtFocusChangeCounter;
    private static final Object mAudioFocusLock = new Object();
    private static final int MAX_STACK_SIZE = 100;
    private static final AudioEventLogger mEventLogger = new AudioEventLogger(50, "focus commands as seen by MediaFocusControl");
    private final Stack<FocusRequester> mFocusStack = new Stack();
    private boolean mNotifyFocusOwnerOnDuck = true;
    private ArrayList<IAudioPolicyCallback> mFocusFollowers = new ArrayList();
    @GuardedBy(value={"mAudioFocusLock"})
    private IAudioPolicyCallback mFocusPolicy = null;
    @GuardedBy(value={"mAudioFocusLock"})
    private IAudioPolicyCallback mPreviousFocusPolicy = null;
    private HashMap<String, FocusRequester> mFocusOwnersForFocusPolicy = new HashMap();
    private static final int RING_CALL_MUTING_ENFORCEMENT_DELAY_MS = 100;
    private static final int[] USAGES_TO_MUTE_IN_RING_OR_CALL = new int[]{1, 14};

    protected MediaFocusControl(Context cntxt, PlayerFocusEnforcer pfe) {
        this.mContext = cntxt;
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mFocusEnforcer = pfe;
    }

    protected void dump(PrintWriter pw) {
        pw.println("\nMediaFocusControl dump time: " + DateFormat.getTimeInstance().format(new Date()));
        this.dumpFocusStack(pw);
        pw.println("\n");
        mEventLogger.dump(pw);
    }

    @Override
    public boolean duckPlayers(FocusRequester winner, FocusRequester loser, boolean forceDuck) {
        return this.mFocusEnforcer.duckPlayers(winner, loser, forceDuck);
    }

    @Override
    public void unduckPlayers(FocusRequester winner) {
        this.mFocusEnforcer.unduckPlayers(winner);
    }

    @Override
    public void mutePlayersForCall(int[] usagesToMute) {
        this.mFocusEnforcer.mutePlayersForCall(usagesToMute);
    }

    @Override
    public void unmutePlayersForCall() {
        this.mFocusEnforcer.unmutePlayersForCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noFocusForSuspendedApp(String packageName, int uid) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator stackIterator = this.mFocusStack.iterator();
            ArrayList<String> clientsToRemove = new ArrayList<String>();
            while (stackIterator.hasNext()) {
                FocusRequester focusOwner = (FocusRequester)stackIterator.next();
                if (!focusOwner.hasSameUid(uid) || !focusOwner.hasSamePackage(packageName)) continue;
                clientsToRemove.add(focusOwner.getClientId());
                mEventLogger.log(new AudioEventLogger.StringEvent("focus owner:" + focusOwner.getClientId() + " in uid:" + uid + " pack: " + packageName + " getting AUDIOFOCUS_LOSS due to app suspension").printLog(TAG));
                focusOwner.dispatchFocusChange(-1);
            }
            for (String clientToRemove : clientsToRemove) {
                this.removeFocusStackEntry(clientToRemove, false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasAudioFocusUsers() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            return !this.mFocusStack.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardAudioFocusOwner() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) {
                FocusRequester exFocusOwner = this.mFocusStack.pop();
                exFocusOwner.handleFocusLoss(-1, null, false);
                exFocusOwner.release();
            }
        }
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.canReassignAudioFocus()) {
            this.mFocusStack.peek().handleFocusGain(1);
        }
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private void propagateFocusLossFromGain_syncAf(int focusGain, FocusRequester fr, boolean forceDuck) {
        LinkedList<String> clientsToRemove = new LinkedList<String>();
        for (FocusRequester focusLoser : this.mFocusStack) {
            boolean isDefinitiveLoss = focusLoser.handleFocusLossFromGain(focusGain, fr, forceDuck);
            if (!isDefinitiveLoss) continue;
            clientsToRemove.add(focusLoser.getClientId());
        }
        for (String clientToRemove : clientsToRemove) {
            this.removeFocusStackEntry(clientToRemove, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries (last is top of stack):");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                ((FocusRequester)stackIterator.next()).dump(pw);
            }
            pw.println("\n");
            if (this.mFocusPolicy == null) {
                pw.println("No external focus policy\n");
            } else {
                pw.println("External focus policy: " + this.mFocusPolicy + ", focus owners:\n");
                this.dumpExtFocusPolicyFocusOwners(pw);
            }
        }
        pw.println("\n");
        pw.println(" Notify on duck:  " + this.mNotifyFocusOwnerOnDuck + "\n");
        pw.println(" In ring or call: " + this.mRingOrCallActive + "\n");
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private void removeFocusStackEntry(String clientToRemove, boolean signal, boolean notifyFocusFollowers) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientToRemove)) {
            FocusRequester fr = this.mFocusStack.pop();
            fr.release();
            if (notifyFocusFollowers) {
                AudioFocusInfo afi = fr.toAudioFocusInfo();
                afi.clearLossReceived();
                this.notifyExtPolicyFocusLoss_syncAf(afi, false);
            }
            if (signal) {
                this.notifyTopOfAudioFocusStack();
            }
        } else {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                FocusRequester fr = (FocusRequester)stackIterator.next();
                if (!fr.hasSameClient(clientToRemove)) continue;
                Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + clientToRemove);
                stackIterator.remove();
                fr.release();
            }
        }
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private void removeFocusStackEntryOnDeath(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().hasSameBinder(cb);
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            FocusRequester fr = (FocusRequester)stackIterator.next();
            if (!fr.hasSameBinder(cb)) continue;
            Log.i(TAG, "AudioFocus  removeFocusStackEntryOnDeath(): removing entry for " + cb);
            stackIterator.remove();
            fr.release();
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private void removeFocusEntryForExtPolicy(IBinder cb) {
        if (this.mFocusOwnersForFocusPolicy.isEmpty()) {
            return;
        }
        boolean released = false;
        Set<Map.Entry<String, FocusRequester>> owners = this.mFocusOwnersForFocusPolicy.entrySet();
        Iterator<Map.Entry<String, FocusRequester>> ownerIterator = owners.iterator();
        while (ownerIterator.hasNext()) {
            Map.Entry<String, FocusRequester> owner = ownerIterator.next();
            FocusRequester fr = owner.getValue();
            if (!fr.hasSameBinder(cb)) continue;
            ownerIterator.remove();
            fr.release();
            this.notifyExtFocusPolicyFocusAbandon_syncAf(fr.toAudioFocusInfo());
            break;
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !this.isLockedFocusOwner(this.mFocusStack.peek());
    }

    private boolean isLockedFocusOwner(FocusRequester fr) {
        return fr.hasSameClient("AudioFocus_For_Phone_Ring_And_Calls") || fr.isLockedFocusOwner();
    }

    @GuardedBy(value={"mAudioFocusLock"})
    private int pushBelowLockedFocusOwners(FocusRequester nfr) {
        int lastLockedFocusOwnerIndex = this.mFocusStack.size();
        for (int index = this.mFocusStack.size() - 1; index >= 0; --index) {
            if (!this.isLockedFocusOwner((FocusRequester)this.mFocusStack.elementAt(index))) continue;
            lastLockedFocusOwnerIndex = index;
        }
        if (lastLockedFocusOwnerIndex == this.mFocusStack.size()) {
            Log.e(TAG, "No exclusive focus owner found in propagateFocusLossFromGain_syncAf()", new Exception());
            this.propagateFocusLossFromGain_syncAf(nfr.getGainRequest(), nfr, false);
            this.mFocusStack.push(nfr);
            return 1;
        }
        this.mFocusStack.insertElementAt(nfr, lastLockedFocusOwnerIndex);
        return 2;
    }

    protected void setDuckingInExtPolicyAvailable(boolean available) {
        this.mNotifyFocusOwnerOnDuck = !available;
    }

    boolean mustNotifyFocusOwnerOnDuck() {
        return this.mNotifyFocusOwnerOnDuck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFocusFollower(IAudioPolicyCallback ff) {
        if (ff == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            boolean found = false;
            for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
                if (!pcb.asBinder().equals(ff.asBinder())) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
            this.mFocusFollowers.add(ff);
            this.notifyExtPolicyCurrentFocusAsync(ff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFocusFollower(IAudioPolicyCallback ff) {
        if (ff == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
                if (!pcb.asBinder().equals(ff.asBinder())) continue;
                this.mFocusFollowers.remove(pcb);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocusPolicy(IAudioPolicyCallback policy, boolean isTestFocusPolicy) {
        if (policy == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (isTestFocusPolicy) {
                this.mPreviousFocusPolicy = this.mFocusPolicy;
            }
            this.mFocusPolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetFocusPolicy(IAudioPolicyCallback policy, boolean isTestFocusPolicy) {
        if (policy == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusPolicy == policy) {
                this.mFocusPolicy = isTestFocusPolicy ? this.mPreviousFocusPolicy : null;
            }
        }
    }

    void notifyExtPolicyCurrentFocusAsync(IAudioPolicyCallback pcb) {
        final IAudioPolicyCallback pcb2 = pcb;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mAudioFocusLock;
                synchronized (object) {
                    if (MediaFocusControl.this.mFocusStack.isEmpty()) {
                        return;
                    }
                    try {
                        pcb2.notifyAudioFocusGrant(((FocusRequester)MediaFocusControl.this.mFocusStack.peek()).toAudioFocusInfo(), 1);
                    }
                    catch (RemoteException e) {
                        Log.e(MediaFocusControl.TAG, "Can't call notifyAudioFocusGrant() on IAudioPolicyCallback " + pcb2.asBinder(), e);
                    }
                }
            }
        };
        thread.start();
    }

    void notifyExtPolicyFocusGrant_syncAf(AudioFocusInfo afi, int requestResult) {
        for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
            try {
                pcb.notifyAudioFocusGrant(afi, requestResult);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyAudioFocusGrant() on IAudioPolicyCallback " + pcb.asBinder(), e);
            }
        }
    }

    void notifyExtPolicyFocusLoss_syncAf(AudioFocusInfo afi, boolean wasDispatched) {
        for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
            try {
                pcb.notifyAudioFocusLoss(afi, wasDispatched);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyAudioFocusLoss() on IAudioPolicyCallback " + pcb.asBinder(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyExtFocusPolicyFocusRequest_syncAf(AudioFocusInfo afi, IAudioFocusDispatcher fd, IBinder cb) {
        Object object = this.mExtFocusChangeLock;
        synchronized (object) {
            afi.setGen(this.mExtFocusChangeCounter++);
        }
        FocusRequester existingFr = this.mFocusOwnersForFocusPolicy.get(afi.getClientId());
        boolean keepTrack = false;
        if (existingFr != null) {
            if (!existingFr.hasSameDispatcher(fd)) {
                existingFr.release();
                keepTrack = true;
            }
        } else {
            keepTrack = true;
        }
        if (keepTrack) {
            AudioFocusDeathHandler hdlr = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(hdlr, 0);
            }
            catch (RemoteException e) {
                return false;
            }
            this.mFocusOwnersForFocusPolicy.put(afi.getClientId(), new FocusRequester(afi, fd, cb, hdlr, this));
        }
        try {
            this.mFocusPolicy.notifyAudioFocusRequest(afi, 1);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call notifyAudioFocusRequest() on IAudioPolicyCallback " + this.mFocusPolicy.asBinder(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult) {
        Object object = this.mExtFocusChangeLock;
        synchronized (object) {
            if (afi.getGen() > this.mExtFocusChangeCounter) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
            FocusRequester fr = this.mFocusOwnersForFocusPolicy.get(afi.getClientId());
            if (fr != null) {
                fr.dispatchFocusResultFromExtPolicy(requestResult);
            }
            return;
        }
    }

    boolean notifyExtFocusPolicyFocusAbandon_syncAf(AudioFocusInfo afi) {
        if (this.mFocusPolicy == null) {
            return false;
        }
        FocusRequester fr = this.mFocusOwnersForFocusPolicy.remove(afi.getClientId());
        if (fr != null) {
            fr.release();
        }
        try {
            this.mFocusPolicy.notifyAudioFocusAbandon(afi);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call notifyAudioFocusAbandon() on IAudioPolicyCallback " + this.mFocusPolicy.asBinder(), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dispatchFocusChange(AudioFocusInfo afi, int focusChange) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusPolicy == null) {
                return 0;
            }
            FocusRequester fr = focusChange == -1 ? this.mFocusOwnersForFocusPolicy.remove(afi.getClientId()) : this.mFocusOwnersForFocusPolicy.get(afi.getClientId());
            if (fr == null) {
                return 0;
            }
            return fr.dispatchFocusChange(focusChange);
        }
    }

    private void dumpExtFocusPolicyFocusOwners(PrintWriter pw) {
        Set<Map.Entry<String, FocusRequester>> owners = this.mFocusOwnersForFocusPolicy.entrySet();
        for (Map.Entry<String, FocusRequester> owner : owners) {
            FocusRequester fr = owner.getValue();
            fr.dump(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentAudioFocus() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusStack.empty()) {
                return 0;
            }
            return this.mFocusStack.peek().getGainRequest();
        }
    }

    protected static int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) {
        switch (attr2.getUsage()) {
            case 1: 
            case 14: {
                return 1000;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 16: {
                return 700;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                return 500;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int requestAudioFocus(AudioAttributes aa, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int sdk, boolean forceDuck) {
        mEventLogger.log(new AudioEventLogger.StringEvent("requestAudioFocus() from uid/pid " + Binder.getCallingUid() + "/" + Binder.getCallingPid() + " clientId=" + clientId + " callingPack=" + callingPackageName + " req=" + focusChangeHint + " flags=0x" + Integer.toHexString(flags) + " sdk=" + sdk).printLog(TAG));
        if (!cb.pingBinder()) {
            Log.e(TAG, " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        if (this.mAppOps.noteOp(32, Binder.getCallingUid(), callingPackageName) != 0) {
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusStack.size() > 100) {
                Log.e(TAG, "Max AudioFocus stack size reached, failing requestAudioFocus()");
                return 0;
            }
            boolean enteringRingOrCall = !this.mRingOrCallActive & "AudioFocus_For_Phone_Ring_And_Calls".compareTo(clientId) == 0;
            if (enteringRingOrCall) {
                this.mRingOrCallActive = true;
            }
            AudioFocusInfo afiForExtPolicy = this.mFocusPolicy != null ? new AudioFocusInfo(aa, Binder.getCallingUid(), clientId, callingPackageName, focusChangeHint, 0, flags, sdk) : null;
            boolean focusGrantDelayed = false;
            if (!this.canReassignAudioFocus()) {
                if ((flags & 1) == 0) {
                    return 0;
                }
                focusGrantDelayed = true;
            }
            if (this.mFocusPolicy != null) {
                if (this.notifyExtFocusPolicyFocusRequest_syncAf(afiForExtPolicy, fd, cb)) {
                    return 100;
                }
                return 0;
            }
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientId)) {
                FocusRequester fr = this.mFocusStack.peek();
                if (fr.getGainRequest() == focusChangeHint && fr.getGrantFlags() == flags) {
                    cb.unlinkToDeath(afdh, 0);
                    this.notifyExtPolicyFocusGrant_syncAf(fr.toAudioFocusInfo(), 1);
                    return 1;
                }
                if (!focusGrantDelayed) {
                    this.mFocusStack.pop();
                    fr.release();
                }
            }
            this.removeFocusStackEntry(clientId, false, false);
            FocusRequester nfr = new FocusRequester(aa, focusChangeHint, flags, fd, cb, clientId, afdh, callingPackageName, Binder.getCallingUid(), this, sdk);
            if (focusGrantDelayed) {
                int requestResult = this.pushBelowLockedFocusOwners(nfr);
                if (requestResult != 0) {
                    this.notifyExtPolicyFocusGrant_syncAf(nfr.toAudioFocusInfo(), requestResult);
                }
                return requestResult;
            }
            if (!this.mFocusStack.empty()) {
                this.propagateFocusLossFromGain_syncAf(focusChangeHint, nfr, forceDuck);
            }
            this.mFocusStack.push(nfr);
            nfr.handleFocusGainFromRequest(1);
            this.notifyExtPolicyFocusGrant_syncAf(nfr.toAudioFocusInfo(), 1);
            if (true & enteringRingOrCall) {
                this.runAudioCheckerForRingOrCallAsync(true);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int abandonAudioFocus(IAudioFocusDispatcher fl, String clientId, AudioAttributes aa, String callingPackageName) {
        mEventLogger.log(new AudioEventLogger.StringEvent("abandonAudioFocus() from uid/pid " + Binder.getCallingUid() + "/" + Binder.getCallingPid() + " clientId=" + clientId).printLog(TAG));
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                AudioFocusInfo afi;
                if (this.mFocusPolicy != null && this.notifyExtFocusPolicyFocusAbandon_syncAf(afi = new AudioFocusInfo(aa, Binder.getCallingUid(), clientId, callingPackageName, 0, 0, 0, 0))) {
                    return 1;
                }
                boolean exitingRingOrCall = this.mRingOrCallActive & "AudioFocus_For_Phone_Ring_And_Calls".compareTo(clientId) == 0;
                if (exitingRingOrCall) {
                    this.mRingOrCallActive = false;
                }
                this.removeFocusStackEntry(clientId, true, true);
                if (true & exitingRingOrCall) {
                    this.runAudioCheckerForRingOrCallAsync(false);
                }
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false, true);
        }
    }

    private void runAudioCheckerForRingOrCallAsync(final boolean enteringRingOrCall) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (enteringRingOrCall) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Object object = mAudioFocusLock;
                synchronized (object) {
                    if (MediaFocusControl.this.mRingOrCallActive) {
                        MediaFocusControl.this.mFocusEnforcer.mutePlayersForCall(USAGES_TO_MUTE_IN_RING_OR_CALL);
                    } else {
                        MediaFocusControl.this.mFocusEnforcer.unmutePlayersForCall();
                    }
                }
            }
        }.start();
    }

    protected class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                if (MediaFocusControl.this.mFocusPolicy != null) {
                    MediaFocusControl.this.removeFocusEntryForExtPolicy(this.mCb);
                } else {
                    MediaFocusControl.this.removeFocusStackEntryOnDeath(this.mCb);
                }
            }
        }
    }
}

