/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioSystem;
import android.media.IPlaybackConfigDispatcher;
import android.media.PlayerBase;
import android.media.VolumeShaper;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.FocusRequester;
import com.android.server.audio.MediaFocusControl;
import com.android.server.audio.PlayerFocusEnforcer;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PlaybackActivityMonitor
implements AudioPlaybackConfiguration.PlayerDeathMonitor,
PlayerFocusEnforcer {
    public static final String TAG = "AudioService.PlaybackActivityMonitor";
    private static final boolean DEBUG = false;
    private static final int VOLUME_SHAPER_SYSTEM_DUCK_ID = 1;
    private static final VolumeShaper.Configuration DUCK_VSHAPE = new VolumeShaper.Configuration.Builder().setId(1).setCurve(new float[]{0.0f, 1.0f}, new float[]{1.0f, 0.2f}).setOptionFlags(2).setDuration(MediaFocusControl.getFocusRampTimeMs(3, new AudioAttributes.Builder().setUsage(5).build())).build();
    private static final VolumeShaper.Configuration DUCK_ID = new VolumeShaper.Configuration(1);
    private static final VolumeShaper.Operation PLAY_CREATE_IF_NEEDED = new VolumeShaper.Operation.Builder(VolumeShaper.Operation.PLAY).createIfNeeded().build();
    private static final int[] UNDUCKABLE_PLAYER_TYPES = new int[]{13, 3};
    private static final VolumeShaper.Operation PLAY_SKIP_RAMP = new VolumeShaper.Operation.Builder(PLAY_CREATE_IF_NEEDED).setXOffset(1.0f).build();
    private final ArrayList<PlayMonitorClient> mClients = new ArrayList();
    private boolean mHasPublicClients = false;
    private final Object mPlayerLock = new Object();
    private final HashMap<Integer, AudioPlaybackConfiguration> mPlayers = new HashMap();
    private final Context mContext;
    private int mSavedAlarmVolume = -1;
    private final int mMaxAlarmVolume;
    private int mPrivilegedAlarmActiveCount = 0;
    private final ArrayList<Integer> mBannedUids = new ArrayList();
    private static final int FLAGS_FOR_SILENCE_OVERRIDE = 192;
    private final ArrayList<Integer> mMutedPlayers = new ArrayList();
    private final DuckingManager mDuckingManager = new DuckingManager();
    private static final AudioEventLogger sEventLogger = new AudioEventLogger(100, "playback activity as reported through PlayerBase");

    PlaybackActivityMonitor(Context context, int maxAlarmVolume) {
        this.mContext = context;
        this.mMaxAlarmVolume = maxAlarmVolume;
        PlayMonitorClient.sListenerDeathMonitor = this;
        AudioPlaybackConfiguration.sPlayerDeathMonitor = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAudioForUid(boolean disable, int uid) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            int index = this.mBannedUids.indexOf(new Integer(uid));
            if (index >= 0) {
                if (!disable) {
                    this.mBannedUids.remove(index);
                }
            } else if (disable) {
                for (AudioPlaybackConfiguration apc : this.mPlayers.values()) {
                    this.checkBanPlayer(apc, uid);
                }
                this.mBannedUids.add(new Integer(uid));
            }
        }
    }

    private boolean checkBanPlayer(AudioPlaybackConfiguration apc, int uid) {
        boolean toBan;
        boolean bl = toBan = apc.getClientUid() == uid;
        if (toBan) {
            int piid = apc.getPlayerInterfaceId();
            try {
                Log.v(TAG, "banning player " + piid + " uid:" + uid);
                apc.getPlayerProxy().pause();
            }
            catch (Exception e) {
                Log.e(TAG, "error banning player " + piid + " uid:" + uid, e);
            }
        }
        return toBan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trackPlayer(PlayerBase.PlayerIdCard pic) {
        int newPiid = AudioSystem.newAudioPlayerId();
        AudioPlaybackConfiguration apc = new AudioPlaybackConfiguration(pic, newPiid, Binder.getCallingUid(), Binder.getCallingPid());
        apc.init();
        sEventLogger.log(new NewPlayerEvent(apc));
        Object object = this.mPlayerLock;
        synchronized (object) {
            this.mPlayers.put(newPiid, apc);
        }
        return newPiid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerAttributes(int piid, AudioAttributes attr2, int binderUid) {
        boolean change;
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                sEventLogger.log(new AudioAttrEvent(piid, attr2));
                change = apc.handleAudioAttributesEvent(attr2);
            } else {
                Log.e(TAG, "Error updating audio attributes");
                change = false;
            }
        }
        if (change) {
            this.dispatchPlaybackChange(false);
        }
    }

    private void checkVolumeForPrivilegedAlarm(AudioPlaybackConfiguration apc, int event) {
        if ((event == 2 || apc.getPlayerState() == 2) && (apc.getAudioAttributes().getAllFlags() & 0xC0) == 192 && apc.getAudioAttributes().getUsage() == 4 && this.mContext.checkPermission("android.permission.MODIFY_PHONE_STATE", apc.getClientPid(), apc.getClientUid()) == 0) {
            if (event == 2 && apc.getPlayerState() != 2) {
                if (this.mPrivilegedAlarmActiveCount++ == 0) {
                    this.mSavedAlarmVolume = AudioSystem.getStreamVolumeIndex(4, 2);
                    AudioSystem.setStreamVolumeIndexAS(4, this.mMaxAlarmVolume, 2);
                }
            } else if (event != 2 && apc.getPlayerState() == 2 && --this.mPrivilegedAlarmActiveCount == 0 && AudioSystem.getStreamVolumeIndex(4, 2) == this.mMaxAlarmVolume) {
                AudioSystem.setStreamVolumeIndexAS(4, this.mSavedAlarmVolume, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void playerEvent(int piid, int event, int binderUid) {
        boolean change;
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (apc == null) {
                return;
            }
            sEventLogger.log(new PlayerEvent(piid, event));
            if (event == 2) {
                for (Integer uidInteger : this.mBannedUids) {
                    if (!this.checkBanPlayer(apc, uidInteger)) continue;
                    sEventLogger.log(new AudioEventLogger.StringEvent("not starting piid:" + piid + " ,is banned"));
                    return;
                }
            }
            if (apc.getPlayerType() == 3) {
                return;
            }
            if (!PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                Log.e(TAG, "Error handling event " + event);
                return;
            }
            this.checkVolumeForPrivilegedAlarm(apc, event);
            change = apc.handleStateEvent(event);
            if (change && event == 2) {
                this.mDuckingManager.checkDuck(apc);
            }
        }
        if (!change) return;
        this.dispatchPlaybackChange(event == 0);
    }

    public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio, int binderUid) {
        sEventLogger.log(new PlayerOpPlayAudioEvent(piid, hasOpPlayAudio, binderUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePlayer(int piid, int binderUid) {
        boolean change = false;
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                sEventLogger.log(new AudioEventLogger.StringEvent("releasing player piid:" + piid));
                this.mPlayers.remove(new Integer(piid));
                this.mDuckingManager.removeReleased(apc);
                this.checkVolumeForPrivilegedAlarm(apc, 0);
                change = apc.handleStateEvent(0);
            }
        }
        if (change) {
            this.dispatchPlaybackChange(true);
        }
    }

    @Override
    public void playerDeath(int piid) {
        this.releasePlayer(piid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(PrintWriter pw) {
        pw.println("\nPlaybackActivityMonitor dump time: " + DateFormat.getTimeInstance().format(new Date()));
        Object object = this.mPlayerLock;
        synchronized (object) {
            pw.println("\n  playback listeners:");
            ArrayList<PlayMonitorClient> arrayList = this.mClients;
            synchronized (arrayList) {
                for (PlayMonitorClient pmc : this.mClients) {
                    pw.print(" " + (pmc.mIsPrivileged ? "(S)" : "(P)") + pmc.toString());
                }
            }
            pw.println("\n");
            pw.println("\n  players:");
            ArrayList<Integer> piidIntList = new ArrayList<Integer>(this.mPlayers.keySet());
            Collections.sort(piidIntList);
            for (Integer piidInt : piidIntList) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piidInt);
                if (apc == null) continue;
                apc.dump(pw);
            }
            pw.println("\n  ducked players piids:");
            this.mDuckingManager.dump(pw);
            pw.print("\n  muted player piids:");
            Iterator<Object> iterator = this.mMutedPlayers.iterator();
            while (iterator.hasNext()) {
                int piid = (Integer)iterator.next();
                pw.print(" " + piid);
            }
            pw.println();
            pw.print("\n  banned uids:");
            iterator = this.mBannedUids.iterator();
            while (iterator.hasNext()) {
                int uid = (Integer)iterator.next();
                pw.print(" " + uid);
            }
            pw.println("\n");
            sEventLogger.dump(pw);
        }
    }

    private static boolean checkConfigurationCaller(int piid, AudioPlaybackConfiguration apc, int binderUid) {
        if (apc == null) {
            return false;
        }
        if (binderUid != 0 && apc.getClientUid() != binderUid) {
            Log.e(TAG, "Forbidden operation from uid " + binderUid + " for player " + piid);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPlaybackChange(boolean iplayerReleased) {
        ArrayList<AudioPlaybackConfiguration> configsSystem;
        ArrayList<PlayMonitorClient> arrayList;
        ArrayList<PlayMonitorClient> arrayList2 = this.mClients;
        synchronized (arrayList2) {
            if (this.mClients.isEmpty()) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            arrayList = this.mPlayerLock;
        }
        synchronized (arrayList) {
            if (this.mPlayers.isEmpty()) {
                return;
            }
            configsSystem = new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values());
        }
        arrayList = this.mClients;
        synchronized (arrayList) {
            if (this.mClients.isEmpty()) {
                return;
            }
            ArrayList<AudioPlaybackConfiguration> configsPublic = this.mHasPublicClients ? this.anonymizeForPublicConsumption(configsSystem) : null;
            for (PlayMonitorClient pmc : this.mClients) {
                try {
                    if (pmc.mErrorCount >= 5) continue;
                    if (pmc.mIsPrivileged) {
                        pmc.mDispatcherCb.dispatchPlaybackConfigChange(configsSystem, iplayerReleased);
                        continue;
                    }
                    pmc.mDispatcherCb.dispatchPlaybackConfigChange(configsPublic, false);
                }
                catch (RemoteException e) {
                    ++pmc.mErrorCount;
                    Log.e(TAG, "Error (" + pmc.mErrorCount + ") trying to dispatch playback config change to " + pmc, e);
                }
            }
        }
    }

    private ArrayList<AudioPlaybackConfiguration> anonymizeForPublicConsumption(List<AudioPlaybackConfiguration> sysConfigs) {
        ArrayList<AudioPlaybackConfiguration> publicConfigs = new ArrayList<AudioPlaybackConfiguration>();
        for (AudioPlaybackConfiguration config : sysConfigs) {
            if (!config.isActive()) continue;
            publicConfigs.add(AudioPlaybackConfiguration.anonymizedCopy(config));
        }
        return publicConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean duckPlayers(FocusRequester winner, FocusRequester loser, boolean forceDuck) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mPlayers.isEmpty()) {
                return true;
            }
            Iterator<AudioPlaybackConfiguration> apcIterator = this.mPlayers.values().iterator();
            ArrayList<AudioPlaybackConfiguration> apcsToDuck = new ArrayList<AudioPlaybackConfiguration>();
            while (apcIterator.hasNext()) {
                AudioPlaybackConfiguration apc = apcIterator.next();
                if (winner.hasSameUid(apc.getClientUid()) || !loser.hasSameUid(apc.getClientUid()) || apc.getPlayerState() != 2) continue;
                if (!forceDuck && apc.getAudioAttributes().getContentType() == 1) {
                    Log.v(TAG, "not ducking player " + apc.getPlayerInterfaceId() + " uid:" + apc.getClientUid() + " pid:" + apc.getClientPid() + " - SPEECH");
                    return false;
                }
                if (ArrayUtils.contains(UNDUCKABLE_PLAYER_TYPES, apc.getPlayerType())) {
                    Log.v(TAG, "not ducking player " + apc.getPlayerInterfaceId() + " uid:" + apc.getClientUid() + " pid:" + apc.getClientPid() + " due to type:" + AudioPlaybackConfiguration.toLogFriendlyPlayerType(apc.getPlayerType()));
                    return false;
                }
                apcsToDuck.add(apc);
            }
            this.mDuckingManager.duckUid(loser.getClientUid(), apcsToDuck);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unduckPlayers(FocusRequester winner) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            this.mDuckingManager.unduckUid(winner.getClientUid(), this.mPlayers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutePlayersForCall(int[] usagesToMute) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            Set<Integer> piidSet = this.mPlayers.keySet();
            for (Integer piid : piidSet) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc == null) continue;
                int playerUsage = apc.getAudioAttributes().getUsage();
                boolean mute = false;
                for (int usageToMute : usagesToMute) {
                    if (playerUsage != usageToMute) continue;
                    mute = true;
                    break;
                }
                if (!mute) continue;
                try {
                    sEventLogger.log(new AudioEventLogger.StringEvent("call: muting piid:" + piid + " uid:" + apc.getClientUid()).printLog(TAG));
                    apc.getPlayerProxy().setVolume(0.0f);
                    this.mMutedPlayers.add(new Integer(piid));
                }
                catch (Exception e) {
                    Log.e(TAG, "call: error muting player " + piid, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmutePlayersForCall() {
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mMutedPlayers.isEmpty()) {
                return;
            }
            for (int piid : this.mMutedPlayers) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc == null) continue;
                try {
                    sEventLogger.log(new AudioEventLogger.StringEvent("call: unmuting piid:" + piid).printLog(TAG));
                    apc.getPlayerProxy().setVolume(1.0f);
                }
                catch (Exception e) {
                    Log.e(TAG, "call: error unmuting player " + piid + " uid:" + apc.getClientUid(), e);
                }
            }
            this.mMutedPlayers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb, boolean isPrivileged) {
        if (pcdb == null) {
            return;
        }
        ArrayList<PlayMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            PlayMonitorClient pmc = new PlayMonitorClient(pcdb, isPrivileged);
            if (pmc.init()) {
                if (!isPrivileged) {
                    this.mHasPublicClients = true;
                }
                this.mClients.add(pmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        if (pcdb == null) {
            return;
        }
        ArrayList<PlayMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            Iterator<PlayMonitorClient> clientIterator = this.mClients.iterator();
            boolean hasPublicClients = false;
            while (clientIterator.hasNext()) {
                PlayMonitorClient pmc = clientIterator.next();
                if (pcdb.equals(pmc.mDispatcherCb)) {
                    pmc.release();
                    clientIterator.remove();
                    continue;
                }
                if (pmc.mIsPrivileged) continue;
                hasPublicClients = true;
            }
            this.mHasPublicClients = hasPublicClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioPlaybackConfiguration> getActivePlaybackConfigurations(boolean isPrivileged) {
        HashMap<Integer, AudioPlaybackConfiguration> hashMap = this.mPlayers;
        synchronized (hashMap) {
            ArrayList<AudioPlaybackConfiguration> configsPublic;
            if (isPrivileged) {
                return new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values());
            }
            Object object = this.mPlayerLock;
            synchronized (object) {
                configsPublic = this.anonymizeForPublicConsumption(new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values()));
            }
            return configsPublic;
        }
    }

    private static final class AudioAttrEvent
    extends AudioEventLogger.Event {
        private final int mPlayerIId;
        private final AudioAttributes mPlayerAttr;

        AudioAttrEvent(int piid, AudioAttributes attr2) {
            this.mPlayerIId = piid;
            this.mPlayerAttr = attr2;
        }

        @Override
        public String eventToString() {
            return new String("player piid:" + this.mPlayerIId + " new AudioAttributes:" + this.mPlayerAttr);
        }
    }

    private static final class DuckEvent
    extends AudioEventLogger.Event {
        private final int mPlayerIId;
        private final boolean mSkipRamp;
        private final int mClientUid;
        private final int mClientPid;

        DuckEvent(AudioPlaybackConfiguration apc, boolean skipRamp) {
            this.mPlayerIId = apc.getPlayerInterfaceId();
            this.mSkipRamp = skipRamp;
            this.mClientUid = apc.getClientUid();
            this.mClientPid = apc.getClientPid();
        }

        @Override
        public String eventToString() {
            return "ducking player piid:" + this.mPlayerIId + " uid/pid:" + this.mClientUid + "/" + this.mClientPid + " skip ramp:" + this.mSkipRamp;
        }
    }

    private static final class NewPlayerEvent
    extends AudioEventLogger.Event {
        private final int mPlayerIId;
        private final int mPlayerType;
        private final int mClientUid;
        private final int mClientPid;
        private final AudioAttributes mPlayerAttr;

        NewPlayerEvent(AudioPlaybackConfiguration apc) {
            this.mPlayerIId = apc.getPlayerInterfaceId();
            this.mPlayerType = apc.getPlayerType();
            this.mClientUid = apc.getClientUid();
            this.mClientPid = apc.getClientPid();
            this.mPlayerAttr = apc.getAudioAttributes();
        }

        @Override
        public String eventToString() {
            return new String("new player piid:" + this.mPlayerIId + " uid/pid:" + this.mClientUid + "/" + this.mClientPid + " type:" + AudioPlaybackConfiguration.toLogFriendlyPlayerType(this.mPlayerType) + " attr:" + this.mPlayerAttr);
        }
    }

    private static final class PlayerOpPlayAudioEvent
    extends AudioEventLogger.Event {
        final int mPlayerIId;
        final boolean mHasOp;
        final int mUid;

        PlayerOpPlayAudioEvent(int piid, boolean hasOp, int uid) {
            this.mPlayerIId = piid;
            this.mHasOp = hasOp;
            this.mUid = uid;
        }

        @Override
        public String eventToString() {
            return "player piid:" + this.mPlayerIId + " has OP_PLAY_AUDIO:" + this.mHasOp + " in uid:" + this.mUid;
        }
    }

    private static final class PlayerEvent
    extends AudioEventLogger.Event {
        final int mPlayerIId;
        final int mState;

        PlayerEvent(int piid, int state) {
            this.mPlayerIId = piid;
            this.mState = state;
        }

        @Override
        public String eventToString() {
            return "player piid:" + this.mPlayerIId + " state:" + AudioPlaybackConfiguration.toLogFriendlyPlayerState(this.mState);
        }
    }

    private static final class DuckingManager {
        private final HashMap<Integer, DuckedApp> mDuckers = new HashMap();

        private DuckingManager() {
        }

        synchronized void duckUid(int uid, ArrayList<AudioPlaybackConfiguration> apcsToDuck) {
            if (!this.mDuckers.containsKey(uid)) {
                this.mDuckers.put(uid, new DuckedApp(uid));
            }
            DuckedApp da = this.mDuckers.get(uid);
            for (AudioPlaybackConfiguration apc : apcsToDuck) {
                da.addDuck(apc, false);
            }
        }

        synchronized void unduckUid(int uid, HashMap<Integer, AudioPlaybackConfiguration> players) {
            DuckedApp da = this.mDuckers.remove(uid);
            if (da == null) {
                return;
            }
            da.removeUnduckAll(players);
        }

        synchronized void checkDuck(AudioPlaybackConfiguration apc) {
            DuckedApp da = this.mDuckers.get(apc.getClientUid());
            if (da == null) {
                return;
            }
            da.addDuck(apc, true);
        }

        synchronized void dump(PrintWriter pw) {
            for (DuckedApp da : this.mDuckers.values()) {
                da.dump(pw);
            }
        }

        synchronized void removeReleased(AudioPlaybackConfiguration apc) {
            int uid = apc.getClientUid();
            DuckedApp da = this.mDuckers.get(uid);
            if (da == null) {
                return;
            }
            da.removeReleased(apc);
        }

        private static final class DuckedApp {
            private final int mUid;
            private final ArrayList<Integer> mDuckedPlayers = new ArrayList();

            DuckedApp(int uid) {
                this.mUid = uid;
            }

            void dump(PrintWriter pw) {
                pw.print("\t uid:" + this.mUid + " piids:");
                for (int piid : this.mDuckedPlayers) {
                    pw.print(" " + piid);
                }
                pw.println("");
            }

            void addDuck(AudioPlaybackConfiguration apc, boolean skipRamp) {
                int piid = new Integer(apc.getPlayerInterfaceId());
                if (this.mDuckedPlayers.contains(piid)) {
                    return;
                }
                try {
                    sEventLogger.log(new DuckEvent(apc, skipRamp).printLog(PlaybackActivityMonitor.TAG));
                    apc.getPlayerProxy().applyVolumeShaper(DUCK_VSHAPE, skipRamp ? PLAY_SKIP_RAMP : PLAY_CREATE_IF_NEEDED);
                    this.mDuckedPlayers.add(piid);
                }
                catch (Exception e) {
                    Log.e(PlaybackActivityMonitor.TAG, "Error ducking player piid:" + piid + " uid:" + this.mUid, e);
                }
            }

            void removeUnduckAll(HashMap<Integer, AudioPlaybackConfiguration> players) {
                for (int piid : this.mDuckedPlayers) {
                    AudioPlaybackConfiguration apc = players.get(piid);
                    if (apc == null) continue;
                    try {
                        sEventLogger.log(new AudioEventLogger.StringEvent("unducking piid:" + piid).printLog(PlaybackActivityMonitor.TAG));
                        apc.getPlayerProxy().applyVolumeShaper(DUCK_ID, VolumeShaper.Operation.REVERSE);
                    }
                    catch (Exception e) {
                        Log.e(PlaybackActivityMonitor.TAG, "Error unducking player piid:" + piid + " uid:" + this.mUid, e);
                    }
                }
                this.mDuckedPlayers.clear();
            }

            void removeReleased(AudioPlaybackConfiguration apc) {
                this.mDuckedPlayers.remove(new Integer(apc.getPlayerInterfaceId()));
            }
        }
    }

    private static final class PlayMonitorClient
    implements IBinder.DeathRecipient {
        static PlaybackActivityMonitor sListenerDeathMonitor;
        final IPlaybackConfigDispatcher mDispatcherCb;
        final boolean mIsPrivileged;
        int mErrorCount = 0;
        static final int MAX_ERRORS = 5;

        PlayMonitorClient(IPlaybackConfigDispatcher pcdb, boolean isPrivileged) {
            this.mDispatcherCb = pcdb;
            this.mIsPrivileged = isPrivileged;
        }

        @Override
        public void binderDied() {
            Log.w(PlaybackActivityMonitor.TAG, "client died");
            sListenerDeathMonitor.unregisterPlaybackCallback(this.mDispatcherCb);
        }

        boolean init() {
            try {
                this.mDispatcherCb.asBinder().linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(PlaybackActivityMonitor.TAG, "Could not link to client death", e);
                return false;
            }
        }

        void release() {
            this.mDispatcherCb.asBinder().unlinkToDeath(this, 0);
        }
    }
}

