/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioFormat;
import android.media.AudioRecordingConfiguration;
import android.media.AudioSystem;
import android.media.IRecordingConfigDispatcher;
import android.media.MediaRecorder;
import android.media.audiofx.AudioEffect;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.audio.AudioEventLogger;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class RecordingActivityMonitor
implements AudioSystem.AudioRecordingCallback {
    public static final String TAG = "AudioService.RecordingActivityMonitor";
    private ArrayList<RecMonitorClient> mClients = new ArrayList();
    private boolean mHasPublicClients = false;
    private List<RecordingState> mRecordStates = new ArrayList<RecordingState>();
    private final PackageManager mPackMan;
    private static final AudioEventLogger sEventLogger = new AudioEventLogger(50, "recording activity received by AudioService");

    RecordingActivityMonitor(Context ctxt) {
        RecMonitorClient.sMonitor = this;
        RecorderDeathHandler.sMonitor = this;
        this.mPackMan = ctxt.getPackageManager();
    }

    @Override
    public void onRecordingConfigurationChanged(int event, int riid, int uid, int session, int source, int portId, boolean silenced, int[] recordingInfo, AudioEffect.Descriptor[] clientEffects, AudioEffect.Descriptor[] effects, int activeSource, String packName) {
        AudioRecordingConfiguration config = this.createRecordingConfiguration(uid, session, source, recordingInfo, portId, silenced, activeSource, clientEffects, effects);
        if (MediaRecorder.isSystemOnlyAudioSource(source)) {
            sEventLogger.log(new RecordingEvent(event, riid, config).printLog(TAG));
            return;
        }
        this.dispatchCallbacks(this.updateSnapshot(event, riid, config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trackRecorder(IBinder recorder) {
        if (recorder == null) {
            Log.e(TAG, "trackRecorder called with null token");
            return -1;
        }
        int newRiid = AudioSystem.newAudioRecorderId();
        RecorderDeathHandler handler = new RecorderDeathHandler(newRiid, recorder);
        if (!handler.init()) {
            return -1;
        }
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            this.mRecordStates.add(new RecordingState(newRiid, handler));
        }
        return newRiid;
    }

    public void recorderEvent(int riid, int event) {
        int configEvent;
        int n = event == 0 ? 0 : (configEvent = event == 1 ? 1 : -1);
        if (riid == -1 || configEvent == -1) {
            sEventLogger.log(new RecordingEvent(event, riid, null).printLog(TAG));
            return;
        }
        this.dispatchCallbacks(this.updateSnapshot(configEvent, riid, null));
    }

    public void releaseRecorder(int riid) {
        this.dispatchCallbacks(this.updateSnapshot(3, riid, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCallbacks(List<AudioRecordingConfiguration> configs) {
        if (configs == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            ArrayList<AudioRecordingConfiguration> configsPublic = this.mHasPublicClients ? RecordingActivityMonitor.anonymizeForPublicConsumption(configs) : new ArrayList<AudioRecordingConfiguration>();
            for (RecMonitorClient rmc : this.mClients) {
                try {
                    if (rmc.mIsPrivileged) {
                        rmc.mDispatcherCb.dispatchRecordingConfigChange(configs);
                        continue;
                    }
                    rmc.mDispatcherCb.dispatchRecordingConfigChange(configsPublic);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Could not call dispatchRecordingConfigChange() on client", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(PrintWriter pw) {
        pw.println("\nRecordActivityMonitor dump time: " + DateFormat.getTimeInstance().format(new Date()));
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            for (RecordingState state : this.mRecordStates) {
                state.dump(pw);
            }
        }
        pw.println("\n");
        sEventLogger.dump(pw);
    }

    private static ArrayList<AudioRecordingConfiguration> anonymizeForPublicConsumption(List<AudioRecordingConfiguration> sysConfigs) {
        ArrayList<AudioRecordingConfiguration> publicConfigs = new ArrayList<AudioRecordingConfiguration>();
        for (AudioRecordingConfiguration config : sysConfigs) {
            publicConfigs.add(AudioRecordingConfiguration.anonymizedCopy(config));
        }
        return publicConfigs;
    }

    void initMonitor() {
        AudioSystem.setRecordingCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAudioServerDied() {
        List<AudioRecordingConfiguration> configs = null;
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            boolean configChanged = false;
            Iterator<RecordingState> it = this.mRecordStates.iterator();
            while (it.hasNext()) {
                RecordingState state = it.next();
                if (state.hasDeathHandler()) continue;
                if (state.isActiveConfiguration()) {
                    configChanged = true;
                    sEventLogger.log(new RecordingEvent(3, state.getRiid(), state.getConfig()));
                }
                it.remove();
            }
            if (configChanged) {
                configs = this.getActiveRecordingConfigurations(true);
            }
        }
        this.dispatchCallbacks(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRecordingCallback(IRecordingConfigDispatcher rcdb, boolean isPrivileged) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            RecMonitorClient rmc = new RecMonitorClient(rcdb, isPrivileged);
            if (rmc.init()) {
                if (!isPrivileged) {
                    this.mHasPublicClients = true;
                }
                this.mClients.add(rmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            Iterator<RecMonitorClient> clientIterator = this.mClients.iterator();
            boolean hasPublicClients = false;
            while (clientIterator.hasNext()) {
                RecMonitorClient rmc = clientIterator.next();
                if (rcdb.equals(rmc.mDispatcherCb)) {
                    rmc.release();
                    clientIterator.remove();
                    continue;
                }
                if (rmc.mIsPrivileged) continue;
                hasPublicClients = true;
            }
            this.mHasPublicClients = hasPublicClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioRecordingConfiguration> getActiveRecordingConfigurations(boolean isPrivileged) {
        ArrayList<AudioRecordingConfiguration> configs = new ArrayList<AudioRecordingConfiguration>();
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            for (RecordingState state : this.mRecordStates) {
                if (!state.isActiveConfiguration()) continue;
                configs.add(state.getConfig());
            }
        }
        if (!isPrivileged) {
            configs = RecordingActivityMonitor.anonymizeForPublicConsumption(configs);
        }
        return configs;
    }

    private AudioRecordingConfiguration createRecordingConfiguration(int uid, int session, int source, int[] recordingInfo, int portId, boolean silenced, int activeSource, AudioEffect.Descriptor[] clientEffects, AudioEffect.Descriptor[] effects) {
        AudioFormat clientFormat = new AudioFormat.Builder().setEncoding(recordingInfo[0]).setChannelMask(recordingInfo[1]).setSampleRate(recordingInfo[2]).build();
        AudioFormat deviceFormat = new AudioFormat.Builder().setEncoding(recordingInfo[3]).setChannelMask(recordingInfo[4]).setSampleRate(recordingInfo[5]).build();
        int patchHandle = recordingInfo[6];
        String[] packages = this.mPackMan.getPackagesForUid(uid);
        String packageName = packages != null && packages.length > 0 ? packages[0] : "";
        return new AudioRecordingConfiguration(uid, session, source, clientFormat, deviceFormat, patchHandle, packageName, portId, silenced, activeSource, clientEffects, effects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioRecordingConfiguration> updateSnapshot(int event, int riid, AudioRecordingConfiguration config) {
        List<AudioRecordingConfiguration> configs = null;
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            boolean configChanged;
            int stateIndex = -1;
            if (riid != -1) {
                stateIndex = this.findStateByRiid(riid);
            } else if (config != null) {
                stateIndex = this.findStateByPortId(config.getClientPortId());
            }
            if (stateIndex == -1) {
                if (event == 0 && config != null) {
                    this.mRecordStates.add(new RecordingState(config));
                    stateIndex = this.mRecordStates.size() - 1;
                } else {
                    if (config == null) {
                        Log.e(TAG, String.format("Unexpected event %d for riid %d", event, riid));
                    }
                    return configs;
                }
            }
            RecordingState state = this.mRecordStates.get(stateIndex);
            switch (event) {
                case 0: {
                    configChanged = state.setActive(true);
                    if (config == null) break;
                    configChanged = state.setConfig(config) || configChanged;
                    break;
                }
                case 2: {
                    configChanged = state.setConfig(config);
                    break;
                }
                case 1: {
                    configChanged = state.setActive(false);
                    if (state.hasDeathHandler()) break;
                    this.mRecordStates.remove(stateIndex);
                    break;
                }
                case 3: {
                    configChanged = state.isActiveConfiguration();
                    this.mRecordStates.remove(stateIndex);
                    break;
                }
                default: {
                    Log.e(TAG, String.format("Unknown event %d for riid %d / portid %d", event, riid, state.getPortId()));
                    configChanged = false;
                }
            }
            if (configChanged) {
                sEventLogger.log(new RecordingEvent(event, riid, state.getConfig()));
                configs = this.getActiveRecordingConfigurations(true);
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findStateByRiid(int riid) {
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            for (int i = 0; i < this.mRecordStates.size(); ++i) {
                if (this.mRecordStates.get(i).getRiid() != riid) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findStateByPortId(int portId) {
        List<RecordingState> list = this.mRecordStates;
        synchronized (list) {
            for (int i = 0; i < this.mRecordStates.size(); ++i) {
                if (this.mRecordStates.get(i).hasDeathHandler() || this.mRecordStates.get(i).getPortId() != portId) continue;
                return i;
            }
        }
        return -1;
    }

    private static final class RecordingEvent
    extends AudioEventLogger.Event {
        private final int mRecEvent;
        private final int mRIId;
        private final int mClientUid;
        private final int mSession;
        private final int mSource;
        private final String mPackName;

        RecordingEvent(int event, int riid, AudioRecordingConfiguration config) {
            this.mRecEvent = event;
            this.mRIId = riid;
            if (config != null) {
                this.mClientUid = config.getClientUid();
                this.mSession = config.getClientAudioSessionId();
                this.mSource = config.getClientAudioSource();
                this.mPackName = config.getClientPackageName();
            } else {
                this.mClientUid = -1;
                this.mSession = -1;
                this.mSource = -1;
                this.mPackName = null;
            }
        }

        private static String recordEventToString(int recEvent) {
            switch (recEvent) {
                case 0: {
                    return "start";
                }
                case 2: {
                    return "update";
                }
                case 1: {
                    return "stop";
                }
                case 3: {
                    return "release";
                }
            }
            return "unknown (" + recEvent + ")";
        }

        @Override
        public String eventToString() {
            return "rec " + RecordingEvent.recordEventToString(this.mRecEvent) + " riid:" + this.mRIId + " uid:" + this.mClientUid + " session:" + this.mSession + " src:" + MediaRecorder.toLogFriendlyAudioSource(this.mSource) + (this.mPackName == null ? "" : " pack:" + this.mPackName);
        }
    }

    private static final class RecorderDeathHandler
    implements IBinder.DeathRecipient {
        static RecordingActivityMonitor sMonitor;
        final int mRiid;
        private final IBinder mRecorderToken;

        RecorderDeathHandler(int riid, IBinder recorderToken) {
            this.mRiid = riid;
            this.mRecorderToken = recorderToken;
        }

        @Override
        public void binderDied() {
            sMonitor.releaseRecorder(this.mRiid);
        }

        boolean init() {
            try {
                this.mRecorderToken.linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(RecordingActivityMonitor.TAG, "Could not link to recorder death", e);
                return false;
            }
        }
    }

    private static final class RecMonitorClient
    implements IBinder.DeathRecipient {
        static RecordingActivityMonitor sMonitor;
        final IRecordingConfigDispatcher mDispatcherCb;
        final boolean mIsPrivileged;

        RecMonitorClient(IRecordingConfigDispatcher rcdb, boolean isPrivileged) {
            this.mDispatcherCb = rcdb;
            this.mIsPrivileged = isPrivileged;
        }

        @Override
        public void binderDied() {
            Log.w(RecordingActivityMonitor.TAG, "client died");
            sMonitor.unregisterRecordingCallback(this.mDispatcherCb);
        }

        boolean init() {
            try {
                this.mDispatcherCb.asBinder().linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(RecordingActivityMonitor.TAG, "Could not link to client death", e);
                return false;
            }
        }

        void release() {
            this.mDispatcherCb.asBinder().unlinkToDeath(this, 0);
        }
    }

    static final class RecordingState {
        private final int mRiid;
        private final RecorderDeathHandler mDeathHandler;
        private boolean mIsActive;
        private AudioRecordingConfiguration mConfig;

        RecordingState(int riid, RecorderDeathHandler handler) {
            this.mRiid = riid;
            this.mDeathHandler = handler;
        }

        RecordingState(AudioRecordingConfiguration config) {
            this.mRiid = -1;
            this.mDeathHandler = null;
            this.mConfig = config;
        }

        int getRiid() {
            return this.mRiid;
        }

        int getPortId() {
            return this.mConfig != null ? this.mConfig.getClientPortId() : -1;
        }

        AudioRecordingConfiguration getConfig() {
            return this.mConfig;
        }

        boolean hasDeathHandler() {
            return this.mDeathHandler != null;
        }

        boolean isActiveConfiguration() {
            return this.mIsActive && this.mConfig != null;
        }

        boolean setActive(boolean active) {
            if (this.mIsActive == active) {
                return false;
            }
            this.mIsActive = active;
            return this.mConfig != null;
        }

        boolean setConfig(AudioRecordingConfiguration config) {
            if (config.equals(this.mConfig)) {
                return false;
            }
            this.mConfig = config;
            return this.mIsActive;
        }

        void dump(PrintWriter pw) {
            pw.println("riid " + this.mRiid + "; active? " + this.mIsActive);
            if (this.mConfig != null) {
                this.mConfig.dump(pw);
            } else {
                pw.println("  no config");
            }
        }
    }
}

