/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.media.AudioSystem;
import android.os.Handler;
import android.util.Log;
import android.view.WindowManager;

class RotationHelper {
    private static final String TAG = "AudioService.RotationHelper";
    private static AudioDisplayListener sDisplayListener;
    private static final Object sRotationLock;
    private static int sDeviceRotation;
    private static Context sContext;
    private static Handler sHandler;

    RotationHelper() {
    }

    static void init(Context context, Handler handler) {
        if (context == null) {
            throw new IllegalArgumentException("Invalid null context");
        }
        sContext = context;
        sHandler = handler;
        sDisplayListener = new AudioDisplayListener();
        RotationHelper.enable();
    }

    static void enable() {
        ((DisplayManager)sContext.getSystemService("display")).registerDisplayListener(sDisplayListener, sHandler);
        RotationHelper.updateOrientation();
    }

    static void disable() {
        ((DisplayManager)sContext.getSystemService("display")).unregisterDisplayListener(sDisplayListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateOrientation() {
        int newRotation = ((WindowManager)sContext.getSystemService("window")).getDefaultDisplay().getRotation();
        Object object = sRotationLock;
        synchronized (object) {
            if (newRotation != sDeviceRotation) {
                sDeviceRotation = newRotation;
                RotationHelper.publishRotation(sDeviceRotation);
            }
        }
    }

    private static void publishRotation(int rotation) {
        Log.v(TAG, "publishing device rotation =" + rotation + " (x90deg)");
        switch (rotation) {
            case 0: {
                AudioSystem.setParameters("rotation=0");
                break;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                break;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                break;
            }
            case 3: {
                AudioSystem.setParameters("rotation=270");
                break;
            }
            default: {
                Log.e(TAG, "Unknown device rotation");
            }
        }
    }

    static {
        sRotationLock = new Object();
        sDeviceRotation = 0;
    }

    static final class AudioDisplayListener
    implements DisplayManager.DisplayListener {
        AudioDisplayListener() {
        }

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            RotationHelper.updateOrientation();
        }
    }
}

