/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.content.AutofillOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.service.autofill.FillEventHistory;
import android.service.autofill.UserData;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.LocalLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillManagerInternal;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.infra.GlobalWhitelistState;
import com.android.internal.infra.WhitelistHelper;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.SyncResultReceiver;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.autofill.AutofillManagerServiceImpl;
import com.android.server.autofill.AutofillManagerServiceShellCommand;
import com.android.server.autofill.FieldClassificationStrategy;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.AutoFillUI;
import com.android.server.infra.AbstractMasterSystemService;
import com.android.server.infra.FrameworkResourcesServiceNameResolver;
import com.android.server.infra.SecureSettingsServiceNameResolver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class AutofillManagerService
extends AbstractMasterSystemService<AutofillManagerService, AutofillManagerServiceImpl> {
    private static final String TAG = "AutofillManagerService";
    private static final Object sLock = AutofillManagerService.class;
    static final String RECEIVER_BUNDLE_EXTRA_SESSIONS = "sessions";
    private static final char COMPAT_PACKAGE_DELIMITER = ':';
    private static final char COMPAT_PACKAGE_URL_IDS_DELIMITER = ',';
    private static final char COMPAT_PACKAGE_URL_IDS_BLOCK_BEGIN = '[';
    private static final char COMPAT_PACKAGE_URL_IDS_BLOCK_END = ']';
    private static final int DEFAULT_AUGMENTED_AUTOFILL_REQUEST_TIMEOUT_MILLIS = 5000;
    @GuardedBy(value={"sLock"})
    private static int sPartitionMaxCount = 10;
    @GuardedBy(value={"sLock"})
    private static int sVisibleDatasetsMaxCount = 0;
    final FrameworkResourcesServiceNameResolver mAugmentedAutofillResolver;
    private final AutoFillUI mUi;
    private final LocalLog mRequestsHistory = new LocalLog(20);
    private final LocalLog mUiLatencyHistory = new LocalLog(20);
    private final LocalLog mWtfHistory = new LocalLog(50);
    private final AutofillCompatState mAutofillCompatState = new AutofillCompatState();
    private final LocalService mLocalService = new LocalService();
    private final ActivityManagerInternal mAm;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(intent.getAction())) {
                if (Helper.sDebug) {
                    Slog.d(AutofillManagerService.TAG, "Close system dialogs");
                }
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    AutofillManagerService.this.visitServicesLocked(s -> s.destroyFinishedSessionsLocked());
                }
                AutofillManagerService.this.mUi.hideAll(null);
            }
        }
    };
    @GuardedBy(value={"mLock"})
    private int mSupportedSmartSuggestionModes;
    @GuardedBy(value={"mLock"})
    int mAugmentedServiceIdleUnbindTimeoutMs;
    @GuardedBy(value={"mLock"})
    int mAugmentedServiceRequestTimeoutMs;
    final AugmentedAutofillState mAugmentedAutofillState = new AugmentedAutofillState();

    public AutofillManagerService(Context context) {
        super(context, new SecureSettingsServiceNameResolver(context, "autofill_service"), "no_autofill");
        this.mUi = new AutoFillUI(ActivityThread.currentActivityThread().getSystemUiContext());
        this.mAm = LocalServices.getService(ActivityManagerInternal.class);
        DeviceConfig.addOnPropertiesChangedListener("autofill", ActivityThread.currentApplication().getMainExecutor(), properties -> this.onDeviceConfigChange(properties.getKeyset()));
        this.setLogLevelFromSettings();
        this.setMaxPartitionsFromSettings();
        this.setMaxVisibleDatasetsFromSettings();
        this.setDeviceConfigProperties();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        context.registerReceiver(this.mBroadcastReceiver, filter, null, FgThread.getHandler());
        this.mAugmentedAutofillResolver = new FrameworkResourcesServiceNameResolver(this.getContext(), 17039699);
        this.mAugmentedAutofillResolver.setOnTemporaryServiceNameChangedCallback((u, s, t) -> this.onAugmentedServiceNameChanged(u, s, t));
        if (this.mSupportedSmartSuggestionModes != 0) {
            UserManager um = this.getContext().getSystemService(UserManager.class);
            List<UserInfo> users = um.getUsers();
            for (int i = 0; i < users.size(); ++i) {
                int userId = users.get((int)i).id;
                this.getServiceForUserLocked(userId);
                this.mAugmentedAutofillState.setServiceInfo(userId, this.mAugmentedAutofillResolver.getServiceName(userId), this.mAugmentedAutofillResolver.isTemporary(userId));
            }
        }
    }

    @Override
    protected String getServiceSettingsProperty() {
        return "autofill_service";
    }

    @Override
    protected void registerForExtraSettingsChanges(ContentResolver resolver, ContentObserver observer) {
        resolver.registerContentObserver(Settings.Global.getUriFor("autofill_compat_mode_allowed_packages"), false, observer, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("autofill_logging_level"), false, observer, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("autofill_max_partitions_size"), false, observer, -1);
        resolver.registerContentObserver(Settings.Global.getUriFor("autofill_max_visible_datasets"), false, observer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSettingsChanged(int userId, String property) {
        switch (property) {
            case "autofill_logging_level": {
                this.setLogLevelFromSettings();
                break;
            }
            case "autofill_max_partitions_size": {
                this.setMaxPartitionsFromSettings();
                break;
            }
            case "autofill_max_visible_datasets": {
                this.setMaxVisibleDatasetsFromSettings();
                break;
            }
            default: {
                Slog.w(TAG, "Unexpected property (" + property + "); updating cache instead");
            }
            case "autofill_compat_mode_allowed_packages": {
                Object object = this.mLock;
                synchronized (object) {
                    this.updateCachedServiceLocked(userId);
                    break;
                }
            }
        }
    }

    private void onDeviceConfigChange(Set<String> keys) {
        Iterator<String> iterator = keys.iterator();
        block8: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "smart_suggestion_supported_modes": 
                case "augmented_service_idle_unbind_timeout": 
                case "augmented_service_request_timeout": {
                    this.setDeviceConfigProperties();
                    continue block8;
                }
            }
            Slog.i(this.mTag, "Ignoring change on " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAugmentedServiceNameChanged(int userId, String serviceName, boolean isTemporary) {
        this.mAugmentedAutofillState.setServiceInfo(userId, serviceName, isTemporary);
        Object object = this.mLock;
        synchronized (object) {
            ((AutofillManagerServiceImpl)this.getServiceForUserLocked(userId)).updateRemoteAugmentedAutofillService();
        }
    }

    @Override
    protected AutofillManagerServiceImpl newServiceLocked(int resolvedUserId, boolean disabled) {
        return new AutofillManagerServiceImpl(this, this.mLock, this.mUiLatencyHistory, this.mWtfHistory, resolvedUserId, this.mUi, this.mAutofillCompatState, disabled);
    }

    @Override
    protected void onServiceRemoved(AutofillManagerServiceImpl service, int userId) {
        service.destroyLocked();
        this.mAutofillCompatState.removeCompatibilityModeRequests(userId);
    }

    @Override
    protected void onServiceEnabledLocked(AutofillManagerServiceImpl service, int userId) {
        this.addCompatibilityModeRequestsLocked(service, userId);
    }

    @Override
    protected void enforceCallingPermissionForManagement() {
        this.getContext().enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
    }

    @Override
    public void onStart() {
        this.publishBinderService("autofill", new AutoFillManagerServiceStub());
        this.publishLocalService(AutofillManagerInternal.class, this.mLocalService);
    }

    @Override
    public void onSwitchUser(int userHandle) {
        if (Helper.sDebug) {
            Slog.d(TAG, "Hiding UI when user switched");
        }
        this.mUi.hideAll(null);
    }

    int getSupportedSmartSuggestionModesLocked() {
        return this.mSupportedSmartSuggestionModes;
    }

    void logRequestLocked(String historyItem) {
        this.mRequestsHistory.log(historyItem);
    }

    boolean isInstantServiceAllowed() {
        return this.mAllowInstantService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySessions(int userId, IResultReceiver receiver) {
        Slog.i(TAG, "destroySessions() for userId " + userId);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.destroySessionsLocked();
                }
            } else {
                this.visitServicesLocked(s -> s.destroySessionsLocked());
            }
        }
        try {
            receiver.send(0, new Bundle());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listSessions(int userId, IResultReceiver receiver) {
        Slog.i(TAG, "listSessions() for userId " + userId);
        this.enforceCallingPermissionForManagement();
        Bundle resultData = new Bundle();
        ArrayList<String> sessions = new ArrayList<String>();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.listSessionsLocked(sessions);
                }
            } else {
                this.visitServicesLocked(s -> s.listSessionsLocked(sessions));
            }
        }
        resultData.putStringArrayList(RECEIVER_BUNDLE_EXTRA_SESSIONS, sessions);
        try {
            receiver.send(0, resultData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Slog.i(TAG, "reset()");
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            this.visitServicesLocked(s -> s.destroyLocked());
            this.clearCacheLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLogLevel(int level) {
        Slog.i(TAG, "setLogLevel(): " + level);
        this.enforceCallingPermissionForManagement();
        long token = Binder.clearCallingIdentity();
        try {
            Settings.Global.putInt(this.getContext().getContentResolver(), "autofill_logging_level", level);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogLevelFromSettings() {
        int level = Settings.Global.getInt(this.getContext().getContentResolver(), "autofill_logging_level", AutofillManager.DEFAULT_LOGGING_LEVEL);
        boolean debug = false;
        boolean verbose = false;
        if (level != 0) {
            if (level == 4) {
                verbose = true;
                debug = true;
            } else if (level == 2) {
                debug = true;
            } else {
                Slog.w(TAG, "setLogLevelFromSettings(): invalid level: " + level);
            }
        }
        if (debug || Helper.sDebug) {
            Slog.d(TAG, "setLogLevelFromSettings(): level=" + level + ", debug=" + debug + ", verbose=" + verbose);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.setLoggingLevelsLocked(debug, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLogLevel() {
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                return 4;
            }
            if (Helper.sDebug) {
                return 2;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxPartitions() {
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            return sPartitionMaxCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxPartitions(int max) {
        Slog.i(TAG, "setMaxPartitions(): " + max);
        this.enforceCallingPermissionForManagement();
        long token = Binder.clearCallingIdentity();
        try {
            Settings.Global.putInt(this.getContext().getContentResolver(), "autofill_max_partitions_size", max);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxPartitionsFromSettings() {
        int max = Settings.Global.getInt(this.getContext().getContentResolver(), "autofill_max_partitions_size", 10);
        if (Helper.sDebug) {
            Slog.d(TAG, "setMaxPartitionsFromSettings(): " + max);
        }
        Object object = sLock;
        synchronized (object) {
            sPartitionMaxCount = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxVisibleDatasets() {
        this.enforceCallingPermissionForManagement();
        Object object = sLock;
        synchronized (object) {
            return sVisibleDatasetsMaxCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxVisibleDatasets(int max) {
        Slog.i(TAG, "setMaxVisibleDatasets(): " + max);
        this.enforceCallingPermissionForManagement();
        long token = Binder.clearCallingIdentity();
        try {
            Settings.Global.putInt(this.getContext().getContentResolver(), "autofill_max_visible_datasets", max);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxVisibleDatasetsFromSettings() {
        int max = Settings.Global.getInt(this.getContext().getContentResolver(), "autofill_max_visible_datasets", 0);
        if (Helper.sDebug) {
            Slog.d(TAG, "setMaxVisibleDatasetsFromSettings(): " + max);
        }
        Object object = sLock;
        synchronized (object) {
            sVisibleDatasetsMaxCount = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeviceConfigProperties() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAugmentedServiceIdleUnbindTimeoutMs = DeviceConfig.getInt("autofill", "augmented_service_idle_unbind_timeout", 0);
            this.mAugmentedServiceRequestTimeoutMs = DeviceConfig.getInt("autofill", "augmented_service_request_timeout", 5000);
            this.mSupportedSmartSuggestionModes = DeviceConfig.getInt("autofill", "smart_suggestion_supported_modes", 1);
            if (this.verbose) {
                Slog.v(this.mTag, "setDeviceConfigProperties(): augmentedIdleTimeout=" + this.mAugmentedServiceIdleUnbindTimeoutMs + ", augmentedRequestTimeout=" + this.mAugmentedServiceRequestTimeoutMs + ", smartSuggestionMode=" + AutofillManager.getSmartSuggestionModeToString(this.mSupportedSmartSuggestionModes));
            }
        }
    }

    void calculateScore(String algorithmName, String value1, String value2, RemoteCallback callback) {
        this.enforceCallingPermissionForManagement();
        FieldClassificationStrategy strategy = new FieldClassificationStrategy(this.getContext(), -2);
        strategy.calculateScores(callback, Arrays.asList(AutofillValue.forText(value1)), new String[]{value2}, new String[]{null}, algorithmName, null, null, null);
    }

    Boolean getFullScreenMode() {
        this.enforceCallingPermissionForManagement();
        return Helper.sFullScreenMode;
    }

    void setFullScreenMode(Boolean mode) {
        this.enforceCallingPermissionForManagement();
        Helper.sFullScreenMode = mode;
    }

    void setTemporaryAugmentedAutofillService(int userId, String serviceName, int durationMs) {
        Slog.i(this.mTag, "setTemporaryAugmentedAutofillService(" + userId + ") to " + serviceName + " for " + durationMs + "ms");
        this.enforceCallingPermissionForManagement();
        Preconditions.checkNotNull(serviceName);
        if (durationMs > 120000) {
            throw new IllegalArgumentException("Max duration is 120000 (called with " + durationMs + ")");
        }
        this.mAugmentedAutofillResolver.setTemporaryService(userId, serviceName, durationMs);
    }

    void resetTemporaryAugmentedAutofillService(int userId) {
        this.enforceCallingPermissionForManagement();
        this.mAugmentedAutofillResolver.resetTemporaryService(userId);
    }

    boolean isDefaultAugmentedServiceEnabled(int userId) {
        this.enforceCallingPermissionForManagement();
        return this.mAugmentedAutofillResolver.isDefaultServiceEnabled(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDefaultAugmentedServiceEnabled(int userId, boolean enabled) {
        Slog.i(this.mTag, "setDefaultAugmentedServiceEnabled() for userId " + userId + ": " + enabled);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)this.getServiceForUserLocked(userId);
            if (service != null) {
                boolean changed = this.mAugmentedAutofillResolver.setDefaultServiceEnabled(userId, enabled);
                if (changed) {
                    service.updateRemoteAugmentedAutofillService();
                    return true;
                }
                if (this.debug) {
                    Slog.d(TAG, "setDefaultAugmentedServiceEnabled(): already " + enabled);
                }
            }
        }
        return false;
    }

    private void setLoggingLevelsLocked(boolean debug, boolean verbose) {
        Helper.sDebug = debug;
        android.view.autofill.Helper.sDebug = debug;
        this.debug = debug;
        Helper.sVerbose = verbose;
        android.view.autofill.Helper.sVerbose = verbose;
        this.verbose = verbose;
    }

    private void addCompatibilityModeRequestsLocked(AutofillManagerServiceImpl service, int userId) {
        this.mAutofillCompatState.reset(userId);
        ArrayMap<String, Long> compatPackages = service.getCompatibilityPackagesLocked();
        if (compatPackages == null || compatPackages.isEmpty()) {
            return;
        }
        Map<String, String[]> whiteListedPackages = this.getWhitelistedCompatModePackages();
        int compatPackageCount = compatPackages.size();
        for (int i = 0; i < compatPackageCount; ++i) {
            String packageName = compatPackages.keyAt(i);
            if (whiteListedPackages == null || !whiteListedPackages.containsKey(packageName)) {
                Slog.w(TAG, "Ignoring not whitelisted compat package " + packageName);
                continue;
            }
            Long maxVersionCode = compatPackages.valueAt(i);
            if (maxVersionCode == null) continue;
            this.mAutofillCompatState.addCompatibilityModeRequest(packageName, maxVersionCode, whiteListedPackages.get(packageName), userId);
        }
    }

    private String getWhitelistedCompatModePackagesFromSettings() {
        return Settings.Global.getString(this.getContext().getContentResolver(), "autofill_compat_mode_allowed_packages");
    }

    private Map<String, String[]> getWhitelistedCompatModePackages() {
        return AutofillManagerService.getWhitelistedCompatModePackages(this.getWhitelistedCompatModePackagesFromSettings());
    }

    private void send(IResultReceiver receiver, int value) {
        try {
            receiver.send(value, null);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error async reporting result to client: " + e);
        }
    }

    private void send(IResultReceiver receiver, Bundle value) {
        try {
            receiver.send(0, value);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error async reporting result to client: " + e);
        }
    }

    private void send(IResultReceiver receiver, String value) {
        this.send(receiver, SyncResultReceiver.bundleFor(value));
    }

    private void send(IResultReceiver receiver, String[] value) {
        this.send(receiver, SyncResultReceiver.bundleFor(value));
    }

    private void send(IResultReceiver receiver, Parcelable value) {
        this.send(receiver, SyncResultReceiver.bundleFor(value));
    }

    private void send(IResultReceiver receiver, boolean value) {
        this.send(receiver, value ? 1 : 0);
    }

    private void send(IResultReceiver receiver, int value1, int value2) {
        try {
            receiver.send(value1, SyncResultReceiver.bundleFor(value2));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error async reporting result to client: " + e);
        }
    }

    @VisibleForTesting
    static Map<String, String[]> getWhitelistedCompatModePackages(String setting) {
        if (TextUtils.isEmpty(setting)) {
            return null;
        }
        ArrayMap<String, String[]> compatPackages = new ArrayMap<String, String[]>();
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(':');
        splitter.setString(setting);
        while (splitter.hasNext()) {
            ArrayList<String> urlBarIds;
            String packageName;
            String packageBlock = splitter.next();
            int urlBlockIndex = packageBlock.indexOf(91);
            if (urlBlockIndex == -1) {
                packageName = packageBlock;
                urlBarIds = null;
            } else {
                if (packageBlock.charAt(packageBlock.length() - 1) != ']') {
                    Slog.w(TAG, "Ignoring entry '" + packageBlock + "' on '" + setting + "'because it does not end on '" + ']' + "'");
                    continue;
                }
                packageName = packageBlock.substring(0, urlBlockIndex);
                urlBarIds = new ArrayList<String>();
                String urlBarIdsBlock = packageBlock.substring(urlBlockIndex + 1, packageBlock.length() - 1);
                if (Helper.sVerbose) {
                    Slog.v(TAG, "pkg:" + packageName + ": block:" + packageBlock + ": urls:" + urlBarIds + ": block:" + urlBarIdsBlock + ":");
                }
                TextUtils.SimpleStringSplitter splitter2 = new TextUtils.SimpleStringSplitter(',');
                splitter2.setString(urlBarIdsBlock);
                while (splitter2.hasNext()) {
                    String urlBarId = splitter2.next();
                    urlBarIds.add(urlBarId);
                }
            }
            if (urlBarIds == null) {
                compatPackages.put(packageName, null);
                continue;
            }
            String[] urlBarIdsArray = new String[urlBarIds.size()];
            urlBarIds.toArray(urlBarIdsArray);
            compatPackages.put(packageName, urlBarIdsArray);
        }
        return compatPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPartitionMaxCount() {
        Object object = sLock;
        synchronized (object) {
            return sPartitionMaxCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVisibleDatasetsMaxCount() {
        Object object = sLock;
        synchronized (object) {
            return sVisibleDatasetsMaxCount;
        }
    }

    final class AutoFillManagerServiceStub
    extends IAutoFillManager.Stub {
        AutoFillManagerServiceStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addClient(IAutoFillManagerClient client, ComponentName componentName, int userId, IResultReceiver receiver) {
            int flags = 0;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                int enabledFlags = ((AutofillManagerServiceImpl)AutofillManagerService.this.getServiceForUserLocked(userId)).addClientLocked(client, componentName);
                if (enabledFlags != 0) {
                    flags |= enabledFlags;
                }
                if (Helper.sDebug) {
                    flags |= 2;
                }
                if (Helper.sVerbose) {
                    flags |= 4;
                }
            }
            AutofillManagerService.this.send(receiver, flags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeClient(IAutoFillManagerClient client, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.removeClientLocked(client);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "removeClient(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAuthenticationResult(Bundle data, int sessionId, int authenticationId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.getServiceForUserLocked(userId);
                service.setAuthenticationResultLocked(data, sessionId, authenticationId, AutoFillManagerServiceStub.getCallingUid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setHasCallback(int sessionId, int userId, boolean hasIt) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.getServiceForUserLocked(userId);
                service.setHasCallback(sessionId, AutoFillManagerServiceStub.getCallingUid(), hasIt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSession(IBinder activityToken, IBinder appCallback, AutofillId autofillId, Rect bounds, AutofillValue value, int userId, boolean hasCallback, int flags, ComponentName componentName, boolean compatMode, IResultReceiver receiver) {
            long result;
            activityToken = Preconditions.checkNotNull(activityToken, "activityToken");
            appCallback = Preconditions.checkNotNull(appCallback, "appCallback");
            autofillId = Preconditions.checkNotNull(autofillId, "autoFillId");
            componentName = Preconditions.checkNotNull(componentName, "componentName");
            String packageName = Preconditions.checkNotNull(componentName.getPackageName());
            Preconditions.checkArgument(userId == UserHandle.getUserId(AutoFillManagerServiceStub.getCallingUid()), "userId");
            try {
                AutofillManagerService.this.getContext().getPackageManager().getPackageInfoAsUser(packageName, 0, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(packageName + " is not a valid package", e);
            }
            int taskId = AutofillManagerService.this.mAm.getTaskIdForActivity(activityToken, false);
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.getServiceForUserLocked(userId);
                result = service.startSessionLocked(activityToken, taskId, AutoFillManagerServiceStub.getCallingUid(), appCallback, autofillId, bounds, value, hasCallback, componentName, compatMode, AutofillManagerService.this.mAllowInstantService, flags);
            }
            int sessionId = (int)result;
            int resultFlags = (int)(result >> 32);
            if (resultFlags != 0) {
                AutofillManagerService.this.send(receiver, sessionId, resultFlags);
            } else {
                AutofillManagerService.this.send(receiver, sessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getFillEventHistory(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            FillEventHistory fillEventHistory = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    fillEventHistory = service.getFillEventHistory(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getFillEventHistory(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, fillEventHistory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getUserData(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            UserData userData = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    userData = service.getUserData(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getUserData(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, userData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getUserDataId(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            UserData userData = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    userData = service.getUserData(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getUserDataId(): no service for " + userId);
                }
            }
            String userDataId = userData == null ? null : userData.getId();
            AutofillManagerService.this.send(receiver, userDataId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserData(UserData userData) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.setUserData(AutoFillManagerServiceStub.getCallingUid(), userData);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "setUserData(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void isFieldClassificationEnabled(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            boolean enabled = false;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    enabled = service.isFieldClassificationEnabled(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "isFieldClassificationEnabled(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getDefaultFieldClassificationAlgorithm(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            String algorithm = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    algorithm = service.getDefaultFieldClassificationAlgorithm(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getDefaultFcAlgorithm(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, algorithm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAugmentedAutofillWhitelist(List<String> packages, List<ComponentName> activities, IResultReceiver receiver) throws RemoteException {
            boolean ok;
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    ok = service.setAugmentedAutofillWhitelistLocked(packages, activities, AutoFillManagerServiceStub.getCallingUid());
                } else {
                    if (Helper.sVerbose) {
                        Slog.v(AutofillManagerService.TAG, "setAugmentedAutofillWhitelist(): no service for " + userId);
                    }
                    ok = false;
                }
            }
            AutofillManagerService.this.send(receiver, ok ? 0 : -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getAvailableFieldClassificationAlgorithms(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            String[] algorithms = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    algorithms = service.getAvailableFieldClassificationAlgorithms(AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getAvailableFcAlgorithms(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, algorithms);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getAutofillServiceComponentName(IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            ComponentName componentName = null;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    componentName = service.getServiceComponentName();
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getAutofillServiceComponentName(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, componentName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restoreSession(int sessionId, IBinder activityToken, IBinder appCallback, IResultReceiver receiver) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            activityToken = Preconditions.checkNotNull(activityToken, "activityToken");
            appCallback = Preconditions.checkNotNull(appCallback, "appCallback");
            boolean restored = false;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    restored = service.restoreSession(sessionId, AutoFillManagerServiceStub.getCallingUid(), activityToken, appCallback);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "restoreSession(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, restored);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateSession(int sessionId, AutofillId autoFillId, Rect bounds, AutofillValue value, int action, int flags, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.updateSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid(), autoFillId, bounds, value, action, flags);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "updateSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAutofillFailure(int sessionId, List<AutofillId> ids, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.setAutofillFailureLocked(sessionId, AutoFillManagerServiceStub.getCallingUid(), ids);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "setAutofillFailure(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSession(int sessionId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.finishSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "finishSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelSession(int sessionId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.cancelSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "cancelSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disableOwnedAutofillServices(int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.disableOwnedAutofillServicesLocked(Binder.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "cancelSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void isServiceSupported(int userId, IResultReceiver receiver) {
            boolean supported = false;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                supported = !AutofillManagerService.this.isDisabledLocked(userId);
            }
            AutofillManagerService.this.send(receiver, supported);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void isServiceEnabled(int userId, String packageName, IResultReceiver receiver) {
            boolean enabled = false;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    enabled = Objects.equals(packageName, service.getServicePackageName());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "isServiceEnabled(): no service for " + userId);
                }
            }
            AutofillManagerService.this.send(receiver, enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPendingSaveUi(int operation, IBinder token) {
            Preconditions.checkNotNull(token, "token");
            Preconditions.checkArgument(operation == 1 || operation == 2, "invalid operation: %d", operation);
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(UserHandle.getCallingUserId());
                if (service != null) {
                    service.onPendingSaveUi(operation, token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(AutofillManagerService.this.getContext(), AutofillManagerService.TAG, pw)) {
                return;
            }
            boolean showHistory = true;
            boolean uiOnly = false;
            if (args != null) {
                String[] stringArray = args;
                int n = stringArray.length;
                block16: for (int i = 0; i < n; ++i) {
                    String arg;
                    switch (arg = stringArray[i]) {
                        case "--no-history": {
                            showHistory = false;
                            continue block16;
                        }
                        case "--ui-only": {
                            uiOnly = true;
                            continue block16;
                        }
                        case "--help": {
                            pw.println("Usage: dumpsys autofill [--ui-only|--no-history]");
                            return;
                        }
                        default: {
                            Slog.w(AutofillManagerService.TAG, "Ignoring invalid dump arg: " + arg);
                        }
                    }
                }
            }
            if (uiOnly) {
                AutofillManagerService.this.mUi.dump(pw);
                return;
            }
            String prefix = "  ";
            boolean realDebug = Helper.sDebug;
            boolean realVerbose = Helper.sVerbose;
            try {
                Helper.sVerbose = true;
                Helper.sDebug = true;
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    pw.print("sDebug: ");
                    pw.print(realDebug);
                    pw.print(" sVerbose: ");
                    pw.println(realVerbose);
                    AutofillManagerService.this.dumpLocked("", pw);
                    AutofillManagerService.this.mAugmentedAutofillResolver.dumpShort(pw);
                    pw.println();
                    pw.print("Max partitions per session: ");
                    pw.println(sPartitionMaxCount);
                    pw.print("Max visible datasets: ");
                    pw.println(sVisibleDatasetsMaxCount);
                    if (Helper.sFullScreenMode != null) {
                        pw.print("Overridden full-screen mode: ");
                        pw.println(Helper.sFullScreenMode);
                    }
                    pw.println("User data constraints: ");
                    UserData.dumpConstraints("  ", pw);
                    AutofillManagerService.this.mUi.dump(pw);
                    pw.print("Autofill Compat State: ");
                    AutofillManagerService.this.mAutofillCompatState.dump("  ", pw);
                    pw.print("from settings: ");
                    pw.println(AutofillManagerService.this.getWhitelistedCompatModePackagesFromSettings());
                    if (AutofillManagerService.this.mSupportedSmartSuggestionModes != 0) {
                        pw.print("Smart Suggestion modes: ");
                        pw.println(AutofillManager.getSmartSuggestionModeToString(AutofillManagerService.this.mSupportedSmartSuggestionModes));
                    }
                    pw.print("Augmented Service Idle Unbind Timeout: ");
                    pw.println(AutofillManagerService.this.mAugmentedServiceIdleUnbindTimeoutMs);
                    pw.print("Augmented Service Request Timeout: ");
                    pw.println(AutofillManagerService.this.mAugmentedServiceRequestTimeoutMs);
                    if (showHistory) {
                        pw.println();
                        pw.println("Requests history:");
                        pw.println();
                        AutofillManagerService.this.mRequestsHistory.reverseDump(fd, pw, args);
                        pw.println();
                        pw.println("UI latency history:");
                        pw.println();
                        AutofillManagerService.this.mUiLatencyHistory.reverseDump(fd, pw, args);
                        pw.println();
                        pw.println("WTF history:");
                        pw.println();
                        AutofillManagerService.this.mWtfHistory.reverseDump(fd, pw, args);
                    }
                    pw.println("Augmented Autofill State: ");
                    AutofillManagerService.this.mAugmentedAutofillState.dump("  ", pw);
                }
            }
            finally {
                Helper.sDebug = realDebug;
                Helper.sVerbose = realVerbose;
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new AutofillManagerServiceShellCommand(AutofillManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }

    static final class AugmentedAutofillState
    extends GlobalWhitelistState {
        @GuardedBy(value={"mGlobalWhitelistStateLock"})
        private final SparseArray<String> mServicePackages = new SparseArray();
        @GuardedBy(value={"mGlobalWhitelistStateLock"})
        private final SparseBooleanArray mTemporaryServices = new SparseBooleanArray();

        AugmentedAutofillState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setServiceInfo(int userId, String serviceName, boolean isTemporary) {
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                if (isTemporary) {
                    this.mTemporaryServices.put(userId, true);
                } else {
                    this.mTemporaryServices.delete(userId);
                }
                if (serviceName != null) {
                    ComponentName componentName = ComponentName.unflattenFromString(serviceName);
                    if (componentName == null) {
                        Slog.w(AutofillManagerService.TAG, "setServiceInfo(): invalid name: " + serviceName);
                        this.mServicePackages.remove(userId);
                    } else {
                        this.mServicePackages.put(userId, componentName.getPackageName());
                    }
                } else {
                    this.mServicePackages.remove(userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void injectAugmentedAutofillInfo(AutofillOptions options, int userId, String packageName) {
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                if (this.mWhitelisterHelpers == null) {
                    return;
                }
                WhitelistHelper helper = (WhitelistHelper)this.mWhitelisterHelpers.get(userId);
                if (helper != null) {
                    options.augmentedAutofillEnabled = helper.isWhitelisted(packageName);
                    options.whitelistedActivitiesForAugmentedAutofill = helper.getWhitelistedComponents(packageName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWhitelisted(int userId, ComponentName componentName) {
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                String packageName;
                if (!super.isWhitelisted(userId, componentName)) {
                    return false;
                }
                if (Build.IS_USER && this.mTemporaryServices.get(userId) && !(packageName = componentName.getPackageName()).equals(this.mServicePackages.get(userId))) {
                    Slog.w(AutofillManagerService.TAG, "Ignoring package " + packageName + " for augmented autofill while using temporary service " + this.mServicePackages.get(userId));
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(String prefix, PrintWriter pw) {
            super.dump(prefix, pw);
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                if (this.mServicePackages.size() > 0) {
                    pw.print(prefix);
                    pw.print("Service packages: ");
                    pw.println(this.mServicePackages);
                }
                if (this.mTemporaryServices.size() > 0) {
                    pw.print(prefix);
                    pw.print("Temp services: ");
                    pw.println(this.mTemporaryServices);
                }
            }
        }
    }

    static final class AutofillCompatState {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private SparseArray<ArrayMap<String, PackageCompatState>> mUserSpecs;

        AutofillCompatState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCompatibilityModeRequested(String packageName, long versionCode, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs == null) {
                    return false;
                }
                ArrayMap<String, PackageCompatState> userSpec = this.mUserSpecs.get(userId);
                if (userSpec == null) {
                    return false;
                }
                PackageCompatState metadata = userSpec.get(packageName);
                if (metadata == null) {
                    return false;
                }
                return versionCode <= metadata.maxVersionCode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getUrlBarResourceIds(String packageName, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs == null) {
                    return null;
                }
                ArrayMap<String, PackageCompatState> userSpec = this.mUserSpecs.get(userId);
                if (userSpec == null) {
                    return null;
                }
                PackageCompatState metadata = userSpec.get(packageName);
                if (metadata == null) {
                    return null;
                }
                return metadata.urlBarResourceIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCompatibilityModeRequest(String packageName, long versionCode, String[] urlBarResourceIds, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                ArrayMap<String, PackageCompatState> userSpec;
                if (this.mUserSpecs == null) {
                    this.mUserSpecs = new SparseArray();
                }
                if ((userSpec = this.mUserSpecs.get(userId)) == null) {
                    userSpec = new ArrayMap();
                    this.mUserSpecs.put(userId, userSpec);
                }
                userSpec.put(packageName, new PackageCompatState(versionCode, urlBarResourceIds));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCompatibilityModeRequests(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs != null) {
                    this.mUserSpecs.remove(userId);
                    if (this.mUserSpecs.size() <= 0) {
                        this.mUserSpecs = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs != null) {
                    this.mUserSpecs.delete(userId);
                    int newSize = this.mUserSpecs.size();
                    if (newSize == 0) {
                        if (Helper.sVerbose) {
                            Slog.v(AutofillManagerService.TAG, "reseting mUserSpecs");
                        }
                        this.mUserSpecs = null;
                    } else if (Helper.sVerbose) {
                        Slog.v(AutofillManagerService.TAG, "mUserSpecs down to " + newSize);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dump(String prefix, PrintWriter pw) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs == null) {
                    pw.println("N/A");
                    return;
                }
                pw.println();
                String prefix2 = prefix + "  ";
                for (int i = 0; i < this.mUserSpecs.size(); ++i) {
                    int user = this.mUserSpecs.keyAt(i);
                    pw.print(prefix);
                    pw.print("User: ");
                    pw.println(user);
                    ArrayMap<String, PackageCompatState> perUser = this.mUserSpecs.valueAt(i);
                    for (int j = 0; j < perUser.size(); ++j) {
                        String packageName = perUser.keyAt(j);
                        PackageCompatState state = perUser.valueAt(j);
                        pw.print(prefix2);
                        pw.print(packageName);
                        pw.print(": ");
                        pw.println(state);
                    }
                }
            }
        }
    }

    static final class PackageCompatState {
        private final long maxVersionCode;
        private final String[] urlBarResourceIds;

        PackageCompatState(long maxVersionCode, String[] urlBarResourceIds) {
            this.maxVersionCode = maxVersionCode;
            this.urlBarResourceIds = urlBarResourceIds;
        }

        public String toString() {
            return "maxVersionCode=" + this.maxVersionCode + ", urlBarResourceIds=" + Arrays.toString(this.urlBarResourceIds);
        }
    }

    private final class LocalService
    extends AutofillManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBackKeyPressed() {
            if (Helper.sDebug) {
                Slog.d(AutofillManagerService.TAG, "onBackKeyPressed()");
            }
            AutofillManagerService.this.mUi.hideAll(null);
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.getServiceForUserLocked(UserHandle.getCallingUserId());
                service.onBackKeyPressed();
            }
        }

        @Override
        public AutofillOptions getAutofillOptions(String packageName, long versionCode, int userId) {
            int loggingLevel = AutofillManagerService.this.verbose ? 6 : (AutofillManagerService.this.debug ? 2 : 0);
            boolean compatModeEnabled = AutofillManagerService.this.mAutofillCompatState.isCompatibilityModeRequested(packageName, versionCode, userId);
            AutofillOptions options = new AutofillOptions(loggingLevel, compatModeEnabled);
            AutofillManagerService.this.mAugmentedAutofillState.injectAugmentedAutofillInfo(options, userId, packageName);
            return options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAugmentedAutofillServiceForUser(int callingUid, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.isAugmentedAutofillServiceForUserLocked(callingUid);
                }
            }
            return false;
        }
    }
}

