/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManagerInternal;
import android.app.ActivityTaskManager;
import android.app.IActivityTaskManager;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.autofill.AutofillServiceInfo;
import android.service.autofill.FieldClassification;
import android.service.autofill.FillEventHistory;
import android.service.autofill.FillResponse;
import android.service.autofill.UserData;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.LocalLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.server.LocalServices;
import com.android.server.autofill.AutofillManagerService;
import com.android.server.autofill.FieldClassificationStrategy;
import com.android.server.autofill.Helper;
import com.android.server.autofill.RemoteAugmentedAutofillService;
import com.android.server.autofill.RemoteFillService;
import com.android.server.autofill.Session;
import com.android.server.autofill.ui.AutoFillUI;
import com.android.server.infra.AbstractPerUserSystemService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

final class AutofillManagerServiceImpl
extends AbstractPerUserSystemService<AutofillManagerServiceImpl, AutofillManagerService> {
    private static final String TAG = "AutofillManagerServiceImpl";
    private static final int MAX_SESSION_ID_CREATE_TRIES = 2048;
    private static final int MAX_ABANDONED_SESSION_MILLIS = 30000;
    private final AutoFillUI mUi;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    @GuardedBy(value={"mLock"})
    private RemoteCallbackList<IAutoFillManagerClient> mClients;
    @GuardedBy(value={"mLock"})
    private AutofillServiceInfo mInfo;
    private static final Random sRandom = new Random();
    private final LocalLog mUiLatencyHistory;
    private final LocalLog mWtfHistory;
    private final FieldClassificationStrategy mFieldClassificationStrategy;
    @GuardedBy(value={"mLock"})
    private ArrayMap<String, Long> mDisabledApps;
    @GuardedBy(value={"mLock"})
    private ArrayMap<ComponentName, Long> mDisabledActivities;
    @GuardedBy(value={"mLock"})
    private UserData mUserData;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), null, true);
    @GuardedBy(value={"mLock"})
    private final SparseArray<Session> mSessions = new SparseArray();
    @GuardedBy(value={"mLock"})
    private FillEventHistory mEventHistory;
    private final AutofillManagerService.AutofillCompatState mAutofillCompatState;
    private long mLastPrune = 0L;
    @GuardedBy(value={"mLock"})
    private RemoteAugmentedAutofillService mRemoteAugmentedAutofillService;
    @GuardedBy(value={"mLock"})
    private ServiceInfo mRemoteAugmentedAutofillServiceInfo;

    AutofillManagerServiceImpl(AutofillManagerService master, Object lock, LocalLog uiLatencyHistory, LocalLog wtfHistory, int userId, AutoFillUI ui, AutofillManagerService.AutofillCompatState autofillCompatState, boolean disabled) {
        super(master, lock, userId);
        this.mUiLatencyHistory = uiLatencyHistory;
        this.mWtfHistory = wtfHistory;
        this.mUi = ui;
        this.mFieldClassificationStrategy = new FieldClassificationStrategy(this.getContext(), userId);
        this.mAutofillCompatState = autofillCompatState;
        this.updateLocked(disabled);
    }

    @GuardedBy(value={"mLock"})
    void onBackKeyPressed() {
        RemoteAugmentedAutofillService remoteService = this.getRemoteAugmentedAutofillServiceLocked();
        if (remoteService != null) {
            remoteService.onDestroyAutofillWindowsRequest();
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected boolean updateLocked(boolean disabled) {
        this.destroySessionsLocked();
        boolean enabledChanged = super.updateLocked(disabled);
        if (enabledChanged) {
            if (!this.isEnabledLocked()) {
                int sessionCount = this.mSessions.size();
                for (int i = sessionCount - 1; i >= 0; --i) {
                    Session session = this.mSessions.valueAt(i);
                    session.removeSelfLocked();
                }
            }
            this.sendStateToClients(false);
        }
        this.updateRemoteAugmentedAutofillService();
        return enabledChanged;
    }

    @Override
    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        this.mInfo = new AutofillServiceInfo(this.getContext(), serviceComponent, this.mUserId);
        return this.mInfo.getServiceInfo();
    }

    String[] getUrlBarResourceIdsForCompatMode(String packageName) {
        return this.mAutofillCompatState.getUrlBarResourceIds(packageName, this.mUserId);
    }

    @GuardedBy(value={"mLock"})
    int addClientLocked(IAutoFillManagerClient client, ComponentName componentName) {
        if (this.mClients == null) {
            this.mClients = new RemoteCallbackList();
        }
        this.mClients.register(client);
        if (this.isEnabledLocked()) {
            return 1;
        }
        if (this.isAugmentedAutofillServiceAvailableLocked() && this.isWhitelistedForAugmentedAutofillLocked(componentName)) {
            return 8;
        }
        return 0;
    }

    @GuardedBy(value={"mLock"})
    void removeClientLocked(IAutoFillManagerClient client) {
        if (this.mClients != null) {
            this.mClients.unregister(client);
        }
    }

    @GuardedBy(value={"mLock"})
    void setAuthenticationResultLocked(Bundle data, int sessionId, int authenticationId, int uid) {
        if (!this.isEnabledLocked()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session != null && uid == session.uid) {
            session.setAuthenticationResultLocked(data, authenticationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHasCallback(int sessionId, int uid, boolean hasIt) {
        if (!this.isEnabledLocked()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session != null && uid == session.uid) {
            Object object = this.mLock;
            synchronized (object) {
                session.setHasCallbackLocked(hasIt);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    long startSessionLocked(IBinder activityToken, int taskId, int uid, IBinder appCallbackToken, AutofillId autofillId, Rect virtualBounds, AutofillValue value, boolean hasCallback, ComponentName componentName, boolean compatMode, boolean bindInstantServiceAllowed, int flags) {
        boolean forAugmentedAutofillOnly;
        boolean bl = forAugmentedAutofillOnly = (flags & 8) != 0;
        if (!this.isEnabledLocked() && !forAugmentedAutofillOnly) {
            return 0L;
        }
        if (!forAugmentedAutofillOnly && this.isAutofillDisabledLocked(componentName)) {
            if (this.isWhitelistedForAugmentedAutofillLocked(componentName)) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "startSession(" + componentName + "): disabled by service but whitelisted for augmented autofill");
                }
                forAugmentedAutofillOnly = true;
            } else {
                if (Helper.sDebug) {
                    Slog.d(TAG, "startSession(" + componentName + "): ignored because disabled by service and not whitelisted for augmented autofill");
                }
                IAutoFillManagerClient client = IAutoFillManagerClient.Stub.asInterface(appCallbackToken);
                try {
                    client.setSessionFinished(4, null);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Could not notify " + componentName + " that it's disabled: " + e);
                }
                return Integer.MAX_VALUE;
            }
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "startSession(): token=" + activityToken + ", flags=" + flags + ", forAugmentedAutofillOnly=" + forAugmentedAutofillOnly);
        }
        this.pruneAbandonedSessionsLocked();
        Session newSession = this.createSessionByTokenLocked(activityToken, taskId, uid, appCallbackToken, hasCallback, componentName, compatMode, bindInstantServiceAllowed, forAugmentedAutofillOnly, flags);
        if (newSession == null) {
            return Integer.MAX_VALUE;
        }
        String servicePackageName = this.mInfo == null ? null : this.mInfo.getServiceInfo().packageName;
        String historyItem = "id=" + newSession.id + " uid=" + uid + " a=" + componentName.toShortString() + " s=" + servicePackageName + " u=" + this.mUserId + " i=" + autofillId + " b=" + virtualBounds + " hc=" + hasCallback + " f=" + flags + " aa=" + forAugmentedAutofillOnly;
        ((AutofillManagerService)this.mMaster).logRequestLocked(historyItem);
        newSession.updateLocked(autofillId, virtualBounds, value, 1, flags);
        if (forAugmentedAutofillOnly) {
            long extraFlags = 0x100000000L;
            long result = 0x100000000L | (long)newSession.id;
            return result;
        }
        return newSession.id;
    }

    @GuardedBy(value={"mLock"})
    private void pruneAbandonedSessionsLocked() {
        long now = System.currentTimeMillis();
        if (this.mLastPrune < now - 30000L) {
            this.mLastPrune = now;
            if (this.mSessions.size() > 0) {
                new PruneTask().execute(new Void[0]);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    void setAutofillFailureLocked(int sessionId, int uid, List<AutofillId> ids) {
        if (!this.isEnabledLocked()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            Slog.v(TAG, "setAutofillFailure(): no session for " + sessionId + "(" + uid + ")");
            return;
        }
        session.setAutofillFailureLocked(ids);
    }

    @GuardedBy(value={"mLock"})
    void finishSessionLocked(int sessionId, int uid) {
        if (!this.isEnabledLocked()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "finishSessionLocked(): no session for " + sessionId + "(" + uid + ")");
            }
            return;
        }
        session.logContextCommitted();
        boolean finished = session.showSaveLocked();
        if (Helper.sVerbose) {
            Slog.v(TAG, "finishSessionLocked(): session finished on save? " + finished);
        }
        if (finished) {
            session.removeSelfLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void cancelSessionLocked(int sessionId, int uid) {
        if (!this.isEnabledLocked()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            Slog.w(TAG, "cancelSessionLocked(): no session for " + sessionId + "(" + uid + ")");
            return;
        }
        session.removeSelfLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    void disableOwnedAutofillServicesLocked(int uid) {
        Slog.i(TAG, "disableOwnedServices(" + uid + "): " + this.mInfo);
        if (this.mInfo == null) {
            return;
        }
        ServiceInfo serviceInfo = this.mInfo.getServiceInfo();
        if (serviceInfo.applicationInfo.uid != uid) {
            Slog.w(TAG, "disableOwnedServices(): ignored when called by UID " + uid + " instead of " + serviceInfo.applicationInfo.uid + " for service " + this.mInfo);
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            String autoFillService = this.getComponentNameLocked();
            ComponentName componentName = serviceInfo.getComponentName();
            if (componentName.equals(ComponentName.unflattenFromString(autoFillService))) {
                this.mMetricsLogger.action(1135, componentName.getPackageName());
                Settings.Secure.putStringForUser(this.getContext().getContentResolver(), "autofill_service", null, this.mUserId);
                this.destroySessionsLocked();
            } else {
                Slog.w(TAG, "disableOwnedServices(): ignored because current service (" + serviceInfo + ") does not match Settings (" + autoFillService + ")");
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @GuardedBy(value={"mLock"})
    private Session createSessionByTokenLocked(IBinder activityToken, int taskId, int uid, IBinder appCallbackToken, boolean hasCallback, ComponentName componentName, boolean compatMode, boolean bindInstantServiceAllowed, boolean forAugmentedAutofillOnly, int flags) {
        int sessionId;
        int tries = 0;
        do {
            if (++tries <= 2048) continue;
            Slog.w(TAG, "Cannot create session in 2048 tries");
            return null;
        } while ((sessionId = Math.abs(sRandom.nextInt())) == 0 || sessionId == Integer.MAX_VALUE || this.mSessions.indexOfKey(sessionId) >= 0);
        this.assertCallerLocked(componentName, compatMode);
        ComponentName serviceComponentName = this.mInfo == null ? null : this.mInfo.getServiceInfo().getComponentName();
        Session newSession = new Session(this, this.mUi, this.getContext(), this.mHandler, this.mUserId, this.mLock, sessionId, taskId, uid, activityToken, appCallbackToken, hasCallback, this.mUiLatencyHistory, this.mWtfHistory, serviceComponentName, componentName, compatMode, bindInstantServiceAllowed, forAugmentedAutofillOnly, flags);
        this.mSessions.put(newSession.id, newSession);
        return newSession;
    }

    private void assertCallerLocked(ComponentName componentName, boolean compatMode) {
        int packageUid;
        String packageName = componentName.getPackageName();
        PackageManager pm = this.getContext().getPackageManager();
        int callingUid = Binder.getCallingUid();
        try {
            packageUid = pm.getPackageUidAsUser(packageName, UserHandle.getCallingUserId());
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("Could not verify UID for " + componentName);
        }
        if (callingUid != packageUid && !LocalServices.getService(ActivityManagerInternal.class).hasRunningActivity(callingUid, packageName)) {
            String[] packages = pm.getPackagesForUid(callingUid);
            String callingPackage = packages != null ? packages[0] : "uid-" + callingUid;
            Slog.w(TAG, "App (package=" + callingPackage + ", UID=" + callingUid + ") passed component (" + componentName + ") owned by UID " + packageUid);
            LogMaker log = new LogMaker(948).setPackageName(callingPackage).addTaggedData(908, this.getServicePackageName()).addTaggedData(949, componentName == null ? "null" : componentName.flattenToShortString());
            if (compatMode) {
                log.addTaggedData(1414, 1);
            }
            this.mMetricsLogger.write(log);
            throw new SecurityException("Invalid component: " + componentName);
        }
    }

    boolean restoreSession(int sessionId, int uid, IBinder activityToken, IBinder appCallback) {
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            return false;
        }
        session.switchActivity(activityToken, appCallback);
        return true;
    }

    @GuardedBy(value={"mLock"})
    boolean updateSessionLocked(int sessionId, int uid, AutofillId autofillId, Rect virtualBounds, AutofillValue value, int action, int flags) {
        Session session = this.mSessions.get(sessionId);
        if (session == null || session.uid != uid) {
            if ((flags & 1) != 0) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "restarting session " + sessionId + " due to manual request on " + autofillId);
                }
                return true;
            }
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateSessionLocked(): session gone for " + sessionId + "(" + uid + ")");
            }
            return false;
        }
        session.updateLocked(autofillId, virtualBounds, value, action, flags);
        return false;
    }

    @GuardedBy(value={"mLock"})
    void removeSessionLocked(int sessionId) {
        this.mSessions.remove(sessionId);
    }

    @GuardedBy(value={"mLock"})
    ArrayList<Session> getPreviousSessionsLocked(Session session) {
        int size = this.mSessions.size();
        ArrayList<Session> previousSessions = null;
        for (int i = 0; i < size; ++i) {
            Session previousSession = this.mSessions.valueAt(i);
            if (previousSession.taskId != session.taskId || previousSession.id == session.id || (previousSession.getSaveInfoFlagsLocked() & 4) == 0) continue;
            if (previousSessions == null) {
                previousSessions = new ArrayList<Session>(size);
            }
            previousSessions.add(previousSession);
        }
        return previousSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSessionSave(Session session) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessions.get(session.id) == null) {
                Slog.w(TAG, "handleSessionSave(): already gone: " + session.id);
                return;
            }
            session.callSaveLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            int sessionCount = this.mSessions.size();
            for (int i = sessionCount - 1; i >= 0; --i) {
                Session session = this.mSessions.valueAt(i);
                if (!session.isSaveUiPendingForTokenLocked(token)) continue;
                session.onPendingSaveUi(operation, token);
                return;
            }
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "No pending Save UI for token " + token + " and operation " + DebugUtils.flagsToString(AutofillManager.class, "PENDING_UI_OPERATION_", operation));
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected void handlePackageUpdateLocked(String packageName) {
        ServiceInfo serviceInfo = this.mFieldClassificationStrategy.getServiceInfo();
        if (serviceInfo != null && serviceInfo.packageName.equals(packageName)) {
            this.resetExtServiceLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void resetExtServiceLocked() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "reset autofill service.");
        }
        this.mFieldClassificationStrategy.reset();
    }

    @GuardedBy(value={"mLock"})
    void destroyLocked() {
        int i;
        if (Helper.sVerbose) {
            Slog.v(TAG, "destroyLocked()");
        }
        this.resetExtServiceLocked();
        int numSessions = this.mSessions.size();
        ArraySet<RemoteFillService> remoteFillServices = new ArraySet<RemoteFillService>(numSessions);
        for (i = 0; i < numSessions; ++i) {
            RemoteFillService remoteFillService = this.mSessions.valueAt(i).destroyLocked();
            if (remoteFillService == null) continue;
            remoteFillServices.add(remoteFillService);
        }
        this.mSessions.clear();
        for (i = 0; i < remoteFillServices.size(); ++i) {
            ((RemoteFillService)remoteFillServices.valueAt(i)).destroy();
        }
        this.sendStateToClients(true);
        if (this.mClients != null) {
            this.mClients.kill();
            this.mClients = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastResponse(int sessionId, FillResponse response) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEventHistory = new FillEventHistory(sessionId, response.getClientState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetLastResponse() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEventHistory = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isValidEventLocked(String method, int sessionId) {
        if (this.mEventHistory == null) {
            Slog.w(TAG, method + ": not logging event because history is null");
            return false;
        }
        if (sessionId != this.mEventHistory.getSessionId()) {
            if (Helper.sDebug) {
                Slog.d(TAG, method + ": not logging event for session " + sessionId + " because tracked session is " + this.mEventHistory.getSessionId());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAuthenticationSelected(int sessionId, Bundle clientState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("setAuthenticationSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(2, null, clientState, null, null, null, null, null, null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDatasetAuthenticationSelected(String selectedDataset, int sessionId, Bundle clientState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("logDatasetAuthenticationSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(1, selectedDataset, clientState, null, null, null, null, null, null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSaveShown(int sessionId, Bundle clientState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("logSaveShown()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(3, null, clientState, null, null, null, null, null, null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDatasetSelected(String selectedDataset, int sessionId, Bundle clientState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("logDatasetSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(0, selectedDataset, clientState, null, null, null, null, null, null, null, null));
            }
        }
    }

    @GuardedBy(value={"mLock"})
    void logContextCommittedLocked(int sessionId, Bundle clientState, ArrayList<String> selectedDatasets, ArraySet<String> ignoredDatasets, ArrayList<AutofillId> changedFieldIds, ArrayList<String> changedDatasetIds, ArrayList<AutofillId> manuallyFilledFieldIds, ArrayList<ArrayList<String>> manuallyFilledDatasetIds, ComponentName appComponentName, boolean compatMode) {
        this.logContextCommittedLocked(sessionId, clientState, selectedDatasets, ignoredDatasets, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, null, null, appComponentName, compatMode);
    }

    @GuardedBy(value={"mLock"})
    void logContextCommittedLocked(int sessionId, Bundle clientState, ArrayList<String> selectedDatasets, ArraySet<String> ignoredDatasets, ArrayList<AutofillId> changedFieldIds, ArrayList<String> changedDatasetIds, ArrayList<AutofillId> manuallyFilledFieldIds, ArrayList<ArrayList<String>> manuallyFilledDatasetIds, ArrayList<AutofillId> detectedFieldIdsList, ArrayList<FieldClassification> detectedFieldClassificationsList, ComponentName appComponentName, boolean compatMode) {
        if (this.isValidEventLocked("logDatasetNotSelected()", sessionId)) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "logContextCommitted() with FieldClassification: id=" + sessionId + ", selectedDatasets=" + selectedDatasets + ", ignoredDatasetIds=" + ignoredDatasets + ", changedAutofillIds=" + changedFieldIds + ", changedDatasetIds=" + changedDatasetIds + ", manuallyFilledFieldIds=" + manuallyFilledFieldIds + ", detectedFieldIds=" + detectedFieldIdsList + ", detectedFieldClassifications=" + detectedFieldClassificationsList + ", appComponentName=" + appComponentName.toShortString() + ", compatMode=" + compatMode);
            }
            AutofillId[] detectedFieldsIds = null;
            FieldClassification[] detectedFieldClassifications = null;
            if (detectedFieldIdsList != null) {
                detectedFieldsIds = new AutofillId[detectedFieldIdsList.size()];
                detectedFieldIdsList.toArray(detectedFieldsIds);
                detectedFieldClassifications = new FieldClassification[detectedFieldClassificationsList.size()];
                detectedFieldClassificationsList.toArray(detectedFieldClassifications);
                int numberFields = detectedFieldsIds.length;
                int totalSize = 0;
                float totalScore = 0.0f;
                for (int i = 0; i < numberFields; ++i) {
                    FieldClassification fc = detectedFieldClassifications[i];
                    List<FieldClassification.Match> matches = fc.getMatches();
                    int size = matches.size();
                    totalSize += size;
                    for (int j = 0; j < size; ++j) {
                        totalScore += matches.get(j).getScore();
                    }
                }
                int averageScore = (int)(totalScore * 100.0f / (float)totalSize);
                this.mMetricsLogger.write(Helper.newLogMaker(1273, appComponentName, this.getServicePackageName(), sessionId, compatMode).setCounterValue(numberFields).addTaggedData(1274, averageScore));
            }
            this.mEventHistory.addEvent(new FillEventHistory.Event(4, null, clientState, selectedDatasets, ignoredDatasets, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, detectedFieldsIds, detectedFieldClassifications));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FillEventHistory getFillEventHistory(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEventHistory != null && this.isCalledByServiceLocked("getFillEventHistory", callingUid)) {
                return this.mEventHistory;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserData getUserData() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUserData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserData getUserData(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCalledByServiceLocked("getUserData", callingUid)) {
                return this.mUserData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUserData(int callingUid, UserData userData) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledByServiceLocked("setUserData", callingUid)) {
                return;
            }
            this.mUserData = userData;
            int numberFields = this.mUserData == null ? 0 : this.mUserData.getCategoryIds().length;
            this.mMetricsLogger.write(new LogMaker(1272).setPackageName(this.getServicePackageName()).addTaggedData(914, numberFields));
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isCalledByServiceLocked(String methodName, int callingUid) {
        int serviceUid = this.getServiceUidLocked();
        if (serviceUid != callingUid) {
            Slog.w(TAG, methodName + "() called by UID " + callingUid + ", but service UID is " + serviceUid);
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mLock"})
    int getSupportedSmartSuggestionModesLocked() {
        return ((AutofillManagerService)this.mMaster).getSupportedSmartSuggestionModesLocked();
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected void dumpLocked(String prefix, PrintWriter pw) {
        long expiration;
        int i;
        long now;
        StringBuilder builder;
        int size;
        super.dumpLocked(prefix, pw);
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("UID: ");
        pw.println(this.getServiceUidLocked());
        pw.print(prefix);
        pw.print("Autofill Service Info: ");
        if (this.mInfo == null) {
            pw.println("N/A");
        } else {
            pw.println();
            this.mInfo.dump(prefix2, pw);
        }
        pw.print(prefix);
        pw.print("Default component: ");
        pw.println(this.getContext().getString(17039700));
        pw.print(prefix);
        pw.println("mAugmentedAutofillNamer: ");
        pw.print(prefix2);
        ((AutofillManagerService)this.mMaster).mAugmentedAutofillResolver.dumpShort(pw, this.mUserId);
        pw.println();
        if (this.mRemoteAugmentedAutofillService != null) {
            pw.print(prefix);
            pw.println("RemoteAugmentedAutofillService: ");
            this.mRemoteAugmentedAutofillService.dump(prefix2, pw);
        }
        if (this.mRemoteAugmentedAutofillServiceInfo != null) {
            pw.print(prefix);
            pw.print("RemoteAugmentedAutofillServiceInfo: ");
            pw.println(this.mRemoteAugmentedAutofillServiceInfo);
        }
        pw.print(prefix);
        pw.print("Field classification enabled: ");
        pw.println(this.isFieldClassificationEnabledLocked());
        pw.print(prefix);
        pw.print("Compat pkgs: ");
        ArrayMap<String, Long> compatPkgs = this.getCompatibilityPackagesLocked();
        if (compatPkgs == null) {
            pw.println("N/A");
        } else {
            pw.println(compatPkgs);
        }
        pw.print(prefix);
        pw.print("Last prune: ");
        pw.println(this.mLastPrune);
        pw.print(prefix);
        pw.print("Disabled apps: ");
        if (this.mDisabledApps == null) {
            pw.println("N/A");
        } else {
            size = this.mDisabledApps.size();
            pw.println(size);
            builder = new StringBuilder();
            now = SystemClock.elapsedRealtime();
            for (i = 0; i < size; ++i) {
                String packageName = this.mDisabledApps.keyAt(i);
                expiration = this.mDisabledApps.valueAt(i);
                builder.append(prefix).append(prefix).append(i).append(". ").append(packageName).append(": ");
                TimeUtils.formatDuration(expiration - now, builder);
                builder.append('\n');
            }
            pw.println(builder);
        }
        pw.print(prefix);
        pw.print("Disabled activities: ");
        if (this.mDisabledActivities == null) {
            pw.println("N/A");
        } else {
            size = this.mDisabledActivities.size();
            pw.println(size);
            builder = new StringBuilder();
            now = SystemClock.elapsedRealtime();
            for (i = 0; i < size; ++i) {
                ComponentName component = this.mDisabledActivities.keyAt(i);
                expiration = this.mDisabledActivities.valueAt(i);
                builder.append(prefix).append(prefix).append(i).append(". ").append(component).append(": ");
                TimeUtils.formatDuration(expiration - now, builder);
                builder.append('\n');
            }
            pw.println(builder);
        }
        size = this.mSessions.size();
        if (size == 0) {
            pw.print(prefix);
            pw.println("No sessions");
        } else {
            pw.print(prefix);
            pw.print(size);
            pw.println(" sessions:");
            for (int i2 = 0; i2 < size; ++i2) {
                pw.print(prefix);
                pw.print("#");
                pw.println(i2 + 1);
                this.mSessions.valueAt(i2).dumpLocked(prefix2, pw);
            }
        }
        pw.print(prefix);
        pw.print("Clients: ");
        if (this.mClients == null) {
            pw.println("N/A");
        } else {
            pw.println();
            this.mClients.dump(pw, prefix2);
        }
        if (this.mEventHistory == null || this.mEventHistory.getEvents() == null || this.mEventHistory.getEvents().size() == 0) {
            pw.print(prefix);
            pw.println("No event on last fill response");
        } else {
            pw.print(prefix);
            pw.println("Events of last fill response:");
            pw.print(prefix);
            int numEvents = this.mEventHistory.getEvents().size();
            for (int i3 = 0; i3 < numEvents; ++i3) {
                FillEventHistory.Event event = this.mEventHistory.getEvents().get(i3);
                pw.println("  " + i3 + ": eventType=" + event.getType() + " datasetId=" + event.getDatasetId());
            }
        }
        pw.print(prefix);
        pw.print("User data: ");
        if (this.mUserData == null) {
            pw.println("N/A");
        } else {
            pw.println();
            this.mUserData.dump(prefix2, pw);
        }
        pw.print(prefix);
        pw.println("Field Classification strategy: ");
        this.mFieldClassificationStrategy.dump(prefix2, pw);
    }

    @GuardedBy(value={"mLock"})
    void destroySessionsLocked() {
        if (this.mSessions.size() == 0) {
            this.mUi.destroyAll(null, null, false);
            return;
        }
        while (this.mSessions.size() > 0) {
            this.mSessions.valueAt(0).forceRemoveSelfLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void destroySessionsForAugmentedAutofillOnlyLocked() {
        int sessionCount = this.mSessions.size();
        for (int i = sessionCount - 1; i >= 0; --i) {
            this.mSessions.valueAt(i).forceRemoveSelfIfForAugmentedAutofillOnlyLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void destroyFinishedSessionsLocked() {
        int sessionCount = this.mSessions.size();
        for (int i = sessionCount - 1; i >= 0; --i) {
            Session session = this.mSessions.valueAt(i);
            if (session.isSavingLocked()) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "destroyFinishedSessionsLocked(): " + session.id);
                }
                session.forceRemoveSelfLocked();
                continue;
            }
            session.destroyAugmentedAutofillWindowsLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void listSessionsLocked(ArrayList<String> output) {
        int numSessions = this.mSessions.size();
        if (numSessions <= 0) {
            return;
        }
        String fmt = "%d:%s:%s";
        for (int i = 0; i < numSessions; ++i) {
            int id2 = this.mSessions.keyAt(i);
            String service = this.mInfo == null ? "no_svc" : this.mInfo.getServiceInfo().getComponentName().flattenToShortString();
            String augmentedService = this.mRemoteAugmentedAutofillServiceInfo == null ? "no_aug" : this.mRemoteAugmentedAutofillServiceInfo.getComponentName().flattenToShortString();
            output.add(String.format("%d:%s:%s", id2, service, augmentedService));
        }
    }

    @GuardedBy(value={"mLock"})
    ArrayMap<String, Long> getCompatibilityPackagesLocked() {
        if (this.mInfo != null) {
            return this.mInfo.getCompatibilityPackages();
        }
        return null;
    }

    @GuardedBy(value={"mLock"})
    RemoteAugmentedAutofillService getRemoteAugmentedAutofillServiceLocked() {
        if (this.mRemoteAugmentedAutofillService == null) {
            String serviceName = ((AutofillManagerService)this.mMaster).mAugmentedAutofillResolver.getServiceName(this.mUserId);
            if (serviceName == null) {
                if (((AutofillManagerService)this.mMaster).verbose) {
                    Slog.v(TAG, "getRemoteAugmentedAutofillServiceLocked(): not set");
                }
                return null;
            }
            Pair<ServiceInfo, ComponentName> pair = RemoteAugmentedAutofillService.getComponentName(serviceName, this.mUserId, ((AutofillManagerService)this.mMaster).mAugmentedAutofillResolver.isTemporary(this.mUserId));
            if (pair == null) {
                return null;
            }
            this.mRemoteAugmentedAutofillServiceInfo = (ServiceInfo)pair.first;
            ComponentName componentName = (ComponentName)pair.second;
            if (Helper.sVerbose) {
                Slog.v(TAG, "getRemoteAugmentedAutofillServiceLocked(): " + componentName);
            }
            this.mRemoteAugmentedAutofillService = new RemoteAugmentedAutofillService(this.getContext(), componentName, this.mUserId, new RemoteAugmentedAutofillService.RemoteAugmentedAutofillServiceCallbacks(){

                @Override
                public void onServiceDied(RemoteAugmentedAutofillService service) {
                    Slog.w(AutofillManagerServiceImpl.TAG, "remote augmented autofill service died");
                    RemoteAugmentedAutofillService remoteService = AutofillManagerServiceImpl.this.mRemoteAugmentedAutofillService;
                    if (remoteService != null) {
                        remoteService.destroy();
                    }
                    AutofillManagerServiceImpl.this.mRemoteAugmentedAutofillService = null;
                }
            }, ((AutofillManagerService)this.mMaster).isInstantServiceAllowed(), ((AutofillManagerService)this.mMaster).verbose, ((AutofillManagerService)this.mMaster).mAugmentedServiceIdleUnbindTimeoutMs, ((AutofillManagerService)this.mMaster).mAugmentedServiceRequestTimeoutMs);
        }
        return this.mRemoteAugmentedAutofillService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRemoteAugmentedAutofillService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteAugmentedAutofillService != null) {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "updateRemoteAugmentedAutofillService(): destroying old remote service");
                }
                this.destroySessionsForAugmentedAutofillOnlyLocked();
                this.mRemoteAugmentedAutofillService.destroy();
                this.mRemoteAugmentedAutofillService = null;
                this.mRemoteAugmentedAutofillServiceInfo = null;
                this.resetAugmentedAutofillWhitelistLocked();
            }
            boolean available = this.isAugmentedAutofillServiceAvailableLocked();
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateRemoteAugmentedAutofillService(): " + available);
            }
            if (available) {
                this.mRemoteAugmentedAutofillService = this.getRemoteAugmentedAutofillServiceLocked();
            }
        }
    }

    private boolean isAugmentedAutofillServiceAvailableLocked() {
        if (((AutofillManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "isAugmentedAutofillService(): setupCompleted=" + this.isSetupCompletedLocked() + ", disabled=" + this.isDisabledByUserRestrictionsLocked() + ", augmentedService=" + ((AutofillManagerService)this.mMaster).mAugmentedAutofillResolver.getServiceName(this.mUserId));
        }
        return this.isSetupCompletedLocked() && !this.isDisabledByUserRestrictionsLocked() && ((AutofillManagerService)this.mMaster).mAugmentedAutofillResolver.getServiceName(this.mUserId) != null;
    }

    boolean isAugmentedAutofillServiceForUserLocked(int callingUid) {
        return this.mRemoteAugmentedAutofillServiceInfo != null && this.mRemoteAugmentedAutofillServiceInfo.applicationInfo.uid == callingUid;
    }

    @GuardedBy(value={"mLock"})
    boolean setAugmentedAutofillWhitelistLocked(List<String> packages, List<ComponentName> activities, int callingUid) {
        String serviceName;
        if (!this.isCalledByAugmentedAutofillServiceLocked("setAugmentedAutofillWhitelistLocked", callingUid)) {
            return false;
        }
        if (((AutofillManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "setAugmentedAutofillWhitelistLocked(packages=" + packages + ", activities=" + activities + ")");
        }
        this.whitelistForAugmentedAutofillPackages(packages, activities);
        if (this.mRemoteAugmentedAutofillServiceInfo != null) {
            serviceName = this.mRemoteAugmentedAutofillServiceInfo.getComponentName().flattenToShortString();
        } else {
            Slog.e(TAG, "setAugmentedAutofillWhitelistLocked(): no service");
            serviceName = "N/A";
        }
        LogMaker log = new LogMaker(1721).addTaggedData(908, serviceName);
        if (packages != null) {
            log.addTaggedData(1722, packages.size());
        }
        if (activities != null) {
            log.addTaggedData(1723, activities.size());
        }
        this.mMetricsLogger.write(log);
        return true;
    }

    @GuardedBy(value={"mLock"})
    private boolean isCalledByAugmentedAutofillServiceLocked(String methodName, int callingUid) {
        RemoteAugmentedAutofillService service = this.getRemoteAugmentedAutofillServiceLocked();
        if (service == null) {
            Slog.w(TAG, methodName + "() called by UID " + callingUid + ", but there is no augmented autofill service defined for user " + this.getUserId());
            return false;
        }
        if (this.getAugmentedAutofillServiceUidLocked() != callingUid) {
            Slog.w(TAG, methodName + "() called by UID " + callingUid + ", but service UID is " + this.getAugmentedAutofillServiceUidLocked() + " for user " + this.getUserId());
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mLock"})
    private int getAugmentedAutofillServiceUidLocked() {
        if (this.mRemoteAugmentedAutofillServiceInfo == null) {
            if (((AutofillManagerService)this.mMaster).verbose) {
                Slog.v(TAG, "getAugmentedAutofillServiceUid(): no mRemoteAugmentedAutofillServiceInfo");
            }
            return -1;
        }
        return this.mRemoteAugmentedAutofillServiceInfo.applicationInfo.uid;
    }

    @GuardedBy(value={"mLock"})
    boolean isWhitelistedForAugmentedAutofillLocked(ComponentName componentName) {
        return ((AutofillManagerService)this.mMaster).mAugmentedAutofillState.isWhitelisted(this.mUserId, componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whitelistForAugmentedAutofillPackages(List<String> packages, List<ComponentName> components) {
        Object object = this.mLock;
        synchronized (object) {
            if (((AutofillManagerService)this.mMaster).verbose) {
                Slog.v(TAG, "whitelisting packages: " + packages + "and activities: " + components);
            }
            ((AutofillManagerService)this.mMaster).mAugmentedAutofillState.setWhitelist(this.mUserId, packages, components);
        }
    }

    @GuardedBy(value={"mLock"})
    void resetAugmentedAutofillWhitelistLocked() {
        if (((AutofillManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "resetting augmented autofill whitelist");
        }
        ((AutofillManagerService)this.mMaster).mAugmentedAutofillState.resetWhitelist(this.mUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateToClients(boolean resetClient) {
        int userClientCount;
        RemoteCallbackList<IAutoFillManagerClient> clients;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClients == null) {
                return;
            }
            clients = this.mClients;
            userClientCount = clients.beginBroadcast();
        }
        try {
            for (int i = 0; i < userClientCount; ++i) {
                IAutoFillManagerClient client = clients.getBroadcastItem(i);
                try {
                    boolean isEnabled;
                    boolean resetSession;
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        resetSession = resetClient || this.isClientSessionDestroyedLocked(client);
                        isEnabled = this.isEnabledLocked();
                    }
                    int flags = 0;
                    if (isEnabled) {
                        flags |= 1;
                    }
                    if (resetSession) {
                        flags |= 2;
                    }
                    if (resetClient) {
                        flags |= 4;
                    }
                    if (Helper.sDebug) {
                        flags |= 8;
                    }
                    if (Helper.sVerbose) {
                        flags |= 0x10;
                    }
                    client.setState(flags);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clients.finishBroadcast();
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isClientSessionDestroyedLocked(IAutoFillManagerClient client) {
        int sessionCount = this.mSessions.size();
        for (int i = 0; i < sessionCount; ++i) {
            Session session = this.mSessions.valueAt(i);
            if (!session.getClient().equals(client)) continue;
            return session.isDestroyed();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableAutofillForApp(String packageName, long duration, int sessionId, boolean compatMode) {
        Object object = this.mLock;
        synchronized (object) {
            long expiration;
            if (this.mDisabledApps == null) {
                this.mDisabledApps = new ArrayMap(1);
            }
            if ((expiration = SystemClock.elapsedRealtime() + duration) < 0L) {
                expiration = Long.MAX_VALUE;
            }
            this.mDisabledApps.put(packageName, expiration);
            int intDuration = duration > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)duration;
            this.mMetricsLogger.write(Helper.newLogMaker(1231, packageName, this.getServicePackageName(), sessionId, compatMode).addTaggedData(1145, intDuration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableAutofillForActivity(ComponentName componentName, long duration, int sessionId, boolean compatMode) {
        Object object = this.mLock;
        synchronized (object) {
            long expiration;
            if (this.mDisabledActivities == null) {
                this.mDisabledActivities = new ArrayMap(1);
            }
            if ((expiration = SystemClock.elapsedRealtime() + duration) < 0L) {
                expiration = Long.MAX_VALUE;
            }
            this.mDisabledActivities.put(componentName, expiration);
            int intDuration = duration > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)duration;
            LogMaker log = new LogMaker(1232).setComponentName(componentName).addTaggedData(908, this.getServicePackageName()).addTaggedData(1145, intDuration).addTaggedData(1456, sessionId);
            if (compatMode) {
                log.addTaggedData(1414, 1);
            }
            this.mMetricsLogger.write(log);
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isAutofillDisabledLocked(ComponentName componentName) {
        long elapsedTime = 0L;
        if (this.mDisabledActivities != null) {
            elapsedTime = SystemClock.elapsedRealtime();
            Long expiration = this.mDisabledActivities.get(componentName);
            if (expiration != null) {
                if (expiration >= elapsedTime) {
                    return true;
                }
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Removing " + componentName.toShortString() + " from disabled list");
                }
                this.mDisabledActivities.remove(componentName);
            }
        }
        String packageName = componentName.getPackageName();
        if (this.mDisabledApps == null) {
            return false;
        }
        Long expiration = this.mDisabledApps.get(packageName);
        if (expiration == null) {
            return false;
        }
        if (elapsedTime == 0L) {
            elapsedTime = SystemClock.elapsedRealtime();
        }
        if (expiration >= elapsedTime) {
            return true;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "Removing " + packageName + " from disabled list");
        }
        this.mDisabledApps.remove(packageName);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFieldClassificationEnabled(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledByServiceLocked("isFieldClassificationEnabled", callingUid)) {
                return false;
            }
            return this.isFieldClassificationEnabledLocked();
        }
    }

    boolean isFieldClassificationEnabledLocked() {
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "autofill_field_classification", 1, this.mUserId) == 1;
    }

    FieldClassificationStrategy getFieldClassificationStrategy() {
        return this.mFieldClassificationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAvailableFieldClassificationAlgorithms(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledByServiceLocked("getFCAlgorithms()", callingUid)) {
                return null;
            }
        }
        return this.mFieldClassificationStrategy.getAvailableAlgorithms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDefaultFieldClassificationAlgorithm(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledByServiceLocked("getDefaultFCAlgorithm()", callingUid)) {
                return null;
            }
        }
        return this.mFieldClassificationStrategy.getDefaultAlgorithm();
    }

    public String toString() {
        return "AutofillManagerServiceImpl: [userId=" + this.mUserId + ", component=" + (this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null) + "]";
    }

    private class PruneTask
    extends AsyncTask<Void, Void, Void> {
        private PruneTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... ignored) {
            int i;
            SparseArray<IBinder> sessionsToRemove;
            int numSessionsToRemove;
            Object object = AutofillManagerServiceImpl.this.mLock;
            synchronized (object) {
                numSessionsToRemove = AutofillManagerServiceImpl.this.mSessions.size();
                sessionsToRemove = new SparseArray<IBinder>(numSessionsToRemove);
                for (i = 0; i < numSessionsToRemove; ++i) {
                    Session session = (Session)AutofillManagerServiceImpl.this.mSessions.valueAt(i);
                    sessionsToRemove.put(session.id, session.getActivityTokenLocked());
                }
            }
            IActivityTaskManager atm = ActivityTaskManager.getService();
            for (i = 0; i < numSessionsToRemove; ++i) {
                try {
                    if (atm.getActivityClassForToken((IBinder)sessionsToRemove.valueAt(i)) == null) continue;
                    sessionsToRemove.removeAt(i);
                    --i;
                    --numSessionsToRemove;
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w(AutofillManagerServiceImpl.TAG, "Cannot figure out if activity is finished", e);
                }
            }
            Object object2 = AutofillManagerServiceImpl.this.mLock;
            synchronized (object2) {
                for (int i2 = 0; i2 < numSessionsToRemove; ++i2) {
                    Session sessionToRemove = (Session)AutofillManagerServiceImpl.this.mSessions.get(sessionsToRemove.keyAt(i2));
                    if (sessionToRemove == null || sessionsToRemove.valueAt(i2) != sessionToRemove.getActivityTokenLocked()) continue;
                    if (sessionToRemove.isSavingLocked()) {
                        if (!Helper.sVerbose) continue;
                        Slog.v(AutofillManagerServiceImpl.TAG, "Session " + sessionToRemove.id + " is saving");
                        continue;
                    }
                    if (Helper.sDebug) {
                        Slog.i(AutofillManagerServiceImpl.TAG, "Prune session " + sessionToRemove.id + " (" + sessionToRemove.getActivityTokenLocked() + ")");
                    }
                    sessionToRemove.removeSelfLocked();
                }
            }
            return null;
        }
    }
}

