/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.os.SystemClock;
import android.service.autofill.augmented.IAugmentedAutofillService;
import android.service.autofill.augmented.IFillCallback;
import android.util.Pair;
import android.util.Slog;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.infra.AbstractRemoteService;
import com.android.internal.infra.AbstractSinglePendingRequestRemoteService;
import com.android.internal.os.IResultReceiver;
import com.android.server.autofill.Helper;

final class RemoteAugmentedAutofillService
extends AbstractSinglePendingRequestRemoteService<RemoteAugmentedAutofillService, IAugmentedAutofillService> {
    private static final String TAG = RemoteAugmentedAutofillService.class.getSimpleName();
    private final int mIdleUnbindTimeoutMs;
    private final int mRequestTimeoutMs;

    RemoteAugmentedAutofillService(Context context, ComponentName serviceName, int userId, RemoteAugmentedAutofillServiceCallbacks callbacks, boolean bindInstantServiceAllowed, boolean verbose, int idleUnbindTimeoutMs, int requestTimeoutMs) {
        super(context, "android.service.autofill.augmented.AugmentedAutofillService", serviceName, userId, callbacks, context.getMainThreadHandler(), bindInstantServiceAllowed ? 0x400000 : 0, verbose);
        this.mIdleUnbindTimeoutMs = idleUnbindTimeoutMs;
        this.mRequestTimeoutMs = requestTimeoutMs;
        this.scheduleBind();
    }

    static Pair<ServiceInfo, ComponentName> getComponentName(String componentName, int userId, boolean isTemporary) {
        ComponentName serviceComponent;
        int flags = 128;
        if (!isTemporary) {
            flags |= 0x100000;
        }
        ServiceInfo serviceInfo = null;
        try {
            serviceComponent = ComponentName.unflattenFromString(componentName);
            serviceInfo = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, flags, userId);
            if (serviceInfo == null) {
                Slog.e(TAG, "Bad service name for flags " + flags + ": " + componentName);
                return null;
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error getting service info for '" + componentName + "': " + e);
            return null;
        }
        return new Pair<ServiceInfo, ComponentName>(serviceInfo, serviceComponent);
    }

    @Override
    protected void handleOnConnectedStateChanged(boolean state) {
        if (state && this.getTimeoutIdleBindMillis() != 0L) {
            this.scheduleUnbind();
        }
        try {
            if (state) {
                ((IAugmentedAutofillService)this.mService).onConnected(Helper.sDebug, Helper.sVerbose);
            } else {
                ((IAugmentedAutofillService)this.mService).onDisconnected();
            }
        }
        catch (Exception e) {
            Slog.w(this.mTag, "Exception calling onConnectedStateChanged(" + state + "): " + e);
        }
    }

    @Override
    protected IAugmentedAutofillService getServiceInterface(IBinder service) {
        return IAugmentedAutofillService.Stub.asInterface(service);
    }

    @Override
    protected long getTimeoutIdleBindMillis() {
        return this.mIdleUnbindTimeoutMs;
    }

    @Override
    protected long getRemoteRequestMillis() {
        return this.mRequestTimeoutMs;
    }

    public void onRequestAutofillLocked(int sessionId, IAutoFillManagerClient client, int taskId, ComponentName activityComponent, AutofillId focusedId, AutofillValue focusedValue) {
        this.scheduleRequest(new PendingAutofillRequest(this, sessionId, client, taskId, activityComponent, focusedId, focusedValue));
    }

    @Override
    public String toString() {
        return "RemoteAugmentedAutofillService[" + ComponentName.flattenToShortString(this.getComponentName()) + "]";
    }

    public void onDestroyAutofillWindowsRequest() {
        this.scheduleAsyncRequest(s -> s.onDestroyAllFillWindowsRequest());
    }

    private void dispatchOnFillTimeout(ICancellationSignal cancellation) {
        this.mHandler.post(() -> {
            try {
                cancellation.cancel();
            }
            catch (RemoteException e) {
                Slog.w(this.mTag, "Error calling cancellation signal: " + e);
            }
        });
    }

    public static interface RemoteAugmentedAutofillServiceCallbacks
    extends AbstractRemoteService.VultureCallback<RemoteAugmentedAutofillService> {
    }

    private static final class PendingAutofillRequest
    extends MyPendingRequest {
        private final AutofillId mFocusedId;
        private final AutofillValue mFocusedValue;
        private final IAutoFillManagerClient mClient;
        private final ComponentName mActivityComponent;
        private final int mSessionId;
        private final int mTaskId;
        private final long mRequestTime = SystemClock.elapsedRealtime();
        private final IFillCallback mCallback;
        private ICancellationSignal mCancellation;

        protected PendingAutofillRequest(RemoteAugmentedAutofillService service, int sessionId, IAutoFillManagerClient client, int taskId, ComponentName activityComponent, AutofillId focusedId, AutofillValue focusedValue) {
            super(service, sessionId);
            this.mClient = client;
            this.mSessionId = sessionId;
            this.mTaskId = taskId;
            this.mActivityComponent = activityComponent;
            this.mFocusedId = focusedId;
            this.mFocusedValue = focusedValue;
            this.mCallback = new IFillCallback.Stub(){

                @Override
                public void onSuccess() {
                    if (!this.finish()) {
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellable(ICancellationSignal cancellation) {
                    Object object = mLock;
                    synchronized (object) {
                        boolean cancelled;
                        Object object2 = mLock;
                        synchronized (object2) {
                            mCancellation = cancellation;
                            cancelled = this.isCancelledLocked();
                        }
                        if (cancelled) {
                            try {
                                cancellation.cancel();
                            }
                            catch (RemoteException e) {
                                Slog.e(mTag, "Error requesting a cancellation", e);
                            }
                        }
                    }
                }

                @Override
                public boolean isCompleted() {
                    return this.isRequestCompleted();
                }

                @Override
                public void cancel() {
                    this.cancel();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isCancelledLocked()) {
                    if (Helper.sDebug) {
                        Slog.d(this.mTag, "run() called after canceled");
                    }
                    return;
                }
            }
            final RemoteAugmentedAutofillService remoteService = (RemoteAugmentedAutofillService)this.getService();
            if (remoteService == null) {
                return;
            }
            IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

                @Override
                public void send(int resultCode, Bundle resultData) throws RemoteException {
                    IBinder realClient = resultData.getBinder("android.view.autofill.extra.AUGMENTED_AUTOFILL_CLIENT");
                    ((IAugmentedAutofillService)remoteService.mService).onFillRequest(mSessionId, realClient, mTaskId, mActivityComponent, mFocusedId, mFocusedValue, mRequestTime, mCallback);
                }
            };
            try {
                this.mClient.getAugmentedAutofillClient(receiver);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "exception handling getAugmentedAutofillClient() for " + this.mSessionId + ": " + e);
                this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteAugmentedAutofillService remoteService) {
            ICancellationSignal cancellation;
            Slog.w(TAG, "PendingAutofillRequest timed out (" + remoteService.mRequestTimeoutMs + "ms) for " + remoteService);
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                remoteService.dispatchOnFillTimeout(cancellation);
            }
            this.finish();
            android.service.autofill.augmented.Helper.logResponse(15, remoteService.getComponentName().getPackageName(), this.mActivityComponent, this.mSessionId, remoteService.mRequestTimeoutMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            ICancellationSignal cancellation;
            if (!super.cancel()) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                try {
                    cancellation.cancel();
                }
                catch (RemoteException e) {
                    Slog.e(this.mTag, "Error cancelling an augmented fill request", e);
                }
            }
            return true;
        }
    }

    private static abstract class MyPendingRequest
    extends AbstractRemoteService.PendingRequest<RemoteAugmentedAutofillService, IAugmentedAutofillService> {
        protected final int mSessionId;

        private MyPendingRequest(RemoteAugmentedAutofillService service, int sessionId) {
            super(service);
            this.mSessionId = sessionId;
        }
    }
}

