/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.service.autofill.SaveRequest;
import android.util.Slog;
import com.android.internal.infra.AbstractRemoteService;
import com.android.internal.infra.AbstractSinglePendingRequestRemoteService;
import com.android.server.autofill.Helper;
import java.util.concurrent.CompletableFuture;

final class RemoteFillService
extends AbstractSinglePendingRequestRemoteService<RemoteFillService, IAutoFillService> {
    private static final long TIMEOUT_IDLE_BIND_MILLIS = 5000L;
    private static final long TIMEOUT_REMOTE_REQUEST_MILLIS = 5000L;
    private final FillServiceCallbacks mCallbacks;

    RemoteFillService(Context context, ComponentName componentName, int userId, FillServiceCallbacks callbacks, boolean bindInstantServiceAllowed) {
        super(context, "android.service.autofill.AutofillService", componentName, userId, callbacks, context.getMainThreadHandler(), 0x100000 | (bindInstantServiceAllowed ? 0x400000 : 0), Helper.sVerbose);
        this.mCallbacks = callbacks;
    }

    @Override
    protected void handleOnConnectedStateChanged(boolean state) {
        if (this.mService == null) {
            Slog.w(this.mTag, "onConnectedStateChanged(): null service");
            return;
        }
        try {
            ((IAutoFillService)this.mService).onConnectedStateChanged(state);
        }
        catch (Exception e) {
            Slog.w(this.mTag, "Exception calling onConnectedStateChanged(" + state + "): " + e);
        }
    }

    @Override
    protected IAutoFillService getServiceInterface(IBinder service) {
        return IAutoFillService.Stub.asInterface(service);
    }

    @Override
    protected long getTimeoutIdleBindMillis() {
        return 5000L;
    }

    @Override
    protected long getRemoteRequestMillis() {
        return 5000L;
    }

    public CompletableFuture<Integer> cancelCurrentRequest() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.isDestroyed()) {
                return Integer.MIN_VALUE;
            }
            AbstractRemoteService.BasePendingRequest canceledRequest = this.handleCancelPendingRequest();
            return canceledRequest instanceof PendingFillRequest ? ((PendingFillRequest)canceledRequest).mRequest.getId() : Integer.MIN_VALUE;
        }, this.mHandler::post);
    }

    public void onFillRequest(FillRequest request) {
        this.scheduleRequest(new PendingFillRequest(request, this));
    }

    public void onSaveRequest(SaveRequest request) {
        this.scheduleRequest(new PendingSaveRequest(request, this));
    }

    private boolean handleResponseCallbackCommon(AbstractRemoteService.PendingRequest<RemoteFillService, IAutoFillService> pendingRequest) {
        if (this.isDestroyed()) {
            return false;
        }
        if (this.mPendingRequest == pendingRequest) {
            this.mPendingRequest = null;
        }
        return true;
    }

    private void dispatchOnFillRequestSuccess(PendingFillRequest pendingRequest, FillResponse response, int requestFlags) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestSuccess(pendingRequest.mRequest.getId(), response, this.mComponentName.getPackageName(), requestFlags);
            }
        });
    }

    private void dispatchOnFillRequestFailure(PendingFillRequest pendingRequest, CharSequence message) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestFailure(pendingRequest.mRequest.getId(), message);
            }
        });
    }

    private void dispatchOnFillRequestTimeout(PendingFillRequest pendingRequest) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestTimeout(pendingRequest.mRequest.getId());
            }
        });
    }

    private void dispatchOnFillTimeout(ICancellationSignal cancellationSignal) {
        this.mHandler.post(() -> {
            try {
                cancellationSignal.cancel();
            }
            catch (RemoteException e) {
                Slog.w(this.mTag, "Error calling cancellation signal: " + e);
            }
        });
    }

    private void dispatchOnSaveRequestSuccess(PendingSaveRequest pendingRequest, IntentSender intentSender) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestSuccess(this.mComponentName.getPackageName(), intentSender);
            }
        });
    }

    private void dispatchOnSaveRequestFailure(PendingSaveRequest pendingRequest, CharSequence message) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestFailure(message, this.mComponentName.getPackageName());
            }
        });
    }

    private static final class PendingSaveRequest
    extends AbstractRemoteService.PendingRequest<RemoteFillService, IAutoFillService> {
        private final SaveRequest mRequest;
        private final ISaveCallback mCallback;

        public PendingSaveRequest(SaveRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new ISaveCallback.Stub(){

                @Override
                public void onSuccess(IntentSender intentSender) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = (RemoteFillService)this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestSuccess(this, intentSender);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = (RemoteFillService)this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestFailure(this, message);
                    }
                }
            };
        }

        @Override
        protected void onTimeout(RemoteFillService remoteService) {
            remoteService.dispatchOnSaveRequestFailure(this, null);
        }

        @Override
        public void run() {
            RemoteFillService remoteService = (RemoteFillService)this.getService();
            if (remoteService != null) {
                if (Helper.sVerbose) {
                    Slog.v(this.mTag, "calling onSaveRequest()");
                }
                try {
                    ((IAutoFillService)remoteService.mService).onSaveRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(this.mTag, "Error calling on save request", e);
                    remoteService.dispatchOnSaveRequestFailure(this, null);
                }
            }
        }

        @Override
        public boolean isFinal() {
            return true;
        }
    }

    private static final class PendingFillRequest
    extends AbstractRemoteService.PendingRequest<RemoteFillService, IAutoFillService> {
        private final FillRequest mRequest;
        private final IFillCallback mCallback;
        private ICancellationSignal mCancellation;

        public PendingFillRequest(final FillRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new IFillCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellable(ICancellationSignal cancellation) {
                    Object object = mLock;
                    synchronized (object) {
                        boolean cancelled;
                        Object object2 = mLock;
                        synchronized (object2) {
                            mCancellation = cancellation;
                            cancelled = this.isCancelledLocked();
                        }
                        if (cancelled) {
                            try {
                                cancellation.cancel();
                            }
                            catch (RemoteException e) {
                                Slog.e(mTag, "Error requesting a cancellation", e);
                            }
                        }
                    }
                }

                @Override
                public void onSuccess(FillResponse response) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = (RemoteFillService)this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestSuccess(this, response, request.getFlags());
                    }
                }

                @Override
                public void onFailure(int requestId, CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = (RemoteFillService)this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestFailure(this, message);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteFillService remoteService) {
            ICancellationSignal cancellation;
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                remoteService.dispatchOnFillTimeout(cancellation);
            }
            remoteService.dispatchOnFillRequestTimeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isCancelledLocked()) {
                    if (Helper.sDebug) {
                        Slog.d(this.mTag, "run() called after canceled: " + this.mRequest);
                    }
                    return;
                }
            }
            RemoteFillService remoteService = (RemoteFillService)this.getService();
            if (remoteService != null) {
                if (Helper.sVerbose) {
                    Slog.v(this.mTag, "calling onFillRequest() for id=" + this.mRequest.getId());
                }
                try {
                    ((IAutoFillService)remoteService.mService).onFillRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(this.mTag, "Error calling on fill request", e);
                    remoteService.dispatchOnFillRequestFailure(this, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            ICancellationSignal cancellation;
            if (!super.cancel()) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                try {
                    cancellation.cancel();
                }
                catch (RemoteException e) {
                    Slog.e(this.mTag, "Error cancelling a fill request", e);
                }
            }
            return true;
        }
    }

    public static interface FillServiceCallbacks
    extends AbstractRemoteService.VultureCallback<RemoteFillService> {
        public void onFillRequestSuccess(int var1, FillResponse var2, String var3, int var4);

        public void onFillRequestFailure(int var1, CharSequence var2);

        public void onFillRequestTimeout(int var1);

        public void onSaveRequestSuccess(String var1, IntentSender var2);

        public void onSaveRequestFailure(CharSequence var1, String var2);
    }
}

