/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityTaskManager;
import android.app.IAssistDataReceiver;
import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SystemClock;
import android.service.autofill.AutofillFieldClassificationService;
import android.service.autofill.CompositeUserData;
import android.service.autofill.Dataset;
import android.service.autofill.FieldClassification;
import android.service.autofill.FieldClassificationUserData;
import android.service.autofill.FillContext;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.InternalSanitizer;
import android.service.autofill.InternalValidator;
import android.service.autofill.SaveInfo;
import android.service.autofill.SaveRequest;
import android.service.autofill.UserData;
import android.service.autofill.ValueFinder;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.KeyEvent;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.autofill.AutofillManagerService;
import com.android.server.autofill.AutofillManagerServiceImpl;
import com.android.server.autofill.FieldClassificationStrategy;
import com.android.server.autofill.Helper;
import com.android.server.autofill.RemoteAugmentedAutofillService;
import com.android.server.autofill.RemoteFillService;
import com.android.server.autofill.ViewState;
import com.android.server.autofill.ui.AutoFillUI;
import com.android.server.autofill.ui.PendingUi;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

final class Session
implements RemoteFillService.FillServiceCallbacks,
ViewState.Listener,
AutoFillUI.AutoFillUiCallback,
ValueFinder {
    private static final String TAG = "AutofillSession";
    private static final String EXTRA_REQUEST_ID = "android.service.autofill.extra.REQUEST_ID";
    private final AutofillManagerServiceImpl mService;
    private final Handler mHandler;
    private final Object mLock;
    private final AutoFillUI mUi;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private static AtomicInteger sIdCounter = new AtomicInteger();
    public final int id;
    public final int uid;
    public final int taskId;
    public final int mFlags;
    @GuardedBy(value={"mLock"})
    private IBinder mActivityToken;
    private final ComponentName mComponentName;
    private final boolean mCompatMode;
    @GuardedBy(value={"mLock"})
    private AssistStructure.ViewNode mUrlBar;
    @GuardedBy(value={"mLock"})
    private boolean mSaveOnAllViewsInvisible;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<AutofillId, ViewState> mViewStates = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private AutofillId mCurrentViewId;
    @GuardedBy(value={"mLock"})
    private IAutoFillManagerClient mClient;
    @GuardedBy(value={"mLock"})
    private IBinder.DeathRecipient mClientVulture;
    private final RemoteFillService mRemoteFillService;
    @GuardedBy(value={"mLock"})
    private SparseArray<FillResponse> mResponses;
    @GuardedBy(value={"mLock"})
    private ArrayList<FillContext> mContexts;
    private boolean mHasCallback;
    @GuardedBy(value={"mLock"})
    private Bundle mClientState;
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    @GuardedBy(value={"mLock"})
    private boolean mIsSaving;
    @GuardedBy(value={"mLock"})
    private PendingUi mPendingSaveUi;
    @GuardedBy(value={"mLock"})
    private ArrayList<String> mSelectedDatasetIds;
    private final long mStartTime;
    @GuardedBy(value={"mLock"})
    private long mUiShownTime;
    @GuardedBy(value={"mLock"})
    private final LocalLog mUiLatencyHistory;
    @GuardedBy(value={"mLock"})
    private final LocalLog mWtfHistory;
    @GuardedBy(value={"mLock"})
    private final SparseArray<LogMaker> mRequestLogs = new SparseArray(1);
    @GuardedBy(value={"mLock"})
    private Runnable mAugmentedAutofillDestroyer;
    @GuardedBy(value={"mLock"})
    private ArrayList<LogMaker> mAugmentedRequestsLogs;
    @GuardedBy(value={"mLock"})
    private ArrayList<AutofillId> mAugmentedAutofillableIds;
    @GuardedBy(value={"mLock"})
    private boolean mForAugmentedAutofillOnly;
    private final IAssistDataReceiver mAssistReceiver = new IAssistDataReceiver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHandleAssistData(Bundle resultData) throws RemoteException {
            FillRequest request;
            if (Session.this.mRemoteFillService == null) {
                Session.this.wtf(null, "onHandleAssistData() called without a remote service. mForAugmentedAutofillOnly: %s", new Object[]{Session.this.mForAugmentedAutofillOnly});
                return;
            }
            AssistStructure structure = (AssistStructure)resultData.getParcelable("structure");
            if (structure == null) {
                Slog.e(Session.TAG, "No assist structure - app might have crashed providing it");
                return;
            }
            Bundle receiverExtras = resultData.getBundle("receiverExtras");
            if (receiverExtras == null) {
                Slog.e(Session.TAG, "No receiver extras - app might have crashed providing it");
                return;
            }
            int requestId = receiverExtras.getInt(Session.EXTRA_REQUEST_ID);
            if (Helper.sVerbose) {
                Slog.v(Session.TAG, "New structure for requestId " + requestId + ": " + structure);
            }
            Object object = Session.this.mLock;
            synchronized (object) {
                try {
                    structure.ensureDataForAutofill();
                }
                catch (RuntimeException e) {
                    Session.this.wtf(e, "Exception lazy loading assist structure for %s: %s", new Object[]{structure.getActivityComponent(), e});
                    return;
                }
                ArrayList<AutofillId> ids = Helper.getAutofillIds(structure, false);
                for (int i = 0; i < ids.size(); ++i) {
                    ids.get(i).setSessionId(Session.this.id);
                }
                int flags = structure.getFlags();
                if (Session.this.mCompatMode) {
                    Object[] urlBarIds = Session.this.mService.getUrlBarResourceIdsForCompatMode(Session.this.mComponentName.getPackageName());
                    if (Helper.sDebug) {
                        Slog.d(Session.TAG, "url_bars in compat mode: " + Arrays.toString(urlBarIds));
                    }
                    if (urlBarIds != null) {
                        Session.this.mUrlBar = Helper.sanitizeUrlBar(structure, (String[])urlBarIds);
                        if (Session.this.mUrlBar != null) {
                            AutofillId urlBarId = Session.this.mUrlBar.getAutofillId();
                            if (Helper.sDebug) {
                                Slog.d(Session.TAG, "Setting urlBar as id=" + urlBarId + " and domain " + Session.this.mUrlBar.getWebDomain());
                            }
                            ViewState viewState = new ViewState(urlBarId, Session.this, 512);
                            Session.this.mViewStates.put(urlBarId, viewState);
                        }
                    }
                    flags |= 2;
                }
                structure.sanitizeForParceling(true);
                if (Session.this.mContexts == null) {
                    Session.this.mContexts = new ArrayList(1);
                }
                Session.this.mContexts.add(new FillContext(requestId, structure, Session.this.mCurrentViewId));
                Session.this.cancelCurrentRequestLocked();
                int numContexts = Session.this.mContexts.size();
                for (int i = 0; i < numContexts; ++i) {
                    Session.this.fillContextWithAllowedValuesLocked((FillContext)Session.this.mContexts.get(i), flags);
                }
                ArrayList contexts = Session.this.mergePreviousSessionLocked(false);
                request = new FillRequest(requestId, contexts, Session.this.mClientState, flags);
            }
            Session.this.mRemoteFillService.onFillRequest(request);
        }

        @Override
        public void onHandleAssistScreenshot(Bitmap screenshot) {
        }
    };

    @GuardedBy(value={"mLock"})
    private AutofillId[] getIdsOfAllViewStatesLocked() {
        int numViewState = this.mViewStates.size();
        AutofillId[] ids = new AutofillId[numViewState];
        for (int i = 0; i < numViewState; ++i) {
            ids[i] = this.mViewStates.valueAt((int)i).id;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findByAutofillId(AutofillId id2) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillValue value = this.findValueLocked(id2);
            if (value != null) {
                if (value.isText()) {
                    return value.getTextValue().toString();
                }
                if (value.isList()) {
                    CharSequence[] options = this.getAutofillOptionsFromContextsLocked(id2);
                    if (options != null) {
                        int index = value.getListValue();
                        CharSequence option = options[index];
                        String string2 = option != null ? option.toString() : null;
                        return string2;
                    }
                    Slog.w(TAG, "findByAutofillId(): no autofill options for id " + id2);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutofillValue findRawValueByAutofillId(AutofillId id2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.findValueLocked(id2);
        }
    }

    @GuardedBy(value={"mLock"})
    private AutofillValue findValueLocked(AutofillId autofillId) {
        AutofillValue value = this.findValueFromThisSessionOnlyLocked(autofillId);
        if (value != null) {
            return this.getSanitizedValue(this.createSanitizers(this.getSaveInfoLocked()), autofillId, value);
        }
        ArrayList<Session> previousSessions = this.mService.getPreviousSessionsLocked(this);
        if (previousSessions != null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "findValueLocked(): looking on " + previousSessions.size() + " previous sessions for autofillId " + autofillId);
            }
            for (int i = 0; i < previousSessions.size(); ++i) {
                Session previousSession = previousSessions.get(i);
                AutofillValue previousValue = previousSession.findValueFromThisSessionOnlyLocked(autofillId);
                if (previousValue == null) continue;
                return this.getSanitizedValue(this.createSanitizers(previousSession.getSaveInfoLocked()), autofillId, previousValue);
            }
        }
        return null;
    }

    private AutofillValue findValueFromThisSessionOnlyLocked(AutofillId autofillId) {
        ViewState state = this.mViewStates.get(autofillId);
        if (state == null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "findValueLocked(): no view state for " + autofillId);
            }
            return null;
        }
        AutofillValue value = state.getCurrentValue();
        if (value == null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "findValueLocked(): no current value for " + autofillId);
            }
            value = this.getValueFromContextsLocked(autofillId);
        }
        return value;
    }

    @GuardedBy(value={"mLock"})
    private void fillContextWithAllowedValuesLocked(FillContext fillContext, int flags) {
        AssistStructure.ViewNode[] nodes = fillContext.findViewNodesByAutofillIds(this.getIdsOfAllViewStatesLocked());
        int numViewState = this.mViewStates.size();
        for (int i = 0; i < numViewState; ++i) {
            ViewState viewState = this.mViewStates.valueAt(i);
            AssistStructure.ViewNode node = nodes[i];
            if (node == null) {
                if (!Helper.sVerbose) continue;
                Slog.v(TAG, "fillContextWithAllowedValuesLocked(): no node for " + viewState.id);
                continue;
            }
            AutofillValue currentValue = viewState.getCurrentValue();
            AutofillValue filledValue = viewState.getAutofilledValue();
            AssistStructure.AutofillOverlay overlay = new AssistStructure.AutofillOverlay();
            if (filledValue != null && filledValue.equals(currentValue)) {
                overlay.value = currentValue;
            }
            if (this.mCurrentViewId != null) {
                overlay.focused = this.mCurrentViewId.equals(viewState.id);
                if (overlay.focused && (flags & 1) != 0) {
                    overlay.value = currentValue;
                }
            }
            node.setAutofillOverlay(overlay);
        }
    }

    @GuardedBy(value={"mLock"})
    private void cancelCurrentRequestLocked() {
        if (this.mRemoteFillService == null) {
            this.wtf(null, "cancelCurrentRequestLocked() called without a remote service. mForAugmentedAutofillOnly: %s", this.mForAugmentedAutofillOnly);
            return;
        }
        this.mRemoteFillService.cancelCurrentRequest().whenComplete((canceledRequest, err) -> {
            if (err != null) {
                Slog.e(TAG, "cancelCurrentRequest(): unexpected exception", err);
                return;
            }
            if (canceledRequest != Integer.MIN_VALUE && this.mContexts != null) {
                int numContexts = this.mContexts.size();
                for (int i = numContexts - 1; i >= 0; --i) {
                    if (this.mContexts.get(i).getRequestId() != canceledRequest.intValue()) continue;
                    if (Helper.sDebug) {
                        Slog.d(TAG, "cancelCurrentRequest(): id = " + canceledRequest);
                    }
                    this.mContexts.remove(i);
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void requestNewFillResponseLocked(ViewState viewState, int newState, int flags) {
        int requestId;
        if (this.mForAugmentedAutofillOnly || this.mRemoteFillService == null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "requestNewFillResponse(): triggering augmented autofill instead (mForAugmentedAutofillOnly=" + this.mForAugmentedAutofillOnly + ", flags=" + flags + ")");
            }
            this.mForAugmentedAutofillOnly = true;
            this.triggerAugmentedAutofillLocked();
            return;
        }
        viewState.setState(newState);
        while ((requestId = sIdCounter.getAndIncrement()) == Integer.MIN_VALUE) {
        }
        int ordinal = this.mRequestLogs.size() + 1;
        LogMaker log = this.newLogMaker(907).addTaggedData(1454, ordinal);
        if (flags != 0) {
            log.addTaggedData(1452, flags);
        }
        this.mRequestLogs.put(requestId, log);
        if (Helper.sVerbose) {
            Slog.v(TAG, "Requesting structure for request #" + ordinal + " ,requestId=" + requestId + ", flags=" + flags);
        }
        this.cancelCurrentRequestLocked();
        try {
            Bundle receiverExtras = new Bundle();
            receiverExtras.putInt(EXTRA_REQUEST_ID, requestId);
            long identity = Binder.clearCallingIdentity();
            try {
                if (!ActivityTaskManager.getService().requestAutofillData(this.mAssistReceiver, receiverExtras, this.mActivityToken, flags)) {
                    Slog.w(TAG, "failed to request autofill data for " + this.mActivityToken);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Session(AutofillManagerServiceImpl service, AutoFillUI ui, Context context, Handler handler, int userId, Object lock, int sessionId, int taskId, int uid, IBinder activityToken, IBinder client, boolean hasCallback, LocalLog uiLatencyHistory, LocalLog wtfHistory, ComponentName serviceComponentName, ComponentName componentName, boolean compatMode, boolean bindInstantServiceAllowed, boolean forAugmentedAutofillOnly, int flags) {
        if (sessionId < 0) {
            this.wtf(null, "Non-positive sessionId: %s", sessionId);
        }
        this.id = sessionId;
        this.mFlags = flags;
        this.taskId = taskId;
        this.uid = uid;
        this.mStartTime = SystemClock.elapsedRealtime();
        this.mService = service;
        this.mLock = lock;
        this.mUi = ui;
        this.mHandler = handler;
        this.mRemoteFillService = serviceComponentName == null ? null : new RemoteFillService(context, serviceComponentName, userId, this, bindInstantServiceAllowed);
        this.mActivityToken = activityToken;
        this.mHasCallback = hasCallback;
        this.mUiLatencyHistory = uiLatencyHistory;
        this.mWtfHistory = wtfHistory;
        this.mComponentName = componentName;
        this.mCompatMode = compatMode;
        this.mForAugmentedAutofillOnly = forAugmentedAutofillOnly;
        this.setClientLocked(client);
        this.mMetricsLogger.write(this.newLogMaker(906).addTaggedData(1452, flags));
    }

    @GuardedBy(value={"mLock"})
    IBinder getActivityTokenLocked() {
        return this.mActivityToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchActivity(IBinder newActivity, IBinder newClient) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#switchActivity() rejected - session: " + this.id + " destroyed");
                return;
            }
            this.mActivityToken = newActivity;
            this.setClientLocked(newClient);
            this.updateTrackedIdsLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void setClientLocked(IBinder client) {
        this.unlinkClientVultureLocked();
        this.mClient = IAutoFillManagerClient.Stub.asInterface(client);
        this.mClientVulture = () -> {
            Slog.d(TAG, "handling death of " + this.mActivityToken + " when saving=" + this.mIsSaving);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsSaving) {
                    this.mUi.hideFillUi(this);
                } else {
                    this.mUi.destroyAll(this.mPendingSaveUi, this, false);
                }
            }
        };
        try {
            this.mClient.asBinder().linkToDeath(this.mClientVulture, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "could not set binder death listener on autofill client: " + e);
            this.mClientVulture = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private void unlinkClientVultureLocked() {
        if (this.mClient != null && this.mClientVulture != null) {
            boolean unlinked = this.mClient.asBinder().unlinkToDeath(this.mClientVulture, 0);
            if (!unlinked) {
                Slog.w(TAG, "unlinking vulture from death failed for " + this.mActivityToken);
            }
            this.mClientVulture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillRequestSuccess(int requestId, FillResponse response, String servicePackageName, int requestFlags) {
        AutofillId[] fieldClassificationIds;
        LogMaker requestLog;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillRequestSuccess() rejected - session: " + this.id + " destroyed");
                return;
            }
            requestLog = this.mRequestLogs.get(requestId);
            if (requestLog != null) {
                requestLog.setType(10);
            } else {
                Slog.w(TAG, "onFillRequestSuccess(): no request log for id " + requestId);
            }
            if (response == null) {
                if (requestLog != null) {
                    requestLog.addTaggedData(909, -1);
                }
                this.processNullResponseLocked(requestId, requestFlags);
                return;
            }
            fieldClassificationIds = response.getFieldClassificationIds();
            if (fieldClassificationIds != null && !this.mService.isFieldClassificationEnabledLocked()) {
                Slog.w(TAG, "Ignoring " + response + " because field detection is disabled");
                this.processNullResponseLocked(requestId, requestFlags);
                return;
            }
        }
        this.mService.setLastResponse(this.id, response);
        int sessionFinishedState = 0;
        long disableDuration = response.getDisableDuration();
        if (disableDuration > 0L) {
            int flags = response.getFlags();
            if ((flags & 2) != 0) {
                this.mService.disableAutofillForActivity(this.mComponentName, disableDuration, this.id, this.mCompatMode);
            } else {
                this.mService.disableAutofillForApp(this.mComponentName.getPackageName(), disableDuration, this.id, this.mCompatMode);
            }
            if (this.triggerAugmentedAutofillLocked() != null) {
                this.mForAugmentedAutofillOnly = true;
                if (Helper.sDebug) {
                    Slog.d(TAG, "Service disabled autofill for " + this.mComponentName + ", but session is kept for augmented autofill only");
                }
                return;
            }
            if (Helper.sDebug) {
                StringBuilder message = new StringBuilder("Service disabled autofill for ").append(this.mComponentName).append(": flags=").append(flags).append(", duration=");
                TimeUtils.formatDuration(disableDuration, message);
                Slog.d(TAG, message.toString());
            }
            sessionFinishedState = 4;
        }
        if ((response.getDatasets() == null || response.getDatasets().isEmpty()) && response.getAuthentication() == null || disableDuration > 0L) {
            this.notifyUnavailableToClient(sessionFinishedState, null);
        }
        if (requestLog != null) {
            requestLog.addTaggedData(909, response.getDatasets() == null ? 0 : response.getDatasets().size());
            if (fieldClassificationIds != null) {
                requestLog.addTaggedData(1271, fieldClassificationIds.length);
            }
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            this.processResponseLocked(response, null, requestFlags);
        }
    }

    @Override
    public void onFillRequestFailure(int requestId, CharSequence message) {
        this.onFillRequestFailureOrTimeout(requestId, false, message);
    }

    @Override
    public void onFillRequestTimeout(int requestId) {
        this.onFillRequestFailureOrTimeout(requestId, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFillRequestFailureOrTimeout(int requestId, boolean timedOut, CharSequence message) {
        boolean showMessage = !TextUtils.isEmpty(message);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillRequestFailureOrTimeout(req=" + requestId + ") rejected - session: " + this.id + " destroyed");
                return;
            }
            if (Helper.sDebug) {
                Slog.d(TAG, "finishing session due to service " + (timedOut ? "timeout" : "failure"));
            }
            this.mService.resetLastResponse();
            LogMaker requestLog = this.mRequestLogs.get(requestId);
            if (requestLog == null) {
                Slog.w(TAG, "onFillRequestFailureOrTimeout(): no log for id " + requestId);
            } else {
                requestLog.setType(timedOut ? 2 : 11);
            }
            if (showMessage) {
                int targetSdk = this.mService.getTargedSdkLocked();
                if (targetSdk >= 29) {
                    showMessage = false;
                    Slog.w(TAG, "onFillRequestFailureOrTimeout(): not showing '" + message + "' because service's targetting API " + targetSdk);
                }
                if (message != null) {
                    requestLog.addTaggedData(1572, message.length());
                }
            }
        }
        this.notifyUnavailableToClient(6, null);
        if (showMessage) {
            this.getUiForShowing().showError(message, (AutoFillUI.AutoFillUiCallback)this);
        }
        this.removeSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveRequestSuccess(String servicePackageName, IntentSender intentSender) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onSaveRequestSuccess() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        LogMaker log = this.newLogMaker(918, servicePackageName).setType(intentSender == null ? 10 : 1);
        this.mMetricsLogger.write(log);
        if (intentSender != null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Starting intent sender on save()");
            }
            this.startIntentSender(intentSender);
        }
        this.removeSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveRequestFailure(CharSequence message, String servicePackageName) {
        boolean showMessage = !TextUtils.isEmpty(message);
        Object object = this.mLock;
        synchronized (object) {
            int targetSdk;
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onSaveRequestFailure() rejected - session: " + this.id + " destroyed");
                return;
            }
            if (showMessage && (targetSdk = this.mService.getTargedSdkLocked()) >= 29) {
                showMessage = false;
                Slog.w(TAG, "onSaveRequestFailure(): not showing '" + message + "' because service's targetting API " + targetSdk);
            }
        }
        LogMaker log = this.newLogMaker(918, servicePackageName).setType(11);
        if (message != null) {
            log.addTaggedData(1572, message.length());
        }
        this.mMetricsLogger.write(log);
        if (showMessage) {
            this.getUiForShowing().showError(message, (AutoFillUI.AutoFillUiCallback)this);
        }
        this.removeSelf();
    }

    @GuardedBy(value={"mLock"})
    private FillContext getFillContextByRequestIdLocked(int requestId) {
        if (this.mContexts == null) {
            return null;
        }
        int numContexts = this.mContexts.size();
        for (int i = 0; i < numContexts; ++i) {
            FillContext context = this.mContexts.get(i);
            if (context.getRequestId() != requestId) continue;
            return context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(int requestId, int datasetIndex, IntentSender intent, Bundle extras) {
        Intent fillInIntent;
        if (Helper.sDebug) {
            Slog.d(TAG, "authenticate(): requestId=" + requestId + "; datasetIdx=" + datasetIndex + "; intentSender=" + intent);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#authenticate() rejected - session: " + this.id + " destroyed");
                return;
            }
            fillInIntent = this.createAuthFillInIntentLocked(requestId, extras);
            if (fillInIntent == null) {
                this.forceRemoveSelfLocked();
                return;
            }
        }
        this.mService.setAuthenticationSelected(this.id, this.mClientState);
        int authenticationId = AutofillManager.makeAuthenticationId(requestId, datasetIndex);
        this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::startAuthentication, this, authenticationId, intent, fillInIntent));
    }

    @Override
    public void onServiceDied(RemoteFillService service) {
        Slog.w(TAG, "removing session because service died");
        this.forceRemoveSelfLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(int requestId, int datasetIndex, Dataset dataset) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#fill() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::autoFill, this, requestId, datasetIndex, dataset, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#save() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AutofillManagerServiceImpl::handleSessionSave, this.mService, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSave() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#cancelSave() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::removeSelf, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestShowFillUi(AutofillId id2, int width, int height, IAutofillWindowPresenter presenter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#requestShowFillUi() rejected - session: " + id2 + " destroyed");
                return;
            }
            if (id2.equals(this.mCurrentViewId)) {
                try {
                    ViewState view = this.mViewStates.get(id2);
                    this.mClient.requestShowFillUi(this.id, id2, width, height, view.getVirtualBounds(), presenter);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Error requesting to show fill UI", e);
                }
            } else if (Helper.sDebug) {
                Slog.d(TAG, "Do not show full UI on " + id2 + " as it is not the current view (" + this.mCurrentViewId + ") anymore");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchUnhandledKey(AutofillId id2, KeyEvent keyEvent) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#dispatchUnhandledKey() rejected - session: " + id2 + " destroyed");
                return;
            }
            if (id2.equals(this.mCurrentViewId)) {
                try {
                    this.mClient.dispatchUnhandledKey(this.id, id2, keyEvent);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Error requesting to dispatch unhandled key", e);
                }
            } else {
                Slog.w(TAG, "Do not dispatch unhandled key on " + id2 + " as it is not the current view (" + this.mCurrentViewId + ") anymore");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestHideFillUi(AutofillId id2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mClient.requestHideFillUi(this.id, id2);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error requesting to hide fill UI", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startIntentSender(IntentSender intentSender) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#startIntentSender() rejected - session: " + this.id + " destroyed");
                return;
            }
            this.removeSelfLocked();
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::doStartIntentSender, this, intentSender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartIntentSender(IntentSender intentSender) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mClient.startIntentSender(intentSender, null);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error launching auth intent", e);
        }
    }

    @GuardedBy(value={"mLock"})
    void setAuthenticationResultLocked(Bundle data, int authenticationId) {
        Dataset dataset;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#setAuthenticationResultLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (this.mResponses == null) {
            Slog.w(TAG, "setAuthenticationResultLocked(" + authenticationId + "): no responses");
            this.removeSelf();
            return;
        }
        int requestId = AutofillManager.getRequestIdFromAuthenticationId(authenticationId);
        FillResponse authenticatedResponse = this.mResponses.get(requestId);
        if (authenticatedResponse == null || data == null) {
            Slog.w(TAG, "no authenticated response");
            this.removeSelf();
            return;
        }
        int datasetIdx = AutofillManager.getDatasetIdFromAuthenticationId(authenticationId);
        if (datasetIdx != 65535 && (dataset = authenticatedResponse.getDatasets().get(datasetIdx)) == null) {
            Slog.w(TAG, "no dataset with index " + datasetIdx + " on fill response");
            this.removeSelf();
            return;
        }
        Object result = data.getParcelable("android.view.autofill.extra.AUTHENTICATION_RESULT");
        Bundle newClientState = data.getBundle("android.view.autofill.extra.CLIENT_STATE");
        if (Helper.sDebug) {
            Slog.d(TAG, "setAuthenticationResultLocked(): result=" + result + ", clientState=" + newClientState + ", authenticationId=" + authenticationId);
        }
        if (result instanceof FillResponse) {
            this.logAuthenticationStatusLocked(requestId, 912);
            this.replaceResponseLocked(authenticatedResponse, (FillResponse)result, newClientState);
        } else if (result instanceof Dataset) {
            if (datasetIdx != 65535) {
                this.logAuthenticationStatusLocked(requestId, 1126);
                if (newClientState != null) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "Updating client state from auth dataset");
                    }
                    this.mClientState = newClientState;
                }
                Dataset dataset2 = (Dataset)result;
                authenticatedResponse.getDatasets().set(datasetIdx, dataset2);
                this.autoFill(requestId, datasetIdx, dataset2, false);
            } else {
                Slog.w(TAG, "invalid index (" + datasetIdx + ") for authentication id " + authenticationId);
                this.logAuthenticationStatusLocked(requestId, 1127);
            }
        } else {
            if (result != null) {
                Slog.w(TAG, "service returned invalid auth type: " + result);
            }
            this.logAuthenticationStatusLocked(requestId, 1128);
            this.processNullResponseLocked(requestId, 0);
        }
    }

    @GuardedBy(value={"mLock"})
    void setHasCallbackLocked(boolean hasIt) {
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#setHasCallbackLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        this.mHasCallback = hasIt;
    }

    @GuardedBy(value={"mLock"})
    private FillResponse getLastResponseLocked(String logPrefixFmt) {
        String logPrefix;
        String string2 = logPrefix = Helper.sDebug && logPrefixFmt != null ? String.format(logPrefixFmt, this.id) : null;
        if (this.mContexts == null) {
            if (logPrefix != null) {
                Slog.d(TAG, logPrefix + ": no contexts");
            }
            return null;
        }
        if (this.mResponses == null) {
            if (Helper.sVerbose && logPrefix != null) {
                Slog.v(TAG, logPrefix + ": no responses on session");
            }
            return null;
        }
        int lastResponseIdx = this.getLastResponseIndexLocked();
        if (lastResponseIdx < 0) {
            if (logPrefix != null) {
                Slog.w(TAG, logPrefix + ": did not get last response. mResponses=" + this.mResponses + ", mViewStates=" + this.mViewStates);
            }
            return null;
        }
        FillResponse response = this.mResponses.valueAt(lastResponseIdx);
        if (Helper.sVerbose && logPrefix != null) {
            Slog.v(TAG, logPrefix + ": mResponses=" + this.mResponses + ", mContexts=" + this.mContexts + ", mViewStates=" + this.mViewStates);
        }
        return response;
    }

    @GuardedBy(value={"mLock"})
    private SaveInfo getSaveInfoLocked() {
        FillResponse response = this.getLastResponseLocked(null);
        return response == null ? null : response.getSaveInfo();
    }

    @GuardedBy(value={"mLock"})
    int getSaveInfoFlagsLocked() {
        SaveInfo saveInfo = this.getSaveInfoLocked();
        return saveInfo == null ? 0 : saveInfo.getFlags();
    }

    public void logContextCommitted() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::handleLogContextCommitted, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogContextCommitted() {
        FillResponse lastResponse;
        Object object = this.mLock;
        synchronized (object) {
            lastResponse = this.getLastResponseLocked("logContextCommited(%s)");
        }
        if (lastResponse == null) {
            Slog.w(TAG, "handleLogContextCommitted(): last response is null");
            return;
        }
        UserData genericUserData = this.mService.getUserData();
        UserData packageUserData = lastResponse.getUserData();
        Parcelable userData = packageUserData == null && genericUserData == null ? null : (packageUserData != null && genericUserData != null ? new CompositeUserData(genericUserData, packageUserData) : (packageUserData != null ? packageUserData : this.mService.getUserData()));
        FieldClassificationStrategy fcStrategy = this.mService.getFieldClassificationStrategy();
        if (userData != null && fcStrategy != null) {
            this.logFieldClassificationScore(fcStrategy, (FieldClassificationUserData)((Object)userData));
        } else {
            this.logContextCommitted(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContextCommitted(ArrayList<AutofillId> detectedFieldIds, ArrayList<FieldClassification> detectedFieldClassifications) {
        Object object = this.mLock;
        synchronized (object) {
            this.logContextCommittedLocked(detectedFieldIds, detectedFieldClassifications);
        }
    }

    @GuardedBy(value={"mLock"})
    private void logContextCommittedLocked(ArrayList<AutofillId> detectedFieldIds, ArrayList<FieldClassification> detectedFieldClassifications) {
        FillResponse lastResponse = this.getLastResponseLocked("logContextCommited(%s)");
        if (lastResponse == null) {
            return;
        }
        int flags = lastResponse.getFlags();
        if ((flags & 1) == 0) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "logContextCommittedLocked(): ignored by flags " + flags);
            }
            return;
        }
        ArraySet<String> ignoredDatasets = null;
        ArrayList<AutofillId> changedFieldIds = null;
        ArrayList<String> changedDatasetIds = null;
        ArrayMap<AutofillId, ArraySet<String>> manuallyFilledIds = null;
        boolean hasAtLeastOneDataset = false;
        int responseCount = this.mResponses.size();
        for (int i = 0; i < responseCount; ++i) {
            FillResponse response = this.mResponses.valueAt(i);
            List<Dataset> datasets = response.getDatasets();
            if (datasets == null || datasets.isEmpty()) {
                if (!Helper.sVerbose) continue;
                Slog.v(TAG, "logContextCommitted() no datasets at " + i);
                continue;
            }
            for (int j = 0; j < datasets.size(); ++j) {
                Dataset dataset = datasets.get(j);
                String datasetId = dataset.getId();
                if (datasetId == null) {
                    if (!Helper.sVerbose) continue;
                    Slog.v(TAG, "logContextCommitted() skipping idless dataset " + dataset);
                    continue;
                }
                hasAtLeastOneDataset = true;
                if (this.mSelectedDatasetIds != null && this.mSelectedDatasetIds.contains(datasetId)) continue;
                if (Helper.sVerbose) {
                    Slog.v(TAG, "adding ignored dataset " + datasetId);
                }
                if (ignoredDatasets == null) {
                    ignoredDatasets = new ArraySet<String>();
                }
                ignoredDatasets.add(datasetId);
            }
        }
        AutofillId[] fieldClassificationIds = lastResponse.getFieldClassificationIds();
        if (!hasAtLeastOneDataset && fieldClassificationIds == null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "logContextCommittedLocked(): skipped (no datasets nor fields classification ids)");
            }
            return;
        }
        for (int i = 0; i < this.mViewStates.size(); ++i) {
            ViewState viewState = this.mViewStates.valueAt(i);
            int state = viewState.getState();
            if ((state & 8) == 0) continue;
            if ((state & 0x800) != 0) {
                String datasetId = viewState.getDatasetId();
                if (datasetId == null) {
                    Slog.w(TAG, "logContextCommitted(): no dataset id on " + viewState);
                    continue;
                }
                AutofillValue autofilledValue = viewState.getAutofilledValue();
                AutofillValue currentValue = viewState.getCurrentValue();
                if (autofilledValue != null && autofilledValue.equals(currentValue)) {
                    if (!Helper.sDebug) continue;
                    Slog.d(TAG, "logContextCommitted(): ignoring changed " + viewState + " because it has same value that was autofilled");
                    continue;
                }
                if (Helper.sDebug) {
                    Slog.d(TAG, "logContextCommitted() found changed state: " + viewState);
                }
                if (changedFieldIds == null) {
                    changedFieldIds = new ArrayList<AutofillId>();
                    changedDatasetIds = new ArrayList<String>();
                }
                changedFieldIds.add(viewState.id);
                changedDatasetIds.add(datasetId);
                continue;
            }
            AutofillValue currentValue = viewState.getCurrentValue();
            if (currentValue == null) {
                if (!Helper.sDebug) continue;
                Slog.d(TAG, "logContextCommitted(): skipping view without current value ( " + viewState + ")");
                continue;
            }
            if (!hasAtLeastOneDataset) continue;
            for (int j = 0; j < responseCount; ++j) {
                FillResponse response = this.mResponses.valueAt(j);
                List<Dataset> datasets = response.getDatasets();
                if (datasets == null || datasets.isEmpty()) {
                    if (!Helper.sVerbose) continue;
                    Slog.v(TAG, "logContextCommitted() no datasets at " + j);
                    continue;
                }
                for (int k = 0; k < datasets.size(); ++k) {
                    Dataset dataset = datasets.get(k);
                    String datasetId = dataset.getId();
                    if (datasetId == null) {
                        if (!Helper.sVerbose) continue;
                        Slog.v(TAG, "logContextCommitted() skipping idless dataset " + dataset);
                        continue;
                    }
                    ArrayList<AutofillValue> values = dataset.getFieldValues();
                    for (int l = 0; l < values.size(); ++l) {
                        ArraySet<String> datasetIds;
                        AutofillValue candidate = values.get(l);
                        if (!currentValue.equals(candidate)) continue;
                        if (Helper.sDebug) {
                            Slog.d(TAG, "field " + viewState.id + " was manually filled with value set by dataset " + datasetId);
                        }
                        if (manuallyFilledIds == null) {
                            manuallyFilledIds = new ArrayMap<AutofillId, ArraySet<String>>();
                        }
                        if ((datasetIds = (ArraySet<String>)manuallyFilledIds.get(viewState.id)) == null) {
                            datasetIds = new ArraySet<String>(1);
                            manuallyFilledIds.put(viewState.id, datasetIds);
                        }
                        datasetIds.add(datasetId);
                    }
                    if (this.mSelectedDatasetIds != null && this.mSelectedDatasetIds.contains(datasetId)) continue;
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "adding ignored dataset " + datasetId);
                    }
                    if (ignoredDatasets == null) {
                        ignoredDatasets = new ArraySet();
                    }
                    ignoredDatasets.add(datasetId);
                }
            }
        }
        ArrayList<AutofillId> manuallyFilledFieldIds = null;
        ArrayList<ArrayList<String>> manuallyFilledDatasetIds = null;
        if (manuallyFilledIds != null) {
            int size = manuallyFilledIds.size();
            manuallyFilledFieldIds = new ArrayList<AutofillId>(size);
            manuallyFilledDatasetIds = new ArrayList<ArrayList<String>>(size);
            for (int i = 0; i < size; ++i) {
                AutofillId fieldId = (AutofillId)manuallyFilledIds.keyAt(i);
                ArraySet datasetIds = (ArraySet)manuallyFilledIds.valueAt(i);
                manuallyFilledFieldIds.add(fieldId);
                manuallyFilledDatasetIds.add(new ArrayList(datasetIds));
            }
        }
        this.mService.logContextCommittedLocked(this.id, this.mClientState, this.mSelectedDatasetIds, ignoredDatasets, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, detectedFieldIds, detectedFieldClassifications, this.mComponentName, this.mCompatMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFieldClassificationScore(FieldClassificationStrategy fcStrategy, FieldClassificationUserData userData) {
        Collection<ViewState> viewStates;
        String[] userValues = userData.getValues();
        String[] categoryIds = userData.getCategoryIds();
        String defaultAlgorithm = userData.getFieldClassificationAlgorithm();
        Bundle defaultArgs = userData.getDefaultFieldClassificationArgs();
        ArrayMap<String, String> algorithms = userData.getFieldClassificationAlgorithms();
        ArrayMap<String, Bundle> args = userData.getFieldClassificationArgs();
        if (userValues == null || categoryIds == null || userValues.length != categoryIds.length) {
            int valuesLength = userValues == null ? -1 : userValues.length;
            int idsLength = categoryIds == null ? -1 : categoryIds.length;
            Slog.w(TAG, "setScores(): user data mismatch: values.length = " + valuesLength + ", ids.length = " + idsLength);
            return;
        }
        int maxFieldsSize = UserData.getMaxFieldClassificationIdsSize();
        ArrayList detectedFieldIds = new ArrayList(maxFieldsSize);
        ArrayList detectedFieldClassifications = new ArrayList(maxFieldsSize);
        Object object = this.mLock;
        synchronized (object) {
            viewStates = this.mViewStates.values();
        }
        int viewsSize = viewStates.size();
        AutofillId[] autofillIds = new AutofillId[viewsSize];
        ArrayList<AutofillValue> currentValues = new ArrayList<AutofillValue>(viewsSize);
        int k = 0;
        for (ViewState viewState : viewStates) {
            currentValues.add(viewState.getCurrentValue());
            autofillIds[k++] = viewState.id;
        }
        RemoteCallback callback = new RemoteCallback(result -> {
            if (result == null) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "setFieldClassificationScore(): no results");
                }
                this.logContextCommitted(null, null);
                return;
            }
            AutofillFieldClassificationService.Scores scores = (AutofillFieldClassificationService.Scores)result.getParcelable("scores");
            if (scores == null) {
                Slog.w(TAG, "No field classification score on " + result);
                return;
            }
            int i = 0;
            int j = 0;
            try {
                for (i = 0; i < viewsSize; ++i) {
                    AutofillId autofillId = autofillIds[i];
                    ArrayMap<String, Float> scoresByField = null;
                    for (j = 0; j < userValues.length; ++j) {
                        String categoryId = categoryIds[j];
                        float score = scores.scores[i][j];
                        if (score > 0.0f) {
                            Float currentScore;
                            if (scoresByField == null) {
                                scoresByField = new ArrayMap<String, Float>(userValues.length);
                            }
                            if ((currentScore = (Float)scoresByField.get(categoryId)) != null && currentScore.floatValue() > score) {
                                if (!Helper.sVerbose) continue;
                                Slog.v(TAG, "skipping score " + score + " because it's less than " + currentScore);
                                continue;
                            }
                            if (Helper.sVerbose) {
                                Slog.v(TAG, "adding score " + score + " at index " + j + " and id " + autofillId);
                            }
                            scoresByField.put(categoryId, Float.valueOf(score));
                            continue;
                        }
                        if (!Helper.sVerbose) continue;
                        Slog.v(TAG, "skipping score 0 at index " + j + " and id " + autofillId);
                    }
                    if (scoresByField == null) {
                        if (!Helper.sVerbose) continue;
                        Slog.v(TAG, "no score for autofillId=" + autofillId);
                        continue;
                    }
                    ArrayList<FieldClassification.Match> matches = new ArrayList<FieldClassification.Match>(scoresByField.size());
                    for (j = 0; j < scoresByField.size(); ++j) {
                        String fieldId = (String)scoresByField.keyAt(j);
                        float score = ((Float)scoresByField.valueAt(j)).floatValue();
                        matches.add(new FieldClassification.Match(fieldId, score));
                    }
                    detectedFieldIds.add(autofillId);
                    detectedFieldClassifications.add(new FieldClassification(matches));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.wtf(e, "Error accessing FC score at [%d, %d] (%s): %s", i, j, scores, e);
                return;
            }
            this.logContextCommitted(detectedFieldIds, detectedFieldClassifications);
        });
        fcStrategy.calculateScores(callback, currentValues, userValues, categoryIds, defaultAlgorithm, defaultArgs, algorithms, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    public boolean showSaveLocked() {
        AutofillValue initialValue;
        SaveInfo saveInfo;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#showSaveLocked() rejected - session: " + this.id + " destroyed");
            return false;
        }
        FillResponse response = this.getLastResponseLocked("showSaveLocked(%s)");
        SaveInfo saveInfo2 = saveInfo = response == null ? null : response.getSaveInfo();
        if (saveInfo == null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "showSaveLocked(" + this.id + "): no saveInfo from service");
            }
            return true;
        }
        if ((saveInfo.getFlags() & 4) != 0) {
            if (Helper.sDebug) {
                Slog.v(TAG, "showSaveLocked(" + this.id + "): service asked to delay save");
            }
            return false;
        }
        ArrayMap<AutofillId, InternalSanitizer> sanitizers = this.createSanitizers(saveInfo);
        ArrayMap<AutofillId, AutofillValue> currentValues = new ArrayMap<AutofillId, AutofillValue>();
        ArraySet<AutofillId> savableIds = new ArraySet<AutofillId>();
        Object[] requiredIds = saveInfo.getRequiredIds();
        boolean allRequiredAreNotEmpty = true;
        boolean atLeastOneChanged = false;
        boolean isUpdate = false;
        if (requiredIds != null) {
            for (int i = 0; i < requiredIds.length; ++i) {
                AutofillId id2 = requiredIds[i];
                if (id2 == null) {
                    Slog.w(TAG, "null autofill id on " + Arrays.toString(requiredIds));
                    continue;
                }
                savableIds.add(id2);
                ViewState viewState = this.mViewStates.get(id2);
                if (viewState == null) {
                    Slog.w(TAG, "showSaveLocked(): no ViewState for required " + id2);
                    allRequiredAreNotEmpty = false;
                    break;
                }
                AutofillValue value = viewState.getCurrentValue();
                if (value == null || value.isEmpty()) {
                    initialValue = this.getValueFromContextsLocked(id2);
                    if (initialValue != null) {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "Value of required field " + id2 + " didn't change; using initial value (" + initialValue + ") instead");
                        }
                        value = initialValue;
                    } else {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "empty value for required " + id2);
                        }
                        allRequiredAreNotEmpty = false;
                        break;
                    }
                }
                if ((value = this.getSanitizedValue(sanitizers, id2, value)) == null) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "value of required field " + id2 + " failed sanitization");
                    }
                    allRequiredAreNotEmpty = false;
                    break;
                }
                viewState.setSanitizedValue(value);
                currentValues.put(id2, value);
                AutofillValue filledValue = viewState.getAutofilledValue();
                if (value.equals(filledValue)) continue;
                boolean changed = true;
                if (filledValue == null) {
                    AutofillValue initialValue2 = this.getValueFromContextsLocked(id2);
                    if (initialValue2 != null && initialValue2.equals(value)) {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "id " + id2 + " is part of dataset but initial value didn't change: " + value);
                        }
                        changed = false;
                    }
                } else {
                    isUpdate = true;
                }
                if (!changed) continue;
                if (Helper.sDebug) {
                    Slog.d(TAG, "found a change on required " + id2 + ": " + filledValue + " => " + value);
                }
                atLeastOneChanged = true;
            }
        }
        AutofillId[] optionalIds = saveInfo.getOptionalIds();
        if (Helper.sVerbose) {
            Slog.v(TAG, "allRequiredAreNotEmpty: " + allRequiredAreNotEmpty + " hasOptional: " + (optionalIds != null));
        }
        if (allRequiredAreNotEmpty) {
            if (!(optionalIds == null || atLeastOneChanged && isUpdate)) {
                for (int i = 0; i < optionalIds.length; ++i) {
                    AutofillId id3 = optionalIds[i];
                    savableIds.add(id3);
                    ViewState viewState = this.mViewStates.get(id3);
                    if (viewState == null) {
                        Slog.w(TAG, "no ViewState for optional " + id3);
                        continue;
                    }
                    if ((viewState.getState() & 8) != 0) {
                        AutofillValue currentValue = viewState.getCurrentValue();
                        AutofillValue value = this.getSanitizedValue(sanitizers, id3, currentValue);
                        if (value == null) {
                            if (!Helper.sDebug) continue;
                            Slog.d(TAG, "value of opt. field " + id3 + " failed sanitization");
                            continue;
                        }
                        currentValues.put(id3, value);
                        AutofillValue filledValue = viewState.getAutofilledValue();
                        if (value == null || value.equals(filledValue)) continue;
                        if (Helper.sDebug) {
                            Slog.d(TAG, "found a change on optional " + id3 + ": " + filledValue + " => " + value);
                        }
                        if (filledValue != null) {
                            isUpdate = true;
                        }
                        atLeastOneChanged = true;
                        continue;
                    }
                    initialValue = this.getValueFromContextsLocked(id3);
                    if (Helper.sDebug) {
                        Slog.d(TAG, "no current value for " + id3 + "; initial value is " + initialValue);
                    }
                    if (initialValue == null) continue;
                    currentValues.put(id3, initialValue);
                }
            }
            if (atLeastOneChanged) {
                Drawable serviceIcon;
                CharSequence serviceLabel;
                List<Dataset> datasets;
                InternalValidator validator;
                if (Helper.sDebug) {
                    Slog.d(TAG, "at least one field changed, validate fields for save UI");
                }
                if ((validator = saveInfo.getValidator()) != null) {
                    boolean isValid;
                    LogMaker log = this.newLogMaker(1133);
                    try {
                        isValid = validator.isValid(this);
                        if (Helper.sDebug) {
                            Slog.d(TAG, validator + " returned " + isValid);
                        }
                        log.setType(isValid ? 10 : 5);
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Not showing save UI because validation failed:", e);
                        log.setType(11);
                        this.mMetricsLogger.write(log);
                        return true;
                    }
                    this.mMetricsLogger.write(log);
                    if (!isValid) {
                        Slog.i(TAG, "not showing save UI because fields failed validation");
                        return true;
                    }
                }
                if ((datasets = response.getDatasets()) != null) {
                    block9: for (int i = 0; i < datasets.size(); ++i) {
                        Dataset dataset = datasets.get(i);
                        ArrayMap<AutofillId, AutofillValue> datasetValues = Helper.getFields(dataset);
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "Checking if saved fields match contents of dataset #" + i + ": " + dataset + "; savableIds=" + savableIds);
                        }
                        for (int j = 0; j < savableIds.size(); ++j) {
                            AutofillId id4 = (AutofillId)savableIds.valueAt(j);
                            AutofillValue currentValue = (AutofillValue)currentValues.get(id4);
                            if (currentValue == null) {
                                if (!Helper.sDebug) continue;
                                Slog.d(TAG, "dataset has value for field that is null: " + id4);
                                continue;
                            }
                            AutofillValue datasetValue = datasetValues.get(id4);
                            if (!currentValue.equals(datasetValue)) {
                                if (!Helper.sDebug) continue block9;
                                Slog.d(TAG, "found a dataset change on id " + id4 + ": from " + datasetValue + " to " + currentValue);
                                continue block9;
                            }
                            if (!Helper.sVerbose) continue;
                            Slog.v(TAG, "no dataset changes for id " + id4);
                        }
                        if (Helper.sDebug) {
                            Slog.d(TAG, "ignoring Save UI because all fields match contents of dataset #" + i + ": " + dataset);
                        }
                        return true;
                    }
                }
                if (Helper.sDebug) {
                    Slog.d(TAG, "Good news, everyone! All checks passed, show save UI for " + this.id + "!");
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(Session::logSaveShown, this));
                IAutoFillManagerClient client = this.getClient();
                this.mPendingSaveUi = new PendingUi(this.mActivityToken, this.id, client);
                Object j = this.mLock;
                synchronized (j) {
                    serviceLabel = this.mService.getServiceLabelLocked();
                    serviceIcon = this.mService.getServiceIconLocked();
                }
                if (serviceLabel == null || serviceIcon == null) {
                    this.wtf(null, "showSaveLocked(): no service label or icon", new Object[0]);
                    return true;
                }
                this.getUiForShowing().showSaveUi(serviceLabel, serviceIcon, this.mService.getServicePackageName(), saveInfo, this, this.mComponentName, this, this.mPendingSaveUi, isUpdate, this.mCompatMode);
                if (client != null) {
                    try {
                        client.setSaveUiState(this.id, true);
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Error notifying client to set save UI state to shown: " + e);
                    }
                }
                this.mIsSaving = true;
                return false;
            }
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "showSaveLocked(" + this.id + "): with no changes, comes no responsibilities.allRequiredAreNotNull=" + allRequiredAreNotEmpty + ", atLeastOneChanged=" + atLeastOneChanged);
        }
        return true;
    }

    private void logSaveShown() {
        this.mService.logSaveShown(this.id, this.mClientState);
    }

    private ArrayMap<AutofillId, InternalSanitizer> createSanitizers(SaveInfo saveInfo) {
        if (saveInfo == null) {
            return null;
        }
        InternalSanitizer[] sanitizerKeys = saveInfo.getSanitizerKeys();
        if (sanitizerKeys == null) {
            return null;
        }
        int size = sanitizerKeys.length;
        ArrayMap<AutofillId, InternalSanitizer> sanitizers = new ArrayMap<AutofillId, InternalSanitizer>(size);
        if (Helper.sDebug) {
            Slog.d(TAG, "Service provided " + size + " sanitizers");
        }
        AutofillId[][] sanitizerValues = saveInfo.getSanitizerValues();
        for (int i = 0; i < size; ++i) {
            InternalSanitizer sanitizer = sanitizerKeys[i];
            Object[] ids = sanitizerValues[i];
            if (Helper.sDebug) {
                Slog.d(TAG, "sanitizer #" + i + " (" + sanitizer + ") for ids " + Arrays.toString(ids));
            }
            for (AutofillId autofillId : ids) {
                sanitizers.put(autofillId, sanitizer);
            }
        }
        return sanitizers;
    }

    private AutofillValue getSanitizedValue(ArrayMap<AutofillId, InternalSanitizer> sanitizers, AutofillId id2, AutofillValue value) {
        AutofillValue sanitized;
        if (sanitizers == null || value == null) {
            return value;
        }
        ViewState state = this.mViewStates.get(id2);
        AutofillValue autofillValue = sanitized = state == null ? null : state.getSanitizedValue();
        if (sanitized == null) {
            InternalSanitizer sanitizer = sanitizers.get(id2);
            if (sanitizer == null) {
                return value;
            }
            sanitized = sanitizer.sanitize(value);
            if (Helper.sDebug) {
                Slog.d(TAG, "Value for " + id2 + "(" + value + ") sanitized to " + sanitized);
            }
            if (state != null) {
                state.setSanitizedValue(sanitized);
            }
        }
        return sanitized;
    }

    @GuardedBy(value={"mLock"})
    boolean isSavingLocked() {
        return this.mIsSaving;
    }

    @GuardedBy(value={"mLock"})
    private AutofillValue getValueFromContextsLocked(AutofillId autofillId) {
        int numContexts = this.mContexts.size();
        for (int i = numContexts - 1; i >= 0; --i) {
            FillContext context = this.mContexts.get(i);
            AssistStructure.ViewNode node = Helper.findViewNodeByAutofillId(context.getStructure(), autofillId);
            if (node == null) continue;
            AutofillValue value = node.getAutofillValue();
            if (Helper.sDebug) {
                Slog.d(TAG, "getValueFromContexts(" + this.id + "/" + autofillId + ") at " + i + ": " + value);
            }
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return null;
    }

    @GuardedBy(value={"mLock"})
    private CharSequence[] getAutofillOptionsFromContextsLocked(AutofillId id2) {
        int numContexts = this.mContexts.size();
        for (int i = numContexts - 1; i >= 0; --i) {
            FillContext context = this.mContexts.get(i);
            AssistStructure.ViewNode node = Helper.findViewNodeByAutofillId(context.getStructure(), id2);
            if (node == null || node.getAutofillOptions() == null) continue;
            return node.getAutofillOptions();
        }
        return null;
    }

    private void updateValuesForSaveLocked() {
        ArrayMap<AutofillId, InternalSanitizer> sanitizers = this.createSanitizers(this.getSaveInfoLocked());
        int numContexts = this.mContexts.size();
        for (int contextNum = 0; contextNum < numContexts; ++contextNum) {
            FillContext context = this.mContexts.get(contextNum);
            AssistStructure.ViewNode[] nodes = context.findViewNodesByAutofillIds(this.getIdsOfAllViewStatesLocked());
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateValuesForSaveLocked(): updating " + context);
            }
            for (int viewStateNum = 0; viewStateNum < this.mViewStates.size(); ++viewStateNum) {
                AutofillValue sanitizedValue;
                ViewState viewState = this.mViewStates.valueAt(viewStateNum);
                AutofillId id2 = viewState.id;
                AutofillValue value = viewState.getCurrentValue();
                if (value == null) {
                    if (!Helper.sVerbose) continue;
                    Slog.v(TAG, "updateValuesForSaveLocked(): skipping " + id2);
                    continue;
                }
                AssistStructure.ViewNode node = nodes[viewStateNum];
                if (node == null) {
                    Slog.w(TAG, "callSaveLocked(): did not find node with id " + id2);
                    continue;
                }
                if (Helper.sVerbose) {
                    Slog.v(TAG, "updateValuesForSaveLocked(): updating " + id2 + " to " + value);
                }
                if ((sanitizedValue = viewState.getSanitizedValue()) == null) {
                    sanitizedValue = this.getSanitizedValue(sanitizers, id2, value);
                }
                if (sanitizedValue != null) {
                    node.updateAutofillValue(sanitizedValue);
                    continue;
                }
                if (!Helper.sDebug) continue;
                Slog.d(TAG, "updateValuesForSaveLocked(): not updating field " + id2 + " because it failed sanitization");
            }
            context.getStructure().sanitizeForParceling(false);
            if (!Helper.sVerbose) continue;
            Slog.v(TAG, "updateValuesForSaveLocked(): dumping structure of " + context + " before calling service.save()");
            context.getStructure().dump(false);
        }
    }

    @GuardedBy(value={"mLock"})
    void callSaveLocked() {
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#callSaveLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (this.mRemoteFillService == null) {
            this.wtf(null, "callSaveLocked() called without a remote service. mForAugmentedAutofillOnly: %s", this.mForAugmentedAutofillOnly);
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "callSaveLocked(" + this.id + "): mViewStates=" + this.mViewStates);
        }
        if (this.mContexts == null) {
            Slog.w(TAG, "callSaveLocked(): no contexts");
            return;
        }
        this.updateValuesForSaveLocked();
        this.cancelCurrentRequestLocked();
        ArrayList<FillContext> contexts = this.mergePreviousSessionLocked(true);
        SaveRequest saveRequest = new SaveRequest(contexts, this.mClientState, this.mSelectedDatasetIds);
        this.mRemoteFillService.onSaveRequest(saveRequest);
    }

    private ArrayList<FillContext> mergePreviousSessionLocked(boolean forSave) {
        ArrayList<FillContext> contexts;
        ArrayList<Session> previousSessions = this.mService.getPreviousSessionsLocked(this);
        if (previousSessions != null) {
            if (Helper.sDebug) {
                Slog.d(TAG, "mergeSessions(" + this.id + "): Merging the content of " + previousSessions.size() + " sessions for task " + this.taskId);
            }
            contexts = new ArrayList();
            for (int i = 0; i < previousSessions.size(); ++i) {
                Session previousSession = previousSessions.get(i);
                ArrayList<FillContext> previousContexts = previousSession.mContexts;
                if (previousContexts == null) {
                    Slog.w(TAG, "mergeSessions(" + this.id + "): Not merging null contexts from " + previousSession.id);
                    continue;
                }
                if (forSave) {
                    previousSession.updateValuesForSaveLocked();
                }
                if (Helper.sDebug) {
                    Slog.d(TAG, "mergeSessions(" + this.id + "): adding " + previousContexts.size() + " context from previous session #" + previousSession.id);
                }
                contexts.addAll(previousContexts);
                if (this.mClientState != null || previousSession.mClientState == null) continue;
                if (Helper.sDebug) {
                    Slog.d(TAG, "mergeSessions(" + this.id + "): setting client state from previous session" + previousSession.id);
                }
                this.mClientState = previousSession.mClientState;
            }
            contexts.addAll(this.mContexts);
        } else {
            contexts = new ArrayList<FillContext>(this.mContexts);
        }
        return contexts;
    }

    @GuardedBy(value={"mLock"})
    private void requestNewFillResponseOnViewEnteredIfNecessaryLocked(AutofillId id2, ViewState viewState, int flags) {
        if ((flags & 1) != 0) {
            this.mForAugmentedAutofillOnly = false;
            if (Helper.sDebug) {
                Slog.d(TAG, "Re-starting session on view " + id2 + " and flags " + flags);
            }
            this.requestNewFillResponseLocked(viewState, 256, flags);
            return;
        }
        if (this.shouldStartNewPartitionLocked(id2)) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Starting partition or augmented request for view id " + id2 + ": " + viewState.getStateAsString());
            }
            this.requestNewFillResponseLocked(viewState, 32, flags);
        } else if (Helper.sVerbose) {
            Slog.v(TAG, "Not starting new partition for view " + id2 + ": " + viewState.getStateAsString());
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean shouldStartNewPartitionLocked(AutofillId id2) {
        if (this.mResponses == null) {
            return true;
        }
        int numResponses = this.mResponses.size();
        if (numResponses >= AutofillManagerService.getPartitionMaxCount()) {
            Slog.e(TAG, "Not starting a new partition on " + id2 + " because session " + this.id + " reached maximum of " + AutofillManagerService.getPartitionMaxCount());
            return false;
        }
        for (int responseNum = 0; responseNum < numResponses; ++responseNum) {
            FillResponse response = this.mResponses.valueAt(responseNum);
            if (ArrayUtils.contains(response.getIgnoredIds(), id2)) {
                return false;
            }
            SaveInfo saveInfo = response.getSaveInfo();
            if (saveInfo != null && (ArrayUtils.contains(saveInfo.getOptionalIds(), id2) || ArrayUtils.contains(saveInfo.getRequiredIds(), id2))) {
                return false;
            }
            List<Dataset> datasets = response.getDatasets();
            if (datasets != null) {
                int numDatasets = datasets.size();
                for (int dataSetNum = 0; dataSetNum < numDatasets; ++dataSetNum) {
                    ArrayList<AutofillId> fields = datasets.get(dataSetNum).getFieldIds();
                    if (fields == null || !fields.contains(id2)) continue;
                    return false;
                }
            }
            if (!ArrayUtils.contains(response.getAuthenticationIds(), id2)) continue;
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mLock"})
    void updateLocked(AutofillId id2, Rect virtualBounds, AutofillValue value, int action, int flags) {
        ViewState viewState;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#updateLocked() rejected - session: " + id2 + " destroyed");
            return;
        }
        id2.setSessionId(this.id);
        if (Helper.sVerbose) {
            Slog.v(TAG, "updateLocked(" + this.id + "): id=" + id2 + ", action=" + Session.actionAsString(action) + ", flags=" + flags);
        }
        if ((viewState = this.mViewStates.get(id2)) == null) {
            if (action == 1 || action == 4 || action == 2) {
                boolean isIgnored;
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Creating viewState for " + id2);
                }
                viewState = new ViewState(id2, this, (isIgnored = this.isIgnoredLocked(id2)) ? 128 : 1);
                this.mViewStates.put(id2, viewState);
                if (isIgnored) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "updateLocked(): ignoring view " + viewState);
                    }
                    return;
                }
            } else {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Ignoring specific action when viewState=null");
                }
                return;
            }
        }
        switch (action) {
            case 1: {
                this.mCurrentViewId = viewState.id;
                viewState.update(value, virtualBounds, flags);
                this.requestNewFillResponseLocked(viewState, 16, flags);
                break;
            }
            case 4: {
                CharSequence text;
                if (this.mCompatMode && (viewState.getState() & 0x200) != 0) {
                    String currentUrl;
                    String string2 = currentUrl = this.mUrlBar == null ? null : this.mUrlBar.getText().toString().trim();
                    if (currentUrl == null) {
                        this.wtf(null, "URL bar value changed, but current value is null", new Object[0]);
                        return;
                    }
                    if (value == null || !value.isText()) {
                        this.wtf(null, "URL bar value changed to null or non-text: %s", value);
                        return;
                    }
                    String newUrl = value.getTextValue().toString();
                    if (newUrl.equals(currentUrl)) {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "Ignoring change on URL bar as it's the same");
                        }
                        return;
                    }
                    if (this.mSaveOnAllViewsInvisible) {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "Ignoring change on URL because session will finish when views are gone");
                        }
                        return;
                    }
                    if (Helper.sDebug) {
                        Slog.d(TAG, "Finishing session because URL bar changed");
                    }
                    this.forceRemoveSelfLocked(5);
                    return;
                }
                if (Objects.equals(value, viewState.getCurrentValue())) break;
                if ((value == null || value.isEmpty()) && viewState.getCurrentValue() != null && viewState.getCurrentValue().isText() && viewState.getCurrentValue().getTextValue() != null && this.getSaveInfoLocked() != null) {
                    int length = viewState.getCurrentValue().getTextValue().length();
                    if (Helper.sDebug) {
                        Slog.d(TAG, "updateLocked(" + id2 + "): resetting value that was " + length + " chars long");
                    }
                    LogMaker log = this.newLogMaker(1124).addTaggedData(1125, length);
                    this.mMetricsLogger.write(log);
                }
                viewState.setCurrentValue(value);
                AutofillValue filledValue = viewState.getAutofilledValue();
                if (filledValue != null) {
                    if (filledValue.equals(value)) {
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "ignoring autofilled change on id " + id2);
                        }
                        viewState.resetState(8);
                        return;
                    }
                    if (viewState.id.equals(this.mCurrentViewId) && (viewState.getState() & 4) != 0) {
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "field changed after autofill on id " + id2);
                        }
                        viewState.resetState(4);
                        ViewState currentView = this.mViewStates.get(this.mCurrentViewId);
                        currentView.maybeCallOnFillReady(flags);
                    }
                }
                viewState.setState(8);
                String filterText = value == null || !value.isText() ? null : ((text = value.getTextValue()) == null ? null : text.toString());
                this.getUiForShowing().filterFillUi(filterText, this);
                break;
            }
            case 2: {
                if (Helper.sVerbose && virtualBounds != null) {
                    Slog.v(TAG, "entered on virtual child " + id2 + ": " + virtualBounds);
                }
                this.mCurrentViewId = viewState.id;
                viewState.setCurrentValue(value);
                if (this.mCompatMode && (viewState.getState() & 0x200) != 0) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "Ignoring VIEW_ENTERED on URL BAR (id=" + id2 + ")");
                    }
                    return;
                }
                if ((flags & 1) == 0 && this.mAugmentedAutofillableIds != null && this.mAugmentedAutofillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "updateLocked(" + id2 + "): augmented-autofillable");
                    }
                    this.triggerAugmentedAutofillLocked();
                    return;
                }
                this.requestNewFillResponseOnViewEnteredIfNecessaryLocked(id2, viewState, flags);
                if (!Objects.equals(this.mCurrentViewId, viewState.id)) {
                    this.mUi.hideFillUi(this);
                    this.mCurrentViewId = viewState.id;
                    this.hideAugmentedAutofillLocked(viewState);
                }
                viewState.update(value, virtualBounds, flags);
                break;
            }
            case 3: {
                if (!Objects.equals(this.mCurrentViewId, viewState.id)) break;
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Exiting view " + id2);
                }
                this.mUi.hideFillUi(this);
                this.hideAugmentedAutofillLocked(viewState);
                this.mCurrentViewId = null;
                break;
            }
            default: {
                Slog.w(TAG, "updateLocked(): unknown action: " + action);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void hideAugmentedAutofillLocked(ViewState viewState) {
        if ((viewState.getState() & 0x1000) != 0) {
            viewState.resetState(4096);
            this.cancelAugmentedAutofillLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isIgnoredLocked(AutofillId id2) {
        FillResponse response = this.getLastResponseLocked(null);
        if (response == null) {
            return false;
        }
        return ArrayUtils.contains(response.getIgnoredIds(), id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillReady(FillResponse response, AutofillId filledId, AutofillValue value) {
        Drawable serviceIcon;
        CharSequence serviceLabel;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillReady() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        String filterText = null;
        if (value != null && value.isText()) {
            filterText = value.getTextValue().toString();
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            serviceLabel = this.mService.getServiceLabelLocked();
            serviceIcon = this.mService.getServiceIconLocked();
        }
        if (serviceLabel == null || serviceIcon == null) {
            this.wtf(null, "onFillReady(): no service label or icon", new Object[0]);
            return;
        }
        this.getUiForShowing().showFillUi(filledId, response, filterText, this.mService.getServicePackageName(), this.mComponentName, serviceLabel, serviceIcon, this, this.id, this.mCompatMode);
        object2 = this.mLock;
        synchronized (object2) {
            if (this.mUiShownTime == 0L) {
                this.mUiShownTime = SystemClock.elapsedRealtime();
                long duration = this.mUiShownTime - this.mStartTime;
                if (Helper.sDebug) {
                    StringBuilder msg = new StringBuilder("1st UI for ").append(this.mActivityToken).append(" shown in ");
                    TimeUtils.formatDuration(duration, msg);
                    Slog.d(TAG, msg.toString());
                }
                StringBuilder historyLog = new StringBuilder("id=").append(this.id).append(" app=").append(this.mActivityToken).append(" svc=").append(this.mService.getServicePackageName()).append(" latency=");
                TimeUtils.formatDuration(duration, historyLog);
                this.mUiLatencyHistory.log(historyLog.toString());
                this.addTaggedDataToRequestLogLocked(response.getRequestId(), 1145, duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAutoFillManagerClient getClient() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnavailableToClient(int sessionFinishedState, ArrayList<AutofillId> autofillableIds) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentViewId == null) {
                return;
            }
            try {
                if (this.mHasCallback) {
                    this.mClient.notifyNoFillUi(this.id, this.mCurrentViewId, sessionFinishedState);
                } else if (sessionFinishedState != 0) {
                    this.mClient.setSessionFinished(sessionFinishedState, autofillableIds);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error notifying client no fill UI: id=" + this.mCurrentViewId, e);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void updateTrackedIdsLocked() {
        int flags;
        AutofillId saveTriggerId;
        FillResponse response = this.getLastResponseLocked(null);
        if (response == null) {
            return;
        }
        ArraySet trackedViews = null;
        this.mSaveOnAllViewsInvisible = false;
        boolean saveOnFinish = true;
        SaveInfo saveInfo = response.getSaveInfo();
        if (saveInfo != null) {
            saveTriggerId = saveInfo.getTriggerId();
            if (saveTriggerId != null) {
                this.writeLog(1228);
            }
            boolean bl = this.mSaveOnAllViewsInvisible = ((flags = saveInfo.getFlags()) & 1) != 0;
            if (this.mSaveOnAllViewsInvisible) {
                if (trackedViews == null) {
                    trackedViews = new ArraySet();
                }
                if (saveInfo.getRequiredIds() != null) {
                    Collections.addAll(trackedViews, saveInfo.getRequiredIds());
                }
                if (saveInfo.getOptionalIds() != null) {
                    Collections.addAll(trackedViews, saveInfo.getOptionalIds());
                }
            }
            if ((flags & 2) != 0) {
                saveOnFinish = false;
            }
        } else {
            flags = 0;
            saveTriggerId = null;
        }
        List<Dataset> datasets = response.getDatasets();
        ArraySet<AutofillId> fillableIds = null;
        if (datasets != null) {
            for (int i = 0; i < datasets.size(); ++i) {
                Dataset dataset = datasets.get(i);
                ArrayList<AutofillId> fieldIds = dataset.getFieldIds();
                if (fieldIds == null) continue;
                for (int j = 0; j < fieldIds.size(); ++j) {
                    AutofillId id2 = fieldIds.get(j);
                    if (trackedViews != null && trackedViews.contains(id2)) continue;
                    fillableIds = ArrayUtils.add(fillableIds, id2);
                }
            }
        }
        try {
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateTrackedIdsLocked(): " + trackedViews + " => " + fillableIds + " triggerId: " + saveTriggerId + " saveOnFinish:" + saveOnFinish + " flags: " + flags + " hasSaveInfo: " + (saveInfo != null));
            }
            this.mClient.setTrackedViews(this.id, Helper.toArray(trackedViews), this.mSaveOnAllViewsInvisible, saveOnFinish, Helper.toArray(fillableIds), saveTriggerId);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Cannot set tracked ids", e);
        }
    }

    @GuardedBy(value={"mLock"})
    void setAutofillFailureLocked(List<AutofillId> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            AutofillId id2 = ids.get(i);
            ViewState viewState = this.mViewStates.get(id2);
            if (viewState == null) {
                Slog.w(TAG, "setAutofillFailure(): no view for id " + id2);
                continue;
            }
            viewState.resetState(4);
            int state = viewState.getState();
            viewState.setState(state | 0x400);
            if (!Helper.sVerbose) continue;
            Slog.v(TAG, "Changed state of " + id2 + " to " + viewState.getStateAsString());
        }
    }

    @GuardedBy(value={"mLock"})
    private void replaceResponseLocked(FillResponse oldResponse, FillResponse newResponse, Bundle newClientState) {
        this.setViewStatesLocked(oldResponse, 1, true);
        newResponse.setRequestId(oldResponse.getRequestId());
        this.mResponses.put(newResponse.getRequestId(), newResponse);
        this.processResponseLocked(newResponse, newClientState, 0);
    }

    @GuardedBy(value={"mLock"})
    private void processNullResponseLocked(int requestId, int flags) {
        ArrayList<AutofillId> autofillableIds;
        FillContext context;
        if ((flags & 1) != 0) {
            this.getUiForShowing().showError(17039545, (AutoFillUI.AutoFillUiCallback)this);
        }
        if ((context = this.getFillContextByRequestIdLocked(requestId)) != null) {
            AssistStructure structure = context.getStructure();
            autofillableIds = Helper.getAutofillIds(structure, true);
        } else {
            Slog.w(TAG, "processNullResponseLocked(): no context for req " + requestId);
            autofillableIds = null;
        }
        this.mService.resetLastResponse();
        this.mAugmentedAutofillDestroyer = this.triggerAugmentedAutofillLocked();
        if (this.mAugmentedAutofillDestroyer == null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "canceling session " + this.id + " when service returned null and it cannot be augmented. AutofillableIds: " + autofillableIds);
            }
            this.notifyUnavailableToClient(2, autofillableIds);
            this.removeSelf();
        } else {
            if (Helper.sVerbose) {
                Slog.v(TAG, "keeping session " + this.id + " when service returned null but it can be augmented. AutofillableIds: " + autofillableIds);
            }
            this.mAugmentedAutofillableIds = autofillableIds;
            try {
                this.mClient.setState(32);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error setting client to autofill-only", e);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private Runnable triggerAugmentedAutofillLocked() {
        int supportedModes = this.mService.getSupportedSmartSuggestionModesLocked();
        if (supportedModes == 0) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "triggerAugmentedAutofillLocked(): no supported modes");
            }
            return null;
        }
        RemoteAugmentedAutofillService remoteService = this.mService.getRemoteAugmentedAutofillServiceLocked();
        if (remoteService == null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "triggerAugmentedAutofillLocked(): no service for user");
            }
            return null;
        }
        if ((supportedModes & 1) == 0) {
            Slog.w(TAG, "Unsupported Smart Suggestion mode: " + supportedModes);
            return null;
        }
        int mode = 1;
        if (this.mCurrentViewId == null) {
            Slog.w(TAG, "triggerAugmentedAutofillLocked(): no view currently focused");
            return null;
        }
        boolean isWhitelisted = this.mService.isWhitelistedForAugmentedAutofillLocked(this.mComponentName);
        String historyItem = "aug:id=" + this.id + " u=" + this.uid + " m=" + mode + " a=" + ComponentName.flattenToShortString(this.mComponentName) + " f=" + this.mCurrentViewId + " s=" + remoteService.getComponentName() + " w=" + isWhitelisted;
        ((AutofillManagerService)this.mService.getMaster()).logRequestLocked(historyItem);
        if (!isWhitelisted) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "triggerAugmentedAutofillLocked(): " + ComponentName.flattenToShortString(this.mComponentName) + " not whitelisted ");
            }
            return null;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "calling Augmented Autofill Service (" + ComponentName.flattenToShortString(remoteService.getComponentName()) + ") on view " + this.mCurrentViewId + " using suggestion mode " + AutofillManager.getSmartSuggestionModeToString(mode) + " when server returned null for session " + this.id);
        }
        ViewState viewState = this.mViewStates.get(this.mCurrentViewId);
        viewState.setState(4096);
        AutofillValue currentValue = viewState.getCurrentValue();
        if (this.mAugmentedRequestsLogs == null) {
            this.mAugmentedRequestsLogs = new ArrayList();
        }
        LogMaker log = this.newLogMaker(1630, remoteService.getComponentName().getPackageName());
        this.mAugmentedRequestsLogs.add(log);
        AutofillId focusedId = AutofillId.withoutSession(this.mCurrentViewId);
        remoteService.onRequestAutofillLocked(this.id, this.mClient, this.taskId, this.mComponentName, focusedId, currentValue);
        if (this.mAugmentedAutofillDestroyer == null) {
            this.mAugmentedAutofillDestroyer = () -> remoteService.onDestroyAutofillWindowsRequest();
        }
        return this.mAugmentedAutofillDestroyer;
    }

    @GuardedBy(value={"mLock"})
    private void cancelAugmentedAutofillLocked() {
        RemoteAugmentedAutofillService remoteService = this.mService.getRemoteAugmentedAutofillServiceLocked();
        if (remoteService == null) {
            Slog.w(TAG, "cancelAugmentedAutofillLocked(): no service for user");
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "cancelAugmentedAutofillLocked() on " + this.mCurrentViewId);
        }
        remoteService.onDestroyAutofillWindowsRequest();
    }

    @GuardedBy(value={"mLock"})
    private void processResponseLocked(FillResponse newResponse, Bundle newClientState, int flags) {
        this.mUi.hideAll(this);
        int requestId = newResponse.getRequestId();
        if (Helper.sVerbose) {
            Slog.v(TAG, "processResponseLocked(): mCurrentViewId=" + this.mCurrentViewId + ",flags=" + flags + ", reqId=" + requestId + ", resp=" + newResponse + ",newClientState=" + newClientState);
        }
        if (this.mResponses == null) {
            this.mResponses = new SparseArray(2);
        }
        this.mResponses.put(requestId, newResponse);
        this.mClientState = newClientState != null ? newClientState : newResponse.getClientState();
        this.setViewStatesLocked(newResponse, 2, false);
        this.updateTrackedIdsLocked();
        if (this.mCurrentViewId == null) {
            return;
        }
        ViewState currentView = this.mViewStates.get(this.mCurrentViewId);
        currentView.maybeCallOnFillReady(flags);
    }

    @GuardedBy(value={"mLock"})
    private void setViewStatesLocked(FillResponse response, int state, boolean clearResponse) {
        AutofillId[] authIds;
        SaveInfo saveInfo;
        List<Dataset> datasets = response.getDatasets();
        if (datasets != null) {
            for (int i = 0; i < datasets.size(); ++i) {
                Dataset dataset = datasets.get(i);
                if (dataset == null) {
                    Slog.w(TAG, "Ignoring null dataset on " + datasets);
                    continue;
                }
                this.setViewStatesLocked(response, dataset, state, clearResponse);
            }
        } else if (response.getAuthentication() != null) {
            for (AutofillId autofillId : response.getAuthenticationIds()) {
                ViewState viewState = this.createOrUpdateViewStateLocked(autofillId, state, null);
                if (!clearResponse) {
                    viewState.setResponse(response);
                    continue;
                }
                viewState.setResponse(null);
            }
        }
        if ((saveInfo = response.getSaveInfo()) != null) {
            AutofillId[] optionalIds;
            AutofillId[] requiredIds = saveInfo.getRequiredIds();
            if (requiredIds != null) {
                for (AutofillId id2 : requiredIds) {
                    this.createOrUpdateViewStateLocked(id2, state, null);
                }
            }
            if ((optionalIds = saveInfo.getOptionalIds()) != null) {
                for (AutofillId id3 : optionalIds) {
                    this.createOrUpdateViewStateLocked(id3, state, null);
                }
            }
        }
        if ((authIds = response.getAuthenticationIds()) != null) {
            for (AutofillId id4 : authIds) {
                this.createOrUpdateViewStateLocked(id4, state, null);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void setViewStatesLocked(FillResponse response, Dataset dataset, int state, boolean clearResponse) {
        ArrayList<AutofillId> ids = dataset.getFieldIds();
        ArrayList<AutofillValue> values = dataset.getFieldValues();
        for (int j = 0; j < ids.size(); ++j) {
            AutofillId id2 = ids.get(j);
            AutofillValue value = values.get(j);
            ViewState viewState = this.createOrUpdateViewStateLocked(id2, state, value);
            String datasetId = dataset.getId();
            if (datasetId != null) {
                viewState.setDatasetId(datasetId);
            }
            if (response != null) {
                viewState.setResponse(response);
                continue;
            }
            if (!clearResponse) continue;
            viewState.setResponse(null);
        }
    }

    @GuardedBy(value={"mLock"})
    private ViewState createOrUpdateViewStateLocked(AutofillId id2, int state, AutofillValue value) {
        ViewState viewState = this.mViewStates.get(id2);
        if (viewState != null) {
            viewState.setState(state);
        } else {
            viewState = new ViewState(id2, this, state);
            if (Helper.sVerbose) {
                Slog.v(TAG, "Adding autofillable view with id " + id2 + " and state " + state);
            }
            viewState.setCurrentValue(this.findValueLocked(id2));
            this.mViewStates.put(id2, viewState);
        }
        if ((state & 4) != 0) {
            viewState.setAutofilledValue(value);
        }
        return viewState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFill(int requestId, int datasetIndex, Dataset dataset, boolean generateEvent) {
        if (Helper.sDebug) {
            Slog.d(TAG, "autoFill(): requestId=" + requestId + "; datasetIdx=" + datasetIndex + "; dataset=" + dataset);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#autoFill() rejected - session: " + this.id + " destroyed");
                return;
            }
            if (dataset.getAuthentication() == null) {
                if (generateEvent) {
                    this.mService.logDatasetSelected(dataset.getId(), this.id, this.mClientState);
                }
                this.autoFillApp(dataset);
                return;
            }
            this.mService.logDatasetAuthenticationSelected(dataset.getId(), this.id, this.mClientState);
            this.setViewStatesLocked(null, dataset, 64, false);
            Intent fillInIntent = this.createAuthFillInIntentLocked(requestId, this.mClientState);
            if (fillInIntent == null) {
                this.forceRemoveSelfLocked();
                return;
            }
            int authenticationId = AutofillManager.makeAuthenticationId(requestId, datasetIndex);
            this.startAuthentication(authenticationId, dataset.getAuthentication(), fillInIntent);
        }
    }

    @GuardedBy(value={"mLock"})
    private Intent createAuthFillInIntentLocked(int requestId, Bundle extras) {
        Intent fillInIntent = new Intent();
        FillContext context = this.getFillContextByRequestIdLocked(requestId);
        if (context == null) {
            this.wtf(null, "createAuthFillInIntentLocked(): no FillContext. requestId=%d; mContexts=%s", requestId, this.mContexts);
            return null;
        }
        fillInIntent.putExtra("android.view.autofill.extra.ASSIST_STRUCTURE", context.getStructure());
        fillInIntent.putExtra("android.view.autofill.extra.CLIENT_STATE", extras);
        return fillInIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAuthentication(int authenticationId, IntentSender intent, Intent fillInIntent) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mClient.authenticate(this.id, authenticationId, intent, fillInIntent);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error launching auth intent", e);
        }
    }

    public String toString() {
        return "Session: [id=" + this.id + ", component=" + this.mComponentName + "]";
    }

    @GuardedBy(value={"mLock"})
    void dumpLocked(String prefix, PrintWriter pw) {
        int i;
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("id: ");
        pw.println(this.id);
        pw.print(prefix);
        pw.print("uid: ");
        pw.println(this.uid);
        pw.print(prefix);
        pw.print("taskId: ");
        pw.println(this.taskId);
        pw.print(prefix);
        pw.print("flags: ");
        pw.println(this.mFlags);
        pw.print(prefix);
        pw.print("mComponentName: ");
        pw.println(this.mComponentName);
        pw.print(prefix);
        pw.print("mActivityToken: ");
        pw.println(this.mActivityToken);
        pw.print(prefix);
        pw.print("mStartTime: ");
        pw.println(this.mStartTime);
        pw.print(prefix);
        pw.print("Time to show UI: ");
        if (this.mUiShownTime == 0L) {
            pw.println("N/A");
        } else {
            TimeUtils.formatDuration(this.mUiShownTime - this.mStartTime, pw);
            pw.println();
        }
        int requestLogsSizes = this.mRequestLogs.size();
        pw.print(prefix);
        pw.print("mSessionLogs: ");
        pw.println(requestLogsSizes);
        for (i = 0; i < requestLogsSizes; ++i) {
            int requestId = this.mRequestLogs.keyAt(i);
            LogMaker log = this.mRequestLogs.valueAt(i);
            pw.print(prefix2);
            pw.print('#');
            pw.print(i);
            pw.print(": req=");
            pw.print(requestId);
            pw.print(", log=");
            Session.dumpRequestLog(pw, log);
            pw.println();
        }
        pw.print(prefix);
        pw.print("mResponses: ");
        if (this.mResponses == null) {
            pw.println("null");
        } else {
            pw.println(this.mResponses.size());
            for (i = 0; i < this.mResponses.size(); ++i) {
                pw.print(prefix2);
                pw.print('#');
                pw.print(i);
                pw.print(' ');
                pw.println(this.mResponses.valueAt(i));
            }
        }
        pw.print(prefix);
        pw.print("mCurrentViewId: ");
        pw.println(this.mCurrentViewId);
        pw.print(prefix);
        pw.print("mDestroyed: ");
        pw.println(this.mDestroyed);
        pw.print(prefix);
        pw.print("mIsSaving: ");
        pw.println(this.mIsSaving);
        pw.print(prefix);
        pw.print("mPendingSaveUi: ");
        pw.println(this.mPendingSaveUi);
        int numberViews = this.mViewStates.size();
        pw.print(prefix);
        pw.print("mViewStates size: ");
        pw.println(this.mViewStates.size());
        for (int i2 = 0; i2 < numberViews; ++i2) {
            pw.print(prefix);
            pw.print("ViewState at #");
            pw.println(i2);
            this.mViewStates.valueAt(i2).dump(prefix2, pw);
        }
        pw.print(prefix);
        pw.print("mContexts: ");
        if (this.mContexts != null) {
            int numContexts = this.mContexts.size();
            for (int i3 = 0; i3 < numContexts; ++i3) {
                FillContext context = this.mContexts.get(i3);
                pw.print(prefix2);
                pw.print(context);
                if (!Helper.sVerbose) continue;
                pw.println("AssistStructure dumped at logcat)");
                context.getStructure().dump(false);
            }
        } else {
            pw.println("null");
        }
        pw.print(prefix);
        pw.print("mHasCallback: ");
        pw.println(this.mHasCallback);
        if (this.mClientState != null) {
            pw.print(prefix);
            pw.print("mClientState: ");
            pw.print(this.mClientState.getSize());
            pw.println(" bytes");
        }
        pw.print(prefix);
        pw.print("mCompatMode: ");
        pw.println(this.mCompatMode);
        pw.print(prefix);
        pw.print("mUrlBar: ");
        if (this.mUrlBar == null) {
            pw.println("N/A");
        } else {
            pw.print("id=");
            pw.print(this.mUrlBar.getAutofillId());
            pw.print(" domain=");
            pw.print(this.mUrlBar.getWebDomain());
            pw.print(" text=");
            Helper.printlnRedactedText(pw, this.mUrlBar.getText());
        }
        pw.print(prefix);
        pw.print("mSaveOnAllViewsInvisible: ");
        pw.println(this.mSaveOnAllViewsInvisible);
        pw.print(prefix);
        pw.print("mSelectedDatasetIds: ");
        pw.println(this.mSelectedDatasetIds);
        if (this.mForAugmentedAutofillOnly) {
            pw.print(prefix);
            pw.println("For Augmented Autofill Only");
        }
        if (this.mAugmentedAutofillDestroyer != null) {
            pw.print(prefix);
            pw.println("has mAugmentedAutofillDestroyer");
        }
        if (this.mAugmentedRequestsLogs != null) {
            pw.print(prefix);
            pw.print("number augmented requests: ");
            pw.println(this.mAugmentedRequestsLogs.size());
        }
        if (this.mAugmentedAutofillableIds != null) {
            pw.print(prefix);
            pw.print("mAugmentedAutofillableIds: ");
            pw.println(this.mAugmentedAutofillableIds);
        }
        if (this.mRemoteFillService != null) {
            this.mRemoteFillService.dump(prefix, pw);
        }
    }

    private static void dumpRequestLog(PrintWriter pw, LogMaker log) {
        pw.print("CAT=");
        pw.print(log.getCategory());
        pw.print(", TYPE=");
        int type = log.getType();
        switch (type) {
            case 10: {
                pw.print("SUCCESS");
                break;
            }
            case 11: {
                pw.print("FAILURE");
                break;
            }
            case 2: {
                pw.print("CLOSE");
                break;
            }
            default: {
                pw.print("UNSUPPORTED");
            }
        }
        pw.print('(');
        pw.print(type);
        pw.print(')');
        pw.print(", PKG=");
        pw.print(log.getPackageName());
        pw.print(", SERVICE=");
        pw.print(log.getTaggedData(908));
        pw.print(", ORDINAL=");
        pw.print(log.getTaggedData(1454));
        Session.dumpNumericValue(pw, log, "FLAGS", 1452);
        Session.dumpNumericValue(pw, log, "NUM_DATASETS", 909);
        Session.dumpNumericValue(pw, log, "UI_LATENCY", 1145);
        int authStatus = Helper.getNumericValue(log, 1453);
        if (authStatus != 0) {
            pw.print(", AUTH_STATUS=");
            switch (authStatus) {
                case 912: {
                    pw.print("AUTHENTICATED");
                    break;
                }
                case 1126: {
                    pw.print("DATASET_AUTHENTICATED");
                    break;
                }
                case 1128: {
                    pw.print("INVALID_AUTHENTICATION");
                    break;
                }
                case 1127: {
                    pw.print("INVALID_DATASET_AUTHENTICATION");
                    break;
                }
                default: {
                    pw.print("UNSUPPORTED");
                }
            }
            pw.print('(');
            pw.print(authStatus);
            pw.print(')');
        }
        Session.dumpNumericValue(pw, log, "FC_IDS", 1271);
        Session.dumpNumericValue(pw, log, "COMPAT_MODE", 1414);
    }

    private static void dumpNumericValue(PrintWriter pw, LogMaker log, String field, int tag) {
        int value = Helper.getNumericValue(log, tag);
        if (value != 0) {
            pw.print(", ");
            pw.print(field);
            pw.print('=');
            pw.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFillApp(Dataset dataset) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#autoFillApp() rejected - session: " + this.id + " destroyed");
                return;
            }
            try {
                int entryCount = dataset.getFieldIds().size();
                ArrayList<AutofillId> ids = new ArrayList<AutofillId>(entryCount);
                ArrayList<AutofillValue> values = new ArrayList<AutofillValue>(entryCount);
                boolean waitingDatasetAuth = false;
                for (int i = 0; i < entryCount; ++i) {
                    if (dataset.getFieldValues().get(i) == null) continue;
                    AutofillId viewId = dataset.getFieldIds().get(i);
                    ids.add(viewId);
                    values.add(dataset.getFieldValues().get(i));
                    ViewState viewState = this.mViewStates.get(viewId);
                    if (viewState == null || (viewState.getState() & 0x40) == 0) continue;
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "autofillApp(): view " + viewId + " waiting auth");
                    }
                    waitingDatasetAuth = true;
                    viewState.resetState(64);
                }
                if (!ids.isEmpty()) {
                    if (waitingDatasetAuth) {
                        this.mUi.hideFillUi(this);
                    }
                    if (Helper.sDebug) {
                        Slog.d(TAG, "autoFillApp(): the buck is on the app: " + dataset);
                    }
                    this.mClient.autofill(this.id, ids, values);
                    if (dataset.getId() != null) {
                        if (this.mSelectedDatasetIds == null) {
                            this.mSelectedDatasetIds = new ArrayList();
                        }
                        this.mSelectedDatasetIds.add(dataset.getId());
                    }
                    this.setViewStatesLocked(null, dataset, 4, false);
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Error autofilling activity: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutoFillUI getUiForShowing() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUi.setCallback(this);
            return this.mUi;
        }
    }

    @GuardedBy(value={"mLock"})
    RemoteFillService destroyLocked() {
        int totalAugmentedRequests;
        if (this.mDestroyed) {
            return null;
        }
        this.unlinkClientVultureLocked();
        this.mUi.destroyAll(this.mPendingSaveUi, this, true);
        this.mUi.clearCallback(this);
        this.mDestroyed = true;
        int totalRequests = this.mRequestLogs.size();
        if (totalRequests > 0) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "destroyLocked(): logging " + totalRequests + " requests");
            }
            for (int i = 0; i < totalRequests; ++i) {
                LogMaker log = this.mRequestLogs.valueAt(i);
                this.mMetricsLogger.write(log);
            }
        }
        int n = totalAugmentedRequests = this.mAugmentedRequestsLogs == null ? 0 : this.mAugmentedRequestsLogs.size();
        if (totalAugmentedRequests > 0) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "destroyLocked(): logging " + totalRequests + " augmented requests");
            }
            for (int i = 0; i < totalAugmentedRequests; ++i) {
                LogMaker log = this.mAugmentedRequestsLogs.get(i);
                this.mMetricsLogger.write(log);
            }
        }
        LogMaker log = this.newLogMaker(919).addTaggedData(1455, totalRequests);
        if (totalAugmentedRequests > 0) {
            log.addTaggedData(1631, totalAugmentedRequests);
        }
        if (this.mForAugmentedAutofillOnly) {
            log.addTaggedData(1720, 1);
        }
        this.mMetricsLogger.write(log);
        return this.mRemoteFillService;
    }

    @GuardedBy(value={"mLock"})
    void forceRemoveSelfLocked() {
        this.forceRemoveSelfLocked(0);
    }

    @GuardedBy(value={"mLock"})
    void forceRemoveSelfIfForAugmentedAutofillOnlyLocked() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "forceRemoveSelfIfForAugmentedAutofillOnly(" + this.id + "): " + this.mForAugmentedAutofillOnly);
        }
        if (!this.mForAugmentedAutofillOnly) {
            return;
        }
        this.forceRemoveSelfLocked();
    }

    @GuardedBy(value={"mLock"})
    void forceRemoveSelfLocked(int clientState) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "forceRemoveSelfLocked(): " + this.mPendingSaveUi);
        }
        boolean isPendingSaveUi = this.isSaveUiPendingLocked();
        this.mPendingSaveUi = null;
        this.removeSelfLocked();
        this.mUi.destroyAll(this.mPendingSaveUi, this, false);
        if (!isPendingSaveUi) {
            try {
                this.mClient.setSessionFinished(clientState, null);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error notifying client to finish session", e);
            }
        }
        this.destroyAugmentedAutofillWindowsLocked();
    }

    @GuardedBy(value={"mLock"})
    void destroyAugmentedAutofillWindowsLocked() {
        if (this.mAugmentedAutofillDestroyer != null) {
            this.mAugmentedAutofillDestroyer.run();
            this.mAugmentedAutofillDestroyer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelf() {
        Object object = this.mLock;
        synchronized (object) {
            this.removeSelfLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void removeSelfLocked() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "removeSelfLocked(" + this.id + "): " + this.mPendingSaveUi);
        }
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#removeSelfLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (this.isSaveUiPendingLocked()) {
            Slog.i(TAG, "removeSelfLocked() ignored, waiting for pending save ui");
            return;
        }
        RemoteFillService remoteFillService = this.destroyLocked();
        this.mService.removeSessionLocked(this.id);
        if (remoteFillService != null) {
            remoteFillService.destroy();
        }
    }

    void onPendingSaveUi(int operation, IBinder token) {
        this.getUiForShowing().onPendingSaveUi(operation, token);
    }

    @GuardedBy(value={"mLock"})
    boolean isSaveUiPendingForTokenLocked(IBinder token) {
        return this.isSaveUiPendingLocked() && token.equals(this.mPendingSaveUi.getToken());
    }

    @GuardedBy(value={"mLock"})
    private boolean isSaveUiPendingLocked() {
        return this.mPendingSaveUi != null && this.mPendingSaveUi.getState() == 2;
    }

    @GuardedBy(value={"mLock"})
    private int getLastResponseIndexLocked() {
        int lastResponseIdx = -1;
        int lastResponseId = -1;
        if (this.mResponses != null) {
            int responseCount = this.mResponses.size();
            for (int i = 0; i < responseCount; ++i) {
                if (this.mResponses.keyAt(i) <= lastResponseId) continue;
                lastResponseIdx = i;
            }
        }
        return lastResponseIdx;
    }

    private LogMaker newLogMaker(int category) {
        return this.newLogMaker(category, this.mService.getServicePackageName());
    }

    private LogMaker newLogMaker(int category, String servicePackageName) {
        return Helper.newLogMaker(category, this.mComponentName, servicePackageName, this.id, this.mCompatMode);
    }

    private void writeLog(int category) {
        this.mMetricsLogger.write(this.newLogMaker(category));
    }

    @GuardedBy(value={"mLock"})
    private void logAuthenticationStatusLocked(int requestId, int status) {
        this.addTaggedDataToRequestLogLocked(requestId, 1453, status);
    }

    @GuardedBy(value={"mLock"})
    private void addTaggedDataToRequestLogLocked(int requestId, int tag, Object value) {
        LogMaker requestLog = this.mRequestLogs.get(requestId);
        if (requestLog == null) {
            Slog.w(TAG, "addTaggedDataToRequestLogLocked(tag=" + tag + "): no log for id " + requestId);
            return;
        }
        requestLog.addTaggedData(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wtf(Exception e, String fmt, Object ... args) {
        String message = String.format(fmt, args);
        Object object = this.mLock;
        synchronized (object) {
            this.mWtfHistory.log(message);
        }
        if (e != null) {
            Slog.wtf(TAG, message, e);
        } else {
            Slog.wtf(TAG, message);
        }
    }

    private static String actionAsString(int action) {
        switch (action) {
            case 1: {
                return "START_SESSION";
            }
            case 2: {
                return "VIEW_ENTERED";
            }
            case 3: {
                return "VIEW_EXITED";
            }
            case 4: {
                return "VALUE_CHANGED";
            }
        }
        return "UNKNOWN_" + action;
    }
}

