/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.graphics.Rect;
import android.service.autofill.FillResponse;
import android.util.DebugUtils;
import android.util.Slog;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import com.android.server.autofill.Helper;
import java.io.PrintWriter;

final class ViewState {
    private static final String TAG = "ViewState";
    public static final int STATE_INITIAL = 1;
    public static final int STATE_FILLABLE = 2;
    public static final int STATE_AUTOFILLED = 4;
    public static final int STATE_CHANGED = 8;
    public static final int STATE_STARTED_SESSION = 16;
    public static final int STATE_STARTED_PARTITION = 32;
    public static final int STATE_WAITING_DATASET_AUTH = 64;
    public static final int STATE_IGNORED = 128;
    public static final int STATE_RESTARTED_SESSION = 256;
    public static final int STATE_URL_BAR = 512;
    public static final int STATE_AUTOFILL_FAILED = 1024;
    public static final int STATE_AUTOFILLED_ONCE = 2048;
    public static final int STATE_TRIGGERED_AUGMENTED_AUTOFILL = 4096;
    public final AutofillId id;
    private final Listener mListener;
    private FillResponse mResponse;
    private AutofillValue mCurrentValue;
    private AutofillValue mAutofilledValue;
    private AutofillValue mSanitizedValue;
    private Rect mVirtualBounds;
    private int mState;
    private String mDatasetId;

    ViewState(AutofillId id2, Listener listener, int state) {
        this.id = id2;
        this.mListener = listener;
        this.mState = state;
    }

    Rect getVirtualBounds() {
        return this.mVirtualBounds;
    }

    AutofillValue getCurrentValue() {
        return this.mCurrentValue;
    }

    void setCurrentValue(AutofillValue value) {
        this.mCurrentValue = value;
    }

    AutofillValue getAutofilledValue() {
        return this.mAutofilledValue;
    }

    void setAutofilledValue(AutofillValue value) {
        this.mAutofilledValue = value;
    }

    AutofillValue getSanitizedValue() {
        return this.mSanitizedValue;
    }

    void setSanitizedValue(AutofillValue value) {
        this.mSanitizedValue = value;
    }

    FillResponse getResponse() {
        return this.mResponse;
    }

    void setResponse(FillResponse response) {
        this.mResponse = response;
    }

    int getState() {
        return this.mState;
    }

    String getStateAsString() {
        return ViewState.getStateAsString(this.mState);
    }

    static String getStateAsString(int state) {
        return DebugUtils.flagsToString(ViewState.class, "STATE_", state);
    }

    void setState(int state) {
        this.mState = this.mState == 1 ? state : (this.mState |= state);
        if (state == 4) {
            this.mState |= 0x800;
        }
    }

    void resetState(int state) {
        this.mState &= ~state;
    }

    String getDatasetId() {
        return this.mDatasetId;
    }

    void setDatasetId(String datasetId) {
        this.mDatasetId = datasetId;
    }

    void update(AutofillValue autofillValue, Rect virtualBounds, int flags) {
        if (autofillValue != null) {
            this.mCurrentValue = autofillValue;
        }
        if (virtualBounds != null) {
            this.mVirtualBounds = virtualBounds;
        }
        this.maybeCallOnFillReady(flags);
    }

    void maybeCallOnFillReady(int flags) {
        if ((this.mState & 4) != 0 && (flags & 1) == 0) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Ignoring UI for " + this.id + " on " + this.getStateAsString());
            }
            return;
        }
        if (this.mResponse != null && (this.mResponse.getDatasets() != null || this.mResponse.getAuthentication() != null)) {
            this.mListener.onFillReady(this.mResponse, this.id, this.mCurrentValue);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewState: [id=").append(this.id);
        if (this.mDatasetId != null) {
            builder.append(", datasetId:").append(this.mDatasetId);
        }
        builder.append(", state:").append(this.getStateAsString());
        if (this.mCurrentValue != null) {
            builder.append(", currentValue:").append(this.mCurrentValue);
        }
        if (this.mAutofilledValue != null) {
            builder.append(", autofilledValue:").append(this.mAutofilledValue);
        }
        if (this.mSanitizedValue != null) {
            builder.append(", sanitizedValue:").append(this.mSanitizedValue);
        }
        if (this.mVirtualBounds != null) {
            builder.append(", virtualBounds:").append(this.mVirtualBounds);
        }
        builder.append("]");
        return builder.toString();
    }

    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("id:");
        pw.println(this.id);
        if (this.mDatasetId != null) {
            pw.print(prefix);
            pw.print("datasetId:");
            pw.println(this.mDatasetId);
        }
        pw.print(prefix);
        pw.print("state:");
        pw.println(this.getStateAsString());
        if (this.mResponse != null) {
            pw.print(prefix);
            pw.print("response id:");
            pw.println(this.mResponse.getRequestId());
        }
        if (this.mCurrentValue != null) {
            pw.print(prefix);
            pw.print("currentValue:");
            pw.println(this.mCurrentValue);
        }
        if (this.mAutofilledValue != null) {
            pw.print(prefix);
            pw.print("autofilledValue:");
            pw.println(this.mAutofilledValue);
        }
        if (this.mSanitizedValue != null) {
            pw.print(prefix);
            pw.print("sanitizedValue:");
            pw.println(this.mSanitizedValue);
        }
        if (this.mVirtualBounds != null) {
            pw.print(prefix);
            pw.print("virtualBounds:");
            pw.println(this.mVirtualBounds);
        }
    }

    static interface Listener {
        public void onFillReady(FillResponse var1, AutofillId var2, AutofillValue var3);
    }
}

