/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.TypedValue;
import android.view.View;
import android.widget.ScrollView;
import com.android.server.autofill.Helper;

public class CustomScrollView
extends ScrollView {
    private static final String TAG = "CustomScrollView";
    private int mWidth = -1;
    private int mHeight = -1;

    public CustomScrollView(Context context) {
        super(context);
    }

    public CustomScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CustomScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 0) {
            Slog.e(TAG, "no children");
            return;
        }
        this.calculateDimensions();
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    private void calculateDimensions() {
        if (this.mWidth != -1) {
            return;
        }
        TypedValue typedValue = new TypedValue();
        Point point = new Point();
        Context context = this.getContext();
        context.getDisplay().getSize(point);
        context.getTheme().resolveAttribute(17956884, typedValue, true);
        View child = this.getChildAt(0);
        int childHeight = child.getMeasuredHeight();
        int maxHeight = (int)typedValue.getFraction(point.y, point.y);
        this.mWidth = point.x;
        this.mHeight = Math.min(childHeight, maxHeight);
        if (Helper.sDebug) {
            Slog.d(TAG, "calculateDimensions(): maxHeight=" + maxHeight + ", childHeight=" + childHeight + ", w=" + this.mWidth + ", h=" + this.mHeight);
        }
    }
}

